<?php
QUnit_Global::includeClass('Affiliate_Merchants_Views_Settings');

class Affiliate_Merchants_Views_Trackcookies extends Affiliate_Merchants_Views_Settings {
    function Affiliate_Merchants_Views_Trackcookies() {
		$this->blAffiliate =& QUnit_Global::newObj('Affiliate_Merchants_Bl_Affiliate');
        $this->blPayoutOpts =& QUnit_Global::newObj('Affiliate_Merchants_Bl_PayoutOptions');

        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_SETTINGS,'javascript:;');
		$this->navigationAddURL(L_G_COOKIESANDTRACKING,'index.php?md=Affiliate_Merchants_Views_Trackcookies');

		// create all tabs
        $this->tabs['langandcur'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabLangsCurrencies');
		$this->tabs['langandcur']->setAttributes('langandcur', L_G_LANGANDCUR, 'settings_langandcur', 'img_langandcur.gif');
        $this->tabs['langandcur']->hideThis();

		if (GLOBAL_DB_ENABLED != 1) {
		    $this->tabs['urlanddir'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabUrlsDirs');
		    $this->tabs['urlanddir']->setAttributes('urlanddir', L_G_URLSANDDIRS, 'settings_urlanddir', 'icon_urlanddir.gif');
		    $this->tabs['urlanddir']->hideThis();
        }

		$this->tabs['emailnotifications'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabEmailNotifications');
        $this->tabs['emailnotifications']->setAttributes('emailnotifications', L_G_EMAILNOTIFICATIONS, 'settings_emailnotifications', 'icon_emailnotifications.gif');
        $this->tabs['emailnotifications']->hideThis();

        $this->tabs['commissions'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabComissions');
        $this->tabs['commissions']->setAttributes('commissions' , L_G_COMMISSIONS, 'settings_commissions', 'icon_commissions.gif');
        $this->tabs['commissions']->hideThis();

        $this->tabs['communications'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabCommunications');
        $this->tabs['communications']->setAttributes('communications', L_G_COMMUNICATION1, 'settings_communications', 'icon_communications.gif');
        $this->tabs['communications']->hideThis();

        $this->tabs['troubleshooting'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabTroubleshooting');
        $this->tabs['troubleshooting']->setAttributes('troubleshooting', L_G_TROUBLESHOOTING, 'settings_troubleshooting', 'icon_troubleshooting.gif');
        $this->tabs['troubleshooting']->hideThis();

        $this->tabs['fraudprotection'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabFraudProtection');
        $this->tabs['fraudprotection']->setAttributes('fraudprotection', L_G_FRAUDPROTECTION, 'settings_fraudprotection', 'icon_fraudprotection.gif');
        $this->tabs['fraudprotection']->hideThis();

        $this->tabs['affsettings'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabAffSettings');
        $this->tabs['affsettings']->setAttributes('affsettings', L_G_EDITCUSTOMIZATION, 'settings_affsettings', 'icon_affsettings.gif');
        $this->tabs['affsettings']->hideThis();

        $this->tabs['cookiestracking'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabCookiesTracking');
        $this->tabs['cookiestracking']->setAttributes('cookiestracking', L_G_COOKIESANDTRACKING, 'settings_cookiestracking', 'icon_cookiestracking.gif');
        //$this->tabs['cookiestracking']->hideThis();

        $this->tabs['bannerformat'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabBannerFormat');
        $this->tabs['bannerformat']->setAttributes('bannerformat', L_G_BANNERFORMAT, 'settings_bannerformat', 'icon_bannerformat.gif');
        $this->tabs['bannerformat']->hideThis();

        /*$this->tabs['sitereplication'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabSiteReplication');
        $this->tabs['sitereplication']->setAttributes('sitereplication', L_G_SITEREPLICATION, 'settings_sitereplication', 'icon_sitereplication.gif');*/

		if($GLOBALS['Auth']->getSetting('Glob_acct_geo_allowed') == '1') {
        	$this->tabs['geoip'] = QUnit_Global::newObj('Affiliate_Merchants_Views_TabGeoIP');
        	$this->tabs['geoip']->setAttributes('geoip', L_G_GEOIPSETTINGS, 'settings_geoip', 'icon_geoip.gif');
		    $this->tabs['geoip']->hideThis();
        }
    }

    function showSettings($reload = false, $errorTabs = array()) {
        if($reload == true || $_POST['commited'] != 'yes') {
            // get settings from Auth
            $this->loadSettings();
        }

        if($_REQUEST['setting_tab_sheet'] == '')
            $_REQUEST['setting_tab_sheet'] = 'langandcur';
        if($_REQUEST['action'] == '')
            $_REQUEST['action'] = 'edit';

        $this->initTemporaryTE();
        $p_tabs = array();
        foreach ($this->tabs as $tab) {
        	$p_tabs[] = array('id'      => $tab->name,
        	                  'caption' => $tab->link,
        	                  'content' => $tab->show($this),
        	                  'error'   => (in_array($tab->name, $errorTabs) ? '1' : '0'),
        	                  'icon'    => $tab->icon,
                              'hidden'  => $tab->hidden);
        }

        $this->assign('a_tabs', $p_tabs);

        $this->addContent('settings_main');

        return true;
    }

}