<?php

QUnit_Global::includeClass('QUnit_UI_TemplatePage');
QUnit_Global::includeClass('QCore_Settings');


class Affiliate_Merchants_Views_Ucenter extends QUnit_UI_TemplatePage
{
    function Affiliate_Merchants_Views_Ucenter() {
        $this->navigationAddURL(L_G_HOME,'index.php?md=home');
        $this->navigationAddURL(L_G_SETTINGS, 'javascript:;');
		$this->navigationAddURL(L_G_UCENTER_SETTINGS,'index.php?md=Affiliate_Merchants_Views_Ucenter');
    }

    //------------------------------------------------------------------------

    function process()
    {

        if($_POST['commited']=="yes"){
            $aid = $GLOBALS['Auth']->getAccountID();
            $data = $this->processdata();
            if($data) {
                foreach($data as $code=>$value) {
                    QCore_Settings::_update($code, $value, SETTINGTYPE_ACCOUNT, $aid);
                }
                $GLOBALS['Auth']->loadSettings();

                if($this->write2configfile($data))
                    QUnit_Messager::setOKMessage(L_G_UCSETTINGS_OK);
                else
                    QUnit_Messager::setErrorMessage(L_G_UCSETTINGS_FAIL);
            }
        }

        $this->loadfromsettings();
        $this->addContent('settings_ucenter');
    }

    //--------------------------------------------------------------------------

    function loadfromsettings() {
        $_POST['uc_enable'] = $GLOBALS['Auth']->settings['Aff_uc_enable'];
        $_POST['uc_appid'] = $GLOBALS['Auth']->settings['Aff_uc_appid'];
        $_POST['uc_appkey'] = $GLOBALS['Auth']->settings['Aff_uc_appkey'];
        $_POST['uc_url'] = $GLOBALS['Auth']->settings['Aff_uc_url'];
        $_POST['uc_ip'] = $GLOBALS['Auth']->settings['Aff_uc_ip'];
        $_POST['uc_method'] = $GLOBALS['Auth']->settings['Aff_uc_method'];
        $_POST['uc_dbserver'] = $GLOBALS['Auth']->settings['Aff_uc_dbserver'];
        $_POST['uc_dbusername'] = $GLOBALS['Auth']->settings['Aff_uc_dbusername'];
        $_POST['uc_dbpasswd'] = $GLOBALS['Auth']->settings['Aff_uc_dbpasswd'];
        $_POST['uc_dbname'] = $GLOBALS['Auth']->settings['Aff_uc_dbname'];
        $_POST['uc_tableprefix'] = $GLOBALS['Auth']->settings['Aff_uc_tableprefix'];
    }

    //--------------------------------------------------------------------------

    function processdata() {
        $return = array();

        $return['Aff_uc_enable'] = intval($_POST['uc_enable']);

        if(!is_numeric($_POST['uc_appid'])) {
            QUnit_Messager::setErrorMessage(L_G_UCAPPID_NOTBEMPTY);
            return false;
        } else {
            $return['Aff_uc_appid'] = $_POST['uc_appid'];
        }

        if(empty($_POST['uc_appkey'])) {
            QUnit_Messager::setErrorMessage(L_G_UCAPPKEY_NOTBEMPTY);
            return false;
        } else {
            $return['Aff_uc_appkey'] = mysql_real_escape_string($_POST['uc_appkey']);
        }

        if(empty($_POST['uc_url'])) {
            QUnit_Messager::setErrorMessage(L_G_UCURL_NOTBEMPTY);
            return false;
        } else {
            $return['Aff_uc_url'] = mysql_real_escape_string($_POST['uc_url']);
        }

        $return['Aff_uc_ip'] = mysql_real_escape_string($_POST['uc_ip']);
        $return['Aff_uc_method'] = in_array($_POST['uc_method'],array('mysql','post'))?$_POST['uc_method']:'post';

        if($return['Aff_uc_method']=='mysql') {
            if(empty($_POST['uc_dbserver']) || empty($_POST['uc_dbserver']) ||
                empty($_POST['uc_dbserver']) || empty($_POST['uc_dbserver']) || empty($_POST['uc_dbserver'])) {
                QUnit_Messager::setErrorMessage(L_G_UCDBCONFIG_NOTBEMPTY);
                return false;
            }
        }

        $return['Aff_uc_dbserver'] = mysql_real_escape_string($_POST['uc_dbserver']);
        $return['Aff_uc_dbusername'] = mysql_real_escape_string($_POST['uc_dbusername']);
        $return['Aff_uc_dbpasswd'] = mysql_real_escape_string($_POST['uc_dbpasswd']);
        $return['Aff_uc_dbname'] = mysql_real_escape_string($_POST['uc_dbname']);
        $return['Aff_uc_tableprefix'] = mysql_real_escape_string($_POST['uc_tableprefix']);

        return $return;
    }

    //--------------------------------------------------------------------------

    function write2configfile($data) {
        $file = $GLOBALS['PROJECT_ROOT_PATH'] . '/settings/ucconfig.inc.php';
        $handle = @fopen($file, 'wb');
        if(!$handle) return false;

        fwrite($handle, "<?php \r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Enable ucenter\r\n");
        fwrite($handle, "define('UC_ENABLE','".$data['Aff_uc_enable']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Connect type\r\n");
        fwrite($handle, "define('UC_CONNECT','".$data['Aff_uc_method']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Database server name, default 'localhost'\r\n");
        fwrite($handle, "define('UC_DBHOST','".$data['Aff_uc_dbserver']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Database username \r\n");
        fwrite($handle, "define('UC_DBUSER','".$data['Aff_uc_dbusername']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Database password \r\n");
        fwrite($handle, "define('UC_DBPW','".$data['Aff_uc_dbpasswd']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Database name \r\n");
        fwrite($handle, "define('UC_DBNAME','".$data['Aff_uc_dbname']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Database charset \r\n");
        fwrite($handle, "define('UC_DBCHARSET','utf8');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// Table prefix \r\n");
        fwrite($handle, "define('UC_DBTABLEPRE','`".$data['Aff_uc_dbname'].'`.'.$data['Aff_uc_tableprefix']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// DB CONNECT \r\n");
        fwrite($handle, "define('UC_DBCONNECT','0');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// UC KEY \r\n");
        fwrite($handle, "define('UC_KEY','".$data['Aff_uc_appkey']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// UC API URL \r\n");
        fwrite($handle, "define('UC_API','".$data['Aff_uc_url']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// UC CHARSET \r\n");
        fwrite($handle, "define('UC_CHARSET','utf8');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// UC IP \r\n");
        fwrite($handle, "define('UC_IP','".$data['Aff_uc_ip']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// UC APP ID \r\n");
        fwrite($handle, "define('UC_APPID','".$data['Aff_uc_appid']."');\r\n");

        fwrite($handle, "//----------------------------------------------------------------------------\r\n");
        fwrite($handle, "// UC PPP \r\n");
        fwrite($handle, "define('UC_PPP','20');\r\n");

        fwrite($handle, "?>\r\n");

        fclose($handle);
        return true;

    }

    //--------------------------------------------------------------------------

}
?>
