<?php

QUnit_Global::includeClass('Affiliate_Merchants_Bl_Settings');
QUnit_Global::includeClass('Affiliate_Merchants_Views_PZoneSettings');

class Affiliate_PZone_Bl_Core extends Affiliate_Merchants_Views_PZoneSettings
{

    public $p_paged = 1;
    public $p_limit_default = 30;
    public $p_limit = 30;
    public $p_pages = 1;
    public $p_page = 1;
    public $p_startpos = 0;
    public $p_total = 0;
    public $p_where = '';

    function Affiliate_PZone_Bl_Core() {
        $this->initSettings();
    }

    //------------------------------------------------------------------------

    function getSiteName() {
        return !empty($this->settings['sitename']['svalue'])?$this->settings['sitename']['svalue']:MT_SITETITLE;
    }

    function getSiteLogo() {
        return !empty($this->settings['sitelogo']['svalue'])?$this->settings['sitelogo']['svalue']:$this->settings['siteurl']['svalue'].'/templates/affiliate/default/images/web_logo.gif';
    }

    function getSiteLogo4Affiliate() {
        return !empty($this->settings['sitelogo']['svalue'])?$this->settings['sitelogo']['svalue']:$this->settings['siteurl']['svalue'].'/templates/pzone/'.$GLOBALS['default_template'].'/images/web_logo.png';
    }

    function getFooterHtml() {
        return $this->settings['footer']['svalue'];
    }

    //--------------------------------------------------------------------------

    /*
    //传入参数
    $params = array(
        'paged'=>true,  //是否分页
        'pageid'=>1,    //当前页码
        'limit'=>30,    //每页显示条数
        'cateid'=array() 或 string,    //文章分类，为空则显示所有分类
    );

    //返回内容
    $rs = array(
        'catename'=>(String),   //分类名称
        'articles'=>(ADODB对象),    //数据库文章
        'pagenav'=>Array('total'=>,'')     //导航信息
    );

    //调用顺序：获取where字句，获取total，获取页面信息，获取列表

    */

    function createMySQLWhere($params) {
        $where = 'where 1 ';
        if(is_array($params['cateid'])) {
            $where .= ' and c.`ID` in ("'.join('","',$params['cateid']).'")';
        }elseif(!empty($params['cateid'])) {
            $where .= ' and c.`ID`="'.$params['cateid'].'"';
        }
        if(!empty($params['search'])) {
            $where .= ' and (p.`title` like "%'.$params['search'].'%" or p.`context` like "%'.$params['search'].'%") ';
        }
        $this->p_where = $where;
    }

    function countPostTotal() {
        $query = 'select count(p.`ID`) as "total" from `wd_pz_posts` p left join `wd_pz_cates` c on p.`cateid`=c.`ID` left join `wd_g_users` u on p.`authorid`=u.`userid` '.$this->p_where;
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            $this->p_total = 0;
        }else {
            $this->p_total = $rs->fields['total'];
        }
    }

    function countPageInfo($params) {
        $this->p_paged = $params['paged'];
        if($this->p_paged) {
            $this->p_limit = (int) $_REQUEST['limit'];
            $this->p_limit = $this->p_limit>0?$this->p_limit:($params['limit']>0?$params['limit']:$this->p_limit_default);
            $this->p_pages = ceil($this->p_total/$this->p_limit);
            $this->p_pages = $this->p_pages<1?1:$this->p_pages;
            $this->p_page = (int) $_REQUEST['pageid'];
            $this->p_page = empty($this->p_page)?$params['pageid']:$this->p_page;
            $this->p_page = $this->p_page>0?($this->p_page>$this->p_pages?$this->p_pages:$this->p_page):1;
            $this->p_startpos = ($this->p_page-1)*$this->p_limit;
        }
    }

    function getPosts($params) {
        $this->createMySQLWhere($params);
        $this->countPostTotal();
        $this->countPageInfo($params);

        $query = 'select p.*, c.`catename`,u.`name` as "authorname" from `wd_pz_posts` p left join `wd_pz_cates` c on p.`cateid` = c.`ID` left join `wd_g_users` u on p.`authorid`=u.`userid` '.$this->p_where.' order by p.`postime` DESC ';

        if($this->p_paged) {
            $query .= ' limit '.$this->p_startpos.', '.$this->p_limit;
        }

        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        if(!$rs || $rs->EOF) {
            return false;
        }

        return array(
            'catename'=>$rs->fields['catename'],    //注意，如果搜索多个分类的文章，这里只返回第一条记录的分类名称
            'articles'=>$rs,
            'paged'=>$this->p_paged,        //是否分页
            'pagenav'=>array(
                'total'=>$this->p_total,    //记录总条数
                'pages'=>$this->p_pages,    //总页面
                'page'=>$this->p_page,      //当前页码
                'limit'=>$this->p_limit     //每页显示条数
            )
        );
    }

    function getSinglePost($id) {
        if(empty($id)) return false;
        $query = 'select p.*, c.`catename`,u.`name` as "authorname" from `wd_pz_posts` p left join `wd_pz_cates` c on p.`cateid` = c.`ID` left join `wd_g_users` u on p.`authorid`=u.`userid` where p.`ID` = "'.$id.'"  ';

        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;

        if(!$rs || $rs->EOF) {
            return false;
        }
        return $rs;
    }

    //--------------------------------------------------------------------------

    //获取友情链接
    function getFriendLinks() {
        $query = 'select * from `wd_pz_links` where `rstatus`="show" order by `rsort`,`dateinserted` asc';
        $rs = $GLOBALS['db']->Query($query);
        $GLOBALS['dbrequests']++;
        if(!$rs || $rs->EOF) {
            return false;
        }

        foreach($rs as $row) {
            if(!empty($row['logourl'])) {
                $tmp['logo'][] = $row;
            }else {
                $tmp['word'][] = $row;
            }
        }
        return $tmp;
    }

    //--------------------------------------------------------------------------

    //推广员总业绩排行榜
    function getTopByTotal($limit=10) {
        $query = 'select u.userid,u.username,u.name,sum(t.commission) as "total" from `wd_pa_transactions` t join wd_g_users u on t.affiliateid=u.userid where t.rstatus=2 group by affiliateid order by total desc limit 0,'.$limit;
        $rs = $GLOBALS['db']->Query($query);
        if(!$rs || $rs->EOF) {
            return false;
        }else {
            return $rs;
        }
    }

    //--------------------------------------------------------------------------

    //推广员月度业绩排行榜
    function getTopByMonth() {
        global $return;
        $query = 'select u.userid,u.username,u.name,sum(t.commission) as "total" from `wd_pa_transactions` t join wd_g_users u on t.affiliateid=u.userid where t.rstatus=2 and date_format(t.`dateinserted`,"%Y-%m-%d") between concat(date_format(LAST_DAY(now()),"%Y-%m-"),"01") and NOW() group by affiliateid order by total desc limit 0,10';
        $rs = $GLOBALS['db']->Query($query);
        if(!$rs || $rs->EOF) {
            return false;
        }else {
            return $rs;
        }
    }

    //--------------------------------------------------------------------------


    //获取显示到顶部导航的链接
    function getShow2Nav_Articles($limit=10) {
        $query = 'select `ID`,`title` from `wd_pz_posts` where `show2nav`="yes" order by `postime` asc limit 0,'.$limit;
        $rs = $GLOBALS['db']->Query($query);
        if(!$rs || $rs->EOF) {
            return false;
        }else {
            return $rs;
        }
    }

    function getShow2Nav_Cates($limit=10) {
        $query = 'select `ID`,`catename` from `wd_pz_cates` where `show2nav`="yes" order by `displaysort` asc limit 0,'.$limit;
        $rs = $GLOBALS['db']->Query($query);
        if(!$rs || $rs->EOF) {
            return false;
        }else {
            return $rs;
        }
    }

    function getShow2Nav_Links($limit=10) {
        $query = 'select `ID`,`sitetitle`,`siteurl` from `wd_pz_links` where `rstatus`="show2nav" order by `dateinserted` asc limit 0,'.$limit;
        $rs = $GLOBALS['db']->Query($query);
        if(!$rs || $rs->EOF) {
            return false;
        }else {
            return $rs;
        }
    }

    //--------------------------------------------------------------------------

}
?>
