<?php
QUnit_Global::includeClass('QCore_Auth');
QUnit_Global::includeClass('QCore_Settings');

class Affiliate_Scripts_Bl_Auth extends QCore_Auth
{
    var $loadedSettingsForAccountID = '';

    //------------------------------------------------------------------------

    function Affiliate_Scripts_Bl_Auth()
    {
        $this->sessionPrefix = 'gaffauth';

        if($this->accountID == '') {
            $this->accountID = 'default1';
        }
    }

    //------------------------------------------------------------------------

    function loadSettings()
    {
        if($this->accountID == '')
            return false;

        if($this->loadedSettingsForAccountID == $this->accountID) {
            // settings already loaded
        }
        else {
            $this->settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $this->accountID);
            $this->loadedSettingsForAccountID = $this->accountID;
        }

        if($this->userID != '')
        {
            $userSettings = QCore_Settings::getAdminSettings(SETTINGTYPE_USER, $this->accountID, $this->userID);

            $this->settings = array_merge($this->settings, $userSettings);
        }

        $this->saveToSession();
    }

    //------------------------------------------------------------------------

    function setAccountID($accountID)
    {
        $this->accountID = $accountID;

        $this->loadSettings();
    }

    //------------------------------------------------------------------------

    function getSettingForScripts($code)
    {
        $sql =  "select value from wd_g_settings ".
                "where rtype="._q(SETTINGTYPE_ACCOUNT).
                " and accountid="._q($this->getAccountID()).
                " and code="._q($code);

        $rs =& $GLOBALS['db']->execute($sql);
        if($rs && !$rs->EOF) {
            return $rs->fields['value'];
        }

        QCore_History::writeHistory(WLOG_DEBUG, "Error get setting with code:".$code, __FILE__, __LINE__);

        return false;
    }
    
    //------------------------------------------------------------------------

    function getLiteAccountID()
    {
        if (GLOBAL_DB_ENABLED == 1) {
            if($_SESSION['s_lite_accountid'] != '') {
                return $_SESSION['s_lite_accountid'];
            }
            
            if($_SESSION['lid'] != '') {
                return $_SESSION['lid'];
            }
        }
            
        return $this->getSetting('AffPlanet_account_id');
    }        

}
?>
