<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class Affiliate_Scripts_Views_AffiliateSignup extends QUnit_UI_TemplatePage
{
    var $accountId;

    //------------------------------------------------------------------------

    function Affiliate_Scripts_Views_AffiliateSignup() {
    }

    //------------------------------------------------------------------------

    function process() {
        QUnit_Global::includeClass('QUnit_Countries');
        QUnit_Global::includeClass('QCore_Bl_Accounts');
        QUnit_Global::includeClass('QUnit_Messager');
        QUnit_Global::includeClass('QCore_Settings');
        QUnit_Global::includeClass('Affiliate_Scripts_Bl_SignupUserNew');

		$settings = $this->getSettings();
		// old signup form style
        //if ($settings['Aff_signup_automatic_form'] != '1')
        //	return $this->processStandard();

        if(!($this->accountId = $GLOBALS['Auth']->getAccountID()) && !($this->accountId = $_POST['aid'])) {
            QUnit_Messager::setErrorMessage(L_G_ACCOUNTNOTKNOWN);
        }

        if($_POST['commited'] == 'yes')
        {
            $signup = QUnit_Global::newObj('Affiliate_Scripts_Bl_SignupUserNew');
            if($signup->processSignup() == false) {
            } else {
                QUnit_Messager::setOkMessage(L_G_SUCCESS);
                $signup->redirect($signup->settings['Aff_affpostsignupurl']);
            }

        } else {
            if ($_REQUEST['pid'] == '') {
                $_REQUEST['pid'] = $this->checkCookie();
            } else {
                if (!$this->saveCookie($_REQUEST['pid'])) {
                    $_REQUEST['pid'] = $this->checkCookie();
                }
            }
        }

        $this->assign('settings', $settings);
        $this->assign('model', $this);
        $this->assign('aid', $this->accountId);

        $this->addTemplate();
    }

    //------------------------------------------------------------------------

    function addTemplate() {
        $this->addContent('aff_signup');
    }

    //------------------------------------------------------------------------

    function getSettings() {
        $settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $this->accountId);
        $settings = array_merge($settings, QCore_Settings::getGlobalSettings());
        return $settings;
    }

    //------------------------------------------------------------------------

    function getFieldRow($code, $caption) {
        $settings = $this->getSettings();
        if($settings['Aff_signup_'.$code] == "1") {
            if($settings['Aff_signup_'.$code.'_mandatory'] === "true") {
                $caption = "<b>$caption</b>";
                $mandatSign = "*";
            } else {
                $mandatSign = "";
            }
            return "<tr>\n" .
                "<td class=\"dir_form\">$caption</td>\n" .
                "<td><input type=\"text\" name=\"$code\" size=64 value=\"".$_POST[$code]."\">$mandatSign</td>" .
                "</tr>";
        }
    }

    //------------------------------------------------------------------------

    function isDisplayed($code) {
        $settings = $this->getSettings();
        if (is_array($code)) {
            if (count($code) > 0) {
                foreach ($code as $c) {
                	if ($settings['Aff_signup_'.$c] == "1") {
                	    return true;
                	}
                }
            }
            return false;
        } else {
            return ($settings['Aff_signup_'.$code] == "1");
        }
    }

    //------------------------------------------------------------------------

    function processStandard() {
        if($_POST['commited'] == 'yes')
        {
            $signup = QUnit_Global::newObj('Affiliate_Scripts_Bl_SignupUser');

            if($signup->processSignup())
            {
                $signup->redirect($signup->settings['Aff_affpostsignupurl']);
            }
        }
        else
        {
            $settings = QCore_Settings::getAccountSettings(SETTINGTYPE_ACCOUNT, $_REQUEST['aid']);
            $settings = array_merge($settings, QCore_Settings::getGlobalSettings());
            //Affiliate_Scripts_Bl_Signup::setLanguageFile(($settings['Aff_default_lang'] != '' ?
            //        $settings['Aff_default_lang'] : $settings['Glob_default_lang']));
        }
        $this->assign('settings', $settings);
        $this->addContent('aff_signup_standard');
    }

    //--------------------------------------------------------------------------

    function checkCookie()
    {
        if($_COOKIE[COOKIE_NAME] != '')
            $cookieval = $_COOKIE[COOKIE_NAME];
        else
            return '';

        $arr = split ( '_', $cookieval);

        if(!is_array($arr))
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: cookie value is not array', __FILE__, __LINE__);
            return '';
        }

        if(count($arr) != 2)
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: cookie value has not 2 elements', __FILE__, __LINE__);
            return '';
        }

        $userID = $arr[0];

        //------------------------------------------------------------------------
        // check user and campaign
        $blUsers = QUnit_Global::newObj('QCore_Bl_Users');
        if(!$blUsers->checkUserExists($userID))
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: User with ID '.$userID.' doesn\'t exist', __FILE__, __LINE__);
            return '';
        }

        return $userID;
    }

    //--------------------------------------------------------------------------

    function saveCookie($pid)
    {
        //------------------------------------------------------------------------
        // check user and campaign
        $blUsers = QUnit_Global::newObj('QCore_Bl_Users');
        if(!$blUsers->checkUserExists($pid))
        {
            QCore_History::DebugMsg(WLOG_ERROR, 'Signup user: User with ID '.$pid.' doesn\'t exist', __FILE__, __LINE__);
            return false;
        }

        if($_COOKIE[COOKIE_NAME] == '') {
            setcookie(COOKIE_NAME, $pid."_null");
        }

        return true;
    }
}
?>
