<?php
class QCore_Bl_GlobalFuncs
{
    function checkCrossLink($value_ID, $list = array(), $column_ID, $column_parentID, $table_name, $deleted = 1, $maxRecursion = 50)
    {
        if($value_ID == '' || $maxRecursion <=0)
            return false;

        // get parent
        $sql = 'select '.$column_parentID.' from '.$table_name.
               ' where '.$column_ID.'='._q($value_ID).
               '   and '.$column_parentID.'<>'._q($value_ID);
        if($deleted == 1) $sql .= ' and deleted='._q('0');
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        if(in_array($rs->fields[$column_parentID], $list))
            return true;
        
        $list[] = $rs->fields[$column_parentID];

        return QCore_Bl_GlobalFuncs::checkCrossLink($rs->fields[$column_parentID], $list, $column_ID, $column_parentID, $table_name, $deleted, $maxRecursion - 1);
    }
    
    //--------------------------------------------------------------------------

    function updateMass($params)
    {
        $valueIDs = $params['ids'];
        if(!is_array($valueIDs) || count($valueIDs) < 1)
            return false;

        $values = $params['values'];
        if(!is_array($values) || count($values) < 1)
            return false;

        $chunkedIDs = array_chunk($valueIDs, WD_MAX_PROCESSED_IDS);
        
        foreach($chunkedIDs as $IDsArray)
        {
            $IDsSql = "('".implode("','", $IDsArray)."')";
            
            $sql = 'update '.$params['table_name'].' set ';
            foreach($values as $field => $value)
                $sql .= ' '.$field.'='._q($value).',';
            $sql = substr($sql, 0, -1);
            $sql .= ' where '.$params['column_id'].' in '.$IDsSql;
            if($params['accountid'] != '') $sql .= ' and accountid='._q($params['accountid']);
            $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
            if(!$rs)
            {
                QUnit_Messager::setErrorMessage(L_G_DBERROR);
                return false;
            }
        }

        return true;
    }
    
    //--------------------------------------------------------------------------
    
    function getTree(&$treeData, $params)
    {
        if((int)$params['maxLevel'] <= 0) return;

        $sql = 'select * from '.$params['table_name']. ' where 1=1 ';
        if($params['where_sql'] != '') $sql .= $params['where_sql']; 
        if(is_array($params['where']) && count($params['where']) > 0)
        {
            foreach($params['where'] as $field => $value)
                $sql .= ' and '.$field.'='._q($value);
        }
        if($params['rootID'] != '')
            $sql .= ' and '.$params['column_parentid'].'='._q($params['rootID']);
        else
            $sql .= ' and ('.$params['column_parentid'].'=\'\' or '.$params['column_parentid'].' is null or '.$params['column_parentid'].'=\'0\')';
        if(is_array($params['order']) && count($params['order']) > 0)
        {
            $sql .= ' order by ';
            foreach($params['order'] as $field)
                $sql .= $field.',';
            $sql = substr($sql,0,-1);
        }

        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        while(!$rs->EOF)
        {
            $temp = array();
            foreach($params['getvalues'] as $field)
                $temp[$field] = $rs->fields[$field];
            $temp['tab'] = $params['tab'];
            $temp['level'] = $params['level'];

            $treeData[] = $temp;

            // look for children
            $temp_params = $params;
            $temp_params['rootID'] = $rs->fields[$params['column_id']];
            $temp_params['tab'] = $temp_params['tab'].$temp_params['tabLevel'];
            $temp_params['level'] = (int)$temp_params['level']+1;
            $temp_params['maxLevel'] = (int)$temp_params['maxLevel'] - 1;

            QCore_Bl_GlobalFuncs::getTree($treeData, $temp_params);

            $rs->MoveNext();
        }
    }

    //--------------------------------------------------------------------------

    function getParents(&$parentsData, $params)
    {
        if($params['parentID'] == '') return;
    
        $sql = 'select * from '.$params['table_name']. ' where 1=1 ';
        if(is_array($params['where']) && count($params['where']) > 0)
        {
            foreach($params['where'] as $field => $value)
                $sql .= ' and '.$field.'='._q($value);
        }
        $sql .= ' and '.$params['column_id'].'='._q($params['parentID']);

        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        while(!$rs->EOF)
        {
            $temp = array();
            foreach($params['getvalues'] as $field_name => $field)
                $temp[(is_int($field_name) ? $field : $field_name)] = $rs->fields[$field];

            $parentsData[] = $temp;

            // look for parent
            $temp_params = $params;
            $temp_params['parentID'] = $rs->fields[$params['column_parentid']];

            QCore_Bl_GlobalFuncs::getParents($parentsData, $temp_params);

            $rs->MoveNext();
        }
    }

    //--------------------------------------------------------------------------
    
    function getTree_old(&$treeData, $params)
    {
        if((int)$params['maxLevel'] <= 0)
            return;

        $sql = 'select * from '.$params['table_name']. ' where 1=1 ';
        if(is_array($params['where']) && count($params['where']) > 0)
        {
            foreach($params['where'] as $field => $value)
                $sql .= ' and '.$field.'='._q($value);
        }
        if($params['rootID'] != '')
            $sql .= ' and '.$params['column_parentid'].'='._q($params['rootID']);
        else
            $sql .= ' and ('.$params['column_parentid'].'=\'\' or '.$params['column_parentid'].' is null or '.$params['column_parentid'].'=\'0\')';
        if(is_array($params['order']) && count($params['order']) > 0)
        {
            $sql .= ' order by ';
            foreach($params['order'] as $field)
                $sql .= $field.',';
            $sql = substr($sql,0,-1);
        }

        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        while(!$rs->EOF)
        {
            $temp = array();
            foreach($params['getvalues'] as $field)
                $temp[$field] = $rs->fields[$field];
            $temp['tab'] = $params['tab'];

            $treeData[] = $temp;

            // look for children
            $temp_params = $params;
            $temp_params['rootID'] = $rs->fields[$params['column_id']];
            $temp_params['tab'] = $temp_params['tab'].$temp_params['tabLevel'];
            $temp_params['maxLevel'] = (int)$temp_params['maxLevel'] - 1;

            QCore_Bl_GlobalFuncs::getTree($treeData, $temp_params);

            $rs->MoveNext();
        }
    }
    
    //--------------------------------------------------------------------------
    
    function returnIDs()
    {
        if($_POST['massaction'] != '')
        {
            $IDs = $_POST['itemschecked'];
        }
        else
        {
            $temp_id = preg_replace('/[\'\"]/', '', $_REQUEST['id']);
            $IDs = array($temp_id);
        }
        
        return $IDs;
    }

}
?>
