<?php
class QCore_Bl_IpCountry
{
    function getCountriesAsArray()
    {
        $sql = 'select distinct(countrySHORT) as cs, countryLONG as cl from wd_g_ipcountry order by countryLONG';
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return array();
        }

        $countries = array();
        while(!$rs->EOF)
        {
            $temp = array();

            $temp['countrycode'] = $rs->fields['cs'];
            $temp['countryname'] = $rs->fields['cl'];

            $users[$rs->fields['cs']] = $temp;

            $rs->MoveNext();
        }
        
        return $users;
    }
    
     //--------------------------------------------------------------------------
    
    function getAvalaibleColumns()
    {
    	$sql = 'select * from wd_g_ipcountry';
		$rs = QCore_Sql_DBUnit::selectLimit($sql, 0, 1, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return array();
        }
        if($rs->numRows() == 0) {
        	return array();
        }
        
        $columns = array();
        if ($rs->fields[countrySHORT] != '') $columns[] = 'countrycode';
        if ($rs->fields[countryLONG] != '') $columns[] = 'countryname';
        if ($rs->fields[ipREGION] != '') $columns[] = 'region';
        if ($rs->fields[ipCITY] != '') $columns[] = 'city';
        if ($rs->fields[ipLATITUDE] != '') $columns[] = 'latitude';
        if ($rs->fields[ipLONGITUDE] != '') $columns[] = 'longitude';
        if ($rs->fields[ipISP] != '') $columns[] = 'isp';
        if ($rs->fields[ipDOMAIN] != '') $columns[] = 'domain';
        
        return $columns;
    }
    
    //--------------------------------------------------------------------------
    
    function getCountryForIp($ip)
    {
    	$sql = 'select * from wd_g_ipcountry where '.
			   $this->dot2LongIP($ip).' between ipFROM AND ipTO';
		$rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return array();
        }
        if($rs->numRows() == 0) {
        	return array('countrycode' => '__',
        			 	 'countryname' => 'Unknown',
        			 	 'region' => '',
        			 	 'city' => '',
        			 	 'latitude' => '',
        			 	 'longitude' => '',
        			 	 'isp' => '',
        			 	 'domain' => '');
        }
        
        return array('countrycode' => $rs->fields['countrySHORT'],
        			 'countryname' => $rs->fields['countryLONG'],
        			 'region' => $rs->fields['ipREGION'],
        			 'city' => $rs->fields['ipCITY'],
        			 'latitude' => $rs->fields['ipLATITUDE'],
        			 'longitude' => $rs->fields['ipLONGITUDE'],
        			 'isp' => $rs->fields['ipISP'],
        			 'domain' => $rs->fields['ipDOMAIN']);
    }
    
    //--------------------------------------------------------------------------
    
    function getCountryInfo($countrycode)
    {
    	$sql = 'select countrySHORT as cs, countryLONG as cl '.
    		   'from wd_g_ipcountry where '.
			   'countrySHORT='._q($countrycode);
		$rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return array();
        }
        if($rs->numRows() == 0) {
        	return array('countrycode' => '__',
        			 	 'countryname' => 'Unknown');
        }
        
        return array('countrycode' => $rs->fields['cs'],
        			 'countryname' => $rs->fields['cl']);
    }
    
    //--------------------------------------------------------------------------
    
    function dot2LongIP($IPaddr)
	{
    	if ($IPaddr == "") {
        	return 0;
    	} else {
        	$ips = split ("\.", "$IPaddr");
        	return ($ips[3] + $ips[2] * 256 + $ips[1] * 256 * 256 + $ips[0] * 256 * 256 * 256);
    	}
	}
	
	//--------------------------------------------------------------------------
	
	function isAllowedIp($ip, $settings = '')
	{
		return $this->isAllowedCountry($this->getCountryForIp($ip), $settings);
	}
	
	//--------------------------------------------------------------------------
	
	function isAllowedCountry($country, $settings = '')
	{
		if($settings == '')
			$settings = $GLOBALS['Auth']->getSettings();
		if($settings['Glob_acct_geo_allow_ban_trafic'] == ALLOW_TRAFFIC) {
			if(strpos($settings['Glob_acct_geo_selectedcountries'], $country['countrycode']) === false)
				return false;
		} else {
			if(strpos($settings['Glob_acct_geo_selectedcountries'], $country['countrycode']) !== false)
				return false;
		}
		
		return true;	
	}
	
	//--------------------------------------------------------------------------
	
	function isAllowedIp_2($ip, $allow_ban_setting, $selected_countries_setting)
	{
		$settings = array('Glob_acct_geo_allow_ban_trafic' => $allow_ban_setting,
						  'Glob_acct_geo_selectedcountries' => $selected_countries_setting);
		return $this->isAllowedIp($ip, $settings);
	}
	
	//--------------------------------------------------------------------------
	
	function deleteAllTableRecords() {
		$sql = 'delete from wd_g_ipcountry';
		$rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }
        return true;
	}
	
	//--------------------------------------------------------------------------
	
	function insertRecordToTable($columns, $values) {
		$sql = 'insert into wd_g_ipcountry ('.implode(',', $columns).') values ('.implode(',', $values).')';
		$rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }
        return true;
	}

}
?>
