<?php
QUnit_Global::includeClass('QUnit_Countries');
QUnit_Global::includeClass('QCore_Bl_Users');

define('WD_PATTERN_DEFAULT', '/[^\'\"]*/');

class QCore_Sql_Table {

    var $columns = array();
    var $where_columns = array();

    function QCore_Sql_Table() {
    }
            
    //--------------------------------------------------------------------------
    
    function getTableName() {
        return '';
    }
            
    //--------------------------------------------------------------------------
    
    function getPkName() {
        return '';
    }
            
    //--------------------------------------------------------------------------
        
    function addColumn($column, $pattern, $needed = true)
    {
        $this->columns[$column]['pattern'] = $pattern;
        //$this->columns[$column]['value'] = ''; 
        $this->columns[$column]['caption'] = $column;
        $this->columns[$column]['needed'] = $needed;        
        $this->columns[$column]['type'] = 'string';        

        $this->where_columns[$column]['pattern'] = $pattern;
        //$this->where_columns[$column]['value'] = ''; 
        $this->where_columns[$column]['caption'] = $column;
        $this->where_columns[$column]['needed'] = $needed;        
        $this->where_columns[$column]['type'] = 'string';        
    }
            
    //--------------------------------------------------------------------------
    
    function isFilled($column) {
        if(isset($this->columns[$column]['value']) && $this->columns[$column]['value'] !== '') {
            return true;
        }
        return false;
    }
            
    //--------------------------------------------------------------------------
    
    function isWhereFilled($column) {
        if(isset($this->where_columns[$column]['value']) && $this->where_columns[$column]['value'] !== '') {
            return true;
        }
        return false;
    }
            
    //--------------------------------------------------------------------------

    function setNeeded($column, $value) {
        if(isset($this->columns[$column])) {
            $this->columns[$column]['needed'] = $value;  
        }        
    }
            
    //--------------------------------------------------------------------------
    
    function setType($column, $value) {
        if(isset($this->columns[$column])) {
            $this->columns[$column]['type'] = $value;  
        }        
    }
            
    //--------------------------------------------------------------------------
    
    function setCaption($column, $caption) {
        if(isset($this->columns[$column])) {
            $this->columns[$column]['caption'] = $caption;  
        }        
    }
            
    //--------------------------------------------------------------------------
    
    function setColumn($column, $value) {
        if(isset($this->columns[$column])) {
            $this->columns[$column]['value'] = $value;            
        }
    }
    
    //--------------------------------------------------------------------------
    
    function setWhereColumn($column, $value) {
        if(isset($this->where_columns[$column])) {
            $this->where_columns[$column]['value'] = $value;
        }
    }
    
    //--------------------------------------------------------------------------

    function setUniqueId($column) {
        if(isset($this->columns[$column])) {
            $this->columns[$column]['value'] = substr(md5(uniqid(rand(), true)), 0, 8);
        }
    }    
            
    //--------------------------------------------------------------------------
    
    function getColumn($column) {
        if(isset($this->columns[$column])) {
            return $this->columns[$column]['value'];
        } 
        return false;       
    }
            
    //--------------------------------------------------------------------------

    function getWhereColumn($column) {
        if(isset($this->where_columns[$column])) {
            return $this->where_columns[$column]['value'];
        } 
        return false;       
    }
            
    //--------------------------------------------------------------------------

    function getCaption($column) {
        if(isset($this->columns[$column])) {
            return $this->columns[$column]['caption'];
        } 
        return false;       
    }
            
    //--------------------------------------------------------------------------

    function getPattern($column) {
        if(isset($this->columns[$column])) {
            return $this->columns[$column]['pattern'];
        } 
        return false;       
    }
            
    //--------------------------------------------------------------------------

    function isNeeded($column) {
        if(isset($this->columns[$column])) {
            return $this->columns[$column]['needed'];
        } 
        return true;       
    }
            
    //--------------------------------------------------------------------------
    
    function getColumns() {
        return $this->columns;
    }

    //--------------------------------------------------------------------------

    function getWhereColumns() {
        return $this->where_columns;
    }
            
    //--------------------------------------------------------------------------

    function fillColumnsFromArray($arr) {
        foreach($arr as $key => $val) {            
            $this->setColumn($key, $val);
        }
    }
    
    //--------------------------------------------------------------------------
    
    function setColumnWithDate($column, $time = '') {        
        if($time === '') $time = time();
        $this->setColumn($column, strftime("%Y-%m-%d %H:%M:%S", $time));
    }
            
    //--------------------------------------------------------------------------
        
    function getErrorMessage() {
        return QUnit_Messager::getErrorMessage();
    }
            
    //--------------------------------------------------------------------------
    
    function addErrorMessage($msg) {
        QUnit_Messager::setErrorMessage($msg);
    }
            
    //--------------------------------------------------------------------------

    function check() {        
        $correct = true;
        foreach($this->getColumns() as $key => $val) {
            if($key=='surname') continue;
            if($this->isFilled($key) === false && $this->isNeeded($key) === true) {
                $this->addErrorMessage($this->getCaption($key).' '.L_G_EMPTY);
                $correct = false;
            } elseif(!preg_match($this->getPattern($key), $this->getColumn($key))) {
                $this->addErrorMessage($this->getCaption($key).' '.L_G_UNALLOWED);
                $correct = false;                
            }
        }
       return $correct;
    }
            
    //--------------------------------------------------------------------------
    
    function insert() {        
        $sql = "insert into ".$this->getTableName()." set ";
        foreach($this->getColumns() as $col => $value) {
            if($this->isFilled($col) != false) {
                $sql .= "$col = '".addslashes($this->getColumn($col))."', ";
            }
        }
        $sql = rtrim($sql, ", ");
        $ret = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if (!$ret)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        return true;      
    }
            
    //--------------------------------------------------------------------------

    function update() {
        $sql = "update ".$this->getTableName()." set ";
        foreach($this->getColumns() as $col => $value) {
            if($this->isFilled($col) != false) {
                $sql .= "$col = '".addslashes($this->getColumn($col))."', ";
            }
        }
        $sql = rtrim($sql, ", ");
        $sql .= " where ".$this->getPkName()." = '".$this->getColumn($this->getPkName())."' and ";
        foreach($this->getWhereColumns() as $col => $value) {
            if($this->isWhereFilled($col) != false) {
                $sql .= "$col = '".addslashes($this->getWhereColumn($col))."' and ";
            }
        }
        $sql = rtrim($sql, " and ");
        $ret = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if (!$ret)
        {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        return true;
    }
            
    //--------------------------------------------------------------------------
    
    function isUnique($column) {
        if(!isset($this->columns[$column])) {
            return false;
        }
        $sql = "select $column from ".$this->getTableName()." where $column='".$this->getColumn($column)."'";
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) return false;        
        if ($rs->RecordCount() == 0) {
            return true;
        }
        return false;                        
    }
    
    //--------------------------------------------------------------------------

    function delete()
    {
        $sql = "delete from ".$this->getTableName();
        if(is_array($this->getColumns()) && count($this->getColumns()) > 0)
        {
            $sql .= " where ";
            foreach($this->getColumns() as $col => $value)
            {
                if($this->isFilled($col) != false)
                    $sql .= "$col = '".addslashes($this->getColumn($col))."' and ";
            }
            $sql = substr($sql, 0, -5);
        }

        $ret = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$ret) {
            QUnit_Messager::setErrorMessage(L_G_DBERROR);
            return false;
        }

        return true;
    }
}
?>
