<?php
QUnit_Global::includeClass('QCore_Sql_Table');

class QCore_Sql_Table_Domains extends QCore_Sql_Table {

    var $columns = array();

    //--------------------------------------------------------------------------

    function QCore_Sql_Table_Domains() {
        $this->addColumn('domainid', WD_PATTERN_DEFAULT);
        $this->addColumn('accountid', WD_PATTERN_DEFAULT);
        $this->addColumn('userid', WD_PATTERN_DEFAULT);
        $this->addColumn('url', WD_PATTERN_DEFAULT);
        $this->addColumn('rtype', WD_PATTERN_DEFAULT);
        $this->addColumn('rstatus', WD_PATTERN_DEFAULT);
        $this->addColumn('dateinserted', WD_PATTERN_DEFAULT);
        $this->addColumn('declinereason', WD_PATTERN_DEFAULT);
    }
    
    //--------------------------------------------------------------------------
    
    function getTableName() {
        return 'wd_g_domains';
    }    
    
    //--------------------------------------------------------------------------
        
    function getPkName() {
        return 'domainid';
    }          
    
    //--------------------------------------------------------------------------
/*
    function existsInAccount() {
        $sql =  "select domainid from ".$this->getTableName().
                " where url = '".$this->getColumn('url')."'".
                "   and accountid = '".$this->getColumn('accountid')."'".
                "   and rtype="._q($this->getColumn('rtype'));
        $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) return false;
        if ($rs->RecordCount() > 0) {
            return $rs->fields('domainid');
        }
        return false;
    }
*/
    //--------------------------------------------------------------------------
    
    function &getDomainsForAccount() {
        $sql =  "select url from ".$this->getTableName().
                " where accountid = '".$this->getColumn('accountid')."'".
                "   and rtype="._q($this->getColumn('rtype')).
                "   and rstatus="._q(AFFSTATUS_APPROVED).
                " order by url";
        $rs =& QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) return false;
        return $rs;
    }
    
    //--------------------------------------------------------------------------
/*
    function isChanged() {
        $sql =  "select url from ".$this->getTableName().
                " where domainid = '".$this->getColumn('domainid')."'".
                "   and rtype="._q($this->getColumn('rtype'));
        $rs =& QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) return false;
        if ($row = $rs->FetchRow()) {
            if($row['url'] == $this->getColumn('url')) {
                return false;
            }
        }
        return true;                
    }
*/
    //--------------------------------------------------------------------------
    
    function getAccountForDomain($url) {
        $sql =  "select accountid from ".$this->getTableName().
                " where url = '$url'".
                "   and rtype="._q($this->getColumn('rtype'));
        $rs =& QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) return false;
        if ($row = $rs->FetchRow()) {
            $this->setColumn('accountid', $row['accountid']);
            return $row['accountid'];
        }                
        return false;
    }
    
    //--------------------------------------------------------------------------
    
    function getDomainRS($params)
    {
        $sql = 'select * from '.$this->getTableName().
               ' where domainid='._q($params['domainid']).
               '   and accountid='._q($params['accountid']).
               '   and userid='._q($params['userid']);
        $rs =& QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
        if(!$rs) return false;
        else return $rs;
    }
    
    //--------------------------------------------------------------------------
    
    function changeState($params)
    {
        $AccountID = $params['AccountID'];
        $affDomainIDs = $params['affDomainIDs'];
        $state = $params['state'];
        $decline_reason = $params['decline_reason'];
        $round_numbers = $params['round_numbers'];
        $settings = $params['settings'];

        if(!is_array($affDomainIDs) || count($affDomainIDs) < 1)
            return false;

        if($state != AFFSTATUS_APPROVED && $state != AFFSTATUS_SUPPRESSED)
            return false;

        $chunkedAffDomainIDs = array_chunk($affDomainIDs, WD_MAX_PROCESSED_IDS);

        foreach($chunkedAffDomainIDs as $affDomainIDsArray)
        {
            $affDomainIDSql = "('".implode("','", $affDomainIDsArray)."')";

            $this->setColumn('domainid', $DomainID);
            $this->setColumn('declinereason', $decline_reason);
            $this->setColumn('rstatus', $state);
            $this->update();
            
            $sql = 'update wd_g_domains '.
                   'set rstatus='._q($state).
                   '   ,declinereason='._q($decline_reason).
                   ' where domainid in '.$affDomainIDSql.
                   '   and accountid='._q($AccountID);
            $rs = QCore_Sql_DBUnit::execute($sql, __FILE__, __LINE__);
            if(!$rs) {
                QUnit_Messager::setErrorMessage(L_G_DBERROR);
                continue;
            }

/*            
            $acs_params = array('accountID' => $AccountID,
                                'affdomainidsql' => $affDomainIDSql
                               );
            if(($old_affCamp_datas = $this->getAffCampStatus($acs_params)) === false) continue;
            
            if(!is_array($old_affCamp_datas) || count($old_affCamp_datas) < 1) continue;
            
            $acs_params = array('state' => $state,
                                'affcampidsql' => $affCampIDSql,
                                'decline_reason' => $decline_reason
                               );
            
            $ret = $this->updateAffCampStatus($acs_params);
            
            if($ret == false) continue;
            
            foreach($old_affCamp_datas as $affCampID => $affCampData)
            {
                if($affCampData['oldstate'] == AFFSTATUS_NOTAPPROVED && $state == AFFSTATUS_APPROVED)
                {
                    $ftaac_params = array('accountID' => $AccountID,
                                          'decimal_places' => $round_numbers,
                                          'affcampid' => $affCampID,
                                          'userid' => $affCampData['userid'],
                                          'campaignid' => $affCampData['campaignid'],
                                          'email' => $affCampData['email'],
                                          'camp_name' => $affCampData['camp_name'],
                                          'settings' => $settings
                                         );

                    $this->firstTimeApproveAffCamp($ftaac_params);
                }
            }
*/
        }
    }
}
?>
