<?php
//define('BASEDIR', realpath(dirname(realpath(__FILE__)) . '/..'));
//ini_set('include_path', PROJECT_INCLUDE_PATH.';'.CORE_INCLUDE_PATH);
/**
* include file in which exists the class
*
* @author 	Viktor Zeman
* @since 	Version 0.1a
* @return
*/

class QUnit_Global {

	/**
	* Return created object
	*
	* @author 	Viktor Zeman
	* @param	string Name of a class to create,
	* @param    next parameters are optionals and are sent as arguments to object constructor
	* @return	object Created object
	*/
	function newObj($class) {
        if(isset($GLOBALS['classMap'])) {
            if(defined('CUSTOMER_CODE') && isset($GLOBALS['classMap'][CUSTOMER_CODE][$class])) {
                $class = $GLOBALS['classMap'][CUSTOMER_CODE][$class];
            } else if(isset($GLOBALS['classMap'][AFF_PROGRAM_TYPE][$class])) {
                $class = $GLOBALS['classMap'][AFF_PROGRAM_TYPE][$class];
            }
        }
		if (!class_exists($class)) QUnit_Global::includeClass($class);
		if (func_num_args() > 1) {
			$arg_list = func_get_args();
			$str_arg_list = '$arg_list[1]';
			for ($i = 2; $i < count($arg_list); $i++) $str_arg_list .= ', $arg_list[' . $i . ']';
			eval("\$obj = new $class($str_arg_list);");
			return $obj;
		} else {
			return new $class;
		}
	}

	function includeClass($class_name) {
		if (class_exists($class_name)) {
            return true;
		}
        $fileName = QUnit_Global::existsClass($class_name);
        if(!$fileName) {
            if(MAIN_DEBUG && function_exists('debug_backtrace')) {
                foreach (debug_backtrace() as $stackElement) {
                    echo sprintf("At line %s, file %s. <br />", $stackElement['line'], $stackElement['file']);
                }
            }

            die(sprintf('Fatal Error: Class <strong>%s</strong> is missing. <br />', $class_name));
        }
		require_once($fileName);
		return true;
	}

	function includeTemplate($template_name) {
        //$fileName = QUnit_Global::existsClass($class_name);
        $pf =& QUnit_Global::newObj('QUnit_Io_PathFinder');
        $fileName = $pf->getTemplatePath($template_name);
        if(!$fileName) {
            if(MAIN_DEBUG && function_exists('debug_backtrace')) {
                foreach (debug_backtrace() as $stackElement) {
                    echo sprintf("At line %s, file %s\n", $stackElement['line'], $stackElement['file']);
                }
            }

            die(sprintf('Fatal Error: Template %s is missing. <br />', $template_name));
        }
		include($fileName.'/'.$template_name);
		return true;
	}

    function existsClass($className) {
        $fileName = QUnit_Global::_existsClass($className, $GLOBALS['PROJECT_INCLUDE_PATH']);
        if($fileName) {
            return $fileName;
        }
        $fileName = QUnit_Global::_existsClass($className, $GLOBALS['CORE_INCLUDE_PATH']);
        if($fileName) {
            return $fileName;
        }
        return false;
    }

	function _existsClass($className, $pathPrefix = '') {
		$fileName = QUnit_Global::_getFileName($className, $pathPrefix);

		if(!is_file($fileName)) {
			$fileName = QUnit_Global::_getFileNameCaseInsensitive($className, $pathPrefix);
		}
		return $fileName;
	}

	function _getRelativeClassPath($className) {
		$classPath = explode('_', $className);
		return implode('/', $classPath);
	}

	function _getFileName($className, $pathPrefix = '') {
		$fileName = $pathPrefix . '/' . QUnit_Global::_getRelativeClassPath($className) . '.class.php';
        //echo $fileName."<br>";
        return $fileName;
	}

	function _getFileNameCaseInsensitive($className, $pathPrefix = '') {
	    if (!function_exists('glob')) {
	       return false;
	    }

		$fileNames = glob($pathPrefix . '/' . sql_regcase(QUnit_Global::_getRelativeClassPath($className))
		             . '.class.php');
		if(!$fileNames) {
            return false;
		}
        return $fileNames[0];
	}

	function newobj_unserialized($className) {
		QUnit_Global::newObj($className);

	}

    function includeFile($file) {
        if(file_exists($GLOBALS['PROJECT_INCLUDE_PATH'].'/'.$file)) {
            require_once $GLOBALS['PROJECT_INCLUDE_PATH'].'/'.$file;
            return true;
        }
        if(file_exists($GLOBALS['CORE_INCLUDE_PATH'].'/'.$file)) {
        require_once $GLOBALS['CORE_INCLUDE_PATH'].'/'.$file;
        return true;
        }
        die("$file not exists. <br />");
    }
}
?>
