<?php
QUnit_Global::includeClass('QUnit_UI_TemplatePage');

class QUnit_Templates
{
    /** includes template */
    function includeTemplate($file)
    {
        include($_SESSION[SESSION_PREFIX.'template'].'/'.$file);
    }

    //-----------------------------------------------------------------------

    /** includes template */
    function printFilter($colspan = 1, $name = L_G_FILTER)
    {
        if(!is_numeric($colspan) && $name == L_G_FILTER) // there is name instead of colspan
            $GLOBALS['filtername'] = $colspan;
        else{
            $GLOBALS['colspan'] = $colspan;
            $GLOBALS['filtername'] = $name;
        }

        echo '<tr><td class="tableheader" colspan="'.$GLOBALS['colspan'].'">'.$GLOBALS['filtername'].'</td></tr>';
    }

    //-----------------------------------------------------------------------

    /** includes template */
    function printAdvancedFilter($colspan, $name=L_G_FILTER, $form_preffix, $form_name, $text = '')
    {
        if($text == '') {
            $text = array('showFilter'     => L_G_SHOWADVANCEDFILTER,
                          'showFilterHelp' => L_G_ADVANCEDFILTERSHOWHELP,
                          'hideFilter'     => L_G_HIDEADVANCEDFILTER,
                          'hideFilterHelp' => L_G_ADVANCEDFILTERHIDEHELP);
        }
?>
        <tr>
        <td class="tableheader" colspan="<?php echo $colspan?>">
        <table cellpadding="0" cellspacing="0" border="0" width="100%">
        <tr><td align="left"><?php echo $name?></td>
          <td align="right">
            <input type="hidden" name="<?php echo $form_preffix?>advanced_filter_show" value="<?php echo $_REQUEST[$form_preffix.'advanced_filter_show']?>">
            <div id="<?php echo $form_preffix?>standard_filter_caption" <?php echo ($_REQUEST[$form_preffix.'advanced_filter_show'] == '1') ? 'style="display:none;"' : ''?>>
                &nbsp;&nbsp;<a class=simplelink href="javascript:showAdvancedFilter('<?php echo $form_preffix?>', document.forms['<?php echo $form_name?>'].elements['<?php echo $form_preffix?>advanced_filter_show']);"><?php echo $text['showFilter']?>
                <img src="<?php echo QUnit_UI_TemplatePage::getImage('af_show.gif')?>" border="0" align="middle"></a>
                &nbsp;&nbsp;<?php showQuickHelp($text['showFilterHelp']); ?>
            </div>
            <div id="<?php echo $form_preffix?>advanced_filter_caption" <?php echo ($_REQUEST[$form_preffix.'advanced_filter_show'] == '1') ? '' : 'style="display:none;"'?>>
                &nbsp;&nbsp;<a class=simplelink href="javascript:showAdvancedFilter('<?php echo $form_preffix?>', document.forms['<?php echo $form_name?>'].elements['<?php echo $form_preffix?>advanced_filter_show']);"><?php echo $text['hideFilter']?>
                <img src="<?php echo QUnit_UI_TemplatePage::getImage('af_hide.gif')?>" border="0" align="middle"></a>
                &nbsp;&nbsp;<?php showQuickHelp($text['hideFilterHelp']); ?>
            </div>
            </td>
        </tr></table>
        </tr>
<?php
        //include('..'.$_SESSION[SESSION_PREFIX.'template'].'/filter.tpl.php');
    }

    //-----------------------------------------------------------------------

    /** includes template */
    function printFilter2($colspan = 1, $name = L_G_FILTER, $hlp = '', $class='')
    {
        if(!is_numeric($colspan) && $name == L_G_FILTER) // there is name instead of colspan
        $GLOBALS['filtername'] = $colspan;
        else
        {
            $GLOBALS['colspan'] = $colspan;
            $GLOBALS['filtername'] = $name;
        }

        print '<tr class="'.$class.'">'.
              '<td class=tableheader2 colspan="'.$GLOBALS['colspan'].'">'.
              '<b>'.$GLOBALS['filtername'].'</b>&nbsp;';
        if($hlp != '') {
            showQuickHelp($hlp);
        }
        print '</td>'.
              '</tr>';

        //include('..'.$_SESSION[SESSION_PREFIX.'template'].'/filter.tpl.php');
    }

    //-----------------------------------------------------------------------

    /** includes template */
    function printFilter3($colspan = 1, $name = L_G_FILTER, $hlp = '')
    {
        if(!is_numeric($colspan) && $name == L_G_FILTER) // there is name instead of colspan
        $GLOBALS['filtername'] = $colspan;
        else
        {
            $GLOBALS['colspan'] = $colspan;
            $GLOBALS['filtername'] = $name;
        }

        print '<tr>'.
              '<td class=tableheader2 style="border-top: 0px;" colspan="'.$GLOBALS['colspan'].'">'.
              '<img src="'.QUnit_UI_TemplatePage::getImage('farrow.png').'" border="10">&nbsp;'.
              '<b>'.$GLOBALS['filtername'].'</b>&nbsp;';
        if($hlp != '') {
            showQuickHelp($hlp);
        }
        print '</td>'.
              '</tr>';

        //include('..'.$_SESSION[SESSION_PREFIX.'template'].'/filter.tpl.php');
    }

    //-----------------------------------------------------------------------

    /** prints table header. also enables sorting */
    function printHeader($name, $sortby = '', $css_class = '')
    {
        if($sortby == '' || $_REQUEST['type'] == 'print')
        {
            echo "<td class=".($css_class == '' ? 'listheader' : $css_class)." nowrap>&nbsp;$name&nbsp;</td>";
            return;
        }
        $neworder = 'desc';
        if($sortby == $_REQUEST['sortby'] && $_REQUEST['sortorder'] == 'desc')
        $neworder = 'asc';

        if($css_class == '') {
            $css_class = ($sortby == $_REQUEST['sortby']) ? 'listheadersort' : 'listheader';
        }

        echo "<td class=".($css_class == '' ? 'listheader' : $css_class)." nowrap>&nbsp;<a href=\"javascript: FilterForm.sortby.value='$sortby'; FilterForm.sortorder.value='$neworder'; FilterForm.submit();\">$name</a>&nbsp;";

        if($sortby == $_REQUEST['sortby'] && $_REQUEST['sortorder'] == 'asc')
        echo "<img src='".QUnit_UI_TemplatePage::getImage('sort_up_sel.gif')."' border=0>";
        else if ($sortby == $_REQUEST['sortby'] && $_REQUEST['sortorder'] == 'desc')
        echo "<img src='".QUnit_UI_TemplatePage::getImage('sort_down_sel.gif')."' border=0>";
        else
        echo "<img src='".QUnit_UI_TemplatePage::getImage('sort_down.gif')."' border=0>";

        echo "&nbsp;</td>";
    }

    //--------------------------------------------------------------------------

    function drawTabs($tabs, $selectedTab, $rows = 1, $strict = true)
    {
        if($rows <0 or $rows>5)
            $rows = 1;

        $tabArray = array();

        if($rows == 1)
            $tabArray[] = $tabs;
        else
        {
            // divide tabs into rows
            if($strict)
            {
                // divide according to number of tabs
                $tabsPerRow = count($tabs) / $rows;

                $count = 0;
                $tabsLine = array();
                foreach($tabs as $tab)
                {
                    if($count>= $tabsPerRow)
                    {
                        // put the tabs into line, and move to next line
                        $tabArray[] = $tabsLine;
                        $tabsLine = array();
                        $count = 0;
                    }

                    $tabsLine[] = $tab;
                    $count++;
                }

                if(count($tabsLine) > 0)
                    $tabArray[] = $tabsLine;
            }
            else
            {
                // divide according to string length of tabs
                $totalStrLen = 0;
                foreach($tabs as $tab)
                    $totalStrLen += strlen($tab);

                $charsPerRow = $totalStrLen / $rows;

                $lineStrLen = 0;
                $tabsLine = array();
                foreach($tabs as $tab)
                {
                    $lineStrLen += strlen($tab);
                    $tabsLine[] = $tab;

                    if($lineStrLen >= $charsPerRow)
                    {
                        // put the tabs into line, and move to next line
                        $tabArray[] = $tabsLine;
                        $tabsLine = array();
                        $lineStrLen = 0;
                    }
                }

                if(count($tabsLine) > 0)
                    $tabArray[] = $tabsLine;
            }
        }

        print '<table width="100%" border="0" cellspacing="0" cellpadding="0">';

        for($i=0; $i<$rows; $i++)
        {
            if($i>0)
                print '<tr><td height="3" width="1" class="sideborders"><img src="'.QUnit_UI_TemplatePage::getImage('blank.gif').'" border="0" width="1" height="1"></td></tr>';

?>
        <tr>
            <td <?php echo $i>0 ? 'class="sideborders"': ''?> align="left">

            <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td class="tabSpacer">&nbsp;</td>

<?php
            // draw one tab line
            foreach($tabArray[$i] as $tab)
            {
                print '<td class="'.($tab[0] == $selectedTab ? 'tabLeftTab' : 'tabLeftTabDisabled').'">&nbsp;</td>';
                print '<td class="'.($tab[0] == $selectedTab ? 'tabContent' : 'tabContentDisabled').'" nowrap>&nbsp;&nbsp;'.$tab[1].'&nbsp;&nbsp;</td>';
                print '<td class="'.($tab[0] == $selectedTab ? 'tabRightTab' : 'tabRightTabDisabled').'">&nbsp;</td>';

                print '<td class="tabSpacer">&nbsp;</td>';
            }
?>
            </tr>
            </table>

            </td>
        </tr>
        <tr>
            <td class="tabLine"><img src="<?php echo  QUnit_UI_TemplatePage::getImage('blank.gif')?>" border="0" width="1" height="1"></td>
        </tr>

<?php
        }

        print '</table>';
    }

    //--------------------------------------------------------------------------

    function printPaging($page, $pages, $allCount, $formName = 'FilterForm')
    {
        echo ($page>0 ? "<a href='javascript:$formName.list_page.value=0; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('FirstPage.gif')."'>".($page>0 ? "</a>" : "")."&nbsp;&nbsp;";
        echo ($page>0 ? "<a href='javascript:$formName.list_page.value=".($page-1)."; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('PrevPage.gif')."'>".($page>0 ? "</a>" : "")."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        echo '<b>'.$allCount.'</b> '.L_G_RECORDSIN." <b>".($page*$_REQUEST["numrows"]+1)."&nbsp;-&nbsp;".((($page+1)*$_REQUEST["numrows"] < $allCount) ? ($page+1)*$_REQUEST["numrows"] : $allCount)."</b> ".L_G_RECORDS."&nbsp;&nbsp;&nbsp;&nbsp;".L_G_DI." <b>".($page+1)."</b>".L_G_PAGEFROM."<b>".$pages."&nbsp;".L_G_PAGE."</b>&nbsp;&nbsp;&nbsp;&nbsp;";
        echo L_G_ROWSPERPAGE."&nbsp;&nbsp;".
                '<select class="forminput" name=numrows onchange="javascript:'.$formName.'.list_page.value=0;'.$formName.'.numrows.value=this.value; '.$formName.'.submit();">
                    <option value=10 '.($_REQUEST["numrows"]==10 ? "selected" : "").'>10</option>
                    <option value=20 '.($_REQUEST["numrows"]==20 ? "selected" : "").'>20</option>
                    <option value=30 '.($_REQUEST["numrows"]==30 ? "selected" : "").'>30</option>
                    <option value=50 '.($_REQUEST["numrows"]==50 ? "selected" : "").'>50</option>
                    <option value=100 '.($_REQUEST["numrows"]==100 ? "selected" : "").'>100</option>
                    <option value=200 '.($_REQUEST["numrows"]==200 ? "selected" : "").'>200</option>
                    <option value=500 '.($_REQUEST["numrows"]==500 ? "selected" : "").'>500</option>
                    <option value=1000 '.($_REQUEST["numrows"]==1000 ? "selected" : "").'>1000</option>
                    <option value=100000000 '.($_REQUEST["numrows"]==100000000 ? "selected" : "").'>'.L_G_ALL.'</option>
                </select>';
        echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        echo ($page<$pages-1 ? "<a href='javascript:$formName.list_page.value=".($page+1)."; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('NextPage.gif')."'>".($page<$pages-1 ? "</a>" : "")."&nbsp;&nbsp;";
        echo ($page<$pages-1 ? "<a href='javascript:$formName.list_page.value=".($pages-1)."; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('LastPage.gif')."'>".($page<$pages-1 ? "</a>" : "")."&nbsp;&nbsp;";
    }

    //--------------------------------------------------------------------------

    function printSimplePaging($page, $pages, $allCount, $numRows, $formName = 'FilterForm')
    {
        echo ($page>0 ? "<a href='javascript:$formName.list_page.value=0; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('FirstPage.gif')."'>".($page>0 ? "</a>" : "")."&nbsp;&nbsp;";
        echo ($page>0 ? "<a href='javascript:$formName.list_page.value=".($page-1)."; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('PrevPage.gif')."'>".($page>0 ? "</a>" : "")."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        echo '<b>'.$allCount.'</b> '.L_G_RECORDSIN." <b> ".($page*$numRows+1)."&nbsp;-&nbsp;".((($page+1)*$numRows < $allCount) ? ($page+1)*$numRows : $allCount).'</b> '.L_G_RECORDS;
        echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        echo ($page<$pages-1 ? "<a href='javascript:$formName.list_page.value=".($page+1)."; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('NextPage.gif')."'>".($page<$pages-1 ? "</a>" : "")."&nbsp;&nbsp;";
        echo ($page<$pages-1 ? "<a href='javascript:$formName.list_page.value=".($pages-1)."; $formName.submit();'>" : "")."<img border=0 src='".QUnit_UI_TemplatePage::getImage('LastPage.gif')."'>".($page<$pages-1 ? "</a>" : "")."&nbsp;&nbsp;";
    }

    //--------------------------------------------------------------------------

    function printTimerange($dayName, $monthName, $yearName)
    {
?>
        <table border=0 cellspacing=0 cellpadding=0>
        <tr>
            <td align=left><?php echo L_G_FROM?>&nbsp;<?php echo L_G_DAY?></td>
            <td align=left>
            &nbsp;
            <select name="<?php echo $dayName?>1">
<?php            for($i=1; $i<=31; $i++) { ?>
              <option value='<?php echo $i?>' <?php echo ($i == $_REQUEST[$dayName.'1'] ? "selected" : "")?>><?php echo $i?></option>
<?php            } ?>
            </select>
            &nbsp;
            </td>
            <td align=left>&nbsp;<?php echo L_G_MONTH?>&nbsp;</td>
            <td align=left>
            &nbsp;
            <select name="<?php echo $monthName?>1">
<?php            for($i=1; $i<=12; $i++) { ?>
              <option value='<?php echo $i?>' <?php echo ($i == $_REQUEST[$monthName.'1'] ? "selected" : "")?>><?php echo $i?></option>
<?php            } ?>
            </select>
            &nbsp;
            </td>
            <td align=left>&nbsp;<?php echo L_G_YEAR?>&nbsp;</td>
            <td align=left>
            &nbsp;
            <select name="<?php echo $yearName?>1">
<?php            for($i=PAP_STARTING_YEAR; $i<=$this->a_curyear; $i++) { ?>
              <option value='<?php echo $i?>' <?php echo ($i == $_REQUEST[$yearName.'1'] ? "selected" : "")?>><?php echo $i?></option>
<?php            } ?>
            </select>
            &nbsp;
            </td>
        </tr>
        <tr>
            <td align=left><?php echo L_G_TO?>&nbsp;<?php echo L_G_DAY?></td>
            <td align=left>
            &nbsp;
            <select name="<?php echo $dayName?>2">
<?php            for($i=1; $i<=31; $i++) { ?>
              <option value='<?php echo $i?>' <?php echo ($i == $_REQUEST[$dayName.'2'] ? "selected" : "")?>><?php echo $i?></option>
<?php            } ?>
            </select>
            &nbsp;
            </td>
            <td align=left>&nbsp;<?php echo L_G_MONTH?>&nbsp;</td>
            <td align=left>
            &nbsp;
            <select name="<?php echo $monthName?>2">
<?php            for($i=1; $i<=12; $i++) { ?>
              <option value='<?php echo $i?>' <?php echo ($i == $_REQUEST[$monthName.'2'] ? "selected" : "")?>><?php echo $i?></option>
<?php            } ?>
            </select>
            &nbsp;
            </td>
            <td align=left>&nbsp;<?php echo L_G_YEAR?>&nbsp;</td>
            <td align=left>
            &nbsp;
            <select name="<?php echo $yearName?>2">
<?php            for($i=PAP_STARTING_YEAR; $i<=$this->a_curyear; $i++) { ?>
              <option value='<?php echo $i?>' <?php echo ($i == $_REQUEST[$yearName.'2'] ? "selected" : "")?>><?php echo $i?></option>
<?php            } ?>
            </select>
            &nbsp;
            </td>
        </tr>
        </table>
<?php
    }

    //-----------------------------------------------------------------------

    /** includes template
    *** parents - name  - to display
    ***         - id    - to identify parent
    */
    function printPath($parents = array(), $link_path = '#', $colspan = 1, $rootname = L_G_ROOT)
    {
        if(!is_array($parents)) $parents = array();

        $parents_path = '';
        foreach($parents as $node)
        {
            if($parents_path == '') $parents_path = $node['name'].'&nbsp';
            else $parents_path = '<a href="'.$link_path.$node['id'].'">'.$node['name'].'</a>&nbsp<img src="'.QUnit_UI_TemplatePage::getImage('farrow.png').'" border="10">&nbsp;'.$parents_path.'&nbsp;';
        }
        if($parents_path == '') $parents_path = '<b>'.$rootname.'</b>&nbsp;';
        else $parents_path = '<a href="'.$link_path.'"><b>'.$rootname.'</b></a>&nbsp<img src="'.QUnit_UI_TemplatePage::getImage('farrow.png').'" border="10">&nbsp;'.$parents_path;

        print '<tr>'.
        '<td colspan="'.$GLOBALS['colspan'].'">'.
        '<b>'.$GLOBALS['filtername'].'</b>&nbsp;'.$parents_path.
        '</td>'.
        '</tr>';
    }

    //--------------------------------------------------------------------------
    // $tabs - array of tabs
    //         $tab['id']       => id of tab
    //         $tab['caption']  => tab caption
    //         $tab['content']  => content of tab
    //         $tab['error']    => 1 if tab contains error
    //         $tab['disabled'] => 1 if tab is disabled
    //         $tab['onclick']  => additional onclick action

    function drawDivTabs($tabs, $preffix, $columnCount = 4, $width = 780, $bottomBorder = true, $drawBlank = true, $hideContent = false) {
        if (count($tabs) == 0) return;
        $height = 18;
        foreach ($tabs as $tab)
            if ($tab['icon'] != '') $height = 50;
        reset($tabs);
?>
        <input type="hidden" id="<?php echo $preffix?>sheet" name="<?php echo $preffix?>sheet" value="<?php echo $_REQUEST[$preffix.'sheet']?>">
        <table cellpadding="0" cellspacing="0" border="0" width="<?php echo $width?>">
        <tr><td><table cellpadding="0" cellspacing="0" border="0" width="100%">
                <tr>
<?php                  reset($tabs);
                    for ($row=0; $row < ceil(count($tabs)/$columnCount); $row++) { ?>
                        <tr>
<?php                          for ($column=0; $column < $columnCount; $column++) {
                                $tab = current($tabs);
                                if ( ($tab == '') || ($tab['disabled'] == '1') ) {
                                    if (!$drawBlank && $tab == '') { ?>
                                        <td width="<?php echo round(100/$columnCount, 0)?>%" valign="bottom"><table border="0" width="100%" cellpadding="0" cellspacing="0">
                                            <tr><td class="tabEdgeBorder4" width="3" height="1"></td></tr>
                                        </table></td>
                                    <?php } else { ?>
                                        <td width="3">
                                            <table width="3" height="<?php echo $height?>" cellpadding="0" cellspacing="0">
                                            <tr><td colspan="3" width="3" height="1"></td></tr>
                                            <tr><td></td><td colspan="2" class="tabEdgeBorder2"></td></tr>
                                            <tr><td></td><td class="tabEdgeBorder1"></td><td class="tabEdgeContentDisabled"></td></tr>
                                            <tr><td class="tabEdgeBorder3"></td><td colspan="2" class="tabEdgeContentDisabled"></td></tr>
                                        </table></td>
                                        <td class="tabContentDisabled" width="<?php echo round(100/$columnCount, 0)?>%">
                                            <?php echo ($tab != '') ? $tab['caption'] : ''?>&nbsp;</td>
                                        <td width="3">
                                            <table width="3" height="<?php echo $height?>" cellpadding="0" cellspacing="0">
                                            <tr><td colspan="3" width="3" height="1"></td></tr>
                                            <tr><td colspan="2" class="tabEdgeBorder2"></td><td></td></tr>
                                            <tr><td class="tabEdgeContentDisabled"></td><td class="tabEdgeBorder1"></td><td></td></tr>
                                            <tr><td colspan="2" class="tabEdgeContentDisabled"></td><td class="tabEdgeBorder3"></td></tr>
                                        </table></td>
                                    <?php }
                                    if ($tab['disabled'] == '1') next($tabs);
                                    continue;
                                } ?>
                                <td width="3" valign="top">
                                    <table width="3" height="<?php echo $height?>" cellpadding="0" cellspacing="0">
                                    <tr><td colspan="3" width="3" height="1"></td></tr>
                                    <tr><td></td><td colspan="2" class="tabEdgeBorder2"></td></tr>
                                    <tr><td></td><td class="tabEdgeBorder1"></td><td id="<?php echo $preffix.$tab['id']?>_left1" class="tabEdgeContent<?php echo ($_REQUEST[$preffix.'sheet'] == $tab['id']) ? '' : 'Disabled'?>"></td></tr>
                                    <tr><td class="tabEdgeBorder3"><img src="<?php echo $this->a_this->getImage("blank.gif")?>" width="1" height="100%"></td><td id="<?php echo $preffix.$tab['id']?>_left2" colspan="2" class="tabEdgeContent<?php echo ($_REQUEST[$preffix.'sheet'] == $tab['id']) ? '' : 'Disabled'?>"></td></tr>
                                    </table>
                                </td>
                                <td width="<?php echo round(100/$columnCount, 0)?>%" class="tabContent<?php echo ($_REQUEST[$preffix.'sheet'] == $tab['id']) ? '' : 'Disabled'?>" id="<?php echo $preffix.$tab['id']?>_content">
                                        <?php if ($tab['icon'] != '') { ?>
                                            <table border="0" cellspacing=0 cellpadding=0 width="100%">
                                            <tr>
                                              <td width=50>
                                                <a href="javascript: showTab('<?php echo $preffix?>', '<?php echo $tab['id']?>');" <?php echo ($tab['onclick'] == '') ? '' : 'onclick="'.$tab['onclick'].'"'?>>
                                                <img src="<?php echo $this->a_this->getImage($tab['icon'])?>" align="absmiddle"></a></td>
                                              <td class="tabContentText">
                                                <a href="javascript: showTab('<?php echo $preffix?>', '<?php echo $tab['id']?>');" <?php echo ($tab['onclick'] == '') ? '' : 'onclick="'.$tab['onclick'].'"'?>>
                                                <?php echo $tab['caption']?></a><br>
                                              <?php echo ($tab['error'] == '1') ? '<b class="errorMessage">! '.L_G_ERROR.' !</b>' : ''?>
                                              </td>
                                            </tr>
                                            </table>
                                        <?php } else {?>
                                            <a href="javascript: showTab('<?php echo $preffix?>', '<?php echo $tab['id']?>');" <?php echo ($tab['onclick'] == '') ? '' : 'onclick="'.$tab['onclick'].'"'?>>
                                            <?php echo $tab['caption']?></a>
                                            <?php echo ($tab['error'] == '1') ? '&nbsp;&nbsp;&nbsp;<b class="errorMessage">! '.L_G_ERROR.' !</b>' : ''?>
                                        <?php } ?>
                                    </td>
                                <td width="3" valign="top">
                                    <table width="3" height="<?php echo $height?>" cellpadding="0" cellspacing="0">
                                    <tr><td colspan="3" width="3" height="1"></td></tr>
                                    <tr><td colspan="2" class="tabEdgeBorder2"></td><td></td></tr>
                                    <tr><td id="<?php echo $preffix.$tab['id']?>_right1" class="tabEdgeContent<?php echo ($_REQUEST[$preffix.'sheet'] == $tab['id']) ? '' : 'Disabled'?>"></td><td class="tabEdgeBorder1"></td><td></td></tr>
                                    <tr><td id="<?php echo $preffix.$tab['id']?>_right2" colspan="2" class="tabEdgeContent<?php echo ($_REQUEST[$preffix.'sheet'] == $tab['id']) ? '' : 'Disabled'?>"></td><td class="tabEdgeBorder3"></td></tr>
                                    </table>
                                </td>
<?php                              next($tabs);
                            }
                    } ?>
                </tr>
                </table>
            </td>
        </tr>
<?php      if (!$hideContent) { ?>
        <tr><td class="settingtab" <?php echo (!$bottomBorder ? 'style="border-bottom: 0px;"' : '')?>>
<?php          foreach ($tabs as $tab) {
                ?><div id="<?php echo $preffix.$tab['id']?>" <?php echo ($_REQUEST[$preffix.'sheet'] == $tab['id']) ? '' : 'style="display: none;"'?>>
                    <?php if ($tab['description'] != '') { ?>
                        <div align="left" style="padding:5px 5px 5px 5px;"><?php echo $tab['description']?></div>
                    <?php } ?>
                    <?php echo $tab['content']?>
                </div><?php
            } ?>
            </td></tr>
<?php      } ?>
        </table>
<?php

    }

}

?>
