<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: class.setting.php,v2 11:46 2009-9-10 Lay $
*/

/*
	*
	PHP解析XML模板
	获取和设置XML节点
	用于修改和读取站点配置文件
	注意 xml 最好使用 utf-8 编码，这里会自动转编码
	*2008-4-3 
	*LIQUAN
	*eg.get config
	
	*$c = new Setting('templet.xslt','config.xml');
	* $c->transform();
	* $c->save();
	* $c->save();
*/

class Setting{
	private $xsl;
	private $xml;
	private $err=false;

	//构造函数
	function __construct($xsl,$xml){
		$this->xsl = $xsl;
		$this->xml = $xml;
		
		//检查文件
		if(!file_exists($this->xml) || !file_exists($this->xsl)){
			$this->err = true;
		}
	}

	//转换成HTML表单
	function transform(){
		
		global $_G;
		
		if($this->err) return 'File not found!';
		
		/*
		echo $this->xml;
		echo '<br />';
		
		echo $this->xsl;
		echo '<br />';
		*/
							
		// Load the XML source
		$xml = new DOMDocument;
		$xml->load($this->xml);

		$xsl = new DOMDocument;
		$xsl->load($this->xsl);

		// Configure the transformer
		$proc = new XSLTProcessor;
		$proc->importStyleSheet($xsl); // attach the xsl rules
		//$proc->setProfiling("/tmp/profile.txt");
		
		$proc->registerPHPFunctions();

		$result= $proc->transformToXML($xml);		
		
		//print_r(libxml_get_errors());
		//exit;
		
		//exit($result);
		
		//转编码
		if( $_G['product']['charset'] && $_G['product']['charset'] != "utf-8" ){
			$result = iconv("UTF-8",$_G['product']['charset'],$result);
		}
		
		//输出传换结果
		return $result;
	
	}
	

	//读取XML配置
	function get(){
		
		global $_G;
		
		if($this->err) return 'File not found!';
							
		//读取插件
		$xml = simplexml_load_file($this->xml);
		$dom = simplexml_import_dom($xml);
		
		$array = array();
		
		//遍历节点
		foreach ($dom->xpath('//key') as $key) {
			$name = $key['name'];
			$type = $key["type"];
			$format = $key["format"];
			
			switch($type){
				case "input":
				case "radio":
				case "hidden":
				case "select":
					$value = $key['value'];					
				break;
				
				case "checkbox":				
					$value = "";
					//遍历子元素
					foreach ($key->xpath('option') as $input) {

						if( $input["checked"] == "true" ){
							$value .= $input["value"].",";
						}						
					}
					$value = substr($value,0,-1);
				break;
				
				case "textarea":
					$value = $key;
				break;
			}
			
			//转编码
			if( $_G['product']['charset'] && $_G['product']['charset'] != "utf-8" ){
				$value = iconv("UTF-8",$_G['product']['charset'],$value);
			}
			
			$array[(string) $key['name']] = (string) $value;
			
		}
		
		return $array;		
	}

	//保存XML配置
	function save($method){
		
		global $_G;
		
		if($this->err) return 'File not found!';
		
		$query = ( $method=='POST'? $_POST : $_GET ) ;
							
		//读取插件
		$xml = simplexml_load_file($this->xml);
		
		$dom = simplexml_import_dom($xml);
		
		$dom["update"] = date("Y/m/d H:i:s");
		
		//遍历表单
		foreach ($dom->xpath('//key') as $key) {
			
			//转为字符
			$name = $key["name"];
			settype($name,"string");
			
			if( $name && isset($query[$name]) ){
			
				$type = $key["type"];
				$format = $key["format"];
				$default = $key["default"];
				
				//参数值
				$value = $query[$name];				
				
				//转编码
				if( $_G['product']['charset'] && $_G['product']['charset'] != "utf-8" ){
					$value = iconv($_G['product']['charset'],"UTF-8",$value);
				}
				
				//获取表单值
				if($format =="number"){
					$value = (integer) $value;
				}
				
				switch($type){
					case "input":
					case "radio":
					case "hidden":
					case "select":
						$key['value']=$value;
					break;
					
					case "checkbox":
						//遍历子元素
						foreach ($key->xpath('option') as $input) {
							$i_value = $input["value"];
							
							//echo $value." ==== ".$i_value;
							
							//if( strpos($value,$i_value) ){
							if( $value == $i_value ){
								$input['checked']="true";
							}else{
								$input['checked']="false";
							}
						}
						//exit();
					break;
					
					case "textarea":
						$value=stripslashes($value);
						
						$elm = dom_import_simplexml($key);
						
						/* 移除elm元素下的所有子元素*/ 
						while ($elm->firstChild) { 
							$elm->removeChild($elm->firstChild); 
						}
						
						//重建CDATA
						$elm->appendChild($elm->ownerDocument->createCDATASection( $value )); 
					break;
				}
			}
		}
		
		if( $dom->saveXML($this->xml) ){
			return true;
		}else{
			return false;
		}
	}

}
?>