<?php

/*

		用户收藏模块管理

*/

//载入全局配置和函数包
require_once dirname(__FILE__).'/../include/global.php';

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_G['product']['charset'];?>" />
<title>模块管理 - Powered By VeryIDE</title>

<?php

echo loader_style(array(VI_BASE."style/dialog.css"),$_G['product']['charset'],$_G['product']['version']);

echo loader_script(array(VI_BASE."js/mo.js",VI_BASE."js/mo.drag.js",VI_BASE."js/serv.dialog.js"),"utf-8",$_G['product']['version']);

?>

<script>

Mo.reader(function(){
				   
	if(window.Node){
		Node.prototype.swapNode=function(node)
		{
			var nextSibling=this.nextSibling;
			var parentNode=this.parentNode;
			node.parentNode.replaceChild(this,node);
			parentNode.insertBefore(node,nextSibling);
		}
	}

				   
	var func = function( ele, index , e ){

		//使其可以拖动
		var dg = new Mo.Drag( ele );
		
		//开始拖动
		dg.onStart = function( x, y, e ) {
			
			//鼠标位置
			var ms = Mo.Event( e ).mouse();
			
			//设置样式
			Mo( ele ).style({ "position":"absolute", "left":ms.x+"px", "top":ms.y+"px" });
			
			//在当前位置创建占位符
			Mo( ele ).insert( "li", { "id" : "engross",  "className" : "temp" } );
		};
		
		//开始拖动
		dg.onDrag = function( x, y, e ) {
			
			var self = this;
			
			var obj = find( e, self );
			
			if( obj && obj.id != "engross" ){
				
				//删除占位符
				Mo("#engross").remove();
			
				//在当前位置创建占位符
				Mo( obj ).insert( "li", { "id" : "engross",  "className" : "temp" } );
				
			}
			
		};
		
		//开始拖动
		dg.onEnd = function( x, y, e ) {
			
			if( Mo("#engross").size() ){
				
				//交换节点
				ele.swapNode( Mo("#engross").item(0) );
							
				//删除占位符
				Mo("#engross").remove();
				
			}
			
			//设置样式
			Mo( ele ).style({ "position":"" });	
			
			//去样式
			Mo("#addons li").attr({ "class":"" });	
			
			//保存排序
			parent.Serv.Addons.saved( loop() );
			
		};
		
		//
		var find = function( e, self ){
			
			var res = null;
			
			//鼠标位置
			var ms = Mo.Event( e ).mouse();
			
			//比较位置
			Mo("#addons li").each(function( ele, index ){
				
				//不能是自己或占位符
				if( ele == self ) return;
				
				var pos = Mo( ele ).position();
				
				//在区域内
				if( ms.x > pos.left && ms.x < pos.left + pos.width && ms.y > pos.top && ms.y < pos.top + pos.height ){
					//ele.className = "light";
					res = ele;
				}else{
					ele.className = "";
				}
				
			});
			
			return res;
		
		};
		
		//
		var loop = function(){
			
			var sort = [];
			
			Mo("#addons li").each( function( ele, index ){
	
				var appid   = this.getAttribute("appid");
				var appname = this.getAttribute("appname");
		
				sort.push( appid );
		
			});
			
			return sort;
		};
		
	};

	//高亮选中主题
	Mo("#addons li").bind( 'mousedown', function( ele, index , e ){
												 
		func( ele, index , e );
			
	}).bind( 'mousemove', function( ele, index , e ){
		
		func( ele, index , e );
			
	});
	
	//主框架载入事件
	Serv.Manager.Loaded();

});

</script>

</head>

<body>

    <div id="wrapper">

        <?php
    
        //未登录
        if( !$_SESSION['Manager']['id'] ){    
            exit('<div id="state" class="failure">未登录，请先登录！</div>');    
        }
    
        ?>
		
		<ul id="naver">
            <li><a href="module.php" ext-hash="true">快捷方式</a></li>
            <li><a href="widget.php" ext-hash="true">小工具</a></li>
            <li><a href="quick.php" ext-hash="true">排序</a></li>
            <li><a href="quick.v2.php" ext-hash="true">排序（方案2）</a></li>
		</ul>
    
        <ul id="addons">
    
        <?php
        
        //连接数据库
        System :: connect();
        
        //插件列表
        
        $sql="SELECT appid from `sys:quick` WHERE aid = '".$_SESSION['Manager']['id']."' ORDER BY sort asc, dateline asc";
        
        $res = System :: $db -> getAll( $sql );
        
        foreach( $res as $row ){
			
			//配置文件
			$self = VI_ROOT.'module/'.$row['appid'].'/config.php';
    
            //加载配置
            if ( file_exists( $self ) && require($self) ) {
            
                $app = $_G['module'][$row['appid']];
                
				echo '<li appid="'.$appid.'" appname="'.$app["name"].'">';

				echo '<a><img src="'.VI_BASE.'module/'.$appid.'/icon.png" /><span>'.$app["name"].'</span></a>';

				echo '</li>';
    
            }
        }
    
        //关闭数据库
        System :: connect();
    
        ?>
    
        </ul>
        
    </div>
    
</body>
</html>