<?php

//生成图片缩略图
function ResizeImage($im,$maxwidth,$maxheight,$name,$type,$clip='false',$x1=0,$y1=0,$clipwidth=0,$clipheight=0){
	//jpeg
	if(PHP_VERSION>="5.1.3"){
		ini_set('gd.jpeg_ignore_warning', 1);
	}
	
	//文件名
	$file_name=$im;
	
	//文件扩展名
	$file_type=fileext($file_name);
	
	//输出扩展名
	$res_type=$type;
	
	//产生错误
	$res_error=false;
	
	$res_array=array();
	
	//返回文件类型
	switch($file_type){
		case "gif":
			if(!$res_type){					$res_type="gif";				}
		
			$im = imagecreatefromgif($im);
		break;
		
		case "jpeg":
		case "jpg":
			if(!$res_type){					$res_type="jpg";				}
		
			$im = imagecreatefromjpeg($im);
		break;
		
		case "png":
			if(!$res_type){					$res_type="png";				}
		
			$im = imagecreatefrompng($im);
		break;
		
		case "bmp":
			if(!$res_type){					$res_type="bmp";			}
		
			$im = imagecreatefromwbmp($im);
		break;
		
		default:
			//没有处理图片
			$res_error=true;
	}
	
	//非图片
	if(!is_resource($im)){
		//新文件信息
		$res_array["name"]=$new_name;
		$res_array["type"]=$res_type;
		$res_array["width"]=$newwidth;
		$res_array["height"]=$newheight;
		$res_array["new"]=$new_img;
		$res_array["error"]=true;
		
		return $res_array;
	}

	
	
	//图片尺寸
	$width   =   imagesx($im);     
	$height   =   imagesy($im);
	
	
	//是否创建新图像
	$new_img=false;
	
	if(($maxwidth   &&   $width   >   $maxwidth)   ||   ($maxheight   &&   $height   >   $maxheight)){     
				  if($maxwidth   &&   $width   >   $maxwidth){     
						  $widthratio   =   $maxwidth/$width;     
						  $RESIZEWIDTH=true;     
				  }     
				  if($maxheight   &&   $height   >   $maxheight){     
						  $heightratio   =   $maxheight/$height;     
						  $RESIZEHEIGHT=true;     
				  }     
				  if($RESIZEWIDTH   &&   $RESIZEHEIGHT)   
					{     
						  if($widthratio   <   $heightratio)   
							  {     
											  $ratio   =   $widthratio;     
							  }   
					  else{     
								$ratio   =   $heightratio;     
							  }     
				  }   
			  elseif($RESIZEWIDTH)   
			{     
					$ratio   =   $widthratio;     
			}elseif($RESIZEHEIGHT)   
			{     
				  $ratio   =   $heightratio;     
			  }     
			  
		$newwidth   =   $width   *   $ratio;     
		$newheight   =   $height   *   $ratio;  
		
		//区域切图
		if($clip!='false'){
		
			/*
			使用 imagecreatetruecolor 透明图片会有黑色背景
			使用 imagecreate 处理 jpg 格式图片有严重失真
			*/
			if($res_type=="png"){
				$newim   =   imagecreate($maxwidth,   $maxheight);
			}else{
				$newim   =   imagecreatetruecolor($maxwidth,   $maxheight);     
			}
		
		}else{
		
			if($res_type=="png"){
				$newim   =   imagecreate($newwidth,   $newheight);
			}else{
				$newim   =   imagecreatetruecolor($newwidth,   $newheight);     
			}
		
		}
	   
		if(function_exists("imagecopyresampled")){
			
			//区域切图
			if($clip!='false'){
			
				//成比例缩放
				if($clipwidth && $clipheight){
					//临时缩放图
					if($res_type=="png"){
						$zoomim   =   imagecreate($clipwidth,   $clipheight);
					}else{
						$zoomim   =   imagecreatetruecolor($clipwidth,   $clipheight);     
					}
					imagecopy ($zoomim, $im, 0, 0, $x1, $y1,  $clipwidth, $clipheight );
				
					imagecopyresampled($newim,   $zoomim,   0,   0,   0,   0,   $maxwidth,   $maxheight,   $clipwidth,   $clipheight);
					
					//销毁$zoomim
					ImageDestroy($zoomim);
					
					//返回尺寸
					$newwidth=$maxwidth;
					$newheight=$maxheight;
				}else{
					//无缩放
					imagecopy ($newim, $im, 0, 0, $x1, $y1,  $maxwidth, $maxheight );
				}

			}else{
				
				imagecopyresampled($newim,   $im,   0,   0,   0,   0,   $newwidth,   $newheight,   $width,   $height);
			}
		}else{     
			
			//区域切图
			if($clip!='false'){
				
				//成比例缩放
				if($clipwidth && $clipheight){
					//临时缩放图
					if($res_type=="png"){
						$zoomim   =   imagecreate($clipwidth,   $clipheight);
					}else{
						$zoomim   =   imagecreatetruecolor($clipwidth,   $clipheight);     
					}
					imagecopy ($zoomim, $im, 0, 0, $x1, $y1,  $clipwidth, $clipheight );
				
					imagecopyresampled($newim,   $zoomim,   0,   0,   0,   0,   $maxwidth,   $maxheight,   $clipwidth,   $clipheight);
					
					//销毁$zoomim
					ImageDestroy($zoomim);
					
					//返回尺寸
					$newwidth=$maxwidth;
					$newheight=$maxheight;
				}else{
					imagecopy ($newim, $im, 0, 0, $x1, $y1,  $maxwidth, $maxheight );
				}
				
			}else{
				imagecopyresized($newim,   $im,   0,   0,   0,   0,   $newwidth,   $newheight,   $width,   $height); 
			}
		}
		
		$new_img=true;
	}else{     
		$newim = $im;
		
		//没有处理图片
		$res_error=true;
	}
	
	//销毁$im
	ImageDestroy($im);
	
	//新图片名
	if($name && $type){
		$new_name=$name . $type;
	}else{
		if($name){
			$new_name=$name;
		}else{
			$new_name=$file_name;
		}
	}
	
	switch($res_type){
		case "gif":
			ImageGif($newim,$new_name);
		break;
		
		case "jpg":
			ImageJpeg($newim,$new_name);
		break;
		
		case "bmp":
			ImagewBmp($newim,$new_name);
		break;
		
		case "png":
			//取消默认的混色模式
			imagealphablending($newim, FALSE);
			
			//设定保存完整的 alpha 通道信息
			imagesavealpha($newim,TRUE);
		
			ImagePng($newim,$new_name);
		break;
		
		default:
			//没有处理图片
			$res_error=true;
	}
	
	//销毁$newim
	if(is_resource($newim)){
		ImageDestroy($newim);
	}

	//新文件信息
	$res_array["name"]=$new_name;
	$res_array["type"]=$res_type;
	$res_array["width"]=$newwidth;
	$res_array["height"]=$newheight;
	$res_array["new"]=$new_img;
	$res_array["error"]=$res_error;
	
	return $res_array;
}     

?>