<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: veryide_files.php,v2 19:47 2008-2-21 Lay $
*/

require '../../include/loader.php';

html_start("数据备份 - VeryIDE");
?>

<!--body start-->
    
	<script type="text/javascript">
	//if( parent.parent.Mo.store.model == "modern" ){
		Mo("#wrapper").attr({"class":"snugly"});
	//}
	</script>

    
	<?php

    //延长程序运行时间
    set_time_limit(0);
    
    //载入类库
    require_once VI_ROOT."class/database.php";
    
	//备份基准目录
    $base = Database :: direct('backup');
    
    $action = getgpc('action');
    
    if($action){

		//连接数据库
		System :: connect();
    
        switch($action){
        
            case "execute":
    
                //检查权限
                $func = "sys-backup-exe";
                System :: check_func( $func, false );
				
				$update = getgpc("update");
                $sqlfile = $base.$update;
                
                //锁文件
                $lock = str_replace(".sql",".lock",$sqlfile);
                
                if(file_exists($lock)){
                    
                    echo '<div id="state" class="failure">抱歉！安装已经存在。更新于早前已经安装，并在使用中：<span class="text-key">'.$update.'</span></div>';
                    
                }else{
                    
                    if(file_exists($sqlfile)){
                    
                        $sql = file_get_contents($sqlfile);
                    
                        $res = Database :: import( $sql );
                        
                        if( $res['error'] ){
                        
                            echo '<div id="state" class="failure">抱歉！安装更新失败。以下是本错误信息详细报告：</div>';

                            trigger_error(str_replace('class="error"','class="text-no"',preg_replace('/<h4>(.*?)<\/h4>/','',$array[1])), E_USER_ERROR);
                        
                        }else{
                        
                            //写入锁
                            create_file( $lock ,date("Y-m-d H:i:s"));
                        
                            echo '<div id="state">恭喜！成功安装更新：'.$update.'，您刚才的操作可能全影响到系统菜单的显示，请刷新查看最新菜单：<input name="submit" onclick=\'parent.location.reload(true)\' type="button" class="submit" value="显示新菜单" /></div>';
                            
                            //搜索模块
                            Module :: search();
                
                            //写入日志
                            System :: insert_event($func,time(),time(),"恢复备份：".$update);
                           
                        }
                        
                    }
                    
                }
                
                //echo $update;
            break;
            
            case "create":
    
                //检查权限
                $func = "sys-backup-add";
                System :: check_func( $func, false );
            
                $name = $_POST["name"];
                
                if (!$name ){
                    
                    System :: redirect($jump,"备份名称不能为空！");
                    
                }elseif ( !preg_match('/^[^\/\\\?!\*]+$/',$name) ){
                    
                    System :: redirect($jump,"备份名称中有非法字符！");
                    
                }else{
					
					$stat = Database :: export( $name );
                                            
                    if( $stat ){
            
                        //写入日志
                        System :: insert_event($func,time(),time(),"数据备份：". $name.".sql" );				
                        
                        echo '<div id="state">恭喜！成功备份数据库，共有 '.$stat.' 条记录。</div>';
                                
                    }else{
                        
                        echo '<div id="state" class="failure">抱歉！备份数据库失败。请确认 backup/ 目录有写权限。</div>';
                    }
                    
                }
            
            break;
        }
	
		//关闭数据库
		System :: connect();

    }
    
    ?>

	<div id="box">
	
	<div class="item">数据备份清单</div>

    <table width="100%" border="0" cellpadding="1" cellspacing="1" class="table">
      <tr class="title">
        <td>ID</td>
        <td>备份文件</td>
        <td>文件大小</td>
        <td>备份时间</td>
        <td width="100">执行操作</td>
      </tr>
    <?php
	
	$list = loop_file( $base, array(), array('sql') );
	
	$x = 1;
    
	foreach( $list as $file ){
		
		//锁文件
		$lock = str_replace(".sql",".lock",$file);
		$val = file_exists($base.$lock);
		
		echo ("<tr class='". zebra( $i, array( "line" , "band" ) ) ."'>");
		echo ('<td>'.( $x++ ).'</td>');
		echo ('<td class="text-yes">'.$file.'</td>');
		
		echo ("<td>".sizecount(filesize($base.$file))."</td>");
		echo ("<td>".date("Y-m-d H:i:s",filemtime($base.$file))."</td>");
		
		echo '<td width="150">';
			
		if( System :: check_func( 'sys-backup-exe' ) ){
			echo '<input name="" value="执行" type="button" class="button" onclick="location.href=\'?action=execute&update='.$file.'\';" />';	
		}
	
		if( System :: check_func( 'sys-backup-dow' ) ){
			echo '<input name="" value="下载" type="button" class="button" onclick="location.href=\''.VI_BASE.'data/backup/'.$file.'\';" />';	
		}
	
		echo '</td>';
	
		echo ("</tr>");

	}
	
	if( count( $list ) == 0 ){
		echo '<tr>     <td colspan="6" class="notice">备份清单暂时没有记录</td>      </tr>';
	}
    
    ?>
	</table>

    
	<?php
    if( System :: check_func( 'sys-backup-add' ) ){
    ?>
    
    <div class="item">创建数据备份</div>

    <form action="" method="post" name="backup">
    
    <table cellpadding="0" cellspacing="0" class="form">
    
        <tr><td colspan="2" class="section">注意: 将只对数据库进行备份，并以将 SQL 语句以文件形式存储。</td></tr>
        
        <tr>
            <td width="60"><strong>备份名称：</strong></td>
            <td>
                <input name="name" type="text" class="text" id="name" size="35" fix_name="备份名称" fix_null="yes" />
                <a href="javascript:void(0);" onclick="Mo('input[name=name]').value(this.innerHTML);void(0);"><?php echo date("Y-m-d");?></a>
            </td>
        </tr>
        <tr class="nobr">
            <td><strong></strong></td>
            <td>
                <input name="action" type="hidden" id="action" value="create" />
                <input type="submit" name="Submit" value="创建此备份" class="submit" />
            </td>
        </tr>
    
    </table>
    
    </form>
    
    <script type="text/javascript">

        //绑定表单事件
        Mo("form[name=backup]").bind( 'submit', function( index , e ){
    
			var result = Mo.Form( this, function(x){
				Mo.Message("wrong",'<div class="s"></div><div class="c">'+x+'</div><div class="e"></div>', 3, { "unique" : "message", "center" : true });
			});
			
			//将密码加密
			return result &&  Mo.Message("info",'<div class="s"></div><div class="c">正在执行操作，请稍后…</div><div class="e"></div>', 30, { "unique" : "message", "center" : true });
    
        });
    
    </script>

    
	<?php
    }
    ?>
    
    </div>
	
</div>

<!--body end-->

<?php html_close();?>