<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: veryide_files.php,v2 19:47 2008-2-21 Lay $
*/

require '../../include/loader.php';

html_start("模块管理 - VeryIDE");
?>

<!--body start-->
	<?php
    
	//连接数据库
	System :: connect();
	
	$action = getgpc('action');
	$module = getgpc("module");
	
	if($action){
	
		switch($action){
			
			//安装模块
			case "install":
		
				//检查权限
				$func = "sys-module-add";
				System :: check_func( $func, false );
				
				$res = Module :: install( $module, $func );
				
				switch( $res ){					
					case 'lock':
						echo '<div id="state" class="failure">抱歉！当前模块已安装（'.$module.'）</div>';
					break;
					
					case 'exec':
						echo '<div id="state" class="failure">抱歉！未找到安装脚本（'.$module.'）</div>';
					break;
					
					case 'stop':
						echo '<div id="state" class="failure">抱歉！安装模块（'.$module.'）失败，以下是本错误信息详细报告：</div>';
					break;
					
					case 'done':
						echo '<div id="state">恭喜！成功安装模块（'.$module.'）</div>';
					break;					
				}
				
			break;
			
			//卸载模块
			case "uninstall":
		
				//检查权限
				$func = "sys-module-del";
				System :: check_func( $func, false );
				
				$res = Module :: uninstall( $module, $func );
				
				switch( $res ){					
					case 'lock':
						echo '<div id="state" class="failure">抱歉！当前模块已卸载（'.$module.'）</div>';
					break;
					
					case 'exec':
						echo '<div id="state" class="failure">抱歉！未找到卸载脚本（'.$module.'）</div>';
					break;
					
					case 'stop':
						echo '<div id="state" class="failure">抱歉！卸载模块（'.$module.'）失败，以下是本错误信息详细报告：</div>';
					break;
					
					case 'done':
						echo '<div id="state">恭喜！成功卸载模块（'.$module.'）</div>';
					break;					
				}
				
			break;			
			
			//禁用模块
			case "disabled":
		
				//检查权限
				$func = "sys-module-dis";
				System :: check_func( $func, false );
				
				Module :: set_state( $module, false );				
				
			break;
			
			//启用模块
			case "enabled":
		
				//检查权限
				$func = "sys-module-ena";
				System :: check_func( $func, false );
				
				Module :: set_state( $module, true );
				
			break;
			
			//搜索模块
			case "search":				
				Module :: search();
			break;
			
		}
	
		//关闭数据库
		System :: connect();
		
		//加载模块缓存
		Module :: get_list();
		
		if( $action != "install" && $action != "uninstall" ){		
			echo '<div id="state">正在使用模块管理工具，您刚才的操作已经成功执行</div>';		
		}

	}

    ?>
    
    <ul id="module">
    
    <?php
    if( count( $_CACHE['system']['module'] ) == 0 ){
    ?>
    
        <p>
            <button class="submit" type="button" onclick="parent.Serv.Apps.open('system','模块管理','calculator','system.module.php');parent.Serv.store.module.Remove();">模块搜索</button>
        </p>
        
    <?php
    }
    ?>

    <?php
    
    $i = 1;

    //遍历模块
    foreach( $_CACHE['system']['module'] as $appid=>$val ){
		
		//当前模块目录
		$base = VI_ROOT . 'module/'. $appid .'/';
    
		//配置文件
		$self = $base.'config.php';
		
		//加载模块配置
		file_exists( $self ) && require_once $self;

		$app = isset( $_G['module'][$appid] ) ? $_G['module'][$appid] : array('name'=>$appid);
		
		echo '<li'.( $i % 2 == 0 ? ' class="zebra"' : '' ).'>';
		
		echo '
			<div class="icon">
				<img src="'.VI_BASE.'module/'.$appid.'/icon.png" />
			</div>';
			
		echo '<div class="name">
				<strong>'.$app["name"].'</strong> '.( $app["version"] ? '<span>'.$app["version"].'</span>' : '' ).'
				<br />
				'.$app["describe"].'
			</div>';
                    
		echo '<div class="site">
				'.$app["author"].'
				<br />
				<a href="'.$app['support'].'" target="_blank">'.$app['support'].'</a>
			</div>';
			
		echo '<div class="site">';
		
			if( file_exists($base.'/install.sql') && !file_exists($base.'/install.lock') ){
				
				echo '<button type="button" onclick="location.href=\'?action=install&module='.$val["appid"].'\';">安装</button>';
				
			}elseif( file_exists($base.'/uninstall.sql') && !file_exists($base.'/uninstall.lock') ){
				
				echo '<button type="button" class="added" onclick="if(confirm(\'确定要卸载此模块吗？\n\n同时删除相关数据库\')){location.href=\'?action=uninstall&module='.$val["appid"].'\';}">卸载</button>';
				
			}elseif( file_exists($base.'/install.lock') ){
				
				echo '<button type="button" class="added">已安装</button>';
				
			}
	
		echo '</div>';
			
		echo '<div class="plus">';
		
			if( $val["config"] && $_G['module'][$appid]['model'] == "module" ){
			
				//
				if($val["state"]){
					
					echo '<button type="button" class="added" onclick="location.href=\'?action=disabled&module='.$val["appid"].'#appid-'.$val["appid"].'\';">禁用</button>';
					
				}else{
					
					echo '<button type="button" onclick="location.href=\'?action=enabled&module='.$val["appid"].'#appid-'.$val["appid"].'\';">启用</button>';
					
				}
			
			}
				
		echo '</div>';
			
		echo '</li>';
		
		$i++;
		
    }

    ?>

    </ul>
	
	<div id="saving">
    	<span class="action">
        	<input name="submit" onclick='location.href="?action=search"' type="button" class="button" value="搜索模块" />
        </span>
		共找到模块 <?php echo count($_CACHE['system']['module']);?> 个
	</div>

<!--body end-->

<?php html_close();?>