<?php

//载入全局配置和函数包
require '../../../include/global.php';
require '../../../include/cacher.php';

//载入模块配置和函数包
Module :: loader( 'vote' );
Module :: loader( 'analytic' );

//当前 APPID
$appid = Module :: get_appid();

/////////////////////////////////////////////
	
//获取参数
$mode = getgpc("mode");
$action = getgpc('action');
$do = getgpc('do');
$fid = getnum('id',0);

//加载缓存
if( !Cached :: loader($appid,"form.".$fid) || !isset($_CACHE[$appid]['form']) ){
	exit('Cache Error!');
}

//回收站中
if( $_CACHE[$appid]['form']['state'] == -1 ){
	exit('Forbidden');	
}

$skin = $_CACHE[$appid]['form']['skin'];

//连接数据库
System :: connect();
		
////////// 载入通行证 ////////////

if( $_G['licence']['type'] != 'free' ){
	
	//载入函数包
	Module :: loader( 'passport' );
	
	//重定义模板
	if( $_G['setting'][$appid]['templet'] ) $_G['setting']['passport']['theme'] = $_G['setting'][$appid]['templet'];
	$_G['setting']['passport']['hidenaver'] = $_CACHE[$appid]['form']['config']['HIDE_NAVER'];
	$_G['setting']['passport']['hideright'] = $_CACHE[$appid]['form']['config']['HIDE_RIGHT'];
	
	//主动初始用户信息
	Passport :: check( false, false );
}

////////// 验证模板 ////////////

if ( !file_exists( 'theme/'.$skin.'/index.htm' ) ) {
	$skin = 'default';
}

/////////////////////////////////////////////
	
//加载 Smarty 类
require VI_ROOT.'smarty/Smarty.class.php';

$smarty = new Smarty;

//模板路径
$smarty->template_dir = 'theme/'.$skin.'/';

//编译路径
$smarty->compile_dir = create_dir( VI_ROOT.'static/'.$appid );

//编译编号（防止冲突）
$smarty->compile_id = $skin;

$smarty->compile_check = true;

$smarty->debugging = false;

/////////// 全局变量 //////////

//系统变量
$smarty->assign("_G",$_G);


//当前页面绝对地址
$smarty->assign("SELF",GetAbsUrl());

//前台目录绝对地址
$smarty->assign("Index", Module :: get_index($appid) );

//随机颜色函数
$smarty->register_function('color',"rand_color");

//随机颜色函数
$smarty->register_function('option',array('Vote','parse_option'));

//公共导航
$smarty->assign("Naver",Module :: hooks_slice('passport/naver'));

/////////// 表单变量 //////////

//重组选项组配置
foreach( $_CACHE[$appid]['group'] as $gid => $group ){
	
	$_CACHE[$appid]['group'][$gid]["description"] = stripslashes( nl2br( ubb_basic($group["description"] ) ) );
	
	//计算表格宽度
	if( $_CACHE[$appid]['group'][$gid]["config"]["GROUP_BREAK"] ){
		$_CACHE[$appid]['group'][$gid]["width"] = floor(100 / $_CACHE[$appid]['group'][$gid]["config"]["GROUP_BREAK"]) . "%";
	}
	
}

//处理描述内容
$_CACHE[$appid]['form']["description"] = Module :: parse_form($_CACHE[$appid]['form']);

//处理表单配置
$config = $_CACHE[$appid]['form']["config"];

//////////
	
//随机排序
if( $config["FORM_RAND_GROUPS"] == "Y" ){	
	$_CACHE[$appid]['group'] = rand_array($_CACHE[$appid]['group']);
}

if( $config["FORM_RAND_OPTION"] == "Y" ){	
	$_CACHE[$appid]['option'] = rand_array($_CACHE[$appid]['option']);
}

//统计总数
if( $config["HIDE_COUNT"] != "Y" ){
	$_CACHE[$appid]['form']["stat"] = System :: $db -> getValue( "SELECT `stat` from `mod:form` WHERE id=".$fid );
}

//统计子项
if( $action != "post" ){

	$opt = System :: $db -> getAll( "SELECT id,gid,stat from `mod:option` WHERE state>0 and fid=".$fid );
	
	//重组选项组配置
	foreach( $opt as $row ){
	
		$_CACHE[$appid]['option'][ $row['gid'] ][ $row['id'] ]["description"] = stripslashes( nl2br( ubb_basic( $_CACHE[$appid]['option'][ $row['gid'] ][ $row['id'] ]["description"] )) );
	
		//从二级缓存中读取
		$_CACHE[$appid]['option'][ $row['gid'] ][ $row['id'] ]["stat"] = $row['stat'];
	}
	
}

//排名排序
$fied = getgpc('fied');
$fied = $fied ? $fied : 'stat';

$sort = getgpc('sort');
$sort = $sort ? $sort : $config["FORM_SORT"];

$limit = getnum('limit',0);

if( $sort ){

	$smarty->assign("fied", $fied );
	$smarty->assign("sort", $sort );
	
	foreach( $_CACHE[$appid]['option'] as $gid => $group ){
		
		multi_sort( $_CACHE[$appid]['option'][$gid], $fied, $sort );

		if( $limit > 0 ){
			$_CACHE[$appid]['option'][$gid] = array_slice( $_CACHE[$appid]['option'][$gid], 0, $limit );
		}
	}
	
}

//////////

//表单模式
$smarty->assign("mode",$mode);

//表单模式
$smarty->assign("appid",$appid);

//动作名称
$smarty->assign("action",$action);

//表单名称
$smarty->assign("Member", $_SESSION['Member']['id'] && $_G['licence']['type'] != 'free' ? Passport :: member( $_SESSION['Member']['id'] ) : array() );

/////////// 个性化 //////////
	
//背景图片
if( !empty($config["PAGE_BG"]) || !empty($config["PAGE_BG_COLOR"]) ){
	$bg = "background:".$config["PAGE_BG_COLOR"].( $config["PAGE_BG"] ? " url(".$config["PAGE_BG"].") " : "" ).$config["PAGE_BG_REPEAT"]." ".$config["PAGE_BG_ATTACHMENT"]." ".$config["PAGE_BG_X"]." ".$config["PAGE_BG_Y"].";";
}

//主体透明
if( !empty($config["PAGE_BG_OPACITY"]) ){
	$op = "filter:alpha(opacity=".$config["PAGE_BG_OPACITY"].");opacity:".($config["PAGE_BG_OPACITY"]/100).";";
}

//页面宽度
if( !empty($config["PAGE_WIDTH"]) ){
	$op .= "width:".$config["PAGE_WIDTH"].$config["PAGE_UNIT"].";";
}

//背景音乐
if( !empty($config["PAGE_SOUND"]) && !$action ){
	$bs = '<bgsound src="'.$config["PAGE_SOUND"].'" autostart="true" loop="'.$config["PAGE_SOUND-LOOP"].'" />';
}

//背景图片
$smarty->assign("background", $bg );

//背景音乐
$smarty->assign("bgsound", $bs );

//页面主体
$smarty->assign("main", $op );

//处理动作
switch( $action ){

	//首页
	case '':
	
		if( !function_exists("mcrypt_module_open") ){
			exit('mcrypt module error');	
		}
	
		//验证码名称
		$captcha = rand_string(10);
	
		//随机验证
		$verify = $_SESSION["verify"] = rand_string(10);
		
		$hash = array("time"=>time(),"ip"=>GetIP(),"captcha"=>$captcha,"verify"=>$verify);		
		$keys = authcrypt( serialize($hash), VI_START );
	
		//表单验证
		$smarty->assign("keys",$keys);
	
		//表单验证
		$smarty->assign("captcha",$captcha);
		
		///////////////////////////////////////
		
		//分页参数
		$gid  = getnum('gid',0);
		$page = getpage("page");
		
		//重组选项组配置
		foreach( $_CACHE[$appid]['group'] as $g => $group ){
		
			if( $group['config']['GROUP_SIZE'] ){
		
				//取出部分（仅对当前有效）
				$count = Vote :: slice( $g, ( $gid == $g ? $page : 1 ), intval( $group['config']['GROUP_SIZE'] ) );
				
				//分页链接
				$url="?id=".$fid."&gid=".$g."&fied=".$fied."&sort=".$sort."&page=";
				
				//生成链接
				$_CACHE[$appid]['group'][$g]["multi"] = multipage( $page, $count, $group['config']['GROUP_SIZE'], $url, "pp-page" );
			
			}
			
		}
		
		//统计系统
		Analytic :: ping( $appid, $fid, 'views' );
	
	break;

	//提交表单
	case "post":
		require 'include.post.php';
	break;
	
	//投票报名
	case "join":
		require 'include.join.php';
	break;

	//用户结果
	case "state":
		require 'include.state.php';
	break;
	
	//详细信息
	case "detail":
		include("include.detail.php");
	break;

}

$appid = 'vote';

//表单结构
$smarty->assign("form", $_CACHE[$appid] );

////////////////////////////

//用户登录验证
if( $_G['licence']['type'] != 'free' && $config['USER_MODE'] == "REG" && !in_array( $action , array('result','state') ) ){

	//载入会员配置
	require VI_ROOT.'module/member/config.php';

	$arr = array();
	
	//记录需要更新的字段
	foreach ($_G['module']['member']["fieds"] as $fied => $name){				
		if( $config["REG_".strtoupper($fied)] ){
			$arr[] = $fied;
		}					
	}
	
	//更新特定字段
	if( count($arr) ){				
		//显示登录窗口，并需要更新资料
		$LOGIN = Passport :: check( true , "['". implode("','",$arr) ."']" );
	}else{
		//显示登录窗口
		$LOGIN = Passport :: check( true , false );				
	}
				
}

//脚本资源
$smarty->assign("script", array(VI_HOST."js/mo.js",VI_HOST."js/mo.ajax.js",VI_HOST."js/mo.ui.js",VI_HOST."js/mo.effect.js",VI_HOST."js/mo.drag.js",VI_HOST."js/mo.form.js",VI_HOST."js/mo.lazy.js") );

//分组类型
$smarty->assign("LOGIN", $LOGIN );

$smarty->display('index.htm');

////////////////////////////

//关闭数据库
System :: connect();
	
?>