<?php
/* 
*  cache
*  ߣ
* ϵ䣺kingerq AT msn DOT com
* ʱ䣺2006-05-05
* ʵ 
include( "cache.php" ); 
$cache = new cache(30);
$cache->cacheCheck();
echo date("Y-m-d H:i:s"); 
$cache->caching();
*/
class cache {
	//Ŀ¼
	var $cacheRoot = "./cache/";
	//ʱ0Ϊ
	var $cacheLimitTime = 0;
	//ļ
	var $cacheFileName = "";
	//չ
	var $cacheFileExt = "php";
	
	/*
	   * 캯
	   * int $cacheLimitTime ʱ
	   * str $cacheRoot		 Ŀ¼
	*/
	function cache( $cacheLimitTime, $cacheRoot="" ) {
	   if( $cacheRoot ){
	   	$this->cacheRoot = $cacheRoot;
	   }
	
	   if( intval( $cacheLimitTime ) ) 
	   $this->cacheLimitTime = $cacheLimitTime;
	   $this->cacheFileName = $this->getCacheFileName();
	   ob_start();
	}
	
	/*
	   * 黺ļǷøʱ֮
	   * أڸʱ֮򷵻ļݣ֮򷵻ʧ
	*/
	function cacheCheck(){
	   if( file_exists( $this->cacheFileName ) ) {
		   $cTime = $this->getFileCreateTime( $this->cacheFileName );
		   if( $cTime + $this->cacheLimitTime > time() ) {
			   echo file_get_contents( $this->cacheFileName );
			   ob_end_flush();
			   exit;
		   }
	   }
	   return false;
	}
	
	/*
	   * ļ̬
	   * string $staticFileName ̬ļ·
	*/
	function caching( $staticFileName = "" ){
	   if( $this->cacheFileName ) {
	   $cacheContent = ob_get_contents();
	   //echo $cacheContent;
	   ob_end_flush();

	   if( $staticFileName ) {
		   $this->saveFile( $staticFileName, $cacheContent );
	   }

	   if( $this->cacheLimitTime )
		   $this->saveFile( $this->cacheFileName, $cacheContent );
	   }
	}
	
	/*
	   * ļ
	   * string $fileName ָļ()allȫ
	   * أɹtrue֮false
	*/
	function clearCache( $fileName = "all" ) {
	   if( $fileName != "all" ) {
	   $fileName = $this->cacheRoot . strtoupper(md5($fileName)).".".$this->cacheFileExt;
	   if( file_exists( $fileName ) ) {
		   return @unlink( $fileName );
	   }else return false;
	   }
	   if ( is_dir( $this->cacheRoot ) ) {
		   if ( $dir = @opendir( $this->cacheRoot ) ) {
			   while ( $file = @readdir( $dir ) ) {
			   $check = is_dir( $file );
			   if ( !$check )
			   @unlink( $this->cacheRoot . $file );
			   }
			   @closedir( $dir );
			   return true;
		   }else{
			   return false;
		   }
	   }else{
		   return false;
	   }
	}
	
	/*
	   * ݵǰ̬ļɻļ
	*/
	function getCacheFileName() {
	   return $this->cacheRoot . strtoupper(md5($_SERVER["REQUEST_URI"])).".".$this->cacheFileExt;
	}
	
	/*
	   * ļʱ
	   * string $fileName ļ·
	   * أļʱļڷ0
	*/
	function getFileCreateTime( $fileName ) {
	   if( ! trim($fileName) ) return 0;

	   if( file_exists( $fileName ) ) {
		   return intval(filemtime( $fileName ));
	   }else return 0;
	}
	
	/*
	   * ļ
	   * string $fileName ļ·
	   * string $text ļ
	   * أɹtureʧܷfalse
	*/
	function saveFile($fileName, $text) {
	   if( ! $fileName || ! $text ) return false;

	   if( $this->makeDir( dirname( $fileName ) ) ) {
		   if( $fp = fopen( $fileName, "w" ) ) {
			   if( @fwrite( $fp, $text ) ) {
				   fclose($fp);
				   return true;
			   }else {
				   fclose($fp);
				   return false;
			   }
		   }
	   }
	   return false;
	}
	
	/*
	   * Ŀ¼
	   * string $dir Ŀ¼ַ
	   * int $mode Ȩ
	   * أ˳ȫѽtrueʽfalse
	*/
	function makeDir( $dir, $mode = "0777" ) {
	   if( ! $dir ) return 0;
	   $dir = str_replace( "\\", "/", $dir );
	   
	   $mdir = "";
	   foreach( explode( "/", $dir ) as $val ) {
		   $mdir .= $val."/";
		   if( $val == ".." || $val == "." || trim( $val ) == "" ) continue;
		   
		   if( ! file_exists( $mdir ) ) {
			   if(!@mkdir( $mdir, $mode )){
			   return false;
			   }
		   }
	   }
	   return true;
	}
}
?>