<?php

/*
*	Copyright VeryIDE,2007-2010
*	http://www.veryide.com/
*
*	$Id: class.setting.php,v2 11:46 2009-9-10 Leilei $
*/

/*
	*
	PHPXMLģ
	ȡXMLڵ
	޸ĺͶȡվļ
	ע xml ʹ utf-8 룬Զת
	*2008-4-3 
	*LIQUAN
	*eg.get config
	
	*$c = new Setting('templet.xslt','config.xml');
	* $c->transform();
	* $c->save();
	* $c->save();
*/

class Setting{
	
	//ļ
	private $xsl;
	
	//ļ
	private $xml;
	
	//
	private $arr;
	
	//Ƿд
	private $err=false;

	//캯
	function __construct( $xsl, $xml, $arr ){
		
		$this->xsl = $xsl;
		$this->xml = $xml;
		$this->arr = $arr;
		
		//ļ
		if(!file_exists($this->xml) || !file_exists($this->xsl)){
			$this->err = true;
		}
	}

	//תHTML
	function transform(){
		
		global $Project;
		global $Setting;
		
		if($this->err) return 'File not found!';
		
		//ػ
		include( $this->xsl );
		
		//ʱ
		$arr = $Setting[$this->arr];
	
		//ת룬תΪUTF-8
		if( $Project["charset"] != "utf-8" ){			
			foreach( $arr as $key => $val ){				
				if( is_string($val) ){				
					$arr[$key] = iconv($Project["charset"],"UTF-8",$val);
				}else{
					$arr[$key] = $val;
				}
			}
		}
							
		// Load the XML source
		$xml = new DOMDocument;
		$xml->load($this->xml);		
		
		$doc = $xml->getElementsByTagName('*');
		
		//
		$res = '';
		
		for ($i=0;$i<$doc->length;$i++){
			
			$ele = $doc->item($i);
			
			switch( $ele -> tagName ){
				
				//
				case "item":
				
					$res .= '<tr><td colspan="2" class="section"><strong>'.$ele -> getAttribute("label").'</strong></td></tr>';
				
				break;
				
				//ѡ
				case "key":
				
					$res .= '<tr text="'.$ele -> getAttribute("tip").'">';
						$res .= '<td width="'.$ele -> getAttribute("width").'" align="'.$ele -> getAttribute("align").'"><strong>'.$ele -> getAttribute("label").'</strong></td>';
						$res .= '<td>';
						
						//
						switch( $ele -> getAttribute("type") ){
							
							case "hidden":
								$res .= '<input name="'.$ele -> getAttribute("name").'" type="hidden" value="'.$arr[$ele -> getAttribute("name")].'" />';
								$res .= $arr[$ele -> getAttribute("name")];
							break;
							
							case "input":
				
								$v = array('idcard'=>"fix_card='yes'",'email'=>"fix_email='yes'",'number'=>"fix_number='yes'",'datetime'=>"fix_date='yes' readonly='true' onclick='return showCalendar(this.id,\"y-mm-dd\");' title='--'",''=>'');				
							
								$res .= '<input name="'.$ele -> getAttribute("name").'" size="'.$ele -> getAttribute("size").'" class="text" value="'.stripcslashes($arr[$ele -> getAttribute("name")]).'" fix_name="'.$ele -> getAttribute("label").'" '.$v[$ele -> getAttribute("format")].'  fix_null="'.( $ele -> getAttribute("null") == "false" ? "yes" : "" ).'" />';							
							break;
							
							case "textarea":
								$res .= '<textarea name="'.$ele -> getAttribute("name").'" rows="'.$ele -> getAttribute("rows").'">'.stripcslashes($arr[$ele -> getAttribute("name")]).'</textarea>';							
							break;
							
							case "select":
								$res .= '<select name="'.$ele -> getAttribute("name").'">';
								
								//ļ
								if( $ele -> getAttribute("folder") ){
									
									//ƤĿ¼
									$root = VI_ROOT.$ele -> getAttribute("folder");
									
									if ($handle = opendir($root)) {
										while (false !== ($file = readdir($handle))) {
											if  (($file  !=   ".") && ($file   !=   ".."))   {
												$res .= '<option value="'.$file.'" '. ( $arr[$ele -> getAttribute("name")] == $file ? 'selected="selected"' : '') .'>'.$file.'</option>';							
											}
										}
										closedir($handle);
									}	
									
								}else{
									
									//ѡ
									$sub = $ele->getElementsByTagName('option');
									
									for ($s=0; $s<$sub->length; $s++){														
										$res .= '<option value="'.$sub ->item($s) -> getAttribute("value").'" '. ( $arr[$ele -> getAttribute("name")] == $sub ->item($s) -> getAttribute("value") ? 'selected="selected"' : '') .'>'.$sub ->item($s) -> nodeValue.'</option>';								
									}
									
								}
															
								$res .= '</select>';							
							break;
							
							case "radio":								
								
								//ѡ
								$sub = $ele->getElementsByTagName('option');
								
								for ($s=0; $s<$sub->length; $s++){														
									$res .= '<label><input name="'.$ele -> getAttribute("name").'" value="'.$sub ->item($s) -> getAttribute("value").'" class="radio" type="radio" '. ( $arr[$ele -> getAttribute("name")] == $sub ->item($s) -> getAttribute("value") ? 'checked="checked"' : '') .' />'.$sub ->item($s) -> nodeValue.'</option></label>';
								}															
															
							break;
							
							case "checkbox":
								
								//ѡ
								$sub = $ele->getElementsByTagName('option');
								
								for ($s=0; $s<$sub->length; $s++){														
									$res .= '<label><input name="'.$ele -> getAttribute("name").'[]" value="'.$sub ->item($s) -> getAttribute("value").'" class="checkbox" type="checkbox" '. ( in_array($sub ->item($s) -> getAttribute("value"),$arr[$ele -> getAttribute("name")]) ? 'checked="checked"' : '') .' />'.$sub ->item($s) -> nodeValue.'</option></label>';								
								}															
															
							break;
							
							default:
								
								$res .= 'ERROR';								
															
							break;
							
						}						
						$res .= $ele -> getAttribute("desc");
						$res .= '</td>';					
					$res .= '</tr>';
				
				break;				
				
			}
			
		}
	
		//ת룬UTF-8תΪǰ
		if( $Project["charset"] != "utf-8" ){
			$res = iconv("UTF-8",$Project["charset"],$res);
		}
		
		//
		return $res;
	
	}
	

	//ȡXML
	function get(){
		
		global $Project;
		
		if($this->err) return 'File not found!';
							
		//ȡ
		$xml = simplexml_load_file($this->xml);
		$dom = simplexml_import_dom($xml);
		
		$array = array();
		
		//ڵ
		foreach ($dom->xpath('//key') as $key) {
			$name = $key['name'];
			$type = $key["type"];
			$format = $key["format"];
			
			switch($type){
				case "input":
				case "radio":
				case "hidden":
				case "select":
					$value = $key['value'];					
				break;
				
				case "checkbox":				
					$value = "";
					//Ԫ
					foreach ($key->xpath('option') as $input) {
						if( $input["checked"] == "true" ){
							$value .= $input["value"].",";
						}						
					}
					$value = substr($value,0,-1);
				break;
				
				case "textarea":
					$value = $key;
				break;
			}
			
			//ת
			if( $Project["charset"] && $Project["charset"] != "utf-8" ){
				$value = iconv("UTF-8",$Project["charset"],$value);
			}
			
			$array[(string) $key['name']] = (string) $value;
			
		}
		
		return $array;		
	}
	
	/*
		
	
		make	д
	*/
	function save( $method , $make = TRUE ){		
		global $Project;
		global $Setting;
		
		if($this->err) return 'File not found!';
		
		$query = ( $method=='POST'? $_POST : $_GET ) ;
		
		//ֻ²
		if( !$make ){
		
			//ػ
			include( $this->xsl );
			
			//ʱ
			$arr = $Setting[$this->arr];
			
			//дύֵ
			foreach( $query as $key => $val ){				
				$arr[$key] = $val;
			}
			
			$query = $arr ;			
		}
		
		//תַ
		foreach( $query as $key => $val ){				
			if( is_string($val) ){				
				$query[$key] = stripcslashes($val);
			}else{
				$query[$key] = $val;
			}
		}
		
		$str = '<?php'.chr(13);
		$str .= ' /*'.date("Y-m-t H:i:s").'*/ '.chr(13);
		
		$str .= '$Setting["'.$this->arr.'"] = ';
		
		$str .= var_export( $query , TRUE );
		
		$str .= '?>';
		
		//д뻺
		return create_file($this->xsl,$str);
		
	}

}
?>