﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>
<xsl:template match="/">

	<!--HEAD-->
	<!--xsl:element name="head">
		<xsl:element name="meta">
			<xsl:attribute name="http-equiv">Content-Type</xsl:attribute>
			<xsl:attribute name="content">text/html; charset=gb2312</xsl:attribute>
		</xsl:element>
		<xsl:element name="title">
			XSLT Test!
		</xsl:element>
	</xsl:element-->
    <!--/HEAD-->
    
    <!--fieldset-->
	
	<xsl:for-each select="//item">
    
        <xsl:element name="fieldset">
        
        	<!--legend-->
            <xsl:element name="legend">
                <xsl:value-of select="@label"/>
            </xsl:element>
            <!--/legend-->
		
            <xsl:for-each select="//key">
			
            	<!--dl-->
                <xsl:element name="dl">
                
                    <!--dt-->
                    <xsl:element name="dt">
                        <xsl:value-of select="@label"/>
                    </xsl:element>
                    <!--/dt-->
                    
                    <!--dd-->
					<xsl:element name="dd">
							
                        <xsl:choose>
                        
                            <xsl:when test="@type = 'input'">
                                <xsl:element name="input">
                                    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                    <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                    <xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute>
                                    <xsl:attribute name="class">text</xsl:attribute>
                                </xsl:element>
                            </xsl:when>
                            
                            <xsl:when test="@type = 'select'">
                                <xsl:element name="select">
                                    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                    <xsl:for-each select="option">
                                        <xsl:element name="option">
                                            <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                            <xsl:if test="../@value = @value">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            <xsl:apply-templates select="text()"/>
                                        </xsl:element>
                                    </xsl:for-each>
                                </xsl:element>
                            </xsl:when>
                            
                            <xsl:when test="@type = 'radio'">
                                <xsl:for-each select="option">
                                    <xsl:element name="label">
                                        <xsl:element name="input">
                                            <xsl:attribute name="type">radio</xsl:attribute>
                                            <xsl:attribute name="class">radio</xsl:attribute>
                                            <xsl:attribute name="name"><xsl:value-of select="../@name"/></xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                            <xsl:if test="../@value = @value">
                                                <xsl:attribute name="checked">checked</xsl:attribute>
                                            </xsl:if>
                                        </xsl:element>
                                        <xsl:apply-templates select="text()"/>
                                    </xsl:element>
                                </xsl:for-each>
                            </xsl:when>
                            
                            <xsl:when test="@type = 'checkbox'">
                                
                                <xsl:for-each select="option">
                                    <xsl:element name="label">
                                        <xsl:element name="input">
                                            <xsl:attribute name="type">checkbox</xsl:attribute>
                                            <xsl:attribute name="class">checkbox</xsl:attribute>
                                            <xsl:attribute name="name"><xsl:value-of select="../@name"/></xsl:attribute>
                                            <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                            
                                            <xsl:if test="@checked = 'true'">
                                                <xsl:attribute name="checked">checked</xsl:attribute>
                                            </xsl:if>
                                            
                                        </xsl:element>
                                        <xsl:apply-templates select="text()"/>
                                    </xsl:element>
                                </xsl:for-each>
                            </xsl:when>
                            
                            <xsl:when test="@type = 'textarea'">
                                <xsl:element name="textarea">
                                    <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
                                    <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
                                    <xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
                                    <xsl:apply-templates select='text()' />
                                </xsl:element>
                            </xsl:when>
                            
                            <xsl:otherwise>
                                未知元素，请检查插件配置文件。
                            </xsl:otherwise>
                        </xsl:choose>
                        
                        <xsl:if test="@null = 'false'">
                            <xsl:text disable-output-escaping="yes"><![CDATA[ *]]></xsl:text>
                        </xsl:if>
                        
                        <xsl:apply-templates select="@description"/>
						
					</xsl:element>
                    <!--/dd-->
                    
                </xsl:element>		
                <!--/dl-->
            
            </xsl:for-each>
            
        </xsl:element>
            
	</xsl:for-each>

	<!--/fieldset-->
    
</xsl:template>
</xsl:stylesheet>