<?php
/**
 * Read and parse remote calendars
 *
 * @author Matthias Sommerfeld, phlyLabs Berlin
 * @copyright 2011-2012 phlyLabs Berlin, http://phlylabs.de
 * @version 0.0.5 2012-06-11 $Id: cron_calendar_remotefolders.php 974 2013-01-30 13:33:03Z mso $
 */

// Just in case
require_once($_PM_['path']['handler'] . '/calendar/functions.php');

class cron_calendar_remotefolders
{
    public function __construct($cronjob)
    {
        $this->job = $cronjob;
    }

    public function Run()
    {
        $job = &$this->job;

        $cDB         = new handler_calendar_driver(0);
        $eventTypes  = $cDB->get_event_types();
        $eventStatus = $cDB->get_event_status();

        $group = $cDB->get_group($job['item']);
        if (empty($group)) {
            $Cron = new DB_Controller_Cron();
            $Cron->removeJob('calendar', 'remotefolders', $job['item']);
            return;
        }

        $cDB->changeUser($group['owner']);
        // First we let PHP try it
        // works only for plain URIs without AUTH or local files
        if (substr($group['uri'], 0, 7) == 'file://') {
            $fh = fopen($group['uri'], 'r');
            if (false === $fh) {
                $cDB->set_remote_calendar_checked($group['gid'], 1404, 'Reading given path failed');
                continue; // File not found / accessible; Cannot parse it
            }
            $file = stream_get_contents($fh);
            fclose($fh);
        } else { // HTTP requests
            $req = parse_url($group['uri']);
            if (!empty($group['ext_un'])) {
                $req['auth_user'] = deconfuse($group['ext_un'], md5($group['uri']));
            }
            if (!empty($group['ext_pw'])) {
                $req['auth_pass'] = deconfuse($group['ext_pw'], md5($group['uri']));
            }
            $httpClient = new Protocol_Client_HTTP();
            $file = $httpClient->send_request($req);
            if (false == $file) {
                $cDB->set_remote_calendar_checked($group['gid'], $httpClient->getErrorNo(), $httpClient->getErrorString());
                continue;
            }
        }

        // Empty selected calendar before importing from the file
        $cDB->empty_calendar(array($group['gid']));

        // Make sure, we can even parse a final calendar entry even if it is broken at the end
        $file .= CRLF . 'END:VEVENT' . CRLF . 'END:VTODO' . CRLF;
        $raw  = '';
        $mode = '';
        $type = 'VEVENT';
        $imported = 0;
        foreach (explode(CRLF, $file) as $line) {
            if ($mode == '' && preg_match('!BEGIN:(VEVENT|VTODO)!', $line, $found)) {
                $mode = 'r';
                $type = $found[1];
            }
            if ($mode == 'r') {
                $raw .= $line . CRLF;
                if (preg_match('!END:' . $type . '!', $line))
                    $mode = 'p';
            }
            if ($mode == 'p') {
                $save = parse_icaldata($raw, $type, $eventTypes, $eventStatus);
                if (!empty($save)) {
                    $save['gid'] = $group['gid'];
                    $res         = false;
                    if ($type == 'VEVENT') {
                        $res = $cDB->add_event($save);
                    } elseif ($type == 'VTODO') {
                        $res = $cDB->add_task($save);
                    }
                    if ($res) {
                        ++$imported;
                    } else {
                        print_r($cDB->get_errors());
                    }
                }
                $raw  = '';
                $mode = '';
            }
        }
        vecho('Imported ' . $imported . ' events for group #' . $group['gid']);
    }
}
?>