<?php
/**
 * Setup Of Advanced Choices
 * @package phlyMail Nahariya 4.0+
 * @copyright 2003-2012 phlyLabs, Berlin (http://phlylabs.de)
 * @version 4.0.9 2012-06-13 $Id: setup.advanced.php 974 2013-01-30 13:33:03Z mso $
 */
// Only valid within phlyMail
if (!defined('_IN_PHM_')) die();

if (!isset($_SESSION['phM_perm_read']['advanced_']) && !$_SESSION['phM_superroot']) {
    $tpl = new phlyTemplate(CONFIGPATH.'/templates/setup.noaccess.tpl');
    $tpl->assign('msg_no_access', $WP_msg['no_access']);
    return;
}
$tpl = new phlyTemplate(CONFIGPATH.'/templates/setup.advanced.tpl');
$whattodo = (isset($_REQUEST['whattodo'])) ? $_REQUEST['whattodo'] : false;
$WP_return = (isset($_REQUEST['WP_return']) && $_REQUEST['WP_return']) ? $_REQUEST['WP_return'] : false;

if ('save' == $whattodo) {
    // Schreibberechtigung
    if (!isset($_SESSION['phM_perm_write']['advanced_']) && !$_SESSION['phM_superroot']) {
        $tpl = new phlyTemplate(CONFIGPATH.'/templates/setup.noaccess.tpl');
        $tpl->assign('msg_no_access', $WP_msg['no_access']);
        return;
    }
    // Add the mandatory -t flag to the sendmail path
    if ($_REQUEST['WP_newsendmail'] && !preg_match('!\s-t([\s\Z\w]|$)!', $_REQUEST['WP_newsendmail'])) {
        $_REQUEST['WP_newsendmail'] = preg_replace('!^(.+)(?=\s|\Z)!U', '\1 -t', $_REQUEST['WP_newsendmail']);
    }
    $tokvar['core'] = array
            ('send_method' => $_REQUEST['WP_newsendmethod']
            ,'sendmail' => $_REQUEST['WP_newsendmail']
            ,'debugging_level' => (isset($_REQUEST['debugging_level'])) ? $_REQUEST['debugging_level'] : 0
            ,'pagesize' => wash_size_field($_REQUEST['WP_newpagesize'])
            ,'use_provsig' => (isset($_REQUEST['WP_useprovsig'])) ? $_REQUEST['WP_useprovsig'] : false
            ,'online_status' => $_REQUEST['WP_isonline']
            ,'show_motd' => (isset($_REQUEST['WP_newshowmotd'])) ? $_REQUEST['WP_newshowmotd'] : 0
            ,'fix_smtp_host' => $_REQUEST['WP_newsmtphost']
            ,'fix_smtp_port' => ($_REQUEST['WP_newsmtpport']) ? $_REQUEST['WP_newsmtpport'] : ''
            ,'fix_smtp_user' => $_REQUEST['WP_newsmtpuser']
            ,'fix_smtp_pass' => $_REQUEST['WP_newsmtppass']
            ,'fix_smtp_security' => $_REQUEST['WP_newsmtpsec']
            ,'provider_name' => phm_stripslashes($_REQUEST['WP_newprovidername'])
            ,'gzip_frontend' => (isset($_REQUEST['WP_usegzip'])) ? $_REQUEST['WP_usegzip'] : 0
            // Only until 4.5
            ,'conf_acc' => (isset($_REQUEST['WP_newconfacc'])) ? $_REQUEST['WP_newconfacc'] : false
            ,'allow_user_setup' => (isset($_REQUEST['WP_newallowconf'])) ? $_REQUEST['WP_newallowconf'] : false
            ,'allow_send' => (isset($_REQUEST['WP_newallowsend'])) ? $_REQUEST['WP_newallowsend'] : false
            );
    $WP_return = $WP_msg['optsnosave'];
    $truth = basics::save_config($_PM_['path']['conf'].'/global.choices.ini.php', $tokvar);
    if ($truth) {
        if ($_REQUEST['WP_provsig']) {
            file_put_contents($_PM_['path']['conf'].'/forced.signature.wpop', phm_stripslashes($_REQUEST['WP_provsig']));
        } else {
            if (file_exists($_PM_['path']['conf'].'/forced.signature.wpop')) unlink($_PM_['path']['conf'].'/forced.signature.wpop');
        }
        if ($_REQUEST['WP_MOTD']) {
            file_put_contents($_PM_['path']['conf'].'/global.MOTD.wpop', phm_stripslashes($_REQUEST['WP_MOTD']));
        } else {
            if (file_exists($_PM_['path']['conf'].'/global.MOTD.wpop')) unlink($_PM_['path']['conf'].'/global.MOTD.wpop');
        }
        $WP_return = $WP_msg['optssaved'];
    }
    header('Location: '.$link_base.'advanced&WP_return='.urlencode($WP_return));
    exit();
}
$_PM_['core']['provsig'] = (file_exists($_PM_['path']['conf'].'/forced.signature.wpop'))
        ? file_get_contents($_PM_['path']['conf'].'/forced.signature.wpop')
        : '';
$_PM_['core']['MOTD'] = (file_exists($_PM_['path']['conf'].'/global.MOTD.wpop'))
        ? file_get_contents($_PM_['path']['conf'].'/global.MOTD.wpop')
        : '';
$tpl->assign(array
        ('head_text' => $WP_msg['SuHeadAdv']
        ,'link_base' => htmlspecialchars($link_base)
        ,'WP_return' => $WP_return
        ,'target_link' => htmlspecialchars($link_base.'advanced&whattodo=save')
        ,'msg_optsendmethod' => $WP_msg['optsendmethod']
        ,'msg_path' => $WP_msg['optsendmail']
        ,'msg_fillin_sm' => $WP_msg['FillinSendMail']
        ,'msg_fillin_smtp' => $WP_msg['FillinSMTP']
        ,'msg_smtphost' => $WP_msg['optsmtphost']
        ,'msg_smtpport' => $WP_msg['optsmtpport']
        ,'msg_smtpuser' => $WP_msg['optsmtpuser']
        ,'msg_smtppass' => $WP_msg['optsmtppass']
        ,'msg_smtpsec' => $WP_msg['ConnectionSecurity']
        ,'size_limit' => $WP_msg['optsizelimit']
        ,'msg_forcedsig' => $WP_msg['SuOptForcedSig']
        ,'sizeexample' => $WP_msg['optsizeexample']
        ,'msg_pagesize' => $WP_msg['SuOptPagesize']
        ,'msg_save' => $WP_msg['save']
        ,'msg_cancel' => $WP_msg['cancel']
        ,'msg_onlineyes' => $WP_msg['SuOnlineYes']
        ,'msg_onlineno' => $WP_msg['SuOnlineNo']
        ,'msg_online' => $WP_msg['SuOptOnline']
        ,'msg_showmotd' => $WP_msg['SuShowMOTD']
        ,'msg_usegzip' => $WP_msg['SuUseGZipFE']
        ,'msg_providername' => $WP_msg['SuNameOfService']
        ,'about_online' => $WP_msg['AboutOnline']
        ,'about_providername' => $WP_msg['AboutProvName']
        ,'about_sendmethod' => $WP_msg['AboutSendMethod']
        ,'about_sizelimit' => $WP_msg['AboutSizeLimit']
        ,'about_pagesize' => $WP_msg['AboutPagesize']
        ,'about_gmapsapikey' => $WP_msg['AboutGMapsAPIKey']
        ,'leg_online' => $WP_msg['LegOnline']
        ,'leg_misc' => $WP_msg['LegMisc']
        ,'leg_fsig' => $WP_msg['LegFSig']
        ,'leg_motd' => $WP_msg['LegMOTD']
        ,'leg_providername' => $WP_msg['LegName']
        ,'leg_debugging' => $WP_msg['LegDebug']
        ,'msg_debugging' => $WP_msg['DebReportWhat']
        ,'about_debugging' => $WP_msg['AboutDebug']
        ,'sendmail' => $_PM_['core']['sendmail']
        ,'smtphost' => isset($_PM_['core']['fix_smtp_host']) ? $_PM_['core']['fix_smtp_host'] : ''
        ,'smtpport' => isset($_PM_['core']['fix_smtp_port']) ? $_PM_['core']['fix_smtp_port'] : ''
        ,'smtpuser' => isset($_PM_['core']['fix_smtp_user']) ? $_PM_['core']['fix_smtp_user'] : ''
        ,'smtppass' => isset($_PM_['core']['fix_smtp_pass']) ? $_PM_['core']['fix_smtp_pass'] : ''
        ,'provsig' => htmlspecialchars($_PM_['core']['provsig'])
        ,'pagesize' => $_PM_['core']['pagesize']
        ,'MOTD' => htmlspecialchars($_PM_['core']['MOTD'])
        ,'providername' => isset($_PM_['core']['provider_name']) ? htmlspecialchars($_PM_['core']['provider_name']) : ''
        // Only until 4.5
        ,'msg_allowsend' => $WP_msg['SuOptAllowSend']
        ,'msg_confacc' => $WP_msg['SuOptConfAcc']
        ,'msg_allowconf' => $WP_msg['SuOptAllowConf']
        // As of 4.0
        ,'gmapsapikey' => isset($_PM_['core']['gmaps_api_key']) ? htmlspecialchars($_PM_['core']['gmaps_api_key']) : ''
        ));
// Debugging?
$t_deb = $tpl->get_block('debug_level');
foreach (array('disabled' => 'DebReportNone', 'enabled' => 'DebReportAll') as $k => $v) {
    $t_deb->assign(array('level' => $k, 'msg_level' => $WP_msg[$v]));
    if (isset($_PM_['core']['debugging_level']) && $_PM_['core']['debugging_level'] == $k) $t_deb->assign_block('sel');
    $tpl->assign('debug_level', $t_deb);
    $t_deb->clear();
}
// Fix SMTP - security
$t_ss = $tpl->get_block('smtpsec');
foreach (array('SSL' => 'SSL', 'STARTTLS' => 'STARTTLS', 'AUTO' => $WP_msg['ConnectionSecurityAuto'], 'none' => $WP_msg['ConnectionSecurityNone']) as $k => $v) {
    $t_ss->assign(array('key' => $k, 'val' => $v));
    if (isset($_PM_['core']['fix_smtp_security']) && $_PM_['core']['fix_smtp_security'] == $k) {
        $t_ss->assign_block('sel');
    }
    $tpl->assign('smtpsec', $t_ss);
    $t_ss->clear();
}

switch ($_PM_['core']['send_method']) {
    case 'sendmail': $tpl->assign_block('methsmsel'); break;
    case 'smtp': $tpl->assign_block('methsmtpsel'); break;
}
switch ($_PM_['core']['online_status']) {
    case true:  $tpl->assign_block('online_yes'); break;
    case false: $tpl->assign_block('online_no');  break;
}
if (isset($_PM_['core']['show_motd']) && $_PM_['core']['show_motd']) $tpl->assign_block('showmotd');
if (isset($_PM_['core']['use_provsig']) && $_PM_['core']['use_provsig']) $tpl->assign_block('use_provsig');
if (isset($_PM_['core']['gzip_frontend']) && $_PM_['core']['gzip_frontend']) $tpl->assign_block('usegzip');
// Only until 4.0
if (isset($_PM_['core']['allow_send']) && $_PM_['core']['allow_send'])             $tpl->assign_block('allowsend');
if (isset($_PM_['core']['conf_acc']) && $_PM_['core']['conf_acc'])                 $tpl->assign_block('confacc');
if (isset($_PM_['core']['allow_user_setup']) && $_PM_['core']['allow_user_setup']) $tpl->assign_block('allowconf');
?>