<?php
/**
 * Config start page and settings checker
 * @package phlyMail Nahariya 4.0+, Branch MessageCenter
 * @subpackage Config interface
 * @copyright 2003-2013 phlyLabs, Berlin (http://phlylabs.de)
 * @version 4.0.9mod1 2013-01-25 $Id: setup.home.php 974 2013-01-30 13:33:03Z mso $
 */
// Only valid within phlyMail
if (!defined('_IN_PHM_')) die();

$tpl = new phlyTemplate(CONFIGPATH.'/templates/setup.home.tpl');
$error = false;

// Check, wether there's settings causing problems
$problems = false;
// Send method and missing settings
switch ($_PM_['core']['send_method']) {
case 'sendmail':
    if (!isset($_PM_['core']['sendmail']) || !$_PM_['core']['sendmail']) {
        $problems['sendmail'] = 1;
    }
    break;
case 'smtp':
    if (!isset($_PM_['core']['fix_smtp_host']) || !$_PM_['core']['fix_smtp_host']) {
        $problems['smtp'] = 1;
    }
    break;
}
// ProvSig
if (isset($_PM_['core']['use_provsig']) && 'true' == $_PM_['core']['use_provsig']) {
    if (file_exists($_PM_['path']['conf'].'/forced.signature.wpop')) {
        $_PM_['core']['provsig'] = file_get_contents($_PM_['path']['conf'].'/forced.signature.wpop');
    }
    if (!isset($_PM_['core']['provsig']) || !$_PM_['core']['provsig']) $problems['provsig'] = 1;
}
// MOTD
if (isset($_PM_['core']['show_motd']) && $_PM_['core']['show_motd']) {
    if (file_exists($_PM_['path']['conf'].'/global.MOTD.wpop')) {
        $_PM_['core']['MOTD'] = file_get_contents($_PM_['path']['conf'].'/global.MOTD.wpop');
    }
    if (!isset($_PM_['core']['MOTD']) || !$_PM_['core']['MOTD']) $problems['MOTD'] = 1;
}
// SMS settings
if (isset($_PM_['core']['sms_feature_active']) && $_PM_['core']['sms_feature_active']) {
    // User/Pass block removed, too much dependent on GW driver
    // Deposit exhausted
    if ($DB->get_sms_global_deposit() < 1) $problems['smsdeposit'] = 1;
    // higher setting of free sms than monthly allowed limit
    if (isset($_PM_['core']['sms_freesms']) && isset($_PM_['core']['sms_maxmonthly'])) {
        if ($_PM_['core']['sms_maxmonthly'] > 0
                && $_PM_['core']['sms_maxmonthly'] < $_PM_['core']['sms_freesms']) {
            $problems['smsfree'] = 1;
        }
    }
}
// All themes up to date?
if (file_exists($_PM_['path']['conf'].'/theme.engine')) {
    $themeEngine = trim(file_get_contents($_PM_['path']['conf'].'/theme.engine'));
    $themes = array();
    $d = opendir($_PM_['path']['theme']);
    while (false !== ($f = readdir($d))) {
        if ('.' == $f) continue;
        if ('..' == $f) continue;
        if (file_exists($_PM_['path']['theme'].'/'.$f.'/choices.ini.php') // Choices file there?
                && is_readable($_PM_['path']['theme'].'/'.$f.'/choices.ini.php')) {
            $thChoi = parse_ini_file($_PM_['path']['theme'].'/'.$f.'/choices.ini.php'); // Parse it
            if (isset($thChoi['engine']) && $thChoi['engine'] == $themeEngine) { // Has engine setting and version matches?
                continue; // Alright, this theme ought to be compatible
            }
        }
        $themes[] = $f;
    }
    closedir($d);
    if (!empty($themes)) $problems['themescompat'] = $themes;
}

// Are the cronjobs running?
$cron = new DB_Controller_Cron();
$cron_hb = $cron->getHeartbeat();
if (empty($cron_hb)) {
    $problems['cronjob'] = 'NULL';
} elseif (strtotime($cron_hb.'Z') < strtotime('-1 hour', time())) {
    $problems['cronjob'] = strtotime($cron_hb.'Z');
}

// Problems found -> output them
if ($problems) {
    $t_c = $tpl->get_block('checks');
    $t_c->assign(array
            ('msg_foundprob' => $WP_msg['CkSFoundProb']
            ,'leg_check' => $WP_msg['Leg_CkSet']
            ));
    $t_p = $t_c->get_block('probline');
    $plist = array
            ('smtp' => array('mod' => 'advanced', 'name' => 'setadv', 'msg' => 'CkSSMTP')
            ,'sendmail' => array('mod' => 'advanced', 'name' => 'setadv', 'msg' => 'CkSSndMl')
            ,'sizelimit' => array('mod' => 'advanced', 'name' => 'setadv', 'msg' => 'CkSSLimit')
            ,'provsig' => array('mod' => 'advanced', 'name' => 'setadv', 'msg' => 'CkSProvSig')
            ,'MOTD' => array('mod' => 'advanced', 'name' => 'setadv', 'msg' => 'CkSMOTD')
            ,'regsysaddr' => array('mod' => 'regnow', 'name' => 'setregnow', 'msg' => 'CkSRegSysAddr')
            ,'regnotice' => array('mod' => 'regnow', 'name' => 'setregnow', 'msg' => 'CkSRegNotice')
            ,'regmailuser' => array('mod' => 'regnow', 'name' => 'setregnow', 'msg' => 'CkSRegMailUser')
            ,'regmailadm' => array('mod' => 'regnow', 'name' => 'setregnow', 'msg' => 'CkSRegMailAdm')
            ,'smsdeposit' => array('mod' => 'sms', 'name' => 'SMS', 'msg' => 'CkSSMSDeposit')
            ,'smsfree' => array('mod' => 'sms', 'name' => 'SMS', 'msg' => 'CkSSMSFree')
            );
    foreach ($plist as $k => $v) {
        if (isset($problems[$k])) {
            $t_p->assign(array
                   ('msg_module' => $WP_msg['CkSModule']
                   ,'module' => $WP_msg[$v['name']], 'msg_descr' => $WP_msg[$v['msg']]
                   ,'link_module' => htmlspecialchars($link_base.$v['mod'])
                   ));
            $t_c->assign('probline', $t_p);
            $t_p->clear();
        }
    }
    if (isset($problems['themescompat'])) {
        $t_p->assign(array
               ('msg_module' => 'Themes'
               ,'msg_descr' => str_replace('$themeslist$', implode('</li><li>', $problems['themescompat']), $WP_msg['CkThemesCompat'])
               ,'module' => $WP_msg['CkThemesCompatURLTitle']
               ,'link_module' => htmlspecialchars($WP_msg['CkThemesCompatURL']).'" target="_blank' // Force new window / tab
               ));
        $t_c->assign('probline', $t_p);
        $t_p->clear();
    }
    if (isset($problems['cronjob'])) {
        if ($problems['cronjob'] == 'NULL') {
            $t_p->assign('msg_descr', $WP_msg['CkCronJobsNeverRan']);
        } else {
            $t_p->assign('msg_descr', str_replace('$lastrun$', date($WP_msg['dateformat'], $problems['cronjob']), $WP_msg['CkCronJobsDelayed']));
        }
        $t_p->assign(array(
                'msg_module' => 'CronJobs',
                'module' => $WP_msg['CkHowToCronJobsTitle'],
                'link_module' => htmlspecialchars($WP_msg['CkHowToCronJobsURL']).'" target="_blank' // Force new window / tab
               ));
        $t_c->assign('probline', $t_p);
        $t_p->clear();
    }
    $tpl->assign('checks', $t_c);
}
//
$overview = $DB->get_usroverview($_PM_['auth']['countonfail']);
foreach (array('all', 'inactive', 'locked', 'active') as $v) {
    if ($overview[$v] > 0) {
        $tpl->assign_block('search_'.$v);
        $tpl->assign('link_search_'.$v, htmlspecialchars($link_base.'users&search=&criteria='.$v));
        $tpl->assign('users_'.$v, $overview[$v]);
    } else {
        $tpl->assign('users_'.$v, 0);
    }
}
$tpl->assign(array
        ('curr_build' => trim(file_get_contents($_PM_['path']['conf'].'/build.name'))
                .' '.version_format(trim(file_get_contents($_PM_['path']['conf'].'/current.build')))
        ,'head_text' => $WP_msg['SuHeadHome']
        ,'link_AU' => htmlspecialchars($link_base.'AU')
        ,'link_fe_onoff' => htmlspecialchars($link_base.'advanced')
        ,'maxlicence' => $WP_msg['UMmaxlicence']
        ,'regusers' => $WP_msg['UMregusers']
        ,'msg_all' => $WP_msg['all']
        ,'msg_active' => $WP_msg['optactive']
        ,'msg_inactive' => $WP_msg['optinactive']
        ,'msg_locked' => $WP_msg['optlocked']
        ,'searchcrit' => $WP_msg['UMsearchcrit']
        ,'msg_currbuild' => $WP_msg['YourCurrBuild']
        ,'msg_frontendis' => $WP_msg['YourFEis']
        ,'msg_checkupd' => $WP_msg['CheckForUpdates']
        ,'msg_chgstatus' => $WP_msg['ChgStatus']
        ,'msg_general' => $WP_msg['general']
        ,'msg_users' => $WP_msg['MenuUsers']
        ,'msg_validto' => $WP_msg['ValidTo']
        ,'confpath' => CONFIGPATH
        ,'users_max' => 1
        ,'valid_to' => $WP_msg['Perpetual']
        ,'msg_fe_active' => ($_PM_['core']['online_status']) ? $WP_msg['SuOnlineYes'] : $WP_msg['SuOnlineNo']
        ));
?>