function setCookie(name, value, expires, path, domain, secure)
{
    // set time, it's in milliseconds
    var today = new Date();
    today.setTime( today.getTime() );

    if (expires) {
        expires = expires * 1000 * 60 * 60 * 24;
    }
    var expires_date = new Date( today.getTime() + (expires) );

    document.cookie = escape(name) + "=" + escape(value)
            + ( (expires) ? ";expires=" + expires_date.toGMTString() : "" )
            + ( (path) ? ";path=" + escape(path) : "" )
            + ( (domain) ? ";domain=" + escape(domain) : "" )
            + ( (secure) ? ";secure" : "" );
}

function getCookie(check_name)
{
    var a_all_cookies = document.cookie.split( ';' );
    var a_temp_cookie = '';
    var cookie_name = '';
    var cookie_value = '';
    var b_cookie_found = false; // set boolean t/f default f

    for (var i = 0; i < a_all_cookies.length; i++) {
        a_temp_cookie = a_all_cookies[i].split( '=' );
        cookie_name = a_temp_cookie[0].replace(/^\s+|\s+$/g, '');

        if (cookie_name == check_name) {
            b_cookie_found = true;
            if (a_temp_cookie.length > 1) {
                cookie_value = unescape(a_temp_cookie[1].replace(/^\s+|\s+$/g, ''));
            }
            return cookie_value;
            break;
        }
        a_temp_cookie = null;
        cookie_name = '';
    }
    return null;
}

function deleteCookie(name, path, domain)
{
    if (getCookie(name)) {
        document.cookie = escape(name) + "=" + ((path) ? ";path=" + escape(path) : "") + ((domain) ? ";domain=" + escape(domain) : "" ) + ";expires=Thu, 01-Jan-1970 00:00:01 GMT";
    }
}

function checkCookiesEnabled()
{
    setCookie('test', 'none', '', '/', '', '');
    if (getCookie('test')) {
        deleteCookie('test', '/', '');
        return true;
    }
    return false;
}