/**
 * JavaScript menus generated by DOM methods
 * There's routines for creating context menus and drop downs
 *
 * @copyright 2004-2009 phlyLabs Berlin, http://phlylabs.de
 * @version 4.0.2 2009-08-03
 */
gecko = (document.getElementById && window.outerHeight);
msie  = (document.getElementById && !window.outerHeight);
capable = msie || gecko;
ctxmen_sensor = false;
ctxmen_id = false;
pm_menu_preload = [];
pm_menu = [];
pm_menu_open = false;
pm_menu_hl = false;
pm_menu_drop = false;
pm_menu_autoclose = false;
pm_menu_fadelevel = 100;
pm_menu_slotpos = [];

function ctxmen_activate_sensor(sensor)
{
    // Refuse to activate another menu if one is already open
    if (ctxmen_id) return;
    // The param actually keeps the menu data
    ctxmen_sensor = sensor;
    for (var i in sensor) {
        if (sensor[i]['icon'] && typeof(pm_menu_preload[sensor[i]['icon']]) == 'undefined') {
            pm_menu_preload[sensor[i]['icon']] = new Image();
			pm_menu_preload[sensor[i]['icon']].src = sensor[i]['icon'];
        }
    }
}

function ctxmen_disable_sensor() { ctxmen_sensor = false; }

function create_menu(e)
{
    var tb, line, tdl, tdm, tdr, div, img, lasttype, right, left, bottom, top;
    if (ctxmen_id) destroy_menu();
    if (pm_menu_open) pm_menu_switchoff();
    if (!ctxmen_sensor) return;
    data = ctxmen_sensor;
    ctxmen_id = 'phm_ctxmen'; // We need an ID
    var menu = document.createElement('table'); // Create the menu container
    menu.cellSpacing = 0;
    // Register event handlers
    menu.onmouseover = hilite;
    menu.onmouseout = lolite;
    menu.className = 'contextmenu shadowed';
    tb = document.createElement('tbody');
    lasttype = 2; // Prevent, that the first thing drawn is a divider
    for (var i in data) { // Read the array with the individual menu entries
        if (typeof(data[i]) != 'object') continue; // This should mak us resistant against overloaded arrays / objects ... hopefully
        var item = data[i];
        if (item['status'] == 3) continue; // Hidden entry
        if (item['status'] == 2) { // This is a divider
            if (lasttype == 2) continue; // Only draw one separator at once
            if (i == data.length-1) continue; // Don't draw sep. as last item in menu. Works only well, if data is numbered accordingly
            lasttype = item['status'];
            line = document.createElement('tr');
            line.className = 'context_active';
            tdl = document.createElement('td');
            tdl.className = 'context_iconhr';
            tdl.innerHTML = '&nbsp;';
            line.appendChild(tdl);
            tdm = document.createElement('td');
            div = document.createElement('div');
            div.className = 'context_hr';
            div.innerHTML = '&nbsp;';
            tdm.appendChild(div);
            line.appendChild(tdm);
            tdr = document.createElement('td');
            div = document.createElement('div');
            div.className = 'context_hrsub';
            div.innerHTML = ' ';
            tdr.appendChild(div);
            line.appendChild(tdr);
        } else { // This is an active entry
            lasttype = item['status'];
            line = document.createElement('tr');
            line.className = (item['status'] == 1) ? 'context_active' : 'context_disabled';
            if (item['status'] == 1) {
                line.setAttribute('id', 'tfireme_' + i);
                line.onclick = fire_link;
            }
            tdl = document.createElement('td');
            tdl.className = 'context_icon';
            if (item['status'] == 1 && item['disabled_icon']) {
                img = document.createElement('img');
                img.setAttribute('src', item['disabled_icon']);
                img.setAttribute('alt', '');
                tdl.appendChild(img);
            } else if (item['icon']) {
                img = document.createElement('img');
                img.setAttribute('src', item['icon']);
                img.setAttribute('alt', '');
                tdl.appendChild(img);
            } else {
                tdl.appendChild(document.createTextNode(' '));
            }
            line.appendChild(tdl);
            tdm = document.createElement('td');
            tdm.className = 'context_text';
            tdm.appendChild(document.createTextNode(item['name']));
            line.appendChild(tdm);
            tdr = document.createElement('td');
            tdr.appendChild(document.createTextNode(' '));
            tdr.className = (typeof(item['sub']) != 'undefined' && item['sub']) ? 'context_subicon' : 'context_nosub';
            line.appendChild(tdr);
        }
        tb.appendChild(line); // Append line to container
    }
    menu.appendChild(tb);
    menu.setAttribute('id', ctxmen_id);
    document.body.appendChild(menu);
    menu = document.getElementById(ctxmen_id);
    // Find out, how close we are to document corners, position accordingly
    right =  msie ? document.body.clientWidth - event.clientX : window.innerWidth - e.clientX;
    bottom = msie ? document.body.clientHeight - event.clientY : window.innerHeight - e.clientY;
    var mywidth  = menu.offsetWidth;
    var myheight = menu.offsetHeight;
    if (right < mywidth) { // Too far to the right ?
        // place it inside document's bounds
        left = msie ? document.body.scrollLeft + event.clientX - (mywidth - right + 5)
                        : window.pageXOffset + e.clientX - (mywidth - right + 5);
    } else {
        // Let it pop up right where the mouse was clicked
        left = msie ? document.body.scrollLeft + event.clientX : window.pageXOffset + e.clientX;
    }
    if (left < 0) left = 4;
    // repeat game with bottom pos
    if (bottom < myheight) {
        top = msie ? document.body.scrollTop + event.clientY - (myheight - bottom + 5)
                       : window.pageYOffset + e.clientY - (myheight - bottom + 5);
    } else if (myheight) {
        top = msie ? document.body.scrollTop + event.clientY : window.pageYOffset + e.clientY;
    } else {
        top = 20;
    }
    if (top < 0) top = 4;
    menu.style.left = left + 'px';
    menu.style.top = top + 'px';
    menu.style.zIndex = 1001;

    // This will allow the menu to appear in front of windowed controls in IE
    var mlay = document.createElement('iframe');
    mlay.setAttribute('id', 'contextmenuiframe');
    mlay.className = 'menuiframe';
    mlay.style.left = left + 'px';
    mlay.style.top = top + 'px';
    mlay.style.width = (mywidth + 2) + 'px';
    mlay.style.height = (myheight + 2) + 'px';
    mlay.style.zIndex = 1000;
    document.body.appendChild(mlay);
    cancel_event(e);
    window.setTimeout('$(document).bind("click", destroy_menu);', 10);

    return false; // Returning false prevents standard context menu of browser
}


function hilite(e)
{
    if (pm_menu_open && pm_menu_autoclose) {
        window.clearTimeout(pm_menu_autoclose);
        pm_menu_setfade(100);
        pm_menu_fadelevel = 100;
    }
    var src = msie ? event.srcElement : e.target;
    if (src.className == 'context_active' || src.parentNode.className == 'context_active') {
        if (src.parentNode.className == 'context_active') src = src.parentNode;
        src.className = 'context_hover';
    }
}

function lolite(e)
{
    if (pm_menu_open) pm_menu_autoclose = window.setTimeout('pm_menu_fadeout();', 1000);
    var src = msie ? event.srcElement : e.target;
    if (src.className == 'context_hover' || src.parentNode.className == 'context_hover') {
        if (src.parentNode.className == 'context_hover') src = src.parentNode;
        src.className = 'context_active';
    }
}

function fire_link(e)
{
	// Handle event
    var src = msie ? event.srcElement : e.target;
    if (src.className == 'context_hover' || src.parentNode.className == 'context_hover') {
        if (src.parentNode.className == 'context_hover') src = src.parentNode;
        var i = src.getAttribute('id').replace(/^(cfireme|tfireme)_/, '');
    }
    destroy_menu();
    eval(data[i]['link']);
}

function destroy_menu()
{
    if (ctxmen_id) {
        $('#' + ctxmen_id + ', #contextmenuiframe').remove();
        ctxmen_id = false;
    }
    $(document).unbind('click', destroy_menu);
    if (frames) {
        if (frames.PHM_tr && frames.PHM_tr.document && frames.PHM_tr.document.onclick) frames.PHM_tr.document.onclick();
    }
    try { parent.onclick(); } catch (e) { }
    try { parent.parent.onclick(); } catch (e) { }
    return true;
}

function pm_menu_additem(slot, icon, name, link, width, height, linktype, selected)
{
    if (!pm_menu[slot]) {
        pm_menu[slot] = [];
        var offset = 0;
    } else {
        var offset = pm_menu[slot].length;
    }
    pm_menu[slot][offset] = {'icon' : icon, 'name' : name, 'link' : link};
    if (width) pm_menu[slot][offset]['width'] = width;
    if (height) pm_menu[slot][offset]['height'] = height;
    if (linktype) pm_menu[slot][offset]['linktype'] = linktype;
    if (selected) pm_menu[slot][offset]['selected'] = selected;
    if (icon && typeof(pm_menu_preload[icon]) == 'undefined') {
        pm_menu_preload[icon] = new Image();
        pm_menu_preload[icon].src = icon;
    }
}

function pm_menu_removeitem(slot, link)
{
    if (!pm_menu[slot]) return;
    var mycopy = [];
    var myoffset = 0;
    for (var i in pm_menu[slot]) {
        if (typeof(pm_menu[slot][i]['link']) != 'undefined' && pm_menu[slot][i]['link'] == link) continue;
        mycopy[myoffset] = pm_menu[slot][i];
        ++myoffset;
    }
    pm_menu[slot] = mycopy;
}

function pm_menu_replaceitem(slot, oldlink, icon, name, link, width, height, linktype, selected)
{
    for (var i in pm_menu[slot]) {
        if (typeof(pm_menu[slot][i]['link']) == 'undefined' || pm_menu[slot][i]['link'] != oldlink) continue;
        pm_menu[slot][i] = {'icon' : icon, 'name' : name, 'link' : link};
        if (width) pm_menu[slot][i]['width'] = width;
        if (height) pm_menu[slot][i]['height'] = height;
        if (linktype) pm_menu[slot][i]['linktype'] = linktype;
        if (selected) pm_menu[slot][i]['selected'] = selected;
        if (icon && typeof(pm_menu_preload[icon]) == 'undefined') {
            pm_menu_preload[icon] = new Image();
            pm_menu_preload[icon].src = icon;
        }
    }
}

function pm_menu_addline(slot)
{
    if (!pm_menu[slot]) return;
    var offset = pm_menu[slot].length;
    pm_menu[slot][offset] = {'drawline' : true};
}

function pm_menu_switch(ele)
{
    if (pm_menu_drop) {
        if (document.getElementById('maintopmenu')) pm_menu_destroy();
        pm_menu_drop = false;
    } else {
        pm_menu_drop = true;
    }
    if (ele) {
        ele.onmouseover();
        ele.blur();
    }
    cnt = document.getElementById('pm_menu_container');
    if (cnt) cnt.className = (cnt.className == 'solid_nodrop') ? 'solid_drop' : 'solid_nodrop';
}

function pm_menu_fadeout()
{
    if (pm_menu_fadelevel == 0) {
        pm_menu_switchoff();
        pm_menu_fadelevel = 100;
        return;
    } else {
        pm_menu_fadelevel -= 10;
    }
    if (!pm_menu_setfade(pm_menu_fadelevel)) {
        pm_menu_switchoff();
        pm_menu_fadelevel = 100;
        return;
    }
    pm_menu_autoclose = window.setTimeout('pm_menu_fadeout();', 50);
}

function pm_menu_setfade(level)
{
    var menu = document.getElementById('maintopmenu');
    try {
        menu.style.opacity = (pm_menu_fadelevel / 100);
    } catch (e) {}
    try {
        menu.style.MozOpacity = (pm_menu_fadelevel / 100);
    } catch (e) {}
    try {
        menu.filters.alpha.opacity = pm_menu_fadelevel;
    } catch (e) {}
    return true;
}

function pm_menu_switchoff()
{
    pm_menu_drop = true;
    pm_menu_switch();
}

function pm_menu_menupos(slot)
{
    if (!pm_menu_slotpos[slot]) {
        var checkobj = document.getElementById('topmendrop_' + slot);
        var objleft = 0;
        while (true) {
            objleft += (checkobj.offsetLeft && checkobj.nodeName != 'TABLE') ? checkobj.offsetLeft : 0;
            if (!checkobj.parentNode) break;
            checkobj = checkobj.parentNode;
        }
        pm_menu_slotpos[slot] = objleft;
    }
    return pm_menu_slotpos[slot];
}

function pm_menu_create(slot)
{
    var tb, line, tdl, tdm, tdr, div, img, lasttype;
    if (!pm_menu_drop) return;
    if (pm_menu_open && pm_menu_autoclose) {
        window.clearTimeout(pm_menu_autoclose);
        pm_menu_setfade(100);
        pm_menu_fadelevel = 100;
    }
    if (document.getElementById('maintopmenu')) pm_menu_destroy();
    var maxlen = 0;
    var menu = document.createElement('table'); // Create the menu container div
    menu.cellSpacing = 0;
    // Register event handlers
    menu.onmouseover = hilite;
    menu.onmouseout  = lolite;
    menu.className   = 'contextmenu shadowed';
    tb = document.createElement('tbody');
    lasttype = 2; // Prevent, that the first thing drawn is a divider
    for (var i in pm_menu[slot]) { // Read the array with the individual menu entries
        if (typeof(pm_menu[slot][i]) != 'object') continue; // Resistance against overloaded arrays / objects
        var myitem = pm_menu[slot][i];
        if (myitem['drawline']) { // This is a divider
            if (lasttype == 2) continue; // Only draw one separator at once
            if (i == pm_menu[slot].length-1) continue; // Don't draw sep. as last item in menu. Works only well, if data is numbered accordingly
            lasttype = 2;
            line = document.createElement('tr');
            line.className = 'context_active';
            tdl = document.createElement('td');
            tdl.className = 'context_iconhr';
            tdl.innerHTML = '&nbsp;';
            line.appendChild(tdl);
            tdr = document.createElement('td');
            div = document.createElement('div');
            div.className = 'context_hr';
            div.innerHTML = '&nbsp;';
            tdr.appendChild(div);
            line.appendChild(tdr);
        } else { // This is an active entry
            lasttype = 1;
            line = document.createElement('tr');
            line.className = 'context_active';
            line.setAttribute('id', '_pm_fireme_' + i);
            line.onclick = pm_menu_fire;
            tdl = document.createElement('td');
            tdl.className = 'context_icon';
            if (myitem['selected'] && 1 == myitem['selected']) {
                img = document.createElement('img');
                img.setAttribute('src', theme_path + '/icons/selected_men.png');
                img.setAttribute('alt', '');
                tdl.appendChild(img);
            } else if (myitem['icon']) {
                img = document.createElement('img');
                img.setAttribute('src', myitem['icon']);
                img.setAttribute('alt', '');
                tdl.appendChild(img);
            } else {
                tdl.appendChild(document.createTextNode(' '));
            }
            line.appendChild(tdl);
            tdr = document.createElement('td');
            tdr.className = 'context_text';
            tdr.appendChild(document.createTextNode(myitem['name']));
            line.appendChild(tdr);
        }
        tb.appendChild(line); // Append line to container
    }
    menu.appendChild(tb);
    menu.setAttribute('id', 'maintopmenu');
    document.body.appendChild(menu);
    menu = document.getElementById('maintopmenu');
    var grandma = document.getElementById('topmenucontainer');
    var myleft = pm_menu_menupos(slot);
    var mytop = (grandma.offsetTop * 1) + (grandma.offsetHeight * 1) - 1;
    menu.style.left = myleft + 'px';
    menu.style.top = mytop + 'px';
    menu.style.zIndex = 11;
    // This will allow the menu to appear in front of windowed controls in IE
    var mlay = document.createElement('iframe');
    mlay.setAttribute('id', 'maintopmenuiframe');
    mlay.className = 'menuiframe';
    mlay.style.left = myleft + 'px';
    mlay.style.top = mytop + 'px';
    mlay.style.width = (menu.offsetWidth + 2) + 'px';
    mlay.style.height = (menu.offsetHeight + 2) + 'px';
    mlay.style.zIndex = 9;
    document.body.appendChild(mlay);
    pm_menu_open = slot;
}

function pm_menu_fire(e)
{
	// Handle event
    var src = msie ? event.srcElement : e.target;
    if (src.className == 'context_hover' || src.parentNode.className == 'context_hover') {
        if (src.parentNode.className == 'context_hover') src = src.parentNode;
        var i = src.getAttribute('id').replace(/^_pm_fireme_/, '');
    }
    myitem = pm_menu[pm_menu_open][i];

    if (myitem['linktype']) {
        if (myitem['linktype'] == 'href') {
            window.location.href = myitem['link'];
            return;
        } else if (myitem['linktype'] == 'js') {
            pm_menu_switch();
            eval(myitem['link']);
            return;
        }
    } else if (!myitem['link']) {
        pm_menu_switch();
        return;
    } else {
        var myhref = 'pm_menu_fire("' + myitem['link'] + '"';
        if (myitem['width'] == '100%') {
            myitem['width'] = $(window).width()*.9;
        } else if (!myitem['width']) {
            myitem['width'] = 600;
        }
        if (myitem['height'] == '100%') {
            myitem['height'] = $(window).height()*.9;
        } else if (!myitem['height']) {
            myitem['height'] = 500;
        }
    }
    window.open
            (myitem['link']
            ,'_pm_' + new Date().getTime()
            ,'width=' + myitem['width'] + ',height=' + myitem['height'] + ',scrollbars=yes,resizable=yes,location=no,menubar=no,status=no,toolbar=no'
            );
    pm_menu_switch();
}

function pm_menu_destroy()
{
    var me;
    if (pm_menu_open != false) {
        me = document.getElementById('maintopmenu');
        me.parentNode.removeChild(me);
        me = document.getElementById('maintopmenuiframe');
        me.parentNode.removeChild(me);
    }
    pm_menu_hl = false;
    pm_menu_open = false;
}

$(document).bind('contextmenu', create_menu);
