<?php
/**
 * Protocol client hull class
 *
 * @package phlyMail Nahariya 4.0+
 * @author Matthias Sommerfeld <mso@phlylabs.de>
 * @copyright 2005-2012 phlyLabs, Berlin (http://phlylabs.de)
 * @version 0.0.1 2012-05-02 $Id: Base.php 977 2013-02-03 15:32:04Z mso $
 */

class Protocol_Client_Base {
    public $CRLF = "\r\n"; // Define standard line endings (CRLF and LF)
    public $LF   = "\n";
    public $error_nl = 'LF'; // Multiple errors can be returned in either HTML linebreaks or plain LF
    public $append_errors = true;
    public $timestamp_errors = false;
    protected $_diag_session = false;
    protected $error = false;
    protected $fp = false;
    protected $is_tls = false;
    protected $is_ssl = false;
    protected $security = 'SSL';
    protected $connected = false;
    protected $server_capa = false;
    protected $reconnect_sleep = false;

    // List of SASL mechanisms we support
    protected $SASL = array('cram_sha256', 'cram_sha1', 'cram_md5', 'login', 'plain');

    /**
     * Sole aim is, to know, whether we are connected or not
     * since we cannot return something useful on construction
     * of the object
     */
    public function check_connected()
    {
        return $this->connected;
    }

    public function get_last_error()
    {
        $return = ($this->error) ? $this->error : '';
        unset ($this->error);
        return $return;
    }

    // Add or set an (timestamped error), that can be requested via get_last_error()
    protected function set_error($error)
    {
        $vorn = ($this->timestamp_errors) ? time().' ' : '';
        $this->diag($error);
        if ($this->append_errors) {
            $this->error .= $vorn.$error.LF;
        } else {
            $this->error  = $vorn.$error;
        }
    }

    protected function diag($msg)
    {
        if ($this->_diag_session) {
            fputs($this->diag, $msg.LF);
        }
    }
}
?>