<?php
/**
 * Cousin of ./init.frontend.php for backend purposes
 * @package phlyMail Nahariya 4.0+
 * @subpackage Core system
 * @copyright 2002-2013 phlyLabs, Berlin (http://phlylabs.de)
 * @version 4.2.0 2013-02-15 $Id: init.backend.php 996 2013-02-10 14:25:19Z mso $
 */
// Only valid within phlyMail
if (!defined('_IN_PHM_')) die();
define('SESS_NAME', session_name());
define('SESS_ID', preg_replace('![^-,a-zA-Z0-9]!', '', session_id())); // Allow up to 6bits per character session IDs
define('CRLF', "\r\n");
define('LF', "\n");
require_once($_PM_['path']['lib'].'/autoload.php');
require_once($_PM_['path']['lib'].'/functions.php');
// Global Choices, overloading core settings
if (file_exists($_PM_['path']['conf'].'/global.choices.ini.php')) {
    $_PM_ = merge_PM($_PM_, parse_ini_file($_PM_['path']['conf'].'/global.choices.ini.php', true));
}
// Suppress DateTime warnings
date_default_timezone_set(@date_default_timezone_get());

$DB = new DB_Base();

$_PM_['core']['file_umask'] = octdec($_PM_['core']['file_umask']);
$_PM_['core']['dir_umask']  = octdec($_PM_['core']['dir_umask']);
define('PHP_SELF', (isset($_SERVER['SCRIPT_NAME']) && $_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : $_SERVER['PHP_SELF']);
if (isset($_SESSION['phM_uid'])) require_once($_PM_['path']['lib'].'/user.choices.php');
require_once($_PM_['path']['message'].'/'.$_PM_['core']['language'].'.php');
// Timezone
if (isset($_PM_['core']['timezone'])) {
    define('PHM_TIMEZONE', $_PM_['core']['timezone']);
    date_default_timezone_set($_PM_['core']['timezone']);
} elseif (isset($WP_msg['tz'])) {
    define('PHM_TIMEZONE', $WP_msg['tz']);
    date_default_timezone_set($WP_msg['tz']);
} else {
    define('PHM_TIMEZONE', date_default_timezone_get());
}
define('PHM_UTCOFFSET', utc_offset());
$DB->settimezone(PHM_UTCOFFSET);

// SMS active?
if (isset($_PM_['core']['sms_active'])) {
    if ($_PM_['core']['sms_active']) $_PM_['core']['sms_active'] = 1;
} elseif (isset($_PM_['core']['sms_default_active'])) {
    if ($_PM_['core']['sms_default_active']) $_PM_['core']['sms_active'] = 1;
} else {
    $_PM_['core']['sms_active'] = 0;
}
?>