/*
 * Tine 2.0 - Calendar 
 * Copyright (c) 2007-2011 Metaways Infosystems GmbH (http://www.metaways.de)
 * http://www.gnu.org/licenses/agpl.html AGPL Version 3
 */
Ext.ns("Tine.Calendar");Tine.Calendar.AddressbookGridPanelHook=function(a){Tine.log.info("initialising calendar addressbook hooks");Ext.apply(this,a);this.addEventAction=new Ext.Action({actionType:"add",requiredGrant:"readGrant",allowMultiple:true,text:this.app.i18n._("New Event"),iconCls:this.app.getIconCls(),scope:this,handler:this.onAddEvent,listeners:{scope:this,render:this.onRender}});Ext.ux.ItemRegistry.registerItem("Addressbook-GridPanel-ContextMenu",this.addEventAction,80)};Ext.apply(Tine.Calendar.AddressbookGridPanelHook.prototype,{app:null,addEventAction:null,ContactGridPanel:null,getContactGridPanel:function(){if(!this.ContactGridPanel){this.ContactGridPanel=Tine.Tinebase.appMgr.get("Addressbook").getMainScreen().getCenterPanel()}return this.ContactGridPanel},onAddEvent:function(b){var c=this.getContactGridPanel().grid.getSelectionModel().getSelections(),a=this.app.getMainScreen(),d=a.getCenterPanel();d.onEditInNewWindow.call(d,"add",{attendee:c})},onRender:function(){var b=this.getContactGridPanel().actionUpdater,a=b.actions;if(a.indexOf(this.addEventAction)<0){b.addActions([this.addEventAction])}}});Ext.ns("Tine.Calendar");Tine.Calendar.ParallelEventsRegistry=function(a){Ext.apply(this,a);this.dtStartTs=this.dtStart.getTime();this.dtEndTs=this.dtEnd.getTime();this.dt=this.granularity*Date.msMINUTE;this.frameLength=Math.ceil((this.dtEndTs-this.dtStartTs)/this.dt);this.map=[]};Tine.Calendar.ParallelEventsRegistry.prototype={dtStart:null,dtEnd:null,granularity:5,dtStartProperty:"dtstart",dtEndProperty:"dtend",map:null,dtStartTs:null,dtEndTs:null,dt:null,register:function(a,e){var h=a.get(this.dtStartProperty);var j=h.getTime();var d=a.get(this.dtEndProperty);var g=d.getTime()-1000;a.duration=g-j;var i=this.tsToIdx(h);var c=this.tsToIdx(g);var f=0;var b=this.getFrame(f);while(!this.isEmptySlice(b,i,c)){b=this.getFrame(++f)}this.registerSlice(b,i,c,a);a.parallelEventRegistry={registry:this,position:f,startIdx:i,endIdx:c};if(e){return this.getEvents(h,d)}},unregister:function(c){var b=c.parallelEventRegistry;var d=this.getFrame(b.position);if(!this.skipIntegrityChecks){for(var a=b.startIdx;a<=b.endIdx;a++){if(d[a]!==c){throw new Ext.Error("event is not registered at expected position")}}}this.unregisterSlice(d,b.startIdx,b.endIdx);c.parallelEventRegistry=null},getEvents:function(e,c,b){var g=e.getTime();var d=c.getTime()-1000;var f=this.tsToIdx(e);var a=this.tsToIdx(d);var i=this.getSliceInfo(f,a).events;var h=this;i.sort(function(k,j){var m=j.duration-k.duration;var l=k.get(h.dtStartProperty).getTime()-j.get(h.dtStartProperty).getTime();return b?l?l:m:m?m:l});return i},getMaxParalles:function(f,e){var a=f.getTime();var b=e.getTime()-1000;var d=this.tsToIdx(f);var c=this.tsToIdx(b);return this.getSliceInfo(d,c).maxParallels},getPosition:function(a){if(!a.parallelEventRegistry){throw new Ext.Error("can't compute position of a non registered event")}return a.parallelEventRegistry.position},getSliceInfo:function(f,e){var d=[];var c=1;for(var b,g,a=0;a<this.map.length;a++){g=this.map[a];for(b=f;b<=e;b++){if(g[b]&&d.indexOf(g[b])===-1){c=Math.max(c,a+1);d.push(g[b])}}}return{events:d,maxParallels:c}},getFrame:function(a){if(a>this.map.length+1){throw new Ext.Error("skipping frames is not allowed")}if(!Ext.isArray(this.map[a])){this.map[a]=new Array(this.frameLength)}return this.map[a]},isEmptySlice:function(d,c,b){for(var a=c;a<=b;a++){if(d[a]){return false}}return true},registerSlice:function(e,c,b,d){for(var a=c;a<=b;a++){e[a]=d}},tsToIdx:function(a){return Math.floor((a-this.dtStartTs)/this.dt)},unregisterSlice:function(d,c,b){for(var a=c;a<=b;a++){d[a]=null}return this}};Ext.ns("Tine.Calendar","Tine.Calendar.Model");Tine.Calendar.Model.Event=Tine.Tinebase.data.Record.create(Tine.Tinebase.Model.genericFields.concat([{name:"id"},{name:"dtend",type:"date",dateFormat:Date.patterns.ISO8601Long},{name:"transp"},{name:"class"},{name:"description"},{name:"geo"},{name:"location"},{name:"organizer"},{name:"priority"},{name:"status_id"},{name:"summary"},{name:"url"},{name:"uid"},{name:"attendee"},{name:"alarms"},{name:"tags"},{name:"notes"},{name:"dtstart",type:"date",dateFormat:Date.patterns.ISO8601Long},{name:"recurid"},{name:"exdate"},{name:"rrule"},{name:"is_all_day_event",type:"bool"},{name:"rrule_until",type:"date",dateFormat:Date.patterns.ISO8601Long},{name:"originator_tz"},{name:"readGrant",type:"bool"},{name:"editGrant",type:"bool"},{name:"deleteGrant",type:"bool"},{name:"editGrant",type:"bool"}]),{appName:"Calendar",modelName:"Event",idProperty:"id",titleProperty:"summary",recordName:"Event",recordsName:"Events",containerProperty:"container_id",containerName:"Calendar",containersName:"Calendars",getDisplayContainer:function(){var a=this.get("container_id");var c=Tine.Tinebase.registry.get("currentAccount").accountId;var b=this.getAttendeeStore();b.each(function(f){var e=f.getUserAccountId();if(e==c){var d=f.get("displaycontainer_id");if(d){a=d}return false}},this);return a},isRecurBase:function(){return !!this.get("rrule")&&!this.get("recurid")},isRecurException:function(){return !!this.get("recurid")&&!(this.idProperty&&this.id.match(/^fakeid/))},isRecurInstance:function(){return this.id&&this.id.match(/^fakeid/)},getAttendeeStore:function(){return Tine.Calendar.Model.Attender.getAttendeeStore(this.get("attendee"))},getMyAttenderRecord:function(){var c=Tine.Tinebase.registry.get("currentAccount").accountId;var b=this.getAttendeeStore();var a=false;b.each(function(e){var d=e.getUserAccountId();if(d==c){a=e;return false}},this);return a}});Tine.Calendar.Model.Event.getDefaultData=function(){var g=Tine.Tinebase.appMgr.get("Calendar"),b=new Date().clearTime().add(Date.HOUR,(new Date().getHours()+1)),d=g.getMainScreen().getCenterPanel(),f=d.getCalendarPanel(d.activeView).getView().getPeriod(),a=g.getMainScreen().getWestPanel().getContainerTreePanel().getDefaultContainerForNewRecords(),e=Tine.Tinebase.registry.get("currentAccount");if(f.from.getTime()>b.getTime()||f.until.getTime()<b.getTime()){b=f.from.clearTime(true).add(Date.HOUR,9)}var c={summary:"",dtstart:b,dtend:b.add(Date.HOUR,1),container_id:a,transp:"OPAQUE",editGrant:true,organizer:Tine.Tinebase.registry.get("userContact"),attendee:[Ext.apply(Tine.Calendar.Model.Attender.getDefaultData(),{user_type:"user",user_id:e,status:"ACCEPTED"})]};return c};Tine.Calendar.Model.Event.getFilterModel=function(){var a=Tine.Tinebase.appMgr.get("Calendar");return[{label:_("Quick search"),field:"query",operators:["contains"]},{filtertype:"tine.widget.container.filtermodel",app:a,recordClass:Tine.Calendar.Model.Event,defaultValue:{path:Tine.Tinebase.container.getMyNodePath()}},{filtertype:"calendar.attendee"},{filtertype:"calendar.attendeestatus"},{filtertype:"addressbook.contact",field:"organizer",label:a.i18n._("Organizer")},{filtertype:"tinebase.tag",app:a}]};Tine.Calendar.Model.EventJsonBackend=Ext.extend(Tine.Tinebase.data.RecordProxy,{createRecurException:function(c,e,b,a){a=a||{};a.params=a.params||{};a.beforeSuccess=function(f){return[this.recordReader(f)]};var d=a.params;d.method=this.appName+".createRecurException";d.recordData=c.data;d.deleteInstance=e?1:0;d.deleteAllFollowing=b?1:0;return this.doXHTTPRequest(a)},deleteRecurSeries:function(b,a){a=a||{};a.params=a.params||{};var c=a.params;c.method=this.appName+".deleteRecurSeries";c.recordData=b.data;return this.doXHTTPRequest(a)},updateRecurSeries:function(b,a){a=a||{};a.params=a.params||{};a.beforeSuccess=function(d){return[this.recordReader(d)]};var c=a.params;c.method=this.appName+".updateRecurSeries";c.recordData=b.data;return this.doXHTTPRequest(a)}});if(Tine.Tinebase.widgets){Tine.Calendar.backend=new Tine.Calendar.Model.EventJsonBackend({appName:"Calendar",modelName:"Event",recordClass:Tine.Calendar.Model.Event})}else{Tine.Calendar.backend=new Tine.Tinebase.data.MemoryBackend({appName:"Calendar",modelName:"Event",recordClass:Tine.Calendar.Model.Event})}Tine.Calendar.Model.Attender=Tine.Tinebase.data.Record.create([{name:"id"},{name:"cal_event_id"},{name:"user_id",sortType:Tine.Tinebase.common.accountSortType},{name:"user_type"},{name:"role"},{name:"quantity"},{name:"status"},{name:"status_authkey"},{name:"displaycontainer_id"}],{appName:"Calendar",modelName:"Attender",idProperty:"id",titleProperty:"name",recordName:"Attender",recordsName:"Attendee",containerProperty:"cal_event_id",containerName:"Event",containersName:"Events",getUserAccountId:function(){var b=this.get("user_type");if(b=="user"||b=="groupmember"){var a=this.get("user_id");if(!a){return null}if(typeof a.get=="function"){if(a.get("contact_id")){return a.get("accountId")}else{return a.get("account_id")}}else{if(a.hasOwnProperty("contact_id")){return a.accountId}else{if(a.hasOwnProperty("account_id")){return a.account_id}}}return a}return null},getUserId:function(){var b=this.get("user_id");if(!b){return null}var a=(typeof b.get=="function")?b.data:b;if(!a){return null}if(typeof a!="object"){return a}switch(this.get("user_type")){case"user":if(a.hasOwnProperty("contact_id")){return a.contact_id}else{if(a.hasOwnProperty("account_id")){return a.id}}break;default:return a.id;break}}});Tine.Calendar.Model.Attender.getDefaultData=function(){return{user_type:"user",role:"REQ",quantity:1,status:"NEEDS-ACTION"}};Tine.Calendar.Model.Attender.getAttendeeStore=function(a){var b=new Ext.data.SimpleStore({fields:Tine.Calendar.Model.Attender.getFieldDefinitions(),sortInfo:{field:"user_id",direction:"ASC"}});Ext.each(a,function(d){var c=new Tine.Calendar.Model.Attender(d,d.id);b.addSorted(c)});return b};Tine.Calendar.Model.Attender.getAttendeeStatusStore=function(){if(!Tine.Calendar.Model.Attender.attendeeStatusStore){var a=Tine.Tinebase.appMgr.get("Calendar");Tine.Calendar.Model.Attender.attendeeStatusStore=new Ext.data.ArrayStore({storeId:"calendar.attener.status",idIndex:0,fields:["id","status_name"],data:[["NEEDS-ACTION",a.i18n._("No response")],["ACCEPTED",a.i18n._("Accepted")],["DECLINED",a.i18n._("Declined")],["TENTATIVE",a.i18n._("Tentative")]]})}return Tine.Calendar.Model.Attender.attendeeStatusStore};Tine.Calendar.Model.Resource=Tine.Tinebase.data.Record.create(Tine.Tinebase.Model.genericFields.concat([{name:"id"},{name:"name"},{name:"description"},{name:"email"},{name:"is_location",type:"bool"},{name:"tags"},{name:"notes"}]),{appName:"Calendar",modelName:"Resource",idProperty:"id",titleProperty:"name",recordName:"Resource",recordsName:"Resources",containerProperty:null});Ext.namespace("Tine.Calendar");Tine.Calendar.AdminPanel=Ext.extend(Ext.TabPanel,{activeTab:0,initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.items=[new Tine.Calendar.ResourcesGridPanel({title:this.app.i18n._("Manage Resources"),disabled:!Tine.Tinebase.common.hasRight("manage_resources","Calendar")})];Tine.Calendar.AdminPanel.superclass.initComponent.call(this)}});Tine.Calendar.AdminPanel.openWindow=function(a){var b=Tine.WindowFactory.getWindow({width:500,height:470,name:"cal-mange-resources",contentPanelConstructor:"Tine.Calendar.AdminPanel",contentPanelConstructorConfig:a})};Date.msSECOND=1000;Date.msMINUTE=60*Date.msSECOND;Date.msHOUR=60*Date.msMINUTE;Date.msDAY=24*Date.msHOUR;Date.msWEEK=7*Date.msDAY;Ext.ns("Tine.Calendar");Tine.Calendar.CalendarPanel=Ext.extend(Ext.Panel,{view:null,store:null,autoRefreshInterval:300,autoRefreshTask:null,border:false,loadMaskText:"Loading events, please wait...",initComponent:function(){Tine.Calendar.CalendarPanel.superclass.initComponent.call(this);this.app=Tine.Tinebase.appMgr.get("Calendar");this.loadMaskText=this.app.i18n._hidden(this.loadMaskText);this.selModel=this.selModel||new Tine.Calendar.EventSelectionModel();this.autoScroll=false;this.autoWidth=false;this.relayEvents(this.view,["changeView","changePeriod","click","dblclick","contextmenu"]);this.store.on("beforeload",this.onBeforeLoad,this);this.store.on("load",this.onLoad,this);this.store.on("loadexception",this.onLoadException,this);this.autoRefreshTask=new Ext.util.DelayedTask(this.store.load,this.store,[{refresh:true,autoRefresh:true}])},getSelectionModel:function(){return this.selModel},getStore:function(){return this.store},getView:function(){return this.view},onAddEvent:function(a,b){this.setLoading(true);if(a.get("id").match(/new/)){a.set("id","")}if(a.isRecurBase()){this.loadMask.show()}Tine.Calendar.backend.saveRecord(a,{scope:this,success:function(c){if(c.isRecurBase()){this.store.load({refresh:true})}else{this.store.remove(a);this.store.add(c);this.setLoading(false);if(this.view&&this.view.calPanel&&this.view.rendered){this.view.getSelectionModel().select(c)}}},failure:this.onProxyFail.createDelegate(this,[a],true)},{checkBusyConficts:b===false?0:1})},onBeforeLoad:function(a,b){if(!b.refresh){if(this.rendered){this.loadMask.show.defer(50,this.loadMask)}this.store.each(this.view.removeEvent,this.view)}b.params=b.params||{};var c=b.params.filter?b.params.filter:[];c.push({field:"period",operator:"within",value:this.getView().getPeriod()})},onLoad:function(){if(this.rendered){this.loadMask.hide()}if(window.isMainWindow&&this.autoRefreshInterval){this.autoRefreshTask.delay(this.autoRefreshInterval*1000)}},onLoadException:function(c,d,b,a){if(window.isMainWindow&&this.autoRefreshInterval){this.autoRefreshTask.delay(this.autoRefreshInterval*5000)}this.setLoading(false);this.loadMask.hide();if(!a.autoRefresh){this.onProxyFail(b)}},onProxyFail:function(c,d){this.setLoading(false);this.loadMask.hide();if(c.code==901){var a=[];var e={};var f=Tine.Calendar.Model.Attender.getAttendeeStore(d.get("attendee"));Ext.each(c.freebusyinfo,function(g){f.each(function(h){if(h.get("user_type")==g.user_type&&h.getUserId()==g.user_id){if(a.indexOf(h)<0){a.push(h);e[h.id]=[]}e[h.id].push(g)}})},this);var b="";Ext.each(a,function(i){var h=Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderName.call(Tine.Calendar.AttendeeGridPanel.prototype,i.get("user_id"),false,i);b+='<div class="cal-conflict-attendername">'+h+"</div>";var g=[];Ext.each(e[i.id],function(m){var l="H:i";var j=Ext.form.DateField.prototype.format;if(d.get("dtstart").format(j)!=d.get("dtend").format(j)||Date.parseDate(m.dtstart,Date.patterns.ISO8601Long).format(j)!=Date.parseDate(m.dtend,Date.patterns.ISO8601Long).format(j)){l=j+" "+l}var k=Date.parseDate(m.dtstart,Date.patterns.ISO8601Long).format(l)+" - "+Date.parseDate(m.dtend,Date.patterns.ISO8601Long).format(l);if(m.event&&m.event.summary){k+=" : "+m.event.summary}g.push(k)},this);b+='<div class="cal-conflict-eventinfos">'+g.join(", <br />")+"</div>"});this.conflictConfirmWin=Tine.widgets.dialog.MultiOptionsDialog.openWindow({modal:true,allowCancel:false,height:180+15*c.freebusyinfo.length,title:this.app.i18n._("Scheduling Conflict"),questionText:'<div class = "cal-conflict-heading">'+this.app.i18n._("The following attendee are busy at the requested time:")+"</div>"+b,options:[{text:this.app.i18n._("Ignore Conflict"),name:"ignore",checked:true},{text:this.app.i18n._("Edit Event"),name:"edit"},{text:this.app.i18n._("Cancel this action"),name:"cancel"}],scope:this,handler:function(g){switch(g){case"ignore":this.onAddEvent(d,false);this.conflictConfirmWin.close();break;case"edit":this.view.getSelectionModel().select(d);d.dirty=false;this.view.fireEvent("dblclick",this.view,d);this.conflictConfirmWin.close();break;case"cancel":default:this.conflictConfirmWin.close();this.loadMask.show();this.store.load({refresh:true});break}}})}else{Tine.Tinebase.ExceptionHandler.handleRequestException(c)}},onUpdateEvent:function(a){this.setLoading(true);if(a.isRecurBase()){this.loadMask.show()}if(a.isRecurInstance()||(a.isRecurBase()&&!a.get("rrule").newrule)){this.deleteMethodWin=Tine.widgets.dialog.MultiOptionsDialog.openWindow({title:this.app.i18n._("Update Event"),height:170,scope:this,options:[{text:this.app.i18n._("Update this event only"),name:"this"},{text:this.app.i18n._("Update this and all future events"),name:(a.isRecurBase()&&!a.get("rrule").newrule)?"series":"future"},{text:this.app.i18n._("Update whole series"),name:"series"},{text:this.app.i18n._("Update nothing"),name:"cancel"}],handler:function(c){switch(c){case"series":this.loadMask.show();var b={scope:this,success:function(){this.store.load({refresh:true})},failure:this.onProxyFail.createDelegate(this,[a],true)};Tine.Calendar.backend.updateRecurSeries(a,b);break;case"this":case"future":var b={scope:this,success:function(d){if(c==="this"){a=this.store.indexOf(a)!=-1?a:this.store.getById(a.id);this.store.remove(a);this.store.add(d);this.setLoading(false);this.view.getSelectionModel().select(d)}else{this.store.load({refresh:true})}},failure:this.onProxyFail.createDelegate(this,[a],true)};Tine.Calendar.backend.createRecurException(a,false,c=="future",b);default:this.loadMask.show();this.store.load({refresh:true});break}}})}else{this.onUpdateEventAction(a)}},onUpdateEventAction:function(a){Tine.Calendar.backend.saveRecord(a,{scope:this,success:function(b){if(b.isRecurBase()){this.store.load({refresh:true})}else{a=this.store.indexOf(a)!=-1?a:this.store.getById(a.id);this.store.remove(a);this.store.add(b);this.setLoading(false);this.view.getSelectionModel().select(b)}},failure:this.onProxyFail.createDelegate(this,[a],true)},{checkBusyConficts:1})},setLoading:function(a){var b=this.getTopToolbar();if(b&&b.loading){b.loading[a?"disable":"enable"]()}},onRender:function(b,a){Tine.Calendar.CalendarPanel.superclass.onRender.apply(this,arguments);this.loadMask=new Ext.LoadMask(this.body,{msg:this.loadMaskText});var d=this.body;this.el.addClass("cal-panel");this.view.init(this);this.view.on("addEvent",this.onAddEvent,this);this.view.on("updateEvent",this.onUpdateEvent,this);this.view.on("click",this.onClick,this);this.view.on("dblclick",this.onDblClick,this);this.view.on("contextmenu",this.onContextMenu,this);d.on("keydown",this.onKeyDown,this);this.view.render()},afterRender:function(){Tine.Calendar.CalendarPanel.superclass.afterRender.call(this);this.view.layout();this.view.afterRender();this.viewReady=true},onResize:function(b,a){Tine.Calendar.CalendarPanel.superclass.onResize.apply(this,arguments);if(this.viewReady){this.view.layout()}},processEvent:function(a,b){},onClick:function(a,b){this.processEvent("click",a)},onContextMenu:function(a,b){this.processEvent("contextmenu",a)},onDblClick:function(a,b){this.processEvent("dblclick",a)},onKeyDown:function(a){this.fireEvent("keydown",a)}});Ext.ns("Tine.Calendar");Tine.Calendar.EventUI=function(a){this.event=a;this.domIds=[];this.app=Tine.Tinebase.appMgr.get("Calendar");this.init()};Tine.Calendar.EventUI.prototype={addClass:function(a){Ext.each(this.getEls(),function(b){b.addClass(a)})},blur:function(){Ext.each(this.getEls(),function(a){a.blur()})},clearDirty:function(){Ext.each(this.getEls(),function(a){a.setOpacity(1,1)})},focus:function(){Ext.each(this.getEls(),function(a){a.focus()})},getEls:function(){var c=[];for(var a=0;a<this.domIds.length;a++){var b=Ext.get(this.domIds[a]);if(b){c.push(b)}}return c},init:function(){},markDirty:function(){Ext.each(this.getEls(),function(a){a.setOpacity(0.5,1)})},onSelectedChange:function(a){if(a){this.addClass("cal-event-active");this.setStyle({"z-index":1000})}else{this.removeClass("cal-event-active");this.setStyle({"z-index":100})}},remove:function(){var a=this.getEls();for(var b=0;b<a.length;b++){if(a[b]&&typeof a[b].remove=="function"){a[b].remove()}}this.domIds=[]},removeClass:function(a){Ext.each(this.getEls(),function(b){b.removeClass(a)})},render:function(){},setOpacity:function(a){Ext.each(this.getEls(),function(b){b.setStyle(a)})},setStyle:function(a){Ext.each(this.getEls(),function(b){b.setStyle(a)})}};Tine.Calendar.DaysViewEventUI=Ext.extend(Tine.Calendar.EventUI,{clearDirty:function(){Tine.Calendar.DaysViewEventUI.superclass.clearDirty.call(this);Ext.each(this.getEls(),function(a){a.setStyle({"border-style":"solid"})})},getRzInfo:function(a,c,i){var h={};var b=a.event;var g=b.view;var e=a.proxy.getBox();var c=c?c:e.width;var i=i?i:e.height;var d=(b.get("dtend").getTime()-b.get("dtstart").getTime())/Date.msMINUTE;if(b.get("is_all_day_event")){var f=Ext.fly(g.wholeDayArea).getWidth()/g.numOfDays;h.diff=Math.round((c-a.originalWidth)/f)}else{h.diff=Math.round((i-a.originalHeight)*(g.timeGranularity/g.granularityUnitHeights));h.diff=Math.round(h.diff/15)*15}h.duration=d+h.diff;if(b.get("is_all_day_event")){h.dtend=b.get("dtend").add(Date.DAY,h.diff)}else{h.dtend=b.get("dtstart").add(Date.MINUTE,h.duration)}return h},markDirty:function(){Tine.Calendar.DaysViewEventUI.superclass.markDirty.call(this);Ext.each(this.getEls(),function(a){a.setStyle({"border-style":"dashed"})})},onSelectedChange:function(a){Tine.Calendar.DaysViewEventUI.superclass.onSelectedChange.call(this,a);if(a){this.addClass("cal-daysviewpanel-event-active")}else{this.removeClass("cal-daysviewpanel-event-active")}},render:function(b){this.event.view=b;this.colorSet=Tine.Calendar.colorMgr.getColor(this.event);this.event.colorSet=this.colorSet;this.dtStart=this.event.get("dtstart");this.startColNum=b.getColumnNumber(this.dtStart);this.dtEnd=this.event.get("dtend");if(this.event.get("editGrant")){this.extraCls="cal-daysviewpanel-event-editgrant"}if(this.dtEnd.format("H:i")=="00:00"){this.dtEnd=this.dtEnd.add(Date.MINUTE,-1)}this.endColNum=b.getColumnNumber(this.dtEnd);if(this.endColNum<0||this.startColNum>b.numOfDays-1){return}this.statusIcons=[];if(this.event.get("class")==="PRIVATE"){this.statusIcons.push({status:"private",text:this.app.i18n._("private classification")})}if(this.event.get("rrule")){this.statusIcons.push({status:"recur",text:this.app.i18n._("recurring event")})}if(!Ext.isEmpty(this.event.get("alarms"))){this.statusIcons.push({status:"alarm",text:this.app.i18n._("has alarm")})}var e=this.event.getMyAttenderRecord();if(e){this.statusIcons.push({status:e.get("status"),text:Tine.Calendar.Model.Attender.getAttendeeStatusStore().getById(e.get("status")).get("status_name")})}var c=this.event.get("is_all_day_event")?b.parallelWholeDayEventsRegistry:b.parallelScrollerEventsRegistry;var a=c.getPosition(this.event);var d=c.getMaxParalles(this.dtStart,this.dtEnd);if(this.event.get("is_all_day_event")){this.renderAllDayEvent(b,d,a)}else{this.renderScrollerEvent(b,d,a)}if(this.event.dirty){this.onSelectedChange(true)}},renderAllDayEvent:function(i,e,h){var f=this.extraCls;var g=Ext.fly(i.wholeDayArea).getWidth();var b=Math.round(g*(this.dtEnd.getTime()-this.dtStart.getTime())/(i.numOfDays*Date.msDAY))-5;var c=Math.round(g*(this.dtStart.getTime()-i.startDate.getTime())/(i.numOfDays*Date.msDAY));if(this.startColNum<0){b=b-Math.abs(this.startColNum)*(g/i.numOfDays);c=0;f=f+" cal-daysviewpanel-event-cropleft"}if(this.endColNum>i.numOfDays){b=b-Math.abs(this.endColNum-i.numOfDays)*(g/i.numOfDays);f=f+" cal-daysviewpanel-event-cropright"}var d=Ext.id()+"-event:"+this.event.get("id");this.domIds.push(d);var a=i.templates.wholeDayEvent.insertFirst(i.wholeDayArea,{id:d,summary:this.event.get("summary"),startTime:this.dtStart.format("H:i"),extraCls:f,color:this.colorSet.color,bgColor:this.colorSet.light,textColor:this.colorSet.text,zIndex:100,width:b+"px",height:"15px",left:c+"px",top:h*18+"px",statusIcons:this.statusIcons},true);if(this.event.dirty){a.setStyle({"border-style":"dashed"});a.setOpacity(0.5)}if(!(this.endColNum>i.numOfDays)&&this.event.get("editGrant")){this.resizeable=new Ext.Resizable(a,{handles:"e",disableTrackOver:true,dynamic:true,widthIncrement:Math.round(g/i.numOfDays),minWidth:Math.round(g/i.numOfDays),listeners:{scope:i,resize:i.onEventResize,beforeresize:i.onBeforeEventResize}})}},renderScrollerEvent:function(h,c,f){var d=h.granularityUnitHeights*((24*60)/h.timeGranularity);for(var j=this.startColNum;j<=this.endColNum;j++){var e=this.extraCls;if(j<0||j>=h.numOfDays){continue}var g=h.getTimeOffset(this.dtStart);var i=this.startColNum==this.endColNum?h.getTimeHeight(this.dtStart,this.dtEnd):h.getTimeOffset(this.dtEnd);if(j!=this.startColNum){g=0;e=e+" cal-daysviewpanel-event-croptop"}if(this.endColNum!=j){i=h.getTimeHeight(this.dtStart,this.dtStart.add(Date.DAY,1));e=e+" cal-daysviewpanel-event-cropbottom"}var b=Ext.id()+"-event:"+this.event.get("id");this.domIds.push(b);if(i<=12){i=12}if(g>d-12){g=d-12}var a=h.templates.event.append(h.getDateColumnEl(j),{id:b,summary:i>=24?this.event.get("summary"):"",startTime:(i>=24&&g<=d-24)?this.dtStart.format("H:i"):this.dtStart.format("H:i")+" "+this.event.get("summary"),extraCls:e,color:this.colorSet.color,bgColor:this.colorSet.light,textColor:this.colorSet.text,zIndex:100,height:i+"px",left:Math.round(f*90*1/c)+"%",width:Math.round(90*1/c)+"%",top:g+"px",statusIcons:this.statusIcons},true);if(this.event.dirty){a.setStyle({"border-style":"dashed"});a.setOpacity(0.5)}if(j==this.endColNum&&this.event.get("editGrant")){this.resizeable=new Ext.Resizable(a,{handles:"s",disableTrackOver:true,dynamic:true,heightIncrement:h.granularityUnitHeights/2,listeners:{scope:h,resize:h.onEventResize,beforeresize:h.onBeforeEventResize}})}}}});Tine.Calendar.MonthViewEventUI=Ext.extend(Tine.Calendar.EventUI,{onSelectedChange:function(a){Tine.Calendar.MonthViewEventUI.superclass.onSelectedChange.call(this,a);if(a){this.addClass("cal-monthview-active");this.setStyle({"background-color":this.color,color:(this.colorSet)?this.colorSet.text:"#000000"})}else{this.removeClass("cal-monthview-active");this.setStyle({"background-color":this.is_all_day_event?this.bgColor:"",color:this.is_all_day_event?"#000000":this.color})}}});Ext.ns("Tine.Calendar");Tine.Calendar.EventSelectionModel=Ext.extend(Ext.tree.MultiSelectionModel,{init:function(a){a.getTreeEl=function(){return a.el};a.el.on("keydown",this.onKeyDown,this);a.on("click",this.onNodeClick,this)},getCount:function(){return this.getSelectedNodes().length},getSelected:function(){var a=this.getSelectedEvents();return a.length>0?a[0]:null},getSelectedEvents:function(){return this.getSelectedNodes()},select:function(a,c,b){if(!a||!a.ui){return a}Tine.Calendar.EventSelectionModel.superclass.select.apply(this,arguments)},onKeyDown:Ext.emptyFn});Ext.ns("Tine.Calendar");Tine.Calendar.DaysView=function(a){Ext.apply(this,a);Tine.Calendar.DaysView.superclass.constructor.call(this);this.addEvents("click","contextmenu","dblclick","changeView","changePeriod","addEvent","updateEvent")};Ext.extend(Tine.Calendar.DaysView,Ext.util.Observable,{startDate:new Date(),numOfDays:4,newEventSummary:"New Event",dayFormatString:"{0}, the {1}. of {2}",timeGranularity:30,granularityUnitHeights:18,denyDragOnMissingEditGrant:true,timeScale:null,scrollOffset:19,editing:false,activeEvent:null,ds:null,updatePeriod:function(a){this.toDay=new Date().clearTime();this.startDate=a.from;var b=this.calPanel.getTopToolbar();if(b){b.periodPicker.update(this.startDate);this.startDate=b.periodPicker.getPeriod().from}this.endDate=this.startDate.add(Date.DAY,this.numOfDays+1);this.updateDayHeaders();this.onBeforeScroll();this.fireEvent("changePeriod",a)},init:function(a){this.calPanel=a;this.app=Tine.Tinebase.appMgr.get("Calendar");this.newEventSummary=this.app.i18n._hidden(this.newEventSummary);this.dayFormatString=this.app.i18n._hidden(this.dayFormatString);this.startDate.setHours(0);this.startDate.setMinutes(0);this.startDate.setSeconds(0);this.endDate=this.startDate.add(Date.DAY,this.numOfDays+1);this.parallelScrollerEventsRegistry=new Tine.Calendar.ParallelEventsRegistry({dtStart:this.startDate,dtEnd:this.endDate});this.parallelWholeDayEventsRegistry=new Tine.Calendar.ParallelEventsRegistry({dtStart:this.startDate,dtEnd:this.endDate});this.initData(a.store);this.initTimeScale();this.initTemplates();this.calPanel.on("beforehide",this.onBeforeHide,this);this.calPanel.on("show",this.onShow,this);Tine.Tinebase.appMgr.on("activate",this.onAppActivate,this)},initData:function(a){if(this.ds){this.ds.un("load",this.onLoad,this);this.ds.un("datachanged",this.onDataChange,this);this.ds.un("add",this.onAdd,this);this.ds.un("remove",this.onRemove,this);this.ds.un("update",this.onUpdate,this);this.ds.un("clear",this.onClear,this)}if(a){a.on("load",this.onLoad,this);a.on("datachanged",this.onDataChange,this);a.on("add",this.onAdd,this);a.on("remove",this.onRemove,this);a.on("update",this.onUpdate,this);a.on("clear",this.onClear,this)}this.ds=a},initTimeScale:function(){var e=[];var a=Date.msDAY/(this.timeGranularity*Date.msMINUTE);var d=this.startDate.clone();var c;for(var b=0;b<a;b++){c=b*this.timeGranularity;e.push([b,c,c*Date.msMINUTE,d.add(Date.MINUTE,c).format("H:i")])}this.timeScale=new Ext.data.SimpleStore({fields:["index","minutes","milliseconds","time"],data:e,id:"index"})},initDropZone:function(){this.dd=new Ext.dd.DropZone(this.mainWrap.dom,{ddGroup:"cal-event",notifyOver:function(a,h,g){var b=Ext.fly(g.sourceEl);b.setStyle({"border-style":"dashed"});b.setOpacity(0.5);if(g.event){var f=g.event;g.scope.getSelectionModel().select(f);var c=Tine.Calendar.DaysView.prototype.getTargetDateTime.call(g.scope,h);if(c){var d=c.format(c.is_all_day_event?Ext.form.DateField.prototype.format:"H:i");if(!f.data.is_all_day_event){Ext.fly(a.proxy.el.query("div[class=cal-daysviewpanel-event-header-inner]")[0]).update(d)}if(f.get("editGrant")){return Math.abs(c.getTime()-f.get("dtstart").getTime())<Date.msMINUTE?"cal-daysviewpanel-event-drop-nodrop":"cal-daysviewpanel-event-drop-ok"}}}return"cal-daysviewpanel-event-drop-nodrop"},notifyOut:function(){},notifyDrop:function(a,h,g){var c=g.scope;var d=c.getTargetDateTime(h);if(d){var f=g.event;if(!f.get("editGrant")||Math.abs(d.getTime()-f.get("dtstart").getTime())<Date.msMINUTE){return false}f.beginEdit();var b=(f.get("dtend").getTime()-f.get("dtstart").getTime())/Date.msMINUTE;f.set("dtstart",d);if(!f.get("is_all_day_event")&&d.is_all_day_event&&f.duration<Date.msDAY){f.set("dtend",d.add(Date.DAY,1))}else{if(f.get("is_all_day_event")&&!d.is_all_day_event){f.set("dtend",d.add(Date.HOUR,1))}else{f.set("dtend",d.add(Date.MINUTE,b))}}f.set("is_all_day_event",d.is_all_day_event);f.endEdit();c.fireEvent("updateEvent",f)}return !!d}})},initDragZone:function(){this.scroller.ddScrollConfig={vthresh:this.granularityUnitHeights*2,increment:this.granularityUnitHeights*4,hthresh:-1,frequency:500};Ext.dd.ScrollManager.register(this.scroller);this.dragZone=new Ext.dd.DragZone(this.el,{ddGroup:"cal-event",view:this,scroll:false,containerScroll:true,getDragData:function(h){var c=this.view.getSelectionModel().getSelectedEvents();var a=h.getTarget("div.cal-daysviewpanel-event",10);if(a){var g=a.id.split(":");var f=this.view.ds.getById(g[1]);if(!f||f.dirty||(this.view.denyDragOnMissingEditGrant&&!f.get("editGrant"))){return}var i=Ext.get(f.ui.domIds[0]).dom.cloneNode(true);i.id=Ext.id();if(f.get("is_all_day_event")){Ext.fly(i).setLeft(0)}else{var b=(Ext.fly(this.view.dayCols[0]).getWidth()*0.9);Ext.fly(i).setTop(0);Ext.fly(i).setWidth(b);Ext.fly(i).setHeight(this.view.getTimeHeight.call(this.view,f.get("dtstart"),f.get("dtend")))}return{scope:this.view,sourceEl:a,event:f,ddel:i,selections:this.view.getSelectionModel().getSelectedEvents()}}},getRepairXY:function(b,a){Ext.fly(this.dragData.sourceEl).setStyle({"border-style":"solid"});Ext.fly(this.dragData.sourceEl).setOpacity(1,1);return Ext.fly(this.dragData.sourceEl).getXY()}})},render:function(){this.templates.master.append(this.calPanel.body,{header:this.templates.header.applyTemplate({daysHeader:this.getDayHeaders(),wholeDayCols:this.getWholeDayCols()}),body:this.templates.body.applyTemplate({timeRows:this.getTimeRows(),dayColumns:this.getDayColumns()})});this.initElements();this.getSelectionModel().init(this)},afterRender:function(){this.mainWrap.on("click",this.onClick,this);this.mainWrap.on("dblclick",this.onDblClick,this);this.mainWrap.on("contextmenu",this.onContextMenu,this);this.mainWrap.on("mousedown",this.onMouseDown,this);this.mainWrap.on("mouseup",this.onMouseUp,this);this.calPanel.on("resize",this.onResize,this);this.initDropZone();this.initDragZone();this.updatePeriod({from:this.startDate});if(this.dsLoaded){this.onLoad.apply(this)}this.isScrolling=true;try{var b=this.app.getRegistry().get("preferences").get("daysviewstarttime");var a=Date.parseDate(b,"H:i");if(!Ext.isDate(a)){throw new Ext.Error("no valid startime given")}this.scrollTo(a)}catch(c){this.scrollTo()}this.layout();this.rendered=true},scrollTo:function(a){a=Ext.isDate(a)?a:new Date();this.scroller.dom.scrollTop=this.getTimeOffset(a)},onBeforeScroll:function(){if(!this.isScrolling){this.isScrolling=true;Ext.each(this.dayCols,function(e,a){var c=Ext.get(e),b=c.down("img[class=cal-daysviewpanel-body-daycolumn-hint-above]"),d=c.down("img[class=cal-daysviewpanel-body-daycolumn-hint-below]");b.setDisplayed(false);d.setDisplayed(false)},this)}},onScroll:function(h,c,i){var a=this.scroller.dom.clientHeight,g=this.scroller.dom.scrollTop,d=g+a,b=[],f=[];this.ds.each(function(e){if(e.ui){Ext.each(e.ui.domIds,function(l){var j=Ext.get(l),k=j.getBox(false,true);if(k.bottom<=g){b.push(j.up("div[class^=cal-daysviewpanel-body-daycolumn]"))}else{if(k.bottom-k.height>=d){f.push(j.up("div[class^=cal-daysviewpanel-body-daycolumn]"))}}},this)}});Ext.each(this.dayCols,function(m,e){var k=Ext.get(m),j=k.down("img[class=cal-daysviewpanel-body-daycolumn-hint-above]"),l=k.down("img[class=cal-daysviewpanel-body-daycolumn-hint-below]");if(b.indexOf(k)>=0){j.setTop(g+5);if(!j.isVisible()){j.fadeIn({duration:1.6})}}if(f.indexOf(k)>=0){l.setTop(d-14);if(!l.isVisible()){l.fadeIn({duration:1.6})}}},this);this.isScrolling=false},onShow:function(){this.scroller.dom.scrollTop=this.lastScrollPos||this.getTimeOffset(new Date())},onBeforeHide:function(){this.lastScrollPos=this.scroller.dom.scrollTop},insertEvent:function(a){a.ui=new Tine.Calendar.DaysViewEventUI(a);a.ui.render(this)},removeAllEvents:function(){var b=Ext.DomQuery.select("div[class^=cal-daysviewpanel-event]",this.mainWrap.dom);for(var a=0;a<b.length;a++){Ext.fly(b[a]).remove()}this.ds.each(function(c){if(c.ui){c.ui.domIds=[]}})},removeEvent:function(a){if(a==this.activeEvent){this.activeEvent=null}if(a.ui){a.ui.remove()}},setActiveEvent:function(a){this.activeEvent=a||null},getActiveEvent:function(){return this.activeEvent},getSelectionModel:function(){return this.calPanel.getSelectionModel()},createEvent:function(d,c){if(this.editing||(c.isRangeAdd&&!this.mouseDown)){return}this.editing=c;this.ds.suspendEvents();this.ds.add(c);this.ds.resumeEvents();var a=c.get("is_all_day_event")?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;a.register(c);this.insertEvent(c);this.layout();if(c.isRangeAdd){c.ui.resizeable.on("resize",function(){if(c.get("is_all_day_event")){var e=true}else{var e=(c.get("dtend").getTime()-c.get("dtstart").getTime())/Date.msMINUTE>=this.timeGranularity}if(e){this.startEditSummary(c)}else{this.abortCreateEvent(c)}},this);var b=c.get("is_all_day_event")?"east":"south";if(Ext.isIE){d.browserEvent={type:"mousedown"}}c.ui.resizeable[b].onMouseDown.call(c.ui.resizeable[b],d)}else{this.startEditSummary(c)}},abortCreateEvent:function(a){this.ds.remove(a);this.editing=false},startEditSummary:function(b){if(b.summaryEditor){return false}var a=b.ui.getEls();var c=b.get("is_all_day_event")?"cal-daysviewpanel-wholedayevent-body":"cal-daysviewpanel-event-body";b.summaryEditor=new Ext.form.TextArea({event:b,renderTo:a[0].down("div[class="+c+"]"),width:b.ui.getEls()[0].getWidth()-12,height:Math.max(12,b.ui.getEls()[0].getHeight()-18),style:"background-color: transparent; background: 0: border: 0; position: absolute; top: 0px;",value:this.newEventSummary,enableKeyEvents:true,listeners:{scope:this,render:function(d){d.focus(true,100)},blur:this.endEditSummary,specialkey:this.endEditSummary,keydown:this.endEditSummary}})},endEditSummary:function(f,d){var c=f.event;var b=f.getValue();if(!this.editing){return}if(d&&d.getKey()==d.ESC){return this.abortCreateEvent(c)}if(d&&d.getKey()!=d.ENTER){return}if(!b){return this.abortCreateEvent(c)}this.editing=false;c.summaryEditor=false;c.set("summary",b);this.ds.suspendEvents();this.ds.remove(c);this.ds.resumeEvents();var a=c.get("is_all_day_event")?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;a.unregister(c);this.removeEvent(c);c.dirty=true;this.ds.add(c);this.fireEvent("addEvent",c)},onAppActivate:function(a){if(a===this.app){}},onResize:function(a){(function(){this.ds.each(function(b){if(b.get("is_all_day_event")){this.removeEvent(b);this.insertEvent(b)}},this)}).defer(50,this)},onClick:function(b){var c=b.getTarget("img[class^=cal-daysviewpanel-body-daycolumn-hint-]",10,true);if(c){this.scroller.scroll(c.hasClass("cal-daysviewpanel-body-daycolumn-hint-above")?"t":"b",10000,true);return}var a=this.getTargetEvent(b);if(a){this.fireEvent("click",a,b)}},onContextMenu:function(a){this.fireEvent("contextmenu",a)},onDblClick:function(h,g){h.stopEvent();var d=this.getTargetEvent(h);var f=this.getTargetDateTime(h);if(d){this.fireEvent("dblclick",d,h)}else{if(f&&!this.editing){var c="cal-daysviewpanel-new-"+Ext.id();var a=f.add(Date.HOUR,1);if(f.is_all_day_event){a=a.add(Date.HOUR,23).add(Date.SECOND,-1)}var d=new Tine.Calendar.Model.Event(Ext.apply(Tine.Calendar.Model.Event.getDefaultData(),{id:c,dtstart:f,dtend:a,is_all_day_event:f.is_all_day_event}),c);this.createEvent(h,d);d.dirty=true}else{if(g.className=="cal-daysviewpanel-dayheader-day"){var i=Ext.DomQuery.select("div[class=cal-daysviewpanel-dayheader-day]",this.innerHd);var b=this.startDate.add(Date.DAY,i.indexOf(g));this.fireEvent("changeView","day",b)}}}},onMouseDown:function(f){if(f.button!==0){return}if(!this.editing){this.focusEl.focus()}this.mouseDown=true;var b=this.getTargetEvent(f);if(this.editing&&this.editing.summaryEditor&&(b!=this.editing)){this.editing.summaryEditor.fireEvent("blur",this.editing.summaryEditor)}var d=this.getTargetDateTime(f);if(d){var a="cal-daysviewpanel-new-"+Ext.id();var c=new Tine.Calendar.Model.Event(Ext.apply(Tine.Calendar.Model.Event.getDefaultData(),{id:a,dtstart:d,dtend:d.is_all_day_event?d.add(Date.HOUR,24).add(Date.SECOND,-1):d.add(Date.MINUTE,2*this.timeGranularity/2),is_all_day_event:d.is_all_day_event}),a);c.isRangeAdd=true;c.dirty=true;f.stopEvent();this.createEvent.defer(100,this,[f,c])}},onMouseUp:function(){this.mouseDown=false},onBeforeEventResize:function(b,d){var c=b.el.id.split(":");var a=this.ds.getById(c[1]);b.event=a;b.originalHeight=b.el.getHeight();b.originalWidth=b.el.getWidth();b.onMouseMove=b.onMouseMove.createSequence(function(){var e=this.event;if(!e){return}var f=e.ui;var g=f.getRzInfo(this);this.durationEl.update(g.dtend.format(e.get("is_all_day_event")?Ext.form.DateField.prototype.format:"H:i"))},b);a.ui.markDirty();if(!b.durationEl){b.durationEl=b.el.insertFirst({"class":"cal-daysviewpanel-event-rzduration",style:"position: absolute; bottom: 3px; right: 2px; z-index: 1000;"})}b.durationEl.update(a.get("dtend").format(a.get("is_all_day_event")?Ext.form.DateField.prototype.format:"H:i"));if(a){this.getSelectionModel().select(a)}else{this.getSelectionModel().clearSelections()}},onEventResize:function(d,b,a){var c=d.event;if(!c){return}var e=c.ui.getRzInfo(d,b,a);if(e.diff!=0){c.set("dtend",e.dtend)}if(c.summaryEditor){c.summaryEditor.setHeight(c.ui.getEls()[0].getHeight()-18)}if(e.diff!=0&&c!=this.editing&&!c.isRangeAdd){this.fireEvent("updateEvent",c)}else{c.ui.clearDirty()}},onDataChange:function(){},onClear:function(){},onUpdate:function(c,b){if(b.get("id").match(/new/)){return}var d=(b.modified.hasOwnProperty("is_all_day_event")?b.modified.is_all_day_event:b.get("is_all_day_event"))?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;var a=b.get("is_all_day_event")?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;var e=b.modified.hasOwnProperty("dtstart")?b.modified.dtstart:b.get("dtstart");var f=b.modified.hasOwnProperty("dtend")?b.modified.dtend:b.get("dtend");var h=d.getEvents(e,f);for(var g=0;g<h.length;g++){this.removeEvent(h[g])}d.unregister(b);var h=d.getEvents(e,f);for(var g=0;g<h.length;g++){this.insertEvent(h[g])}var i=a.getEvents(b.get("dtstart"),b.get("dtend"));for(var g=0;g<i.length;g++){this.removeEvent(i[g])}a.register(b);var i=a.getEvents(b.get("dtstart"),b.get("dtend"));for(var g=0;g<i.length;g++){this.insertEvent(i[g])}this.setActiveEvent(this.getActiveEvent());this.layout()},onAdd:function(h,b,e){for(var f=0;f<b.length;f++){var g=b[f];var a=g.get("is_all_day_event")?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;a.register(g);var d=a.getEvents(g.get("dtstart"),g.get("dtend"));for(var c=0;c<d.length;c++){this.removeEvent(d[c]);this.insertEvent(d[c])}}this.layout()},onRemove:function(e,c,b,d){if(!c||b==-1){return}if(d!==true){}var a=c.get("is_all_day_event")?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;a.unregister(c);this.removeEvent(c);this.getSelectionModel().unselect(c);this.layout()},onLoad:function(){if(!this.rendered){this.dsLoaded=true;return}this.removeAllEvents();this.parallelScrollerEventsRegistry=new Tine.Calendar.ParallelEventsRegistry({dtStart:this.startDate,dtEnd:this.endDate});this.parallelWholeDayEventsRegistry=new Tine.Calendar.ParallelEventsRegistry({dtStart:this.startDate,dtEnd:this.endDate});this.ds.fields=Tine.Calendar.Model.Event.prototype.fields;this.ds.sortInfo={field:"dtstart",direction:"ASC"};this.ds.applySort();this.ds.each(function(b){var a=b.get("is_all_day_event")?this.parallelWholeDayEventsRegistry:this.parallelScrollerEventsRegistry;a.register(b)},this);this.ds.each(this.insertEvent,this);this.layout()},print:function(){var a=new Tine.Calendar.Printer.DaysViewRenderer();a.print(this)},hex2dec:function(c){var f=0;c=c.toString();var b=c.length,e,d;for(var a=0;a<b;a++){e=Math.pow(16,(Math.abs(a-c.length)-1));d=parseInt(c.toString().charAt([a]),10);if(isNaN(d)){switch(c.toString().charAt([a]).toUpperCase()){case"A":d=10;break;case"B":d=11;break;case"C":d=12;break;case"D":d=13;break;case"E":d=14;break;case"F":d=15;break;default:return NaN}}f=f+(e*d)}return f},getPeriod:function(){return{from:this.startDate,until:this.startDate.add(Date.DAY,this.numOfDays)}},getTargetDateTime:function(f){var d=f.getTarget();if(d.id.match(/^ext-gen\d+:\d+/)){var c=d.id.split(":");var a=this.startDate.add(Date.DAY,parseInt(c[1],10));a.is_all_day_event=true;if(c[2]){var b=this.timeScale.getAt(c[2]);a=a.add(Date.MINUTE,b.get("minutes"));a.is_all_day_event=false}return a}},getTargetEvent:function(d){var c=d.getTarget();var a=Ext.fly(c);if(a.hasClass("cal-daysviewpanel-event")||(a=a.up("[id*=event:]",10))){var b=a.dom.id.split(":");return this.ds.getById(b[1])}},getTimeOffset:function(a){var b=this.granularityUnitHeights/this.timeGranularity;return Math.round(b*(60*a.getHours()+a.getMinutes()))},getTimeHeight:function(b,a){var c=this.granularityUnitHeights/this.timeGranularity;return Math.round(c*((a.getTime()-b.getTime())/Date.msMINUTE))},initElements:function(){var c=Ext.Element;var b=this.calPanel.body.dom.firstChild;var a=b.childNodes;this.el=new c(b);this.mainWrap=new c(a[0]);this.mainHd=new c(this.mainWrap.dom.firstChild);this.innerHd=this.mainHd.dom.firstChild;this.wholeDayArea=this.innerHd.firstChild.childNodes[1];this.scroller=new c(this.mainWrap.dom.childNodes[1]);this.scroller.setStyle("overflow-x","hidden");this.scroller.on("scroll",this.onBeforeScroll,this);this.scroller.on("scroll",this.onScroll,this,{buffer:200});this.mainBody=new c(this.scroller.dom.firstChild);this.dayCols=this.mainBody.dom.firstChild.lastChild.childNodes;this.focusEl=new c(this.el.dom.lastChild);this.focusEl.swallowEvent("click",true);this.focusEl.swallowEvent("dblclick",true);this.focusEl.swallowEvent("contextmenu",true)},getColumnNumber:function(a){return Math.floor((a.add(Date.SECOND,1).getTime()-this.startDate.getTime())/Date.msDAY)},getDateColumnEl:function(a){return this.dayCols[a]},checkWholeDayEls:function(){var b=[];for(var a=0;a<this.wholeDayArea.childNodes.length-1;a++){if(this.wholeDayArea.childNodes[a].childNodes.length===1){b.push(a)}}for(var a=1;a<b.length;a++){Ext.fly(this.wholeDayArea.childNodes[b[a]]).remove()}},layout:function(){if(!this.mainBody){return}var d=this.calPanel;var h=d.body;var a=h.getSize(true);var b=a.width;this.el.setSize(a.width,a.height);this.layoutWholeDayHeader();var f=this.mainHd.getHeight();var e=a.height-(f);this.scroller.setSize(b,e);this.innerHd.style.width=(b+2)+"px";this.onScroll.defer(100,this)},layoutWholeDayHeader:function(){var c=Ext.get(this.wholeDayArea);for(var b=0,a=c.getTop();b<this.wholeDayArea.childNodes.length-1;b++){a=Math.max(parseInt(Ext.get(this.wholeDayArea.childNodes[b]).getBottom(),10),a)}c.setHeight(a-c.getTop()+10)},getDayHeaders:function(){var d="";var e=100/this.numOfDays;for(var c=0,b;c<this.numOfDays;c++){var a=this.startDate.add(Date.DAY,c);d+=this.templates.dayHeader.applyTemplate({day:String.format(this.dayFormatString,a.format("l"),a.format("j"),a.format("F")),height:this.granularityUnitHeights,width:e+"%",left:c*e+"%"})}return d},updateDayHeaders:function(){var e=Ext.DomQuery.select("div[class=cal-daysviewpanel-dayheader-day]",this.innerHd);for(var d=0,c,a,f,b;d<e.length;d++){c=this.startDate.add(Date.DAY,d);a=c.getTime()==this.toDay.getTime();f=Ext.fly(e[d]);f.update(String.format(this.dayFormatString,c.format("l"),c.format("j"),c.format("F")));f.parent()[(a?"add":"remove")+"Class"]("cal-daysviewpanel-dayheader-today");Ext.fly(this.dayCols[d])[(a?"add":"remove")+"Class"]("cal-daysviewpanel-body-daycolumn-today")}},getWholeDayCols:function(){var c="";var d=100/this.numOfDays;var a=Ext.id();for(var b=0;b<this.numOfDays;b++){c+=this.templates.wholeDayCol.applyTemplate({id:a+":"+b,width:d+"%",left:b*d+"%"})}return c},getTimeRows:function(){var a="";this.timeScale.each(function(c){var b=c.get("index");a+=this.templates.timeRow.applyTemplate({cls:b%2?"cal-daysviewpanel-timeRow-off":"cal-daysviewpanel-timeRow-on",height:this.granularityUnitHeights+"px",top:b*this.granularityUnitHeights+"px",time:b%2?"":c.get("time")})},this);return a},getDayColumns:function(){var b="";var c=100/this.numOfDays;for(var a=0;a<this.numOfDays;a++){b+=this.templates.dayColumn.applyTemplate({width:c+"%",left:a*c+"%",overRows:this.getOverRows(a)})}return b},getOverRows:function(c){var b="";var a=Ext.id();this.timeScale.each(function(e){var d=e.get("index");b+=this.templates.overRow.applyTemplate({id:a+":"+c+":"+d,cls:"cal-daysviewpanel-daycolumn-row-"+(d%2?"off":"on"),height:this.granularityUnitHeights+"px"})},this);return b},initTemplates:function(){var c=this.templates||{};c.master=new Ext.XTemplate('<div class="cal-daysviewpanel" hidefocus="true">','<div class="cal-daysviewpanel-viewport">','<div class="cal-daysviewpanel-header"><div class="cal-daysviewpanel-header-inner"><div class="cal-daysviewpanel-header-offset">{header}</div></div><div class="x-clear"></div></div>','<div class="cal-daysviewpanel-scroller"><div class="cal-daysviewpanel-body">{body}</div></div>',"</div>",'<a href="#" class="cal-daysviewpanel-focus" tabIndex="-1"></a>',"</div>");c.header=new Ext.XTemplate('<div class="cal-daysviewpanel-daysheader">{daysHeader}</div><div class="cal-daysviewpanel-wholedayheader"><div class="cal-daysviewpanel-wholedayheader-daycols">{wholeDayCols}</div></div>');c.dayHeader=new Ext.XTemplate('<div class="cal-daysviewpanel-dayheader" style="height: {height}; width: {width}; left: {left};"><div class="cal-daysviewpanel-dayheader-day-wrap"><div class="cal-daysviewpanel-dayheader-day">{day}</div></div>',"</div>");c.wholeDayCol=new Ext.XTemplate('<div class="cal-daysviewpanel-body-wholedaycolumn" style="left: {left}; width: {width};"><div id="{id}" class="cal-daysviewpanel-body-wholedaycolumn-over">&#160;</div></div>');c.body=new Ext.XTemplate('<div class="cal-daysviewpanel-body-inner">{timeRows}<div class="cal-daysviewpanel-body-daycolumns">{dayColumns}</div></div>');c.timeRow=new Ext.XTemplate('<div class="{cls}" style="height: {height}; top: {top};">','<div class="cal-daysviewpanel-timeRow-time">{time}</div>',"</div>");c.dayColumn=new Ext.XTemplate('<div class="cal-daysviewpanel-body-daycolumn" style="left: {left}; width: {width};">','<div class="cal-daysviewpanel-body-daycolumn-inner">&#160;</div>',"{overRows}",'<img src="',Ext.BLANK_IMAGE_URL,'" class="cal-daysviewpanel-body-daycolumn-hint-above" />','<img src="',Ext.BLANK_IMAGE_URL,'" class="cal-daysviewpanel-body-daycolumn-hint-below" />',"</div>");c.overRow=new Ext.XTemplate('<div class="cal-daysviewpanel-daycolumn-row" style="height: {height};"><div id="{id}" class="{cls}" >&#160;</div></div>');c.event=new Ext.XTemplate('<div id="{id}" class="cal-daysviewpanel-event {extraCls}" style="width: {width}; height: {height}; left: {left}; top: {top}; z-index: {zIndex}; background-color: {bgColor}; border-color: {color};"><div class="cal-daysviewpanel-event-header" style="background-color: {color};"><div class="cal-daysviewpanel-event-header-inner" style="color: {textColor}; background-color: {color}; z-index: {zIndex};">{startTime}</div><div class="cal-daysviewpanel-event-header-icons"><tpl for="statusIcons"><img src="',Ext.BLANK_IMAGE_URL,"\" class=\"cal-status-icon {status}-{[parent.textColor == '#FFFFFF' ? 'white' : 'black']}\" ext:qtip=\"{text}\" />",'</tpl></div></div><div class="cal-daysviewpanel-event-body">{[Ext.util.Format.nl2br(Ext.util.Format.htmlEncode(values.summary))]}</div></div>');c.wholeDayEvent=new Ext.XTemplate('<div id="{id}" class="cal-daysviewpanel-event {extraCls}" style="width: {width}; height: {height}; left: {left}; top: {top}; z-index: {zIndex}; background-color: {bgColor}; border-color: {color};"><div class="cal-daysviewpanel-wholedayevent-body">{[Ext.util.Format.nl2br(Ext.util.Format.htmlEncode(values.summary))]}</div><div class="cal-daysviewpanel-event-header-icons" style="background-color: {bgColor};" ><tpl for="statusIcons"><img src="',Ext.BLANK_IMAGE_URL,'" class="cal-status-icon {status}-black" ext:qtip="{text}" />',"</tpl></div></div>");for(var a in c){var b=c[a];if(b&&typeof b.compile=="function"&&!b.compiled){b.disableFormats=true;b.compile()}}this.templates=c}});Ext.ns("Tine.Calendar");Tine.Calendar.MonthView=function(a){Ext.apply(this,a);Tine.Calendar.MonthView.superclass.constructor.call(this);this.addEvents("click","contextmenu","dblclick","changeView","changePeriod","addEvent","updateEvent")};Ext.extend(Tine.Calendar.MonthView,Ext.util.Observable,{startDate:new Date().clearTime(),newEventSummary:"New Event",calWeekString:"WK",moreString:"{0} more...",monthNames:Date.monthNames,dayNames:Date.dayNames,startDay:Ext.DatePicker.prototype.startDay,denyDragOnMissingEditGrant:true,activeEvent:null,toDay:null,dateMesh:null,parallelEventsRegistry:null,afterRender:function(){this.initElements();this.getSelectionModel().init(this);this.el.on("mousedown",this.onMouseDown,this);this.el.on("dblclick",this.onDblClick,this);this.el.on("click",this.onClick,this);this.el.on("contextmenu",this.onContextMenu,this);this.initDragZone();this.initDropZone();this.updatePeriod({from:this.period.from});if(this.dsLoaded){this.onLoad.apply(this)}this.rendered=true},calcDateMesh:function(){var c=[];var b=Date.parseDate(this.startDate.format("Y-m")+"-01 00:00:00",Date.patterns.ISO8601Long);while(b.getDay()!=this.startDay){b=b.add(Date.DAY,-1)}while(b.getMonth()!=this.startDate.add(Date.MONTH,1).getMonth()){for(var a=0;a<7;a++){c.push(b.add(Date.DAY,a).clone())}b=b.add(Date.DAY,7)}this.dateMesh=c},getActiveEvent:function(){return this.activeEvent},getDayCellIndex:function(a){return Math.round((a.clearTime(true).getTime()-this.dateMesh[0].getTime())/Date.msDAY)},getEventSlice:function(b,c){c=Math.abs(c);for(var a=b.childNodes.length;a<=c;a++){Ext.DomHelper.insertAfter(b.lastChild,'<div class="cal-monthview-eventslice"/>')}while(b.childNodes[c].innerHTML){c++;if(c>b.childNodes.length-1){Ext.DomHelper.insertAfter(b.lastChild,'<div class="cal-monthview-eventslice"/>')}}return b.childNodes[c]},getPeriod:function(){if(!this.dateMesh){this.calcDateMesh()}return{from:this.dateMesh[0],until:this.dateMesh[this.dateMesh.length-1].add(Date.DAY,1)}},getSelectionModel:function(){return this.calPanel.selModel},getTargetDateTime:function(d){var c=d.getTarget("td.cal-monthview-daycell",3);if(c){var b=this.dayCells.indexOf(c);var a=this.dateMesh[this.dayCells.indexOf(c)];a.add(Date.HOUR,10);return a}},getTargetEvent:function(d){var c=d.getTarget("div.cal-monthview-alldayevent",10)||d.getTarget("div.cal-monthview-event",10);if(c){var b=c.id.split(":");var a=this.ds.getById(b[1])}return a},init:function(a){this.calPanel=a;this.app=Tine.Tinebase.appMgr.get("Calendar");this.newEventSummary=this.app.i18n._hidden(this.newEventSummary);this.calWeekString=this.app.i18n._hidden(this.calWeekString);this.moreString=this.app.i18n._hidden(this.moreString);this.monthNames=Date.monthNames;this.dayNames=Date.dayNames;this.startDay=Ext.DatePicker.prototype.startDay;this.initData(a.store);this.initTemplates()},initData:function(a){if(this.ds){this.ds.un("load",this.onLoad,this);this.ds.un("add",this.onAdd,this);this.ds.un("remove",this.onRemove,this);this.ds.un("update",this.onUpdate,this)}if(a){a.on("load",this.onLoad,this);a.on("add",this.onAdd,this);a.on("remove",this.onRemove,this);a.on("update",this.onUpdate,this)}this.ds=a},initDragZone:function(){this.dragZone=new Ext.dd.DragZone(this.el,{ddGroup:"cal-event",view:this,scroll:false,getDragData:function(g){var a=g.getTarget("div.cal-monthview-alldayevent",10)||g.getTarget("div.cal-monthview-event",10);if(a){var f=a.id.split(":");var c=this.view.ds.getById(f[1]);if(this.view.denyDragOnMissingEditGrant&&!c.get("editGrant")){return false}var h=Ext.get(c.ui.domIds[0]).dom.cloneNode(true);var b=Ext.fly(a).getWidth()*c.ui.domIds.length;Ext.fly(h).removeClass(["cal-monthview-alldayevent-cropleft","cal-monthview-alldayevent-cropright"]);Ext.fly(h).setWidth(b);Ext.fly(h).setOpacity(0.5);h.id=Ext.id();return{scope:this.view,sourceEl:a,event:c,ddel:h,selections:this.view.getSelectionModel().getSelectedEvents()}}},getRepairXY:function(b,a){Ext.fly(this.dragData.sourceEl).setOpacity(1,1);return Ext.fly(this.dragData.sourceEl).getXY()}})},initDropZone:function(){this.dd=new Ext.dd.DropZone(this.el.dom,{ddGroup:"cal-event",notifyOver:function(a,f,c){var d=f.getTarget("td.cal-monthview-daycell",3);var b=c.event;if(b){c.scope.getSelectionModel().select(b)}return d&&b&&b.get("editGrant")?"cal-daysviewpanel-event-drop-ok":"cal-daysviewpanel-event-drop-nodrop"},notifyDrop:function(a,i,f){var b=f.scope;var h=i.getTarget("td.cal-monthview-daycell",3);var c=b.dateMesh[b.dayCells.indexOf(h)];if(c){var d=f.event;var g=(c.getTime()-d.get("dtstart").clearTime(true).getTime())/Date.msDAY;if(!g||!d.get("editGrant")){return false}d.beginEdit();d.set("dtstart",d.get("dtstart").add(Date.DAY,g));d.set("dtend",d.get("dtend").add(Date.DAY,g));d.endEdit();b.fireEvent("updateEvent",d)}return !!c}})},initElements:function(){var a=Ext.Element;this.focusEl=new a(this.calPanel.body.dom.firstChild);this.el=new a(this.calPanel.body.dom.lastChild);this.mainHd=new a(this.el.dom.firstChild);this.mainBody=new a(this.el.dom.lastChild);this.dayCells=Ext.DomQuery.select("td[class=cal-monthview-daycell]",this.mainBody.dom)},initTemplates:function(){var c=this.templates||{};c.allDayEvent=new Ext.XTemplate('<div id="{id}" class="cal-monthview-event cal-monthview-alldayevent {extraCls}" style="background-color: {bgColor};"><div class="cal-event-icon {iconCls} cal-monthview-event-info-{[values.showInfo ? "show" : "hide"]}"><div class="cal-monthview-alldayevent-summary" style="width: {width};">{[Ext.util.Format.htmlEncode(values.summary)]}</div></div></div>');c.event=new Ext.XTemplate('<div id="{id}" class="cal-monthview-event {extraCls}" style="color: {color};"><div class="cal-event-icon {iconCls}"><div class="cal-monthview-event-summary">{startTime} {[Ext.util.Format.htmlEncode(values.summary)]}</div></div></div>');for(var a in c){var b=c[a];if(b&&typeof b.compile=="function"&&!b.compiled){b.disableFormats=true;b.compile()}}this.templates=c},insertEvent:function(b){b.ui=new Tine.Calendar.MonthViewEventUI(b);var j=b.get("dtstart");var d=this.getDayCellIndex(j);var e=b.get("dtend");if(e.format("H:i")=="00:00"){e=e.add(Date.MINUTE,-1)}var n=this.getDayCellIndex(e);if(n<0||d>=this.dateMesh.length){return}var l=this.parallelEventsRegistry.getPosition(b);b.ui.is_all_day_event=b.get("is_all_day_event")||d!=n;b.ui.colorSet=b.colorSet=Tine.Calendar.colorMgr.getColor(b);b.ui.color=b.ui.colorSet.color;b.ui.bgColor=b.ui.colorSet.light;var f={startTime:j.format("H:i"),summary:b.get("summary"),color:b.ui.color,bgColor:b.ui.bgColor,width:"100%"};for(var g=Math.max(d,0);g<=Math.min(n,this.dayCells.length-1);g++){var c=g%7,o=Math.floor(g/7);f.id=Ext.id()+"-event:"+b.get("id");b.ui.domIds.push(f.id);var m=this.templates.event;f.extraCls=b.get("editGrant")?"cal-monthview-event-editgrant":"";if(b.ui.is_all_day_event){m=this.templates.allDayEvent;f.color="black";if(g>d){f.extraCls+=" cal-monthview-alldayevent-cropleft"}if(g<n){f.extraCls+=" cal-monthview-alldayevent-cropright"}f.showInfo=g==d||g%7==0;if(f.showInfo&&d!=n){var k=(o==Math.floor(n/7)?n%7:6)-c+1;f.width=100*k+"%"}}var h=this.getEventSlice(this.dayCells[g].lastChild,l);var a=m.overwrite(h,f,true);if(b.dirty){a.setOpacity(0.5);b.ui.onSelectedChange(true)}}},layout:function(){if(!this.mainBody){return}var h=this.calPanel;var k=h.body;var d=k.getSize(true);var l=d.width;var m=this.mainHd.getSize(true);var b=this.mainHd.dom.firstChild.childNodes;Ext.fly(b[0]).setWidth(50);for(var e=1;e<b.length;e++){Ext.get(b[e]).setWidth((l-50)/7)}var a=((d.height-m.height-2)/Math.ceil(this.dateMesh.length/7));var f=this.mainBody.dom.childNodes;for(var e=0;e<f.length;e++){Ext.get(f[e]).setHeight(a)}var j=Ext.get(this.dayCells[0].firstChild).getSize();this.dayCellsHeight=a-j.height;for(var e=0;e<this.dayCells.length;e++){Ext.get(this.dayCells[e].lastChild).setSize((l-50)/7,this.dayCellsHeight)}this.layoutDayCells()},layoutDayCells:function(){for(var a=0;a<this.dayCells.length;a++){if(this.dayCells[a].lastChild.childNodes.length>1){this.layoutDayCell(this.dayCells[a],true,true)}}},layoutDayCell:function(c,g,f){while(c.lastChild.childNodes.length>1&&c.lastChild.lastChild.innerHTML==""){Ext.fly(c.lastChild.lastChild).remove()}for(var d=0,b=0,e=0;d<c.lastChild.childNodes.length;d++){var a=Ext.get(c.lastChild.childNodes[d]);b+=a.getHeight();a[b>this.dayCellsHeight&&g?"hide":"show"]();if(b>this.dayCellsHeight&&g){e++}}if(f){c.firstChild.firstChild.innerHTML=e>0?String.format(this.moreString,e):""}return b},onAdd:function(g,a,d){for(var e=0;e<a.length;e++){var f=a[e];this.parallelEventsRegistry.register(f);var c=this.parallelEventsRegistry.getEvents(f.get("dtstart"),f.get("dtend"));for(var b=0;b<c.length;b++){this.removeEvent(c[b]);this.insertEvent(c[b])}this.setActiveEvent(f)}this.layoutDayCells()},onClick:function(g,f){var c=this.getTargetEvent(g);if(c){this.fireEvent("click",c,g);return}var b=new Date().getTime();if(b-parseInt(this.lastClickTime,10)<300){this.lastClickTime=b;return}var d=this.getTargetDateTime(g);if(Math.abs(d-b)<100){this.lastClickTime=b;return this.onClick.defer(400,this,[g,f])}this.lastClickTime=b;switch(f.className){case"cal-monthview-dayheader-date":case"cal-monthview-dayheader-more":var a=f.parentNode.firstChild.innerHTML;if(!a){return}this.zoomDayCell(f.parentNode.parentNode);break}},onContextMenu:function(a){this.fireEvent("contextmenu",a)},onDblClick:function(g,f){this.lastClickTime=new Date().getTime();g.stopEvent();var d=this.getTargetEvent(g);if(d){this.fireEvent("dblclick",d,g);return}switch(f.className){case"cal-monthview-wkcell":var h=Ext.DomQuery.select("td[class=cal-monthview-wkcell]",this.mainBody.dom).indexOf(f);var b=this.dateMesh[7*h];this.fireEvent("changeView","week",b);break;case"cal-monthview-dayheader-date":case"cal-monthview-dayheader-more":var a=this.dayCells.indexOf(f.parentNode.parentNode);var c=this.dateMesh[a];this.fireEvent("changeView","day",c);break;case"cal-monthview-daycell":var a=this.dayCells.indexOf(f);var c=this.dateMesh[a];break}},onLoad:function(){if(!this.rendered){this.dsLoaded=true;return}this.removeAllEvents();this.parallelEventsRegistry=new Tine.Calendar.ParallelEventsRegistry({dtStart:this.dateMesh[0],dtEnd:this.dateMesh[this.dateMesh.length-1].add(Date.DAY,1),granularity:60*24});this.ds.fields=Tine.Calendar.Model.Event.prototype.fields;this.ds.sortInfo={field:"dtstart",direction:"ASC"};this.ds.applySort();this.ds.each(function(a){this.parallelEventsRegistry.register(a)},this);this.ds.each(this.insertEvent,this);this.layoutDayCells()},onMouseDown:function(b,a){this.focusEl.focus();this.mainBody.focus();if(!b.getTarget("div.cal-monthview-daypreviewbox")){this.unZoom()}},onRemove:function(d,b,a,c){this.parallelEventsRegistry.unregister(b);this.removeEvent(b);this.getSelectionModel().unselect(b)},onUpdate:function(f,e){var g=e.modified.hasOwnProperty("dtstart")?e.modified.dtstart:e.get("dtstart");var d=e.modified.hasOwnProperty("dtend")?e.modified.dtend:e.get("dtend");var c=this.parallelEventsRegistry.getEvents(g,d);for(var b=0;b<c.length;b++){this.removeEvent(c[b])}this.parallelEventsRegistry.unregister(e);var c=this.parallelEventsRegistry.getEvents(g,d);for(var b=0;b<c.length;b++){this.insertEvent(c[b])}var a=this.parallelEventsRegistry.getEvents(e.get("dtstart"),e.get("dtend"));for(var b=0;b<a.length;b++){this.removeEvent(a[b])}this.parallelEventsRegistry.register(e);var a=this.parallelEventsRegistry.getEvents(e.get("dtstart"),e.get("dtend"));for(var b=0;b<a.length;b++){this.insertEvent(a[b])}e.commit(true);this.setActiveEvent(this.getActiveEvent());this.layoutDayCells()},print:function(){var a=new Tine.Calendar.Printer.MonthViewRenderer();a.print(this)},removeAllEvents:function(){var b=Ext.DomQuery.filter(Ext.DomQuery.select("div[class^=cal-monthview-event]",this.mainBody.dom),"div[class=cal-monthview-eventslice]",true);for(var a=0;a<b.length;a++){Ext.fly(b[a]).remove()}this.ds.each(function(c){if(c.ui){c.ui.domIds=[]}});this.layoutDayCells()},removeEvent:function(a){if(!a){return}if(a==this.activeEvent){this.activeEvent=null}if(a.ui){a.ui.remove()}},render:function(){var a=['<a href="#" class="cal-monthviewpanel-focus" tabIndex="-1"></a>','<table class="cal-monthview-inner" cellspacing="0"><thead><tr class="cal-monthview-inner-header" height="23px">',"<th class='cal-monthview-wkcell-header'><span >",this.calWeekString,"</span></th>"];for(var b=0;b<7;b++){var e=this.startDay+b;if(e>6){e=e-7}a.push("<th class='cal-monthview-daycell'><span>",this.dayNames[e],"</span></th>")}a[a.length]="</tr></thead><tbody><tr><td class='cal-monthview-wkcell'></td>";for(var b=0;b<42;b++){if(b%7==0&&b!=0){a[a.length]="</tr><tr><td class='cal-monthview-wkcell'></td>"}a[a.length]='<td class="cal-monthview-daycell"><div class="cal-monthview-dayheader"><div class="cal-monthview-dayheader-more"></div><div class="cal-monthview-dayheader-date"></div></div><div class="cal-monthview-daybody"><div class="cal-monthview-eventslice" /></div></td>'}a.push("</tr></tbody></table>");var c=this.calPanel.body.dom;c.className="cal-monthview";c.innerHTML=a.join("")},setActiveEvent:function(a){this.activeEvent=a||null},updatePeriod:function(d){this.toDay=new Date().clearTime();this.startDate=d.from;this.calcDateMesh();var e=this.calPanel.getTopToolbar();if(e){e.periodPicker.update(this.startDate);this.startDate=e.periodPicker.getPeriod().from}var c=Ext.DomQuery.select("div[class=cal-monthview-dayheader-date]",this.mainBody.dom);for(var a=0;a<this.dateMesh.length;a++){this.dayCells[a].style.background=this.dateMesh[a].getMonth()==this.startDate.getMonth()?"#FFFFFF":"#F9F9F9";if(this.dateMesh[a].getTime()==this.toDay.getTime()){this.dayCells[a].style.background="#EBF3FD"}c[a].innerHTML=this.dateMesh[a].format("j")}var b=Ext.DomQuery.select("td[class=cal-monthview-wkcell]",this.mainBody.dom);for(var a=0;a<b.length;a++){if(this.dateMesh.length>a*7+1){b[a].innerHTML=this.dateMesh[a*7+1].getWeekOfYear()}}this.layout();this.fireEvent("changePeriod",d)},unZoom:function(){if(this.zoomCell){this.lastClickTime=new Date().getTime();var b=Ext.get(this.zoomCell);var d=b.last();var a=b.getHeight()-b.first().getHeight();d.scrollTo("top");d.removeClass("cal-monthview-daypreviewbox");d.setStyle("background-color",b.getStyle("background-color"));d.setStyle("border-top","none");d.setHeight(a);for(var c=0;c<d.dom.childNodes.length;c++){Ext.get(d.dom.childNodes[c]).setWidth(d.getWidth());Ext.get(d.dom.childNodes[c]).setWidth(d.first().getWidth())}this.layoutDayCell(this.zoomCell,true,true);this.zoomCell=false}},zoomDayCell:function(a){this.zoomCell=a;var e=Ext.get(a.lastChild);var d=e.getBox();var f=Ext.fly(a).getStyle("background-color");f=="transparent"?"#FFFFFF":f;e.addClass("cal-monthview-daypreviewbox");e.setBox(d);e.setStyle("background-color",f);e.setStyle("border-top","1px solid "+f);var c=this.layoutDayCell(a,false,true)+10;var b=this.calPanel.el.getBottom()-d.y;e.setHeight(Math.min(c,b))}});Ext.ns("Tine.Calendar");Tine.Calendar.PagingToolbar=Ext.extend(Ext.Toolbar,{dtStart:null,view:"day",periodPicker:null,initComponent:function(){this.addEvents("change","refresh");if(!Ext.isDate(this.dtStart)){this.dtStart=new Date()}this.periodPicker=new Tine.Calendar.PagingToolbar[Ext.util.Format.capitalize(this.view)+"PeriodPicker"]({tb:this,listeners:{scope:this,change:function(b,a,c){this.dtStart=c.from.clone();this.fireEvent("change",this,a,c)}}});Tine.Calendar.PagingToolbar.superclass.initComponent.call(this);this.bind(this.store)},onRender:function(b,a){Tine.Calendar.PagingToolbar.superclass.onRender.call(this,b,a);this.prevBtn=this.addButton({tooltip:Ext.PagingToolbar.prototype.prevText,iconCls:"x-tbar-page-prev",handler:this.onClick.createDelegate(this,["prev"])});this.addSeparator();this.periodPicker.render();this.addSeparator();this.nextBtn=this.addButton({tooltip:Ext.PagingToolbar.prototype.nextText,iconCls:"x-tbar-page-next",handler:this.onClick.createDelegate(this,["next"])});this.addSeparator();this.todayBtn=this.addButton({text:Ext.DatePicker.prototype.todayText,iconCls:"cal-today-action",handler:this.onClick.createDelegate(this,["today"])});this.loading=this.addButton({tooltip:Ext.PagingToolbar.prototype.refreshText,iconCls:"x-tbar-loading",handler:this.onClick.createDelegate(this,["refresh"])});this.addFill();if(this.isLoading){this.loading.disable()}},onClick:function(a){switch(a){case"today":case"next":case"prev":this.periodPicker[a]();this.fireEvent("change",this,this.activeView,this.periodPicker.getPeriod());break;case"refresh":this.fireEvent("refresh",this,this.activeView,this.periodPicker.getPeriod());break}},getPeriod:function(){return this.periodPicker.getPeriod()},beforeLoad:function(){this.isLoading=true;if(this.rendered&&this.loading){this.loading.disable()}},onLoad:function(a,b,c){this.isLoading=false;if(this.rendered&&this.loading){this.loading.enable()}},unbind:function(a){a=Ext.StoreMgr.lookup(a);a.un("beforeload",this.beforeLoad,this);a.un("load",this.onLoad,this);this.store=undefined},bind:function(a){a=Ext.StoreMgr.lookup(a);a.on("beforeload",this.beforeLoad,this);a.on("load",this.onLoad,this);this.store=a},onDestroy:function(){if(this.store){this.unbind(this.store)}Tine.Calendar.PagingToolbar.superclass.onDestroy.call(this)}});Tine.Calendar.PagingToolbar.AbstractPeriodPicker=function(a){Ext.apply(this,a);this.addEvents("change");Tine.Calendar.PagingToolbar.AbstractPeriodPicker.superclass.constructor.call(this);this.update(this.tb.dtStart);this.init()};Ext.extend(Tine.Calendar.PagingToolbar.AbstractPeriodPicker,Ext.util.Observable,{init:function(){},hide:function(){this.button.hide()},show:function(){this.button.show()},update:function(a){},render:function(){},prev:function(){},next:function(){},today:function(){this.update(new Date().clearTime())},getPeriod:function(){}});Tine.Calendar.PagingToolbar.DayPeriodPicker=Ext.extend(Tine.Calendar.PagingToolbar.AbstractPeriodPicker,{init:function(){this.button=new Ext.Button({text:this.tb.dtStart.format(Ext.DatePicker.prototype.format),menu:new Ext.menu.DateMenu({listeners:{scope:this,select:function(a){if(typeof(a.getValue)=="function"){this.update(a.getValue());this.fireEvent("change",this,"day",this.getPeriod())}}}})})},update:function(a){this.dtStart=a.clone();if(this.button&&this.button.rendered){this.button.setText(a.format(Ext.DatePicker.prototype.format))}},render:function(){this.button=this.tb.addButton(this.button)},next:function(){this.dtStart=this.dtStart.add(Date.DAY,1);this.update(this.dtStart)},prev:function(){this.dtStart=this.dtStart.add(Date.DAY,-1);this.update(this.dtStart)},getPeriod:function(){var a=Date.parseDate(this.dtStart.format("Y-m-d")+" 00:00:00",Date.patterns.ISO8601Long);return{from:a,until:a.add(Date.DAY,1)}}});Tine.Calendar.PagingToolbar.WeekPeriodPicker=Ext.extend(Tine.Calendar.PagingToolbar.AbstractPeriodPicker,{init:function(){this.label=new Ext.form.Label({text:Tine.Tinebase.appMgr.get("Calendar").i18n._("Week"),style:"padding-right: 3px"});this.field=new Ext.form.TextField({value:this.tb.dtStart.getWeekOfYear(),width:30,cls:"x-tbar-page-number",listeners:{scope:this,specialkey:this.onSelect,blur:this.onSelect}})},onSelect:function(c,b){if(b&&b.getKey()==b.ENTER){return c.blur()}var a=c.getValue()-this.dtStart.getWeekOfYear()-parseInt(this.dtStart.getDay()<1?1:0,10);if(a!==0){this.update(this.dtStart.add(Date.DAY,a*7));this.fireEvent("change",this,"week",this.getPeriod())}},update:function(b){var c=b.add(Date.DAY,-1*b.getDay());if(Ext.DatePicker.prototype.startDay){c=c.add(Date.DAY,Ext.DatePicker.prototype.startDay-(b.getDay()==0?7:0))}this.dtStart=c;if(this.field&&this.field.rendered){var a=b.add(Date.DAY,b.getDay()<1?1:0);this.field.setValue(parseInt(a.getWeekOfYear(),10))}},render:function(){this.tb.addField(this.label);this.tb.addField(this.field)},hide:function(){this.label.hide();this.field.hide()},show:function(){this.label.show();this.field.show()},next:function(){this.dtStart=this.dtStart.add(Date.DAY,7);this.update(this.dtStart)},prev:function(){this.dtStart=this.dtStart.add(Date.DAY,-7);this.update(this.dtStart)},getPeriod:function(){return{from:this.dtStart.clone(),until:this.dtStart.add(Date.DAY,7)}}});Tine.Calendar.PagingToolbar.MonthPeriodPicker=Ext.extend(Tine.Calendar.PagingToolbar.AbstractPeriodPicker,{init:function(){this.dateMenu=new Ext.menu.DateMenu({hideMonthPicker:Ext.DatePicker.prototype.hideMonthPicker.createSequence(function(){if(this.monthPickerActive){this.monthPickerActive=false;this.value=this.activeDate;this.fireEvent("select",this,this.value)}}),listeners:{scope:this,select:function(a){if(typeof(a.getValue)=="function"){this.update(a.getValue());this.fireEvent("change",this,"month",this.getPeriod())}}}});this.button=new Ext.Button({minWidth:130,text:Ext.DatePicker.prototype.monthNames[this.tb.dtStart.getMonth()]+this.tb.dtStart.format(" Y"),menu:this.dateMenu,listeners:{scope:this,menushow:function(a,b){b.picker.showMonthPicker();b.picker.monthPickerActive=true},menuhide:function(a,b){b.picker.monthPickerActive=false}}})},update:function(b){this.dtStart=b.clone();if(this.button&&this.button.rendered){var a=Ext.DatePicker.prototype.monthNames[b.getMonth()];this.button.setText(a+b.format(" Y"));this.dateMenu.picker.setValue(b)}},render:function(){this.button=this.tb.addButton(this.button)},next:function(){this.dtStart=this.dtStart.add(Date.MONTH,1);this.update(this.dtStart)},prev:function(){this.dtStart=this.dtStart.add(Date.MONTH,-1);this.update(this.dtStart)},getPeriod:function(){var a=Date.parseDate(this.dtStart.format("Y-m")+"-01 00:00:00",Date.patterns.ISO8601Long);return{from:a,until:a.add(Date.MONTH,1)}}});Ext.ns("Tine.Calendar");Tine.Calendar.EventDetailsPanel=Ext.extend(Tine.widgets.grid.DetailsPanel,{border:false,attendeeRenderer:function(c){var d=Tine.Calendar.Model.Attender.getAttendeeStore(c);var b=[];d.each(function(f){var e=Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderName.call(Tine.Calendar.AttendeeGridPanel.prototype,f.get("user_id"),false,f);var a=Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderStatus.call(Tine.Calendar.AttendeeGridPanel.prototype,f.get("status"),{},f);b.push(e+" ("+a+")")});return b.join("\n")},containerRenderer:function(a){var b=this.record.getDisplayContainer();return this.containerTpl.apply({color:Tine.Calendar.colorMgr.getColor(b).color,name:Ext.util.Format.htmlEncode(b&&b.name?b.name:this.app.i18n._("Unknown calendar"))})},datetimeRenderer:function(a){return String.format(this.app.i18n._("{0} {1} o'clock"),Tine.Tinebase.common.dateRenderer(a),a.format("H:i"))},transpRenderer:function(a){return Tine.Tinebase.common.booleanRenderer(a=="OPAQUE")},initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.containerTpl=new Ext.XTemplate('<div class="x-tree-node-leaf x-unselectable file">','<img class="x-tree-node-icon" unselectable="on" src="',Ext.BLANK_IMAGE_URL,'">','<span style="color: {color};">&nbsp;&#9673;&nbsp</span>',"<span>{name}</span>","</div>").compile();this.supr().initComponent.call(this)},getDefaultInfosPanel:function(){if(!this.defaultInfosPanel){this.defaultInfosPanel=new Ext.ux.display.DisplayPanel({layout:"fit",border:false,items:[{layout:"hbox",border:false,defaults:{margins:"0 5 0 0"},layoutConfig:{padding:"5",align:"stretch"},items:[{flex:1,border:false,layout:"ux.display",layoutConfig:{background:"solid",declaration:this.app.i18n.n_("Event","Events",50)}},{flex:1,border:false,layout:"ux.display",layoutConfig:{background:"border"}}]}]})}return this.defaultInfosPanel},getSingleRecordPanel:function(){if(!this.singleRecordPanel){this.singleRecordPanel=new Ext.ux.display.DisplayPanel({layout:"fit",border:false,items:[{layout:"vbox",border:false,layoutConfig:{align:"stretch"},items:[{layout:"hbox",flex:0,height:16,border:false,style:"padding-left: 5px; padding-right: 5px",layoutConfig:{align:"stretch"},items:[{flex:1,xtype:"ux.displayfield",name:"summary",style:"padding-top: 2px",cls:"x-ux-display-header"},{flex:1,xtype:"ux.displayfield",style:"text-align: right;",cls:"x-ux-display-header",name:"container_id",htmlEncode:false,renderer:this.containerRenderer.createDelegate(this)}]},{layout:"hbox",flex:1,border:false,layoutConfig:{padding:"5",align:"stretch"},defaults:{margins:"0 5 0 0"},items:[{flex:2,layout:"ux.display",labelWidth:60,layoutConfig:{background:"solid"},items:[{xtype:"ux.displayfield",name:"dtstart",fieldLabel:this.app.i18n._("Start Time"),renderer:this.datetimeRenderer.createDelegate(this)},{xtype:"ux.displayfield",name:"dtend",fieldLabel:this.app.i18n._("End Time"),renderer:this.datetimeRenderer.createDelegate(this)},{xtype:"ux.displayfield",name:"transp",fieldLabel:this.app.i18n._("Blocking"),renderer:this.transpRenderer.createDelegate(this)},{xtype:"ux.displayfield",name:"location",fieldLabel:this.app.i18n._("Location")},{xtype:"ux.displayfield",name:"organizer",fieldLabel:this.app.i18n._("Organizer"),renderer:function(a){return a&&a.n_fileas?a.n_fileas:""}}]},{flex:2,layout:"ux.display",labelAlign:"top",autoScroll:true,layoutConfig:{background:"solid"},items:[{xtype:"ux.displayfield",name:"attendee",nl2br:true,fieldLabel:this.app.i18n._("Attendee"),renderer:this.attendeeRenderer}]},{flex:3,layout:"fit",border:false,items:[{cls:"x-ux-display-background-border",xtype:"ux.displaytextarea",name:"description"}]}]}]}]})}return this.singleRecordPanel},updateDetails:function(b,a){this.getSingleRecordPanel().loadRecord.defer(100,this.getSingleRecordPanel(),[b])}});Ext.ns("Tine.Calendar");Tine.Calendar.MainScreenCenterPanel=Ext.extend(Ext.Panel,{activeView:"week",startDate:new Date().clearTime(),startDates:null,calendarPanels:{},border:false,layout:"border",stateful:true,stateId:"cal-mainscreen",stateEvents:["changeview"],getState:function(){return Ext.copyTo({},this,"activeView")},applyState:Ext.emptyFn,initComponent:function(){this.addEvents("changeview");this.recordClass=Tine.Calendar.Model.Event;this.app=Tine.Tinebase.appMgr.get("Calendar");this.i18nRecordName=this.app.i18n.n_hidden(this.recordClass.getMeta("recordName"),this.recordClass.getMeta("recordsName"),1);this.i18nRecordsName=this.app.i18n._hidden(this.recordClass.getMeta("recordsName"));this.i18nContainerName=this.app.i18n.n_hidden(this.recordClass.getMeta("containerName"),this.recordClass.getMeta("containersName"),1);this.i18nContainersName=this.app.i18n._hidden(this.recordClass.getMeta("containersName"));var a=Ext.state.Manager.get(this.stateId,{});Ext.apply(this,a);this.defaultFilters=[{field:"attender",operator:"in",value:[Ext.apply(Tine.Calendar.Model.Attender.getDefaultData(),{user_id:Tine.Tinebase.registry.get("currentAccount")})]},{field:"attender_status",operator:"notin",value:["DECLINED"]}];this.filterToolbar=this.getFilterToolbar();this.filterToolbar.onFilterChange=this.refresh.createDelegate(this,[false]);this.filterToolbar.getAllFilterData=this.getAllFilterData.createDelegate(this);this.filterToolbar.getQuickFilterPlugin().criteriaIgnores.push({field:"period"},{field:"grants"});this.startDates=[];this.initActions();this.initLayout();Tine.Calendar.MainScreenCenterPanel.superclass.initComponent.call(this)},initActions:function(){this.action_editInNewWindow=new Ext.Action({requiredGrant:"readGrant",text:this.i18nEditActionText?this.app.i18n._hidden(this.i18nEditActionText):String.format(Tine.Tinebase.translation._hidden("Edit {0}"),this.i18nRecordName),disabled:true,handler:this.onEditInNewWindow.createDelegate(this,["edit"]),iconCls:"action_edit"});this.action_addInNewWindow=new Ext.Action({requiredGrant:"addGrant",text:this.i18nAddActionText?this.app.i18n._hidden(this.i18nAddActionText):String.format(Tine.Tinebase.translation._hidden("Add {0}"),this.i18nRecordName),handler:this.onEditInNewWindow.createDelegate(this,["add"]),iconCls:"action_add"});this.action_deleteRecord=new Ext.Action({requiredGrant:"deleteGrant",allowMultiple:true,singularText:this.i18nDeleteActionText?i18nDeleteActionText[0]:String.format(Tine.Tinebase.translation.n_hidden("Delete {0}","Delete {0}",1),this.i18nRecordName),pluralText:this.i18nDeleteActionText?i18nDeleteActionText[1]:String.format(Tine.Tinebase.translation.n_hidden("Delete {0}","Delete {0}",1),this.i18nRecordsName),translationObject:this.i18nDeleteActionText?this.app.i18n:Tine.Tinebase.translation,text:this.i18nDeleteActionText?this.i18nDeleteActionText[0]:String.format(Tine.Tinebase.translation.n_hidden("Delete {0}","Delete {0}",1),this.i18nRecordName),handler:this.onDeleteRecords,disabled:true,iconCls:"action_delete",scope:this});this.actions_print=new Ext.Action({requiredGrant:"readGrant",text:this.app.i18n._("Print Page"),handler:this.onPrint,iconCls:"action_print",scope:this});this.showDayView=new Ext.Toolbar.Button({pressed:this.activeView==="day",text:this.app.i18n._("Day"),iconCls:"cal-day-view",xtype:"tbbtnlockedtoggle",handler:this.changeView.createDelegate(this,["day"]),enableToggle:true,toggleGroup:"Calendar_Toolbar_tgViews"});this.showWeekView=new Ext.Toolbar.Button({pressed:this.activeView==="week",text:this.app.i18n._("Week"),iconCls:"cal-week-view",xtype:"tbbtnlockedtoggle",handler:this.changeView.createDelegate(this,["week"]),enableToggle:true,toggleGroup:"Calendar_Toolbar_tgViews"});this.showMonthView=new Ext.Toolbar.Button({pressed:this.activeView==="month",text:this.app.i18n._("Month"),iconCls:"cal-month-view",xtype:"tbbtnlockedtoggle",handler:this.changeView.createDelegate(this,["month"]),enableToggle:true,toggleGroup:"Calendar_Toolbar_tgViews"});this.changeViewActions=[this.showDayView,this.showWeekView,this.showMonthView];this.recordActions=[this.action_editInNewWindow,this.action_deleteRecord];this.actionUpdater=new Tine.widgets.ActionUpdater({actions:this.recordActions,grantsProperty:false,containerProperty:false})},initLayout:function(){this.items=[{region:"center",layout:"card",activeItem:0,border:false,items:[this.getCalendarPanel(this.activeView)]}];if(this.detailsPanel){this.items.push({region:"south",border:false,collapsible:true,collapseMode:"mini",header:false,split:true,layout:"fit",height:this.detailsPanel.defaultHeight?this.detailsPanel.defaultHeight:125,items:this.detailsPanel})}if(this.filterToolbar){this.items.push({region:"north",border:false,items:this.filterToolbar,listeners:{scope:this,afterlayout:function(a){a.suspendEvents();a.setHeight(this.filterToolbar.getHeight());a.ownerCt.layout.layout();a.resumeEvents()}}})}},changeView:function(c,a){Tine.log.debug("Tine.Calendar.MainScreenCenterPanel::changeView("+c+","+a+")");this.startDates[this.activeView]=this.startDate.clone();if(a&&Ext.isDate(a)){this.startDate=a.clone()}else{var h=this.startDates[c],g=this.getCalendarPanel(this.activeView).getView().getPeriod();if(Ext.isDate(h)&&h.between(g.from,g.until)){this.startDate=this.startDates[c].clone()}}var b=this.getCalendarPanel(c);var f=this.items.first();if(b.rendered){f.layout.setActiveItem(b.id)}else{f.add(b);f.layout.setActiveItem(b.id);f.doLayout()}this.activeView=c;var e=Ext.get(Ext.DomQuery.selectNode("tr[class=x-toolbar-right-row]",b.tbar.dom));for(var d=this.changeViewActions.length-1;d>=0;d--){e.insertFirst(this.changeViewActions[d].getEl().parent().dom)}this["show"+Ext.util.Format.capitalize(c)+"View"].toggle(true);this.updateEventActions();b.getView().updatePeriod({from:this.startDate});b.getStore().load({});this.fireEvent("changeview",this,c)},getActionToolbar:Tine.widgets.grid.GridPanel.prototype.getActionToolbar,getActionToolbarItems:Tine.widgets.grid.GridPanel.prototype.getActionToolbarItems,getAllFilterData:function(){var a=this.getCalendarPanel(this.activeView).getStore();var b={};this.onStoreBeforeload(a,b);return b.params.filter},getCustomfieldFilters:Tine.widgets.grid.GridPanel.prototype.getCustomfieldFilters,getFilterToolbar:Tine.widgets.grid.GridPanel.prototype.getFilterToolbar,getStore:function(){return this.getCalendarPanel(this.activeView).getStore()},onContextMenu:function(d){d.stopEvent();var i=this.getCalendarPanel(this.activeView).getView();var a=i.getTargetEvent(d);var f=i.getTargetDateTime(d);var h,b;if(f||a){var g=f||a.get("dtstart").clone();if(g.format("H:i")==="00:00"){g=g.add(Date.HOUR,9)}h={text:this.i18nAddActionText?this.app.i18n._hidden(this.i18nAddActionText):String.format(Tine.Tinebase.translation._hidden("Add {0}"),this.i18nRecordName),handler:this.onEditInNewWindow.createDelegate(this,["add",{dtStart:g}]),iconCls:"action_add"};if(a){var j=a.getMyAttenderRecord();if(j){b={text:this.app.i18n._("Set my response"),iconCls:"cal-response-action-"+j.get("status"),menu:[]};Tine.Calendar.Model.Attender.getAttendeeStatusStore().each(function(e){b.menu.push({text:e.get("status_name"),handler:this.setResponseStatus.createDelegate(this,[a,e.id]),iconCls:"cal-response-action-"+e.id,disabled:j.get("status")===e.id})},this)}}}else{h=this.action_addInNewWindow}if(a){i.getSelectionModel().select(a,d,d.ctrlKey)}else{i.getSelectionModel().clearSelections()}var c=new Ext.menu.Menu({items:this.recordActions.concat(h,b||[])});c.showAt(d.getXY())},onDeleteRecords:function(){var a=this.getCalendarPanel(this.activeView);var c=a.getSelectionModel().getSelectedEvents();var e=false;var b=false;Ext.each(c,function(f){f.ui.markDirty();if(f.isRecurInstance()){b=true}if(f.isRecurBase()){e=true}});if(c.length>1&&(e||b)){Ext.Msg.show({title:this.app.i18n._("Please Change Selection"),msg:this.app.i18n._("Your selection contains recurring events. Recuring events must be deleted seperatly!"),icon:Ext.MessageBox.INFO,buttons:Ext.Msg.OK,scope:this,fn:function(){this.onDeleteRecordsConfirmFail(a,c)}});return}if(c.length===1&&(e||b)){this.deleteMethodWin=Tine.widgets.dialog.MultiOptionsDialog.openWindow({title:this.app.i18n._("Delete Event"),scope:this,height:170,options:[{text:this.app.i18n._("Delete this event only"),name:"this"},{text:this.app.i18n._("Delete this and all future events"),name:e?"all":"future"},{text:this.app.i18n._("Delete whole series"),name:"all"},{text:this.app.i18n._("Delete nothing"),name:"nothing"}],handler:function(g){switch(g){case"all":case"this":case"future":a.getTopToolbar().beforeLoad();if(g!=="this"){a.loadMask.show()}var f={scope:this,success:function(){if(g==="this"){Ext.each(c,function(h){a.getStore().remove(h)});a.getTopToolbar().onLoad()}else{this.refresh(true)}}};if(g==="all"){Tine.Calendar.backend.deleteRecurSeries(c[0],f)}else{Tine.Calendar.backend.createRecurException(c[0],true,g==="future",f)}break;default:this.onDeleteRecordsConfirmFail(a,c);break}}});return}var d=String.format(this.app.i18n.ngettext("Do you really want to delete this event?","Do you really want to delete the {0} selected events?",c.length),c.length);Ext.MessageBox.confirm(Tine.Tinebase.translation._hidden("Confirm"),d,function(f){if(f==="yes"){this.onDeleteRecordsConfirmNonRecur(a,c)}else{this.onDeleteRecordsConfirmFail(a,c)}},this)},onDeleteRecordsConfirmNonRecur:function(a,c){a.getTopToolbar().beforeLoad();var d=Ext.unique(c);var b={scope:this,success:function(){a.getTopToolbar().onLoad();Ext.each(d,function(e){a.getStore().remove(e)})},failure:function(){a.getTopToolbar().onLoad();Ext.MessageBox.alert(Tine.Tinebase.translation._hidden("Failed"),String.format(this.app.i18n.n_("Failed not delete event","Failed to delete the {0} events",c.length),c.length))}};Tine.Calendar.backend.deleteRecords(c,b)},onDeleteRecordsConfirmFail:function(a,b){Ext.each(b,function(c){c.ui.clearDirty()})},onEditInNewWindow:function(e,f){var d=null;if(e==="edit"){var b=this.getCalendarPanel(this.activeView);var c=b.getSelectionModel().getSelectedEvents();if(Ext.isArray(c)&&c.length===1){d=c[0];if(!d||d.dirty){return}}}if(!d){d=new Tine.Calendar.Model.Event(Tine.Calendar.Model.Event.getDefaultData(),0);if(f&&Ext.isDate(f.dtStart)){d.set("dtstart",f.dtStart);d.set("dtend",f.dtStart.add(Date.HOUR,1))}if(f&&Ext.isArray(f.attendee)){var a=d.get("attendee")||[];Ext.each(f.attendee,function(g){a.push(Ext.apply(Tine.Calendar.Model.Attender.getDefaultData(),{user_id:Ext.isFunction(g.beginEdit)?g.data:g}))},this);d.set("attendee",a)}}Tine.Calendar.EventEditDialog.openWindow({record:Ext.util.JSON.encode(d.data),recordId:d.data.id,listeners:{scope:this,update:function(j){var i=Tine.Calendar.backend.recordReader({responseText:j});i.dirty=true;d.phantom=(e==="edit");var g=this.getCalendarPanel(this.activeView);var h=g.getStore();d=h.getById(d.id);h.remove(d);h.add(i);g.onUpdateEvent(i)}}})},onKeyDown:function(a){if(a.ctrlKey){switch(a.getKey()){case a.A:a.preventDefault();break;case a.E:if(!this.action_editInNewWindow.isDisabled()){this.onEditInNewWindow("edit")}a.preventDefault();break;case a.N:if(!this.action_addInNewWindow.isDisabled()){this.onEditInNewWindow("add")}a.preventDefault();break}}else{if(a.getKey()===a.DELETE){if(!this.action_deleteRecord.isDisabled()){this.onDeleteRecords.call(this)}}}},onPrint:function(){var b=this.getCalendarPanel(this.activeView),a=b?b.getView():null;if(a&&Ext.isFunction(a.print)){a.print()}else{Ext.Msg.alert(this.app.i18n._("Could not Print"),this.app.i18n._("Sorry, your current view does not support printing."))}},onStoreBeforeload:function(a,b){b.params=b.params||{};this.lastStoreTransactionId=b.transactionId=Ext.id();b.params.filter=[];this.filterToolbar.onBeforeLoad.call(this.filterToolbar,a,b)},onStoreBeforeLoadRecords:function(c,a,b){return this.lastStoreTransactionId===a.transactionId},onStoreLoad:function(a,b){if(a!==this.getCalendarPanel(this.activeView).getStore()){console.log("not active anymore");return}this.filterToolbar.setValue(a.proxy.jsonReader.jsonData.filter);Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getWestPanel().getContainerTreePanel().getFilterPlugin().setValue(a.proxy.jsonReader.jsonData.filter)},refresh:function(b){Tine.log.debug("Tine.Calendar.MainScreenCenterPanel::refresh("+b+")");var a=this.getCalendarPanel(this.activeView);a.getStore().load({refresh:b});Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getWestPanel().getFavoritesPanel().getSelectionModel().clearSelections()},setResponseStatus:function(d,b){var e=d.getMyAttenderRecord();if(e){e.set("status",b);d.dirty=true;var a=this.getCalendarPanel(this.activeView);var c=a.getStore();c.remove(d);c.add(d);a.onUpdateEvent(d)}},updateEventActions:function(){var a=this.getCalendarPanel(this.activeView);var b=a.getSelectionModel().getSelectedEvents();this.actionUpdater.updateActions(b);if(this.detailsPanel){this.detailsPanel.onDetailsUpdate(a.getSelectionModel())}},updateView:function(c){Tine.log.debug("Tine.Calendar.MainScreenCenterPanel::updateView("+c+")");var a=this.getCalendarPanel(c);var b=a.getTopToolbar().getPeriod();a.getView().updatePeriod(b);a.getStore().load({})},getCalendarPanel:function(c){if(!this.calendarPanels[c]){var b=new Ext.data.Store({id:"id",fields:Tine.Calendar.Model.Event,proxy:Tine.Calendar.backend,reader:new Ext.data.JsonReader({}),listeners:{scope:this,beforeload:this.onStoreBeforeload,beforeloadrecords:this.onStoreBeforeLoadRecords,load:this.onStoreLoad}});var d=new Tine.Calendar.PagingToolbar({view:c,store:b,dtStart:this.startDate,listeners:{scope:this,render:function(f){for(var e=0;e<this.changeViewActions.length;e+=1){if(!this.changeViewActions[e].rendered){f.addButton(this.changeViewActions[e])}}}}});d.on("change",this.updateView.createDelegate(this,[c]),this,{buffer:200});d.on("refresh",this.refresh.createDelegate(this,[true]),this,{buffer:200});var a;switch(c){case"day":a=new Tine.Calendar.DaysView({startDate:d.getPeriod().from,numOfDays:1});break;case"week":a=new Tine.Calendar.DaysView({startDate:d.getPeriod().from,numOfDays:7});break;case"month":a=new Tine.Calendar.MonthView({period:d.getPeriod()});break}a.on("changeView",this.changeView,this);a.on("changePeriod",function(e){this.startDate=e.from;this.startDates[c]=this.startDate.clone();this.updateMiniCal()},this);a.on("dblclick",this.onEditInNewWindow.createDelegate(this,["edit"]));a.on("contextmenu",this.onContextMenu,this);this.calendarPanels[c]=new Tine.Calendar.CalendarPanel({tbar:d,store:b,view:a});this.calendarPanels[c].getSelectionModel().on("selectionchange",this.updateEventActions,this);this.calendarPanels[c].on("keydown",this.onKeyDown,this);this.calendarPanels[c].on("render",function(){var f=Tine.widgets.persistentfilter.model.PersistentFilter.getDefaultFavorite(this.app.appName);var e=this.app.getMainScreen().getWestPanel().getFavoritesPanel();e.selectFilter(f)},this);this.calendarPanels[c].relayEvents(this,["show","beforehide"])}return this.calendarPanels[c]},updateMiniCal:function(){var d=Ext.getCmp("cal-mainscreen-minical");var b=null;var f=this.getCalendarPanel(this.activeView).getView().getPeriod();switch(this.activeView){case"week":b=[f.from.add(Date.DAY,1).getWeekOfYear()];break;case"month":b=[];var a=f.from.add(Date.DAY,1).getWeekOfYear();var e=Math.round((f.until.getTime()-f.from.getTime())/Date.msWEEK);for(var c=0;c<e;c+=1){b.push(a+c)}break}d.update(this.startDate,true,b)}});Ext.ns("Tine.Calendar");Tine.Calendar.MainScreenWestPanel=Ext.extend(Tine.widgets.mainscreen.WestPanel,{containerTreePanelClassName:"CalendarSelectTreePanel",cls:"cal-tree",getAdditionalItems:function(){return[Ext.apply({title:this.app.i18n._("Mini Calendar"),forceLayout:true,border:false,layout:"hbox",layoutConfig:{align:"middle"},defaults:{border:false},items:[{flex:1},this.getDatePicker(),{flex:1}]},this.defaults)]},getDatePicker:function(){if(!this.datePicker){this.datePicker=new Ext.DatePicker({width:200,id:"cal-mainscreen-minical",plugins:[new Ext.ux.DatePickerWeekPlugin({weekHeaderString:Tine.Tinebase.appMgr.get("Calendar").i18n._("WK"),inspectMonthPickerClick:function(a,c){if(c.getTarget("button")){var b=Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getCenterPanel();b.changeView("month",this.activeDate);return false}}})],listeners:{scope:this,select:function(b,c,a){var d=Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getCenterPanel();d.changeView(a?"week":"day",c)}}})}return this.datePicker}});Ext.reg("tine.calendar.mainscreenwestpanel",Tine.Calendar.MainScreenWestPanel);Ext.namespace("Tine.Calendar");Ext.onReady(function(){Ext.util.CSS.updateRule(".CalendarIconCls","background-image","url(../../images/view-calendar-day-"+new Date().getDate()+".png)")});Tine.Calendar.Application=Ext.extend(Tine.Tinebase.Application,{addButtonText:"New Event",getTitle:function(){return this.i18n.ngettext("Calendar","Calendars",1)},getIconCls:function(a){switch(a){case"PreferencesTreePanel":return"PreferencesTreePanel-CalendarIconCls";break;default:return"CalendarIconCls";break}},init:function(){Tine.Calendar.Application.superclass.init.apply(this.arguments);new Tine.Calendar.AddressbookGridPanelHook({app:this})}});Tine.Calendar.MainScreen=function(a){Ext.apply(this,a);Tine.Calendar.colorMgr=new Tine.Calendar.ColorManager({});Tine.Calendar.MainScreen.superclass.constructor.apply(this,arguments)};Ext.extend(Tine.Calendar.MainScreen,Tine.widgets.MainScreen,{westPanelXType:"tine.calendar.mainscreenwestpanel",getCenterPanel:function(){if(!this.contentPanel){this.contentPanel=new Tine.Calendar.MainScreenCenterPanel({detailsPanel:new Tine.Calendar.EventDetailsPanel()})}return this.contentPanel},showNorthPanel:function(){if(!this.actionToolbar){this.actionToolbar=this.contentPanel.getActionToolbar()}Tine.Tinebase.MainScreen.setActiveToolbar(this.actionToolbar,true)}});Ext.ns("Tine.Calendar");Tine.Calendar.EventEditDialog=Ext.extend(Tine.widgets.dialog.EditDialog,{containerId:-1,labelAlign:"side",windowNamePrefix:"EventEditWindow_",appName:"Calendar",recordClass:Tine.Calendar.Model.Event,recordProxy:Tine.Calendar.backend,showContainerSelector:false,tbarItems:[{xtype:"widget-activitiesaddbutton"}],mode:"local",evalGrants:false,onResize:function(){Tine.Calendar.EventEditDialog.superclass.onResize.apply(this,arguments);this.setTabHeight.defer(100,this)},getFormItems:function(){return{xtype:"tabpanel",border:false,plain:true,activeTab:0,border:false,items:[{title:this.app.i18n.n_("Event","Events",1),border:false,frame:true,layout:"border",items:[{region:"center",layout:"hfit",border:false,items:[{xtype:"fieldset",layout:"hfit",autoHeight:true,title:this.app.i18n.n_("Event","Events",1),items:[{xtype:"columnform",labelAlign:"side",labelWidth:100,formDefaults:{xtype:"textfield",anchor:"100%",labelSeparator:"",columnWidth:0.6},items:[[{columnWidth:1,fieldLabel:this.app.i18n._("Summary"),name:"summary",listeners:{render:function(a){a.focus(false,250)}},allowBlank:false,requiredGrant:"editGrant"}],[{columnWidth:1,fieldLabel:this.app.i18n._("Location"),name:"location",requiredGrant:"editGrant"}],[{xtype:"datetimefield",fieldLabel:this.app.i18n._("Start Time"),listeners:{scope:this,change:this.onDtStartChange},name:"dtstart",requiredGrant:"editGrant"},{columnWidth:0.4,xtype:"combo",hideLabel:true,readOnly:true,hideTrigger:true,disabled:true,name:"originator_tz",requiredGrant:"editGrant"}],[{xtype:"datetimefield",fieldLabel:this.app.i18n._("End Time"),listeners:{scope:this,change:this.onDtEndChange},name:"dtend",requiredGrant:"editGrant"},{columnWidth:0.17,xtype:"checkbox",hideLabel:true,boxLabel:this.app.i18n._("whole day"),listeners:{scope:this,check:this.onAllDayChange},name:"is_all_day_event",requiredGrant:"editGrant"},{columnWidth:0.23,xtype:"checkbox",hideLabel:true,boxLabel:this.app.i18n._("non-blocking"),name:"transp",requiredGrant:"editGrant",getValue:function(){var a=Ext.form.Checkbox.prototype.getValue.call(this);return a?"TRANSPARENT":"OPAQUE"},setValue:function(b){var a=(b=="TRANSPARENT"||b===true);return Ext.form.Checkbox.prototype.setValue.call(this,a)}}]]}]},{xtype:"fieldset",layout:"hfit",autoHeight:true,title:Tine.Tinebase.translation._hidden("Saved in"),items:[{layout:"column",items:[Ext.apply(this.CalendarSelectWidget,{columnWidth:0.77}),{columnWidth:0.23,xtype:"checkbox",hideLabel:true,boxLabel:this.app.i18n._("Private"),name:"class",requiredGrant:"editGrant",getValue:function(){var a=Ext.form.Checkbox.prototype.getValue.call(this);return a?"PRIVATE":"PUBLIC"},setValue:function(b){var a=(b=="PRIVATE"||b===true);return Ext.form.Checkbox.prototype.setValue.call(this,a)}}]}]},{xtype:"tabpanel",deferredRender:false,activeTab:0,border:false,height:235,form:true,items:[this.attendeeGridPanel,this.rrulePanel,this.alarmPanel]}]},{region:"east",layout:"accordion",animate:true,width:200,split:true,collapsible:true,collapseMode:"mini",header:false,margins:"0 5 0 5",border:true,items:[new Ext.Panel({title:this.app.i18n._("Description"),iconCls:"descriptionIcon",layout:"form",labelAlign:"top",border:false,items:[{style:"margin-top: -4px; border 0px;",labelSeparator:"",xtype:"textarea",name:"description",hideLabel:true,grow:false,preventScrollbars:false,anchor:"100% 100%",emptyText:this.app.i18n._("Enter description"),requiredGrant:"editGrant"}]}),new Tine.widgets.activities.ActivitiesPanel({app:"Calendar",showAddNoteForm:false,border:false,bodyStyle:"border:1px solid #B5B8C8;"}),new Tine.widgets.tags.TagPanel({app:"Calendar",border:false,bodyStyle:"border:1px solid #B5B8C8;"})]}]},new Tine.widgets.activities.ActivitiesTabPanel({app:this.appName,record_id:(this.record)?this.record.id:"",record_model:this.appName+"_Model_"+this.recordClass.getMeta("modelName")})]}},initComponent:function(){this.attendeeGridPanel=new Tine.Calendar.AttendeeGridPanel({});this.rrulePanel=new Tine.Calendar.RrulePanel({});this.alarmPanel=new Tine.widgets.dialog.AlarmPanel({});this.attendeeStore=this.attendeeGridPanel.getStore();this.CalendarSelectWidget=new Tine.Calendar.CalendarSelectWidget(this);Tine.Calendar.EventEditDialog.superclass.initComponent.call(this)},isValid:function(){var a=this.validateDtStart()&&this.validateDtEnd();if(!this.rrulePanel.isValid()){a=false;this.rrulePanel.ownerCt.setActiveTab(this.rrulePanel)}return a&&Tine.Calendar.EventEditDialog.superclass.isValid.apply(this,arguments)},onAllDayChange:function(d,e){var b=this.getForm().findField("dtstart");var c=this.getForm().findField("dtend");b.setDisabled(e,"time");c.setDisabled(e,"time");if(e){b.clearTime();var a=c.getValue();if(Ext.isDate(a)&&a.format("H:i:s")!="23:59:59"){c.setValue(a.clearTime(true).add(Date.HOUR,24).add(Date.SECOND,-1))}}else{b.undo();c.undo()}},onDtEndChange:function(b,c,a){this.validateDtEnd()},onDtStartChange:function(b,f,a){if(Ext.isDate(f)&&Ext.isDate(a)){var e=f.getTime()-a.getTime();var c=this.getForm().findField("dtend");var d=c.getValue();if(Ext.isDate(d)){c.setValue(d.add(Date.MILLI,e))}}},onRecordLoad:function(){if(this.rendered){this.attendeeGridPanel.onRecordLoad(this.record);this.rrulePanel.onRecordLoad(this.record);this.alarmPanel.onRecordLoad(this.record);this.CalendarSelectWidget.onRecordLoad(this.record);if(!this.record.get("editGrant")){this.getForm().items.each(function(a){if(a.isFormField&&a.requiredGrant!==undefined){a.setDisabled(!this.record.get(a.requiredGrant))}},this)}}Tine.Calendar.EventEditDialog.superclass.onRecordLoad.apply(this,arguments)},onRecordUpdate:function(){Tine.Calendar.EventEditDialog.superclass.onRecordUpdate.apply(this,arguments);this.attendeeGridPanel.onRecordUpdate(this.record);this.rrulePanel.onRecordUpdate(this.record);this.alarmPanel.onRecordUpdate(this.record);this.CalendarSelectWidget.onRecordUpdate(this.record)},setTabHeight:function(){var b=this.items.first().items.first();var a=b.items.first();var c=a.items.last();c.setHeight(a.getEl().getBottom()-c.getEl().getTop())},validateDtEnd:function(){var c=this.getForm().findField("dtstart").getValue();var a=this.getForm().findField("dtend");var b=a.getValue();if(!Ext.isDate(b)){a.markInvalid(this.app.i18n._("End date is not valid"));return false}else{if(Ext.isDate(c)&&b.getTime()-c.getTime()<=0){a.markInvalid(this.app.i18n._("End date must be after start date"));return false}else{a.clearInvalid();return true}}},validateDtStart:function(){var a=this.getForm().findField("dtstart");var b=a.getValue();if(!Ext.isDate(b)){a.markInvalid(this.app.i18n._("Start date is not valid"));return false}else{a.clearInvalid();return true}}});Tine.Calendar.EventEditDialog.openWindow=function(a){var c=a.recordId?a.recordId:0;var b=Tine.WindowFactory.getWindow({width:800,height:470,name:Tine.Calendar.EventEditDialog.prototype.windowNamePrefix+c,contentPanelConstructor:"Tine.Calendar.EventEditDialog",contentPanelConstructorConfig:a});return b};Ext.ns("Tine.Calendar");Tine.Calendar.AttendeeGridPanel=Ext.extend(Ext.grid.EditorGridPanel,{autoExpandColumn:"user_id",clicksToEdit:1,enableHdMenu:false,showMemberOfType:false,showNamesOnly:false,record:null,currentAccountId:null,ctxMenu:null,attendeeStore:null,stateful:true,stateId:"cal-attendeegridpanel",applyState:Ext.emptyFn,initComponent:function(){this.app=this.app?this.app:Tine.Tinebase.appMgr.get("Calendar");this.currentAccountId=Tine.Tinebase.registry.get("currentAccount").accountId;this.title=this.hasOwnProperty("title")?this.title:this.app.i18n._("Attendee");this.plugins=this.plugins||[];if(!this.showNamesOnly){this.plugins.push(new Ext.ux.grid.GridViewMenuPlugin({}))}this.store=new Ext.data.SimpleStore({fields:Tine.Calendar.Model.Attender.getFieldDefinitions(),sortInfo:{field:"user_id",direction:"ASC"}});this.on("beforeedit",this.onBeforeAttenderEdit,this);this.on("afteredit",this.onAfterAttenderEdit,this);this.initColumns();Tine.Calendar.AttendeeGridPanel.superclass.initComponent.call(this)},initColumns:function(){this.columns=[{id:"role",dataIndex:"role",width:70,sortable:true,hidden:this.showNamesOnly||true,header:this.app.i18n._("Role"),renderer:this.renderAttenderRole.createDelegate(this)},{id:"displaycontainer_id",dataIndex:"displaycontainer_id",width:200,sortable:false,hidden:this.showNamesOnly||true,header:Tine.Tinebase.translation._hidden("Saved in"),tooltip:this.app.i18n._("This is the calendar where the attender has saved this event in"),renderer:this.renderAttenderDispContainer.createDelegate(this),editor2:new Tine.widgets.container.selectionComboBox({blurOnSelect:true,selectOnFocus:true,appName:"Calendar",getValue:function(){if(this.selectedContainer){var a=this.selectedContainer.id;this.selectedContainer.toString=function(){return a}}return this.selectedContainer},listeners:{scope:this,select:function(c,b){var a=this.getSelectionModel().getSelectedCell();if(a){var d=a[0];this.store.getAt(d).set("displaycontainer_id",b)}}}})},{id:"user_type",dataIndex:"user_type",width:40,sortable:true,resizable:false,header:"&#160;",tooltip:this.app.i18n._("Type"),renderer:this.renderAttenderType.createDelegate(this),editor:new Ext.form.ComboBox({blurOnSelect:true,expandOnFocus:true,mode:"local",store:[["user",this.app.i18n._("User")],["group",this.app.i18n._("Group")],["resource",this.app.i18n._("Resource")]].concat(this.showMemberOfType?[["memberOf",this.app.i18n._("Member of group")]]:[])})},{id:"user_id",dataIndex:"user_id",width:300,sortable:true,header:this.app.i18n._("Name"),renderer:this.renderAttenderName.createDelegate(this),editor:true},{id:"status",dataIndex:"status",width:100,sortable:true,header:this.app.i18n._("Status"),hidden:this.showNamesOnly,renderer:this.renderAttenderStatus.createDelegate(this),editor:new Ext.form.ComboBox({blurOnSelect:true,expandOnFocus:true,mode:"local",displayField:"status_name",valueField:"id",store:Tine.Calendar.Model.Attender.getAttendeeStatusStore()})}]},onAfterAttenderEdit:function(c){switch(c.field){case"user_id":var a=false;this.store.each(function(e){if(c.record.getUserId()==e.getUserId()&&c.record.get("user_type")==e.get("user_type")&&c.record!=e){var d=this.getView().getRow(this.store.indexOf(e));Ext.fly(d).highlight();a=true;return false}},this);if(a){c.record.reject();this.startEditing(c.row,c.column)}else{if(c.value){var b=new Tine.Calendar.Model.Attender(Tine.Calendar.Model.Attender.getDefaultData(),"new-"+Ext.id());this.store.add([b]);this.startEditing(c.row+1,c.column)}}break;case"user_type":this.startEditing(c.row,c.column+1);break;case"container_id":if(c.record==this.eventOriginator){this.record.set("container_id","");this.record.set("container_id",c.record.get("displaycontainer_id"))}break}},onBeforeAttenderEdit:function(c){if(c.field=="status"){var b=c.record.get("displaycontainer_id");c.cancel=!(b&&b.account_grants&&b.account_grants.editGrant);return}if(c.field=="displaycontainer_id"){if(!c.value||!c.value.account_grants||!c.value.account_grants.deleteGrant){c.cancel=true}return}if(!this.record.get("editGrant")){c.cancel=true;return}if(c.record.get("user_id")){c.cancel=true;if(c.field=="quantity"&&c.record.get("user_type")=="resource"){c.cancel=false}return}if(c.field=="user_id"){var a=c.grid.getColumnModel();switch(c.record.get("user_type")){case"user":a.config[c.column].setEditor(new Tine.Addressbook.SearchCombo({blurOnSelect:true,selectOnFocus:true,renderAttenderName:this.renderAttenderName,getValue:function(){return this.selectedRecord?this.selectedRecord.data:null}}));break;case"group":case"memberOf":a.config[c.column].setEditor(new Tine.Tinebase.widgets.form.RecordPickerComboBox({blurOnSelect:true,recordClass:Tine.Addressbook.Model.List,getValue:function(){return this.selectedRecord?this.selectedRecord.data:null}}));break;case"resource":a.config[c.column].setEditor(new Tine.Tinebase.widgets.form.RecordPickerComboBox({blurOnSelect:true,recordClass:Tine.Calendar.Model.Resource,getValue:function(){return this.selectedRecord?this.selectedRecord.data:null}}));break}a.config[c.column].editor.selectedRecord=null}},onContextMenu:function(b,a){b.preventDefault();var d=this.getView().findRowIndex(a);var c=this.store.getAt(d);if(c){var c=this.store.getAt(d);if(!c.get("user_id")){return}this.ctxMenu=new Ext.menu.Menu({items:[{text:this.app.i18n._("Remove Attender"),iconCls:"action_delete",scope:this,disabled:!this.record.get("editGrant"),handler:function(){this.store.removeAt(d)}}]});this.ctxMenu.showAt(b.getXY())}},onRecordLoad:function(b){this.record=b;this.store.removeAll();var a=b.get("attendee");Ext.each(a,function(d){var c=new Tine.Calendar.Model.Attender(d,d.id);this.store.addSorted(c);if(d.displaycontainer_id&&this.record.get("container_id")&&d.displaycontainer_id.id==this.record.get("container_id").id){this.eventOriginator=c}},this);if(b.get("editGrant")){this.store.add([new Tine.Calendar.Model.Attender(Tine.Calendar.Model.Attender.getDefaultData(),"new-"+Ext.id())])}},onRecordUpdate:function(b){this.stopEditing(false);var a=[];this.store.each(function(d){var c=d.get("user_id");if(c){if(typeof c.get=="function"){d.data.user_id=c.data}a.push(d.data)}},this);b.set("attendee","");b.set("attendee",a)},onKeyDown:function(b){switch(b.getKey()){case b.DELETE:if(this.record.get("editGrant")){var a=this.getSelectionModel().getSelectedCell();if(a){var d=a[0];var c=this.store.getAt(d);if(!c.get("user_id")){return}this.store.removeAt(d)}}break}},renderAttenderName:function(c,b,a){if(c){var d=a?a.get("user_type"):"user";return this["renderAttender"+Ext.util.Format.capitalize(d)+"Name"].apply(this,arguments)}if(arguments[1]){arguments[1].css="x-form-empty-field";return this.app.i18n._("Click here to invite another attender...")}},renderAttenderUserName:function(a){if(typeof a.get=="function"&&a.get("n_fileas")){return Ext.util.Format.htmlEncode(a.get("n_fileas"))}if(a.n_fileas){return Ext.util.Format.htmlEncode(a.n_fileas)}if(a.accountDisplayName){return Ext.util.Format.htmlEncode(a.accountDisplayName)}if(Ext.isString(a)&&!a.match("^[0-9a-f-]{40,}$")&&!parseInt(a,10)){return Ext.util.Format.htmlEncode(a)}return Tine.Tinebase.appMgr.get("Calendar").i18n._("No Information")},renderAttenderGroupmemberName:function(a){var a=Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderUserName.apply(this,arguments);return a+" "+Tine.Tinebase.appMgr.get("Calendar").i18n._("(as a group member)")},renderAttenderGroupName:function(a){if(typeof a.getTitle=="function"){return Ext.util.Format.htmlEncode(a.getTitle())}if(a.name){return Ext.util.Format.htmlEncode(a.name)}if(Ext.isString(a)){return Ext.util.Format.htmlEncode(a)}return Tine.Tinebase.appMgr.get("Calendar").i18n._("No Information")},renderAttenderMemberofName:function(a){return Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderGroupName.apply(this,arguments)},renderAttenderResourceName:function(a){if(typeof a.getTitle=="function"){return Ext.util.Format.htmlEncode(a.getTitle())}if(a.name){return Ext.util.Format.htmlEncode(a.name)}if(Ext.isString(a)){return Ext.util.Format.htmlEncode(a)}return Tine.Tinebase.appMgr.get("Calendar").i18n._("No Information")},renderAttenderDispContainer:function(b,a,c){a.attr='style = "overflow: none;"';if(b){if(b.name){return Ext.util.Format.htmlEncode(b.name).replace(/ /g,"&nbsp;")}else{a.css="x-form-empty-field";return this.app.i18n._("No Information")}}},renderAttenderQuantity:function(b,a,c){return b>1?b:""},renderAttenderRole:function(a){switch(a){case"REQ":return this.app.i18n._("Required");break;case"OPT":return this.app.i18n._("Optional");break;default:return Ext.util.Format.htmlEncode(this.app.i18n._hidden(a));break}},renderAttenderStatus:function(a,c,d){if(!d.get("user_id")){return""}if(d.get("displaycontainer_id")){c.attr='style = "cursor:pointer;"'}else{c.css="x-form-empty-field"}var b=Tine.Tinebase.appMgr.get("Calendar").i18n;switch(a){case"NEEDS-ACTION":return b._("No response");break;case"ACCEPTED":return b._("Accepted");break;case"DECLINED":return b._("Declined");break;case"TENTATIVE":return b._("Tentative");break;default:return Ext.util.Format.htmlEncode(b._hidden(a));break}},renderAttenderType:function(d,c,e){c.css="tine-grid-cell-no-dirty";var b="";switch(d){case"user":b="renderer_accountUserIcon";break;case"group":b="renderer_accountGroupIcon";break;default:b="cal-attendee-type-"+d;break}var a='<div style="background-position:0px;" class="'+b+'">&#160</div>';if(!e.get("user_id")){a=Tine.Tinebase.common.cellEditorHintRenderer(a)}return a}});Ext.ns("Tine.Calendar");Tine.Calendar.AttendeeFilterModel=Ext.extend(Tine.widgets.grid.FilterModel,{app:null,field:"attender",defaultOperator:"equals",initComponent:function(){Tine.Calendar.AttendeeFilterModel.superclass.initComponent.call(this);this.app=Tine.Tinebase.appMgr.get("Calendar");this.operators=["in"];this.label=this.app.i18n._("Attendee");this.defaultValue=Ext.apply(Tine.Calendar.Model.Attender.getDefaultData(),{user_id:Tine.Tinebase.registry.get("currentAccount")})},valueRenderer:function(b,a){var c=new Tine.Calendar.AttendeeFilterModelValueField({app:this.app,filter:b,width:200,id:"tw-ftb-frow-valuefield-"+b.id,value:b.data.value?b.data.value:this.defaultValue,renderTo:a});c.on("select",this.onFiltertrigger,this);return c}});Tine.widgets.grid.FilterToolbar.FILTERS["calendar.attendee"]=Tine.Calendar.AttendeeFilterModel;Tine.Calendar.AttendeeFilterModelValueField=Ext.extend(Ext.ux.form.LayerCombo,{hideButtons:false,layerAlign:"tr-br?",minLayerWidth:400,layerHeight:300,lazyInit:true,formConfig:{labelAlign:"left",labelWidth:30},initComponent:function(){this.fakeRecord=new Tine.Calendar.Model.Event(Tine.Calendar.Model.Event.getDefaultData());this.on("beforecollapse",this.onBeforeCollapse,this);this.supr().initComponent.call(this)},getFormValue:function(){this.attendeeGridPanel.onRecordUpdate(this.fakeRecord);return this.fakeRecord.get("attendee")},getItems:function(){this.attendeeGridPanel=new Tine.Calendar.AttendeeGridPanel({title:this.app.i18n._("Select Attendee"),height:this.layerHeight||"auto",showNamesOnly:true,showMemberOfType:true});this.attendeeGridPanel.store.on({add:function(b){this.action_ok.setDisabled(this.attendeeGridPanel.store.getCount()===1)},remove:function(b){this.action_ok.setDisabled(this.attendeeGridPanel.store.getCount()===1)},scope:this});var a=[this.attendeeGridPanel];return a},onBeforeCollapse:function(){return(!this.attendeeGridPanel.ctxMenu||this.attendeeGridPanel.ctxMenu.hidden)&&!this.attendeeGridPanel.editing},setValue:function(c){c=Ext.isArray(c)?c:[c];this.fakeRecord.set("attendee","");this.fakeRecord.set("attendee",c);this.currentValue=[];var d=Tine.Calendar.Model.Attender.getAttendeeStore(c);var b=[];d.each(function(e){this.currentValue.push(e.data);var a=Tine.Calendar.AttendeeGridPanel.prototype.renderAttenderName.call(Tine.Calendar.AttendeeGridPanel.prototype,e.get("user_id"),false,e);b.push(a)},this);this.setRawValue(b.join(", "));return this},setFormValue:function(a){this.attendeeGridPanel.onRecordLoad(this.fakeRecord)}});Ext.ns("Tine.Calendar");Tine.Calendar.AttendeeStatusFilterModel=Ext.extend(Tine.widgets.grid.FilterModel,{app:null,field:"attender_status",defaultOperator:"notin",initComponent:function(){this.operators=["in","notin"];this.label=_("Attendee Status");this.defaultValue=["DECLINED"];this.supr().initComponent.call(this)},valueRenderer:function(b,a){var c=new Tine.Calendar.AttendeeStatusFilterModelValueField({app:this.app,filter:b,width:200,id:"tw-ftb-frow-valuefield-"+b.id,value:b.data.value?b.data.value:this.defaultValue,renderTo:a});c.on("specialkey",function(f,d){if(d.getKey()==d.ENTER){this.onFiltertrigger()}},this);c.on("select",this.onFiltertrigger,this);return c}});Tine.widgets.grid.FilterToolbar.FILTERS["calendar.attendeestatus"]=Tine.Calendar.AttendeeStatusFilterModel;Tine.Calendar.AttendeeStatusFilterModelValueField=Ext.extend(Ext.ux.form.LayerCombo,{hideButtons:false,formConfig:{labelAlign:"left",labelWidth:30},getFormValue:function(){var a=[];var d=Tine.Calendar.Model.Attender.getAttendeeStatusStore();var b=this.getInnerForm().getForm().getValues();for(var c in b){if(b[c]==="on"&&d.getById(c)){a.push(c)}}return a},getItems:function(){var a=[];Tine.Calendar.Model.Attender.getAttendeeStatusStore().each(function(b){a.push({xtype:"checkbox",boxLabel:b.get("status_name"),icon:b.get("status_icon"),name:b.get("id")})},this);return a},setValue:function(a){a=Ext.isArray(a)?a:[a];var c=Tine.Calendar.Model.Attender.getAttendeeStatusStore();var b=[];this.currentValue=[];Tine.Calendar.Model.Attender.getAttendeeStatusStore().each(function(d){var f=d.get("id");var e=d.get("status_name");if(a.indexOf(f)>=0){b.push(e);this.currentValue.push(f)}},this);this.setRawValue(b.join(", "));return this},setFormValue:function(a){this.getInnerForm().getForm().items.each(function(b){b.setValue(a.indexOf(b.name)>=0?"on":"off")},this)}});Ext.ns("Tine.Calendar");Tine.Calendar.FilterPanel=Ext.extend(Tine.widgets.persistentfilter.PickerPanel,{filter:[{field:"model",operator:"equals",value:"Calendar_Model_EventFilter"}],getFilterToolbar:function(){return this.app.getMainScreen().getCenterPanel().filterToolbar},storeOnBeforeload:function(a,b){b.params.filter=this.store.getById(this.getSelectionModel().getSelectedNode().id).get("filters");b.params.filter=Ext.decode(Ext.encode(b.params.filter));var c=Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getCenterPanel();var d=c.getCalendarPanel(c.activeView).getView().getPeriod();Ext.each(b.params.filter,function(e){if(e.field==="period"){b.params.filter.remove(e);return false}},this);b.params.filter.push({field:"period",operator:"within",value:d});a.un("beforeload",this.storeOnBeforeload,this)}});Tine.Calendar.CalendarSelectTreePanel=Ext.extend(Tine.widgets.container.TreePanel,{recordClass:Tine.Calendar.Model.Event,ddGroup:"cal-event",filterMode:"filterToolbar",useContainerColor:true,initComponent:function(){this.filterPlugin=new Tine.widgets.tree.FilterPlugin({treePanel:this,getGridPanel:function(){return Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getCenterPanel()}});this.on("beforeclick",this.onBeforeClick,this);this.on("containercolorset",function(){Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getCenterPanel().refresh(true)});this.supr().initComponent.call(this)},onBeforeClick:function(a,b){if(a.attributes.path.match(/^\/$|^\/personal$/)){this.onClick(a,b);return false}},onBeforeCreateNode:function(a){this.supr().onBeforeCreateNode.apply(this,arguments);if(a.container){a.container.capabilites_private=true}},onBeforeNodeDrop:function(e){var a=e.target.attributes,d=e.data.selections,b=Tine.Tinebase.appMgr.get("Calendar").getMainScreen().getCenterPanel(),c=b.getCalendarPanel(b.activeView),f=false;if(!a.account_grants.addGrant){f=true}Ext.each(d,function(g){if(Tine.Tinebase.container.pathIsMyPersonalContainer(g.get("container_id").path)){g.set("container_id",a.id);c.onUpdateEventAction(g);e.cancel=false;e.dropNode=[]}else{f=true}},this);if(f){return false}}});Ext.ns("Tine.Calendar");Tine.Calendar.CalendarSelectWidget=function(a){this.EventEditDialog=a;Tine.Calendar.CalendarSelectWidget.superclass.constructor.call(this)};Ext.extend(Tine.Calendar.CalendarSelectWidget,Ext.Panel,{layout:"fit",style:"padding-right: 5px;",calMapRecord:Ext.data.Record.create([{name:"attender"},{name:"calendar"},{name:"user"},{name:"userAccountId"},{name:"calendarName"},{name:"userName"},{name:"editGrant"},{name:"isOriginal"}]),currentCalMap:null,requiredGrant:"editGrant",EventEditDialog:null,calCombo:null,getPhysContainer:function(){return this.record.get("container_id")},buildCalMapStore:function(b){this.calMapStore.removeAll();var a=this.record.get("container_id");this.EventEditDialog.attendeeStore.each(function(h){var g=h.get("displaycontainer_id");var c=h.get("user_id");var e=h.getUserAccountId();var d=this.EventEditDialog.attendeeGridPanel.renderAttenderDispContainer(g,{});var f=this.EventEditDialog.attendeeGridPanel.renderAttenderName(c,{});if(e&&f){if(g&&g.name){if(!(a&&a.name)||a.id!=g.id){if(!b||g.account_grants.editGrant){this.calMapStore.add([new this.calMapRecord({attender:h,calendar:g,user:c,userAccountId:e,calendarName:d,userName:String.format("for {0}",f),editGrant:g.account_grants.editGrant,isOriginal:false})])}}}}},this);if(a&&a.name&&(!b||a.account_grants.editGrant)){this.calMapStore.add([new this.calMapRecord({calendar:a,calendarName:a.name,userName:this.app.i18n._("Originally"),editGrant:a.account_grants.editGrant,isOriginal:true})])}},initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.recordClass=Tine.Calendar.Model.Event;this.currentAccountId=Tine.Tinebase.registry.get("currentAccount").accountId;this.calMapStore=new Ext.data.SimpleStore({fields:this.calMapRecord});this.initTpl();this.fakeCombo=new Ext.form.ComboBox({mode:"local",hideMode:"visibility",style:{position:"absolute",top:"0px",right:"0px"},store:this.calMapStore,tpl:this.attendeeListTpl,onSelect:this.onCalMapSelect.createDelegate(this)});this.calCombo=new Tine.widgets.container.selectionComboBox({hideLabel:true,containerName:this.app.i18n.n_hidden(this.recordClass.getMeta("containerName"),this.recordClass.getMeta("containersName"),1),containersName:this.app.i18n._hidden(this.recordClass.getMeta("containersName")),appName:this.app.appName,requiredGrant:this.requiredGrant,hideTrigger2:false,trigger2Class:"cal-invitation-trigger",onTrigger2Click:this.fakeCombo.onTriggerClick.createDelegate(this.fakeCombo),allowBlank:true,listeners:{scope:this,beforequery:this.onBeforeCalComboQuery,select:this.onCalComboSelect}});this.items=[this.calCombo,this.fakeCombo];this.supr().initComponent.call(this)},initTpl:function(){this.attendeeListTpl=new Ext.XTemplate('<tpl for="."><div class="cal-calselectwidget-fakelist-item x-combo-list-item"><div class="cal-calselectwidget-fakelist-calendar">{calendarName}</div><div class="cal-calselectwidget-fakelist-account">{userName}</div></div></tpl>')},onAttendeUpdate:function(a,c){var b=attender.getUserAccountId();if(b){if(typeof c.get("displaycontainer_id").get=="function"){if(c.get("displaycontainer_id").get("account_grants").account_id==this.currentCalMap.get("userAccountId")){this.currentCalMap.set("calendar","");this.currentCalMap.set("calendar",c.get("displaycontainer_id"));this.calCombo.setRawValue(c.get("displaycontainer_id").get("name"))}else{if(b==this.currentAccountId&&c.get("user_type")=="user"&&this.currentCalMap.get("isOriginal")){this.currentCalMap.set("calendar","");this.currentCalMap.set("calendar",c.get("displaycontainer_id"));this.calCombo.setRawValue(c.get("displaycontainer_id").get("name"))}}}}},onBeforeCalComboQuery:function(){if(!this.currentCalMap||this.currentCalMap.get("isOriginal")){this.calCombo.startPath="/"}else{this.calCombo.startPath="/personal/"+this.currentCalMap.get("userAccountId")}},onCalComboSelect:function(){var a=this.calCombo.selectedContainer;a.toString=function(){return a.id};if(!this.currentCalMap||this.currentCalMap.get("isOriginal")){this.record.set("container_id",a)}else{this.currentCalMap.get("attender").set("displaycontainer_id",a)}},onCalMapSelect:function(a,b){if(a&&typeof a.get=="function"){this.calCombo.setValue(a.get("calendar"));this.calCombo.setTrigger2Text(String.format(a.get("userName")));this.currentCalMap=a;this.fakeCombo.collapse();this.fakeCombo.hide();this.fakeCombo.fireEvent("select",this.fakeCombo,a,b)}},onRecordLoad:function(b){this.record=b;this.buildCalMapStore(true);if(this.calMapStore.getCount()==0){if(this.record.phantom){this.calCombo.setValue("")}else{this.buildCalMapStore(false);if(this.calMapStore.getCount()>0){this.onCalMapSelect(this.calMapStore.getAt(0))}this.calCombo.setDisabled(true)}}else{if(this.calMapStore.getCount()==1){this.onCalMapSelect(this.calMapStore.getAt(0));this.calCombo.setTrigger2Disabled(true)}else{var d=this.calMapStore.find("userAccountId",this.currentAccountId);var a=this.calMapStore.find("isOriginal",true);var c=d>0?d:a;this.onCalMapSelect(this.calMapStore.getAt(c))}}},onRecordUpdate:function(a){},onResize:function(b,a){this.supr().onResize.apply(this,arguments);this.fakeCombo.setWidth(b)}});Ext.ns("Tine.Calendar");Tine.Calendar.ColorManager=function(a){Ext.apply(this,a);this.colorMap={};this.id=this.stateId;Ext.ComponentMgr.register(this);this.addEvents("beforestaterestore","staterestore","beforestatesave","statesave");if(this.stateful){this.initState()}};Ext.extend(Tine.Calendar.ColorManager,Ext.util.Observable,{schemaName:"standard",stateId:"cal-color-mgr-containers",stateful:false,colorMap:null,colorSchemataPointer:0,gray:{color:"#808080",light:"#EDEDED",text:"#FFFFFF",lightText:"#FFFFFF"},colorPalette:Ext.ColorPalette.prototype.colors,colorSchemata:{"000000":{color:"#000000",light:"#8F8F8F",text:"#FFFFFF",lightText:"#FFFFFF"},"993300":{color:"#993300",light:"#CEA590",text:"#FFFFFF",lightText:"#FFFFFF"},"333300":{color:"#333300",light:"#A6A691",text:"#FFFFFF",lightText:"#FFFFFF"},"003300":{color:"#003300",light:"#8FA48F",text:"#FFFFFF",lightText:"#FFFFFF"},"003366":{color:"#003366",light:"#90A5B9",text:"#FFFFFF",lightText:"#FFFFFF"},"000080":{color:"#000080",light:"#9090C4",text:"#FFFFFF",lightText:"#FFFFFF"},"333399":{color:"#333399",light:"#A5A5CE",text:"#FFFFFF",lightText:"#FFFFFF"},"333333":{color:"#333333",light:"#A6A6A6",text:"#FFFFFF",lightText:"#FFFFFF"},"800000":{color:"#800000",light:"#C79393",text:"#FFFFFF",lightText:"#FFFFFF"},FF6600:{color:"#FF6600",light:"#F8BB92",text:"#FFFFFF",lightText:"#FFFFFF"},"808000":{color:"#808000",light:"#C6C692",text:"#FFFFFF",lightText:"#FFFFFF"},"008000":{color:"#008000",light:"#92C692",text:"#FFFFFF",lightText:"#FFFFFF"},"008080":{color:"#008080",light:"#91C5C5",text:"#FFFFFF",lightText:"#FFFFFF"},"0000FF":{color:"#0000FF",light:"#9292F8",text:"#FFFFFF",lightText:"#FFFFFF"},"666699":{color:"#666699",light:"#BBBBD0",text:"#FFFFFF",lightText:"#FFFFFF"},"808080":{color:"#808080",light:"#C6C6C6",text:"#FFFFFF",lightText:"#FFFFFF"},FF0000:{color:"#FF0000",light:"#F89292",text:"#FFFFFF",lightText:"#FFFFFF"},FF9900:{color:"#FF9900",light:"#F8D092",text:"#FFFFFF",lightText:"#FFFFFF"},"99CC00":{color:"#99CC00",light:"#D0E492",text:"#FFFFFF",lightText:"#FFFFFF"},"339966":{color:"#339966",light:"#A7D0BB",text:"#FFFFFF",lightText:"#FFFFFF"},"33CCCC":{color:"#33CCCC",light:"#A8E5E5",text:"#FFFFFF",lightText:"#FFFFFF"},"3366FF":{color:"#3366FF",light:"#A7BBF8",text:"#FFFFFF",lightText:"#FFFFFF"},"800080":{color:"#800080",light:"#C692C6",text:"#FFFFFF",lightText:"#FFFFFF"},"969696":{color:"#969696",light:"#CECECE",text:"#FFFFFF",lightText:"#FFFFFF"},FF00FF:{color:"#FF00FF",light:"#F690F6",text:"#FFFFFF",lightText:"#FFFFFF"},FFCC00:{color:"#FFCC00",light:"#F7E391",text:"#FFFFFF",lightText:"#FFFFFF"},FFFF00:{color:"#FFFF00",light:"#F7F791",text:"#000000",lightText:"#000000"},"00FF00":{color:"#00FF00",light:"#93F993",text:"#000000",lightText:"#000000"},"00FFFF":{color:"#00FFFF",light:"#93F9F9",text:"#000000",lightText:"#000000"},"00CCFF":{color:"#00CCFF",light:"#93E5F9",text:"#FFFFFF",lightText:"#FFFFFF"},"993366":{color:"#993366",light:"#D1A8BC",text:"#FFFFFF",lightText:"#FFFFFF"},C0C0C0:{color:"#C0C0C0",light:"#DFDFDF",text:"#FFFFFF",lightText:"#FFFFFF"},FF99CC:{color:"#FF99CC",light:"#F8F0E4",text:"#FFFFFF",lightText:"#FFFFFF"},FFCC99:{color:"#FFCC99",light:"#F8E4D0",text:"#000000",lightText:"#000000"},FFFF99:{color:"#FFFF99",light:"#F9F9D1",text:"#000000",lightText:"#000000"},CCFFCC:{color:"#CCFFCC",light:"#E5F9E5",text:"#000000",lightText:"#000000"},CCFFFF:{color:"#CCFFFF",light:"#E5F9F9",text:"#000000",lightText:"#000000"},"99CCFF":{color:"#99CCFF",light:"#D0E4F8",text:"#000000",lightText:"#000000"},CC99FF:{color:"#CC99FF",light:"#E5D1F9",text:"#000000",lightText:"#000000"},FFFFFF:{color:"#DFDFDF",light:"#F8F8F8",text:"#000000",lightText:"#000000"}},getColor:function(b){var a=null;if(typeof b.get!="function"){a=b}else{a=b.get("container_id");if(!a||!a.type||a.type!="shared"){a=b.getDisplayContainer()}}if(!a.color){return this.gray}return this.colorSchemata[a.color.replace("#","")]}});Ext.ns("Tine.Calendar");Tine.Calendar.RrulePanel=Ext.extend(Ext.Panel,{wkdays:["SU","MO","TU","WE","TH","FR","SA"],activeRuleCard:null,layout:"form",frame:true,initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.title=this.app.i18n._("Recurrances");this.defaults={border:false};this.NONEcard=new Ext.Panel({freq:"NONE",html:this.app.i18n._("No recurring rule defined")});this.NONEcard.setRule=Ext.emptyFn;this.NONEcard.fillDefaults=Ext.emptyFn;this.NONEcard.getRule=function(){return null};this.NONEcard.isValid=function(){return true};this.DAILYcard=new Tine.Calendar.RrulePanel.DAILYcard({rrulePanel:this});this.WEEKLYcard=new Tine.Calendar.RrulePanel.WEEKLYcard({rrulePanel:this});this.MONTHLYcard=new Tine.Calendar.RrulePanel.MONTHLYcard({rrulePanel:this});this.YEARLYcard=new Tine.Calendar.RrulePanel.YEARLYcard({rrulePanel:this});this.ruleCards=new Ext.Panel({layout:"card",activeItem:0,items:[this.NONEcard,this.DAILYcard,this.WEEKLYcard,this.MONTHLYcard,this.YEARLYcard]});this.idPrefix=Ext.id();this.items=[{xtype:"toolbar",style:"margin-bottom: 5px;",items:[{id:this.idPrefix+"tglbtnNONE",xtype:"tbbtnlockedtoggle",enableToggle:true,text:this.app.i18n._("None"),handler:this.onFreqChange.createDelegate(this,["NONE"]),toggleGroup:this.idPrefix+"freqtglgroup"},{id:this.idPrefix+"tglbtnDAILY",xtype:"tbbtnlockedtoggle",enableToggle:true,text:this.app.i18n._("Daily"),handler:this.onFreqChange.createDelegate(this,["DAILY"]),toggleGroup:this.idPrefix+"freqtglgroup"},{id:this.idPrefix+"tglbtnWEEKLY",xtype:"tbbtnlockedtoggle",enableToggle:true,text:this.app.i18n._("Weekly"),handler:this.onFreqChange.createDelegate(this,["WEEKLY"]),toggleGroup:this.idPrefix+"freqtglgroup"},{id:this.idPrefix+"tglbtnMONTHLY",xtype:"tbbtnlockedtoggle",enableToggle:true,text:this.app.i18n._("Monthly"),handler:this.onFreqChange.createDelegate(this,["MONTHLY"]),toggleGroup:this.idPrefix+"freqtglgroup"},{id:this.idPrefix+"tglbtnYEARLY",xtype:"tbbtnlockedtoggle",enableToggle:true,text:this.app.i18n._("Yearly"),handler:this.onFreqChange.createDelegate(this,["YEARLY"]),toggleGroup:this.idPrefix+"freqtglgroup"}]},{layout:"form",style:"padding-left: 10px;",items:[this.ruleCards]}];Tine.Calendar.RrulePanel.superclass.initComponent.call(this)},isValid:function(){return this.activeRuleCard.isValid(this.record)},onFreqChange:function(a){this.ruleCards.layout.setActiveItem(this[a+"card"]);this.ruleCards.layout.layout();this.activeRuleCard=this[a+"card"]},onRecordLoad:function(a){this.record=a;if(!this.record.get("editGrant")||this.record.isRecurException()){this.items.each(function(h){h.setDisabled(true)},this)}this.rrule=this.record.get("rrule");var c=this.record.get("dtstart");if(Ext.isDate(c)){var e=Tine.Calendar.RrulePanel.prototype.wkdays[c.format("w")];var g=c.format("j");var b=c.format("n");this.WEEKLYcard.setRule({interval:1,byday:e});this.MONTHLYcard.setRule({interval:1,byday:"1"+e,bymonthday:g});this.YEARLYcard.setRule({byday:"1"+e,bymonthday:g,bymonth:b})}var f=this.rrule&&this.rrule.freq?this.rrule.freq:"NONE";var d=Ext.getCmp(this.idPrefix+"tglbtn"+f);d.toggle(true);this.activeRuleCard=this[f+"card"];this.ruleCards.activeItem=this.activeRuleCard;this.activeRuleCard.setRule(this.rrule);if(this.record.isRecurException()){this.activeRuleCard=this.NONEcard;this.items.each(function(h){h.setDisabled(true)},this);this.NONEcard.html=this.app.i18n._("Exceptions of reccuring events can't have recurrences themselves.")}},onRecordUpdate:function(a){var b=this.activeRuleCard.rendered?this.activeRuleCard.getRule():this.rrule;if(!this.rrule&&b){b.newrule=true}a.set("rrule","");a.set("rrule",b)}});Tine.Calendar.RrulePanel.AbstractCard=Ext.extend(Ext.Panel,{border:false,layout:"form",labelAlign:"side",autoHeight:true,getRule:function(){var a=this.until.getRawValue();a=a?Date.parseDate(a,this.until.format):null;if(Ext.isDate(a)){a=a.clearTime(true).add(Date.HOUR,24).add(Date.SECOND,-1).format(Date.patterns.ISO8601Long)}var b={freq:this.freq,interval:this.interval.getValue(),until:a};return b},onAfterUnitTriggerClick:function(){if(!this.until.getValue()){var a=this.rrulePanel.record.get("dtstart");this.until.menu.picker.setValue(a)}},initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.untilId=Ext.id();this.until=new Ext.form.DateField({requiredGrant:"editGrant",width:100,emptyText:this.app.i18n._("forever"),onTriggerClick:Ext.form.DateField.prototype.onTriggerClick.createSequence(this.onAfterUnitTriggerClick,this),listeners:{scope:this,render:function(d){d.wrap.setWidth.defer(100,d.wrap,[d.initialConfig.width])}}});var c=this.intervalString.split("{0}");var b=c[0];var a=c[1];this.interval=new Ext.form.NumberField({requiredGrant:"editGrant",style:"text-align:right;",value:1,width:40});if(!this.items){this.items=[]}if(this.freq!="YEARLY"){this.items=[{layout:"column",items:[{width:70,html:b},this.interval,{style:"padding-top: 2px;",html:a}]}].concat(this.items)}this.items=this.items.concat({layout:"column",style:"padding-top: 5px;",items:[{width:70,html:this.app.i18n._("Until")},this.until]});Tine.Calendar.RrulePanel.AbstractCard.superclass.initComponent.call(this)},isValid:function(a){var b=this.until.getValue();if(Ext.isDate(b)&&Ext.isDate(a.get("dtstart"))){if(b.getTime()<a.get("dtstart").getTime()){this.until.markInvalid(this.app.i18n._("Until has to be after event start"));return false}}return true},setRule:function(b){this.interval.setValue(b.interval);var a=Date.parseDate(b.until,Date.patterns.ISO8601Long);this.until.value=a}});Tine.Calendar.RrulePanel.DAILYcard=Ext.extend(Tine.Calendar.RrulePanel.AbstractCard,{freq:"DAILY",initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.intervalString=this.app.i18n._("Every {0}. Day");Tine.Calendar.RrulePanel.DAILYcard.superclass.initComponent.call(this)}});Tine.Calendar.RrulePanel.WEEKLYcard=Ext.extend(Tine.Calendar.RrulePanel.AbstractCard,{freq:"WEEKLY",getRule:function(){var b=Tine.Calendar.RrulePanel.WEEKLYcard.superclass.getRule.call(this);var a=[];this.byday.items.each(function(c){if(c.checked){a.push(c.name)}},this);b.byday=a.join();if(!b.byday){b.byday=this.byDayValue}return b},initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.intervalString=this.app.i18n._("Every {0}. Week at");var a=[];for(var b=0,c;b<7;b++){c=(b+Ext.DatePicker.prototype.startDay)%7;a.push({boxLabel:Date.dayNames[c],name:Tine.Calendar.RrulePanel.prototype.wkdays[c]})}this.byday=new Ext.form.CheckboxGroup({requiredGrant:"editGrant",style:"padding-top: 5px;",hideLabel:true,items:a});this.items=[this.byday];Tine.Calendar.RrulePanel.WEEKLYcard.superclass.initComponent.call(this)},setRule:function(b){Tine.Calendar.RrulePanel.WEEKLYcard.superclass.setRule.call(this,b);if(b.byday){this.byDayValue=b.byday;var a=b.byday.split(",");if(Ext.isArray(this.byday.items)){Ext.each(this.byday.items,function(c){if(a.indexOf(c.name)!=-1){c.checked=true}},this)}else{this.byday.items.each(function(c){if(a.indexOf(c.name)!=-1){c.setValue(true)}},this)}}}});Tine.Calendar.RrulePanel.MONTHLYcard=Ext.extend(Tine.Calendar.RrulePanel.AbstractCard,{freq:"MONTHLY",getRule:function(){var a=Tine.Calendar.RrulePanel.MONTHLYcard.superclass.getRule.call(this);if(this.bydayRadio.checked){a.byday=this.wkNumber.getValue()+this.wkDay.getValue()}else{a.bymonthday=this.bymonthdayday.getValue()}return a},initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.intervalString=this.app.i18n._("Every {0}. Month");this.idPrefix=Ext.id();this.bydayRadio=new Ext.form.Radio({hideLabel:true,boxLabel:this.app.i18n._("at the"),name:this.idPrefix+"byRadioGroup",inputValue:"BYDAY",checked:true,listeners:{check:this.onByRadioCheck.createDelegate(this)}});this.wkNumber=new Ext.form.ComboBox({requiredGrant:"editGrant",width:80,listWidth:80,triggerAction:"all",hideLabel:true,value:1,editable:false,mode:"local",store:[[1,this.app.i18n._("first")],[2,this.app.i18n._("second")],[3,this.app.i18n._("third")],[4,this.app.i18n._("fourth")],[-1,this.app.i18n._("last")]]});var b=[];for(var a=0,c;a<7;a++){c=(a+Ext.DatePicker.prototype.startDay)%7;Tine.Calendar.RrulePanel.prototype.wkdays[c];b.push([Tine.Calendar.RrulePanel.prototype.wkdays[c],Date.dayNames[c]])}this.wkDay=new Ext.form.ComboBox({requiredGrant:"editGrant",width:100,listWidth:100,triggerAction:"all",hideLabel:true,value:Tine.Calendar.RrulePanel.prototype.wkdays[Ext.DatePicker.prototype.startDay],editable:false,mode:"local",store:b});this.bymonthdayRadio=new Ext.form.Radio({requiredGrant:"editGrant",hideLabel:true,boxLabel:this.app.i18n._("at the"),name:this.idPrefix+"byRadioGroup",inputValue:"BYMONTHDAY",listeners:{check:this.onByRadioCheck.createDelegate(this)}});this.bymonthdayday=new Ext.form.NumberField({requiredGrant:"editGrant",hideLabel:true,width:40,value:1,disabled:true});this.items=[{html:'<div style="padding-top: 5px; padding-left: 5px"><div style="position: relative;"><table><tr><td style="position: relative;" width="60" id="'+this.idPrefix+'bydayradio"></td><td width="100" id="'+this.idPrefix+'bydaywknumber"></td><td width="110" id="'+this.idPrefix+'bydaywkday"></td></tr></table></div><div style="position: relative;"><table><tr><td width="60" id="'+this.idPrefix+'bymonthdayradio"></td><td width="40" id="'+this.idPrefix+'bymonthdayday"></td><td>.</td></tr></table></div></div>',listeners:{scope:this,render:this.onByRender}}];Tine.Calendar.RrulePanel.MONTHLYcard.superclass.initComponent.call(this)},onByRadioCheck:function(a,b){switch(a.inputValue){case"BYDAY":this.bymonthdayday.setDisabled(b);break;case"BYMONTHDAY":this.wkNumber.setDisabled(b);this.wkDay.setDisabled(b);break}},onByRender:function(){var b=Ext.get(this.idPrefix+"bydayradio");var c=Ext.get(this.idPrefix+"bydaywknumber");var e=Ext.get(this.idPrefix+"bydaywkday");var a=Ext.get(this.idPrefix+"bymonthdayradio");var d=Ext.get(this.idPrefix+"bymonthdayday");if(!(b&&a)){return this.onByRender.defer(100,this,arguments)}this.bydayRadio.render(b);this.wkNumber.render(c);this.wkNumber.wrap.setWidth(80);this.wkDay.render(e);this.wkDay.wrap.setWidth(100);this.bymonthdayRadio.render(a);this.bymonthdayday.render(d)},setRule:function(b){Tine.Calendar.RrulePanel.MONTHLYcard.superclass.setRule.call(this,b);if(b.byday){this.bydayRadio.setValue(true);this.bymonthdayRadio.setValue(false);this.onByRadioCheck(this.bydayRadio,true);this.onByRadioCheck(this.bymonthdayRadio,false);var a=b.byday.match(/([\-\d]{1,2})([A-Z]{2})/);this.wkNumber.setValue(a[1]);this.wkDay.setValue(a[2])}if(b.bymonthday){this.bydayRadio.setValue(false);this.bymonthdayRadio.setValue(true);this.onByRadioCheck(this.bydayRadio,false);this.onByRadioCheck(this.bymonthdayRadio,true);this.bymonthdayday.setValue(b.bymonthday)}}});Tine.Calendar.RrulePanel.YEARLYcard=Ext.extend(Tine.Calendar.RrulePanel.AbstractCard,{freq:"YEARLY",getRule:function(){var a=Tine.Calendar.RrulePanel.MONTHLYcard.superclass.getRule.call(this);if(this.bydayRadio.checked){a.byday=this.wkNumber.getValue()+this.wkDay.getValue()}else{a.bymonthday=this.bymonthdayday.getValue()}a.bymonth=this.bymonth.getValue();return a},initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.intervalString=this.app.i18n._("Every {0}. Year");this.idPrefix=Ext.id();this.bydayRadio=new Ext.form.Radio({requiredGrant:"editGrant",hideLabel:true,boxLabel:this.app.i18n._("at the"),name:this.idPrefix+"byRadioGroup",inputValue:"BYDAY",listeners:{check:this.onByRadioCheck.createDelegate(this)}});this.wkNumber=new Ext.form.ComboBox({requiredGrant:"editGrant",width:80,listWidth:80,triggerAction:"all",hideLabel:true,value:1,editable:false,mode:"local",disabled:true,store:[[1,this.app.i18n._("first")],[2,this.app.i18n._("second")],[3,this.app.i18n._("third")],[4,this.app.i18n._("fourth")],[-1,this.app.i18n._("last")]]});var b=[];for(var a=0,e;a<7;a++){e=(a+Ext.DatePicker.prototype.startDay)%7;Tine.Calendar.RrulePanel.prototype.wkdays[e];b.push([Tine.Calendar.RrulePanel.prototype.wkdays[e],Date.dayNames[e]])}this.wkDay=new Ext.form.ComboBox({requiredGrant:"editGrant",width:100,listWidth:100,triggerAction:"all",hideLabel:true,value:Tine.Calendar.RrulePanel.prototype.wkdays[Ext.DatePicker.prototype.startDay],editable:false,mode:"local",store:b,disabled:true});this.bymonthdayRadio=new Ext.form.Radio({requiredGrant:"editGrant",hideLabel:true,boxLabel:this.app.i18n._("at the"),name:this.idPrefix+"byRadioGroup",inputValue:"BYMONTHDAY",checked:true,listeners:{check:this.onByRadioCheck.createDelegate(this)}});this.bymonthdayday=new Ext.form.NumberField({requiredGrant:"editGrant",hideLabel:true,width:40,value:1});var c=[];for(var a=0;a<Date.monthNames.length;a++){c.push([a+1,Date.monthNames[a]])}this.bymonth=new Ext.form.ComboBox({requiredGrant:"editGrant",width:100,listWidth:100,triggerAction:"all",hideLabel:true,value:1,editable:false,mode:"local",store:c});this.items=[{html:'<div style="padding-top: 5px;"><div style="position: relative;"><table><tr><td style="position: relative;" width="65" id="'+this.idPrefix+'bydayradio"></td><td width="100" id="'+this.idPrefix+'bydaywknumber"></td><td width="110" id="'+this.idPrefix+'bydaywkday"></td></tr></table></div><div style="position: relative;"><table><tr><td width="65" id="'+this.idPrefix+'bymonthdayradio"></td><td width="40" id="'+this.idPrefix+'bymonthdayday"></td><td>.</td></tr></table></div><div style="position: relative;"><table><tr><td width="48" style="padding-left: 17px">'+this.app.i18n._("of")+'</td><td width="100" id="'+this.idPrefix+'bymonth"></td></tr></table></div></div>',listeners:{scope:this,render:this.onByRender}}];Tine.Calendar.RrulePanel.YEARLYcard.superclass.initComponent.call(this)},onByRadioCheck:function(a,b){switch(a.inputValue){case"BYDAY":this.bymonthdayday.setDisabled(b);break;case"BYMONTHDAY":this.wkNumber.setDisabled(b);this.wkDay.setDisabled(b);break}},onByRender:function(){var b=Ext.get(this.idPrefix+"bydayradio");var c=Ext.get(this.idPrefix+"bydaywknumber");var f=Ext.get(this.idPrefix+"bydaywkday");var a=Ext.get(this.idPrefix+"bymonthdayradio");var d=Ext.get(this.idPrefix+"bymonthdayday");var e=Ext.get(this.idPrefix+"bymonth");if(!(b&&a)){return this.onByRender.defer(100,this,arguments)}this.bydayRadio.render(b);this.wkNumber.render(c);this.wkNumber.wrap.setWidth(80);this.wkDay.render(f);this.wkDay.wrap.setWidth(100);this.bymonthdayRadio.render(a);this.bymonthdayday.render(d);this.bymonth.render(e);this.bymonth.wrap.setWidth(100)},setRule:function(b){Tine.Calendar.RrulePanel.MONTHLYcard.superclass.setRule.call(this,b);if(b.byday){this.bydayRadio.setValue(true);this.bymonthdayRadio.setValue(false);this.onByRadioCheck(this.bydayRadio,true);this.onByRadioCheck(this.bymonthdayRadio,false);var a=b.byday.match(/([\-\d]{1,2})([A-Z]{2})/);this.wkNumber.setValue(a[1]);this.wkDay.setValue(a[2])}if(b.bymonthday){this.bydayRadio.setValue(false);this.bymonthdayRadio.setValue(true);this.onByRadioCheck(this.bydayRadio,false);this.onByRadioCheck(this.bymonthdayRadio,true);this.bymonthdayday.setValue(b.bymonthday)}this.bymonth.setValue(b.bymonth)}});Ext.ns("Tine.Calendar");Tine.Calendar.ResourcesGridPanel=Ext.extend(Tine.widgets.grid.GridPanel,{recordClass:Tine.Calendar.Model.Resource,defaultSortInfo:{field:"name",dir:"ASC"},evalGrants:false,newRecordIcon:"cal-resource",initComponent:function(){this.app=Tine.Tinebase.appMgr.get("Calendar");this.gridConfig={};this.gridConfig.columns=[{id:"name",header:this.app.i18n._("Name"),width:150,sortable:true,dataIndex:"name"},{id:"email",header:this.app.i18n._("Email"),width:150,sortable:true,dataIndex:"email"},new Ext.ux.grid.CheckColumn({header:_("Location"),dataIndex:"is_location",width:55})];this.supr().initComponent.call(this)},initLayout:function(){this.supr().initLayout.call(this);this.items.push({region:"north",height:55,border:false,items:this.actionToolbar})},initialLoad:function(){this.store.load.defer(10,this.store,[typeof this.autoLoad=="object"?this.autoLoad:undefined])}});Ext.ns("Tine.Calendar");Tine.Calendar.ResourceEditDialog=Ext.extend(Tine.widgets.dialog.EditDialog,{recordClass:Tine.Calendar.Model.Resource,windowNamePrefix:"ResourceEditWindow_",evalGrants:false,showContainerSelector:false,tbarItems:[{xtype:"widget-activitiesaddbutton"}],getFormItems:function(){return{xtype:"tabpanel",border:false,plain:true,activeTab:0,border:false,items:[{title:this.app.i18n.n_("Resource","Resources",1),autoScroll:true,border:false,frame:true,layout:"border",items:[{region:"center",xtype:"columnform",labelAlign:"top",formDefaults:{xtype:"textfield",anchor:"100%",labelSeparator:"",columnWidth:0.333},items:[[{xtype:"textfield",fieldLabel:this.app.i18n._("Name"),allowBlank:false,name:"name"},{xtype:"textfield",fieldLabel:this.app.i18n._("Email"),allowBlank:false,name:"email",vtype:"email"},{xtype:"checkbox",fieldLabel:this.app.i18n._("Is a location"),name:"is_location"}],[{columnWidth:1,fieldLabel:this.app.i18n._("Description"),emptyText:this.app.i18n._("Enter description..."),name:"description",xtype:"textarea",height:200}]]},{layout:"accordion",animate:true,region:"east",width:210,split:true,collapsible:true,collapseMode:"mini",header:false,margins:"0 5 0 5",border:true,items:[new Tine.widgets.activities.ActivitiesPanel({app:"Calendar",showAddNoteForm:false,border:false,bodyStyle:"border:1px solid #B5B8C8;"}),new Tine.widgets.tags.TagPanel({app:"Calendar",border:false,bodyStyle:"border:1px solid #B5B8C8;"})]}]},new Tine.widgets.activities.ActivitiesTabPanel({app:this.appName,record_id:this.record.id,record_model:this.appName+"_Model_"+this.recordClass.getMeta("modelName")})]}}});Tine.Calendar.ResourceEditDialog.openWindow=function(a){var c=(a.record&&a.record.id)?a.record.id:0;var b=Tine.WindowFactory.getWindow({width:800,height:400,name:Tine.Calendar.ResourceEditDialog.prototype.windowNamePrefix+c,contentPanelConstructor:"Tine.Calendar.ResourceEditDialog",contentPanelConstructorConfig:a});return b};Ext.ns("Tine.Calendar.Printer");Tine.Calendar.Printer.BaseRenderer=Ext.extend(Ext.ux.Printer.BaseRenderer,{stylesheetPath:"Calendar/css/print.css",generateCalRows:function(h,d,e){var i,c,a,g,f=Math.ceil(h.length/d),b="";for(i=0;i<f;i++){a="";for(c=0;c<d;c++){g=e?i*d+c:c*f+i;a+=String.format('<td class="cal-print-daycell" style="vertical-align: top;">{0}</td>',h[g]||"")}b+=String.format('<tr class="cal-print-dayrow" style="height: {1}mm">{0}</tr>',a,this.paperHeight/f)}return b},generateDay:function(a,e,d){var c="";d.each(function(g){var h=g.data.dtstart.getTime()<=a.getTime()?a:g.data.dtstart,f=g.data.dtend.getTime()>e.getTime()?e:g.data.dtend;c+=this.eventTpl.apply({color:g.colorSet.color,startTime:g.data.is_all_day_event?"":h.format("H:i"),untilseperator:g.data.is_all_day_event?"":"-",endTime:g.data.is_all_day_event?"":f.format("H:i"),summary:Ext.util.Format.htmlEncode(g.data.summary),duration:g.data.is_all_day_event?Tine.Tinebase.appMgr.get("Calendar").i18n._("whole day"):Tine.Tinebase.common.minutesRenderer(Math.round((f.getTime()-h.getTime())/(1000*60)),"{0}:{1}","i")})},this);var b=this.dayTpl.apply({dayOfMonth:a.format("j"),weekDay:a.format("l")});return String.format('<table class="cal-print-daysview-day"><tr>{0}</tr>{1}</table>',b,c)},splitDays:function(c,b,d,e){var j=[];for(var h,a,g,f=0;f<d;f++){h=b.add(Date.DAY,f);a=h.add(Date.DAY,1).add(Date.SECOND,-1);g=c.queryBy(function(i){return i.data.dtstart.getTime()<a.getTime()&&i.data.dtend.getTime()>h.getTime()});j.push(e?{dayStart:h,dayEnd:a,dayEvents:g}:this.generateDay(h,a,g))}return j},dayTpl:new Ext.XTemplate("<tr>",'<th  colspan="5">','<span class="cal-print-daysview-day-dayOfMonth">{dayOfMonth}</span>','<span class="cal-print-daysview-day-weekDay">{weekDay}</span>',"</th>","</tr>"),eventTpl:new Ext.XTemplate("<tr>",'<td class="cal-print-daysview-day-color"><span style="color: {color};">&#9673;</span></td>','<td class="cal-print-daysview-day-starttime">{startTime}</td>','<td class="cal-print-daysview-day-untilseperator">{untilseperator}</td>','<td class="cal-print-daysview-day-endtime">{endTime}</td>','<td class="cal-print-daysview-day-summary">{summary} (<span class="cal-print-daysview-day-duration">{duration}</span>)</td>',"</tr>")});Tine.Calendar.Printer.DaysViewRenderer=Ext.extend(Tine.Calendar.Printer.BaseRenderer,{paperHeight:200,generateBody:function(b){var c=this.splitDays(b.ds,b.startDate,b.numOfDays),a=[];a.push('<table><tr><th class="cal-print-title">',this.getTitle(b),"</th></tr></table>");if(b.numOfDays===1){a.push(String.format('<div class="cal-print-day-singleday">{0}</div>',c[0]))}else{if(b.numOfDays<9){if(b.numOfDays==7&&b.startDate.format("w")==1){a.push(this.generateIsoWeek(c))}else{a.push(String.format("<table>{0}</table>",this.generateCalRows(c,2)))}}else{a.push(String.format("<table>{0}</table>",this.generateCalRows(c,2,true)))}}return a.join("\n")},getTitle:function(f){if(f.numOfDays==1){return String.format(f.dayFormatString+" {3}",f.startDate.format("l"),f.startDate.format("j"),f.startDate.format("F"),f.startDate.format("Y"))}else{var b=f.startDate.add(Date.DAY,f.numOfDays-1),h=f.startDate.format("j. "),g=f.startDate.format("F "),e=f.startDate.format("Y "),d=b.format("j. "),c=b.format("F "),i=b.format("Y "),a=f.numOfDays==7?String.format(f.app.i18n._("Week {0} :"),f.startDate.add(Date.DAY,1).getWeekOfYear())+" ":"";if(e===i){e=""}if(g===c){g=""}return a+h+g+e+" - "+d+c+i}},generateIsoWeek:function(b){var a=this.paperHeight/4;return["<table>",'<tr style="height: '+a+'mm;">','<td class="cal-print-daycell" width="50%">',b[0],"</td>",'<td class="cal-print-daycell" width="50%">',b[3],"</td>","</tr>",'<tr style="height: '+a+'mm;">','<td class="cal-print-daycell" width="50%">',b[1],"</td>",'<td class="cal-print-daycell" width="50%">',b[4],"</td>","</tr>",'<tr style="height: '+a+'mm;">','<td class="cal-print-daycell" width="50%">',b[2],"</td>",'<td class="cal-print-daycell" width="50%">','<table style="padding: 0;">','<tr style="height: '+a/2+'mm;">','<td class="cal-print-daycell" width="100%" style="padding: 0;">',b[5],"</td>","</tr>",'<tr style="height: '+a/2+'mm;">','<td class="cal-print-daycell" width="100%" style="padding: 0;">',b[6],"</td>","</tr>","</table>","</tr>","</table>"].join("\n")}});Tine.Calendar.Printer.MonthViewRenderer=Ext.extend(Tine.Calendar.Printer.BaseRenderer,{paperHeight:170,generateBody:function(b){var e=this.splitDays(b.ds,b.dateMesh[0],b.dateMesh.length),a=[];a.push('<style type="text/css">',"@page {","size:landscape","}","</style>");a.push('<table><tr><th class="cal-print-title">',this.getTitle(b),"</th></tr></table>");var g=[];for(var c=0;c<7;c++){var f=b.startDay+c;if(f>6){f=f-7}g.push("<td class='cal-print-monthview-daycell'><span>",b.dayNames[f],"</span></td>")}a.push(String.format('<br/><table class="cal-print-monthview"><tr>{0}</thead>{1}</tr>',g.join("\n"),this.generateCalRows(e,7,true)));return a.join("\n")},getTitle:function(a){return a.dateMesh[10].format("F Y")},dayHeadersTpl:new Ext.XTemplate("<tr>",'<tpl for=".">',"<th>{{dataIndex}}</th>","</tpl>","</tr>")});