/************************** generic translations **************************/ 
Locale.prototype.TranslationLists={Date:{full:"Y年n月j日L","long":"Y年n月j日",medium:"Y/m/d","short":"y/m/d"},Time:{full:"G時i分s秒v","long":"H:i:sT",medium:"G:i:s","short":"G:i"},DateTime:{Ed:"j日(T)",GGGGyMd:"GGGGy年n月j日",H:"G時",Hm:"G:i",M:"L",MEd:"n/j(E)",MMM:"LLL",MMMEd:"n月j日(E)",MMMMEd:"n月j日(E)",MMMMd:"n月j日",MMMd:"n月j日",MMdd:"m/d",Md:"n/j",d:"j日",mmss:"i:s",ms:"i:s",y:"y",yM:"y/n",yMEd:"y/n/j(T)",yMMM:"y年n月",yMMMEd:"y年n月j日(T)",yMMMM:"y年n月",yQ:"y/Q",yQQQ:"YQQQ",yyMMM:"y年n月",yyQ:"y/Q",yyyy:"y年",yyyyMM:"Y/m"},Month:{"1":"1月","2":"2月","3":"3月","4":"4月","5":"5月","6":"6月","7":"7月","8":"8月","9":"9月","10":"10月","11":"11月","12":"12月"},Day:{sun:"日曜日",mon:"月曜日",tue:"火曜日",wed:"水曜日",thu:"木曜日",fri:"金曜日",sat:"土曜日"},Symbols:{decimal:".",group:",",list:";",percent:"%",zero:"0",pattern:"#",plus:"+",minus:"-",exponent:"E",mille:"‰",infinity:"∞",nan:"NaN"},Question:{yes:"はい:ハイ",no:"いいえ:イイエ"},Language:{aa:"アファル語",ab:"アブハズ語",ace:"アチェー語",ach:"アチョリ語",ada:"アダングメ語",ady:"アディゲ語",ae:"アヴェスタ語",af:"アフリカーンス語",afa:"セム・ハム諸語",afh:"アフリヒリ語",ain:"アイヌ語",ak:"アカン語",akk:"アッカド語",ale:"アレウト語",alg:"アルゴンキアン語族",alt:"南アルタイ語",am:"アムハラ語",an:"アラゴン語",ang:"古代英語",anp:"アンギカ語",apa:"アパッチ語族",ar:"アラビア語",arc:"アラム語",arn:"アラウカン語",arp:"アラパホー語",art:"人工諸語",arw:"アラワク語",as:"アッサム語",ast:"アストゥリアス語",ath:"アサパスカン語族",aus:"オーストラリア語族",av:"アヴァル語",awa:"アワディー語",ay:"アイマラ語",az:"アゼルバイジャン語",ba:"バシキール語",bad:"バンダ語",bai:"バミレケ語族",bal:"バルーチー語",ban:"バリ語",bas:"バサ語",bat:"バルト諸語",be:"ベラルーシ語",bej:"ベジャ語",bem:"ベンバ語",ber:"ベルベル諸語",bg:"ブルガリア語",bh:"ビハール語",bho:"ボージプリー語",bi:"ビスラマ語",bik:"ビコル語",bin:"ビニ語",bla:"シクシカ語",bm:"バンバラ語",bn:"ベンガル語",bnt:"バントゥ諸語",bo:"チベット語",br:"ブルトン語",bra:"ブラジ語",bs:"ボスニア語",btk:"バタク語",bua:"ブリヤート語",bug:"ブギ語",byn:"ビリン語",ca:"カタロニア語",cad:"カドー語",cai:"中米インディアン諸語",car:"カリブ語",cau:"コーカサス諸語",cch:"チャワイ語",ce:"チェチェン語",ceb:"セブアノ語",cel:"ケルト諸語",ch:"チャモロ語",chb:"チブチャ語",chg:"チャガタイ語",chk:"チューク語",chm:"マリ語",chn:"ビーチ・ラ・マー 等",cho:"チョクトー語",chp:"チペワイアン語",chr:"チェロキー語",chy:"シャイアン語",cmc:"チャム語族",co:"コルシカ語",cop:"コプト語",cpe:"英語が基盤の混成語・混合語",cpf:"フランス語が基盤の混成語・混合語",cpp:"ポルトガル語が基盤の混成語・混合語",cr:"クリー語",crh:"クリミア・タタール語",crp:"その他の混成語・混合語",cs:"チェコ語",csb:"カシューブ語",cu:"教会スラブ語",cus:"クシュ諸語",cv:"チュヴァシュ語",cy:"ウェールズ語",da:"デンマーク語",dak:"ダコタ語",dar:"ダルガン語",day:"ダヤク語",de:"ドイツ語",de_AT:"ドイツ語（オーストリア）",de_CH:"正統ドイツ語（スイス）",del:"デラウェア語",den:"スレイビー語",dgr:"ドグリブ語",din:"ディンカ語",doi:"ドグリ語",dra:"ドラヴィダ諸語",dsb:"低ソルビア語",dua:"ドゥアラ語",dum:"中世オランダ語",dv:"ディベヒ語",dyu:"デゥウラ語",dz:"ゾンカ語",ee:"エウェ語",efi:"エフィック語",egy:"古代エジプト語",eka:"エカジュク語",el:"ギリシャ語",elx:"エラム語",en:"英語",en_CA:"カナダ英語",en_GB:"イギリス英語",en_US:"アメリカ英語",enm:"中世英語",eo:"エスペラント語",es:"スペイン語",es_419:"スペイン語（ラテンアメリカ）",es_ES:"スペイン語（イベリア半島）",et:"エストニア語",eu:"バスク語",ewo:"エウォンド語",fa:"ペルシア語",fan:"ファング語",fat:"ファンティー語",ff:"フラニ語",fi:"フィンランド語",fil:"フィリピノ語",fiu:"フィン・ウゴル諸語",fj:"フィジー語",fo:"フェロー語",fon:"フォン語",fr:"フランス語",fr_CA:"フランス語（カナダ）",fr_CH:"フランス語（スイス）",frm:"中期フランス語",fro:"古フランス語",frs:"東フリジア語",fur:"フリウリ語",fy:"フリジア語",ga:"アイルランド語",gaa:"ガ語",gay:"ガヨ語",gba:"バヤ語",gd:"スコットランド・ゲール語",gem:"ゲルマン諸語",gez:"ゲエズ語",gil:"キリバス語",gl:"ガリシア語",gmh:"中高ドイツ語",gn:"グアラニー語",goh:"古高ドイツ語",gon:"ゴーンディー語",gor:"ゴロンタロ語",got:"ゴート語",grb:"グレボ語",grc:"古代ギリシャ語",gsw:"スイスドイツ語（スイス）",gu:"グジャラート語",gv:"マン島語",gwi:"グウィッチン語",ha:"ハウサ語",hai:"ハイダ語",haw:"ハワイ語",he:"ヘブライ語",hi:"ヒンディー語",hil:"ヒリガイノン語",him:"ヒマチャル語",hit:"ヒッタイト語",hmn:"フモン語",ho:"ヒリモトゥ語",hr:"クロアチア語",hsb:"上ソルビア語",ht:"ハイチ語",hu:"ハンガリー語",hup:"アタパスカ語",hy:"アルメニア語",hz:"ヘレロ語",ia:"インターリングア語",iba:"イバン語",id:"インドネシア語",ie:"インターリング語",ig:"イボ語",ii:"四川イ語",ijo:"イジョー語",ik:"イヌピアック語",ilo:"イロカノ語",inc:"インド諸語",ine:"印欧諸語",inh:"イングシ語",io:"イド語",ira:"イラン語",iro:"イロコイ語族",is:"アイスランド語",it:"イタリア語",iu:"イヌクウティトット語",ja:"日本語",jbo:"ロジバン語",jpr:"ユダヤ・ペルシア語",jrb:"ユダヤ・アラビア語",jv:"ジャワ語",ka:"グルジア語",kaa:"カラ・カルパク語",kab:"カビル語",kac:"カチン語",kaj:"カジェ語",kam:"カンバ語",kar:"カレン語",kaw:"カウィ語",kbd:"カバルド語",kcg:"カタブ語",kfo:"コロ語",kg:"コンゴ語",kha:"カシ語",khi:"コイサン諸語",kho:"コータン語",ki:"キクユ語",kj:"クアニャマ語",kk:"カザフ語",kl:"グリーンランド語",km:"クメール語",kmb:"キンブンドゥ語",kn:"カンナダ語",ko:"韓国語",kok:"コンカニ語",kos:"コシャエ語",kpe:"クペレ語",kr:"カヌリ語",krc:"カラチャイ語",krl:"カレリア語",kro:"クルー語",kru:"クルク語",ks:"カシミール語",ku:"クルド語",kum:"クムク語",kut:"クテナイ語",kv:"コミ語",kw:"コーンウォール語",ky:"キルギス語",la:"ラテン語",lad:"ラジノ語",lah:"ラフンダー語",lam:"ランバ語",lb:"ルクセンブルク語",lez:"レズギ語",lg:"ガンダ語",li:"リンブルフ語",ln:"リンガラ語",lo:"ラオ語",lol:"モンゴ語",loz:"ロズィ語",lt:"リトアニア語",lu:"ルバ・カタンガ語",lua:"ルバ・ルルア語",lui:"ルイセーニョ語",lun:"ルンダ語",luo:"ルオ語",lus:"ルシャイ語",lv:"ラトビア語",mad:"マドゥラ語",mag:"マガヒー語",mai:"マイティリー語",mak:"マカッサル語",man:"マンディンゴ語",map:"オーストロネシア諸語",mas:"マサイ語",mdf:"モクシャ語",mdr:"マンダル語",men:"メンデ語",mg:"マダガスカル語",mga:"中期アイルランド語",mh:"マーシャル語",mi:"マオリ語",mic:"ミクマク語",min:"ミナンカバウ語",mis:"その他の言語",mk:"マケドニア語",mkh:"モン・クメール諸語",ml:"マラヤーラム語",mn:"モンゴル語",mnc:"満州語",mni:"マニプル語",mno:"マノボ語族",mo:"モルダビア語",moh:"モーホーク語",mos:"モシ語",mr:"マラーティー語",ms:"マレー語",mt:"マルタ語",mul:"複数言語",mun:"ムンダ語族",mus:"クリーク語",mwl:"ミランダ語",mwr:"マールワーリー語",my:"ビルマ語",myn:"マヤ語族",myv:"エルジャ語",na:"ナウル語",nah:"ナワトル語",nai:"北米インディアン諸語",nap:"ナポリ語",nb:"ノルウェー語 (ブークモール)",nd:"北ンデベレ語",nds:"低地ドイツ語、低地サクソン語",ne:"ネパール語","new":"ネワール語",ng:"ンドンガ語",nia:"ニアス語",nic:"ニジェール・コルドファン諸語",niu:"ニウーエイ語",nl:"オランダ語",nl_BE:"フレミッシュ語",nn:"ノルウェー語 (ニーノシュク)",no:"ノルウェー語",nog:"ノガイ語",non:"古ノルド語",nqo:"ンコ語",nr:"南ンデベレ語",nso:"北部ソト語",nub:"ヌビア語族",nv:"ナバホ語",nwc:"古典ネワール語",ny:"ニャンジャ語、チチェワ語、チェワ語",nym:"ニャムウェジ語",nyn:"ニャンコレ語",nyo:"ニョロ語",nzi:"ンゼマ語",oc:"オック語",oj:"オブジワ語",om:"オロモ語",or:"オリヤー語",os:"オセト語",osa:"オセージ語",ota:"オスマントルコ語",oto:"オトミ語族",pa:"パンジャブ語",paa:"パプア諸語",pag:"パンガシナン語",pal:"パフラヴィ語",pam:"パンパンガ語",pap:"パピアメント語",pau:"パラオ語",peo:"古代ペルシア語",phi:"フィリピン諸語",phn:"フェニキア語",pi:"パーリ語",pl:"ポーランド語",pon:"ポンペイ語",pra:"プラークリット語族",pro:"古期プロバンス語",ps:"パシュトゥー語",pt:"ポルトガル語",pt_BR:"ポルトガル語 (ブラジル)",pt_PT:"ポルトガル語（イベリア半島）",qu:"ケチュア語",raj:"ラージャスターン語",rap:"ラパヌイ語",rar:"ラロトガ語",rm:"レト・ロマン語",rn:"ルンディ語",ro:"ルーマニア語",roa:"ロマンス諸語",rom:"ロマーニー語",root:"ルート",ru:"ロシア語",rup:"アルーマニア語",rw:"ルワンダ語",sa:"サンスクリット語",sad:"サンダウェ語",sah:"ヤクート語",sai:"南米インディアン諸語",sal:"セイリッシュ語族",sam:"サマリア・アラム語",sas:"ササク語",sat:"サンターリー語",sc:"サルデーニャ語",scn:"シチリア語",sco:"スコットランド語",sd:"シンド語",se:"北サーミ語",sel:"セリクプ語",sem:"セム諸語",sg:"サンゴ語",sga:"古期アイルランド語",sgn:"手まね言語",sh:"セルボ＝クロアチア語",shn:"シャン語",si:"シンハラ語",sid:"シダモ語",sio:"スー語族",sit:"シナ・チベット諸語",sk:"スロバキア語",sl:"スロベニア語",sla:"スラブ諸語",sm:"サモア語",sma:"南サーミ語",smi:"サーミ諸語",smj:"ルレ・サーミ語",smn:"イナリ・サーミ語",sms:"スコルト・サーミ語",sn:"ショナ語",snk:"ソニンケ語",so:"ソマリ語",sog:"ソグド語",son:"ソンガイ語",sq:"アルバニア語",sr:"セルビア語",srn:"スリナム語",srr:"セレル語",ss:"シスワティ語",ssa:"ナイル・サハラ諸語",st:"南部ソト語",su:"スンダ語",suk:"スクマ語",sus:"スス語",sux:"シュメール語",sv:"スウェーデン語",sw:"スワヒリ語",syr:"シリア語",ta:"タミール語",tai:"タイ諸語",te:"テルグ語",tem:"テムネ語",ter:"テレーノ語",tet:"テトゥン語",tg:"タジク語",th:"タイ語",ti:"ティグリニア語",tig:"ティグレ語",tiv:"ティブ語",tk:"トルクメン語",tkl:"トケラウ語",tl:"タガログ語",tlh:"クリンゴン語",tli:"トリンギット語",tmh:"タマシェク語",tn:"ツワナ語",to:"トンガ語",tog:"トンガ語 (ニアサ)",tpi:"トク・ピシン語",tr:"トルコ語",ts:"ツォンガ語",tsi:"チムシュ語",tt:"タタール語",tum:"トゥンブカ語",tup:"トゥピ語族",tut:"アルタイ諸語",tvl:"ツバル語",tw:"トウィ語",ty:"タヒチ語",tyv:"トゥヴァ語",udm:"ウドムルト語",ug:"ウイグル語",uga:"ウガリト語",uk:"ウクライナ語",umb:"ウンブンドゥ語",und:"非確定",ur:"ウルドゥー語",uz:"ウズベク語",vai:"ヴァイ語",ve:"ベンダ語",vi:"ベトナム語",vo:"ボラピュク語",vot:"ボート語",wa:"ワロン語",wak:"ワカシ語族",wal:"ワッラモ語",war:"ワライ語",was:"ワショ語",wen:"ソルビア語族",wo:"ウォロフ語",xal:"カルムイク語",xh:"コサ語",yao:"ヤオ語",yap:"ヤップ語",yi:"イディッシュ語",yo:"ヨルバ語",ypk:"ユピック語族",za:"チワン語",zap:"ザポテック語",zen:"ゼナガ語",zh:"中国語",zh_Hans:"簡体中国語",zh_Hant:"繁体中国語",znd:"ザンデ語",zu:"ズールー語",zun:"ズニ語"},CountryList:{AD:"アンドラ",AE:"アラブ首長国連邦",AF:"アフガニスタン",AG:"アンティグア・バーブーダ",AI:"アンギラ",AL:"アルバニア",AM:"アルメニア",AN:"オランダ領アンティル諸島",AO:"アンゴラ",AQ:"南極大陸",AR:"アルゼンチン",AS:"米領サモア",AT:"オーストリア",AU:"オーストラリア",AW:"アルバ島",AX:"オーランド諸島",AZ:"アゼルバイジャン",BA:"ボスニア・ヘルツェゴビナ",BB:"バルバドス",BD:"バングラデシュ",BE:"ベルギー",BF:"ブルキナファソ",BG:"ブルガリア",BH:"バーレーン",BI:"ブルンジ",BJ:"ベニン",BL:"サン・バルテルミー",BM:"バミューダ",BN:"ブルネイ",BO:"ボリビア",BR:"ブラジル",BS:"バハマ",BT:"ブータン",BV:"ブーベ島",BW:"ボツワナ",BY:"ベラルーシ",BZ:"ベリーズ",CA:"カナダ",CC:"ココス (キーリング) 諸島",CD:"コンゴ民主共和国 (キンシャサ)",CF:"中央アフリカ共和国",CG:"コンゴ共和国 (ブラザビル)",CH:"スイス",CI:"コートジボワール",CK:"クック諸島",CL:"チリ",CM:"カメルーン",CN:"中国",CO:"コロンビア",CR:"コスタリカ",CS:"セルビア・モンテネグロ",CU:"キューバ",CV:"カーボベルデ",CX:"クリスマス島",CY:"キプロス",CZ:"チェコ共和国",DE:"ドイツ",DJ:"ジブチ",DK:"デンマーク",DM:"ドミニカ国",DO:"ドミニカ共和国",DZ:"アルジェリア",EC:"エクアドル",EE:"エストニア",EG:"エジプト",EH:"西サハラ",ER:"エリトリア",ES:"スペイン",ET:"エチオピア",FI:"フィンランド",FJ:"フィジー",FK:"フォークランド諸島",FM:"ミクロネシア",FO:"フェロー諸島",FR:"フランス",GA:"ガボン",GB:"イギリス",GD:"グレナダ",GE:"グルジア",GF:"仏領ギアナ",GG:"ガーンジー",GH:"ガーナ",GI:"ジブラルタル",GL:"グリーンランド",GM:"ガンビア",GN:"ギニア",GP:"グアドループ",GQ:"赤道ギニア",GR:"ギリシャ",GS:"南ジョージア島・南サンドイッチ諸島",GT:"グアテマラ",GU:"グアム",GW:"ギニアビサウ",GY:"ガイアナ",HK:"香港",HM:"ハード島・マクドナルド諸島",HN:"ホンジュラス",HR:"クロアチア",HT:"ハイチ",HU:"ハンガリー",ID:"インドネシア",IE:"アイルランド",IL:"イスラエル",IM:"マン島",IN:"インド",IO:"英領インド洋植民地",IQ:"イラク",IR:"イラン",IS:"アイスランド",IT:"イタリア",JE:"ジャージー",JM:"ジャマイカ",JO:"ヨルダン",JP:"日本",KE:"ケニア",KG:"キルギスタン",KH:"カンボジア",KI:"キリバス",KM:"コモロ",KN:"セントクリストファー・ネイビス",KP:"朝鮮民主主義人民共和国",KR:"大韓民国",KW:"クウェート",KY:"ケイマン諸島",KZ:"カザフスタン",LA:"ラオス",LB:"レバノン",LC:"セントルシア",LI:"リヒテンシュタイン",LK:"スリランカ",LR:"リベリア",LS:"レソト",LT:"リトアニア",LU:"ルクセンブルグ",LV:"ラトビア",LY:"リビア",MA:"モロッコ",MC:"モナコ",MD:"モルドバ",ME:"モンテネグロ",MF:"セント・マーチン",MG:"マダガスカル",MH:"マーシャル諸島共和国",MK:"マケドニア",ML:"マリ",MM:"ミャンマー",MN:"モンゴル",MO:"マカオ",MP:"北マリアナ諸島",MQ:"マルティニーク島",MR:"モーリタニア",MS:"モントセラト島",MT:"マルタ",MU:"モーリシャス",MV:"モルジブ",MW:"マラウィ",MX:"メキシコ",MY:"マレーシア",MZ:"モザンビーク",NA:"ナミビア",NC:"ニューカレドニア",NE:"ニジェール",NF:"ノーフォーク島",NG:"ナイジェリア",NI:"ニカラグア",NL:"オランダ",NO:"ノルウェー",NP:"ネパール",NR:"ナウル",NU:"ニウエ島",NZ:"ニュージーランド",OM:"オマーン",PA:"パナマ",PE:"ペルー",PF:"仏領ポリネシア",PG:"パプアニューギニア",PH:"フィリピン",PK:"パキスタン",PL:"ポーランド",PM:"サンピエール島・ミクロン島",PN:"ピトケアン島",PR:"プエルトリコ",PS:"パレスチナ領土",PT:"ポルトガル",PW:"パラオ",PY:"パラグアイ",QA:"カタール",RE:"レユニオン島",RO:"ルーマニア",RS:"セルビア",RU:"ロシア",RW:"ルワンダ",SA:"サウジアラビア",SB:"ソロモン諸島",SC:"セーシェル",SD:"スーダン",SE:"スウェーデン",SG:"シンガポール",SH:"セントヘレナ",SI:"スロベニア",SJ:"スバールバル諸島・ヤンマイエン島",SK:"スロバキア",SL:"シエラレオネ",SM:"サンマリノ",SN:"セネガル",SO:"ソマリア",SR:"スリナム",ST:"サントメ・プリンシペ",SV:"エルサルバドル",SY:"シリア",SZ:"スワジランド",TC:"タークス諸島・カイコス諸島",TD:"チャド",TF:"フランス領極南諸島",TG:"トーゴ",TH:"タイ",TJ:"タジキスタン",TK:"トケラウ諸島",TL:"東ティモール",TM:"トルクメニスタン",TN:"チュニジア",TO:"トンガ",TR:"トルコ",TT:"トリニダード・トバゴ",TV:"ツバル",TW:"台湾",TZ:"タンザニア",UA:"ウクライナ",UG:"ウガンダ",UM:"米領太平洋諸島",US:"アメリカ合衆国",UY:"ウルグアイ",UZ:"ウズベキスタン",VA:"バチカン市国",VC:"セントビンセント・グレナディーン諸島",VE:"ベネズエラ",VG:"イギリス領ヴァージン諸島",VI:"アメリカ領ヴァージン諸島",VN:"ベトナム",VU:"バヌアツ",WF:"ウォリス・フツナ",WS:"サモア",YE:"イエメン",YT:"マヨット島",ZA:"南アフリカ",ZM:"ザンビア",ZW:"ジンバブエ",ZZ:"不明な地域"},Territory:{"001":"世界","002":"アフリカ","003":"北米","005":"南アメリカ","009":"オセアニア","011":"西アフリカ","013":"中央アメリカ","014":"東アフリカ","015":"北アフリカ","017":"中部アフリカ","018":"南部アフリカ","019":"アメリカ大陸","021":"北アメリカ","029":"カリブ海","030":"東アジア","034":"南アジア","035":"東南アジア","039":"南ヨーロッパ","053":"オーストラリア・ニュージーランド","054":"メラネシア","057":"ミクロネシア地域","061":"ポリネシア","062":"南中央アジア","142":"アジア","143":"中央アジア","145":"西アジア","150":"ヨーロッパ","151":"東ヨーロッパ","154":"北ヨーロッパ","155":"西ヨーロッパ","172":"独立国家共同体","419":"ラテンアメリカ・カリブ地域","830":"チャネル諸島",QO:"その他のオセアニア",QU:"欧州連合"},CityToTimezone:{"Etc/Unknown":"不明","Europe/Andorra":"アンドラ公国","Asia/Dubai":"ドバイ","Asia/Kabul":"カブール","America/Antigua":"アンチグア","America/Anguilla":"アンギラ","Europe/Tirane":"チラナ","Asia/Yerevan":"エレバン","America/Curacao":"キュラソー","Africa/Luanda":"ルアンダ","Antarctica/Rothera":"ロデラ","Antarctica/Palmer":"パーマー","Antarctica/South_Pole":"南極点","Antarctica/Syowa":"昭和基地","Antarctica/Mawson":"モーソン","Antarctica/Davis":"デービス","Antarctica/Vostok":"ボストーク","Antarctica/Casey":"ケーシー","Antarctica/DumontDUrville":"デュモン デュルビル","Antarctica/McMurdo":"マクムード","America/Argentina/Rio_Gallegos":"リオガイェゴス","America/Mendoza":"メンドーサ","America/Argentina/San_Juan":"サンファン","America/Argentina/Ushuaia":"ウスアイア","America/Argentina/La_Rioja":"ラリオハ","America/Argentina/San_Luis":"サンルイス","America/Catamarca":"カタマルカ","America/Jujuy":"フフイ","America/Argentina/Tucuman":"トゥクマン","America/Cordoba":"コルドバ","America/Buenos_Aires":"ブエノスアイレス","Pacific/Pago_Pago":"パゴパゴ","Europe/Vienna":"ウィーン","Australia/Perth":"パース","Australia/Eucla":"ユークラ","Australia/Darwin":"ダーウィン","Australia/Adelaide":"アデレード","Australia/Broken_Hill":"ブロークンヒル","Australia/Currie":"カリー","Australia/Melbourne":"メルボルン","Australia/Hobart":"ホバート","Australia/Lindeman":"リンデマン","Australia/Sydney":"シドニー","Australia/Brisbane":"ブリスベン","Australia/Lord_Howe":"ロードハウ","America/Aruba":"アルバ","Asia/Baku":"バクー","America/Barbados":"バルバドス","Asia/Dhaka":"ダッカ","Europe/Brussels":"ブリュッセル","Africa/Ouagadougou":"ワガドゥグー","Europe/Sofia":"ソフィア","Asia/Bahrain":"バーレーン国","Africa/Bujumbura":"ブジュンブラ","Africa/Porto-Novo":"ポルトノボ","Atlantic/Bermuda":"バミューダ","Asia/Brunei":"ブルネイ","America/La_Paz":"ラパス","America/Eirunepe":"エイルネペ","America/Rio_Branco":"リオブランコ","America/Porto_Velho":"ポルトベーリョ","America/Boa_Vista":"ボアビスタ","America/Manaus":"マナウス","America/Cuiaba":"クイアバ","America/Campo_Grande":"カンポグランデ","America/Belem":"ベレン","America/Araguaina":"アラグァイナ","America/Sao_Paulo":"サンパウロ","America/Bahia":"バイーア","America/Fortaleza":"フォルタレザ","America/Maceio":"マセイオ","America/Recife":"レシフェ","America/Noronha":"ノロニャ","America/Nassau":"ナッサウ","Asia/Thimphu":"ティンプー","Africa/Gaborone":"ガボローネ","Europe/Minsk":"ミンスク","America/Belize":"ベリーズ","America/Dawson":"ドーソン","America/Whitehorse":"ホワイトホース","America/Inuvik":"イヌヴィク","America/Vancouver":"バンクーバー","America/Dawson_Creek":"ドーソンクリーク","America/Yellowknife":"イエローナイフ","America/Edmonton":"エドモントン","America/Swift_Current":"スウィフトカレント","America/Cambridge_Bay":"ケンブリッジベイ","America/Regina":"レジャイナ","America/Winnipeg":"ウィニペグ","America/Resolute":"レソリュート","America/Rainy_River":"レイニーリバー","America/Rankin_Inlet":"ランキン湾","America/Coral_Harbour":"コーラルハーバー","America/Thunder_Bay":"サンダーベイ","America/Nipigon":"ニピゴン","America/Toronto":"トロント","America/Montreal":"モントリオール","America/Iqaluit":"イカルイット","America/Pangnirtung":"パンナータング","America/Moncton":"モンクトン","America/Halifax":"ハリファクス","America/Goose_Bay":"グースベイ","America/Glace_Bay":"グレースベイ","America/Blanc-Sablon":"ブラン・サブロン","America/St_Johns":"セントジョンズ","Indian/Cocos":"ココス","Africa/Kinshasa":"キンシャサ","Africa/Lubumbashi":"ルブンバシ","Africa/Bangui":"バンギ","Africa/Brazzaville":"ブラザビル","Europe/Zurich":"チューリッヒ","Africa/Abidjan":"アビジャン","Pacific/Rarotonga":"ラロトンガ","Pacific/Easter":"イースター島","America/Santiago":"アメリカ/サンチアゴ","Africa/Douala":"ドゥアラ","Asia/Kashgar":"カシガル","Asia/Urumqi":"ウルムチ","Asia/Chongqing":"重慶","Asia/Shanghai":"上海","Asia/Harbin":"ハルビン","America/Bogota":"ボゴタ","America/Costa_Rica":"コスタリカ共和国","America/Havana":"ハバナ","Atlantic/Cape_Verde":"カボベルデ共和国","Indian/Christmas":"クリスマス","Asia/Nicosia":"ニコシア","Europe/Berlin":"ベルリン","Africa/Djibouti":"ジブチ共和国","Europe/Copenhagen":"コペンハーゲン","America/Dominica":"ドミニカ国","America/Santo_Domingo":"サントドミンゴ","Africa/Algiers":"アルジェ","Pacific/Galapagos":"ガラパゴス","America/Guayaquil":"アメリカ/グアヤキル","Europe/Tallinn":"タリン","Africa/Cairo":"カイロ","Africa/El_Aaiun":"アイウン","Africa/Asmera":"アスマラ","Atlantic/Canary":"カナリア諸島","Africa/Ceuta":"セウタ","Europe/Madrid":"ヨーロッパ/マドリード","Africa/Addis_Ababa":"アジスアベバ","Europe/Helsinki":"ヘルシンキ","Pacific/Fiji":"フィジー共和国","Atlantic/Stanley":"スタンリー","Pacific/Truk":"トラック","Pacific/Ponape":"ポナペ","Pacific/Kosrae":"コシャエ","Atlantic/Faeroe":"フェロー","Europe/Paris":"パリ","Africa/Libreville":"リーブルビル","Europe/London":"ヨーロッパ/ロンドン","America/Grenada":"グレナダ","Asia/Tbilisi":"トビリシ","America/Cayenne":"カイエンヌ","Africa/Accra":"アクラ","Europe/Gibraltar":"ジブラルタル","America/Thule":"チューレ","America/Godthab":"アメリカ/ゴッドホープ","America/Scoresbysund":"スコレスビスン","America/Danmarkshavn":"デンマークシャウン","Africa/Banjul":"バンジュル","Africa/Conakry":"コナクリ","America/Guadeloupe":"グアダループ","Africa/Malabo":"マラボ","Europe/Athens":"アテネ","Atlantic/South_Georgia":"南ジョージア島","America/Guatemala":"グァテマラ共和国","Pacific/Guam":"グアム","Africa/Bissau":"ビサウ","America/Guyana":"ガイアナ","Asia/Hong_Kong":"香港","America/Port-au-Prince":"ポルトープランス","Europe/Budapest":"ブダペスト","Asia/Jakarta":"ジャカルタ","Asia/Pontianak":"ポンティアナク","Asia/Makassar":"マカッサル","Asia/Jayapura":"ジャヤプラ","Europe/Dublin":"ダブリン","Asia/Jerusalem":"エルサレム","Indian/Chagos":"チャゴス","Asia/Baghdad":"バグダッド","Asia/Tehran":"テヘラン","Atlantic/Reykjavik":"レイキャビーク","Europe/Rome":"ローマ","America/Jamaica":"ジャマイカ","Asia/Amman":"アンマン","Asia/Tokyo":"東京","Africa/Nairobi":"ナイロビ","Asia/Bishkek":"ビシュケク","Asia/Phnom_Penh":"プノンペン","Pacific/Enderbury":"エンダベリー","Pacific/Kiritimati":"キリティマティ","Pacific/Tarawa":"タラワ","Indian/Comoro":"コモロ","America/St_Kitts":"セントキッツネイビス","Asia/Pyongyang":"平壌","Asia/Seoul":"ソウル","Asia/Kuwait":"クウェート国","America/Cayman":"ケイマン","Asia/Aqtau":"アクタウ","Asia/Oral":"オラル","Asia/Aqtobe":"アクトベ","Asia/Qyzylorda":"キジルオルダ","Asia/Almaty":"アルマトイ","Asia/Vientiane":"ビエンチャン","Asia/Beirut":"ベイルート","America/St_Lucia":"セントルシア","Europe/Vaduz":"ファドゥーツ","Asia/Colombo":"コロンボ","Africa/Monrovia":"モンロビア","Africa/Maseru":"マセル","Europe/Vilnius":"ヴィルニアス","Europe/Luxembourg":"ルクセンブルグ大公国","Europe/Riga":"リガ","Africa/Tripoli":"トリポリ","Africa/Casablanca":"カサブランカ","Europe/Monaco":"モナコ公国","Europe/Chisinau":"キシナウ","Indian/Antananarivo":"アンタナナリボ","Pacific/Kwajalein":"クワジェリン","Pacific/Majuro":"マジュロ","Africa/Bamako":"アフリカ/バマコ","Asia/Rangoon":"ラングーン","Asia/Hovd":"ホブド","Asia/Ulaanbaatar":"ウランバートル","Asia/Choibalsan":"チョイバルサン","Asia/Macau":"マカオ","Pacific/Saipan":"サイパン","America/Martinique":"マルチニーク","Africa/Nouakchott":"ヌアクショット","America/Montserrat":"モントセラト島","Europe/Malta":"マルタ共和国","Indian/Mauritius":"モーリシャス共和国","Indian/Maldives":"モルディブ共和国","Africa/Blantyre":"ブランタイア","America/Tijuana":"ティフアナ","America/Hermosillo":"エルモシヨ","America/Mazatlan":"マサトラン","America/Chihuahua":"チワワ","America/Monterrey":"モンテレイ","America/Mexico_City":"メキシコシティー","America/Merida":"メリダ","America/Cancun":"カンクン","Asia/Kuala_Lumpur":"アジア/クアラルンプール","Asia/Kuching":"クチン","Africa/Maputo":"マプト","Africa/Windhoek":"ビントフック","Pacific/Noumea":"ヌメア","Africa/Niamey":"ニアメー","Pacific/Norfolk":"ノーフォーク","Africa/Lagos":"ラゴス","America/Managua":"マナグア","Europe/Amsterdam":"アムステルダム","Europe/Oslo":"オスロ","Asia/Katmandu":"カトマンズ","Pacific/Nauru":"ナウル共和国","Pacific/Niue":"ニウエ","Pacific/Chatham":"チャタム","Pacific/Auckland":"太平洋/オークランド","Asia/Muscat":"マスカット","America/Panama":"パナマ共和国","America/Lima":"リマ","Pacific/Tahiti":"太平洋/タヒチ","Pacific/Marquesas":"マルケサス","Pacific/Gambier":"ガンビア","Pacific/Port_Moresby":"ポートモレスビー","Asia/Manila":"マニラ","Asia/Karachi":"カラチ","Europe/Warsaw":"ワルシャワ","America/Miquelon":"ミクロン","Pacific/Pitcairn":"ピトケアン島","America/Puerto_Rico":"プエルトリコ","Asia/Gaza":"ガザ","Atlantic/Azores":"アゾレス諸島","Atlantic/Madeira":"マデイラ","Europe/Lisbon":"ヨーロッパ/リスボン","Pacific/Palau":"パラオ共和国","America/Asuncion":"アスンシオン","Asia/Qatar":"カタール","Indian/Reunion":"レユニオン","Europe/Bucharest":"ブカレスト","Europe/Kaliningrad":"カリーニングラード","Europe/Moscow":"モスクワ","Europe/Volgograd":"ボルゴグラード","Europe/Samara":"サマラ","Asia/Yekaterinburg":"エカテリンブルグ","Asia/Omsk":"オムスク","Asia/Novosibirsk":"ノボシビルスク","Asia/Krasnoyarsk":"クラスノヤルスク","Asia/Irkutsk":"イルクーツク","Asia/Yakutsk":"ヤクーツク","Asia/Vladivostok":"ウラジオストク","Asia/Sakhalin":"サハリン","Asia/Magadan":"マガダン","Asia/Kamchatka":"カムチャッカ","Asia/Anadyr":"アナジル","Africa/Kigali":"キガリ","Asia/Riyadh":"リヤド","Pacific/Guadalcanal":"ガダルカナル","Indian/Mahe":"マエ","Africa/Khartoum":"ハルツーム","Europe/Stockholm":"ストックホルム","Asia/Singapore":"シンガポール","Atlantic/St_Helena":"セントヘレナ","Arctic/Longyearbyen":"北極/ロングイヤービーエン","Africa/Freetown":"フリータウン","Africa/Dakar":"ダカール","Africa/Mogadishu":"モガディシュ","America/Paramaribo":"パラマリボ","Africa/Sao_Tome":"サントメ","America/El_Salvador":"サルバドル","Asia/Damascus":"ダマスカス","Africa/Mbabane":"ムババネ","America/Grand_Turk":"グランドターク","Africa/Ndjamena":"ンジャメナ","Indian/Kerguelen":"ケルゲレーヌ","Africa/Lome":"ロメ","Asia/Bangkok":"バンコク","Asia/Dushanbe":"ドゥシャンベ","Pacific/Fakaofo":"ファカオフォ","Asia/Dili":"ディリ","Asia/Ashgabat":"アシガバード","Africa/Tunis":"チュニジア","Pacific/Tongatapu":"トンガタプ","Europe/Istanbul":"イスタンブール","America/Port_of_Spain":"ポートオブスペイン","Pacific/Funafuti":"フナフティ","Asia/Taipei":"台北","Africa/Dar_es_Salaam":"ダルエスサラーム","Europe/Uzhgorod":"ウジゴロド","Europe/Kiev":"キエフ","Europe/Simferopol":"シンフェローポリ","Europe/Zaporozhye":"ザポロージェ","Africa/Kampala":"カンパラ","Pacific/Midway":"ミッドウェー","Pacific/Johnston":"ジョンストン","Pacific/Wake":"ウェーク","America/Adak":"アダック","America/Nome":"ノーメ","Pacific/Honolulu":"ホノルル","America/Anchorage":"アンカレッジ","America/Yakutat":"ヤクタット","America/Juneau":"ジュノー","America/Los_Angeles":"ロサンゼルス","America/Boise":"ボイシ","America/Phoenix":"フェニックス","America/Shiprock":"シップロック","America/Denver":"デンバー","America/North_Dakota/New_Salem":"ノースダコタ州ニューセーラム","America/North_Dakota/Center":"ノースダコタ州センター","America/Chicago":"シカゴ","America/Menominee":"メノミニー","America/Indiana/Vincennes":"インディアナ州ビンセンス","America/Indiana/Petersburg":"インディアナ州ピーターズバーグ","America/Indiana/Tell_City":"インディアナ州テルシティ","America/Indiana/Knox":"インディアナ州ノックス","America/Indiana/Winamac":"インディアナ州ウィナマック","America/Indiana/Marengo":"インディアナ州マレンゴ","America/Indianapolis":"インディアナポリス","America/Louisville":"ルイスビル","America/Indiana/Vevay":"インディアナ州ビベー","America/Kentucky/Monticello":"ケンタッキー州モンティチェロ","America/Detroit":"デトロイト","America/New_York":"ニューヨーク","America/Montevideo":"モンテビデオ","Asia/Samarkand":"サマルカンド","Asia/Tashkent":"アジア/タシケント","America/St_Vincent":"セントヴィンセント","America/Caracas":"カラカス","America/Tortola":"トルトーラ","America/St_Thomas":"セントトマス","Asia/Saigon":"サイゴン","Pacific/Efate":"エファテ","Pacific/Wallis":"ワリー","Pacific/Apia":"アピーア","Asia/Aden":"アデン","Indian/Mayotte":"マイヨット島","Africa/Johannesburg":"ヨハネスブルグ","Africa/Lusaka":"ルサカ","Africa/Harare":"ハラーレ"}};
/*************************** extjs translations ***************************/ 
/*
 * Japanese translation
 * By tyama
 * 04-08-2007, 05:49 AM
 *
 * update based on English Translations by Condor (8 Aug 2008)
 * By sakuro (30 Aug 2008)
 */

Ext.UpdateManager.defaults.indicatorText = '<div class="loading-indicator">読み込み中...</div>';

if(Ext.DataView){
  Ext.DataView.prototype.emptyText = "";
}

if(Ext.grid.GridPanel){
  Ext.grid.GridPanel.prototype.ddText = "{0} 行選択";
}

if(Ext.LoadMask){
  Ext.LoadMask.prototype.msg = "読み込み中...";
}

Date.monthNames = [
  '1月',
  '2月',
  '3月',
  '4月',
  '5月',
  '6月',
  '7月',
  '8月',
  '9月',
  '10月',
  '11月',
  '12月'
];

Date.getShortMonthName = function(month) {
  return "" + (month + 1);
};

Date.monthNumbers = {
  "1" : 0,
  "2" : 1,
  "3" : 2,
  "4" : 3,
  "5" : 4,
  "6" : 5,
  "7" : 6,
  "8" : 7,
  "9" : 8,
  "10" : 9,
  "11" : 10,
  "12" : 11
};

Date.getMonthNumber = function(name) {
  return Date.monthNumbers[name.substring(0, name.length - 1)];
  // or simply parseInt(name.substring(0, name.length - 1)) - 1
};

Date.dayNames = [
  "日曜日",
  "月曜日",
  "火曜日",
  "水曜日",
  "木曜日",
  "金曜日",
  "土曜日"
];

Date.getShortDayName = function(day) {
  return Date.dayNames[day].substring(0, 1); // just remove "曜日" suffix
};

Date.formatCodes.a = "(this.getHours() < 12 ? '午前' : '午後')";
Date.formatCodes.A = "(this.getHours() < 12 ? '午前' : '午後')"; // no case difference

if(Ext.MessageBox){
  Ext.MessageBox.buttonText = {
    ok     : "OK",
    cancel : "キャンセル",
    yes    : "はい",
    no     : "いいえ"
  };
}

if(Ext.util.Format){
  Ext.util.Format.date = function(v, format){
    if(!v) return "";
    if(!(v instanceof Date)) v = new Date(Date.parse(v));
    return v.dateFormat(format || "Y/m/d");
  };
}

if(Ext.DatePicker){
  Ext.apply(Ext.DatePicker.prototype, {
    todayText         : "今日",
    minText           : "選択した日付は最小値以下です。",
    maxText           : "選択した日付は最大値以上です。",
    disabledDaysText  : "",
    disabledDatesText : "",
    monthNames        : Date.monthNames,
    dayNames          : Date.dayNames,
    nextText          : '次月へ (コントロール+右)',
    prevText          : '前月へ (コントロール+左)',
    monthYearText     : '月選択 (コントロール+上/下で年移動)',
    todayTip          : "{0} (スペースキー)",
    format            : "Y/m/d",
    okText            : "OK",
    cancelText        : "キャンセル",
    startDay          : 0
  });
}

if(Ext.PagingToolbar){
  Ext.apply(Ext.PagingToolbar.prototype, {
    beforePageText : "ページ",
    afterPageText  : "/ {0}",
    firstText      : "最初のページ",
    prevText       : "前のページ",
    nextText       : "次のページ",
    lastText       : "最後のページ",
    refreshText    : "更新",
    displayMsg     : "{2} 件中 {0} - {1} を表示",
    emptyMsg       : '表示するデータがありません。'
  });
}

if(Ext.form.Field){
  Ext.form.Field.prototype.invalidText = "フィールドの値が不正です。";
}

if(Ext.form.TextField){
  Ext.apply(Ext.form.TextField.prototype, {
    minLengthText : "このフィールドの最小値は {0} です。",
    maxLengthText : "このフィールドの最大値は {0} です。",
    blankText     : "必須項目です。",
    regexText     : "",
    emptyText     : null
  });
}

if(Ext.form.NumberField){
  Ext.apply(Ext.form.NumberField.prototype, {
    decimalSeparator : ".",
    decimalPrecision : 2,
    minText : "このフィールドの最小値は {0} です。",
    maxText : "このフィールドの最大値は {0} です。",
    nanText : "{0} は数値ではありません。"
  });
}

if(Ext.form.DateField){
  Ext.apply(Ext.form.DateField.prototype, {
    disabledDaysText  : "無効",
    disabledDatesText : "無効",
    minText           : "このフィールドの日付は、 {0} 以降の日付に設定してください。",
    maxText           : "このフィールドの日付は、 {0} 以前の日付に設定してください。",
    invalidText       : "{0} は間違った日付入力です。 - 入力形式は「{1}」です。",
    format            : "Y/m/d",
    altFormats        : "y/m/d|m/d/y|m/d/Y|m-d-y|m-d-Y|m/d|m-d|md|mdy|mdY|d|Y-m-d"
  });
}

if(Ext.form.ComboBox){
  Ext.apply(Ext.form.ComboBox.prototype, {
    loadingText       : "読み込み中...",
    valueNotFoundText : undefined
  });
}

if(Ext.form.VTypes){
  Ext.apply(Ext.form.VTypes, {
    emailText    : 'メールアドレスを"user@example.com"の形式で入力してください。',
    urlText      : 'URLを"http:/'+'/www.example.com"の形式で入力してください。',
    alphaText    : '半角英字と"_"のみです。',
    alphanumText : '半角英数と"_"のみです。'
  });
}

if(Ext.form.HtmlEditor){
  Ext.apply(Ext.form.HtmlEditor.prototype, {
    createLinkText : 'リンクのURLを入力してください:',
    buttonTips : {
      bold : {
        title: '太字 (コントロール+B)',
        text: '選択テキストを太字にします。',
        cls: 'x-html-editor-tip'
      },
      italic : {
        title: '斜体 (コントロール+I)',
        text: '選択テキストを斜体にします。',
        cls: 'x-html-editor-tip'
      },
      underline : {
        title: '下線 (コントロール+U)',
        text: '選択テキストに下線を引きます。',
        cls: 'x-html-editor-tip'
      },
      increasefontsize : {
        title: '文字を大きく',
        text: 'フォントサイズを大きくします。',
        cls: 'x-html-editor-tip'
      },
      decreasefontsize : {
        title: '文字を小さく',
        text: 'フォントサイズを小さくします。',
        cls: 'x-html-editor-tip'
      },
      backcolor : {
        title: '文字のハイライト',
        text: '選択テキストの背景色を変更します。',
        cls: 'x-html-editor-tip'
      },
      forecolor : {
        title: '文字の色',
        text: '選択テキストの色を変更します。',
        cls: 'x-html-editor-tip'
      },
      justifyleft : {
        title: '左揃え',
        text: 'テキストを左揃えにします。',
        cls: 'x-html-editor-tip'
      },
      justifycenter : {
        title: '中央揃え',
        text: 'テキストを中央揃えにします。',
        cls: 'x-html-editor-tip'
      },
      justifyright : {
        title: '右揃え',
        text: 'テキストを右揃えにします。',
        cls: 'x-html-editor-tip'
      },
      insertunorderedlist : {
        title: '番号なし箇条書き',
        text: '番号なし箇条書きを開始します。',
        cls: 'x-html-editor-tip'
      },
      insertorderedlist : {
        title: '番号付き箇条書き',
        text: '番号付き箇条書きを開始します。',
        cls: 'x-html-editor-tip'
      },
      createlink : {
        title: 'ハイパーリンク',
        text: '選択テキストをハイパーリンクにします。',
        cls: 'x-html-editor-tip'
      },
      sourceedit : {
        title: 'ソース編集',
        text: 'ソース編集モードに切り替えます。',
        cls: 'x-html-editor-tip'
      }
    }
  });
}

if(Ext.grid.GridView){
  Ext.apply(Ext.grid.GridView.prototype, {
    sortAscText  : "昇順",
    sortDescText : "降順",
    columnsText  : "カラム"
  });
}

if(Ext.grid.GroupingView){
  Ext.apply(Ext.grid.GroupingView.prototype, {
    emptyGroupText : '(なし)',
    groupByText    : 'このカラムでグルーピング',
    showGroupsText : 'グルーピング'
  });
}

if(Ext.grid.PropertyColumnModel){
  Ext.apply(Ext.grid.PropertyColumnModel.prototype, {
    nameText   : "名称",
    valueText  : "値",
    dateFormat : "Y/m/d"
  });
}

if(Ext.layout.BorderLayout && Ext.layout.BorderLayout.SplitRegion){
  Ext.apply(Ext.layout.BorderLayout.SplitRegion.prototype, {
    splitTip            : "ドラッグするとリサイズできます。",
    collapsibleSplitTip : "ドラッグでリサイズ。 ダブルクリックで隠す。"
  });
}

if(Ext.form.TimeField){
  Ext.apply(Ext.form.TimeField.prototype, {
    minText : "このフィールドの時刻は、 {0} 以降の時刻に設定してください。",
    maxText : "このフィールドの時刻は、 {0} 以前の時刻に設定してください。",
    invalidText : "{0} は間違った時刻入力です。",
    format : "g:i A",
    altFormats : "g:ia|g:iA|g:i a|g:i A|h:i|g:i|H:i|ga|ha|gA|h a|g a|g A|gi|hi|gia|hia|g|H"
  });
}

if(Ext.form.CheckboxGroup){
  Ext.apply(Ext.form.CheckboxGroup.prototype, {
    blankText : "このグループから最低１つのアイテムを選択しなければなりません。"
  });
}

if(Ext.form.RadioGroup){
  Ext.apply(Ext.form.RadioGroup.prototype, {
    blankText : "このグループから１つのアイテムを選択しなければなりません。"
  });
}
/********************** tine translations of Tinebase**********************/ 
Locale.Gettext.prototype._msgs['./LC_MESSAGES/Tinebase'] = new Locale.Gettext.PO(({
""
: "Project-Id-Version: Tine2.0\nPOT-Creation-Date: 2008-05-17 22:12+0100\nPO-Revision-Date: \nLast-Translator: kitamura yuuki <ykitamura@clasi-co.jp>\nLanguage-Team: Yuuki 'Taisa' Kitamura <ykitamura@clasi-co.jp>\nLanguage: \nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nPlural-Forms: nplurals=1; plural=0;\nX-Poedit-Language: Japanese\nX-Poedit-Country: JAPAN\n"

, "unknown"
: "不明"

, "Authorisation Required"
: "要認証"

, "Your session is not valid. You need to login again."
: "セッションが正しくありません。もう一度ログインしてください"

, "Abnormal End"
: "以上終了"

, "An error occurred, the program ended abnormal."
: "エラーが発生し、プログラムが異常終了しました"

, "default"
: ""

, "note"
: "ノート"

, "default note type"
: "標準ノートタイプ"

, "telephone"
: "電話"

, "telephone call"
: "通話"

, "email"
: "Eメール"

, "email contact"
: "Eメールコンタクト"

, "created"
: "作成されました"

, "record created"
: "レコードが作製されました"

, "changed"
: "変更されました"

, "record changed"
: "レコードが変更されました"

, "Timezone"
: "タイムゾーン"

, "The timezone in which dates are shown in Tine 2.0."
: ""

, "Language"
: "言語"

, "The language of the Tine 2.0 GUI."
: ""

, "Default Application"
: ""

, "The default application to show after login."
: ""

, "Window Type"
: ""

, "You can choose between ExtJs style windows or normal Browser popup windows."
: ""

, "Confirm Logout"
: ""

, "Show confirmation dialog on logout."
: ""

, "Report bugs"
: "バグの報告"

, "Report bugs to the software vendor directly when they occur."
: ""

, "Check version"
: "バージョンを調べる"

, "Check for new versions of this software."
: ""

, "Manage own profile"
: ""

, "The right to manage the own profile (selected contact data)."
: ""

, "Manage own client state"
: ""

, "The right to manage the own client state."
: ""

, "admin"
: "管理者"

, "admin right description"
: "管理者の正しい記述"

, "run"
: "実行"

, "run right description"
: "正しい記述の実行"

, "{0} minute, {0} minutes"
: [
  "{0} 分"

]
, "{0} hour, {0} hours"
: [
  "時間"

]
, "{0} workday, {0} workdays"
: [
  "営業日"

]
, "{0} second, {0} seconds"
: [
  ""

]
, "User: {0}"
: "ユーザ: {0}"

, "About {0}"
: "追加 {0}"

, "Debug Console (Ctrl + F11)"
: ""

, "Preferences"
: "プレファレンス"

, "Edit Profile"
: ""

, "Change password"
: "パスワードの変更"

, "Logout"
: "ログアウト"

, "Logout from {0}"
: "Tine2.0からログアウトする"

, "Allow desktop notifications"
: ""

, "Request permissions for webkit desktop notifications."
: ""

, "Install web app"
: ""

, "Install Tine 2.0 as web app in your browser."
: ""

, "Confirm"
: "確認"

, "Are you sure you want to logout?"
: "ログアウトしますか？"

, "Logging you out..."
: "ログアウトしています..."

, "Please wait!"
: "お待ちください"

, "Profile Information"
: ""

, "Apply"
: "適用"

, "Please Wait"
: "お待ちください"

, "Read"
: "読込"

, "The field is readable part of the profile"
: ""

, "Edit"
: "編集"

, "The field is editable part of the profile"
: ""

, "Field Name"
: ""

, "Searching..."
: "検索しています。"

, "Invalid configuration"
: ""

, "You need to correct the red marked fields before config could be saved"
: ""

, "Transferring Configuration..."
: ""

, "Save config"
: "保存する"

, "Reload config"
: ""

, "Search User"
: "検索"

, "Search Group"
: "検索しています。"

, "Add Anyone"
: "ノートの追加"

, "Anyone"
: "ノート"

, "Search for users ..."
: ""

, "Search for groups ..."
: "検索しています。"

, "Name"
: "名前"

, "setting new timezone..."
: "新しいタイムゾーンを設定しています。"

, "low"
: "低"

, "normal"
: "普通"

, "high"
: "高"

, "urgent"
: "緊急"

, "Add a Note..."
: "ノートの追加"

, "Add"
: "追加"

, "Note"
: "ノート"

, "Add new note"
: "新しいノート"

, "Notes"
: "ノート"

, "Enter new note:"
: "新しいノートの入力："

, "Cancel"
: "キャンセル"

, "Ok"
: "OK"

, "Add Note"
: "ノートの追加"

, "Add a {0} Note"
: " {0} ノートの追加"

, "Type"
: "タイプ"

, "Created By"
: "作成者"

, "Timestamp"
: "時刻"

, "Displaying history records {0} - {1} of {2}"
: "履歴の表示 {0} - {1} 件中 {2}"

, "No history to display"
: "履歴を表示しない"

, "History"
: "履歴"

, "Quick search"
: ""

, "Time"
: "時間"

, "User"
: "ユーザ"

, "My favorites"
: ""

, "Delete Favorite"
: ""

, "Rename Favorite"
: ""

, "Overwrite Favorite"
: ""

, "Do you really want to delete the favorite \"{0}\"?"
: ""

, "Please wait"
: "お待ちください"

, "Deleting Favorite \"{0}\""
: ""

, "New Name"
: ""

, "Please enter the new name for favorite \"{0}\"?"
: ""

, "Renaming Favorite \"{0}\""
: ""

, "Overwrite?"
: ""

, "Do you want to overwrite the favorite \"{0}\"?"
: ""

, "Overwriting Favorite \"{0}\""
: ""

, "Could not save Favorite"
: ""

, "Your current view does not support favorites"
: ""

, "save filter"
: "フィルタの保存"

, "Please enter a name for the favorite"
: ""

, "Favorite not Saved"
: ""

, "You have to supply a name for the favorite!"
: ""

, "You have to supply a shorter name! Names of favorite can only be up to 40 characters long."
: ""

, "Saving favorite"
: ""

, "Favorite, Favorites"
: [
  ""

]
, "Events"
: ""

, "General Preferences"
: ""

, "My Profile"
: ""

, "delete"
: "削除"

, "Saved in"
: "保存する"

, "Copy {0}"
: ""

, "Add New {0}"
: "新しい {0}　を追加する"

, "Edit {0} \"{1}\""
: "編集　{0} \"{1}\""

, "Transferring {0}..."
: ""

, "Errors"
: "エラー"

, "Please fix the errors noted."
: "表示されているエラー項目を修正してくだささい。"

, "Do you really want to delete this {0}?"
: "本当に削除しますか？ {0}?"

, "Deleting {0}"
: "{0}　を削除しています"

, "Failed"
: "失敗"

, "Could not delete {0}."
: " {0}を削除できません"

, "There are no preferences for this application."
: ""

, "Change settings for application {0}"
: ""

, "Defaults"
: ""

, "Username"
: "ユーザ名"

, "Password"
: "パスワード"

, "Please enter your credentials"
: ""

, "Links"
: "ログイン"

, "Files"
: ""

, "Import definition"
: ""

, "Import description"
: ""

, "Import into {0}"
: ""

, "Dry run"
: ""

, "No files added"
: ""

, "You need to add files to import."
: ""

, "Dry run results"
: ""

, "Import test successful for {0} records, import test failed for {1} records."
: ""

, "Import results"
: ""

, "Import successful for {0} records / import failed for {1} records / {2} duplicates found"
: ""

, "Admin Mode"
: ""

, "Applications"
: ""

, "Edit Preferences"
: ""

, "Loading ..."
: ""

, "Saving of preferences failed."
: ""

, "What would you like to do?"
: ""

, "You need to select an option!"
: ""

, "Export, Export"
: [
  ""

]
, "Export {0} {1}"
: ""

, "Export definition"
: ""

, "Select Export Definition ..."
: ""

, "Alarms"
: ""

, "Custom Datetime"
: ""

, "Send Alarm"
: ""

, "None"
: "ノート"

, "0 minutes before"
: "の前"

, "15 minutes before"
: "の前"

, "30 minutes before"
: "の前"

, "1 hour before"
: "の前"

, "2 hours before"
: "の前"

, "1 day before"
: "の前"

, "New version of Tine 2.0 available"
: "Tine 2.0の新バージョンが有効です。"

, "Version \"{0}\" of Tine 2.0 is available."
: "Version \"{0}\" のTine 2.0が利用できます"

, "It's a critical update and must be installed as soon as possible!"
: "緊急アップデートです。早急にインストールしてください。"

, "Please consider updating!"
: "アップデートを考慮してください!"

, "setting new language..."
: "新しい言語を設定しています..."

, "Select a country..."
: ""

, "New {0}"
: "新しい {0}"

, "Please enter the name of the new {0}:"
: "{0}の新しい名前を入力してください:"

, "No {0} added"
: "{0}　は追加されませんでした"

, "You have to supply a {0} name!"
: " {0}　には名前が必要です！"

, "Creating {0}..."
: "{0}を作成しています..."

, "Do you really want to delete the {0} \"{1}\"?"
: "本当に削除しますか {0} \"{1}\"?"

, "Deleting {0} \"{1}\""
: "削除しています{0} \"{1}\""

, "Please enter the new name of the {0}:"
: "{0}の新しい名前を入力してください:"

, "Not renamed {0}"
: "{0}の名前は変更されませんでした"

, "Updating {0} \"{1}\""
: "更新しています{0} \"{1}\""

, "Manage Permissions for {0} \"{1}\""
: "権限を変更します {0} \"{1}\""

, "Add {0}"
: "追加 {0}"

, "Rename {0}"
: "名前の変更　{0}"

, "Set color for {0}"
: ""

, "Manage permissions"
: "権限管理"

, "Reload {0}"
: "名前の変更　{0}"

, "containers"
: ""

, "Favorites"
: ""

, "Save current view as favorite"
: ""

, "No {0} where found. Please try to change your filter-criteria, view-options or the {1} you search in."
: " {0} が見つかりません。フィルターの変更、表示オプションの変更か {1} 再検索をしてください"

, "Edit {0}"
: "編集 {0}"

, "Print Page"
: ""

, "Delete {0}, Delete {0}"
: [
  "削除"

]
, "Displaying records {0} - {1} of {2}"
: "レコードの表示{0} - {1}　件中 {2}"

, "No {0} to display"
: "表示する {0} がありません"

, "Tagging"
: "タグ"

, "Creation Time"
: ""

, "Last Modified Time"
: ""

, "Last Modified By"
: ""

, "Not Allowed"
: "許可されていません"

, "You are not allowed to delete all pages at once"
: "全てのページを一度に削除する権限がありません。"

, "Do you really want to delete the selected record ({0})?, Do you really want to delete the selected records ({0})?"
: [
  ""

]
, " ... This may take a long time!"
: ""

, "show details"
: ""

, "Always show advanced filters"
: ""

, "Your view is limited by {0} criteria:, Your view is limited by {0} criterias:"
: [
  ""

]
, "contains"
: "contains"

, "reg. exp."
: ""

, "is equal to"
: "と等しい"

, "is greater than"
: "より大きい"

, "is less than"
: "より少ない"

, "is not"
: "ではない"

, "one of"
: "ノート"

, "none of"
: ""

, "is before"
: "の前"

, "is after"
: "の後"

, "is within"
: "の中に"

, "is in week no."
: "今週"

, "starts with"
: "から始まる"

, "ends with"
: "で終る"

, "select a operator"
: "オペレータの選択"

, "Search Account ..."
: "検索しています。"

, "today"
: "今日"

, "yesterday"
: "昨日"

, "this week"
: "今週"

, "last week"
: "先週"

, "the week before last"
: "先々週"

, "this month"
: "今月"

, "last month"
: "先月"

, "this quarter"
: "今四半期"

, "last quarter"
: "前四半期"

, "this year"
: "今年"

, "last year"
: "去年"

, "tomorrow"
: "明日"

, "next week"
: "来週"

, "next month"
: "今月"

, "next quarter"
: "来四半期"

, "next year"
: "来年"

, "Upload Failed"
: "アップロードに失敗しました。"

, "Could not upload file. Filesize could be too big. Please notify your Administrator. Max upload size: "
: ""

, "Remove file"
: ""

, "Add file"
: ""

, "name"
: ""

, "size"
: ""

, "type"
: ""

, "Remove record"
: ""

, "Search for records ..."
: ""

, "Show"
: "見る"

, "add new filter"
: "新しいフィルタの追加"

, "reset all filters"
: "全てのフィルタのリセット"

, "start search"
: "検索の開始"

, "save as favorite"
: ""

, "select a field"
: "フィールドの選択"

, "Delete this filter"
: "フィルターの削除"

, "and"
: "かつ"

, "Remove"
: ""

, "Selected  {0}"
: ""

, "is personal of"
: ""

, "Folder"
: "フォルダー"

, "Updating Grants"
: "Grantsのアップデート"

, "Error"
: ""

, "You are not allowed to remove all admins for this container!"
: ""

, "choose other {0}..."
: "他を選択 {0}..."

, "Select a {0}"
: ""

, "Recently used {0}:"
: "最近利用した　{0}:"

, "please select a {0}"
: " {0}　を選択してください"

, "The grant to read records of this container"
: ""

, "The grant to add records to this container"
: ""

, "The grant to edit records in this container"
: ""

, "Delete"
: "削除"

, "The grant to delete records in this container"
: ""

, "The grant to export records from this container"
: ""

, "Sync"
: ""

, "The grant to synchronise records with this container"
: ""

, "Admin"
: "管理者"

, "The grant to administrate this container"
: ""

, "Free Busy"
: ""

, "The grant to access free busy information of events in this calendar"
: ""

, "Private"
: ""

, "The grant to access records marked as private in this container"
: ""

, "container, containers"
: [
  ""

]
, "You are not allowed to select the {0} '{1}':"
: ""

, "{0} grant is required for desired action"
: ""

, "Insufficient Grants"
: ""

, "Tag"
: "タグ"

, "tag name"
: "タグ名"

, "personal"
: "個人用"

, "Tags"
: "タグ"

, "Add a new personal tag"
: "個人用タグの新規追加"

, "Add New Personal Tag"
: "個人用タグの新規追加"

, "Please note: You create a personal tag. Only you can see it!"
: "個人用タグが追加されました。これは貴方だけが閲覧できます。"

, "Enter tag name:"
: "タグ名を入力してください"

, "No Tags to display"
: "タグを表示しない"

, "Detach tag, Detach tags"
: [
  "タグのデタッチ"

]
, "Edit tag"
: "タグの編集"

, "Rename Tag"
: "タグの名称変更"

, "Please enter a new name:"
: "名前を入力してください"

, "Edit Description"
: "備考の編集"

, "Description for tag"
: "タグの説明"

, "Please enter new description:"
: "説明を入力してください"

, "Change Color"
: "色の変更"

, "Delete Tag, Delete Tags"
: [
  "タグの削除"

]
, "Realy Delete Selected Tag?, Realy Delete Selected Tags?"
: [
  "選択したタグを本当に削除しますか？"

]
, "the selected tag will be deleted and disapear for all entries, The selected tags will be removed and disapear for all entries"
: [
  "選択したタグは削除され全てのエントリから見えなくなります"

]
, "Please wait a moment..."
: "しばらくお待ちください"

, "Deleting Tag, Deleting Tags"
: [
  "タグの削除"

]
, "Could not delete Tag(s)."
: "タグを削除できませんでした"

, "Notice"
: "注意"

, "The minimum tag length is three."
: "タグの最小長は３です。"

, "Could not create tag."
: "タグを作成できません"

, "Could not update tag."
: "タグを更新できません"

, "Enter tag name"
: "タグ名を入力してください"

, "Description"
: "説明"

, "Color"
: "Color"

, "Add Tag"
: "追加"

, "Attach the following tag to all selected items:"
: ""

, "Select Tag"
: "タグの削除"

, "Custom Fields"
: "カスタムフィールド"

, "General"
: "普通"

, "There are no custom fields yet"
: "カスタムフィールドがありません"

, "Loading"
: "Loading"

, "Click to edit"
: ""

, "Not An Image"
: "画像なし"

, "Please select an image file (gif/png/jpeg)"
: ""

, "Could not upload image. Please notify your Administrator"
: "画像のアップロードに失敗しました。管理者に連絡してください。"

, "Change Image"
: "イメージの変更"

, "Crop Image"
: "Crop Image"

, "Delete Image"
: "イメージの削除"

, "Show Original Image"
: ""

, "Image Failed"
: "Image Failed"

, "Could not load image. Please notify your Administrator"
: "イメージを読み込めません。管理者に連絡してください。"

, "Software Version"
: "ソフトウェアバージョン"

, "The window you want to work with is backgrounded. Your browser does't support to forground the window for you, so you need to use your operating systems window switching features. Please send complaints to your browser vendor!"
: ""

, "online"
: "オンライン"

, "offline"
: "オフライン"

, "enter searchfilter"
: "サーチフィルタの入力"

, "{0} selected"
: "{0} が選択されています"

, "Unselect all"
: "全て選択しない"

, "Select all visible ({0} records)"
: "表示しているものを全て選択 ({0} 件)"

, "Select all pages ({0} records)"
: "全ページ選択 ({0} 件)"

, "Toggle selection"
: "トグル選択"

, "All {0}"
: "全ての {0}"

, "Shared {0}"
: "共有 {0}"

, "Other Users {0}"
: "他のユーザの{0}"

, "My {0}"
: "マイ {0}"

, "Change Password For \"{0}\""
: "パスワードを変更しました　\"{0}\""

, "Old Password"
: "古いパスワード"

, "New Password"
: "新しいパスワード"

, "Repeat new Password"
: "もう一度パスワードを入力してください"

, "Please Wait!"
: "お待ちください。"

, "changing password..."
: "パスワードを変更しています..."

, "Success"
: "成功しました"

, "Your password has been changed."
: "パスワードは変更されました"

, "Failure"
: "失敗しました"

, "The new passwords mismatch, please correct them."
: "新しいパスワードが一致しません。正しく入力し直してください。"

, "Import, Imports"
: [
  ""

]
, "Credentials, Credentials"
: [
  ""

]
, "Relation, Relations"
: [
  ""

]
, "Department, Departments"
: [
  ""

]
, "Config, Configs"
: [
  ""

]
, "Configs"
: ""

, "Missing Applications"
: ""

, "There are no applications enabled for you. Please contact your administrator."
: "サーバが応答しません。ネットワーク接続を確認し、システム管理者に連絡してください。"

, "Outdent Text"
: ""

, "Indent Text"
: ""

, "Remove Formatting"
: ""

, "Login"
: "ログイン"

, "Tine 2.0 is made for you"
: ""

, "Tine 2.0 wants to make business collaboration easier and more enjoyable - for your needs! So you are warmly welcome to discuss with us, bring in ideas and get help."
: ""

, "Tine 2.0 Homepage"
: ""

, "Tine 2.0 Forum"
: ""

, "about {0} minutes"
: ""

, "Tine 2.0 needs your help"
: ""

, "We regularly need your feedback to make the next Tine 2.0 releases fit your needs even better. Help us and yourself by participating:"
: ""

, "participate!"
: ""

, "Languages"
: ""

, "Duration"
: ""

, "Browser incompatible"
: ""

, "Your browser is not supported by Tine 2.0."
: ""

, "Browser incompatible?"
: ""

, "You are using an unrecognized browser. This could result in unexpected behaviour."
: ""

, "You might try one of these browsers:"
: ""

, "Logging you in..."
: "ログインしています..."

, "Login successful. Loading {0}..."
: "ログイン成功.Tine 2.0をロードしています..."

, "Login failure"
: "ログインに失敗しました"

, "Your username and/or your password are wrong!!!"
: "ユーザ名またはパスワードが違います"

, "Please enter your login data"
: "ログイン情報を入力してください。"

, "Your session timed out. You need to login again."
: "セッションタイムアウトしました。再ログインしてください。"

, "Insufficient Rights"
: "不十分な権利"

, "Sorry, you are not permitted to perform this action"
: "この操作をする権限がありません。"

, "Not Found"
: "許可されていません"

, "Sorry, your request could not be completed because the required data could not be found. In most cases this means that someone already deleted the data. Please refresh your current view."
: ""

, "Concurrent Updates"
: "アップデートの発生"

, "Someone else saved this record while you where editing the data. You need to reload and make your changes again."
: "レコード編集中に誰かが同じレコードを編集したようです。画面を再ロードしてもう一度編集しなおしてください。"

, "Service Unavailable"
: ""

, "The server is currently unable to handle the request due to a temporary overloading or maintenance of the server. Please try again or contact your administrator."
: ""

, "Connection lost, please check your network!"
: "コネクションに失敗しました。ネットワーク接続を確認してください。"

, "Timeout"
: ""

, "Sorry, some timeout occured while processing your request. Please reload your browser, try again or contact your administrator."
: ""

, "No Response"
: ""

, "Sorry, the Server did not respond any data. Please reload your browser, try again or contact your administrator."
: ""

, "Out of Resources"
: ""

, "Sorry, the Server stated a \"memory exhausted\" condition. Please contact your administrator."
: ""

, "No Role Memberships"
: ""

, "Your user account has no role memberships. Please contact your administrator."
: ""

, "Registration Wizard"
: "登録ウィザード"

, "Given name"
: "名"

, "Family name"
: "姓"

, "Login name"
: "ログイン名"

, "Emailaddress"
: "Emailアドレス"

, "Congratulations!"
: "おめでとうございます！"

, "You have entered all needed information. If you press the Finish button we will send you the registration email."
: "全ての必要情報を入力してください。Finishボタンを押すと登録情報を電子メールで送付します。"

, "Your password expired. Please enter a new user password:"
: ""

, "Send Report"
: "レポートの送付"

, "The last action you made was potentially not performed correctly."
: "あなたの最後の動作は正しく実行されなかった可能性があります"

, "Please help improving this software and notify the vendor. Include a brief description of what you where doing when the error occurred."
: ""

, "Send Contact Information"
: ""

, "Details:"
: "詳細の表示:"

, "Sending report..."
: "レポートの送付中..."

, "Please wait a moment"
: "しばらくお待ちください"

, "Transmission Completed"
: "転送の完了"

, "Your report has been sent. Thanks for your contribution"
: "レポートは送信されました。ご協力ありがとうございます。"

, "Please restart your browser now!"
: "ログイン情報を入力してください。"

, "Fatal Error: Client self-update failed, please contact your administrator and/or restart/reload your browser."
: ""

, "Task, Tasks"
: [
  "タスク"

]
, "to do list, to do lists"
: [
  "ＴｏＤｏリスト"

]
, "Created by"
: "作成者"

, "Activities"
: "アクティビティ"

, "Data"
: ""

, "Tine 2.0 needs to be updated or is not installed yet."
: ""

, "Please wait or contact your administrator"
: ""

, "by"
: "の"

, "Changed fields:"
: "変更されたフィールド:"



































})); 
