<?php
/**
 * 定义模板相关函数
 */
load('ydLib');
function get_slide($selector, $autoPage, $titCell, $mainCell, $autoPlay, $interTime, $delayTime, $defaultIndex, 
		$trigger, $scroll, $vis, $prevCell, $nextCell, $titOnClassName, $effect){
	$defaultIndex =   !empty($defaultIndex) ?  "defaultIndex:".$defaultIndex."," : '';
	$data = "<script type='text/javascript'>
		$(document).ready(function(){
			$('$selector').slide({
				$autoPage $titCell $mainCell $autoPlay $interTime $delayTime $defaultIndex $trigger $scroll $vis $prevCell $nextCell $titOnClassName $effect
			});
		})
	</script>";
	return $data;
}

//获取顶层菜单
//$menuOwner:  0：会员，1:管理员
//$groupid: 0:表示不受分组权限的限制
function get_menu_top($menuOwner = 0){
	$m = D('Admin/MenuTop');
	$data = $m->getMenuTop( array('MenuOwner'=>$menuOwner) );
	return $data;
}

function get_menu_group($MenuTopID = 0){
	$m = D('Admin/MenuGroup');
	$data = $m->getMenuGroup( $MenuTopID, 1);
	return $data;
}

function get_menu($menuGroupID = 0){
	$m = D('Admin/Menu');
	$data = $m->getMenu( $menuGroupID, 1);
	return $data;
}

function get_menu_operation(){
	$m = D('Admin/MenuOperation');
	$data = $m->getMenuOperationPath( ACTION_NAME, MODULE_NAME, GROUP_NAME);
	return $data;
}

//频道信息
function get_channel($parentID = 0, $depth=1, $prefix='', $idlist=false){
	$channel = D('Admin/Channel');
	$data = $channel->getChannelList($parentID, $depth, $prefix, $idlist);
	$count = count( $data );
	if( empty($data) ) return false;  //当$data为false时，count($data)返回1，因此必选先判断$data是否为空
	//找出ChannelDepth最大值
	$maxDepth = -9999;
	for($j = 0; $j < $count; $j++){
		if( $data[$j]['ChannelDepth'] > $maxDepth ) {
			$maxDepth = $data[$j]['ChannelDepth'];
		}
	}
	
	for($i = 0; $i < $count; $i++){
		if( 33 == $data[$i]['ChannelModelID'] && trim($data[$i]['LinkUrl']) != '' ){ //33:转向链接
			if( GROUP_NAME == 'Wap' && 'http' != strtolower( substr($data[$i]['LinkUrl'], 0, 4))){
				//站内链接手机站，如：1.html ,自动加上全路径
				$data[$i]['ChannelUrl'] = WapHomeUrl().'/'.ltrim($data[$i]['LinkUrl'],'/');
			}else{
				$data[$i]['ChannelUrl'] = $data[$i]['LinkUrl'];
			}
		}else{
			$data[$i]['ChannelUrl'] = ChannelUrl($data[$i]['ChannelID'], $data[$i]['Html'], '');
		}
		$data[$i]['ChannelDepth'] = ($maxDepth - $data[$i]['ChannelDepth'] + 1);
		$data[$i]['Count'] = $count;
		//$data[$i]['HasChild'] = $channel->hasChildChannel($data[$i]['ChannelID']) ? 1 : 0;
	}
	return $data;
}

//专题信息
function get_special($ChannelID = 0, $idlist=-1){
	$m = D('Admin/Special');
	$p = array('IsEnable'=>1, 'idlist'=>$idlist, 'ChannelID'=>$ChannelID);
	$data = $m->getSpecial($p);
	if( empty($data) ) return false; 
	return $data;
}

//频道信息
function get_navigation($parentID = 0, $depth=1, $idlist=-1, $isshow=1, $channelmodelid=-1, $LanguageID=-1, $Field=''){
	if( !is_numeric($parentID) ) return false;
	if(empty($idlist)) $idlist = -1; //$idlist为空，可能传入false或''
	if(empty($channelmodelid)) $channelmodelid = -1;
	if(empty($Field)) $Field = '';
	$key = md5($parentID.$depth.$idlist.$isshow.$channelmodelid.$LanguageID.$Field);
	static $_cache = array();
	if (isset($_cache[$key])){
		return $_cache[$key];
	}
	$channel = D('Admin/Channel');
	$data = $channel->getNavigation($parentID, $depth, $idlist, $isshow,$channelmodelid, $LanguageID, $Field);
	if( empty($data) ) return false;  //当$data为false时，count($data)返回1，因此必选先判断$data是否为空
	$count = count( $data );
	
	//找出ChannelDepth最大值，归一化ChannelDepth，从0开始
	$maxDepth = -9999;
	for($j = 0; $j < $count; $j++){
		if( $data[$j]['ChannelDepth'] > $maxDepth ) {
			$maxDepth = $data[$j]['ChannelDepth'];
		}
	}

	for($i = 0; $i < $count; $i++){
		if( 33 == $data[$i]['ChannelModelID'] && trim($data[$i]['LinkUrl']) != ''){ //33:转向链接
			if( GROUP_NAME == 'Wap' && 'http' != strtolower( substr($data[$i]['LinkUrl'], 0, 4))){
				//站内链接手机站，如：1.html ,自动加上全路径
				$data[$i]['ChannelUrl'] = WapHomeUrl().'/'.ltrim($data[$i]['LinkUrl'],'/');
			}else{
				$data[$i]['ChannelUrl'] = $data[$i]['LinkUrl'];
			}
		}else{
			$data[$i]['ChannelUrl'] = ChannelUrl($data[$i]['ChannelID'], $data[$i]['Html'], '');
		}
		$data[$i]['ChannelDepth'] = ($maxDepth - $data[$i]['ChannelDepth'] + 1);
		$data[$i]['Count'] = $count;
		ChannelName($data[$i]['ChannelID'], $data[$i]['ChannelName']); //缓存频道名称
	}
	$_cache[$key] = $data;
	return $data;
}

//微信应用列表
function get_wx_app(){
	$m = D('Admin/WxApp');
	$App = $m->getApp(-1, -1, -1, '', 1);
	$n = count($App);
	
	for($i=0; $i < $n; $i++){
		switch($App[$i]['AppTypeID']){
			case 1: //微活动
				$type = substr($App[$i]['AppParameter'], 0, 1);
				$App[$i]['Keyword'] = ($type==0) ? '大转盘' : '刮刮卡';
				break;
			case 2:  //微投票
				$App[$i]['Keyword'] = '投票';
				break;
			case 5:  //微调查
				$App[$i]['Keyword'] = '调查';
				break;
			default:
				break;
		}
	}
	
	$wa= D('Admin/WxApptype');
	$type = $wa->getAppType(1);
	foreach($type as $k=>$v){
		$t[ $v['AppTypeID'] ] = $v['AppTypeName'];
	}
	
	$applist = include CONF_PATH.'wxapp.php';  //加载微信配置文件
	foreach ($applist as $k=>$v){
		$App[] = array(
				"AppID"=>$k, 
				'AppName'=>$v['name'], 
				'Keyword'=>$k, 
				'Description'=>$v['description'],
				'AppTypeName'=>$t[ $v['type'] ],
		);
	}
	return $App;
}

//网站地图
function get_sitemap($ChannelID = 0, $depth=-1, $prefix='&nbsp;&nbsp;'){
	return get_navigation($ChannelID, $depth);
}

//友情链接
function get_link($linkClassID = 0, $top = 10){
	$m = D('Admin/Link');
	$data = $m->getLink(0, $top, $linkClassID, 1);
	return $data;
}

//有利于自定义表单
function get_banner_list($BannerGroupID = -1){
	$m = D('Admin/Banner');
	$data = $m->getBanner(1, $BannerGroupID);
	return $data;
}

function get_bannergroup(){
	$m = D('Admin/BannerGroup');
	$data = $m->getBannerGroup();
	return $data;
}

//人才招聘
function get_job($top = 10, $nowPage = 0){
	$m = D('Admin/Job');
	if( $nowPage != 0 ){//分页, $labelID和$top无效, 获取指定分页数据
		$t = array('cn'=>8, 'en'=>4);
		$PageSize = PageSize( $t[LANG_SET] ); //页面大小
		$PageSize = ($PageSize > 0) ? $PageSize : 20;
		$nowPage = ( $nowPage - 1 > 0 ) ? ( $nowPage - 1 ) : 0;
		$offset = $nowPage * $PageSize;
		$data = $m->getJob($offset, $PageSize, 1);
	}else{ //不分页
		$data = $m->getJob(0, $top, 1);
	}
	return $data;
}

//广告
function get_ad($adid, $id, $width, $height, $delay=10, $step=1, $left='8px', $right='8px', $top='260px'){
	$m = D('Admin/Ad');
	$data = $m->where("IsEnable=1 and AdID=$adid")->find();
	
	$AdTypeID = $data['AdTypeID'];
	$des = $data['AdName']."[".$data['AdTime']."]&#13".$data['AdDescription'];
	$adUrl = $data['AdUrl'];
	$adContent = $data['AdContent'];
	$adName = $data['AdName'];
	
	$parseStr = "";
	switch($AdTypeID){
		case 1:   //图片广告
			$parseStr = "<!--图片广告start-->";
			if(empty($adUrl)){
				$parseStr .= "<img $width $height  src='$adContent' border='0' alt='$des' title='$des' />";
			}else{
				$parseStr .= "<a id='$id' href='$adUrl' target='_blank'><img $width $height  src='$adContent' border='0' alt='$des' title='$des' /></a>";
			}
			$parseStr .= "<!--图片广告end-->";
			break;
		case 2:   //Flash广告
			$parseStr .=  "<!--Flash广告start-->\n";
			$parseStr .= "<embed $width $height src=\"".$data['AdContent']."\" ";
			$parseStr .= " quality=\"high\" type=\"application/x-shockwave-flash\" wmode=\"transparent\"  ";
			$parseStr .= " pluginspage=\"http://www.macromedia.com/go/getflashplayer\" allowScriptAccess=\"always\">";
			$parseStr .= "</embed>";
			$parseStr .=  "\n<!--Flash广告start-->";
			break;
		case 3:   //漂浮广告
			$width    = !empty($width)   ? "'imgHeight':".$width."," : '';
			$height   = !empty($height) ? "'imgWidth':".$height."," : '';
			$closefloatad = __ROOT__."/Public/Images/closefloatad.png";
			$parseStr .= "
			<!--漂浮广告start-->
			<script type='text/javascript'>
				$(function(){
					$.floatingAd({
						delay: $delay,
						isLinkClosed: false,
						ad:	[{
							headFilter: 0.1,
							'img': '$adContent',
							$width
							$height
							'linkUrl': '$adUrl',
							'z-index': 100,
							'title': '$adName',
							'closed-icon': '$closefloatad'
						}]
					});
				});
			</script>
			<!--漂浮广告end-->";
			break;
		case 4:   //代码广告
			$parseStr = "<!--代码广告start-->\n".$data['AdContent']."\n<!--代码广告end-->";
			break;
		case 5: //对联广告
			$top1 = str_ireplace('px', '', $top);
			
			$duilianImg = $data['AdContent'];
			$duilianImg = str_replace(array("\r\n","\r"), "\n", $duilianImg);
			$duilianImg = (array)explode ("\n", $duilianImg);
			
			$duilianImg1 = $duilianImg[0];
			$duilianImg2 = !empty($duilianImg[1]) ? $duilianImg[1] : $duilianImg[0];

			$duilianUrl = (array)explode(',', $data['AdUrl']);
			$duilianUrl1 = $duilianUrl[0];
			$duilianUrl2 = !empty($duilianUrl[1]) ? $duilianUrl[1] : $duilianUrl[0];

			$adclose = __ROOT__."/Public/Images/adclose.gif";
			$parseStr = "<!--对联广告start-->
			<style>
			.duilian$id{top:$top; position:absolute; display:none;}
			.duilianclose$id{ cursor:pointer; }
			</style>
			<div class='duilian$id' style='left:$left;'>
			<div><a href='$duilianUrl1' target='_blank'><img src='$duilianImg1' $width $height  alt='$des' title='$des'></a></div>
			<img  class='duilianclose$id' src='$adclose' $width  height='14px'>
			</div>
			<div class='duilian$id'  style='right:$right;'>
			<div><a  href='$duilianUrl2'  target='_blank'><img src='$duilianImg2' $width $height  alt='$des' title='$des'></a></div>
			<img class='duilianclose$id' src='$adclose' $width  height='14px'>
			</div>
			<script type='text/javascript'>
			$(document).ready(function(){
				var duilian = $('div.duilian$id');
				var window_w = $(window).width();
				if( window_w > 1000 ){ duilian.show(); }
				$(window).scroll(function(){
				var scrollTop = $(window).scrollTop();
				duilian.stop().animate({top:scrollTop+$top1}, 800);
			});
			$('img.duilianclose$id').click(function(){
				$(this).parent().hide();
				return false;
			});
			});
			</script>
			<!--对联广告end-->";
			break;
		}
		return $parseStr;
}

function AdCount($adGroupID){
	$m = D('Admin/Ad');
	$n = $m->getAdCount($adGroupID);
	return $n;
}

function get_ad_list($groupID = -1){
	$m = D('Admin/Ad');
	$p['IsEnable'] = 1;
	if( $groupID != -1){
		$p['AdGroupID'] = $groupID;
	}
	$data = $m->getAd(-1, -1, $p);
	return $data;
}

function get_area($parent = -1){
	$m = D('Admin/Area');
	$data = $m->getArea($parent,1);
	return $data;
}

function get_adgroup(){
	$m = D('Admin/AdGroup');
	$p['IsEnable'] = 1;
	$data = $m->getAdGroup($p);
	return $data;
}

//在线客服列表
function get_support($qqstyle='41'){
	$m = D('Admin/Support');
	$data = $m->getSupport(1);
	$n = count($data);
	for($i = 0; $i < $n; $i++){
		switch( $data[$i]['SupportTypeID']){
			case 2://淘宝旺旺
				$data[$i]['SupportFace'] = yd_taobao_face($data[$i]['SupportNumber']);
				break;
			case 3://阿里旺旺
				$data[$i]['SupportFace'] = yd_ali_face($data[$i] ['SupportNumber'] );
				break;
			case 4 : // 微软MSN
				$data [$i] ['SupportFace'] = yd_msn_face ( $data [$i] ['SupportNumber'] );
				break;
			case 5 : // Skype
				$data [$i] ['SupportFace'] = yd_skype_face ( $data [$i] ['SupportNumber'] );
				break;
			case 6://国际版阿里旺旺
				$data[$i]['SupportFace'] = yd_interali_face($data[$i] ['SupportNumber'] );
				break;
			case 7: //自定义
				$data[$i]['SupportFace'] = $data[$i]['SupportNumber'];
				break;
			case 1 : // qq
			default :
				$data [$i] ['SupportFace'] = yd_qq_face ( $data [$i] ['SupportNumber'], $qqstyle );
				break;
		}
	}
	return $data;
}

//获取标签数据
function get_label($channelmodelid){
	$m = D('Admin/Label');
	$data = $m->getLabel($channelmodelid,-1,1);
	return $data;
}

//获取表单字段列表
function get_form($channelmodelid){
	$m = D('Admin/Attribute');
	$group = $m->getGroup($channelmodelid);
	$Attribute = $m->getAttribute($channelmodelid);
	foreach($group as $g){
		foreach ($Attribute as $a){
			if( $a['GroupID'] == $g['AttributeID'] ){
				$data[] = $a;
			}
		}
	}
	unset($group, $Attribute);
	return $data;
}

//主要用于前台模型调用，获取模型字段列表
function get_model($channelmodelid, $idlist=-1){
	$index = array('en'=>1, 'cn'=>0);
	$id = $index[ get_language_mark() ];
	$m = D('Admin/Attribute');
	$group = $m->getGroup($channelmodelid);
	$Attribute = $m->getAttribute($channelmodelid, false, 1, -1, $idlist);
	$n = 0;
	foreach($group as $g){
		foreach ($Attribute as $a){
			if( $a['GroupID'] == $g['AttributeID'] ){
				$DisplayName = explode(',', $a['DisplayName']);
				$a['DisplayName'] = isset($DisplayName[$id]) ? $DisplayName[$id] : $DisplayName[0];
				$data[$n] = $a;
				
				if( stripos($a['DisplayType'], 'radio') !== false ){
					$Selected = "checked='checked'";
				}else if(stripos($a['DisplayType'], 'checkbox') !== false ){
					$Selected = "checked='checked'";
				}else if(stripos($a['DisplayType'], 'select') !== false ){
					$Selected = "selected='selected'";
				}
				//获取具体项目
				if(stripos($a['DisplayType'], 'radio') !== false 
						|| stripos($a['DisplayType'], 'checkbox') !== false 
						||  stripos($a['DisplayType'], 'select') !== false){
					$defaultValue = str_replace(array("\r\n","\r"), "\n", $a['DisplayValue']);
					$item = explode("\n", $defaultValue);
					for($j = 0; $j < count($item); $j++){
						$itemString = explode(',', $item[$j]);
						$itemString = isset($itemString[$id]) ? $itemString[$id] : $itemString[0];
						$t = explode ('|', $itemString ); //value|item|是否是默认
						$sel=empty($t[2]) ? '' : $Selected;
						$data[$n]['Item'][$j] = array('Value'=> $t[0], 'Text'=>$t[1], 'Selected'=>$sel);
					}
				}
				$n++;
			}
		}
	}
	unset($group, $Attribute);
	return $data;
}

//获取订阅邮件分类
function get_mail_class(){
	$m = D('Admin/MailClass');
	$data = $m->getMailClass(1);
	return $data;
}

//获取友情链接分类
function get_link_class(){
	$m = D('Admin/LinkClass');
	$data = $m->getLinkClass();
	return $data;
}

function get_videopalyer($data){
	import("@.Common.YdVideoPlayer");
	$v = new YdVideoPlayer( $data );
	$html = $v->render();
	return $html;
}

//banner
function get_banner($width, $height, $time, $showtext, $textcolor, $textbgcolor,$textbgalpha,$bartextcolor,$barovercolor,$baroutcolor,$channelid,$groupid=-1,$top=-1,$labelid=-1){
	$files = '';  $links = ''; $texts = '';
	if(empty($channelid) ){
		$m = D('Admin/Banner');
		$data = $m->getBanner(1 , $groupid);
		$count = count($data);
		if( $count <= 0 ) return '';
		if( $count == 1 ) return get_one_banner($data [0]['BannerImage'], $data [0]['BannerUrl'] ,$data [0]['BannerName'], $width, $height);
		for($i = 0; $i < $count; $i++){
			$files .= '|'.$data[$i]['BannerImage'];
			$links .= '|'.$data[$i]['BannerUrl'];
			$texts .= '|'.$data[$i]['BannerName'];
		}
	}else{
		$m = D('Admin/Info');
		$data = $m->getInfoImage($channelid, $top, $labelid);
		$count = count($data);
		if( $count <= 0 ) return '';
		if( $count == 1 ) return get_one_banner($data[0]['InfoPicture'], InfoUrl( $data [0]['InfoID'] ),$data [0]['InfoTitle'], $width, $height);
		for($i = 0; $i < $count; $i++){
			$files .= '|'.$data[$i]['InfoPicture'];
			$links .= '|'.InfoUrl($data[$i]['InfoID']);
			$texts .= '|'. $data[$i]['InfoTitle'];
		}
	}
	
	$files = substr($files, 1);
	$links = substr($links, 1);
	$texts = ($showtext==1) ? substr($texts, 1) : ''; //控制是否显示标题
	
	$effectFile = __ROOT__.'/Public/effect/normal.swf';
	
	//-- config:参数 自动播放时间(秒)|文字颜色|文字背景色|文字背景透明度|按键数字颜色|当前按键颜色|普
	$parseStr = "<script type=\"text/javascript\">
	var swf_width = '$width';
	var swf_height = '$height';
	var config = '$time|$textcolor|$textbgcolor|$textbgalpha|$bartextcolor|$barovercolor|$baroutcolor';
	var files = '$files';
	var links = '$links';
	var texts = '$texts';
	
	document.write('<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0\" width=\"'+ swf_width +'\" height=\"'+ swf_height +'\">');
	document.write('<param name=\"movie\" value=\"$effectFile\" />');
	document.write('<param name=\"quality\" value=\"high\" />');
	document.write('<param name=\"menu\" value=\"false\" />');
	document.write('<param name=wmode value=\"opaque\" />');
	document.write('<param name=\"FlashVars\" value=\"config='+config+'&bcastr_flie='+files+'&bcastr_link='+links+'&bcastr_title='+texts+'\" />');
	document.write('<embed src=\"$effectFile\" wmode=\"opaque\" FlashVars=\"config='+config+'&bcastr_flie='+files+'&bcastr_link='+links+'&bcastr_title='+texts+'& menu=\"false\" quality=\"high\" width=\"'+ swf_width +'\" height=\"'+ swf_height +'\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />');
	document.write('</object>');
	</script>";
	return $parseStr;
}

//输出banner1，存在Bug，如仅支持jpg，偶尔图片显示空白
function get_banner1($width, $height, $time, $showtext, $channelid,$groupid=-1,$top=-1,$labelid=-1) {
	$files = $links = $texts = '';
	if (empty ( $channelid )) {
		$m = D ( 'Admin/Banner' );
		$data = $m->getBanner ( 1 , $groupid);
		$count = count ( $data );
		if( $count <= 0 ) return '';
		if( $count == 1 ) return get_one_banner($data [0]['BannerImage'], $data [0]['BannerUrl'] ,$data [0]['BannerName'],$width, $height);
		for($i = 0; $i < $count; $i ++) {
			$files .= '|' . $data [$i]['BannerImage'];
			$links .= '|' . $data [$i]['BannerUrl'];
			$texts .= '|' . $data [$i]['BannerName'];
		}
	} else { // 取频道图片
		$m = D ( 'Admin/Info' );
		$data = $m->getInfoImage ( $channelid , $top, $labelid);
		$count = count ( $data );
		if( $count <= 0 ) return '';
		if( $count == 1 ) return get_one_banner($data[0]['InfoPicture'], InfoUrl( $data [0]['InfoID'] ),$data [0]['InfoTitle'],$width, $height);
		for($i = 0; $i < $count; $i ++) {
			$files .= '|' . $data [$i] ['InfoPicture'];
			$links .= '|' . InfoUrl ( $data [$i] ['InfoID'] );
			$texts .= '|' . $data [$i] ['InfoTitle'];
		}
	}
	
	$files = substr ( $files, 1 );
	$links = substr ( $links, 1 );
	$texts = substr ( $texts, 1 );
	$effectFile = __ROOT__ . '/Public/effect/slide.swf';
	
	// -- config:参数 自动播放时间(秒)|文字颜色|文字背景色|文字背景透明度|按键数字颜色|当前按键颜色|普
	$parseStr = "<script type='text/javascript'>
	var interval_time=$time;
	var focus_width='$width';
	var focus_height='$height';
	var text_height = $showtext;
	var text_align= 'center';
	var swf_height = parseInt(focus_height)+parseInt(text_height);
	
	var pics= '$files'
	var links='$links'
	var texts='$texts'
		
	document.write('<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"'+ focus_width +'\" height=\"'+ swf_height +'\">');
	document.write('<param name=\"movie\" value=\"$effectFile\"><param name=\"quality\" value=\"high\"><param name=\"bgcolor\" value=\"#ffffff\">');
	document.write('<param name=\"menu\" value=\"false\"><param name=wmode value=\"transparent\">');
	document.write('<param name=\"FlashVars\" value=\"pics='+pics+'&links='+links+'&texts='+texts+'&borderwidth='+focus_width+'&borderheight='+focus_height+'&textheight='+text_height+'&text_align='+text_align+'&interval_time='+interval_time+'\">');
	document.write('<embed src=\"$effectFile\" wmode=\"opaque\" FlashVars=\"pics='+pics+'&links='+links+'&texts='+texts+'&borderwidth='+focus_width+'&borderheight='+focus_height+'&textheight='+text_height+'&text_align='+text_align+'&interval_time='+interval_time+'\" menu=\"false\" bgcolor=\"#ffffff\"  quality=\"high\" width=\"'+ focus_width +'\" height=\"'+ swf_height +'\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />');
	document.write('</object>');
	</script>";
	return $parseStr;
}
// banner2
function get_banner2($width, $height, $time, $showtext, $channelid,$groupid=-1,$top=-1,$labelid=-1) {
	return get_banner1 ( $width, $height, $time, $showtext, $channelid  , $groupid, $top, $labelid);
}
// banner3
function get_banner3($width, $height, $time, $showtext, $channelid,$groupid=-1,$top=-1,$labelid=-1) {
	// symbol: linear（直线）和circular（圆形，译注：类似倒计时，顺时针）。
	$xml = "<?xml version='1.0' encoding='utf-8' ?>
	<cu3er>
	<settings>
	<auto_play>
	<defaults symbol='circular' time='$time' /><!--倒计时按钮的位置-->
	<tweenIn width='30' height='30' tint='0xFF0000' alpha='0.5'/>
	<tweenOver alpha='1'/>
	</auto_play>
	<prev_button>
	<defaults round_corners='5,5,5,5'/>
	<tweenOver tint='0xFFFFFF' scaleX='1.1' scaleY='1.1'/>
	<tweenOut tint='0x000000' />
	</prev_button>
	<prev_symbol>
	<tweenOver tint='0x000000' />
	</prev_symbol>
	<next_button>
	<defaults round_corners='5,5,5,5'/>
	<tweenOver tint='0xFFFFFF'  scaleX='1.1' scaleY='1.1'/>
	<tweenOut tint='0x000000' />
	</next_button>
	<next_symbol>
	<tweenOver tint='0x000000' />
	</next_symbol>
	</settings>
	<slides>";
	
	//num – 每次变换包含的切片数 slicing – 立方体切片方向：水平horizontal或垂直vertical
	// direction - 变换方向 / 立方体旋转方向：上up、下、左、右
	//shader – transition shading type – none, flat, phong
	//<transition num="4" direction="right" shader="flat" />
	//$transition[] = "<transition num='4' slicing='vertical' direction='down' />";
	$transition = array(0=>'<transition num="3" slicing="vertical" direction="down"/>',
	    1=>'<transition num="4" direction="right" shader="flat" />',
	    2=>'<transition num="6" slicing="vertical" direction="up" shader="phong" delay="0.05" z_multiplier="4" />',
	    3=>'',
	);
	$n = count($transition)-1;
	if(empty($channelid) ){
		$m = D('Admin/Banner');
		$data = $m->getBanner(1 , $groupid);
		$count = count($data);
		if( $count <= 0 ) return '';
		if( $count == 1 ) return get_one_banner($data [0]['BannerImage'], $data [0]['BannerUrl'] ,$data [0]['BannerName'], $width, $height);
		for($i = 0; $i < $count; $i++){
			$title = trim($data[$i]['BannerName']);
			$img = $data[$i]['BannerImage'];
			$url = $data[$i]['BannerUrl'];
			$xml .= "\n<slide><url>$img</url>";
			if( $showtext && $title !='' ){
			    $xml .= "\n<description>\n<link target='_blank'>$url</link>\n<heading>$title</heading>\n<paragraph></paragraph>\n</description>";
			}else{
			    $xml .= "\n<link target='_blank'>$url</link>";
			}
			$tr = ($i != $count - 1) ? $transition[$i % $n] : '';
			$xml .= "\n</slide>\n$tr";
		}
	}else{ //取频道图片
			$m = D('Admin/Info');
			$data = $m->getInfoImage($channelid, $top, $labelid);
			$count = count($data);
			if( $count <= 0 ) return '';
			if( $count == 1 ) return get_one_banner($data[0]['InfoPicture'], InfoUrl( $data [0]['InfoID'] ),$data [0]['InfoTitle'], $width, $height);
			for($i = 0; $i < $count; $i++){
				$title = $data[$i]['InfoTitle'];
				$para = $data[$i]['InfoSContent'];
				$img = $data[$i]['InfoPicture'];
				$url = InfoUrl($data[$i]['InfoID']);
				$xml .= "\n<slide><url>$img</url>";
				if( $showtext && $title !='' ){
				$xml .= "\n<description>\n<link target='_blank'>$url</link>\n<heading>$title</heading>\n<paragraph>$para</paragraph>\n</description>";
				}else{
				$xml .= "\n<link target='_blank'>$url</link>";
				}
				$tr = ($i != $count - 1) ? $transition[$i % $n] : '';
				$xml .= "\n</slide>\n$tr";
		  }
	}
	$xml .= "\n</slides>\n</cu3er>";
	$fileName = RUNTIME_PATH.'data/banner3.xml';
	$b = file_put_contents($fileName, $xml);
	if( !b ) return false;
	$effectFile = __ROOT__.'/Public/effect/cu3er.swf';
	
	$parseStr = "<script type='text/javascript'>
	var swf_width='$width';
	var swf_height = '$height';
	var xml = '$fileName';
	document.write('<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"'+ swf_width +'\" height=\"'+ swf_height +'\">');
	document.write('<param name=\"movie\" value=\"$effectFile\"><param name=\"quality\" value=\"high\"><param name=\"bgcolor\" value=\"#ffffff\">');
	document.write('<param name=\"menu\" value=\"false\"><param name=wmode value=\"transparent\">');
	document.write('<param name=\"FlashVars\" value=\"xml='+xml+'\">');
	document.write('<embed src=\"$effectFile\" wmode=\"opaque\" FlashVars=\"xml='+xml+'\" menu=\"false\" bgcolor=\"#ffffff\"  quality=\"high\" width=\"'+ swf_width +'\" height=\"'+ swf_height +'\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />');
	document.write('</object>');
	</script>";
	return $parseStr;
}
//输出单个媒体文件支持：图像，swf
//$url仅对图像格式文件有效
function get_one_banner($image, $url, $title, $width, $height){
	$ext = strtolower( yd_file_ext($image) );
	$str = '';
	if( empty($ext) ) return $str;
	if($ext == 'swf'){ //flash动画
		$str = "
		<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"$width\" height=\"$height\">
		<param name=\"movie\" value=\"$image\">
		<param name=\"quality\" value=\"high\">
		<param name=\"bgcolor\" value=\"#ffffff\">
		<param name=\"menu\" value=\"false\">
		<param name=wmode value=\"transparent\">
		<embed src=\"$image\" wmode=\"opaque\"  menu=\"false\" bgcolor=\"#ffffff\"  quality=\"high\" width=\"$width\" height=\"$height\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />
		</object>";
	}else{ //图像
		//$width .= 'px'; $height .= 'px';  //必须加上px image的宽度或高度才生效
		//经测试不加px，正常
		if( is_numeric($width) ) $width .= 'px';
		if( is_numeric($height) ) $height .= 'px';
		if( empty($url) ){
			$str = "<img src='$image' alt='$title'  style=\"width:$width;height:$height\"  />";
		}else {
			$str = "<a href='$url' target='_blank'><img src='$image' alt='$title'    style='width:$width;height:$height;border:0px'  /></a>";
		}
	}
	return $str;
}

//客户留言
function get_guestbook($top = 10, $nowPage = 0){
	$m = D('Admin/Guestbook');
	if( $nowPage != 0 ){//分页, $labelID和$top无效, 获取指定分页数据
		$t = array('cn'=>9, 'en'=>5);
		$PageSize = PageSize( $t[LANG_SET] ); //页面大小
		$PageSize = ($PageSize > 0) ? $PageSize : 20;
		$nowPage = ( $nowPage - 1 > 0 ) ? ( $nowPage - 1 ) : 0;
		$offset = $nowPage * $PageSize;
		$data = $m->getMessage($offset, $PageSize, 1);
	}else{ //不分页
		$data = $m->getMessage(0, $top, 1);
	}
	return $data;
}

//获取评论信息
function get_comment($infoid, $nowPage = 0){
	$m = D('Admin/Comment');
    $params['InfoID'] =$infoid;
	if( $nowPage != 0 ){
		$PageSize = $GLOBALS['Config']['COMMENT_PAGE_SIZE']; //页面大小
		$PageSize = ($PageSize > 0) ? $PageSize : 20;
		$nowPage = ( $nowPage - 1 > 0 ) ? ( $nowPage - 1 ) : 0;
		$offset = $nowPage * $PageSize;
		$data = $m->getComment($offset, $PageSize, $params);  //-1:所有人的评论，1: 审核通过的
	}else{ //不分页
		$data = $m->getComment(-1, -1, $params);
	}
	return $data;
}

//投票调查
function get_vote_list($id){
	$m = D('Admin/WxApp');
	$data = $m->findTagVote($id);
	return $data;
}

function get_infoalbum($infoid, $fieldname='InfoAlbum'){
	$m = D('Admin/Info');
	$data = $m->getInfoAlbum( $infoid, $fieldname);
	return $data;
}

function get_inforelation($infoid, $fieldname='InfoRelation'){
	$m = D('Admin/Info');
	$data = $m->getInfoRelation($infoid,$fieldname);
	if( empty($data) ) return false;
	$Total = count($data);
	for($i = 0; $i < $Total; $i++){
		$data[$i]['DiscountPrice'] = DiscountPrice($data[$i]['InfoID'], $data[$i]['InfoPrice']);
		$data[$i]['InfoPrice'] = yd_to_money($data[$i]['InfoPrice']);
		$data[$i]['InfoSTitle'] = $data[$i]['InfoTitle'];
		$data[$i]['InfoUrl'] = InfoUrl($data[$i]['InfoID'], $data[$i]['Html'], $data[$i]['LinkUrl'], false, $data[$i]['ChannelID']);
		$data[$i]['Count'] = $Total;
	}
	return $data;
}

function get_channelalbum($channelid, $fieldname='ChannelAlbum'){
	$m = D('Admin/Channel');
	$data = $m->getChannelAlbum( $channelid, $fieldname);
	return $data;
}

function get_channelrelation($channelid, $fieldname='ChannelRelation'){
	$m = D('Admin/Channel');
	$data = $m->getChannelRelation($channelid,$fieldname);
	if( empty($data) ) return false;
	$Total = count($data);
	for($i = 0; $i < $Total; $i++){
		$data[$i]['InfoSTitle'] = $data[$i]['InfoTitle'];
		$data[$i]['InfoUrl'] = InfoUrl($data[$i]['InfoID'], $data[$i]['Html'], $data[$i]['LinkUrl'], false, $data[$i]['ChannelID']);
		$data[$i]['Count'] = $Total;
	}
	return $data;
}

function get_history($top=-1){
	$h = YdHistory::getInstance();
	$data = $h->getAllData($top);
	return $data;
}

//sales 按销量排序
function get_top($channelid='-1', $type='sales', $top=-1, $order='desc'){
	$m = D('Admin/Info');
	$data = $m->getTopOrderbySales($channelid, $top, $order);
	return $data;
}

function get_tag($infoid){
	$m = D('Admin/Info');
	$str = $m->getTag($infoid);
	if( empty($str) ) return false;
	$data = explode(',', $str);
	$n = count($data);
	$tag = false;
	for($i = 0; $i < $n; $i++){
		$name = trim($data[$i]);
		$url = InfoSearchAction();
		$url .= (strpos($url, '?') === false ) ? '?' : '&';
		$url .= 'Keywords='.urlencode($name);
		$tag[$i]['TagName'] = $name;
		$tag[$i]['TagUrl'] = $url;
	}
	return $tag;
}

function get_oauth(){
	$m = D('Admin/Oauth');
	$options['IsEnable'] = 1;
	$options['RemoveEmpty'] = 1;
	$data = $m->getOauth($options);
	if(empty($data)) return false;
	import("@.Common.YdOauth");
	$n = count($data);
	for($i = 0; $i < $n; $i++){
		$obj = YdOauth::getInstance($data[$i]['OauthMark']);
		$obj->setAppID( $data[$i]['OauthAppID'] );
		$obj->setAppKey( $data[$i]['OauthAppKey'] );
		$data[$i]['OauthRequestUrl'] = $obj->getRequestUrl();
	}
	return $data;
}

//获取信息
function get_info($channelID = 0, $specialID = 0, $top = 10, $timeFormat='Y-m-d', $titleLen = 0, $suffix='...', $labelID='', $nowPage=0, 
		$keywords='', $orderby=false, $minprice=-1, $maxprice=-1, $attr='', $LanguageID=-1, $Field='', $PageSize=0,
		$ProvinceID=-1, $CityID=-1, $DistrictID=-1, $TownID=-1){
	$m = D('Admin/Info');
	$options = array('Time'=>1, 'MinPrice'=>$minprice, 'MaxPrice'=>$maxprice,'Attr'=>$attr, 'LanguageID'=>$LanguageID, 
			'Field'=>$Field, 'Flag'=>1, 'ProvinceID'=>$ProvinceID, 'CityID'=>$CityID, 'DistrictID'=>$DistrictID, 'TownID'=>$TownID);
	if( $nowPage != 0 ){ //分页, $labelID和$top无效, 获取指定分页数据
		$Total = $m->getCount($channelID, 1, 1, $keywords, -1, $specialID, $labelID, 1, -1, $options); //获取总记录数$page
		if( empty($PageSize) ){
			$PageSize = D('Admin/Channel')->where("ChannelID=$channelID")->getField('PageSize'); //页面大小
			$PageSize = ($PageSize > 0) ? $PageSize : 20;
		}
		$nowPage = ( $nowPage - 1 > 0 ) ? ( $nowPage - 1 ) : 0;
		$offset = $nowPage * $PageSize;
		$data = $m->getInfo($offset, $PageSize, $channelID, 1, 1, $labelID, $keywords, -1, $specialID, 1, $orderby, -1, $options);
	}else{ //不分页
		$data = $m->getInfo(0, $top, $channelID, 1, 1, $labelID, $keywords, -1, $specialID, 1, $orderby, -1, $options);
		$Total = count($data);
	}
	if( empty($data) ) return false;  //当$data为false时，count($data)返回1，因此必选先判断$data是否为空
	$mt = D('Admin/TypeAttribute');
	$count = count( $data );
	//$html = C('HTML_CACHE_ON');
	for($i = 0; $i < $count; $i++){
		//当$titleLen＝0时这样写会浪费CPU资源。$len = mb_strlen( $data[$i]['InfoTitle'] , 'utf-8'); //1个汉字算1个长度
		if( $titleLen > 0 &&  mb_strlen( $data[$i]['InfoTitle'] , 'utf-8') > $titleLen ){ //截取字符串
			$data[$i]['InfoSTitle'] = msubstr( $data[$i]['InfoTitle'], 0, $titleLen, 'utf-8', $suffix);
		}else{
			$data[$i]['InfoSTitle'] = $data[$i]['InfoTitle'];
		}
		//if($html){
		//	$data[$i]['InfoHit'] = "<script src='".__GROUP__."/public/getInfoHit?infoid={$data[$i]['InfoID']}'></script>";
		//}	
		$data[$i]['DiscountPrice'] = DiscountPrice($data[$i]['InfoID'], $data[$i]['InfoPrice']);
		$data[$i]['ExchangePrice'] = ExchangePrice($data[$i]['InfoID'], $data[$i]['ExchangePoint'],$data[$i]['DiscountPrice']);
		
		$data[$i]['InfoPrice'] = yd_to_money($data[$i]['InfoPrice']);
		$timestamp = strtotime( $data[$i]['InfoTime'] );
		$data[$i]['InfoTime'] = date($timeFormat, $timestamp );  //格式化时间
		$data[$i]['InfoFriendTime'] = yd_friend_date($timestamp);
		$data[$i]['InfoUrl'] = InfoUrl($data[$i]['InfoID'], $data[$i]['Html'], $data[$i]['LinkUrl'],  false, $data[$i]['ChannelID']);
		if( empty($Field) || false !== stripos($Field, 'ChannelUrl') ){
			$data[$i]['ChannelUrl'] = ChannelUrl($data[$i]['ChannelID'], $data[$i]['ChannelHtml'], $data[$i]['ChannelLinkUrl']);
		}
		$data[$i]['Count'] = $Total;
		if($data[$i]['TypeID']>0){
			$data[$i]['HasPriceAttribute'] = $mt->hasPriceAttribute($data[$i]['TypeID']);
		}else{
			$data[$i]['HasPriceAttribute'] = 0;
		}
		
	}
	return $data;
}

/**
 * 获取类型属性
 * @param int $type 1：所有属性、2：规格属性、3：检索条件属性
 * @param int $infoid 信息ID，仅type=2、3时有效
 * @param int $channelid 频道ID，仅type=1时有效
 * @param int $specialid 专题ID，仅type=1时有效
 * @param int $minprice 最小价格，仅type=1时有效
 * @param int $maxprice 最大价格，仅type=1时有效
 */
function get_type_attribute($type=1, $infoid=-1, $channelid=-1, $specialid=-1, $minprice=-1, $maxprice=-1){
	if( !is_numeric($infoid)) $infoid = -1;
	if( !is_numeric($channelid)) $channelid = -1;
	if( !is_numeric($specialid)) $specialid = -1;
	if( !is_numeric($minprice)) $minprice = -1;
	if( !is_numeric($maxprice)) $maxprice = -1;
	$m = D('Admin/TypeAttribute');
	switch($type){
		case 1:
			$data = $m->getAllAttribute($infoid); //显示所有属性和分组
			break;
		case 2:
			$data = $m->getSpecAttribute($infoid); //仅显示规格
			break;
		case 3:
			$data = $m->getConditionAttribute($channelid, $specialid, $minprice, $maxprice); //显示筛选条件属性
			break;
	}
	return $data;
}

/**
 * 获取选择属性数据
 * @param string $attr 属性值，多个属性值以下划线隔开
 */
function get_selected_attribute($attr='', $specialid=-1, $minprice=-1, $maxprice=-1){
	if( empty($attr) ) return false;
	if( !preg_match('/^([0-9]+_?)+$/',$attr) ) return false;
	$m = D('Admin/TypeAttributeValue');
	$data = $m->getSelectedAttribute($attr, $specialid, $minprice, $maxprice);
	return $data;
}

/**
 * 执行sql返回数据
 * @param string $sql   //sql不能包含< > 引号等特殊字符,<用&lt;替代，>用&gt;替代, 单引号用^替代
 * @param int $page 小于等于0表示不分页
 */
function get_data($sql){
	//sql合法性检验
	$prefix = strtolower(substr($sql, 0, 6));
	if( $prefix != 'select' ) return false;
	$chars = array(
			'&lt;'=>'<', '&gt;'=>'>', '^^'=>'"', '^'=>"'",
			' nheq '=>' !== ',' heq '=>' === ',' neq '=>' != ',' eq '=>' == ',' egt '=>' >= ',' gt '=>' > ',' elt '=>' <= ',' lt '=>' < '
	);
	$sql = str_replace(array_keys($chars), array_values($chars), $sql);
	$banTable = array('admin','admin_group','member','member_group','config');
	$tablePrefix = C('DB_PREFIX');
	foreach($banTable as $v){
		if( stripos($sql, $tablePrefix.$v) ){
			return false;
		}
	}
	$m = new Model();
	$data = $m->query($sql);
	return $data;
}

/**
 * 返回json数组
 * @param string $url
 */
function get_json($url){
	$content = file_get_contents($url);
	$data[0] = json_decode($content, true); //返回二维数组，便于voilist遍历
	return $data;
}

//根据主键获取表中字段值, $tableName:不带前缀
function get_single_value($id, $tableName, $FieldName){
	if(!is_numeric($id)) return false;
	$key = $tableName.$FieldName.$id;
	static $_cache = array();
	if (isset($_cache[$key])){
		return $_cache[$key];
	}
	switch ( strtolower($tableName) ){
		case 'info': //信息
			$m = D('Admin/Info');
			$result = $m->where("InfoID=$id and IsEnable=1 and IsCheck=1")->getField($FieldName);
			break;
		case 'channel': //频道
			$m = D('Admin/Channel');
			$where = "ChannelID=$id and IsEnable=1 ";
			if( $FieldName == 'LinkUrl' ){ //必须为链接模型才返回LinkUrl
					$where .= ' and ChannelModelID = 33';
			}
			$result = $m->where($where)->getField($FieldName);
			break;
		case 'channel_model':
			$m = D('Admin/ChannelModel');
			$result = $m->where("ChannelModelID=$id")->getField($FieldName);
			break;
		case 'banner': //幻灯
			$m = D('Admin/Banner');
			$result = $m->where("BannerID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'bannergroup': //幻灯片分组
			$m = D('Admin/BannerGroup');
			$result = $m->where("BannerGroupID=$id")->getField($FieldName);
			break;
		case 'link': //友情链接
			$m = D('Admin/Link');
			$result = $m->where("LinkID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'linkclass': //友情链接分类
			$m = D('Admin/LinkClass');
			$result = $m->where("LinkClassID=$id")->getField($FieldName);
			break;
		case 'ad': //广告
			$m = D('Admin/Ad');
			$result = $m->where("AdID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'adgroup': //广告分组
			$m = D('Admin/AdGroup');
			$result = $m->where("AdGroupID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'job': //职位
			$m = D('Admin/Job');
			$result = $m->where("JobID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'tag': //自定义标签
			$m = D('Admin/Tag');
			$result = $m->where("TagID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'special': //专题
			$m = D('Admin/Special');
			$result = $m->where("SpecialID=$id and IsEnable=1")->getField($FieldName);
			break;
		case 'guestbook': //留言
			$m = D('Admin/Guestbook');
			$result = $m->where("MessageID=$id")->getField($FieldName);
			break;
		case 'label': //频道属性标记
			$m = D('Admin/Label');
			$result = $m->where("LabelID=$id")->getField($FieldName);
			break;
		case 'member': //会员信息
			$m = D('Admin/Member');
			$result = $m->where("MemberID=$id and IsLock=0 and IsCheck=1")->getField($FieldName);
			break;
		default:
			$result = false;
	}
	$_cache[$key] = $result;
	return $result;
}

//频道单字段 Start===============================================
function HasChild($id){
	$HasChild = get_single_value($id, 'Channel', 'HasChild');
	return $HasChild;
}

//当前频道顶层频道是否有子频道
function TopHasChild($id){
	$result = HasChild($id);
	if($result==1) return 1;
	
	$result = HasParent($id);
	if($result==1) return 1;
	
	return 0;
}

function HasParent($id){
	$result = get_single_value($id, 'Channel', 'Parent');
	return $result > 0 ? 1: 0;
}
//指定频道的最顶层频道ID
function TopChannelID($id){
	$m = D('Admin/Channel');
	$topChannelID = $m->getTopChannel($id);
	return $topChannelID;
}

//$value不为false时表示赋值缓存频道名称，可以极大的提升ChannelName函数性能
function ChannelName($id, $name=false){
	static $_cache = array();
	if(false === $name){
		if (isset($_cache[$id])){
			return $_cache[$id];
		}
		$m = D('Admin/Channel');
		$where['ChannelID'] = intval($id);
		$where['IsEnable'] = 1;
		$result = $m->where($where)->getField('ChannelName');
		$_cache[$id] = $result;
		return $result;
	}else{ //缓存频道名称
		$_cache[$id] = $name;
	}
}
function ChannelModelName($id){	return  get_single_value($id, 'Channel_Model', 'ChannelModelName');}
function ChannelModelID($id){	return  get_single_value($id, 'Channel', 'ChannelModelID');}
function ChannelTarget($id){	return  get_single_value($id, 'Channel', 'ChannelTarget');}
function ChannelOrder($id){	return  get_single_value($id, 'Channel', 'ChannelOrder');}

function ChannelUrl($id, $html=false, $linkurl=false, $langmark = false){
	static $_cache = array();
	if (isset($_cache[$id])){
		return $_cache[$id];
	}
	
	if($langmark === false){
		$prefix = LANG_PREFIX;
	}else{ //显式传入$langmark
		$prefix = $langmark != C('DEFAULT_LANG') ? '/'.$langmark : '';
	}
	
	//如果存在欢迎页=================================================
	if($id == 1 || $id== 2) {
		$HasWelcome = file_exists( THEME_PATH.'channel/welcome.html' );
		if( $HasWelcome == false){
			$url =  (strtolower(GROUP_NAME) != 'wap') ? __APP__ : __GROUP__;
			//存在bug，没有电脑站并默认为Wap时，英文版首页地址为：/index.php/en,会调到home分组
			//解决方案：将配置文件config路由默认home删除即可
			$url .= $prefix;  
			if( $url == '' ) $url = '/';  //当在public/login时，若__APP__为空，则首页为/public地址
			$url = AppendWxUrlPara($url);
			$_cache[$id] = $url;
			return $url;
		}
	}
	//===========================================================
	
	//转向链接======================================================
	if( false === $linkurl ){ //无显式参数传入
		$linkurl = ChannelLinkUrl($id);
		if( !empty( $linkurl ) ) {
			$url = AppendWxUrlPara($linkurl);
			$_cache[$id] = $url;
			return $url;
		}
	}else if( !empty($linkurl) ){ //有参数插入，并且不为空
		$url = AppendWxUrlPara($linkurl);
		$_cache[$id] = $url;
		return $url;
	}
	//============================================================
	
	//非转向链接的情况==============================
	if( false === $html){  //无显式参数传入
		$html = ChannelHtml($id);
	}
	//=========================================
	
	if(C('URL_ROUTER_ON')){//支持路由
		$url = (strtolower(GROUP_NAME) != 'wap') ? U($prefix."/$html") : U('/wap'.$prefix.'/'.$html);
	}else{
		$url = (strtolower(GROUP_NAME) != 'wap') ? U('channel/index', "id=$html") : U('wap/channel/index', "id=$html");
	}
	$url = AppendWxUrlPara($url);
	$_cache[$id] = $url;
	return $url;
}

function ChannelLinkUrl($id){
	$linkurl = get_single_value($id, 'Channel', 'LinkUrl');
	return $linkurl;
}
function ChannelSName($id){
	return get_single_value($id, 'Channel', 'ChannelSName'); 
}
function ChannelContent($id, $count = 0, $suffix='...'){
	$content = get_single_value($id, 'Channel', 'ChannelContent');
	if( $count > 0 ){
		$len = mb_strlen( $content , 'utf-8');  //获取实际内容的长度
		if( $len > $count ){ //截取字符串
			$content = msubstr( $content, 0, $count, 'utf-8', $suffix);
		}
	}
	$content = ParseTag($content);
	return $content;
}
function ChannelSContent($id, $count = 0, $suffix='...'){
	$content = get_single_value($id, 'Channel', 'ChannelSContent');
	if( $count <= 0 ) return $content;
	$len = mb_strlen( $content , 'utf-8');  //获取实际内容的长度
	if( $len > $count ){ //截取字符串
		$content = msubstr( $content, 0, $count, 'utf-8', $suffix);
	}
	return $content;
}
function ChannelPicture($id){
	return get_single_value($id, 'Channel', 'ChannelPicture');
}
function ChannelReadTemplate($id){
	return get_single_value($id, 'Channel', 'ReadTemplate');
}
function ChannelIndexTemplate($id){
	return get_single_value($id, 'Channel', 'IndexTemplate');
}
function ChannelReadLevel($id){	return get_single_value($id, 'Channel', 'ReadLevel');}
function PageSize($id){	return get_single_value($id, 'Channel', 'PageSize');}
function ChannelParent($id){
	return get_single_value($id, 'Channel', 'Parent');
}
function ChannelIcon($id){
	return get_single_value($id, 'Channel', 'ChannelIcon');
}
function ChannelStyle($id){return get_single_value($id, 'Channel', 'ChannelStyle');}
function ChannelF1($id){
	return get_single_value($id, 'Channel', 'f1');
}
function ChannelF2($id){
	return get_single_value($id, 'Channel', 'f2');
}
function ChannelF3($id){
	return get_single_value($id, 'Channel', 'f3');
}

function ChannelHtml($id){	return get_single_value($id, 'Channel', 'Html');}
function ChannelTitle($id){	return  get_single_value($id, 'Channel', 'Title');}
function ChannelKeywords($id){	return  get_single_value($id, 'Channel', 'Keywords');}
function ChannelDescription($id){	return  get_single_value($id, 'Channel', 'Description');}
function ChannelIsShow($id){	return  get_single_value($id, 'Channel', 'IsShow');}
//频道单字段 End================================================

//频道属性标记 Start==============================================
function LabelName($id){
	$name = get_single_value($id, 'Label', 'LabelName');
	return $name;
}
//频道属性标记 End===============================================

//友情链接 start===============================================
//友情链接 Start==============================================
function LinkClassName($id){
	return get_single_value($id, 'LinkClass', 'LinkClassName');
}
function LinkName($id){
	return get_single_value($id, 'Link', 'LinkName');
}
function LinkClassID($id){
	return get_single_value($id, 'Link', 'LinkClassID');
}
function LinkType($id){
	return get_single_value($id, 'Link', 'LinkType');
}
function LinkLogo($id){
	return get_single_value($id, 'Link', 'LinkLogo');
}
function LinkUrl($id){
	return get_single_value($id, 'Link', 'LinkUrl');
}
function LinkDescription($id){
	return get_single_value($id, 'Link', 'LinkDescription');
}
//友情链接 End===============================================

//会员 start================================================
function MemberMobile($id){
	return get_single_value($id, 'Member', 'MemberMobile');
}

function MemberEmail($id){
	return get_single_value($id, 'Member', 'MemberEmail');
}

/**
 * 获取当前会员总积分
 */
function TotalPoint(){
	$TotalPoint = 0;
	$MemberID = session('MemberID');
	if($MemberID>0){
		$m = D('Admin/Point');
		$TotalPoint = $m->getTotalPoint($MemberID);
		if(empty($TotalPoint)) $TotalPoint=0;
	}
	return $TotalPoint;
}

/**
 * 获取当前订单最大可用积分
 */
function MaxUsePoint(){
	$MemberID = session('MemberID');
	$m = D('Admin/Cart');
	$point = $m->getCartExchangePoint($MemberID);
	return $point;
}
//会员 end=================================================

//幻灯片 start===============================================
function BannerGroupName($id){
	return get_single_value($id, 'BannerGroup', 'BannerGroupName');
}
function BannerName($id){
	return get_single_value($id, 'Banner', 'BannerName');
}
function BannerGroupID($id){
	return get_single_value($id, 'Banner', 'BannerGroupID');
}
function BannerImage($id){
	return get_single_value($id, 'Banner', 'BannerImage');
}
function BannerThumbnail($id){
	return get_single_value($id, 'Banner', 'BannerThumbnail');
}
function BannerUrl($id){
	return get_single_value($id, 'Banner', 'BannerUrl');
}
function BannerDescription($id){
	return get_single_value($id, 'Banner', 'BannerDescription');
}
//幻灯片 End===============================================

//专题 start===============================================
function SpecialName($id){
	return get_single_value($id, 'Special', 'SpecialName');
}
function SpecialDescription($id){
	return get_single_value($id, 'Special', 'SpecialDescription');
}
//专题 End===============================================

//自定义标签 start===============================================
function TagName($id){
	return get_single_value($id, 'Tag', 'TagName');
}
function TagContent($id){
	return get_single_value($id, 'Tag', 'TagContent');
}
function TagDescription($id){
	return get_single_value($id, 'Tag', 'TagDescription');
}
//自定义标签 End===============================================

//广告标签 start===============================================
function AdName($id){
	return get_single_value($id, 'Ad', 'AdName');
}
function AdContent($id){
	return get_single_value($id, 'Ad', 'AdContent');
}
function AdUrl($id){
	return get_single_value($id, 'Ad', 'AdUrl');
}
function AdDescription($id){
	return get_single_value($id, 'Ad', 'AdDescription');
}
function AdTime($id){
	return get_single_value($id, 'Ad', 'AdTime');
}
function AdGroupID($id){
	return get_single_value($id, 'Ad', 'AdGroupID');
}
function AdGroupName($id){
	return get_single_value($id, 'AdGroup', 'AdGroupName');
}
function AdGroupDescription($id){
	return get_single_value($id, 'AdGroup', 'AdGroupDescription');
}
//广告标签 End===============================================

//信息单字段 Start===============================================
function ChannelID($id){return get_single_value($id, 'Info', 'ChannelID');}
function InfoTitle($id){return get_single_value($id, 'Info', 'InfoTitle');}
function InfoTime($id){return get_single_value($id, 'Info', 'InfoTime');}
function InfoF1($id){ return get_single_value($id, 'Info', 'f1');}
function InfoF2($id){return get_single_value($id, 'Info', 'f2');}
function InfoF3($id){return get_single_value($id, 'Info', 'f3');}
function InfoF4($id){return get_single_value($id, 'Info', 'f4');}
function InfoF5($id){return get_single_value($id, 'Info', 'f5');}
function InfoPrice($id){return yd_to_money(get_single_value($id, 'Info', 'InfoPrice'));}

function DiscountPrice($id, $infoprice){
	$price = is_numeric($infoprice) ? $infoprice : get_single_value($id, 'Info', 'InfoPrice');
	$price = yd_to_money($price*$GLOBALS['DiscountRate']); //4舍5入保留2位小数
	return $price;
}

/**
 * 计算积分兑换价格=价格-积分x(1/POINT_EXCHANGE_RATE)
 * @param int $id
 * @param int $point
 * @param doube $discountprice
 * @return Ambigous <string, unknown>
 */
function ExchangePrice($id, $point, $discountprice=false){
	$price = is_numeric($discountprice) ? $discountprice : DiscountPrice($id);
	if($point>0){
		$rate = $GLOBALS['Config']['POINT_EXCHANGE_RATE'];
		if($rate>0){
			$price = $price-$point/$rate;
			if($price<0) $price = 0;
			$price = yd_to_money($price); //4舍5入保留2位小数
		}
	}
	return $price;
}

function InfoSContent($id, $count = 0, $suffix='...'){
	$content = get_single_value($id, 'Info', 'InfoSContent');
	if( $count <= 0 ) return $content;
	$len = mb_strlen( $content , 'utf-8');  //获取实际内容的长度
	if( $len > $count ){ //截取字符串
		$content = msubstr( $content, 0, $count, 'utf-8', $suffix);
	}
	return $content;
}
function InfoContent($id, $count = 0, $suffix='...'){
	$content = get_single_value($id, 'Info', 'InfoContent');
	if( $count > 0 ){
		$len = mb_strlen( $content , 'utf-8');  //获取实际内容的长度
		if( $len > $count ){ //截取字符串
			$content = msubstr( $content, 0, $count, 'utf-8', $suffix);
		}
	}
	$content = ParseTag($content);
	return $content;
}
function InfoPicture($id){
	return get_single_value($id, 'Info', 'InfoPicture');
}
function InfoAttachment($id){
	return get_single_value($id, 'Info', 'InfoAttachment');
}
function InfoHtml($id){
	return get_single_value($id, 'Info', 'Html');
}
function InfoLinkUrl($id){
	return get_single_value($id, 'Info', 'LinkUrl');
}

function InfoUrl($id, $html=false, $linkurl=false, $langmark = false, $channelid=false){
	//转向链接======================================================
	if( false === $linkurl ){ //无显式参数传入
		$linkurl = InfoLinkUrl($id);
		if( !empty( $linkurl ) ) {
			$url = AppendWxUrlPara($linkurl);
			return $url;
		}
	}else if( !empty($linkurl) ){ //有参数插入，并且不为空
		$url = AppendWxUrlPara($linkurl);
		return $url;
	}
	//============================================================
	
	if($langmark === false){
		$prefix = LANG_PREFIX;
	}else{ //显式传入$langmark
		$prefix = $langmark != C('DEFAULT_LANG') ? '/'.$langmark : '';
	}
	
	if($channelid !== false){
		$dir = $GLOBALS['Config']['CHANNEL_DATA'][$channelid];
	}else{
		$channelid = ChannelID($id);
		$dir = $GLOBALS['Config']['CHANNEL_DATA'][$channelid];
	}
	if( empty($dir) ) $dir = 'info';
	
	//非转向链接的情况
	if( false === $html){  //无显式参数传入
		$html = InfoHtml($id);
		if( !empty($html) ) $id = $html;
	}else if( !empty($html) ){ //显式传参
		$id = $html;
	}
	
	if(C('URL_ROUTER_ON')){
		$url =  (strtolower(GROUP_NAME) != 'wap') ? U("{$prefix}/{$dir}/{$id}") : U("/wap{$prefix}/{$dir}/{$id}");  //支持路由
	}else{
		$url =  (strtolower(GROUP_NAME) != 'wap') ? U("{$dir}/read", "id={$id}") : U("wap/{$dir}/read", "id={$id}");
	}
	$url = AppendWxUrlPara($url);
	return $url;
}
//获取指定频道信息数
function InfoCount($id){
	$m = D('Admin/Info');
	$n = $m->getInfoCount($id);
	return $n;
}

function InfoOrder($id){return get_single_value($id, 'Info', 'InfoOrder');}
function InfoHit($id){return get_single_value($id, 'Info', 'InfoHit');}
function InfoFrom($id){return get_single_value($id, 'Info', 'InfoFrom');}

function LabelID($id){
	return get_single_value($id, 'Info', 'LabelID');
}
function InfoAlbum($id){
	return get_single_value($id, 'Info', 'InfoAlbum');
}
function InfoRelation($id){
	return get_single_value($id, 'Info', 'InfoRelation');
}

function InfoReadLevel($id){return get_single_value($id, 'Info', 'ReadLevel');}
function SpecialID($id){return get_single_value($id, 'Info', 'SpecialID'); }
function InfoKeywords($id){	return get_single_value($id, 'Info', 'Keywords'); }
function InfoDescription($id){ return get_single_value($id, 'Info', 'Description'); }
//信息单字段 End===============================================

//常见页面Url=================================================
//信息检索
function InfoSearchAction( $ChannelID = 0 ){
	//$url = __APP__.'/'.GROUP_NAME.'/channel/search';
	$url = __GROUP__.'/channel/search';
	if( $ChannelID != 0 ){
		$url .= '/id/'.$ChannelID;
	}
	$url .= '/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}

function InfoSearchUrl( $ChannelID = 0 ){
	return InfoSearchAction( $ChannelID );
}

//邮件订阅Url
function SubscibeUrl($MailClassID = false){
	$url = __GROUP__.'/channel/subscibe';
	if( $MailClassID ){
		$url .= '/id/'.$MailClassID;
	}
	$url .= '/l/'.LANG_SET;
	return $url;
}

//用户注册
function MemberRegAction(){
	$url = __GROUP__.'/public/savereg/l/'.LANG_SET;
	return $url;
}

function MemberSaveRegUrl(){
	return MemberRegAction();
}

function MemberSaveOauth(){
	$url = __GROUP__.'/public/saveOauth/l/'.LANG_SET;
	return $url;
}

//留言板地址
function GuestbookAddAction(){
	$url = __GROUP__.'/channel/guestbookadd/l/'.LANG_SET;
	return $url;
}

function GuestbookAddUrl(){
	return GuestbookAddAction();
}

function CommentAddAction(){
	$url = __GROUP__.'/channel/commentadd/l/'.LANG_SET;
	return $url;
}

function OrderAddAction(){
	$url = __GROUP__.'/channel/orderAdd/l/'.LANG_SET;
	return $url;
}

function ShopUrl($InfoID){
	$url = __APP__.'/wap/public/addCart/l/'.LANG_SET.'?infoid='.$InfoID;
	return $url;
}

//网站首页地址
function HomeUrl(){
	$t = array('en'=>2, 'cn'=>1);
	$id = $t[ get_language_mark() ];
	if(stripos($_SERVER['HTTP_USER_AGENT'],"MicroMessenger") === false) {
		return ChannelUrl($id);
	}else{
		return WxChannelUrl($id);
	}
}

//手机站首页网址
function WapHomeUrl($langmark=false){
	if($langmark === false){
		$prefix = LANG_PREFIX;
	}else{ //显式传入$langmark
		$prefix = $langmark != C('DEFAULT_LANG') ? '/'.$langmark : '';
	}
	$url =  __APP__.'/wap'.$prefix;
	$domainRules = C('APP_SUB_DOMAIN_RULES');
	if(!empty($domainRules)){ //如果设置了域名
		$data = array_keys( $domainRules );
		if( isset($data[0]) ){
			$protocol = get_current_protocal();
			if( 2 == C('URL_MODEL') ){
				$url =  $protocol.$data[0].$prefix;
			}else{
				$url =  $protocol.$data[0].'/index.php'.$prefix;
			}
		}
	}
	$url = AppendWxUrlPara($url);
	return $url;
}

//人才招聘地址
function JobUrl(){
	$t = array('en'=>3, 'cn'=>8);
	$id = $t[ get_language_mark() ];
	return ChannelUrl($id);
}

//语言切换地址
function LanguageUrl($mark = 'cn'){
	//如果不存在欢迎页==============================================
	$HasWelcome = file_exists( THEME_PATH.'channel/welcome.html' );
	if( $HasWelcome == false){ //如果不存在欢迎页
		$url =  (strtolower(GROUP_NAME) != 'wap') ? __APP__ : __GROUP__;
		if( $url == '' ) $url = '/';
		$url .= '?l='.$mark;
		return AppendWxUrlPara($url);
	}
	//==========================================================
	
	$t = array('en'=>2, 'cn'=>1);
	$id = $t[$mark];
	$html = ChannelHtml($id);
	if(C('URL_ROUTER_ON')){ //支持路由
		$url = (strtolower(GROUP_NAME) != 'wap') ? U("/$html") : U("/wap/$html");
	}else{
		$url = (strtolower(GROUP_NAME) != 'wap') ? U('channel/index', "id=$html") : U('wap/channel/index', "id=$html");
	}
	$url .= '?l='.$mark;
	return AppendWxUrlPara($url);
}

//网站地图地址
function SitemapUrl(){
	$t = array('en'=>14, 'cn'=>3);
	$id = $t[ get_language_mark() ];
	$url = ChannelUrl($id);
	return $url;
}

//在线订购地址
function OrderUrl($InfoID=false){
	//$t = array('en'=>7, 'cn'=>6);
	//$id = $t[ get_language_mark() ];
	//$html = ChannelHtml($id);	
	$html = 'order';
	if(C('URL_ROUTER_ON')){
		$url = (strtolower(GROUP_NAME) != 'wap') ? U(LANG_PREFIX."/$html$InfoID") : U("/wap".LANG_PREFIX."/$html$InfoID");  //支持路由
	}else{
		$url =  (strtolower(GROUP_NAME) != 'wap') ? U('channel/index', array('id'=>$html,'infoid'=>$InfoID)) : U('/wap/channel/index', array('id'=>$html,'infoid'=>$InfoID));
	}
	return AppendWxUrlPara($url);
}


//投递简历地址
function ResumeUrl($JobID=false){
	//$t = array('en'=>11, 'cn'=>10);
	//$id = $t[ get_language_mark() ];
	//$html = ChannelHtml($id);
	$html = 'resume';
	if(C('URL_ROUTER_ON')){
		$url = (strtolower(GROUP_NAME) != 'wap') ? U(LANG_PREFIX."/$html$JobID") : U("/wap".LANG_PREFIX."/$html$JobID");  //支持路由
	}else{
		$url =  (strtolower(GROUP_NAME) != 'wap') ? U('channel/index', array('id'=>$html,'jobid'=>$JobID)) : U('/wap/channel/index', array('id'=>$html,'jobid'=>$JobID));
	}
	return AppendWxUrlPara($url);
}

//API接口网址
function ApiUrl($type){
	if(GROUP_NAME=='Home' || GROUP_NAME=='Wap'){
		$url = __GROUP__.'/api/'.$type.'/l/'.LANG_SET;
	}else{
		$url = __APP__.'/api/'.$type.'/l/'.LANG_SET;
	}
	return $url;
}

//用户登录
function MemberLoginUrl(){
	$url = __GROUP__.'/public/login/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}

//用户注册
function MemberRegUrl(){
	$url = __GROUP__.'/public/reg/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}

//手机注册验证码链接
function SmsCodeUrl(){
	$url = __GROUP__.'/public/sendSmsCode/l/'.LANG_SET;
	return $url;
}

//忘记密码
function MemberForgetUrl(){
	$url = __GROUP__.'/public/forget/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}

//登陆验证
function CheckMemberUrl(){
	$url = __GROUP__.'/public/checkLogin';
	return $url;
}

//用户后台首页
function MemberUrl(){
	$url = __APP__.'/member/public/index';
	return $url;
}

function WapMemberUrl(){
	$url = __APP__.'/member/mobile/index';
	return $url;
}

function MemberLogoutUrl(){
	$url = __APP__.'/member/public/logout';
	return $url;
}

//反馈表单提交
function FeedbackUrl(){
	$url =  __GROUP__.'/Channel/feedbackAdd/l/'.LANG_SET;
	return $url;
}

//邮件发送
function MailUrl($isverify = 1){
	$url =  __GROUP__.'/public/sendMail?isverify='.$isverify;
	return $url;
}

/**
 * 生成验证码
 * @param string $verifyName 验证码session名称
 * @param int $width 宽度
 * @param int $height 高度
 * @param int $length 验证码个数
 * @param int $mode 模式 0:字母, 1:数字, 2:大写字母, 3:小写字母, 4:中文, 5:混合
 * @param string $type 验证码图片格式
 */
function CodeUrl($verifyName='verify',$width = 22, $height = 22, $length = 4, $mode = 1, $type = 'png'){
	$get = "?verify=$verifyName&width=$width&height=$height&length=$length&mode=$mode&type=$type";
	return __GROUP__."/public/verifyCode".$get;
}
//表单Action end==================================================


//微信实用函数start==============================================
//微信API接口地址
function WxApiUrl(){
	$v = C('URL_MODEL');
	$url = get_web_url();
	if($v == 1){
		$url .= '/index.php';
	}
	$url .= '/public/wxapi/';
	return $url;
}

//2013年附加微信参数，修复不能拨号的bug，$iswx＝true表示确定是微信
function AppendWxUrlPara($url, $iswx=false){
	return $url;  //2017-8-31 最近发现不附加这串字符也可以拨号，所以直接返回
	if( $iswx || stripos($_SERVER['HTTP_USER_AGENT'],"MicroMessenger") ) {
		//判断url中是否存在?参数
		$append = (strpos($url, '?') === false ) ? '?' : '&';
		$url .= $append.C('WX_URL_APPEND');
	}
	return $url;
}

function WxLotteryUrl($appID){
	$url = get_wx_url()."/app/lottery?appid=$appID";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//投票Url
function WxVoteUrl($appID){
	$url = get_wx_url()."/app/vote?appid=$appID";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//调查Url
function WxResearchUrl($appID){
	$url = get_wx_url()."/app/research?appid=$appID";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//提交投票
function WxVoteAddUrl($appID){
	$url =  __GROUP__.'/channel/voteAdd?appid='.$appID;
	return $url;
}

//会员卡首页地址
function WxCardUrl(){
	$url = get_wx_url()."/app/card";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

function WxCardStoreUrl(){
	$url = get_wx_url()."/app/cardStore";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//会员卡说明地址
function WxCardInfoUrl(){
	$url = get_wx_url()."/app/cardInfo";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//会员卡通知管理
function WxCardNotifyUrl(){
	$url = get_wx_url()."/app/cardNotify";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//我的消费记录
function WxCardMyConsumeUrl(){
	$url = get_wx_url()."/app/cardMyConsume";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//我的积分记录
function WxCardMyScoreUrl(){
	$url = get_wx_url()."/app/cardMyScore";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//我的兑换记录
function WxCardMyExchangeUrl(){
	$url = get_wx_url()."/app/cardMyExchange";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//会员资料
function WxCardMemberUrl(){
	$url = get_wx_url()."/app/cardMember";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//微信绑定会员
function WxBindMemberUrl(){
	$url = get_wx_url()."/app/bindMember";
	$url = AppendWxUrlPara($url, true);
	return $url;
}


//会员特权地址
function WxCardPrivilegeUrl(){
	$url = get_wx_url()."/app/cardprivilege";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//会员卡优惠卷地址
function WxCouponUrl(){
	$url = get_wx_url()."/app/cardCoupon";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//会员卡兑换
function WxExchangeUrl(){
	$url = get_wx_url()."/app/cardExchange";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//会员卡签到
function WxCardScoreUrl(){
	$url = get_wx_url()."/app/cardScore";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//微应用Url地址
function WxAppUrl($AppID, $AppTypeID=false){
	$AppTypeID = (false === $AppTypeID) ? WxAppTypeID($AppID) : $AppTypeID;
	switch($AppTypeID){
		case 1: //微活动
			$url = WxLotteryUrl($AppID);
			break;
		case 2: //微投票
			$url = WxVoteUrl($AppID);
			break;
		case 5: //微调查
			$url = WxResearchUrl($AppID);
			break;
		case 6: //微会员卡
			$url = WxCardUrl();
			break;
		default:
			$url = "";
	}
	return $url;
}

//生成微信Token唯一字符串
function WxToken(){
	$name = explode('.', get_web_url());
	if( !empty( $name[1] ) ){
		$prefix = strtoupper( trim( $name[1] ) ) ;
		$prefix = str_replace('-', '', $prefix);
	}else{
		$prefix = 'YOUDIANCMS';
	}
	$token = $prefix.date('YmdHis');
	//$token必须为英文或数字，长度为3－32字符
	if( strlen($token) > 32 ){
		$token = substr($token, 0, 32);
	}
	return $token;
}

function WxAppName($appID){
	$m = D('Admin/WxApp');
	$AppName = $m->where("AppID=$appID")->getField('AppName');
	return $AppName;
}

function WxAppTypeID($appID){
	$m = D('Admin/WxApp');
	$AppTypeID = $m->where("AppID=$appID")->getField('AppTypeID');
	return $AppTypeID;
}

//微信频道Url，带wx=1后缀
function WxChannelUrl($id, $html=false, $linkurl=false, $langmark = false){
	static $_cache = array();
	if (isset($_cache[$id])){
		return $_cache[$id];
	}

	if($langmark === false){
		$prefix = LANG_PREFIX;
	}else{ //显式传入$langmark
		$prefix = $langmark != C('DEFAULT_LANG') ? '/'.$langmark : '';
	}

	$url = get_wx_url();  //返回微信绝对地址
	//如果存在欢迎页=================================================
	if($id == 1 || $id== 2) {
		$HasWelcome = file_exists( THEME_PATH.'channel/welcome.html' );
		if( $HasWelcome == false){
			$url .= $prefix;
			$url = AppendWxUrlPara($url, true);
			$_cache[$id] = $url;
			return $url;
		}
	}
	//===========================================================

	//转向链接======================================================
	if( false === $linkurl ){ //无显式参数传入
		$linkurl = ChannelLinkUrl($id);
		if( !empty( $linkurl ) ) {
			$linkurl = WxAbsoulteUrl( $linkurl );
			return AppendWxUrlPara($linkurl, true);
		}
	}else if( !empty($linkurl) ){ //有参数插入，并且不为空
		$linkurl = WxAbsoulteUrl( $linkurl );
		return AppendWxUrlPara($linkurl, true);
	}
	//============================================================

	//非转向链接的情况==============================
	if( false === $html){  //无显式参数传入
		$html = ChannelHtml($id);
	}
	//=========================================
	$url .= $prefix.'/'.$html;
	$url = AppendWxUrlPara($url, true);
	$_cache[$id] = $url;
	return $url;
}

//转化为微信绝对地址
function WxAbsoulteUrl($url){
	$resourceUrl = '';
	if(!empty($url)){
		if( strtolower( substr($url, 0, 7) ) == 'http://' || strtolower( substr($url, 0, 8) ) == 'https://'
				|| strtolower( substr($url, 0, 6) ) == 'ftp://' ){
			$resourceUrl = $url;
		}else{
			$resourceUrl = get_wx_url().$url; //必须是绝对地址
		}
	}
	return $resourceUrl;
}

//微信信息Url地址
function WxInfoUrl($id, $html=false, $linkurl=false, $langmark = false, $channelid=false){
	//转向链接======================================================
	if( false === $linkurl ){ //无显式参数传入
		$linkurl = InfoLinkUrl($id);
		if( !empty( $linkurl ) ) {
			$linkurl = WxAbsoulteUrl( $linkurl );
			return AppendWxUrlPara($linkurl, true);
		}
	}else if( !empty($linkurl) ){ //有参数插入，并且不为空
		$linkurl = WxAbsoulteUrl( $linkurl );
		return AppendWxUrlPara($linkurl, true);
	}
	//============================================================
	if($channelid !== false){
		$dir = $GLOBALS['Config']['CHANNEL_DATA'][$channelid];
	}else{
		$channelid = ChannelID($id);
		$dir = $GLOBALS['Config']['CHANNEL_DATA'][$channelid];
	}
	if( empty($dir) ) $dir = 'info';
	
	if($langmark === false){
		$prefix = LANG_PREFIX;
	}else{ //显式传入$langmark
		$prefix = $langmark != C('DEFAULT_LANG') ? '/'.$langmark : '';
	}
	$url = get_wx_url();  //返回微信绝对地址
	//非转向链接的情况
	if( false === $html){  //无显式参数传入
		$html = InfoHtml($id);
		if( !empty($html) ) $id = $html;
	}else if( !empty($html) ){ //显式传参
		$id = $html;
	}
	$url .= "{$prefix}/{$dir}/{$id}";
	$url = AppendWxUrlPara($url, true);
	return $url;
}

//菜单颜色
function WxMenuTypeColor($MenuID){
	$color = array(
			1=>'#000000',  2=>'#90F',  3=>'blue',  4=>'green',  5=>'#630',
			6=>'red',  7=>'#960', 8=>'#F90',
	);
	if( isset($color[$MenuID]) ){
		return $color[$MenuID];
	}else{
		return '#000000'; //默认为黑色
	}
}

//判断微信用户的ID是否有效
function wxUserExist($fromUser){
	$m = D('Admin/Member');
	$b = $m->wxUserExist($fromUser);
	return $b;
}

//微信实用函数end==============================================

//模板实用函数start==============================================
function Left($str, $len = 0, $suffix='...'){
	if( $len <= 0 ) return $str;
	if( LANG_SET == 'en'){
		$len *= 2;  //英文长度自动加倍
	}
	$n = mb_strlen( $str , 'utf-8');  //获取实际内容的长度
	if( $n > $len ){ //截取字符串
		$str = msubstr( $str, 0, $len, 'utf-8', $suffix);
	}
	$str = yd_close_tags($str);//补齐Html标签
	return $str;
}

//返回默认图片url
function DefaultPicture($url, $default='1'){
	if( strlen(trim($url)) <= 0 ){
		$k = get_language_mark();
		$nopic = APP_TMPL_PATH."Public/Images/nopic$k.jpg";
		$nopic_p = get_web_root().$nopic;
		if( !file_exists( $nopic_p ) ){
			$nopic = __ROOT__.'/Public/Images/nopic/'.$default.$k.'.jpg';
		}
		return $nopic;
	}
	return $url;
}

/**
 * 返回默认头像
 */
function DefaultAvatar($url){
	if( strlen(trim($url)) <= 0 ){
		$nopic = APP_TMPL_PATH."Public/Images/noavatar.png";
		$nopic_p = get_web_root().$nopic;
		if( !file_exists( $nopic_p ) ){
			$nopic = __ROOT__.'/Public/Images/nopic/noavatar.png';
		}
		return $nopic;
	}
	return $url;
}


//获取手机网站频道图标
function WapChannelIcon($ChannelID, $default='default.jpg'){
	$icon = APP_TMPL_PATH."Public/images/icon/$ChannelID.jpg";
	$icon_p = get_web_root().$icon;
	if( !file_exists( $icon_p ) ){
		$icon = APP_TMPL_PATH."Public/images/icon/$default";
	}
	return $icon;
}

function WapChannelIconPng($ChannelID, $default='default.png'){
	$icon = APP_TMPL_PATH."Public/images/icon/$ChannelID.png";
	$icon_p = get_web_root().$icon;
	if( !file_exists( $icon_p ) ){
		$icon = APP_TMPL_PATH."Public/images/icon/$default";
	}
	return $icon;
}

//返回对应频道模型ID对应的颜色
function ChannelModelColor($ChannelModelID){
	//30文章,31图片,32单页,33链接,34视频,35下载,36产品
	$color = array(
			30=>'#000000',  31=>'#90F',  32=>'blue',  33=>'red',  34=>'#630',
			35=>'#666',  36=>'green', 37=>'#960', 38=>'#000000',    39=>'#000000',
	);
	if( isset($color[$ChannelModelID]) ){
		return $color[$ChannelModelID];
	}else if($ChannelModelID < 30){
		return '#999';
	}else{
		return '#000000'; //默认为黑色
	}
}

/**
 * 替换图片中的src属性，主要用于辅助实现按需加载图片
 * @param string $content
 * @param string $replacement src被替换为这个字符串
 */
function ImageSrcReplace($content, $replacement='data-original='){
	if( stripos($content, '<img') > 0){
		$content = preg_replace('/(<img.+)src=/iU', '$1 '.$replacement, $content);
	}
	return $content;
}
//实用函数End==================================================

//判断是否需要缓存，仅用于ReadHtmlCacheBehavior
function requireCache(){
	$m = strtolower( MODULE_NAME );
	$a = strtolower( ACTION_NAME );
	//首页========================================
	if( $m == 'index' && $a == 'index'){
		$ChannelID = LANG_ID;
		$IsHtml = get_single_value($ChannelID, 'Channel', 'IsHtml');
		return ($IsHtml == 1) ? true : false;
	}
	//===========================================
	
	//频道主页======================================
	if( $m == 'channel' && $a == 'index'){
		$m = D('Admin/Channel');
		$IsHtml = $m->IsHtmlByHtml( $_GET['id'] );
		return ($IsHtml == 1) ? true : false;
	}
	//===========================================
	
	//信息主页======================================
	if( $m == 'info' && $a == 'read'){
		$m = D('Admin/Info');
		$IsHtml = $m->getIsHtml( $_GET['id']  );
		return ($IsHtml == 1) ? true : false;
	}
	//============================================
}

//百度翻译
function baiduTranslate($content, $from='zh', $to = 'en'){
	if( empty($content) || is_numeric($content)){
		$data["Status"] = 1;
		$data["Content"] = $content;
		return $data;
	}
	//为了翻译正常，对待翻译的数据做预处理===================================
	//翻译：<img src='1.jpg' title='my img' />计算 签名";
	//结果：<img src='1.jpg' title='my img' />signature calculation
	//翻译html标记存在的问题：在翻译img，属性值用单引号包含，百度翻译标签可能会删除里面的空格
	//翻译图片会存在问题，因此翻译前做替换
	$content = strip_tags($content, "<img><br><br/><videoplayer>");
	$pattern = array(
			'/<videoplayer\s+?[^>]*?[\/]?>/i',
			'/<img\s+?[^>]*?[\/]?>/i'
	);
	$search = array();
	$replace = array();
	foreach($pattern as $k=>$p){
		$n = preg_match_all($p, $content, $matchs);
		if( $n > 0 ){
			$i = 0;
			foreach ($matchs[0] as $v){
				$search[] = $v;
				$replace[]= '{['.$k.$i.']}';
				$i++;
			}
			$content = str_ireplace($search, $replace, $content);
		}
	}
	//==============================================================
	//翻译常量定义
	$apiurl = "http://api.fanyi.baidu.com/api/trans/vip/translate";
	$appid  = $GLOBALS['Config']['BAIDU_TRANSLATE_APPID'];
	$apikey = $GLOBALS['Config']['BAIDU_TRANSLATE_APIKEY'];
	$timeout = 30; //超时时间，单位：秒

	$text = baiduSplit($content, 5000); //$maxBytes = 5800; //单次请求不能超过6000字节
	$nSize = count($text);
	$data = array();
	for($j=0; $j < $nSize; $j++){
		$myText = trim($text[$j]);
		if( strlen($myText) == 0 ) continue;
		$salt = rand(10000,99999);
		$sign = md5($appid . $myText . $salt . $apikey); //计算签名（appid+q+salt+密钥）
		$p = array('appid'=>$appid,'q'=>$myText, 'salt' => $salt , 'from'=>$from, 'to'=>$to, 'sign'=>$sign);
		$result = yd_curl_post($apiurl, $p, $timeout);
		$result = json_decode($result, true);
		if(empty($result)){
			$data["Status"] = 0;
			$data["ErrorMessage"] = "翻译结果为空，可能是内容有乱码";
		}else if( !isset($result['error_code']) ){ //如果翻译出错，返回：{"error_code":"52003","error_msg":"UNAUTHORIZED USER"}
			$data["Status"] = 1;
			$n = count($result['trans_result']);
			for($i=0;$i<$n;$i++){
				$data['Content'] .= $result['trans_result'][$i]['dst'];
				if($i != $n-1 ){  //段落之间必须加上回车
					$data['Content'] .= "<br/>";
				}
			}
			//反向替换图片
			$data['Content'] = str_ireplace($replace, $search, $data['Content']);
		}else{
			$code = array(
				'52000'=>'成功',
				'52001'=>'请求超时, 请重试',
				'52002'=>'系统错误, 请重试',
				'52003'=>'未授权用户, 请检查您的appid是否正确',
				'54000'=>'必填参数为空, 请检查是否少传参数',
				'58000'=>'客户端IP非法	检查您填写的IP地址是否正确, 请可修改您填写的服务器IP地址',
				'54001'=>'签名错误, 请请检查您的签名生成方法',
				'54003'=>'访问频率受限，请降低您的调用频率',
				'58001'=>'译文语言方向不支持, 请检查译文语言是否在语言列表里',
				'54004'=>'账户余额不足, 请前往管理控制台为账户充值',
				'54005'=>'长query请求频繁, 请降低长query的发送频率，3s后再试',
			);
			$error_code = $result['error_code'];
			$data["Status"] = 0;
			$data["ErrorMessage"] = isset( $code[$error_code] ) ? $code[$error_code] : '翻译异常';
		}
	} //for end
	return $data;
}

//单次翻译有最大值限制，必须将长文本分块
function baiduSplit($content, $max = 5000){
	$totalBytes = strlen($content);
	if( $totalBytes > $max){
		$delimiter = array(',', '.', '，', '。', "\r\n","\n"); //在标点符号处截断，不会影响翻译
		$prePos = 0;         //上一次位置
		$curPos = $max;  //当前位置
		$maxOffset = $totalBytes + $max;
		while($curPos <= $maxOffset){
			$offset = $curPos - $totalBytes;
			foreach ($delimiter as $d){
				$pos = strrpos($content, $d, $offset);
				if($pos !== false || $pos > $prePos ) break; //一旦发现，跳出
			}
			if( $pos !== false && $pos > $prePos ) $curPos = $pos;
			$len = $curPos - $prePos;
			$text[] = substr($content, $prePos, $len);
			$prePos = $curPos; //记住上一次的位置
			$curPos += $max;
		}
	}else{
		$text[] = $content;
	}
	return $text;
}

//to 收件人帐号,多个帐号以逗号,分开
function sendwebmail($to, $title, $body){
	if( empty($to) || empty($title) || empty($body)) return false;
	$from = $GLOBALS['Config']['EMAIL_ACCOUNT'];  //发件人账号
	$fromname = $GLOBALS['Config']['EMAIL_SENDER'];  //发件人姓名
	$smtp = $GLOBALS['Config']['EMAIL_SMTP'];
	$pwd = $GLOBALS['Config']['EMAIL_PASSWORD'];
	$port = $GLOBALS['Config']['EMAIL_PORT'];
	$way = $GLOBALS['Config']['EMAIL_WAY'];
	$b = sendmail($from, $fromname, $to, $title, $body, $from, $pwd, $smtp, false, false, $port, $way);
	return $b;
}

/**
 * 
 * @param string 发件人账号
 * @param string 发件人姓名
 * @param mix to 收件人帐号,多个帐号以逗号,分开
 * @param string $title 邮件标题
 * @param string $body 内容
 * @param string $usename  邮箱账号
 * @param string $usepassword  邮箱密码
 * @param string $smtp  smtp服务器
 * @param string $repto
 * @param string $repname
 * @return boolean
 */
function sendmail($from, $fromname, $to, $title, $body, $usename, $usepassword, $smtp, $repto=false, $repname=false, $port=25, $way='tls'){
	ini_set("max_execution_time", "30000");
	include_once('./App/Lib/Common/class.phpmailer.php');
	$mail   = new PHPMailer();
	//$mail->SMTPDebug  = true;
	$mail->CharSet    = "UTF-8"; // charset
	$mail->Encoding   = "base64";

	$mail->IsSMTP(); // telling the class to use SMTP

	//system
	$mail->Port       = $port;
	if(stripos($smtp,'.gmail.com')===false){
		$mail->SMTPSecure = ($way=='tls') ? '' : "ssl";
		$mail->Host       = $smtp; // SMTP server
	}else{
		$mail->Host       = $smtp; // SMTP server
		$mail->SMTPSecure = "ssl";
		//$mail->Host       = 'ssl://'.$smtp; // SMTP server
	}

	$mail->SMTPAuth   = true;
	$mail->Username   = $usename; // SMTP account username
	$mail->Password   = $usepassword;        // SMTP account password

	$mail->From       = $from;//send email
	$mail->FromName   = $fromname; //name of send

	//repet
	if($repto!=""){
		$name = isset($repname)?$repname:$repto;
		$mail->AddReplyTo($repto, $name);
	}
	$mail->WordWrap   = 50; // line

	//title
	$mail->Subject		= (isset($title)) ? $title : '';//title


	//$mail->AltBody    = "To view the message, please use an HTML compatible email viewer!"; //

	//body
	//$body  = eregi_replace("[\]",'',$body);
	//已经被PHP7 废弃eregi_replace
	$body  = preg_replace("/\\\/",'',$body); //Remove backslashes
	$mail->MsgHTML($body);

	//to
	if($to){
		$address = explode(",",$to);
		foreach($address AS $key => $val){
			if( yd_is_email($val) ){  //邮件有效才添加
				$mail->AddAddress($val, "");
			}
		}
	}
	//send attech
	//if(isset($data['attach']))
	//{
	//$attach = explode("|",$data['attach']);
	//foreach($attach AS $key => $val)
	//{
	//$mail->AddAttachment($val,"");             // attech
	//}
	//}
	if(!@$mail->Send()) {
		$mail->SmtpClose();
		//return "Mailer Error: " . $mail->ErrorInfo;
		define('PHP_MAILER_ERROR', $mail->ErrorInfo);
		return false;
	} else {
		$mail->SmtpClose();
		//return "Message sent!";
		define('PHP_MAILER_ERROR', '');
		return true;
	}
}

//判断now是否位于[start,end]
//$start:开始时间，$end:结束时间, $now:未指定则为当前时间
function isTimeRange($start, $end, $now=false){
	$flag = 0;
	$s = strtotime($start);
	$e = strtotime($end);
	$n = ($now === false) ? time() : strtotime($now);
	if($n < $s){
		$flag = -1;
	}else if($n>$e){
		$flag = 1;
	}else{
		$flag = 0; //位于范围内
	}
	return $flag;
}

//根据模型，获取所有数据
function getAllInfo(&$data, $ChannelModelID=6){
	$m = D('Admin/Attribute');
	$Attribute = $m->getAttribute( $ChannelModelID );
	$f = array();
	foreach($Attribute as $a){
		if( $a['FieldName'] != 'GuestName'){
			$name = explode(',', $a['DisplayName']);
			$f[] = array( 'FieldName'=>$a['FieldName'], 'DisplayName'=>$name[0] );
		}
	}
	unset($Attribute);
	$n = count($data);
	for($i = 0; $i<$n; $i++){
		foreach($f as $v){
			if(!empty($data[$i][$v['FieldName']])){
				$value = $data[$i][$v['FieldName']];
				$suffix = strtolower( substr($value, -4) );
				if( $suffix == '.jpg' || $suffix == '.png' || $suffix == '.gif'){
					$value = "<a href='{$value}' target='_blank'><img src='{$value}' class='autoimg' /></a>";
				}
				$data[$i]['AllInfo'] .= "<b class='displayname'>{$v['DisplayName']}：</b>{$value}<br/>";
			}
		}
	}
}

//解析微信应用参数开始========
//$out:传入数组，用于输出
function parseAppParameter($parameter, $type, &$out){
	$p = explode('@@@', $parameter);
	switch($type){
		case 1:  //微活动
			$out['LotteryType'] = $p[0];
			$out['LotteryIntroduction'] = $p[1];
			$out['LotteryDescription'] = $p[2];
			$out['LotteryStartTime'] = $p[3];
			$out['LotteryEndTime'] = $p[4];
			
			$out['LotteryRepeatTip'] = $p[5];
			$out['LotteryStartPicture'] = $p[6];
			$out['LotteryEndPicture'] = $p[7];
			$out['LotteryEndTitle'] = $p[8];
			$out['LotteryEndDescription'] = $p[9];
				
			$out['LotteryAward1'] = $p[10];
			$out['LotteryAward1Num'] = $p[11];
			$out['LotteryAward1Probability'] = $p[12];
			
			$out['LotteryAward2'] = $p[13];
			$out['LotteryAward2Num'] = $p[14];
			$out['LotteryAward2Probability'] = $p[15];
			
			$out['LotteryAward3'] = $p[16];
			$out['LotteryAward3Num'] = $p[17];
			$out['LotteryAward3Probability'] = $p[18];
			
			$out['LotteryMax'] = $p[19];
			$out['LotteryPassword'] = $p[20];
			
			$out['LotteryDayMax'] = $p[21];
			$out['LotteryTip'] = $p[22];
		case 5:  //微调查
			//0图片封面@@@1开始说明@@@2开始说明@@@3开始时间@@@4结束时间@@@5转向链接@@@6图文描述@@@7是否匿名
			$out['ResearchPicture'] = $p[0];
			$out['StartDescription'] = $p[1];
			$out['EndDescription'] = $p[2];
			$out['StartTime'] = $p[3];
			$out['EndTime'] = $p[4];
			$out['LinkUrl'] = $p[5];
			$out['ResearchDescription'] = $p[6];
			$out['IsAnonymous'] = $p[7];
			break;
		case 6: //微会员卡
			//0名称@@@1图标@@@2背景@@@3封面图片@@@4封面消息@@@5卡号文字颜色@@@6名称文字颜色
			//@@@7使用说明@@@8积分规则说明@@@9签到奖励@@@10消费奖励
			//@@@11商家名称@@@12商家简介@@@13联系方式@@@14商家地址@@@15经度@@@16纬度@@@17商家确认消费密码
			//@@@分店列表(StoreID###StoreName###StoreTelephone###StoreAddress$$$)
			//@@@业务关联LinkName###LinkType###LinkUrl$$$
			$out['CardName'] = $p[0];
			$out['CardIcon'] = $p[1];
			$out['CardBackground'] = $p[2];
			$out['CardPicture'] = $p[3];
			$out['CardTip'] = $p[4];
			
			$out['CardNumberColor'] = $p[5];
			$out['CardNameColor'] = $p[6];
			$out['CardDescription'] = $p[7];
			$out['ScoreDescription'] = $p[8];
			$out['SignAward'] = $p[9];
			
			$out['ConsumeAward'] = $p[10];
			$out['MerchantName'] = $p[11];
			$out['MerchantDescription'] = $p[12];
			$out['MerchantTelephone'] = $p[13];
			$out['MerchantAddress'] = $p[14];
			
			$out['Longitude'] = $p[15];
			$out['Latitude'] = $p[16];
			$out['CardPassword'] = $p[17];
			
			if( !empty($p[18]) ){
				$store = (array)explode('$$$', $p[18]);
				foreach($store as $it){
					$t = (array)explode('###', $it);
					$out['Store'][]=array(
							'StoreID'=>$t[0], 
							'StoreName'=>$t[1], 
							'StoreTelephone'=>$t[2], 
							'StoreAddress'=>$t[3]
					);
				}
			}
			
			if( !empty($p[19]) ){
				$link = (array)explode('$$$', $p[19]);
				foreach($link as $it){
					$t = (array)explode('###', $it);
					$out['Link'][]=array(
							'LinkName'=>$t[0],
							'LinkType'=>$t[1],
							'LinkUrl'=>$t[2]
					);
				}
			}
			
		case 2:  //微调查
			//是否多选@@@开始时间@@@结束时间@@@选项@@@图片@@@结果显示
			$out['IsMultiple'] = $p[0];
			$out['StartTime'] = $p[1];
			$out['EndTime'] = $p[2];
			$out['VotePicture'] = $p[4];
			$out['ShowResult'] = $p[5];
			$temp = (array)explode('$$$', $p[3]);
			foreach ($temp as $it){
				$tt = (array)explode('###', $it);
				$out['Item'][] = array('ItemID'=>$tt[0],'ItemName'=>$tt[1]);
			}
			break;
	}
}
//解析微信应用参数结束========

/**
 * 用于解析内容中的标签，仅支持及少数标签
 * 目前支持的标签右：videoplayer
 * @param string $content
 */
function ParseTag($content){
	$start = stripos($content, '<videoplayer');
	while ( $start !== false ){
		$posEnd = stripos($content, '/>', $start);
		$length = $posEnd - $start + 2;
		$tag = substr($content, $start, $length);
		$xml = simplexml_load_string($tag);
		if($xml) {
			$attr = (array)($xml->attributes());
			$attr= array_change_key_case($attr['@attributes']);
			import("@.Common.YdVideoPlayer");
			$v = new YdVideoPlayer( $attr );
			$html = $v->render();
			$content = substr_replace($content, $html, $start, $length);
		}
		$start = stripos($content, '<videoplayer', $posEnd);
	}
	return $content;
}

//购物车模块===================================
//获取购物车数据
function get_cart(){
	import("@.Common.YdCart");
	$cart = YdCart::getInstance();
	$data = $cart->getAll();
	return $data;
}
//收货时间时间列表
function get_deliverytime(){
	$m = D('Admin/DeliveryTime');
	$data = $m->getDeliveryTime(1);
	return $data;
}
//配送方式
function get_shipping(){
	$m = D('Admin/Shipping');
	$p['IsEnable'] = 1;
	$data = $m->getShipping($p);
	return $data;
}

//收货人信息
function get_consignee(){
	$m = D('Admin/Consignee');
	$p['MemberID'] = session('MemberID');
	$p['IsEnable'] = 1;
	$data = $m->getConsignee($p);
	return $data;
}

//分销商等级
function get_distributorlevel(){
	$m = D('Admin/DistributorLevel');
	$data = $m->getDistributorLevel();
	return $data;
}

//获取现金类型
function get_cashtype(){
	$m = D('Admin/Cash');
	$data = $m->getCashType();
	return $data;
}

//支付方式 $sitetype 1:都可以，2：电脑，3：手机
function get_pay($sitetype, $isOnline=-1){
	$m = D('Admin/Pay');
	$p['IsEnable'] = 1;
	$p['SiteType'] = $sitetype;
	$p['IsOnline'] = $isOnline;
	$data = $m->getPay($p);
	$pay = array();
	$n = count($data);
	
	//微信客户端不能用支付宝，手机端模板代码里控制不能使用微信支付
	if( stripos($_SERVER['HTTP_USER_AGENT'],"MicroMessenger") ){
		$blacklist = array(1); //微信端支付黑名单，1:支付宝
		for($i = 0; $i < $n; $i++){
			if( !in_array($data[$i]['PayTypeID'], $blacklist)){
				$pay[] = $data[$i];
			}
		}
		return $pay;
	}else if( yd_is_mobile() ){ //如果是移动端
		$blacklist = array(10); //微信端支付黑名单，10:微支付
		for($i = 0; $i < $n; $i++){
			if( !in_array($data[$i]['PayTypeID'], $blacklist)){
				$pay[] = $data[$i];
			}
		}
		return $pay;
	}else{
		return $data;
	}
}

//当前会员可用优惠券列表
function get_coupon(){
	$MemberID = session("MemberID");
	if( empty($MemberID) ) return false;
	$m = D('Admin/CouponSend');
	$data = $m->getAvailableCoupon($MemberID);
	return $data;
}

//支付类别
function get_pay_type(){
	$m = D('Admin/PayType');
	$data = $m->getPayType(1);
	return $data;
}

//获取价格区间
function get_price_range($channelid=-1, $count=5){
	$m = D('Admin/Info');
	$row = $m->getMinMaxPrice($channelid);
	$min = $row['MinPrice'];
	$max = $row['MaxPrice'];
	if( $count == 1){
		$data[] = array('MinPrice'=>$min, 'MaxPrice'=>$max);
		return $data;
	}
	
	$price_grade = 0.0001;
	$n = log10( $max );
	for($i = -2; $i <= $n; $i++){
		$price_grade *= 10;
	}
	
	//计算价格跨度：取整( (最大值-最小值) / 分级数 / 数量级 ) * 数量级
	$span = ceil( ($max - $min) / $count / $price_grade ) * $price_grade;
	if($span == 0) $span = $price_grade;
	
	//计算新的最小最大值
	for($i = 1; $min > $span * $i; $i ++);
	for($j = 1; $min > $span * ($i-1) + $price_grade * $j; $j++);
	$new_min = $span * ($i-1) + $price_grade * ($j - 1);
	for(; $max >= $span * $i; $i ++);
	$new_max = $span * ($i) + $price_grade * ($j - 1);
	
	$new_grade = round( ($new_max-$new_min)/$count );
	if($new_grade <= 0 ) $new_grade = 1; //必须添加，否则$new_grade=0时，会死循环
	for($start = $new_min; $start < $new_max; $start += $new_grade){
		if( $start >= $max ) break; //解决"当价格=最大值时，分级会多出来"的bug
		$data[] = array('MinPrice'=>$start, 'MaxPrice'=>$start+$new_grade);
	}
	return $data;
}

//获取订单状态
function get_order_status(){
	$data = array(
			1=>array('OrderStatusID'=>1, 'OrderStatusName'=>'新订单', 'MemberOrderStatusName'=>'等待付款'),
			2=>array('OrderStatusID'=>2, 'OrderStatusName'=>'已付款', 'MemberOrderStatusName'=>'待发货'),
			3=>array('OrderStatusID'=>3, 'OrderStatusName'=>'已发货', 'MemberOrderStatusName'=>'待收货'),
			
			4=>array('OrderStatusID'=>4, 'OrderStatusName'=>'退款', 'MemberOrderStatusName'=>'已退款'),
			5=>array('OrderStatusID'=>5, 'OrderStatusName'=>'退货', 'MemberOrderStatusName'=>'已退货'),
			
			6=>array('OrderStatusID'=>6, 'OrderStatusName'=>'结单', 'MemberOrderStatusName'=>'已完成'),
			7=>array('OrderStatusID'=>7, 'OrderStatusName'=>'作废', 'MemberOrderStatusName'=>'已作废'),
			8=>array('OrderStatusID'=>8, 'OrderStatusName'=>'已取消', 'MemberOrderStatusName'=>'已取消'),
	);
	return $data;
}

//通过js获取json数据
function JsonUrl(){
	$url = __GROUP__.'/public/getJson/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}
//购物车Url
function CartUrl(){
	$url = __GROUP__.'/public/cart/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}
//结算地址
function CheckoutUrl(){
	$url = __GROUP__.'/public/checkout/l/'.LANG_SET;
	return AppendWxUrlPara($url);
}

//支付页面地址，在Wap、Member分组也可能会调用到
function PayUrl($orderid=''){
	if(GROUP_NAME == 'Member'){
		if( MODULE_NAME == 'Mobile' ){ //手机会员端
			$protocol = get_current_protocal();
			$domain = strtolower(get_wap_domain());
			$url = !empty($domain) ? $protocol.$domain.__APP__ : __APP__.'/wap';
			$url .= '/public/pay?l='.LANG_SET;
		}else{
			$url = __APP__.'/public/pay?l='.LANG_SET;
		}
	}else{
		$url = __GROUP__.'/public/pay?l='.LANG_SET;
	}
	if( !empty($orderid) ) $url .="&orderid={$orderid}";
	return $url;
}

function getOrderStatusUrl($orderid=false){
	$url = __GROUP__.'/public/getOrderStatus/l/'.LANG_SET;
	if( !empty($orderid) ) $url .="/orderid/{$orderid}";
	return $url;
}

//立即支付
function PayNowUrl($orderid=false, $payid=false){
	$url = __GROUP__.'/public/payNow?l='.LANG_SET;
	if( !empty($orderid) ) $url .="&orderid={$orderid}";
	if( !empty($payid) ) $url .="&payid={$payid}";
	return $url;
}

//结算地址
function SaveCheckoutUrl(){
	$url = __GROUP__.'/public/saveCheckout/l/'.LANG_SET;
	return $url;
}

//检查线下优惠券代码
function CheckCouponCodeUrl(){
	$url = __GROUP__.'/public/checkCouponCode/l/'.LANG_SET;
	return $url;
}

function CheckPointUrl(){
	$url = __GROUP__.'/public/checkPoint/l/'.LANG_SET;
	return $url;
}

//添加到购物车Url
function AddCartUrl($InfoID=false){
	$url = __GROUP__.'/public/addCart/l/'.LANG_SET;
	if( is_numeric($InfoID)){
		$url .= '/id/'.$InfoID;
	}
	return AppendWxUrlPara($url);
}
//删除购物车商品
function DeleteCartUrl($InfoID=false){
	$url = __GROUP__.'/public/deleteCart/l/'.LANG_SET;
	if( is_numeric($InfoID)){
		$url .= '/id/'.$InfoID;
	}
	return AppendWxUrlPara($url);
}

function _quantityUrl($type=1, $InfoID=false, $n=false){
	switch($type){
		case 2: //+
			$url = __GROUP__.'/public/incQuantity/l/'.LANG_SET;
			break;
		case 3: //-
			$url = __GROUP__.'/public/decQuantity/l/'.LANG_SET;
			break;
		default: //set
			$url = __GROUP__.'/public/setQuantity/l/'.LANG_SET;
			if( is_numeric($n)){
				$url .= '/quantity/'.$n;
			}
	}
	if( is_numeric($InfoID)){
		$url .= '/id/'.$InfoID;
	}
	$url = AppendWxUrlPara($url);
	return $url;
}
//设置商品数量
function SetQuantityUrl($InfoID=false, $n=false){
	return _quantityUrl(1, $InfoID, $n);
}
//增加商品数量
function IncQuantityUrl($InfoID=false){
	return _quantityUrl(2, $InfoID);
}
//减少商品数量
function DecQuantityUrl($InfoID=false){
	return _quantityUrl(3, $InfoID);
}
//清空购物车
function ClearCartUrl(){
	$url = __GROUP__.'/public/clearCart/l/'.LANG_SET;
	return $url;
}
function ClearHistoryUrl(){
	$url = __GROUP__.'/public/clearHistory/l/'.LANG_SET;
	return $url;
}
//购物车总金额
function TotalPrice(){
	import("@.Common.YdCart");
	$cart = YdCart::getInstance();
	$total = $cart->getTotalPrice();
	return $total;
}
function TotalItemCount(){
	import("@.Common.YdCart");
	$cart = YdCart::getInstance();
	$total = $cart->getItemCount();
	return $total;
}
//生成支付二维码图片，url: weixin：//wxpay/s/An4baqw
function PayQrcode($url, $size=7){
	import("@.Common.phpqrcode");
	//容错率，也就是有被覆盖的区域还能识别，分别是 
	//L（QR_ECLEVEL_L，7%），M（QR_ECLEVEL_M，15%），Q（QR_ECLEVEL_Q，25%），H（QR_ECLEVEL_H，30%）； 
	$errorCorrectionLevel = 'H';
	$dir = RUNTIME_PATH.'qrcode/';
	if( !file_exists($dir)){
		@mkdir($dir,0755,true);
	}
	$fileName = $dir.md5($url).'.png';
	//生成二维码图片
	QRcode::png($url, $fileName, $errorCorrectionLevel, $size, 1);
	$fileName = __ROOT__.substr($fileName, 1);
	return $fileName;
}

/*
 * 微信公众号支付授权目录
 */
function WeixinPayDir(){
	$protocol = get_current_protocal();
	$domainWap = strtolower(get_wap_domain());
	if( !empty($domainWap) ){
		$url = $protocol.$domainWap.__APP__.'/public/';
	}else{
		$url = $protocol.$_SERVER['HTTP_HOST'].__APP__.'/wap/public/';
	}
	return $url;
}

/*
 * 微信公众号支付授权目录(用于手机后台的会员充值)
 */
function WeixinRechargeDir(){
	$protocol = get_current_protocal();
	$domainWap = strtolower(get_wap_domain());
	if( !empty($domainWap) ){
		$url = $protocol.$domainWap.__APP__.'/Member/Mobile/recharge/';
	}else{
		$url = $protocol.$_SERVER['HTTP_HOST'].__APP__.'/Member/Mobile/recharge/';
	}
	return $url;
}

/*
 * 微信公众号支付回调域名
 */
function WeixinPayOAuthDomain(){
	$domain = get_wap_domain();
	if( empty($domain) ){
		$domain = $_SERVER['HTTP_HOST'];
	}
	$domain = strtolower($domain);
	return $domain;
}

/**
 * 第三方登录回调地址
 * @param string $groupName 分组名称
 */
function OauthCallback($groupName='Home'){
	$url = get_current_protocal();
	if($groupName=='Home'){
		$domain = $_SERVER['HTTP_HOST'];
		$url .= $domain.__APP__;
	}else{
		$domain = strtolower(get_wap_domain());
		if( !empty($domain) ){
			$url .= $domain.__APP__;
		}else{
			$url .= $_SERVER['HTTP_HOST'].__APP__.'/wap';
		}
	}
	$url .='/public/oauth';
	return $url;
}

/**
 * 判断当前支付是否是跳转支付
 * @param int $type
 */
function IsRedirectPay($type){
	$list = array(1, 2, 3, 4, 8, 9);
	return in_array($type, $list);
}
//==========================================

/**
 * 获取七牛域名
 */
function get_qiniu_url(){
	$url = '';
	if(GROUP_NAME=='Home' || GROUP_NAME=='Wap'){
		$QiniuEnable = $GLOBALS['Config']['QiniuEnable'];
		//仅对Home和Wap分组有效
		if($QiniuEnable==1){
			$url = $GLOBALS['Config']['QiniuUrl'];
		}
	}
	return $url;
}

/**
 * 获取访问者的网址或域名(包含端口号)
 */
function get_current_url($hasProtocal=true){
	$url = '';
	if($hasProtocal){
		$url = get_current_protocal();
	}
	//当非80端口时：_SERVER["HTTP_HOST"] 会输出端口号，例如：xx.net:8080
	$url .= $_SERVER['HTTP_HOST'];
	//$port = $_SERVER["SERVER_PORT"];
	//if( !empty($port) && $port != 80 ){
	//	$url .= ':'.$port;
	//}
	return $url;
}

/**
 * 推送信息给百度
 * @param int $InfoID
 */
function baidu_push_info($InfoID){
	$result = "";
	if( isset($_POST['InfoTime']) && empty($_POST['LinkUrl']) ){
		//定时发布的文章不提交到百度
		$diff = time() - strtotime($_POST['InfoTime']);
		if( $_POST['IsEnable']==1 &&  $_POST['IsCheck']==1 && $diff>=0){
			$result = baidu_push_content($InfoID, 1);
		}
	}
	return $result;
}

/**
 * 推送信息给百度
 * @param int $InfoID
 */
function baidu_push_channel($ChannelID){
	$result = "";
	if( empty($_POST['LinkUrl']) && $_POST['IsEnable']==1 ){
		$result = baidu_push_content($ChannelID, 2);
	}
	return $result;
}

/**
 * 百度推送信息或文章
 * @param int $id
 * @param int $type
 */
function baidu_push_content($id, $type=1){
	$enable = &$GLOBALS['Config']['BaiduPushEnable'];
	$msg = "";
	if(!empty($enable) && $id>0){
		$domain = get_current_url();
		if($type==1){ //信息
			$url = $domain.InfoUrl($id);
		}else{ //频道
			$url = $domain.ChannelUrl($id);
		}
		$result = baidu_push($url);
		if( isset($result['error']) ){
			$msg = "<span style='color:red;'>百度推送失败，{$result['message']}<span>";
		}else{
			$msg = "<span style='color:green;'>百度推送成功！<span>";
		}
	}
	return $msg;
}

/**
 * 将网址推送到百度
 * @param string/array $url 支持单个网址推送、多个网址推送（已回车隔开）、数组
 * 没有启用返回false
 */
function baidu_push($url){
	/*
	 * 推送成功推送失败
		字段	                是否必选	参数类型	说明
		success	            是	             int	成功推送的url条数
		remain	            是          	 int	当天剩余的可推送url条数
		not_same_site	否	             array	由于不是本站url而未处理的url列表
		not_valid	        否	             array	不合法的url列表
		
		推送失败
		字段	    是否必传	类型	    说明
		error	        是	        int	    错误码，与状态码相同
		message	是	        string	错误描述
	 */
	//数组分离
	if( is_string($url)){
		$url = str_replace("\r\n", "\n", $url);
		$url = str_replace("\r", "\n", $url);
		$url = explode("\n", trim($url));
	}
	//去重
	$url = array_unique($url);
	//删除无效网址
	$data = array();
	foreach ($url as $v){
		if( 'http' == strtolower(substr($v, 0, 4)) ){
			$data[] = $v;
		}
	}
	$token = &$GLOBALS['Config']['BaiduPushToken'];
	if(empty($token)) {
		return array('error'=>'901', 'message'=>'token为空');
	}
	$domain = get_current_url(false); //域名先已经在站长平台进行过登记
	//$domain = "www.csyoudian.com";
	$api = "http://data.zz.baidu.com/urls?site={$domain}&token={$token}";
	//if(!is_array($url)) $url = array($url); //不是数组转换为数组
	$data = implode("\n", $data);  //2019-01-03必须添加此语句才正常，之前没有
	$result = yd_curl_post($api, $data);
	if(!empty($result)){
		$result = json_decode($result, true);
	}else{
		$result = array('error'=>'902', 'message'=>'curl_post返回空');
	}
	return $result;
}

//=============APP 相关函数 开始===================
/**
 * 将url转化为全路径
 * @param string $url
 * @param string $domain
 */
function app_to_fullurl($url, $domain=false){
	//表示为相对地址需要转换，为空时不需要转换
	if( !empty($url) && substr($url, 0, 1) == '/' ){ 
		if(empty($domain)) $domain = get_current_url();
		$url = $domain.$url;
	}
	return $url;
}

/**
 * 移除域名前缀 http://www.x.com/Upload/1.jgp 转化为：/Upload/1.jpg
 * @param string $url
 * @param string $domain
 * @return string
 */
function app_remove_domain($url, $domain=false){
	if( !empty($url) && strtolower(substr($url, 0, 4))  == 'http' ){
		if(empty($domain)) $domain = get_current_url();
		$url = str_ireplace($domain, '', $url);
		$url = trim($url);
	}
	return $url;
}

/**
 * 生成App播放器代码
 * @param string $url 本地路径或优酷或土豆的路径
 * @return string
 */
function app_video_player($url, $domain=false){
	if( substr($url, 0, 1) == '/' ){ //表示为相对地址，一定是本地视频文件
		if(empty($domain)) $domain = get_current_url();
		$url = $domain.$url;
		$player = "<video class='app_video_player' src='{$url}' controls='controls' autoplay='autoplay'></video>";
	}else{
		//第三方播放平台
		$player = "<iframe class='app_video_player' src='{$url}'  allowtransparency='true' allowfullscreen='true' ";
		$player .= "allowfullscreenInteractive='true' scrolling='no' border='0' frameborder='0'></iframe>";
	}
	return $player;
}

/**
 * 获取当前的协议
 */
function get_current_protocal(){
	$protocal = 'http://';
	$b = yd_is_https();
	if($b){
		$protocal = 'https://';
	}
	return $protocal;
}

/**
 * 根据邀请码，获取邀请人ID
 */
function GetInviterID(){
	$InviterID = 0;
	//小程序、APP不支持session则直接通过GET/POST传参
	if( !empty($_REQUEST['ic']) ){ 
		$code = trim($_REQUEST['ic']);
	}elseif( session("?ic") ){
		$code = trim(session("ic"));
	}else{
		$code = '';
	}
	if(!empty($code)){
		$m = D('Admin/Member');
		$code = addslashes(stripslashes($code));
		$MemberID = $m->where("InviteCode='{$code}'")->getField('MemberID');
		if($MemberID>0){
			$InviterID = $MemberID;
		}
	}
	return $InviterID;
}

//获取水印字体文件信息
function GetWaterFonts(){
	$list['simkai.ttf']="楷体";
	$data = array();
	foreach (glob("./Public/font/*.*") as $filename) {
		$FontName = basename($filename);
		$FontAlias = isset($list[$FontName]) ? $list[$FontName] : '';
		$data[]=array(
			'FontFile'=>$filename,
			'FontName'=>$FontName,
			'FontAlias'=>$FontAlias
		);
	}
	return $data;
}
//=============APP 相关函数 结束===================

//=============插件相关函数 开始===================
/**
 * 插件命名规范：
 * （1）插件公共函数以plugin_开头，如：plugin_distribute_enable
 * （2）三级分销：相关函数以distribute_开头，如：distribute_rebate分销返利
 * （3）对模板调用的函数，采用大驼峰命名规则，如：TotalIncome
 */
/**
 * 是否启用了分销插件
 */
function plugin_distribute_enable(){
	$DistributeEnable = $GLOBALS['Config']['DistributeEnable'];
	return $DistributeEnable;
}

/**
 * 获取当前用户总收益
 * @return number
 */
function TotalIncome(){
	$CashType = 5; //表示分佣金额
	$MemberID = session('MemberID');
	$total= 0;
	if($MemberID>0){
		$m = D('Admin/Cash');
		$total = $m->getQuantity($CashType, $MemberID);
		$total = round($total, 2);
	}
	return $total;
}

/**
 * 生成6位数数字和字符的邀请码
 * @param int $len 邀请码的长度
 */
function MakeInviteCode($len=6){
	$code = strtolower(rand_string($len, 5));
	return $code;
}


function PcInviteUrl($MemberID=false){
	return InviteUrl($MemberID,1);
}

function WapInviteUrl($MemberID=false){
	return InviteUrl($MemberID,2);
}

/**
 * 我的推广链接
 * @param int $MemberID
 * @param int $type 1:pc,2:wap
 * @return string
 */
function InviteUrl($MemberID=false, $type=1){
	$url = '';
	if(empty($MemberID)){
		$MemberID = session('MemberID');
	}
	if(empty($MemberID)) {
		return $url;
	}
	
	$m = D('Admin/Member');
	$where['MemberID'] = intval($MemberID);
	$InviteCode = $m->where($where)->getField('InviteCode');
	if(!empty($InviteCode)){
		if($type==2){
			$url = get_wx_url();
		}else{
			$url = get_web_url();
			if( 2 != C('URL_MODEL') ){
				$url .= '/index.php';
			}
		}
		$url .= '/public/reg/l/'.LANG_SET."?ic={$InviteCode}";
	}
	return $url;
}

function InviteQrcode($MemberID=false){
	//L（QR_ECLEVEL_L，7%），M（QR_ECLEVEL_M，15%），Q（QR_ECLEVEL_Q，25%），H（QR_ECLEVEL_H，30%）；
	if(empty($MemberID)){
		$MemberID = session('MemberID');
	}
	$dir = APP_DATA_PATH.'ic/';
	$fileName = $dir.$MemberID.'.png';
	if(!file_exists($fileName)){
		if( !file_exists($dir)){
			@mkdir($dir, 0755, true);
		}
		//生成二维码图片
		$url = WapInviteUrl($MemberID);
		import("@.Common.phpqrcode");
		QRcode::png($url, $fileName, 'H', 7, 1);
	}
	$fileName = __ROOT__.substr($fileName, 1);
	return $fileName;
}

/**
 * 判断用户是否开启了分销功能
 * @param int $MemberID
 */
function can_distribute($MemberID){
	$b = false;
	$MemberID = intval($MemberID);
	$enable = plugin_distribute_enable();
	if($enable==1){
		//成为分销商的条件 1:无条件，2：购买商品，不管哪种情况IsDistributor一定等于1
		$m = D('Admin/Member');
		$IsDistributor = $m->where("MemberID=$MemberID")->getField('IsDistributor');
		$b = ($IsDistributor==1) ? true : false;
	}
	return $b;
}

/**
 * 购买商品满指定数量自动成为分销商
 */
function auto_set_distributor($OrderID){
	$Requirement = $GLOBALS['Config']['DistributeRequirement'];
	//2：购买商品自动成为分销商
	if($Requirement == 2){
		$mo = D('Admin/Order');
		$MemberID = $mo->where("OrderStatus=6 and OrderID=$OrderID")->getField('MemberID');
		
		$mm = D('Admin/Member');
		$member = $mm->where("MemberID=$MemberID")->field('IsDistributor,IsCheck,IsLock,InviteCode')->find();
		$IsDistributor = $member['IsDistributor'];
		$IsCheck = $member['IsCheck'];
		$IsLock = $member['IsLock'];
		$InviteCode = $member['InviteCode'];
		if($IsCheck==1 && $IsLock==0 && $IsDistributor==0){ //只有不是分销商的情况才自动设置
			$MinMoney = intval($GLOBALS['Config']['MinMoney']);
			$TotalOrderPrice = $mo->getTotalOrderPrice($MemberID);
			if($TotalOrderPrice >= $MinMoney){
				$md = D('Admin/DistributorLevel');
				$DistributorLevelID = $md->getLowestDistributorLevelID();
				$update['IsDistributor'] = 1;
				$update['DistributorLevelID'] = $DistributorLevelID;
				$update['DistributorTime'] = date('Y-m-d H:i:s');
				if(empty($InviteCode)){
					$update['InviteCode'] = MakeInviteCode();
				}
				$b = $mm->where("MemberID=$MemberID")->setField($update);
			}
		}
	}
}

/**
 * 分销返利
 * @param int $OrderID
 */
function distribute_rebate($OrderID){
	$m = D('Admin/Order');
	$order = $m->where("OrderID=$OrderID")->field('MemberID,OrderNumber')->find();
	$MemberID = $order['MemberID'];
	$OrderNumber = $order['OrderNumber'];
	//判断当前用户是否有分销功能
	$canDistribute = can_distribute($MemberID);
	if(!$canDistribute) return false;
	
	//==计算总分成佣金==
	$Commission = 0; //总分成佣金
	$DistributeMode = $GLOBALS['Config']['DistributeMode'];
	if($DistributeMode==1){ //1:按商品设置的分成金额      
		$mi = D('Admin/Info');
		$Commission = $mi->getOrderCommission($OrderID);
	}else{ //2:按订单设置的分成比例
		//获取当前订单消费总额
		$TotalOrderPrice = $m->getTotalOrderPrice($MemberID, $OrderID);
		$OrderRate = doubleval($GLOBALS['Config']['OrderRate'])/100.0;
		$Commission = $TotalOrderPrice * $OrderRate;
	}
	if( $Commission<=0 ) return false;
	
	//==开始返利==
	$CashTime = date('Y-m-d H:i:s');
	$cash = array(); //返利数据
	//1.自己返佣
	$memberToUpgrade = array(); //记录可能会升级的分销商
	$BuyerRate = doubleval($GLOBALS['Config']['BuyerRate'])/100.0;
	if($BuyerRate>0){
		$money = round($Commission * $BuyerRate, 2);
		$cash[] = array(
			'MemberID'=>$MemberID,
			'CashQuantity'=>$money,
			'CashType'=>5, //5:表示分销佣金
			'CashStatus'=>1,
			'CashTime'=>$CashTime,
			'OrderID'=>$OrderID, //分佣时记录对应的订单ID
			'CashRemark'=>"购买者自返佣，订单号：{$OrderNumber}",
		);
		$memberToUpgrade[] = $MemberID;
	}
	//2.下线返佣
	$md = D('Admin/DistributorLevel');
	$mm = D('Admin/Member');
	$upline = $mm->getUpline($MemberID, $GLOBALS['Config']['ReturnGrade']);
	foreach ($upline as $level=>$v){
		$rate = $md->getCommissionRate($v['DistributorLevelID'], $level);
		//参与返利的上线一定正常状态，否则不返利
		if($v['IsCheck']==1 && $v['IsLock']==0 && $rate>0){
			$money = $Commission * $rate;
			$memberToUpgrade[] = $v['MemberID'];
			$cash[] = array(
				'MemberID'=>$v['MemberID'],
				'CashQuantity'=>$money,
				'CashType'=>5,  //5:表示分销佣金
				'CashStatus'=>1,
				'CashTime'=>$CashTime,
				'OrderID'=>$OrderID, //分佣时记录对应的订单ID
				'CashRemark'=>"订单号：{$OrderNumber}",
			);
			//模板变量
			$var['CashQuantity'] = $money;
			$var['OrderNumber'] = $OrderNumber;
			$var['CashTime'] =  $CashTime;
			$var['MemberName'] =  $v['MemberName'];
			$var['MemberEmail'] =  $v['MemberEmail'];
			$var['MemberMobile'] =  $v['MemberMobile'];
			distribute_notify($var);
		}
	}
	//3. 批量插入数据
	if(count($cash)>0){
		$mc = D('Admin/Cash');
		$result = $mc->addAll($cash); //批量插入返利数据
		if($result){
			//4.相关会员，升级分销商等级
			$md->upgradeDistributorLevel($memberToUpgrade);
		}
	}
}

/**
 * 分销返利通知
 * @param array $data 相关数据
 */
function distribute_notify($data){
	//会员姓名、返佣金额
	$search = array('{$Name}',  '{$Money}', '{$Time}', '{$OrderNumber}');
	$replace = array($data['MemberName'], $data['CashQuantity'], $data['CashTime'], $data['OrderNumber']);
	//邮件通知
	$IsEmailNotify = $GLOBALS['Config']['DistributeEmail'];
	if($IsEmailNotify==1 && !empty($data['MemberEmail'])){
		$emailTitle = str_ireplace($search, $replace, $GLOBALS['Config']['DistributeEmailTitle']);
		$emailBody = str_ireplace($search, $replace, $GLOBALS['Config']['DistributeEmailBody']);
		$emailBody = nl2br($emailBody);
		$b = sendwebmail($data['MemberEmail'], $emailTitle, $emailBody);
	}
	//短信通知
	$IsSmsNotify = $GLOBALS['Config']['DistributeSms'];
	if($IsSmsNotify==1 && !empty($data['MemberMobile'])){
		$content = str_ireplace($search, $replace, $GLOBALS['Config']['DistributeSmsBody']);
		$b = send_sms($data['MemberMobile'], $content);
	}
}
//=============插件相关函数 结束===================
