<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */
class ConfigAction extends AdminBaseAction {
	//系统设置编辑
	function basic(){
		$m = D('Admin/Config');
		$data = $m->getConfig('basic'); //配置数据不从缓存中提取
		
		$this->assign('WebName', $data['WEB_NAME'] );
		$this->assign('WebUrl', $data['WEB_URL'] );
		$this->assign('WebIcon', $data['WEB_ICON'] );
		$this->assign('WebURL', $data['WEB_URL'] );
		$this->assign('WebIcp', $data['WEB_ICP'] );
		$this->assign('WebICP', $data['WEB_ICP'] );
		$this->assign('WebStatus', $data['WEB_STATUS'] );
		$this->assign('WebCloseReason', $data['WEB_CLOSE_REASON'] );
		$this->assign('WebBadWords', $data['WEB_BAD_WORDS'] );
		$this->assign('WebBadIP', $data['WEB_BAD_IP'] );
		$this->assign('WebLogo', $data['WEB_LOGO'] );
        $this->assign('CheckUpdate', $data['CheckUpdate'] );
		
		$this->assign('Action', __URL__.'/saveBasic' );
		$this->display();
	}
	
	function email(){
		$m = D('Admin/Config');
		$data = $m->getConfig('basic'); //配置数据不从缓存中提取
		$this->assign('EmailSender', $data['EMAIL_SENDER'] );
		$this->assign('EmailAccount', $data['EMAIL_ACCOUNT'] );
		$this->assign('EmailSmtp', $data['EMAIL_SMTP'] );
		$this->assign('EmailPassword', $data['EMAIL_PASSWORD'] );
		$this->assign('EmailWay', $data['EMAIL_WAY'] );
		$this->assign('EmailPort', $data['EMAIL_PORT'] );
		$this->assign('Action', __URL__.'/saveEmail' );
		$this->display();
	}
	
	function testEmail(){
			//sendmail(  '发件人账号','发件人姓名','收件人帐号','邮件标题','内容','邮箱账号','邮箱密码','smtp服务器,false,false,端口,协议);
			$username = $_POST['EmailAccount'];
			$pwd = $_POST['EmailPassword'];
			$smtp = $_POST['EmailSmtp'];
			$fromname = $_POST['EmailSender'];
			$port = $_POST['EmailPort'];
			$way = $_POST['EmailWay'];
			if($way=='ssl' && !function_exists('openssl_open') ){
				$this->ajaxReturn(null, '系统不支持OpenSSL组件，请开启，或选择TLS方式发送邮件！' , 3);
			}
			$b = sendmail($username, $fromname, $username, L('EmailTestTitle'), L('EmailTestContent'), $username, $pwd, $smtp, false, false, $port, $way);
			WriteLog();
			if( $b ){
				$this->ajaxReturn(null, '邮箱设置正确!' , 1);
			}else{
				$this->ajaxReturn(null, '邮箱设置错误！'.PHP_MAILER_ERROR , 0);
			}
	}
	
	function saveEmail(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	//保存配置
	function saveBasic(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			//保存调试配置[无需缓存到runtime]=======================
			$debugFile = './Data/app.debug';
			if( isset($_POST['APP_DEBUG']) && $_POST['APP_DEBUG'] == 1 ){
				@touch( $debugFile );
			}else{
				@unlink( $debugFile );
			}
			//===========================================
			
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();		
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function seo(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('seo'); //配置数据不从缓存中提取
		
		//搜索引擎优化设置
		$this->assign('Title', $data['TITLE'] );
		$this->assign('Keywords', $data['KEYWORDS'] );
		$this->assign('Description', $data['DESCRIPTION'] );
		
		$this->assign('Action', __URL__.'/saveSeo' );
		$this->display();
	}
	
	function saveSeo(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			//将中文逗号替换成英文逗号
			$_POST['KEYWORDS'] = str_replace('，', ',', $_POST['KEYWORDS']);
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	/**
	 * 站长统计设置
	 */
	function stat(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('stat');
		
		$this->assign('StatUserName', $data['STAT_USERNAME'] );
		$this->assign('StatUserPwd', $data['STAT_USERPWD'] );
		$this->assign('StatCode', $data['STAT_CODE'] );
		$this->assign('AsyncStatCode', $data['ASYNC_STAT_CODE'] );
		$this->assign('StatEnable', $data['STAT_ENABLE'] );

		$this->assign("Action", __URL__.'/SaveStat');
		$this->display();
	}
	
	
	
	/**
	 * 保存站长统计设置
	 */
	function saveStat(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	/**
	 * 百度分享设置
	 */
	function baidushare(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('baidushare');
	
		$this->assign('ShareStyle', $data['SHARE_STYLE'] );
		$this->assign('ShareTop', $data['SHARE_TOP'] );
		$this->assign('SharePos', $data['SHARE_POS'] );
		$this->assign('ShareSize', $data['SHARE_SIZE'] );
		$this->assign('ShareEnable', $data['SHARE_ENABLE'] );
	
		$this->assign("Action", __URL__.'/SaveBaidushare');
		$this->display();
	}
	
	function saveBaidushare(){
			if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function contact(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('contact'); //配置数据不从缓存中提取
		
		//联系方式
		$this->assign('Company', $data['COMPANY'] );
		$this->assign('Contact', $data['CONTACT'] );
		$this->assign('Address', $data['ADDRESS'] );
		$this->assign('Telephone', $data['TELEPHONE'] );
		$this->assign('Mobile', $data['MOBILE'] );
		$this->assign('Fax', $data['FAX'] );
		$this->assign('Email', $data['EMAIL'] );
		$this->assign('QQ', $data['QQ'] );
		$this->assign('PostCode', $data['POSTCODE'] );
		
		$this->assign('Longitude', $data['Longitude'] );
		$this->assign('Latitude', $data['Latitude'] );
		
		$this->assign('Action', __URL__.'/saveContact' );
		$this->display();
	}
	
	function saveContact(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function upload(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('upload'); //配置数据不从缓存中提取
		
		$IsExecutable = yd_is_executable('./Upload');
		
		$this->assign('Upload', $data['UPLOAD'] );
		$this->assign('UploadFileType', $data['UPLOAD_FILE_TYPE'] );
		$this->assign('MaxUploadSize', $data['MAX_UPLOAD_SIZE'] );
		$this->assign('IsExecutable', $IsExecutable );
		
		$this->assign('Action', __URL__.'/saveUpload' );
		$this->display();
	}
	
	function saveUpload(){
		if( isset($_POST) ){  //保存配置到数据库
			if( !is_numeric($_POST['MAX_UPLOAD_SIZE']) ){
				$this->ajaxReturn(null, '最大上传文件大小必须为数字!' , 0);
			}
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function guestbook(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('guestbook'); //配置数据不从缓存中提取
		
		$this->assign('GuestBookAllow', $data['GUEST_BOOK_ALLOW'] );
		$this->assign('GuestBookCheck', $data['GUEST_BOOK_CHECK'] );
		$this->assign('GuestBookVerifycode', $data['GUEST_BOOK_VERIFYCODE'] );
		$this->assign('GuestBookPageSize', $data['GUEST_BOOK_PAGESIZE'] );
		
		//邮件通知
		$this->assign('GuestBookSendEmail', $data['GUEST_BOOK_SENDEMAIL'] );
		$this->assign('GuestBookEmail', $data['GUEST_BOOK_EMAIL'] );  //接收邮件帐号
		$this->assign('GuestBookEmailTitle', $data['GUEST_BOOK_EMAIL_TITLE'] );  //邮件标题
		//$this->assign('GuestBookEmailBody', $data['GUEST_BOOK_EMAIL_BODY'] );  //邮件内容
		
		$this->assign('GuestBookSms', $data['GUEST_BOOK_SMS'] );
		$this->assign('GuestBookSmsTo', $data['GUEST_BOOK_SMS_TO'] );  //接收邮件帐号
		$this->assign('GuestBookSmsTemplate', $data['GUEST_BOOK_SMS_TEMPLATE'] );  //邮件标题
		
		//$this->assign('Label', $this->getLabel(6) );
		$this->assign('Action', __URL__.'/saveGuestbook' );
		$this->display();
	}
	
	function feedback(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('guestbook'); //配置数据不从缓存中提取
		$this->assign('c', $data );
		$this->assign('Action', __URL__.'/saveFeedback' );
		$this->display();
	}
	
	function saveFeedback(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	//返回模型对应的标签数组（不含分组名称）
	private function getLabel($channelModelID){
		$label[] = array('LabelName'=>'{$WebName}', 'DisplayName'=>'网站名称');
		$label[] = array('LabelName'=>'{$WebUrl}', 'DisplayName'=>'网站域名');
		$m = D('Admin/Attribute');
		$Attribute = $m->getAttribute($channelModelID);
		foreach ($Attribute as $a){
			$name = explode(',', $a['DisplayName']);
			$label[] = array('LabelName'=>'{$'.$a['FieldName'].'}', 'DisplayName'=>$name[0]);
		}
		return $label;
	}
	
	function saveGuestbook(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function comment(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('comment'); //配置数据不从缓存中提取
		
		$this->assign('CommentEnable', $data['COMMENT_ENABLE'] );
		$this->assign('CommentCheck', $data['COMMENT_CHECK'] );
		$this->assign('CommentVerifycode', $data['COMMENT_VERIFYCODE'] );
		$this->assign('CommentPageSize', $data['COMMENT_PAGE_SIZE'] );
		$this->assign('CommentBuy', $data['COMMENT_BUY'] );
		$this->assign('CommentTip', $data['COMMENT_TIP'] );
		
		$this->assign('Action', __URL__.'/saveComment' );
		$this->display();
	}
	
	function saveComment(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function water(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('water'); //配置数据不从缓存中提取
		$this->assign('WaterEnable', $data['WATER_ENABLE'] );
		$this->assign('WaterPic', $data['WATER_PIC'] );
		$this->assign('WaterOffsetX', $data['WATER_OFFSET_X'] );
		$this->assign('WaterOffsetY', $data['WATER_OFFSET_Y'] );
		$this->assign('WaterTrans', $data['WATER_TRANS'] );
		
		$this->assign('WaterType', $data['WATER_TYPE'] );
		$this->assign('WaterText', $data['WATER_TEXT'] );
		$this->assign('WaterFont', $data['WATER_FONT'] );
		$this->assign('WaterTextSize', $data['WATER_TEXT_SIZE'] );
		$this->assign('WaterTextColor', $data['WATER_TEXT_COLOR'] );
		$this->assign('WaterTextAngle', $data['WATER_TEXT_ANGLE'] );
		$this->assign('WaterPosition', $data['WATER_POSITION'] );
		
		$MyFont = GetWaterFonts();
		$this->assign('MyFont',$MyFont);
		$this->assign('Action', __URL__.'/saveWater' );
		$this->display();
	}
	
	function saveWater(){
		if( isset($_POST) ){  //保存配置到数据库
			if( $_POST['WATER_TYPE'] == 2 ){ //文字水印
				if( empty($_POST['WATER_TEXT']) ){
					$this->ajaxReturn(null, '水印文字不能为空!' , 0);
				}
				
				$font = './Public/font/'.$_POST['WATER_FONT'];
				if( !is_file($font)){
					$this->ajaxReturn(null, '水印字体文件不存在!' , 0);
				}
				
				if( !is_numeric($_POST['WATER_TEXT_SIZE']) ){
					$this->ajaxReturn(null, '水印文字大小必须为数字!' , 0);
				}
					
				if( !is_numeric($_POST['WATER_TEXT_ANGLE']) ){
					$this->ajaxReturn(null, '水印文字角度必须为数字!' , 0);
				}
					
				if( !is_numeric($_POST['WATER_OFFSET_X']) ){
					$this->ajaxReturn(null, '水印文字水平X偏移量必须为数字!' , 0);
				}
					
				if( !is_numeric($_POST['WATER_OFFSET_Y']) ){
					$this->ajaxReturn(null, '水印文字垂直Y偏移量必须为数字!' , 0);
				}
			}else{  //图片水印
				if( empty($_POST['WATER_PIC']) ){
					$this->ajaxReturn(null, '水印图片不能为空!' , 0);
				}
			}
			
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	//水印预览
	function waterPreview(){
		header("Content-type: image/jpg");
		$src = './Public/Images/standard/1.jpg';
		$dst = RUNTIME_PATH.'waterpreview.jpg';
		if( is_file($dst) ){
			@unlink($dst);
		}
		
		if( 1 == $GLOBALS['Config']['WATER_ENABLE']){
			addWater($src, $dst);
		}else{ //未启用水印
			$dst = $src;
		}
		
		//$dst = __ROOT__.substr($dst, 1);
		//$this->ajaxReturn($dst,'',1);
		if( file_exists($dst) ){
			$g = imagecreatefromjpeg($dst);
			imagejpeg($g, NULL, 80);
			imagedestroy($g);
		}
	}
	
	/**
	 * 第三方登录设置
	 */
	function oauth(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Oauth');
		$data = $m->getOauth();
		if(empty($data)) return false;
		import("@.Common.YdOauth");
		$n = count($data);
		for($i = 0; $i < $n; $i++){
			$obj = YdOauth::getInstance($data[$i]['OauthMark']);
			$obj->setAppID( $data[$i]['OauthAppID'] );
			$obj->setAppKey( $data[$i]['OauthAppKey'] );
			$data[$i]['OauthRequestUrl'] = $obj->getRequestUrl();
		}
		$this->assign("Data", $data);
		$this->assign('Action', __URL__.'/saveOauth' );
		$this->display();
	}
	
	function saveOauth(){
		if( isset($_POST) ){
			$data = array();
			$n = count( $_POST['OauthID'] );
			$m = D("Admin/Oauth");
			for($i=0; $i<$n; $i++){
				$data = array(
					'OauthID'=>$_POST['OauthID'][$i],
					'OauthAppID'=>$_POST['OauthAppID'][$i],
					'OauthAppKey'=>$_POST['OauthAppKey'][$i],
					'OauthOrder'=>$_POST['OauthOrder'][$i],
					'IsEnable'=>$_POST['IsEnable'][$i]
				);
				$result = $m->save($data);
			}
			if($result === false){
				$this->ajaxReturn(null, '保存失败!' , 0);
			}else{
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}
		}
	}
	
	
	function reg(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('reg'); //配置数据不从缓存中提取
		
		$this->assign('MemberEnable', $data['MEMBER_ENABLE'] );
		$this->assign('MemberRegEnable', $data['MEMBER_REG_ENABLE'] );
		$this->assign('MemberRegCheck', $data['MEMBER_REG_CHECK'] );
		$this->assign('MemberRegVerifyCode', $data['MEMBER_REG_VERIFYCODE'] );
		$this->assign('MemberLoginVerifyCode', $data['MEMBER_LOGIN_VERIFYCODE'] );
		$this->assign('MemberAddCheck', $data['MEMBER_ADD_CHECK'] );
		$this->assign('EmailBody', $data['EMAIL_BODY'] );
		$this->assign('MobileRegTemplate', $data['MOBILE_REG_TEMPLATE'] );
		
		$this->assign('Action', __URL__.'/saveReg' );
		$this->display();
	}
	
	function saveReg(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function db(){
		header("Content-Type:text/html; charset=utf-8");
		$this->assign('DbHost', C('DB_HOST') );
		$this->assign('DbName', C('DB_NAME') );
		$this->assign('DbUser', C('DB_USER') );
		$this->assign('DbPort', C('DB_PORT') );
		$this->assign('DbPrefix', C('DB_PREFIX') );
		$this->assign('Action', __URL__.'/saveDb' );
		$this->display();
	}
	
	function saveDb(){
		if( isset($_POST) ){  //保存配置到数据库
			//检查数据库连接================================================
			$dbHost = trim($_POST['DB_HOST']);
			$dbUser= trim($_POST['DB_USER']);
			$dbName = trim($_POST['DB_NAME']);		
			$dbPwd= trim($_POST['DB_PWD']);
			$dbPort = trim($_POST['DB_PORT']);
			$dbPrefix = trim($_POST['DB_PREFIX']);
			
			$conn = @mysql_connect($dbHost, $dbUser, $dbPwd);
			if( !$conn ){
				$this->ajaxReturn(null, '连接数据库失败!' , 0);
			}
			if( !mysql_select_db($dbName, $conn) ){
				$this->ajaxReturn(null, '数据库'.$dbName.'不存在！' , 0);
			}
			if( isset($_POST['testdb']) ) { //数据库测试
				$this->ajaxReturn(null, '连接数据库成功!' , 1);
			}
			//==========================================================
			
			//保存数据库配置文件==============================================
			$file = CONF_PATH.'db.php';
			$db = array ('DB_TYPE' => 'mysqli',
					'DB_HOST' => $dbHost,
					'DB_NAME' => $dbName,
					'DB_USER' => $dbUser,
					'DB_PWD' => $dbPwd,
					'DB_PORT' => $dbPort,
					'DB_PREFIX' => $dbPrefix,
			);
			$b = cache_array($db, $file);
			if( !b ) $this->ajaxReturn(null, '保存数据库配置失败!' , 0);
			
			//缓存数据库成功后必须更新数据库配置缓存======================
			//C('DB_HOST', $_POST['DB_HOST']);
			//C('DB_NAME', $_POST['DB_NAME']);
			//C('DB_USER', $_POST['DB_USER']);
			//C('DB_PWD', $_POST['DB_PWD']);
			//C('DB_PORT', $_POST['DB_PORT']);
			//$m = M();
			//$m->db(0, NULL);
			//$m->db(0, "mysql://$dbUser:$dbPwd@$dbHost:$dbPort/$dbName");
			//存在问题：当前配置写入db.php后，并没有改变当前正在运行的数据库对象，下次运行才生效
			//是否有办法解决
			//==================================================
			
			//写配置文件
			YdCache::writeAll(); //更新所有缓存,内部会调用YdCache::deleteAll(); 
			WriteLog();
			$this->ajaxReturn(null, '配置数据库成功!' , 1);
		}
	}

	//在线客服设置
	function online(){
		header("Content-Type:text/html; charset=utf-8");
		
		$m = D('Admin/Config');
		$data = $m->getConfig('online'); //配置数据不从缓存中提取
		
		$this->assign('OnlineEnable', $data['ONLINE_ENABLE'] );
		$this->assign('OnlineStyle', $data['ONLINE_STYLE'] );
		$this->assign('OnlinePosition', $data['ONLINE_POSITION'] );
		$this->assign('OnlineTop', $data['ONLINE_TOP'] );
		$this->assign('OnlineEffect', $data['ONLINE_EFFECT'] );
		$this->assign('OnlineWidth', $data['ONLINE_WIDTH'] );
		
		$this->assign('OnlineOpen', $data['ONLINE_OPEN'] );
		$this->assign('OnlineTelephone', $data['ONLINE_TELEPHONE'] );
		
		$this->assign('OnlineFooterText', $data['ONLINE_FOOTER_TEXT'] );
		$this->assign('OnlineTitle', $data['ONLINE_TITLE'] );
		
		$this->assign('Action', __URL__.'/saveOnline' );
		$this->display();
	}
	
	//保存在线客服
	function saveOnline(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	/**
	 * 语言设置
	 */
	function language(){
		header("Content-Type:text/html; charset=utf-8");
		$this->assign('LangAutoDetect', C('LANG_AUTO_DETECT') );
		$this->assign('DefaultLang', C('DEFAULT_LANG') );
		$this->assign('Action', __URL__.'/saveLanguage' );
		$this->display();
	}
	
	function saveLanguage(){
		if( isset($_POST) ){
			if( YdCache::writeCoreConfig($_POST) ){
				YdCache::deleteAll();
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	/**
	 * 内核设置
	 */
	function core(){
		header("Content-Type:text/html; charset=utf-8");
		//1: 不启用伪静态(PathInfo模式), 2:启用伪静态 Rewrite模式
		$this->assign('UrlModel', C('URL_MODEL') );  
		$this->assign('UrlHtmlSuffix', C('URL_HTML_SUFFIX') );
		$this->assign('Action', __URL__.'/saveCore' );
		$this->display();
	}
	
	function saveCore(){
		if( isset($_POST) ){  //保存配置到文件
			if( $_POST['URL_MODEL'] == 2 ){
				//若启用伪静态需要判断服务器是否支持伪静态, 加t参数防止缓存
				$url = get_web_url().'/public/testmodel/t/'.time();
				$url = str_ireplace('index.php/', '', $url);
				//$r = get_headers($url);  若使用get_headers，则url不存在时，也会返回200 OK
				$txt = file_get_contents($url);
				if( $txt != 'success'){
					$this->ajaxReturn(null, '您的服务器不支持伪静态!' , 0);
				}
			}
			$data['URL_MODEL'] = $_POST['URL_MODEL'];
			$data['URL_HTML_SUFFIX'] = $_POST['URL_HTML_SUFFIX'];
			$b = YdCache::writeCoreConfig($data);
			if( $b ){
				YdCache::deleteAll();
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function order(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('order'); //配置数据不从缓存中提取
	
		$this->assign('OrderAllow', $data['ORDER_ALLOW'] );
		$this->assign('OrderPageSize', $data['ORDER_PAGESIZE'] );
		$this->assign('OrderVerifyCode', $data['ORDER_VERIFYCODE'] );
		$this->assign('OrderEmail', $data['ORDER_EMAIL'] );
		$this->assign('OrderEmailBody', $data['ORDER_EMAIL_BODY'] );
		$this->assign('OrderEmailTo', $data['ORDER_EMAIL_TO'] );
		$this->assign('OrderEmailTitle', $data['ORDER_EMAIL_TITLE'] );
		$this->assign('OrderPrefix', $data['ORDER_PREFIX'] );
		
		$this->assign('CurrencySymbol', $data['CURRENCY_SYMBOL'] );
		
		$this->assign('OrderSms', $data['ORDER_SMS'] );
		$this->assign('OrderSmsTo', $data['ORDER_SMS_TO'] );
		$this->assign('OrderSmsTemplate', $data['ORDER_SMS_TEMPLATE'] );
		
		//商城设置
		$this->assign('FreeShippingThreshold', $data['FREE_SHIPPING_THRESHOLD'] );
		$this->assign('PointExchangeRate', $data['POINT_EXCHANGE_RATE'] );
		$this->assign('AutoReceiveDays', $data['AUTO_RECEIVE_DAYS'] );

		$this->assign('Action', __URL__.'/saveOrder' );
		$this->display();
	}
	
	function saveOrder(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	//自动生成关键词内链
	function autoLink(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('link'); //配置数据不从缓存中提取
	
		$this->assign('LinkEnable', $data['LINK_ENABLE'] );
		$this->assign('LinkKeyword', $data['LINK_KEYWORD'] );
	
		$this->assign('Action', __URL__.'/saveAutoLink' );
		$this->display();
	}
	
	function saveAutoLink(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			//将中文等号替换成英文等号
			$_POST['LINK_KEYWORD'] = str_replace('＝', '=', $_POST['LINK_KEYWORD']);
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function thumb(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('thumb'); //配置数据不从缓存中提取
		$this->assign('ThumbEnable', $data['THUMB_ENABLE'] );
		$this->assign('ThumbWaterEnable', $data['THUMB_WATER_ENABLE'] );
		$this->assign('ThumbType', $data['THUMB_TYPE'] );
		$this->assign('ThumbWidth', $data['THUMB_WIDTH'] );
		$this->assign('ThumbHeight', $data['THUMB_HEIGHT'] );
		$this->assign('ThumbFirst', $data['THUMB_FIRST'] );
	
		$this->assign('Action', __URL__.'/saveThumb' );
		$this->display();
	}

	function saveThumb(){
		if( isset($_POST) ){  //保存配置到数据库
			if( !is_numeric($_POST['THUMB_WIDTH']) ){
				$this->ajaxReturn(null, '缩略图宽度必须为数字!' , 0);
			}
			if( !is_numeric($_POST['THUMB_HEIGHT']) ){
				$this->ajaxReturn(null, '缩略图高度必须为数字!' , 0);
			}
			unset( $_POST['__hash__'] );
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function wap(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('wap'); //配置数据不从缓存中提取
		$this->assign('WapAutoRedirect', $data['WAP_AUTO_REDIRECT'] );
		$this->assign('WapPcAccess', $data['WAP_PC_ACCESS'] );
		$this->assign('WapLogo', $data['WAP_LOGO'] );
		$this->assign('WapQrcode', $data['WAP_QRCODE'] );
		$this->assign('WapStatus', $data['WAP_STATUS'] );
		
		//读取domain数据，直接从核心配置文件里读取========
		$wapUrl = YdCache::readCoreConfig('WAP_URL');
		$this->assign('WapURL', $wapUrl );
		$this->assign('WapUrl', $wapUrl );
		//====================================
		
		$this->assign('Action', __URL__.'/saveWap' );
		$this->display();
	}
	
	function saveWap(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			
			//保存手机网站域名配置到config/domain.php[无需缓存到runtime]============
			if( isset($_POST['WAP_URL']) ){
				$domain = array('APP_SUB_DOMAIN_RULES'=>array());
				$dList = explode(',', trim($_POST['WAP_URL']));
				foreach( (array)$dList as $d){
					if(!empty($d)){
						$d = trim($d);
						$d = str_ireplace('http://', '', rtrim($d,'\\/') ); //去掉http://
						$temp[$d] = array('wap/');
					}
				}
				$domain['APP_SUB_DOMAIN_RULES'] = $temp;
				YdCache::writeCoreConfig($domain);
				YdCache::deleteAll();
			}
			//====================================================
			
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	function  translateTest(){
		$content = $_REQUEST['content'];
		$result = baiduTranslate($content, 'auto', 'auto');
		if( $result['Status'] == 1){
			$this->ajaxReturn(null, $result['Content'] , 1);
		}else{
			$this->ajaxReturn(null, $result['ErrorMessage'], 1);
		}
	}
	
	function other(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Config');
		$data = $m->getConfig('other'); //配置数据不从缓存中提取
		$this->assign('AdminPageSize', $data['ADMIN_PAGE_SIZE'] );
		$this->assign('AdminRollPage', $data['ADMIN_ROLL_PAGE'] );
		$this->assign('AutoDelEnable', $data['AUTO_DEL_ENABLE'] );
		$this->assign('AutoUploadEnable', $data['AUTO_UPLOAD_ENABLE'] );
		$this->assign('DelLinkEnable', $data['DEL_LINK_ENABLE'] );
		
		$this->assign('AllowLink', $data['ALLOW_LINK'] );
		$this->assign('BaiduTranslateApiKey', $data['BAIDU_TRANSLATE_APIKEY'] );
		$this->assign('BaiduTranslateAppId', $data['BAIDU_TRANSLATE_APPID'] );
		
		$this->assign('SmsType', $data['SMS_TYPE'] );
		$this->assign('SmsAccount', $data['SMS_ACCOUNT'] );
		$this->assign('SmsPassword', $data['SMS_PASSWORD'] );
		$this->assign('SmsIpMax', $data['SMS_IP_MAX'] );
		$this->assign('SmsNumMax', $data['SMS_NUM_MAX'] );
		
		$this->assign('SearchPageSize', $data['SearchPageSize'] );
		$this->assign('HomeRollPage', $data['HomeRollPage'] );
		$this->assign('AdminLoginName', C('ADMIN_LOGIN_NAME') );
		
		$this->assign('Action', __URL__.'/saveOther' );
		$this->display();
	}
	
	function getLeftNum(){
		$data = $GLOBALS['Config'];
		import("@.Common.YdSms");
		$obj = YdSms::getInstance( $data['SMS_TYPE'] );
		$obj->setConfig( $data );
		$num = $obj->getLeftNum();
		if( is_numeric($num)){
			$this->ajaxReturn(null, $num, 1);
		}else{
			$this->ajaxReturn(null, "查询失败，{$num}" , 0);
		}
	}
	
	//短信发送测试
	function sendSmsTest(){
		$mobile = $_GET['mobile'];
		$code = $_GET['code']; //校验码
		$content = $GLOBALS['Config']['MOBILE_REG_TEMPLATE']; //读取模板
		$msg = '';
		$result = send_sms($mobile, $content, array('{$Code}'=>$code), 1, $msg);
		if( $result ){
			$this->ajaxReturn(null, $msg, 1);
		}else{
			$this->ajaxReturn(null, "发送失败，{$msg}" , 0);
		}
	}
	
	function saveOther(){
		if( isset($_POST) ){  //保存配置到数据库
			unset( $_POST['__hash__'] );
			
			//保存后台登陆名称到core.php文件
			$config['ADMIN_LOGIN_NAME'] = $_POST['AdminLoginName'];
			YdCache::writeCoreConfig($config);

			
			$m = D("Admin/Config");
			if( $m->saveConfig($_POST) ){
				WriteLog();
				$this->ajaxReturn(null, '保存成功!' , 1);
			}else{
				$this->ajaxReturn(null, '保存失败!' , 0);
			}
		}
	}
	
	/**
	 * 批量替换图片地址，不对外公开
	 */
	function batch(){
		header("Content-Type:text/html; charset=utf-8");
		$action = strtolower($_POST['Action']);
		if($action=='replaceimage'){ //批量替换图片
			$search = trim($_POST['Search']);
			$replace = trim($_POST['Replace']);
			if( empty($search) ){
				$this->ajaxReturn(null, '搜索图像路径字符串不能为空!' , 0);
			}
			if( empty($replace) ){
				$this->ajaxReturn(null, '替换字符串不能为空!' , 0);
			}
			if( $search==$replace ){
				$this->ajaxReturn(null, '检索串和替换串不能相同' , 0);
			}
			$n = 0;
			//1。替换配置 开始==
			$m = D('Admin/Config');
			$where = "ConfigName in('WEB_LOGO','WAP_LOGO','WX_LOGO','WX_QRCODE','APP_LOGO','WAP_QRCODE'";
			$where .= ",'XCX_QRCODE','APP_ABOUT')";
			$data = $m->where($where)->field('ConfigID,ConfigValue')->select();
			foreach ($data as $v){
				$wh = "ConfigID={$v['ConfigID']}";
				$ConfigValue = str_replace($search, $replace, $v['ConfigValue']);
				$result = $m->where($wh)->setField('ConfigValue', $ConfigValue);
				if($result){
					$n++;
				}
			}
			//1.替换配置 结束==
			
			//2.替换信息 开始==
			$m = D('Admin/Info');
			$where = "IsEnable=1 and (InfoPicture!='' or InfoContent!='' )";
			$data = $m->where($where)->field('InfoID,InfoPicture,InfoContent')->select();
			foreach ($data as $v){
				$r = array();
				$picture = $v['InfoPicture'];
				$content = $v['InfoContent'];
				if(!empty($picture) || !empty($content)){
					$wh = "InfoID={$v['InfoID']}";
					if( 0 === strpos($picture, $search) ){
						$r['InfoPicture'] = str_replace($search, $replace, $picture);
					}
					if( false === strpos($content, $replace)){
						$r['InfoContent'] = str_replace($search, $replace, $content);
					}
					$result = $m->where($wh)->setField($r);
					if($result){
						$n++;
					}
				}
			}
			//2.替换信息 结束==
			
			//3.替换频道 开始==
			$m = D('Admin/Channel');
			$where = "IsEnable=1 and (ChannelPicture!='' or ChannelContent!='' )";
			$data = $m->where($where)->field('ChannelID,ChannelPicture,ChannelContent')->select();
			foreach ($data as $v){
				$r = array();
				$picture = $v['ChannelPicture'];
				$content = $v['ChannelContent'];
				if(!empty($picture) || !empty($content)){
					$wh = "ChannelID={$v['ChannelID']}";
					if( 0 === strpos($picture, $search) ){
						$r['ChannelPicture'] = str_replace($search, $replace, $picture);
					}
					if( false === strpos($content, $replace)){
						$r['ChannelContent'] = str_replace($search, $replace, $content);
					}
					$result = $m->where($wh)->setField($r);
					if($result){
						$n++;
					}
				}
			}
			//3.替换频道  结束==
			
			//4.替换幻灯片开始==
			$m = D('Admin/Banner');
			$where = "BannerImage!=''";
			$data = $m->where($where)->field('BannerID,BannerImage')->select();
			foreach ($data as $v){
				$r = array();
				$picture = $v['BannerImage'];
				if(!empty($picture)){
					$wh = "BannerID={$v['BannerID']}";
					if( 0 === strpos($picture, $search) ){
						$r['BannerImage'] = str_replace($search, $replace, $picture);
						$result = $m->where($wh)->setField($r);
						if($result){
							$n++;
						}
					}
				}
			}
			//4.替换幻灯片  结束==
			
			//5.替换专题 开始==
			$m = D('Admin/Special');
			$where = "SpecialPicture!=''";
			$data = $m->where($where)->field('SpecialID,SpecialPicture')->select();
			foreach ($data as $v){
				$r = array();
				$picture = $v['SpecialPicture'];
				if(!empty($picture)){
					$wh = "SpecialID={$v['SpecialID']}";
					if( 0 === strpos($picture, $search) ){
						$r['SpecialPicture'] = str_replace($search, $replace, $picture);
						$result = $m->where($wh)->setField($r);
						if($result){
							$n++;
						}
					}
				}
			}
			//5.替换专题  结束==
			
			//6.替换广告 开始==
			$m = D('Admin/Ad');
			$where = "AdContent!=''";
			$data = $m->where($where)->field('AdID,AdContent')->select();
			foreach ($data as $v){
				$r = array();
				$picture = $v['AdContent'];
				if(!empty($picture)){
					$wh = "AdID={$v['AdID']}";
					if( 0 === strpos($picture, $search) ){
						$r['AdContent'] = str_replace($search, $replace, $picture);
						$result = $m->where($wh)->setField($r);
						if($result){
							$n++;
						}
					}
				}
			}
			//6.替换广告  结束==
			
			//7.替换友情链接 开始==
			$m = D('Admin/Link');
			$where = "LinkLogo!=''";
			$data = $m->where($where)->field('LinkID,LinkLogo')->select();
			foreach ($data as $v){
				$r = array();
				$picture = $v['LinkLogo'];
				if(!empty($picture)){
					$wh = "LinkID={$v['LinkID']}";
					if( 0 === strpos($picture, $search) ){
						$r['LinkLogo'] = str_replace($search, $replace, $picture);
						$result = $m->where($wh)->setField($r);
						if($result){
							$n++;
						}
					}
				}
			}
			//7.替换友情链接  结束==
			
			if( $n>0 ){
				$this->ajaxReturn(null, "替换图像地址成功!共替换了{$n}个!", 1);
			}else{
				$this->ajaxReturn(null, '没有替换任何图像地址!' , 0);
			}
		}
		$this->assign("WebInstallDir", $this->WebInstallDir);
		$this->display();
	}

    /**
     * 后台主题颜色设置
     */
    function theme(){
        $m = D('Admin/Config');
        $data = $m->getConfig('basic'); //配置数据不从缓存中提取
        $this->assign('AdminThemeColor', $data['AdminThemeColor'] );
        $this->assign('Action', __URL__.'/saveTheme' );
        $this->display();
    }

    /**
     * 保存主题颜色
     */
    function saveTheme(){
        if( isset($_POST) ){  //保存配置到数据库
            if( empty($_POST['AdminThemeColor']) ){
                $this->ajaxReturn(null, '主题颜色不能为空!' , 0);
            }
            unset( $_POST['__hash__'] );
            $m = D("Admin/Config");
            if( $m->saveConfig($_POST) ){
                WriteLog();
                $this->ajaxReturn(null, '保存成功!' , 1);
            }else{
                $this->ajaxReturn(null, '保存失败!' , 0);
            }
        }
    }
}
?>