<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved.
 */
class JobAction extends AdminBaseAction {
	function index(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Job');
		import("ORG.Util.Page");
		$TotalPage = $m->getCount();
		$PageSize = $this->AdminPageSize;
		
		$Page = new Page($TotalPage, $PageSize);
		$Page->rollPage = $this->AdminRollPage;
		$ShowPage = $Page->show();
		$Job = $m->getJob($Page->firstRow, $Page->listRows);
		
		//计算应聘简历数=============================================
		$r = D('Admin/Resume');
		$n = count($Job);
		for ($i=0; $i<$n; $i++){
			$Job[$i]['ResumeCount'] = $r->getResumeCount( $Job[$i]['JobID'] );
		}
		//======================================================
		
		$this->assign('NowPage', $Page->getNowPage()); //分页条
		$this->assign('Job', $Job);
		$this->assign('Page', $ShowPage); //分页条
		$this->display();
	}
	
	function add(){
		header("Content-Type:text/html; charset=utf-8");
	
		//模型属性信息==============================================
		$m = D('Admin/Attribute');
		$Attribute = $m->getAttribute(7);
		$Group = $m->getGroup(7);
		
		for($n = 0; $n < count($Attribute); $n++){
			if($Attribute[$n]['DisplayType'] == 'datetime'){
				$Attribute[$n]['DisplayValue'] = date('Y-m-d H:i:s'); //显示当期时间
				break;
			}
		}
		$Attribute = parent::parseAttribute($Attribute);  //解析属性信息
		//======================================================
		$this->assign('Action', __URL__.'/SaveAdd');
		$this->assign('Group', $Group);
		$this->assign('Attribute', $Attribute);
		$this->display();
	}
	
	function saveAdd(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Job');
		if( $m->create() ){
			if($m->add()){
				WriteLog("ID:".$m->getLastInsID() );
				$this->ajaxReturn(null, '添加成功!' , 1);
			}else{
				$this->ajaxReturn(null, '添加失败!' , 0);
			}
		}else{
			$this->ajaxReturn(null, $m->getError() , 0);
		}
	}
	
	function del(){
		header("Content-Type:text/html; charset=utf-8");
		$JobID = $_GET["JobID"];
		$p = $_GET["p"];
		$m = D('Admin/Job');
		if( is_numeric($JobID) && is_numeric($p) && !$m->hasData( $JobID ) ){
			$m->delete($JobID);
			WriteLog("ID:$JobID");
		}
		redirect(__URL__."/index/p/$p");
	}
	
	function batchDel(){
		$id = $_POST['JobID'];
		$NowPage = $_POST["NowPage"];
		
		$m = D('Admin/Job');
		foreach($id as $k=>$v){
			if( $m->hasData($v) ){
				unset( $id[$k] );
			}
		}
		
		if( count($id) > 0 ){
			$m->batchDelJob( $id );
			WriteLog("ID:".implode(',', $id));
		}
		redirect(__URL__."/index/p/$NowPage");
	}
	
	//批量排序Banner
	function batchSort(){
		$JobOrder = $_POST['JobOrder']; //排序
		$JobID = $_POST['JobOrderID']; //排序
		$NowPage = $_POST["NowPage"];
		if( count($JobID) > 0 && count($JobOrder) > 0 ){
			D('Admin/Job')->batchSortJob($JobID, $JobOrder);
			WriteLog();
		}
		redirect(__URL__."/index?p=$NowPage");
	}
	
	function modify(){
		header("Content-Type:text/html; charset=utf-8");
		//参数有效性检查===========================
		$JobID = $_GET['JobID'];
		if( !is_numeric($JobID)){
			alert("非法参数", __URL__.'/index');
		}
		//====================================
	
		//模型属性信息=================================================
		$m = D('Admin/Attribute');
		$Attribute = $m->getAttribute(7);
		$Group = $m->getGroup(7);
	
		//获取专题数据======================================================
		$m = D('Admin/Job');
		$Info = $m->find( $JobID );
		for($n = 0; $n < count($Attribute); $n++){
			if( $this->IsSelectedAttribute( $Attribute[$n]['DisplayType'] ) ){
				$Attribute[$n]['SelectedValue'] = $Info[ $Attribute[$n]['FieldName'] ]; //获取频道设置值
			}else{
				$Attribute[$n]['DisplayValue'] = $Info[ $Attribute[$n]['FieldName'] ];
			}
		}
		$Attribute = parent::parseAttribute($Attribute);  //解析属性信息
		//==============================================================
	
		$this->assign('HiddenName', 'JobID');
		$this->assign('HiddenValue', $JobID);
		$this->assign('Action', __URL__.'/saveModify');
	
		$this->assign('Group', $Group);
		$this->assign('Attribute', $Attribute);
		$this->display();
	}
	
	function saveModify(){
		header("Content-Type:text/html; charset=utf-8");
		$m = D('Admin/Job');
		if( $m->create() ){
			if($m->save() === false){
				$this->ajaxReturn(null, '修改失败!' , 0);
			}else{
				WriteLog( "ID:".$_POST['JobID'] );
				$this->ajaxReturn(null, '修改成功!' , 1);
			}
		}else{
			$this->ajaxReturn(null, $m->getError() , 0);
		}
	}

	//应聘简历管理
	function resume(){
		header("Content-Type:text/html; charset=utf-8");
		$JobID = isset($_REQUEST['JobID']) ? $_REQUEST['JobID'] : -1;
		
		$m = D('Admin/Resume');
		import("ORG.Util.Page");
		$TotalPage = $m->getResumeCount($JobID); 
		$PageSize = $this->AdminPageSize;
		
		$Page = new Page($TotalPage, $PageSize);
		$Page->rollPage = $this->AdminRollPage;
		if( $JobID != -1){
			$Page->parameter = "&JobID=$JobID";
		}
		$ShowPage = $Page->show();
		
		$Resume= $m->getResume($Page->firstRow, $Page->listRows, -1, $JobID);
		
		$this->assign('NowPage', $Page->getNowPage()); //分页条
		$this->assign('JobID', $JobID);
		$this->assign('Resume', $Resume);
		$this->assign('Page', $ShowPage); //分页条
		$this->display();
	}
	
	function delResume(){
		header("Content-Type:text/html; charset=utf-8");
		$ResumeID = $_GET["ResumeID"];
		$JobID = isset($_REQUEST['JobID']) ? $_REQUEST['JobID'] : -1;
		$p = $_GET["p"];
	
		if( is_numeric($ResumeID) && is_numeric($p)){
			D('Admin/Resume')->delete($ResumeID);
			WriteLog("ID:$ResumeID");
		}
		redirect(__URL__."/resume?JobID=$JobID&p=$p");
	}
	
	function batchDelResume(){
		$id = $_POST['ResumeID'];
		$JobID = isset($_REQUEST['JobID']) ? $_REQUEST['JobID'] : -1;
		$NowPage = $_POST["NowPage"];
		if( count($id) > 0 ){
			D('Admin/Resume')->batchDelResume($id);
			WriteLog("ID:".implode(',', $id));
		}
		redirect(__URL__."/resume?JobID=$JobID&p=$NowPage");
	}
	
	function viewResume(){
		header("Content-Type:text/html; charset=utf-8");
		//参数有效性检查===========================
		$ResumeID = $_GET['ResumeID'];
		if( !is_numeric($ResumeID) ) return;
		$m = D('Admin/Resume');
		$Info = $m->findResume($ResumeID);
		$this->assign('Resume', $Info);
		$this->display();
	}
}