<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */
class AdminBaseAction extends BaseAction {
	function _initialize(){
		$mName = strtolower(ACTION_NAME);
		$NoCheckAction = array('login', 'verify','checklogin','showcode','logout'); //免登录验证模块
		if( !$this->isLogin() && !in_array($mName, $NoCheckAction)){ //没有登录，将返回登录页面
			$this->redirect("Public/login");
		}
		
		if( !$this->checkPurview() ){ //没有登录，将返回网站首页
			$this->redirect("Public/welcome");
		}
		
		$this->assign("AdminName", session("AdminName") );
		$this->assign("AdminGroupName", session("AdminGroupName") );
		
		$this->AdminPageSize = $GLOBALS['Config']['ADMIN_PAGE_SIZE'] <= 0 ? 20 : $GLOBALS['Config']['ADMIN_PAGE_SIZE'];
		$this->AdminRollPage = $GLOBALS['Config']['ADMIN_ROLL_PAGE'] <= 0 ? 30 : $GLOBALS['Config']['ADMIN_ROLL_PAGE'];
		$this->assign("AdminPageSize", $this->AdminPageSize );
		
		parent::_initialize();
		$this->assign('LanguageID', session('AdminLangSet'));
	}

	//权限检查 0:检查菜单，1：顶层菜单，2：树形频道
	function checkPurview(){
		$gid = session('AdminGroupID');
		if( $gid == 1 ) return true;  //超级管理员拥有所有权限
		
		$mName = strtolower( MODULE_NAME);
		$aName = strtolower( ACTION_NAME);
		$m = D('Admin/AdminGroup');
		if( $mName == 'channel') { //树形频道权限判断
			$list = $m->getChannelPurview( $gid );
			$id = $_REQUEST['ChannelID'];
		}else if( $mName == 'info' ){
			//已在info模块做了判断，这里无须判断
			return true;
			//$list = $m->getChannelPurview( $gid );
			//$id = $_REQUEST['ChannelID'];
		}else if( $mName == 'public' && $aName == 'memberleft') {//顶层菜单权限判断
			$list = $m->getMenuTopPurview( $gid );
			$id = $_REQUEST['MenuTopID'];
		}else{ //菜单权限判断
			$list = $m->getMenuPurview( $gid );
			$m1 = D('Admin/MenuOperation');
			$id = $m1->getMenuID(ACTION_NAME, MODULE_NAME, GROUP_NAME);
		}
		
		if( !is_numeric($id) ) return true; //不存在的菜单，不控制权限
		$list = explode(',', $list);
		if( in_array($id, $list) ){
			return true;
		}else{
			return false;
		}
	}
	
	//是否登录
	function isLogin(){
		$b = session("?AdminID") && session("?AdminName");
		return $b;
	}
	
	//模板上传[电脑模板和手机模板]
	function uploadTemplate() {
		set_time_limit(0);
		import("ORG.Net.UploadFile");
		$upload = new UploadFile();
		//设置上传文件大小
		$upload->maxSize  = $GLOBALS['Config']['MAX_UPLOAD_SIZE'] ; //最大上传大小
		//设置上传文件类型
		$upload->allowExts  = array('zip');
		//设置附件上传目录
		$upload->savePath =  RUNTIME_PATH; //模板上传到临时文件夹
		$upload->saveRule= time;
	
		if(!$upload->upload()) {
			$this->ajaxReturn(null, $upload->getErrorMsg() , 0);
		}else{
			$info =  $upload->getUploadFileInfo();
			//解压模板
			import('ORG.Util.PclZip');
			$tplDir = ($_POST['ishome'] == 1) ? TMPL_PATH.'Home/' : TMPL_PATH.'Wap/';
			$zipname = RUNTIME_PATH.$info[0]['savename'];
			$archive = new PclZip($zipname);
			if (($list = $archive->listContent()) == 0) {
				$this->ajaxReturn(null, '安装模板失败!' , 0);
			}else{
				//判断模板目录是否存在
				$currentDir = $tplDir.$list[0]['filename'];  //获取模板文件名
				if( is_dir($currentDir)){
					$this->ajaxReturn(null, '模板目录已经存在!请打开zip压缩包重命名根目录名,再重新安装!' , 0);
				}

				//判断是否是有效模板=====================================
				$count = count($list);
				$IsValid = false;
				for($n = 0; $n < $count; $n++){
				    $filename = strtolower($list[$n]['filename']);
					if( $list[$n]['folder'] == true && stripos($filename, 'channel/')  ){
						$IsValid = true;
						break;
					}
				}
                if( !$IsValid ){
                    $this->ajaxReturn(null, '无效模板压缩包!' , 0);
                }
                //================================================

                //模板里的文件名不能包含php、jsp、asp、aspx等危险文件============
                $map = array('php'=>true, 'jsp'=>true, 'asp'=>true, 'aspx'=>true);
                for($n = 0; $n < $count; $n++){
                    if( $list[$n]['folder']) continue;
                    $filename = strtolower($list[$n]['filename']);
                    if(stripos($filename, '/common_en.php') || stripos($filename, '/common_cn.php') ){

                    }else{
                        $ext = strtolower(yd_file_ext($filename));
                        if(isset($map[$ext])){
                            $this->ajaxReturn(null, "模板不能包含{$ext}文件" , 0);
                        }
                    }
                }
                //==============================================
			}
				
			//解压模板压缩包到模板目录
			if ($archive->extract(PCLZIP_OPT_PATH, $tplDir) == 0) {
				@unlink($zipname);
				$this->ajaxReturn(null, '安装模板失败!' , 0);
			}else{
				@unlink($zipname);
                $this->checkTemplateLangFile($currentDir);
				$this->ajaxReturn(null, '安装模板成功!' , 1);
			}
		}
	}

    /**
     * 检查模板语言包php文件是否有效
     * 如果是无效的则直接删除
     */
	private function checkTemplateLangFile($currentDir){
        $langs = array('cn', 'en');
        foreach($langs as $v){
            $langFile = "{$currentDir}Lang/common_{$v}.php";
            if(file_exists($langFile)){
                $content = file_get_contents($langFile);
                $content = trim($content, '<?php');
                $content = trim($content);
                if('return array' != substr($content,0,12)){
                    @unlink($langFile);
                }
            }
        }
    }
	
	//判断是否是一个有效的模板文件 $fileFullName文件全路径
	//防止非法保存文件
	function isValidTplFile($fileFullName, $type='Home'){
	    //去掉xml，容易产生xml注入漏洞
		$allowedExt = array('html','htm','shtml','js','css');
		$ext = strtolower(yd_file_ext($fileFullName));
		if( !in_array($ext, $allowedExt) || !file_exists($fileFullName) ){
			return false;
		}
		return true;
	}
	
	//编辑模板文件前预处理
	function preModifyTplFile($fileFullName){
		$IsWritable = yd_is_writable($fileFullName) ? 1 : 0;
		$BgColorText = ($IsWritable) ? '' : ' background:#eee;';
		$ReadOnlyText = ($IsWritable) ? '' : ' readonly="readonly" ';
		$DisableText = ($IsWritable) ? '' : ' disabled="disabled" ';
		$this->assign('IsWritable', $IsWritable);
		$this->assign('BgColorText', $BgColorText);
		$this->assign('ReadOnlyText', $ReadOnlyText);
		$this->assign('DisableText', $DisableText);
	}
	
	//切换数据状态（主要是2种状态）
	function toggleStatus(){
		$id = intval($_GET['id']);
		$fieldValue = intval( $_GET['FieldValue']);
		$fieldName = $_GET['FieldName'];
		$tableName = strtolower($_GET['TableName']);
		if( $id <= 0 || empty($fieldName) || empty($tableName)){
			$this->ajaxReturn(null, '参数错误' , 0);
		}else{
			switch($tableName){
				case 'link':
					if($fieldName == 'IsEnable') D('Admin/Link')->where("LinkID={$id}")->setField('IsEnable',$fieldValue); break;
				case 'mail_class':
					if( $fieldName == 'IsEnable') D('Admin/MailClass')->where("MailClassID={$id}")->setField('IsEnable',$fieldValue); break;
				case 'mail':
					if( $fieldName == 'IsEnable') D('Admin/Mail')->where("MailID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'ad_group':
					if($fieldName == 'IsEnable') D('Admin/AdGroup')->where("AdGroupID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'ad':
					if( $fieldName == 'IsEnable') D('Admin/Ad')->where("AdID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'banner':
					if( $fieldName == 'IsEnable') D('Admin/Banner')->where("BannerID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'member':
					if( $fieldName == 'IsLock') D('Admin/Member')->where("MemberID={$id}")->setField('IsLock',$fieldValue);
					if( $fieldName == 'IsCheck') D('Admin/Member')->where("MemberID={$id}")->setField('IsCheck',$fieldValue);break;
				case 'admin':
					if( $fieldName == 'IsLock') D('Admin/Admin')->where("AdminID={$id}")->setField('IsLock',$fieldValue);break;
				case 'support':
					if( $fieldName == 'IsEnable') D('Admin/Support')->where("SupportID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'shipping':
					if( $fieldName == 'IsEnable') D('Admin/Shipping')->where("ShippingID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'pay':
					if( $fieldName == 'IsEnable') D('Admin/Pay')->where("PayID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'job':
					if( $fieldName == 'IsEnable') D('Admin/Job')->where("JobID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'tag':
					if( $fieldName == 'IsEnable') D('Admin/Tag')->where("TagID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'type':
					if( $fieldName == 'IsEnable') D('Admin/Type')->where("TypeID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'special':
					if( $fieldName == 'IsEnable') D('Admin/Special')->where("SpecialID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'channel':
					if( $fieldName == 'IsShow') D('Admin/Channel')->where("ChannelID={$id}")->setField('IsShow',$fieldValue);
					if( $fieldName == 'IsLock') D('Admin/Channel')->where("ChannelID={$id}")->setField('IsLock',$fieldValue);
					if( $fieldName == 'IsEnable') D('Admin/Channel')->where("ChannelID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'info':
					if( $fieldName == 'IsEnable') D('Admin/Info')->where("InfoID={$id}")->setField('IsEnable',$fieldValue);
					if( $fieldName == 'IsCheck') D('Admin/Info')->where("InfoID={$id}")->setField('IsCheck',$fieldValue);break;
				case 'type_group':
					if( $fieldName == 'IsEnable') D('Admin/TypeGroup')->where("TypeGroupID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'type_attribute':
					if( $fieldName == 'IsEnable') D('Admin/TypeAttribute')->where("TypeAttributeID={$id}")->setField('IsEnable',$fieldValue);
					if( $fieldName == 'IsSearch') D('Admin/TypeAttribute')->where("TypeAttributeID={$id}")->setField('IsSearch',$fieldValue);break;
				case 'channelmodel':
					if( $fieldName == 'IsEnable') D('Admin/ChannelModel')->where("ChannelModelID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'guestbook':
					if( $fieldName == 'IsCheck') D('Admin/Guestbook')->where("MessageID={$id}")->setField('IsCheck',$fieldValue);break;
				case 'comment':
					if( $fieldName == 'IsCheck') D('Admin/Comment')->where("CommentID={$id}")->setField('IsCheck',$fieldValue);break;
				case 'wx_menu':
					if( $fieldName == 'IsEnable') D('Admin/WxMenu')->where("MenuID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'wx_reply':
					if( $fieldName == 'IsEnable') D('Admin/WxReply')->where("ReplyID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'wx_app':
					if( $fieldName == 'IsEnable') D('Admin/WxApp')->where("AppID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'wx_gift':
					if( $fieldName == 'IsEnable') D('Admin/WxGift')->where("GiftID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'wx_coupon':
					if( $fieldName == 'IsEnable') D('Admin/WxCoupon')->where("CouponID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'secret':
					if( $fieldName == 'IsEnable') D('Admin/Secret')->where("SecretID={$id}")->setField('IsEnable',$fieldValue);break;
				case 'menu_top':
					if($fieldName == 'IsEnable') D('Admin/MenuTop')->where("MenuTopID={$id}")->setField('IsEnable',$fieldValue); break;
				case 'menu_group':
					if($fieldName == 'IsEnable') D('Admin/MenuGroup')->where("MenuGroupID={$id}")->setField('IsEnable',$fieldValue); break;
				case 'menu':
					if($fieldName == 'IsEnable') {
						D('Admin/Menu')->where("MenuID={$id}")->setField('IsEnable',$fieldValue); 
						//禁止三级分销插件的同时，需要关闭分销功能
						if($fieldValue==0 && $id==148){
							$mc = D('Admin/Config');
							$mc->where("ConfigID=293")->setField('ConfigValue',0);
						}
					}
					break;
				case 'area':
					if($fieldName == 'IsEnable') D('Admin/Area')->where("AreaID={$id}")->setField('IsEnable',$fieldValue); break;
			}
			$this->ajaxReturn(null, '设置成功' , 1);
		}
	}
}