<?php 
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */
class YdUpgrade{
	//次版本号只能是一位
    private $_lastError = ''; //上次错误
	private $_upgradeUrl = 'http://upgrade.youdiancms.com/';

    private $_currentVersion = '';   //当前版本
	private $_info = array(); //版本元数据信息

	private $_cachePath = null;  //升级包临时解压位置
    private $_unzipPath = '';      //解压路径
    private $_sqlPath = ''; //升级sql路径
	
	function __construct(){
        $this->_currentVersion = CMS_VERSION;
        $this->_cachePath = RUNTIME_PATH.'upgrade';
        $this->_sqlPath = APP_DATA_PATH . 'upgradesql/';
	}

	//检测是否可以升级
    function canUpgrade(){
        $b = file_exists(APP_DATA_PATH.'noupgrade.lock');
        if($b){
            return '系统已经锁定，不能在线升级！';
        }

        //升级元数据，t参数防止缓存
        $url = $this->_upgradeUrl.'version.json?t='.time();
        $json = @file_get_contents($url);
        $data = json_decode($json, true);
        if( empty($data) ) {
            return '无法连接版本服务器！';
        }
        $this->_info = $data;
        //默认情况下，在第一个版本低于第二个时，version_compare() 返回 -1；如果两者相等，返回 0；第二个版本更低时则返回 1。
        if(version_compare($data['version'], $this->_currentVersion) <= 0) {
            return '已经是最新版本';
        }
        return true;
    }

    //获取升级元数据
	function getInfo(){
	    return $this->_info;
    }

    //获取最后错误数据
    function getLastError(){
        return $this->_lastError;
    }

	//开始升级
	function start(){
		@set_time_limit(0);
		sleep(20);
        $dirlistToCheck = array(
            'App/',
            'App/Lib/',
            'App/Tpl/Admin/',
            'App/Tpl/Member/',
            'App/Core/',
            'App/Lang/',
            'App/Common/',
        );
        foreach($dirlistToCheck as $dir){
            if(!yd_is_writable('./'.$dir)){
                $this->_lastError = "{$dir}目录没有写入权限";
                return false;
            }
        }

        //先删除，再创建
        @deldir( $this->_cachePath  );
        @mkdir( $this->_cachePath );
		//删除之前的升级脚本，防止冲突
        if( is_dir($this->_sqlPath) ){
            @deldir($this->_sqlPath);
        }

        //升级包名称：upgrade+版本号.zip
		$filename = "upgrade{$this->_info['version']}.zip";
        $url = "{$this->_upgradeUrl}{$filename}?rand1=".date('Ymd');
        $savePath = $this->_cachePath.'/'.$filename; //保存路径
        $this->_unzipPath = $this->_cachePath.'/'.basename($filename, '.zip'); //解压路径

        //第1步：下载zip压缩包
        @file_put_contents($savePath,  @file_get_contents($url) );

        //第2步：解压到指定目录
        import('ORG.Util.PclZip');
        $zip = new PclZip($savePath);
        if( $zip->extract(PCLZIP_OPT_PATH, $this->_unzipPath, PCLZIP_OPT_REPLACE_NEWER) == 0 ){
            $this->_lastError = '解压失败！';
            return false;
        }

        //第3步：覆盖升级包所有文件
        import('ORG.Io.Dir');
        $dir = new Dir();
        $dir->copyDir($this->_unzipPath, './');

        //第4步：升级数据库脚本（必须放置覆盖文件后，升级脚本本身存在bug更容易解决问题）
        $isSuccess = $this->_upgradeDb(); //更新数据库
        if(!$isSuccess) {
            $this->_lastError = '升级数据库失败！';
            return false;
        }
        //第5步：清除所有系统缓存
        YdCache::writeAll();
		return true;
	}

    /**
     * 执行脚本升级数据库
     */
	private function _upgradeDb(){
        $filelist = glob("{$this->_sqlPath}upgrade*.sql");
        sort($filelist); //对脚本文件升序排列
        foreach ($filelist as $fullFileName){
            $name = basename($fullFileName, '.sql');
            $temp = explode('_', $name);
            if(2 != count($temp)) continue;
            // 升级包名称：upgrade3位序号_版本号.zip 如：upgrade001_9.0.1.sql
            $sqlVersion = $temp[1];
            if(version_compare($sqlVersion, $this->_currentVersion) > 0) {
                $this->_executeSqlFile($fullFileName);
            }
        }
        return true;
    }
	
	//更新数据库
	private function _executeSqlFile($sql){
		if( !file_exists($sql) ) return true;
		$content = @file_get_contents($sql);
		//升级脚本表前缀用[@DbPrefix]替代
		$dbPrefix = C('DB_PREFIX');
        $content = str_ireplace('[@DbPrefix]', $dbPrefix, $content);
		$db = M();
		$sqlList = sql_split($content);
		foreach ($sqlList as $query) {
			$query = trim($query);
			if ($query) {
				$result = @$db->execute($query);
			}
		}
		return true;
	}
}