<?php
//通信秘钥管理
class SecretModel extends Model{
	function getSecret($options = array()){
		if( isset($options['IsEnable']) && $options['IsEnable'] != -1){
			$IsEnable = intval($options['IsEnable']);
			$this->where("IsEnable=$IsEnable");
		}
		$result = $this->order('SecretID desc')->select();
		return $result;
	}
	
	function findSecret($id, $options = array() ){
		if( !is_numeric($id) ) return false;
		$where['SecretID'] = intval($id);
		if( isset($options['IsEnable']) && $options['IsEnable'] != -1 ) {
			$where['IsEnable'] = intval($options['IsEnable']);
		}
		$result = $this->where($where)->find();
		return $result;
	}
	
	/**
	 * 检查是否调用指定api的权限
	 * @param string $AppID
	 * @param string $ApiFunction Api函数名称
	 */
	function checkSecret($AppID, $ApiFunction){
		$AppID = addslashes(stripslashes($AppID));
		$ApiFunction = addslashes(stripslashes($ApiFunction));
		$Api = get_api_list();
		if( !isset($Api[$ApiFunction]) ) return false;
		$ApiID = $Api[$ApiFunction]['ApiID'];
		$where = "AppID='{$AppID}' and FIND_IN_SET({$ApiID}, ApiList)";
		$AppSecret = $this->where($where)->getField('AppSecret');
		return $AppSecret;
	}
	
	function getAppSecret($appID){
		$where['AppID'] = intval($appID);
		$where['IsEnable'] = 1;
		$AppSecret = $this->where($where)->getField('AppSecret');
		return $AppSecret;
	}
}