
DROP TABLE IF EXISTS `youdian_ad`;
CREATE TABLE `youdian_ad` (
  `AdID` int(11) NOT NULL AUTO_INCREMENT,
  `AdTypeID` tinyint(4) DEFAULT NULL,
  `AdName` varchar(50) DEFAULT NULL,
  `AdContent` text,
  `AdUrl` varchar(255) DEFAULT NULL,
  `AdDescription` varchar(255) DEFAULT NULL,
  `AdTime` datetime DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `AdGroupID` int(11) DEFAULT NULL,
  `AdOrder` int(11) DEFAULT '0',
  PRIMARY KEY (`AdID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_ad_group`;
CREATE TABLE `youdian_ad_group` (
  `AdGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `AdGroupName` varchar(50) DEFAULT NULL,
  `AdGroupDescription` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`AdGroupID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_ad_type`;
CREATE TABLE `youdian_ad_type` (
  `AdTypeID` tinyint(4) NOT NULL,
  `AdTypeName` char(20) DEFAULT NULL,
  PRIMARY KEY (`AdTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_admin`;
CREATE TABLE `youdian_admin` (
  `AdminID` int(11) NOT NULL AUTO_INCREMENT,
  `AdminName` varchar(50) DEFAULT NULL,
  `MemberID` int(11) DEFAULT NULL,
  `AdminGroupID` int(11) DEFAULT NULL,
  `AdminPassword` varchar(64) DEFAULT NULL,
  `LastLoginTime` datetime DEFAULT NULL,
  `LastLoginIP` varchar(15) DEFAULT NULL,
  `IsLock` tinyint(4) NOT NULL DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `LoginFailCount` tinyint(4) NOT NULL DEFAULT '0',
  `LoginCount` int(11) DEFAULT '0',
  PRIMARY KEY (`AdminID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_admin_group`;
CREATE TABLE `youdian_admin_group` (
  `AdminGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `AdminGroupName` varchar(50) DEFAULT NULL,
  `AdminGroupRemark` varchar(255) DEFAULT NULL,
  `MenuPurview` text,
  `MenuTopPurview` varchar(512) DEFAULT NULL,
  `MenuGroupPurview` varchar(512) DEFAULT NULL,
  `ChannelPurviewcn` text,
  `ChannelPurviewen` text,
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`AdminGroupID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_active`;
CREATE TABLE `youdian_app_active` (
  `AppActiveID` int(11) NOT NULL AUTO_INCREMENT,
  `Uuid` varchar(20) DEFAULT '',
  `StartTime` datetime DEFAULT NULL,
  `Ip` varchar(20) DEFAULT '',
  PRIMARY KEY (`AppActiveID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_feedback`;
CREATE TABLE `youdian_app_feedback` (
  `AppFeedbackID` int(11) NOT NULL AUTO_INCREMENT,
  `AppFeedbackContent` varchar(512) DEFAULT '',
  `AppFeedbackImage` varchar(200) DEFAULT '',
  `AppFeedbackContact` varchar(50) DEFAULT '',
  `MemberID` int(11) DEFAULT '0',
  `Uuid` varchar(50) DEFAULT '',
  `AppFeedbackIp` varchar(20) DEFAULT '',
  `AppFeedbackTime` datetime DEFAULT NULL,
  PRIMARY KEY (`AppFeedbackID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_message`;
CREATE TABLE `youdian_app_message` (
  `AppMessageID` int(11) NOT NULL AUTO_INCREMENT,
  `AppMessageType` tinyint(4) DEFAULT '1',
  `AppMessageTitle` varchar(255) DEFAULT '',
  `AppMessageContent` text,
  `AppMessageParameter` varchar(255) DEFAULT '',
  `AppMessageTime` datetime DEFAULT NULL,
  PRIMARY KEY (`AppMessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_stat`;
CREATE TABLE `youdian_app_stat` (
  `Uuid` varchar(100) NOT NULL,
  `Platform` varchar(20) DEFAULT '',
  `Model` varchar(50) DEFAULT '',
  `Manufacturer` varchar(50) DEFAULT '',
  `Ip` varchar(20) DEFAULT '',
  `Time` datetime DEFAULT NULL,
  PRIMARY KEY (`Uuid`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_area`;
CREATE TABLE `youdian_area` (
  `AreaID` smallint(11) unsigned NOT NULL AUTO_INCREMENT,
  `AreaName` varchar(120) NOT NULL DEFAULT '',
  `AreaNameEn` varchar(120) DEFAULT '',
  `AreaOrder` smallint(11) DEFAULT '0',
  `Parent` smallint(11) unsigned NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`AreaID`)
) AUTO_INCREMENT=3432 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_attribute`;
CREATE TABLE `youdian_attribute` (
  `AttributeID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelModelID` int(11) DEFAULT NULL,
  `FieldName` varchar(50) DEFAULT NULL,
  `FieldType` varchar(20) DEFAULT NULL,
  `DisplayName` varchar(255) DEFAULT NULL,
  `DisplayType` varchar(20) DEFAULT NULL,
  `DisplayOrder` int(11) DEFAULT '0',
  `DisplayWidth` varchar(10) DEFAULT NULL,
  `DisplayHeight` varchar(10) DEFAULT NULL,
  `DisplayClass` varchar(20) DEFAULT NULL,
  `DisplayValue` varchar(255) DEFAULT NULL,
  `DisplayHelpText` varchar(255) DEFAULT NULL,
  `IsValidate` tinyint(4) DEFAULT NULL,
  `ValidateRule` varchar(255) DEFAULT NULL,
  `GroupID` int(4) DEFAULT NULL,
  `IsRequire` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`AttributeID`)
) AUTO_INCREMENT=688 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_banner`;
CREATE TABLE `youdian_banner` (
  `BannerID` int(11) NOT NULL AUTO_INCREMENT,
  `BannerName` varchar(50) DEFAULT NULL,
  `BannerGroupID` int(11) NOT NULL DEFAULT '1',
  `BannerImage` varchar(512) DEFAULT NULL,
  `BannerThumbnail` varchar(512) DEFAULT NULL,
  `BannerUrl` varchar(512) DEFAULT NULL,
  `BannerOrder` int(11) NOT NULL DEFAULT '0',
  `BannerDescription` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`BannerID`)
) AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_banner_group`;
CREATE TABLE `youdian_banner_group` (
  `BannerGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `BannerGroupName` char(50) DEFAULT NULL,
  `BannerGroupOrder` int(11) NOT NULL DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`BannerGroupID`)
) AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_cart`;
CREATE TABLE `youdian_cart` (
  `CartID` int(11) NOT NULL AUTO_INCREMENT,
  `ProductID` int(11) DEFAULT NULL,
  `ProductQuantity` int(11) DEFAULT '1',
  `MemberID` int(11) DEFAULT '0',
  `LanguageID` tinyint(4) DEFAULT '1',
  `AttributeValueID` varchar(200) DEFAULT '',
  PRIMARY KEY (`CartID`)
) AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_cash`;
CREATE TABLE `youdian_cash` (
  `CashID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) NOT NULL DEFAULT '0',
  `CashQuantity` double DEFAULT '0',
  `CashType` tinyint(4) DEFAULT '1',
  `CashStatus` tinyint(4) DEFAULT '2',
  `CashTime` datetime DEFAULT NULL,
  `PayID` int(11) DEFAULT '0',
  `CashRemark` varchar(256) DEFAULT '',
  `BankName` varchar(50) DEFAULT '',
  `BankAccount` varchar(50) DEFAULT '',
  `OwnerName` varchar(10) DEFAULT '',
  `OrderID` int(11) DEFAULT '0',
  PRIMARY KEY (`CashID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_channel`;
CREATE TABLE `youdian_channel` (
  `ChannelID` int(11) NOT NULL AUTO_INCREMENT,
  `Parent` int(11) DEFAULT NULL,
  `HasChild` tinyint(4) DEFAULT NULL,
  `ChannelName` varchar(50) DEFAULT NULL,
  `ChannelSName` varchar(20) DEFAULT NULL,
  `ChannelContent` longtext,
  `ChannelSContent` text,
  `ChannelModelID` int(11) DEFAULT NULL,
  `ChannelTarget` varchar(10) DEFAULT NULL,
  `LinkUrl` varchar(512) DEFAULT NULL,
  `HasPicture` tinyint(4) DEFAULT '0',
  `ChannelPicture` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Keywords` varchar(255) DEFAULT NULL,
  `Description` varchar(512) DEFAULT NULL,
  `Html` varchar(50) DEFAULT NULL,
  `ReadLevel` varchar(255) DEFAULT NULL,
  `PageSize` int(11) DEFAULT '20',
  `ChannelOrder` int(11) NOT NULL DEFAULT '0',
  `IndexTemplate` varchar(50) DEFAULT NULL,
  `ReadTemplate` varchar(50) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IsLock` tinyint(4) NOT NULL DEFAULT '0',
  `IsShow` tinyint(4) NOT NULL DEFAULT '1',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `IsHtml` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `ChannelIcon` varchar(255) DEFAULT NULL,
  `ChannelStyle` tinyint(4) DEFAULT '0',
  `ChannelAlbum` text,
  `ChannelRelation` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ChannelID`)
) AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_channel_model`;
CREATE TABLE `youdian_channel_model` (
  `ChannelModelID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelModelName` varchar(50) DEFAULT NULL,
  `ChannelModelOrder` int(11) NOT NULL DEFAULT '0',
  `ChannelModelTable` varchar(50) DEFAULT NULL,
  `ChannelModelDescription` varchar(255) DEFAULT NULL,
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IndexTemplate` varchar(50) DEFAULT NULL,
  `ReadTemplate` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ChannelModelID`)
) AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_collect`;
CREATE TABLE `youdian_collect` (
  `CollectID` int(11) NOT NULL AUTO_INCREMENT,
  `CollectName` varchar(255) DEFAULT NULL,
  `ChannelID` int(11) DEFAULT NULL,
  `ListUrlPara` text,
  `DetailUrlPara` text,
  `FieldPara` text,
  `ReplacePara` text,
  `OtherPara` text,
  `CreateTime` datetime DEFAULT NULL,
  `CollectDescription` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`CollectID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_comment`;
CREATE TABLE `youdian_comment` (
  `CommentID` int(11) NOT NULL AUTO_INCREMENT,
  `InfoID` int(11) NOT NULL,
  `GuestID` int(11) DEFAULT '0',
  `GuestName` varchar(50) DEFAULT '',
  `GuestIP` varchar(20) DEFAULT '',
  `CommentContent` text,
  `CommentTime` datetime DEFAULT NULL,
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `CommentRank` tinyint(4) DEFAULT '3',
  `Parent` int(11) DEFAULT '0',
  `CommentPicture` varchar(512) DEFAULT '',
  PRIMARY KEY (`CommentID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_config`;
CREATE TABLE `youdian_config` (
  `ConfigID` int(11) NOT NULL AUTO_INCREMENT,
  `ConfigName` varchar(50) DEFAULT NULL,
  `ConfigValue` text,
  `ConfigDescription` varchar(255) DEFAULT NULL,
  `ConfigFile` varchar(20) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ConfigID`)
) AUTO_INCREMENT=330 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_consignee`;
CREATE TABLE `youdian_consignee` (
  `ConsigneeID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) DEFAULT '0',
  `ConsigneeRealName` varchar(20) DEFAULT '',
  `ConsigneeGender` tinyint(4) DEFAULT '0',
  `ConsigneeEmail` varchar(50) DEFAULT '',
  `ConsigneeMobile` varchar(20) DEFAULT '',
  `ConsigneeTelephone` varchar(20) DEFAULT '',
  `ConsigneeAddress` varchar(100) DEFAULT '',
  `ConsigneeAddressAlias` varchar(20) DEFAULT '',
  `ConsigneePostcode` varchar(20) DEFAULT '',
  `IsDefault` tinyint(4) DEFAULT '0',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`ConsigneeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_coupon`;
CREATE TABLE `youdian_coupon` (
  `CouponID` int(11) NOT NULL AUTO_INCREMENT,
  `CouponName` varchar(50) DEFAULT '',
  `CouponMoney` double DEFAULT '20',
  `ConsumeMoney` double DEFAULT '100',
  `CouponQuantity` int(11) DEFAULT '0',
  `CouponType` tinyint(4) DEFAULT '1',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `CouponTime` datetime DEFAULT NULL,
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`CouponID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_coupon_send`;
CREATE TABLE `youdian_coupon_send` (
  `CouponSendID` int(11) NOT NULL AUTO_INCREMENT,
  `CouponID` int(11) DEFAULT '0',
  `MemberID` int(11) DEFAULT '0',
  `CouponCode` varchar(20) DEFAULT '',
  `CouponSendTime` datetime DEFAULT NULL,
  `OrderID` int(11) DEFAULT '0',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`CouponSendID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_customer`;
CREATE TABLE `youdian_customer` (
  `CustomerID` int(11) NOT NULL AUTO_INCREMENT,
  `Host` varchar(50) NOT NULL,
  `OS` varchar(20) DEFAULT NULL,
  `Version` varchar(10) DEFAULT NULL,
  `Edition` varchar(20) DEFAULT NULL,
  `Name` varchar(50) DEFAULT NULL,
  `Contact` varchar(20) DEFAULT NULL,
  `Telephone` varchar(20) DEFAULT NULL,
  `Mobile` varchar(20) DEFAULT NULL,
  `QQ` varchar(20) DEFAULT NULL,
  `TaoBao` varchar(20) DEFAULT NULL,
  `Email` varchar(20) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Remark` varchar(255) DEFAULT NULL,
  `IsAuthorize` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`CustomerID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_delivery_time`;
CREATE TABLE `youdian_delivery_time` (
  `DeliveryTimeID` int(11) NOT NULL DEFAULT '0',
  `DeliveryTimeName` varchar(100) DEFAULT NULL,
  `DeliveryTimeOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`DeliveryTimeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_distributor_level`;
CREATE TABLE `youdian_distributor_level` (
  `DistributorLevelID` tinyint(4) NOT NULL AUTO_INCREMENT,
  `DistributorLevelName` varchar(50) DEFAULT '',
  `CommissionRate1` double DEFAULT '0',
  `CommissionRate2` double DEFAULT '0',
  `CommissionRate3` double DEFAULT '0',
  `CommissionThreshold` double DEFAULT '0',
  `DistributorLevelRemark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`DistributorLevelID`)
) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_favorite`;
CREATE TABLE `youdian_favorite` (
  `FavoriteID` int(11) NOT NULL AUTO_INCREMENT,
  `InfoID` int(11) NOT NULL,
  `MemberID` int(11) NOT NULL,
  `FavoriteTime` datetime DEFAULT NULL,
  PRIMARY KEY (`FavoriteID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_guestbook`;
CREATE TABLE `youdian_guestbook` (
  `MessageID` int(11) NOT NULL AUTO_INCREMENT,
  `GuestID` int(11) DEFAULT '0',
  `GuestName` varchar(50) DEFAULT NULL,
  `GuestIP` varchar(20) DEFAULT NULL,
  `Contact` text,
  `MessageTitle` text,
  `MessageContent` text,
  `MessageTime` datetime DEFAULT NULL,
  `AnswerContent` text,
  `AnswerTime` datetime DEFAULT NULL,
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `Email` text,
  `Address` text,
  `Gender` text,
  `QQ` text,
  PRIMARY KEY (`MessageID`)
) AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_history`;
CREATE TABLE `youdian_history` (
  `HistoryID` int(11) NOT NULL AUTO_INCREMENT,
  `InfoID` int(11) NOT NULL DEFAULT '0',
  `MemberID` int(11) NOT NULL DEFAULT '0',
  `HistoryTime` datetime DEFAULT NULL,
  PRIMARY KEY (`HistoryID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_info`;
CREATE TABLE `youdian_info` (
  `InfoID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelID` int(11) DEFAULT NULL,
  `SpecialID` varchar(512) DEFAULT NULL,
  `MemberID` int(11) DEFAULT NULL,
  `InfoTitle` varchar(100) DEFAULT NULL,
  `InfoSContent` text,
  `InfoContent` longtext,
  `HasPicture` tinyint(4) NOT NULL DEFAULT '0',
  `InfoPicture` varchar(255) DEFAULT NULL,
  `ReadLevel` varchar(255) DEFAULT NULL,
  `InfoAttachment` varchar(255) DEFAULT NULL,
  `HasAttachment` tinyint(4) NOT NULL DEFAULT '0',
  `IsLinkUrl` tinyint(4) NOT NULL DEFAULT '0',
  `LinkUrl` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Keywords` varchar(255) DEFAULT NULL,
  `Description` varchar(512) DEFAULT NULL,
  `InfoOrder` int(11) NOT NULL DEFAULT '0',
  `InfoTime` datetime DEFAULT NULL,
  `InfoAuthor` varchar(50) DEFAULT NULL,
  `InfoHit` int(11) DEFAULT '0',
  `InfoFrom` varchar(50) DEFAULT NULL,
  `LabelID` varchar(512) DEFAULT NULL,
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `IsHtml` tinyint(4) NOT NULL DEFAULT '1',
  `Html` varchar(50) DEFAULT NULL,
  `InfoAlbum` text,
  `InfoRelation` varchar(255) DEFAULT NULL,
  `Tag` varchar(255) DEFAULT '',
  `InfoPrice` double DEFAULT '0',
  `ChannelIDEx` varchar(255) DEFAULT '',
  `TypeID` int(11) DEFAULT '0',
  `ProvinceID` int(11) DEFAULT '0',
  `CityID` int(11) DEFAULT '0',
  `DistrictID` int(11) DEFAULT '0',
  `TownID` int(11) DEFAULT '0',
  `MarketPrice` double DEFAULT '0',
  `SalesCount` int(11) DEFAULT '0',
  `StockCount` int(11) DEFAULT '9999',
  `GivePoint` int(11) DEFAULT '0',
  `ExchangePoint` int(11) DEFAULT '0',
  `Longitude` double DEFAULT '0',
  `Latitude` double DEFAULT '0',
  `Commission` double DEFAULT '0',
  `InfoIP` varchar(20) DEFAULT '',
  PRIMARY KEY (`InfoID`)
) AUTO_INCREMENT=277 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_job`;
CREATE TABLE `youdian_job` (
  `JobID` int(11) NOT NULL AUTO_INCREMENT,
  `JobName` varchar(50) DEFAULT NULL,
  `Education` varchar(50) DEFAULT NULL,
  `Gender` varchar(10) DEFAULT NULL,
  `Age` varchar(50) DEFAULT NULL,
  `Salary` varchar(50) DEFAULT NULL,
  `Language` varchar(20) DEFAULT NULL,
  `Number` varchar(20) DEFAULT NULL,
  `Workplace` varchar(50) DEFAULT NULL,
  `Expiration` varchar(20) DEFAULT NULL,
  `Requirement` text,
  `JobOrder` int(11) DEFAULT '0',
  `Time` datetime DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`JobID`)
) AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_label`;
CREATE TABLE `youdian_label` (
  `LabelID` int(11) NOT NULL AUTO_INCREMENT,
  `LabelName` char(20) DEFAULT NULL,
  `ChannelModelID` int(11) DEFAULT NULL,
  `LabelOrder` int(11) DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LabelID`)
) AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_language`;
CREATE TABLE `youdian_language` (
  `LanguageID` int(11) NOT NULL AUTO_INCREMENT,
  `LanguageName` varchar(20) DEFAULT NULL,
  `LanguageMark` varchar(10) DEFAULT NULL,
  `LanguageIcon` varchar(255) DEFAULT NULL,
  `LanguageOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LanguageID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_link`;
CREATE TABLE `youdian_link` (
  `LinkID` int(11) NOT NULL AUTO_INCREMENT,
  `LinkClassID` int(11) DEFAULT NULL,
  `LinkName` varchar(50) DEFAULT NULL,
  `LinkType` tinyint(4) DEFAULT '0',
  `LinkUrl` varchar(255) DEFAULT NULL,
  `LinkLogo` varchar(255) DEFAULT NULL,
  `LinkOrder` int(11) NOT NULL DEFAULT '0',
  `LinkDescription` varchar(512) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LinkID`)
) AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_link_class`;
CREATE TABLE `youdian_link_class` (
  `LinkClassID` int(11) NOT NULL AUTO_INCREMENT,
  `LinkClassName` varchar(50) DEFAULT NULL,
  `LinkClassOrder` int(11) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LinkClassID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_log`;
CREATE TABLE `youdian_log` (
  `LogID` int(11) NOT NULL AUTO_INCREMENT,
  `LogType` tinyint(4) DEFAULT '1',
  `UserAction` varchar(255) DEFAULT NULL,
  `UserName` varchar(100) DEFAULT NULL,
  `UserIP` varchar(50) DEFAULT NULL,
  `UserCity` varchar(50) DEFAULT NULL,
  `LogTime` datetime DEFAULT NULL,
  `LogDescription` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LogID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_mail`;
CREATE TABLE `youdian_mail` (
  `MailID` int(11) NOT NULL AUTO_INCREMENT,
  `MailClassID` int(11) DEFAULT NULL,
  `MailAccount` varchar(50) DEFAULT NULL,
  `Name` varchar(50) DEFAULT NULL,
  `Telephone` varchar(20) DEFAULT NULL,
  `Address` varchar(1024) DEFAULT NULL,
  `AddTime` datetime DEFAULT NULL,
  `Remark` varchar(1024) DEFAULT NULL,
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MailID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_mail_class`;
CREATE TABLE `youdian_mail_class` (
  `MailClassID` int(11) NOT NULL AUTO_INCREMENT,
  `MailClassName` varchar(50) DEFAULT NULL,
  `MailClassOrder` int(11) NOT NULL DEFAULT '0',
  `MailClassDescription` varchar(1024) DEFAULT NULL,
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MailClassID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_mail_send`;
CREATE TABLE `youdian_mail_send` (
  `MailSendID` int(11) NOT NULL AUTO_INCREMENT,
  `MailTitle` varchar(255) DEFAULT NULL,
  `MailContent` text,
  `AddTime` datetime DEFAULT NULL,
  `SendTime` datetime DEFAULT NULL,
  `SendLog` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MailSendID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_member`;
CREATE TABLE `youdian_member` (
  `MemberID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberGroupID` int(11) DEFAULT '1',
  `MemberName` varchar(50) DEFAULT NULL,
  `MemberGender` tinyint(4) DEFAULT '1',
  `MemberRealName` varchar(50) DEFAULT NULL,
  `MemberPassword` varchar(64) DEFAULT NULL,
  `MemberBirthday` date DEFAULT NULL,
  `MemberAddress` varchar(100) DEFAULT NULL,
  `MemberPostCode` varchar(6) DEFAULT NULL,
  `MemberEmail` varchar(50) DEFAULT NULL,
  `MemberTelephone` varchar(20) DEFAULT NULL,
  `MemberMobile` varchar(20) DEFAULT NULL,
  `MemberQQ` varchar(20) DEFAULT NULL,
  `MemberQuestion` varchar(50) DEFAULT NULL,
  `MemberAnswer` varchar(50) DEFAULT NULL,
  `LastLoginTime` datetime DEFAULT NULL,
  `LastLoginIP` varchar(15) DEFAULT NULL,
  `RegisterTime` datetime DEFAULT NULL,
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `IsLock` tinyint(4) NOT NULL DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `WxID` varchar(50) DEFAULT NULL,
  `WxName` varchar(50) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `Position` varchar(100) DEFAULT NULL,
  `CardNumber` varchar(20) DEFAULT NULL,
  `CardTime` datetime DEFAULT NULL,
  `InviterID` int(11) DEFAULT '0',
  `MemberAvatar` varchar(200) DEFAULT NULL,
  `OpenID` varchar(200) DEFAULT NULL,
  `LoginCount` int(11) DEFAULT '0',
  `LoginFailCount` tinyint(4) DEFAULT '0',
  `RegisterIP` varchar(15) DEFAULT '',
  `IsDistributor` tinyint(4) DEFAULT '0',
  `DistributorLevelID` tinyint(4) DEFAULT '0',
  `DistributorTime` datetime DEFAULT NULL,
  `CashPassword` varchar(50) DEFAULT '',
  `InviteCode` varchar(20) DEFAULT '',
  PRIMARY KEY (`MemberID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_member_group`;
CREATE TABLE `youdian_member_group` (
  `MemberGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberGroupName` varchar(50) DEFAULT NULL,
  `MemberGroupRemark` varchar(512) DEFAULT NULL,
  `MenuTopPurview` varchar(512) DEFAULT NULL,
  `MenuGroupPurview` varchar(512) DEFAULT NULL,
  `MenuPurview` text,
  `ChannelPurviewen` text,
  `ChannelPurviewcn` text,
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `DiscountRate` double DEFAULT '1',
  PRIMARY KEY (`MemberGroupID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu`;
CREATE TABLE `youdian_menu` (
  `MenuID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuGroupID` int(6) DEFAULT NULL,
  `MenuName` char(20) DEFAULT NULL,
  `MenuContent` char(255) DEFAULT NULL,
  `MenuType` tinyint(4) DEFAULT '0',
  `MenuOrder` int(11) NOT NULL DEFAULT '0',
  `SubMenu` char(255) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MenuID`)
) AUTO_INCREMENT=161 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_group`;
CREATE TABLE `youdian_menu_group` (
  `MenuGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuTopID` int(11) DEFAULT NULL,
  `MenuGroupName` char(20) DEFAULT NULL,
  `MenuGroupOrder` int(11) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MenuGroupID`)
) AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_operation`;
CREATE TABLE `youdian_menu_operation` (
  `MenuOperationID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuID` int(11) DEFAULT NULL,
  `MenuOperationName` char(40) DEFAULT NULL,
  `ActionName` char(25) DEFAULT NULL,
  `ModuleName` char(25) DEFAULT NULL,
  `GroupName` char(25) DEFAULT 'Admin',
  `MenuOperationOrder` int(11) DEFAULT '0',
  `LogType` tinyint(4) DEFAULT '1',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`MenuOperationID`)
) AUTO_INCREMENT=549 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_top`;
CREATE TABLE `youdian_menu_top` (
  `MenuTopID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuTopName` char(20) DEFAULT NULL,
  `MenuTopUrl` char(255) DEFAULT NULL,
  `MenuTopTarget` char(20) DEFAULT NULL,
  `MenuTopOrder` int(11) NOT NULL DEFAULT '0',
  `MenuOwner` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `IsActive` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MenuTopID`)
) AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_oauth`;
CREATE TABLE `youdian_oauth` (
  `OauthID` int(11) NOT NULL AUTO_INCREMENT,
  `OauthName` varchar(50) DEFAULT NULL,
  `OauthOrder` int(11) DEFAULT '0',
  `OauthAppID` varchar(200) DEFAULT '',
  `OauthAppKey` varchar(200) DEFAULT '',
  `OauthAppUrl` varchar(200) DEFAULT NULL,
  `OauthMark` varchar(20) DEFAULT '',
  `OauthAppRemark` varchar(255) DEFAULT '',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`OauthID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order`;
CREATE TABLE `youdian_order` (
  `OrderID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) NOT NULL,
  `OrderNumber` varchar(50) DEFAULT '1',
  `ShippingPrice` double DEFAULT '0',
  `PayPrice` double DEFAULT '0',
  `DiscountPrice` double DEFAULT '0',
  `TotalPrice` double DEFAULT '0',
  `OrderPoint` int(11) DEFAULT '0',
  `PayID` int(11) NOT NULL,
  `ShippingID` int(11) NOT NULL,
  `OrderStatus` tinyint(4) DEFAULT '1',
  `PayStatus` tinyint(4) DEFAULT '2',
  `ShippingStatus` tinyint(4) DEFAULT '2',
  `OrderTime` datetime DEFAULT NULL,
  `OrderRemark` text,
  `ConsigneeRealName` varchar(20) DEFAULT NULL,
  `ConsigneeGender` tinyint(4) DEFAULT NULL,
  `ConsigneeEmail` varchar(20) DEFAULT NULL,
  `ConsigneePostcode` varchar(20) DEFAULT NULL,
  `ConsigneeMobile` varchar(20) DEFAULT NULL,
  `ConsigneeTelephone` varchar(20) DEFAULT NULL,
  `ConsigneeAddress` varchar(50) DEFAULT NULL,
  `ConsigneeRemark` varchar(255) DEFAULT NULL,
  `DeliveryTimeID` int(11) DEFAULT NULL,
  `LanguageID` tinyint(1) NOT NULL DEFAULT '1',
  `CouponPrice` double DEFAULT '0',
  `PointPrice` double DEFAULT '0',
  PRIMARY KEY (`OrderID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order_log`;
CREATE TABLE `youdian_order_log` (
  `OrderLogID` int(11) NOT NULL AUTO_INCREMENT,
  `OrderID` int(11) DEFAULT NULL,
  `OrderLogType` tinyint(4) DEFAULT '1',
  `Operator` varchar(50) DEFAULT '0',
  `PayPrice` double DEFAULT '0',
  `ShippingNumber` varchar(50) DEFAULT '',
  `OrderLogTime` datetime DEFAULT NULL,
  `OrderLogRemark` text,
  PRIMARY KEY (`OrderLogID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order_product`;
CREATE TABLE `youdian_order_product` (
  `OrderProductID` int(11) NOT NULL AUTO_INCREMENT,
  `OrderID` int(11) DEFAULT NULL,
  `ProductID` int(11) DEFAULT NULL,
  `ProductName` varchar(255) DEFAULT NULL,
  `ProductPrice` double DEFAULT '0',
  `ProductQuantity` int(11) DEFAULT '1',
  `ProductAttribute` varchar(512) DEFAULT '',
  `AttributeValueID` varchar(200) DEFAULT '',
  PRIMARY KEY (`OrderProductID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_pay`;
CREATE TABLE `youdian_pay` (
  `PayID` int(11) NOT NULL AUTO_INCREMENT,
  `PayTypeID` int(11) DEFAULT '1',
  `PayName` varchar(100) DEFAULT NULL,
  `PayOrder` int(11) DEFAULT '0',
  `AccountName` varchar(100) DEFAULT NULL,
  `AccountPassword` varchar(100) DEFAULT NULL,
  `AccountKey` varchar(100) DEFAULT NULL,
  `AccountID` varchar(100) DEFAULT NULL,
  `PayRate` double DEFAULT '0',
  `PayCurrency` varchar(50) DEFAULT NULL,
  `p1` text,
  `p2` text,
  `PayInterface` tinyint(4) DEFAULT '1',
  `PayDescription` varchar(500) DEFAULT NULL,
  `SiteType` varchar(20) DEFAULT '2',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`PayID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_pay_type`;
CREATE TABLE `youdian_pay_type` (
  `PayTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `PayTypeName` varchar(255) DEFAULT NULL,
  `PayTypeOrder` int(11) DEFAULT '0',
  `IsOnline` tinyint(4) DEFAULT '1',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`PayTypeID`)
) AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_point`;
CREATE TABLE `youdian_point` (
  `PointID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) DEFAULT '0',
  `OrderID` int(11) DEFAULT '0',
  `PointValue` int(11) DEFAULT '0',
  `PointType` tinyint(4) DEFAULT '1',
  `PointTime` datetime DEFAULT NULL,
  `PointRemark` varchar(50) DEFAULT '',
  PRIMARY KEY (`PointID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_resume`;
CREATE TABLE `youdian_resume` (
  `ResumeID` int(11) NOT NULL AUTO_INCREMENT,
  `JobID` int(11) NOT NULL,
  `GuestID` int(11) DEFAULT NULL,
  `GuestName` varchar(20) DEFAULT NULL,
  `Gender` varchar(20) DEFAULT NULL,
  `Birthday` date DEFAULT NULL,
  `Ethnic` varchar(20) DEFAULT NULL,
  `Salary` varchar(20) DEFAULT NULL,
  `Political` varchar(20) DEFAULT NULL,
  `Education` varchar(20) DEFAULT NULL,
  `Telephone` varchar(50) DEFAULT NULL,
  `Email` varchar(50) DEFAULT NULL,
  `Address` varchar(50) DEFAULT NULL,
  `Time` datetime DEFAULT NULL,
  `Birthplace` varchar(20) DEFAULT NULL,
  `Specialty` varchar(20) DEFAULT NULL,
  `School` varchar(20) DEFAULT NULL,
  `Detail` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `GuestIP` varchar(20) DEFAULT '',
  PRIMARY KEY (`ResumeID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_secret`;
CREATE TABLE `youdian_secret` (
  `SecretID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` varchar(20) DEFAULT '',
  `AppSecret` varchar(64) DEFAULT '',
  `SecretTime` datetime DEFAULT NULL,
  `ApiList` varchar(255) DEFAULT '',
  `SecretRemark` varchar(100) DEFAULT '',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`SecretID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_shipping`;
CREATE TABLE `youdian_shipping` (
  `ShippingID` int(11) NOT NULL AUTO_INCREMENT,
  `ShippingName` varchar(100) DEFAULT NULL,
  `ShippingOrder` int(11) DEFAULT '0',
  `ShippingDescription` text,
  `ShippingPrice` double DEFAULT '0',
  `ShippingInsureRate` double DEFAULT '0',
  `IsCod` tinyint(4) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`ShippingID`)
) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_special`;
CREATE TABLE `youdian_special` (
  `SpecialID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelID` int(11) DEFAULT NULL,
  `SpecialName` char(50) DEFAULT NULL,
  `SpecialDescription` char(255) DEFAULT NULL,
  `SpecialOrder` int(11) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `SpecialPicture` char(255) DEFAULT '',
  PRIMARY KEY (`SpecialID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support`;
CREATE TABLE `youdian_support` (
  `SupportID` int(11) NOT NULL AUTO_INCREMENT,
  `SupportName` char(50) DEFAULT NULL,
  `SupportTypeID` int(11) DEFAULT NULL,
  `SupportNumber` text,
  `SupportOrder` int(11) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`SupportID`)
) AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support3`;
CREATE TABLE `youdian_support3` (
  `Support3ID` int(11) NOT NULL AUTO_INCREMENT,
  `Support3Js` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`Support3ID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support_type`;
CREATE TABLE `youdian_support_type` (
  `SupportTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `SupportTypeName` char(20) DEFAULT NULL,
  `SupportTypeOrder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`SupportTypeID`)
) AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_tag`;
CREATE TABLE `youdian_tag` (
  `TagID` int(11) NOT NULL AUTO_INCREMENT,
  `TagName` varchar(50) DEFAULT NULL,
  `TagContent` text,
  `TagDescription` varchar(255) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`TagID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_token`;
CREATE TABLE `youdian_token` (
  `Token` varchar(32) NOT NULL,
  `Timestamp` int(11) DEFAULT '0',
  `MemberID` int(11) DEFAULT '0',
  PRIMARY KEY (`Token`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type`;
CREATE TABLE `youdian_type` (
  `TypeID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeName` varchar(100) DEFAULT '',
  `TypeOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type_attribute`;
CREATE TABLE `youdian_type_attribute` (
  `TypeAttributeID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeID` int(11) DEFAULT '0',
  `TypeGroupID` int(11) DEFAULT '0',
  `TypeAttributeName` varchar(100) DEFAULT '',
  `TypeAttributeOrder` int(11) DEFAULT '0',
  `ValueType` tinyint(4) DEFAULT '1',
  `InputType` tinyint(4) DEFAULT '1',
  `InputValue` varchar(255) DEFAULT '',
  `IsSearch` tinyint(4) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeAttributeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type_attribute_value`;
CREATE TABLE `youdian_type_attribute_value` (
  `AttributeValueID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeAttributeID` int(11) DEFAULT '0',
  `InfoID` int(11) DEFAULT '0',
  `AttributeValue` text,
  `AttributePicture` varchar(255) DEFAULT '',
  `AttributePrice` double DEFAULT '0',
  PRIMARY KEY (`AttributeValueID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type_group`;
CREATE TABLE `youdian_type_group` (
  `TypeGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeID` int(11) DEFAULT '0',
  `TypeGroupName` varchar(100) DEFAULT '',
  `TypeGroupOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_app`;
CREATE TABLE `youdian_wx_app` (
  `AppID` int(11) NOT NULL AUTO_INCREMENT,
  `AppName` varchar(100) DEFAULT NULL,
  `AppTypeID` tinyint(4) DEFAULT '1',
  `AppKeyword` varchar(50) DEFAULT NULL,
  `AppOrder` int(11) DEFAULT '99',
  `AppParameter` text,
  `AppDescription` text,
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`AppID`)
) AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_apptype`;
CREATE TABLE `youdian_wx_apptype` (
  `AppTypeID` int(11) NOT NULL DEFAULT '0',
  `AppTypeName` varchar(50) DEFAULT NULL,
  `AppTypeOrder` int(11) DEFAULT '99',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`AppTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_award`;
CREATE TABLE `youdian_wx_award` (
  `AwardID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `AwardNumber` tinyint(4) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `Mobile` varchar(50) DEFAULT NULL,
  `AwardSN` varchar(50) DEFAULT NULL,
  `AwardTime` datetime DEFAULT NULL,
  `AwardStatus` tinyint(4) DEFAULT '0',
  `IsCheck` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`AwardID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_consume`;
CREATE TABLE `youdian_wx_consume` (
  `ConsumeID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) DEFAULT NULL,
  `ConsumeType` tinyint(4) DEFAULT NULL,
  `ConsumeMoney` int(11) DEFAULT NULL,
  `ConsumeTime` datetime DEFAULT NULL,
  `RelationID` int(11) DEFAULT NULL,
  `Remark` text,
  PRIMARY KEY (`ConsumeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_coupon`;
CREATE TABLE `youdian_wx_coupon` (
  `CouponID` int(11) NOT NULL AUTO_INCREMENT,
  `CouponName` varchar(50) DEFAULT NULL,
  `CouponOrder` int(11) DEFAULT '99',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `CouponNumber` int(11) DEFAULT '100',
  `Remark` text,
  `IsEnable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`CouponID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_gift`;
CREATE TABLE `youdian_wx_gift` (
  `GiftID` int(11) NOT NULL AUTO_INCREMENT,
  `GiftName` varchar(50) DEFAULT NULL,
  `GiftOrder` int(11) DEFAULT '99',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Score` int(11) DEFAULT '100',
  `GiftPicture` varchar(255) DEFAULT NULL,
  `Remark` text,
  `IsEnable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`GiftID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_menu`;
CREATE TABLE `youdian_wx_menu` (
  `MenuID` tinyint(4) NOT NULL AUTO_INCREMENT,
  `Parent` tinyint(4) DEFAULT NULL,
  `MenuName` varchar(255) DEFAULT NULL,
  `TypeID` tinyint(4) DEFAULT NULL,
  `MenuOrder` int(11) DEFAULT '0',
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`MenuID`)
) AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_message`;
CREATE TABLE `youdian_wx_message` (
  `MessageID` int(4) NOT NULL AUTO_INCREMENT,
  `MsgID` varchar(50) DEFAULT NULL,
  `MsgType` varchar(10) DEFAULT NULL,
  `FromUserName` varchar(50) DEFAULT '3',
  `ToUserName` varchar(50) DEFAULT NULL,
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `CreateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`MessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_notify`;
CREATE TABLE `youdian_wx_notify` (
  `NotifyID` int(11) NOT NULL AUTO_INCREMENT,
  `NotifyName` varchar(255) DEFAULT NULL,
  `NotifyContent` text,
  `NotifyTime` datetime DEFAULT NULL,
  PRIMARY KEY (`NotifyID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_question`;
CREATE TABLE `youdian_wx_question` (
  `QuestionID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `QuestionOrder` int(11) DEFAULT '99',
  `QuestionName` varchar(255) DEFAULT NULL,
  `QuestionItem` text,
  `IsMultiple` tinyint(4) DEFAULT NULL,
  `IsEnable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`QuestionID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_reply`;
CREATE TABLE `youdian_wx_reply` (
  `ReplyID` int(4) NOT NULL AUTO_INCREMENT,
  `ReplyTypeID` tinyint(4) DEFAULT '3',
  `Keyword` varchar(50) DEFAULT NULL,
  `Priority` int(11) DEFAULT '0',
  `TypeID` tinyint(4) DEFAULT NULL,
  `Count` int(11) DEFAULT '0',
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`ReplyID`)
) AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_research`;
CREATE TABLE `youdian_wx_research` (
  `ResearchID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `QuestionID` int(11) DEFAULT NULL,
  `ItemID` int(11) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `ResearchTime` datetime DEFAULT NULL,
  PRIMARY KEY (`ResearchID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_score`;
CREATE TABLE `youdian_wx_score` (
  `ScoreID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) DEFAULT NULL,
  `ScoreNumber` int(11) DEFAULT NULL,
  `ScoreTime` datetime DEFAULT NULL,
  `ScoreType` tinyint(4) DEFAULT NULL,
  `RelationID` int(11) DEFAULT NULL,
  `Remark` text,
  PRIMARY KEY (`ScoreID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_suggest`;
CREATE TABLE `youdian_wx_suggest` (
  `SuggestID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `SuggestContent` text,
  `SuggestTime` datetime DEFAULT NULL,
  PRIMARY KEY (`SuggestID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_type`;
CREATE TABLE `youdian_wx_type` (
  `TypeID` tinyint(4) NOT NULL AUTO_INCREMENT,
  `TypeName` varchar(50) DEFAULT NULL,
  `IsReply` tinyint(11) DEFAULT '1',
  `TypeOrder` tinyint(4) unsigned DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeID`)
) AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_vote`;
CREATE TABLE `youdian_wx_vote` (
  `VoteID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `ItemID` int(11) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `VoteTime` datetime DEFAULT NULL,
  PRIMARY KEY (`VoteID`)
) DEFAULT CHARSET=utf8;


INSERT INTO `youdian_ad_group` VALUES
('1','默认广告分组','','1','1'),
('2','default ad group','','1','2');

INSERT INTO `youdian_ad_type` VALUES
('1','图片广告'),
('2','文字广告'),
('3','动画/视频广告'),
('4','代码广告');

INSERT INTO `youdian_admin` VALUES
('1','admin','1','1','ed9f2df6c3b16155f6981c23a99afc9e','2020-11-13 15:50:30','192.168.1.78','0','1','0','179');

INSERT INTO `youdian_admin_group` VALUES
('1','超级管理组','超级管理组拥有所有权限',NULL,NULL,NULL,NULL,NULL,'1'),
('2','频道管理员','','8,74','1,2,3,8','5,3','33,15,17,18,19,55,20,21,22,23,24,25,26,27,28,29,32,30,31,53','34,35,37,40,41,43,47,48,50,51,52,54','0');

INSERT INTO `youdian_area` VALUES
('2','北京','BeiJing','0','0','1'),
('3','安徽省','AnHuiSheng','0','0','1'),
('4','福建省','FuJianSheng','0','0','1'),
('5','甘肃省','GanSuSheng','0','0','1'),
('6','广东省','GuangDongSheng','0','0','1'),
('7','广西壮族自治区','GuangXiZhuangZuZiZhiQu','0','0','1'),
('8','贵州省','GuiZhouSheng','0','0','1'),
('9','海南省','HaiNanSheng','0','0','1'),
('10','河北省','HeBeiSheng','0','0','1'),
('11','河南省','HeNanSheng','0','0','1'),
('12','黑龙江省','HeiLongJiangSheng','0','0','1'),
('13','湖北省','HuBeiSheng','0','0','1'),
('14','湖南省','HuNanSheng','0','0','1'),
('15','吉林省','JiLinSheng','0','0','1'),
('16','江苏省','JiangSuSheng','0','0','1'),
('17','江西省','JiangXiSheng','0','0','1'),
('18','辽宁省','LiaoNingSheng','0','0','1'),
('19','内蒙古自治区','NeiMengGuZiZhiQu','0','0','1'),
('20','宁夏回族自治区','NingXiaHuiZuZiZhiQu','0','0','1'),
('21','青海省','QingHaiSheng','0','0','1'),
('22','山东省','ShanDongSheng','0','0','1'),
('23','山西省','ShanXiSheng','0','0','1'),
('24','陕西省','ShanXiSheng','0','0','1'),
('25','上海市','ShangHaiShi','0','0','1'),
('26','四川省','SiChuanSheng','0','0','1'),
('27','天津市','TianJinShi','0','0','1'),
('28','西藏自治区','XiCangZiZhiQu','0','0','1'),
('29','新疆维吾尔自治区','XinJiangWeiWuErZiZhiQu','0','0','1'),
('30','云南省','YunNanSheng','0','0','1'),
('31','浙江省','ZheJiangSheng','0','0','1'),
('32','重庆市','ZhongQingShi','0','0','1'),
('33','香港特别行政区','Hong Kong','0','0','1'),
('34','澳门特别行政区','Macao','0','0','1'),
('35','台湾','TaiWan','0','0','1'),
('36','安庆','AnQing','0','3','1'),
('37','蚌埠','BangBu','0','3','1'),
('38','巢湖','ChaoHu','0','3','1'),
('39','池州','ChiZhou','0','3','1'),
('40','滁州','ChuZhou','0','3','1'),
('41','阜阳','FuYang','0','3','1'),
('42','淮北','HuaiBei','0','3','1'),
('43','淮南','HuaiNan','0','3','1'),
('44','黄山','HuangShan','0','3','1'),
('45','六安','LiuAn','0','3','1'),
('46','马鞍山','MaAnShan','0','3','1'),
('47','宿州','SuZhou','0','3','1'),
('48','铜陵','TongLing','0','3','1'),
('49','芜湖','WuHu','0','3','1'),
('50','宣城','XuanCheng','0','3','1'),
('51','亳州','Zhou','0','3','1'),
('53','福州','FuZhou','0','4','1'),
('54','龙岩','LongYan','0','4','1'),
('55','南平','NanPing','0','4','1'),
('56','宁德','NingDe','0','4','1'),
('57','莆田','PuTian','0','4','1'),
('58','泉州','QuanZhou','0','4','1'),
('59','三明','SanMing','0','4','1'),
('60','厦门','XiaMen','0','4','1'),
('61','漳州','ZhangZhou','0','4','1'),
('62','兰州','LanZhou','0','5','1'),
('63','白银','BaiYin','0','5','1'),
('64','定西','DingXi','0','5','1'),
('65','甘南','GanNan','0','5','1'),
('66','嘉峪关','JiaYuGuan','0','5','1'),
('67','金昌','JinChang','0','5','1'),
('68','酒泉','JiuQuan','0','5','1'),
('69','临夏','LinXia','0','5','1'),
('70','陇南','LongNan','0','5','1'),
('71','平凉','PingLiang','0','5','1'),
('72','庆阳','QingYang','0','5','1'),
('73','天水','TianShui','0','5','1'),
('74','武威','WuWei','0','5','1'),
('75','张掖','ZhangYe','0','5','1'),
('76','广州','GuangZhou','0','6','1'),
('77','深圳','Shen','0','6','1'),
('78','潮州','ChaoZhou','0','6','1'),
('79','东莞','Dong','0','6','1'),
('80','佛山','FoShan','0','6','1'),
('81','河源','HeYuan','0','6','1'),
('82','惠州','HuiZhou','0','6','1'),
('83','江门','JiangMen','0','6','1'),
('84','揭阳','JieYang','0','6','1'),
('85','茂名','MaoMing','0','6','1'),
('86','梅州','MeiZhou','0','6','1'),
('87','清远','QingYuan','0','6','1'),
('88','汕头','ShanTou','0','6','1'),
('89','汕尾','ShanWei','0','6','1'),
('90','韶关','ShaoGuan','0','6','1'),
('91','阳江','YangJiang','0','6','1'),
('92','云浮','YunFu','0','6','1'),
('93','湛江','ZhanJiang','0','6','1'),
('94','肇庆','ZhaoQing','0','6','1'),
('95','中山','ZhongShan','0','6','1'),
('96','珠海','ZhuHai','0','6','1'),
('97','南宁','NanNing','0','7','1'),
('98','桂林','GuiLin','0','7','1'),
('99','百色','BaiSe','0','7','1'),
('100','北海','BeiHai','0','7','1'),
('101','崇左','ChongZuo','0','7','1'),
('102','防城港','FangChengGang','0','7','1'),
('103','贵港','GuiGang','0','7','1'),
('104','河池','HeChi','0','7','1'),
('105','贺州','HeZhou','0','7','1'),
('106','来宾','LaiBin','0','7','1'),
('107','柳州','LiuZhou','0','7','1'),
('108','钦州','QinZhou','0','7','1'),
('109','梧州','WuZhou','0','7','1'),
('110','玉林','YuLin','0','7','1'),
('111','贵阳','GuiYang','0','8','1'),
('112','安顺','AnShun','0','8','1'),
('113','毕节','BiJie','0','8','1'),
('114','六盘水','LiuPanShui','0','8','1'),
('115','黔东南','QianDongNan','0','8','1'),
('116','黔南','QianNan','0','8','1'),
('117','黔西南','QianXiNan','0','8','1'),
('118','铜仁','TongRen','0','8','1'),
('119','遵义','ZunYi','0','8','1'),
('120','海口','HaiKou','0','9','1'),
('121','三亚','SanYa','0','9','1'),
('122','白沙','BaiSha','0','9','1'),
('123','保亭','BaoTing','0','9','1'),
('124','昌江','ChangJiang','0','9','1'),
('125','澄迈县','ChengMaiXian','0','9','1'),
('126','定安县','DingAnXian','0','9','1'),
('127','东方','DongFang','0','9','1'),
('128','乐东','LeDong','0','9','1'),
('129','临高县','LinGaoXian','0','9','1'),
('130','陵水','LingShui','0','9','1'),
('131','琼海','QiongHai','0','9','1'),
('132','琼中','QiongZhong','0','9','1'),
('133','屯昌县','TunChangXian','0','9','1'),
('134','万宁','WanNing','0','9','1'),
('135','文昌','WenChang','0','9','1'),
('136','五指山','WuZhiShan','0','9','1'),
('137','儋州','Zhou','0','9','1'),
('138','石家庄','ShiJiaZhuang','0','10','1'),
('139','保定','BaoDing','0','10','1'),
('140','沧州','CangZhou','0','10','1'),
('141','承德','ChengDe','0','10','1'),
('142','邯郸','HanDan','0','10','1'),
('143','衡水','HengShui','0','10','1'),
('144','廊坊','LangFang','0','10','1'),
('145','秦皇岛','QinHuangDao','0','10','1'),
('146','唐山','TangShan','0','10','1'),
('147','邢台','XingTai','0','10','1'),
('148','张家口','ZhangJiaKou','0','10','1'),
('149','郑州','ZhengZhou','0','11','1'),
('150','洛阳','LuoYang','0','11','1'),
('151','开封','KaiFeng','0','11','1'),
('152','安阳','AnYang','0','11','1'),
('153','鹤壁','HeBi','0','11','1'),
('154','济源','JiYuan','0','11','1'),
('155','焦作','JiaoZuo','0','11','1'),
('156','南阳','NanYang','0','11','1'),
('157','平顶山','PingDingShan','0','11','1'),
('158','三门峡','SanMenXia','0','11','1'),
('159','商丘','ShangQiu','0','11','1'),
('160','新乡','XinXiang','0','11','1'),
('161','信阳','XinYang','0','11','1'),
('162','许昌','XuChang','0','11','1'),
('163','周口','ZhouKou','0','11','1'),
('164','驻马店','ZhuMaDian','0','11','1'),
('165','漯河','He','0','11','1'),
('166','濮阳','Yang','0','11','1'),
('167','哈尔滨','HaErBin','0','12','1'),
('168','大庆','DaQing','0','12','1'),
('169','大兴安岭','DaXingAnLing','0','12','1'),
('170','鹤岗','HeGang','0','12','1'),
('171','黑河','HeiHe','0','12','1'),
('172','鸡西','JiXi','0','12','1'),
('173','佳木斯','JiaMuSi','0','12','1'),
('174','牡丹江','MuDanJiang','0','12','1'),
('175','七台河','QiTaiHe','0','12','1'),
('176','齐齐哈尔','QiQiHaEr','0','12','1'),
('177','双鸭山','ShuangYaShan','0','12','1'),
('178','绥化','SuiHua','0','12','1'),
('179','伊春','YiChun','0','12','1'),
('180','武汉','WuHan','0','13','1'),
('181','仙桃','XianTao','0','13','1'),
('182','鄂州','EZhou','0','13','1'),
('183','黄冈','HuangGang','0','13','1'),
('184','黄石','HuangShi','0','13','1'),
('185','荆门','JingMen','0','13','1'),
('186','荆州','JingZhou','0','13','1'),
('187','潜江','QianJiang','0','13','1'),
('188','神农架林区','ShenNongJiaLinQu','0','13','1'),
('189','十堰','ShiYan','0','13','1'),
('190','随州','SuiZhou','0','13','1'),
('191','天门','TianMen','0','13','1'),
('192','咸宁','XianNing','0','13','1'),
('193','襄樊','XiangFan','0','13','1'),
('194','孝感','XiaoGan','0','13','1'),
('195','宜昌','YiChang','0','13','1'),
('196','恩施','EnShi','0','13','1'),
('197','长沙','ChangSha','0','14','1'),
('198','张家界','ZhangJiaJie','0','14','1'),
('199','常德','ChangDe','0','14','1'),
('200','郴州','ChenZhou','0','14','1'),
('201','衡阳','HengYang','0','14','1'),
('202','怀化','HuaiHua','0','14','1'),
('203','娄底','LouDi','0','14','1'),
('204','邵阳','ShaoYang','0','14','1'),
('205','湘潭','XiangTan','0','14','1'),
('206','湘西','XiangXi','0','14','1'),
('207','益阳','YiYang','0','14','1'),
('208','永州','YongZhou','0','14','1'),
('209','岳阳','YueYang','0','14','1'),
('210','株洲','ZhuZhou','0','14','1'),
('211','长春','ChangChun','0','15','1'),
('212','吉林','JiLin','0','15','1'),
('213','白城','BaiCheng','0','15','1'),
('214','白山','BaiShan','0','15','1'),
('215','辽源','LiaoYuan','0','15','1'),
('216','四平','SiPing','0','15','1'),
('217','松原','SongYuan','0','15','1'),
('218','通化','TongHua','0','15','1'),
('219','延边','YanBian','0','15','1'),
('220','南京','NanJing','0','16','1'),
('221','苏州','SuZhou','0','16','1'),
('222','无锡','WuXi','0','16','1'),
('223','常州','ChangZhou','0','16','1'),
('224','淮安','HuaiAn','0','16','1'),
('225','连云港','LianYunGang','0','16','1'),
('226','南通','NanTong','0','16','1'),
('227','宿迁','SuQian','0','16','1'),
('228','泰州','TaiZhou','0','16','1'),
('229','徐州','XuZhou','0','16','1'),
('230','盐城','YanCheng','0','16','1'),
('231','扬州','YangZhou','0','16','1'),
('232','镇江','ZhenJiang','0','16','1'),
('233','南昌','NanChang','0','17','1'),
('234','抚州','FuZhou','0','17','1'),
('235','赣州','GanZhou','0','17','1'),
('236','吉安','JiAn','0','17','1'),
('237','景德镇','JingDeZhen','0','17','1'),
('238','九江','JiuJiang','0','17','1'),
('239','萍乡','PingXiang','0','17','1'),
('240','上饶','ShangRao','0','17','1'),
('241','新余','XinYu','0','17','1'),
('242','宜春','YiChun','0','17','1'),
('243','鹰潭','YingTan','0','17','1'),
('244','沈阳','ShenYang','0','18','1'),
('245','大连','DaLian','0','18','1'),
('246','鞍山','AnShan','0','18','1'),
('247','本溪','BenXi','0','18','1'),
('248','朝阳','ChaoYang','0','18','1'),
('249','丹东','DanDong','0','18','1'),
('250','抚顺','FuShun','0','18','1'),
('251','阜新','FuXin','0','18','1'),
('252','葫芦岛','HuLuDao','0','18','1'),
('253','锦州','JinZhou','0','18','1'),
('254','辽阳','LiaoYang','0','18','1'),
('255','盘锦','PanJin','0','18','1'),
('256','铁岭','TieLing','0','18','1'),
('257','营口','YingKou','0','18','1'),
('258','呼和浩特','HuHeHaoTe','0','19','1'),
('259','阿拉善盟','ALaShanMeng','0','19','1'),
('260','巴彦淖尔盟','BaYanNaoErMeng','0','19','1'),
('261','包头','BaoTou','0','19','1'),
('262','赤峰','ChiFeng','0','19','1'),
('263','鄂尔多斯','EErDuoSi','0','19','1'),
('264','呼伦贝尔','HuLunBeiEr','0','19','1'),
('265','通辽','TongLiao','0','19','1'),
('266','乌海','WuHai','0','19','1'),
('267','乌兰察布市','WuLanChaBuShi','0','19','1'),
('268','锡林郭勒盟','XiLinGuoLeMeng','0','19','1'),
('269','兴安盟','XingAnMeng','0','19','1'),
('270','银川','YinChuan','0','20','1'),
('271','固原','GuYuan','0','20','1'),
('272','石嘴山','ShiZuiShan','0','20','1'),
('273','吴忠','WuZhong','0','20','1'),
('274','中卫','ZhongWei','0','20','1'),
('275','西宁','XiNing','0','21','1'),
('276','果洛','GuoLuo','0','21','1'),
('277','海北','HaiBei','0','21','1'),
('278','海东','HaiDong','0','21','1'),
('279','海南','HaiNan','0','21','1'),
('280','海西','HaiXi','0','21','1'),
('281','黄南','HuangNan','0','21','1'),
('282','玉树','YuShu','0','21','1'),
('283','济南','JiNan','0','22','1'),
('284','青岛','QingDao','0','22','1'),
('285','滨州','BinZhou','0','22','1'),
('286','德州','DeZhou','0','22','1'),
('287','东营','DongYing','0','22','1'),
('288','菏泽','HeZe','0','22','1'),
('289','济宁','JiNing','0','22','1'),
('290','莱芜','LaiWu','0','22','1'),
('291','聊城','LiaoCheng','0','22','1'),
('292','临沂','LinYi','0','22','1'),
('293','日照','RiZhao','0','22','1'),
('294','泰安','TaiAn','0','22','1'),
('295','威海','WeiHai','0','22','1'),
('296','潍坊','WeiFang','0','22','1'),
('297','烟台','YanTai','0','22','1'),
('298','枣庄','ZaoZhuang','0','22','1'),
('299','淄博','ZiBo','0','22','1'),
('300','太原','TaiYuan','0','23','1'),
('301','长治','ChangZhi','0','23','1'),
('302','大同','DaTong','0','23','1'),
('303','晋城','JinCheng','0','23','1'),
('304','晋中','JinZhong','0','23','1'),
('305','临汾','LinFen','0','23','1'),
('306','吕梁','LvLiang','0','23','1'),
('307','朔州','ShuoZhou','0','23','1'),
('308','忻州','XinZhou','0','23','1'),
('309','阳泉','YangQuan','0','23','1'),
('310','运城','YunCheng','0','23','1'),
('311','西安','XiAn','0','24','1'),
('312','安康','AnKang','0','24','1'),
('313','宝鸡','BaoJi','0','24','1'),
('314','汉中','HanZhong','0','24','1'),
('315','商洛','ShangLuo','0','24','1'),
('316','铜川','TongChuan','0','24','1'),
('317','渭南','WeiNan','0','24','1'),
('318','咸阳','XianYang','0','24','1'),
('319','延安','YanAn','0','24','1'),
('320','榆林','YuLin','0','24','1'),
('321','上海','ShangHai','0','25','1'),
('322','成都','ChengDu','0','26','1'),
('323','绵阳','MianYang','0','26','1'),
('324','阿坝','ABa','0','26','1'),
('325','巴中','BaZhong','0','26','1'),
('326','达州','DaZhou','0','26','1'),
('327','德阳','DeYang','0','26','1'),
('328','甘孜','GanZi','0','26','1'),
('329','广安','GuangAn','0','26','1'),
('330','广元','GuangYuan','0','26','1'),
('331','乐山','LeShan','0','26','1'),
('332','凉山','LiangShan','0','26','1'),
('333','眉山','MeiShan','0','26','1'),
('334','南充','NanChong','0','26','1'),
('335','内江','NeiJiang','0','26','1'),
('336','攀枝花','PanZhiHua','0','26','1'),
('337','遂宁','SuiNing','0','26','1'),
('338','雅安','YaAn','0','26','1'),
('339','宜宾','YiBin','0','26','1'),
('340','资阳','ZiYang','0','26','1'),
('341','自贡','ZiGong','0','26','1'),
('342','泸州','Zhou','0','26','1'),
('343','天津','TianJin','0','27','1'),
('344','拉萨','LaSa','0','28','1'),
('345','阿里','ALi','0','28','1'),
('346','昌都','ChangDu','0','28','1'),
('347','林芝','LinZhi','0','28','1'),
('348','那曲','NaQu','0','28','1'),
('349','日喀则','RiKaZe','0','28','1'),
('350','山南','ShanNan','0','28','1'),
('351','乌鲁木齐','WuLuMuQi','0','29','1'),
('352','阿克苏','AKeSu','0','29','1'),
('353','阿拉尔','ALaEr','0','29','1'),
('354','巴音郭楞','BaYinGuoLeng','0','29','1'),
('355','博尔塔拉','BoErTaLa','0','29','1'),
('356','昌吉','ChangJi','0','29','1'),
('357','哈密','HaMi','0','29','1'),
('358','和田','HeTian','0','29','1'),
('359','喀什','KaShi','0','29','1'),
('360','克拉玛依','KeLaMaYi','0','29','1'),
('361','克孜勒苏','KeZiLeSu','0','29','1'),
('362','石河子','ShiHeZi','0','29','1'),
('363','图木舒克','TuMuShuKe','0','29','1'),
('364','吐鲁番','TuLuFan','0','29','1'),
('365','五家渠','WuJiaQu','0','29','1'),
('366','伊犁','YiLi','0','29','1'),
('367','昆明','KunMing','0','30','1'),
('368','怒江','NuJiang','0','30','1'),
('369','普洱','PuEr','0','30','1'),
('370','丽江','LiJiang','0','30','1'),
('371','保山','BaoShan','0','30','1'),
('372','楚雄','ChuXiong','0','30','1'),
('373','大理','DaLi','0','30','1'),
('374','德宏','DeHong','0','30','1'),
('375','迪庆','DiQing','0','30','1'),
('376','红河','HongHe','0','30','1'),
('377','临沧','LinCang','0','30','1'),
('378','曲靖','QuJing','0','30','1'),
('379','文山','WenShan','0','30','1'),
('380','西双版纳','XiShuangBanNa','0','30','1'),
('381','玉溪','YuXi','0','30','1'),
('382','昭通','ZhaoTong','0','30','1'),
('383','杭州','HangZhou','0','31','1'),
('384','湖州','HuZhou','0','31','1'),
('385','嘉兴','JiaXing','0','31','1'),
('386','金华','JinHua','0','31','1'),
('387','丽水','LiShui','0','31','1'),
('388','宁波','NingBo','0','31','1'),
('389','绍兴','ShaoXing','0','31','1'),
('390','台州','TaiZhou','0','31','1'),
('391','温州','WenZhou','0','31','1'),
('392','舟山','ZhouShan','0','31','1'),
('393','衢州','Zhou','0','31','1'),
('394','重庆','ZhongQing','0','32','1'),
('396','澳门','AoMen','0','34','1'),
('398','迎江区','YingJiangQu','0','36','1'),
('399','大观区','DaGuanQu','0','36','1'),
('400','宜秀区','YiXiuQu','0','36','1'),
('401','桐城市','TongChengShi','0','36','1'),
('402','怀宁县','HuaiNingXian','0','36','1'),
('403','枞阳县','YangXian','0','36','1'),
('404','潜山县','QianShanXian','0','36','1'),
('405','太湖县','TaiHuXian','0','36','1'),
('406','宿松县','SuSongXian','0','36','1'),
('407','望江县','WangJiangXian','0','36','1'),
('408','岳西县','YueXiXian','0','36','1'),
('409','中市区','ZhongShiQu','0','37','1'),
('410','东市区','DongShiQu','0','37','1'),
('411','西市区','XiShiQu','0','37','1'),
('412','郊区','JiaoQu','0','37','1'),
('413','怀远县','HuaiYuanXian','0','37','1'),
('414','五河县','WuHeXian','0','37','1'),
('415','固镇县','GuZhenXian','0','37','1'),
('416','居巢区','JuChaoQu','0','38','1'),
('417','庐江县','LuJiangXian','0','38','1'),
('418','无为县','WuWeiXian','0','38','1'),
('419','含山县','HanShanXian','0','38','1'),
('420','和县','HeXian','0','38','1'),
('421','贵池区','GuiChiQu','0','39','1'),
('422','东至县','DongZhiXian','0','39','1'),
('423','石台县','ShiTaiXian','0','39','1'),
('424','青阳县','QingYangXian','0','39','1'),
('425','琅琊区','LangQu','0','40','1'),
('426','南谯区','NanQu','0','40','1'),
('427','天长市','TianChangShi','0','40','1'),
('428','明光市','MingGuangShi','0','40','1'),
('429','来安县','LaiAnXian','0','40','1'),
('430','全椒县','QuanJiaoXian','0','40','1'),
('431','定远县','DingYuanXian','0','40','1'),
('432','凤阳县','FengYangXian','0','40','1'),
('433','蚌山区','BangShanQu','0','41','1'),
('434','龙子湖区','LongZiHuQu','0','41','1'),
('435','禹会区','YuHuiQu','0','41','1'),
('436','淮上区','HuaiShangQu','0','41','1'),
('437','颍州区','ZhouQu','0','41','1'),
('438','颍东区','DongQu','0','41','1'),
('439','颍泉区','QuanQu','0','41','1'),
('440','界首市','JieShouShi','0','41','1'),
('441','临泉县','LinQuanXian','0','41','1'),
('442','太和县','TaiHeXian','0','41','1'),
('443','阜南县','FuNanXian','0','41','1'),
('444','颖上县','YingShangXian','0','41','1'),
('445','相山区','XiangShanQu','0','42','1'),
('446','杜集区','DuJiQu','0','42','1'),
('447','烈山区','LieShanQu','0','42','1'),
('448','濉溪县','XiXian','0','42','1'),
('449','田家庵区','TianJiaQu','0','43','1'),
('450','大通区','DaTongQu','0','43','1'),
('451','谢家集区','XieJiaJiQu','0','43','1'),
('452','八公山区','BaGongShanQu','0','43','1'),
('453','潘集区','PanJiQu','0','43','1'),
('454','凤台县','FengTaiXian','0','43','1'),
('455','屯溪区','TunXiQu','0','44','1'),
('456','黄山区','HuangShanQu','0','44','1'),
('457','徽州区','HuiZhouQu','0','44','1'),
('458','歙县','Xian','0','44','1'),
('459','休宁县','XiuNingXian','0','44','1'),
('460','黟县','Xian','0','44','1'),
('461','祁门县','QiMenXian','0','44','1'),
('462','金安区','JinAnQu','0','45','1'),
('463','裕安区','YuAnQu','0','45','1'),
('464','寿县','ShouXian','0','45','1'),
('465','霍邱县','HuoQiuXian','0','45','1'),
('466','舒城县','ShuChengXian','0','45','1'),
('467','金寨县','JinZhaiXian','0','45','1'),
('468','霍山县','HuoShanXian','0','45','1'),
('469','雨山区','YuShanQu','0','46','1'),
('470','花山区','HuaShanQu','0','46','1'),
('471','金家庄区','JinJiaZhuangQu','0','46','1'),
('472','当涂县','DangTuXian','0','46','1'),
('473','埇桥区','QiaoQu','0','47','1'),
('474','砀山县','ShanXian','0','47','1'),
('475','萧县','XiaoXian','0','47','1'),
('476','灵璧县','LingXian','0','47','1'),
('477','泗县','Xian','0','47','1'),
('478','铜官山区','TongGuanShanQu','0','48','1'),
('479','狮子山区','ShiZiShanQu','0','48','1'),
('480','郊区','JiaoQu','0','48','1'),
('481','铜陵县','TongLingXian','0','48','1'),
('482','镜湖区','JingHuQu','0','49','1'),
('483','弋江区','JiangQu','0','49','1'),
('484','鸠江区','JiangQu','0','49','1'),
('485','三山区','SanShanQu','0','49','1'),
('486','芜湖县','WuHuXian','0','49','1'),
('487','繁昌县','FanChangXian','0','49','1'),
('488','南陵县','NanLingXian','0','49','1'),
('489','宣州区','XuanZhouQu','0','50','1'),
('490','宁国市','NingGuoShi','0','50','1'),
('491','郎溪县','LangXiXian','0','50','1'),
('492','广德县','GuangDeXian','0','50','1'),
('493','泾县','Xian','0','50','1'),
('494','绩溪县','JiXiXian','0','50','1'),
('495','旌德县','DeXian','0','50','1'),
('496','涡阳县','WoYangXian','0','51','1'),
('497','蒙城县','MengChengXian','0','51','1'),
('498','利辛县','LiXinXian','0','51','1'),
('499','谯城区','ChengQu','0','51','1'),
('500','东城区','DongChengQu','0','2','1'),
('501','西城区','XiChengQu','0','2','1'),
('502','海淀区','HaiDianQu','0','2','1'),
('503','朝阳区','ChaoYangQu','0','2','1'),
('504','崇文区','ChongWenQu','0','2','1'),
('505','宣武区','XuanWuQu','0','2','1'),
('506','丰台区','FengTaiQu','0','2','1'),
('507','石景山区','ShiJingShanQu','0','2','1'),
('508','房山区','FangShanQu','0','2','1'),
('509','门头沟区','MenTouGouQu','0','2','1'),
('510','通州区','TongZhouQu','0','2','1'),
('511','顺义区','ShunYiQu','0','2','1'),
('512','昌平区','ChangPingQu','0','2','1'),
('513','怀柔区','HuaiRouQu','0','2','1'),
('514','平谷区','PingGuQu','0','2','1'),
('515','大兴区','DaXingQu','0','2','1'),
('3429','西盖村','XiGaiCun','0','3427','1'),
('518','鼓楼区','GuLouQu','0','53','1'),
('519','台江区','TaiJiangQu','0','53','1'),
('520','仓山区','CangShanQu','0','53','1'),
('521','马尾区','MaWeiQu','0','53','1'),
('522','晋安区','JinAnQu','0','53','1'),
('523','福清市','FuQingShi','0','53','1'),
('524','长乐市','ChangLeShi','0','53','1'),
('525','闽侯县','MinHouXian','0','53','1'),
('526','连江县','LianJiangXian','0','53','1'),
('527','罗源县','LuoYuanXian','0','53','1'),
('528','闽清县','MinQingXian','0','53','1'),
('529','永泰县','YongTaiXian','0','53','1'),
('530','平潭县','PingTanXian','0','53','1'),
('531','新罗区','XinLuoQu','0','54','1'),
('532','漳平市','ZhangPingShi','0','54','1'),
('533','长汀县','ChangTingXian','0','54','1'),
('534','永定县','YongDingXian','0','54','1'),
('535','上杭县','ShangHangXian','0','54','1'),
('536','武平县','WuPingXian','0','54','1'),
('537','连城县','LianChengXian','0','54','1'),
('538','延平区','YanPingQu','0','55','1'),
('539','邵武市','ShaoWuShi','0','55','1'),
('540','武夷山市','WuYiShanShi','0','55','1'),
('541','建瓯市','JianShi','0','55','1'),
('542','建阳市','JianYangShi','0','55','1'),
('543','顺昌县','ShunChangXian','0','55','1'),
('544','浦城县','PuChengXian','0','55','1'),
('545','光泽县','GuangZeXian','0','55','1'),
('546','松溪县','SongXiXian','0','55','1'),
('547','政和县','ZhengHeXian','0','55','1'),
('548','蕉城区','JiaoChengQu','0','56','1'),
('549','福安市','FuAnShi','0','56','1'),
('550','福鼎市','FuDingShi','0','56','1'),
('551','霞浦县','XiaPuXian','0','56','1'),
('552','古田县','GuTianXian','0','56','1'),
('553','屏南县','PingNanXian','0','56','1'),
('554','寿宁县','ShouNingXian','0','56','1'),
('555','周宁县','ZhouNingXian','0','56','1'),
('556','柘荣县','RongXian','0','56','1'),
('557','城厢区','ChengXiangQu','0','57','1'),
('558','涵江区','HanJiangQu','0','57','1'),
('559','荔城区','LiChengQu','0','57','1'),
('560','秀屿区','XiuYuQu','0','57','1'),
('561','仙游县','XianYouXian','0','57','1'),
('562','鲤城区','LiChengQu','0','58','1'),
('563','丰泽区','FengZeQu','0','58','1'),
('564','洛江区','LuoJiangQu','0','58','1'),
('565','清濛开发区','QingKaiFaQu','0','58','1'),
('566','泉港区','QuanGangQu','0','58','1'),
('567','石狮市','ShiShiShi','0','58','1'),
('568','晋江市','JinJiangShi','0','58','1'),
('569','南安市','NanAnShi','0','58','1'),
('570','惠安县','HuiAnXian','0','58','1'),
('571','安溪县','AnXiXian','0','58','1'),
('572','永春县','YongChunXian','0','58','1'),
('573','德化县','DeHuaXian','0','58','1'),
('574','金门县','JinMenXian','0','58','1'),
('575','梅列区','MeiLieQu','0','59','1'),
('576','三元区','SanYuanQu','0','59','1'),
('577','永安市','YongAnShi','0','59','1'),
('578','明溪县','MingXiXian','0','59','1'),
('579','清流县','QingLiuXian','0','59','1'),
('580','宁化县','NingHuaXian','0','59','1'),
('581','大田县','DaTianXian','0','59','1'),
('582','尤溪县','YouXiXian','0','59','1'),
('583','沙县','ShaXian','0','59','1'),
('584','将乐县','JiangLeXian','0','59','1'),
('585','泰宁县','TaiNingXian','0','59','1'),
('586','建宁县','JianNingXian','0','59','1'),
('587','思明区','SiMingQu','0','60','1'),
('588','海沧区','HaiCangQu','0','60','1'),
('589','湖里区','HuLiQu','0','60','1'),
('590','集美区','JiMeiQu','0','60','1'),
('591','同安区','TongAnQu','0','60','1'),
('592','翔安区','XiangAnQu','0','60','1'),
('593','芗城区','ChengQu','0','61','1'),
('594','龙文区','LongWenQu','0','61','1'),
('595','龙海市','LongHaiShi','0','61','1'),
('596','云霄县','YunXiaoXian','0','61','1'),
('597','漳浦县','ZhangPuXian','0','61','1'),
('598','诏安县','AnXian','0','61','1'),
('599','长泰县','ChangTaiXian','0','61','1'),
('600','东山县','DongShanXian','0','61','1'),
('601','南靖县','NanJingXian','0','61','1'),
('602','平和县','PingHeXian','0','61','1'),
('603','华安县','HuaAnXian','0','61','1'),
('604','皋兰县','GaoLanXian','0','62','1'),
('605','城关区','ChengGuanQu','0','62','1'),
('606','七里河区','QiLiHeQu','0','62','1'),
('607','西固区','XiGuQu','0','62','1'),
('608','安宁区','AnNingQu','0','62','1'),
('609','红古区','HongGuQu','0','62','1'),
('610','永登县','YongDengXian','0','62','1'),
('611','榆中县','YuZhongXian','0','62','1'),
('612','白银区','BaiYinQu','0','63','1'),
('613','平川区','PingChuanQu','0','63','1'),
('614','会宁县','HuiNingXian','0','63','1'),
('615','景泰县','JingTaiXian','0','63','1'),
('616','靖远县','JingYuanXian','0','63','1'),
('617','临洮县','LinXian','0','64','1'),
('618','陇西县','LongXiXian','0','64','1'),
('619','通渭县','TongWeiXian','0','64','1'),
('620','渭源县','WeiYuanXian','0','64','1'),
('621','漳县','ZhangXian','0','64','1'),
('622','岷县','Xian','0','64','1'),
('623','安定区','AnDingQu','0','64','1'),
('624','安定区','AnDingQu','0','64','1'),
('625','合作市','HeZuoShi','0','65','1'),
('626','临潭县','LinTanXian','0','65','1'),
('627','卓尼县','ZhuoNiXian','0','65','1'),
('628','舟曲县','ZhouQuXian','0','65','1'),
('629','迭部县','DieBuXian','0','65','1'),
('630','玛曲县','MaQuXian','0','65','1'),
('631','碌曲县','LuQuXian','0','65','1'),
('632','夏河县','XiaHeXian','0','65','1'),
('633','嘉峪关市','JiaYuGuanShi','0','66','1'),
('634','金川区','JinChuanQu','0','67','1'),
('635','永昌县','YongChangXian','0','67','1'),
('636','肃州区','SuZhouQu','0','68','1'),
('637','玉门市','YuMenShi','0','68','1'),
('638','敦煌市','DunHuangShi','0','68','1'),
('639','金塔县','JinTaXian','0','68','1'),
('640','瓜州县','GuaZhouXian','0','68','1'),
('641','肃北','SuBei','0','68','1'),
('642','阿克塞','AKeSai','0','68','1'),
('643','临夏市','LinXiaShi','0','69','1'),
('644','临夏县','LinXiaXian','0','69','1'),
('645','康乐县','KangLeXian','0','69','1'),
('646','永靖县','YongJingXian','0','69','1'),
('647','广河县','GuangHeXian','0','69','1'),
('648','和政县','HeZhengXian','0','69','1'),
('649','东乡族自治县','DongXiangZuZiZhiXian','0','69','1'),
('650','积石山','JiShiShan','0','69','1'),
('651','成县','ChengXian','0','70','1'),
('652','徽县','HuiXian','0','70','1'),
('653','康县','KangXian','0','70','1'),
('654','礼县','LiXian','0','70','1'),
('655','两当县','LiangDangXian','0','70','1'),
('656','文县','WenXian','0','70','1'),
('657','西和县','XiHeXian','0','70','1'),
('658','宕昌县','ChangXian','0','70','1'),
('659','武都区','WuDuQu','0','70','1'),
('660','崇信县','ChongXinXian','0','71','1'),
('661','华亭县','HuaTingXian','0','71','1'),
('662','静宁县','JingNingXian','0','71','1'),
('663','灵台县','LingTaiXian','0','71','1'),
('664','崆峒区','Qu','0','71','1'),
('665','庄浪县','ZhuangLangXian','0','71','1'),
('666','泾川县','ChuanXian','0','71','1'),
('667','合水县','HeShuiXian','0','72','1'),
('668','华池县','HuaChiXian','0','72','1'),
('669','环县','HuanXian','0','72','1'),
('670','宁县','NingXian','0','72','1'),
('671','庆城县','QingChengXian','0','72','1'),
('672','西峰区','XiFengQu','0','72','1'),
('673','镇原县','ZhenYuanXian','0','72','1'),
('674','正宁县','ZhengNingXian','0','72','1'),
('675','甘谷县','GanGuXian','0','73','1'),
('676','秦安县','QinAnXian','0','73','1'),
('677','清水县','QingShuiXian','0','73','1'),
('678','秦州区','QinZhouQu','0','73','1'),
('679','麦积区','MaiJiQu','0','73','1'),
('680','武山县','WuShanXian','0','73','1'),
('681','张家川','ZhangJiaChuan','0','73','1'),
('682','古浪县','GuLangXian','0','74','1'),
('683','民勤县','MinQinXian','0','74','1'),
('684','天祝','TianZhu','0','74','1'),
('685','凉州区','LiangZhouQu','0','74','1'),
('686','高台县','GaoTaiXian','0','75','1'),
('687','临泽县','LinZeXian','0','75','1'),
('688','民乐县','MinLeXian','0','75','1'),
('689','山丹县','ShanDanXian','0','75','1'),
('690','肃南','SuNan','0','75','1'),
('691','甘州区','GanZhouQu','0','75','1'),
('692','从化市','CongHuaShi','0','76','1'),
('693','天河区','TianHeQu','0','76','1'),
('694','东山区','DongShanQu','0','76','1'),
('695','白云区','BaiYunQu','0','76','1'),
('696','海珠区','HaiZhuQu','0','76','1'),
('697','荔湾区','LiWanQu','0','76','1'),
('698','越秀区','YueXiuQu','0','76','1'),
('699','黄埔区','HuangPuQu','0','76','1'),
('700','番禺区','FanQu','0','76','1'),
('701','花都区','HuaDuQu','0','76','1'),
('702','增城区','ZengChengQu','0','76','1'),
('703','从化区','CongHuaQu','0','76','1'),
('704','市郊','ShiJiao','0','76','1'),
('705','福田区','FuTianQu','0','77','1'),
('706','罗湖区','LuoHuQu','0','77','1'),
('707','南山区','NanShanQu','0','77','1'),
('708','宝安区','BaoAnQu','0','77','1'),
('709','龙岗区','LongGangQu','0','77','1'),
('710','盐田区','YanTianQu','0','77','1'),
('711','湘桥区','XiangQiaoQu','0','78','1'),
('712','潮安县','ChaoAnXian','0','78','1'),
('713','饶平县','RaoPingXian','0','78','1'),
('714','南城区','NanChengQu','0','79','1'),
('715','东城区','DongChengQu','0','79','1'),
('716','万江区','WanJiangQu','0','79','1'),
('717','莞城区','ChengQu','0','79','1'),
('718','石龙镇','ShiLongZhen','0','79','1'),
('719','虎门镇','HuMenZhen','0','79','1'),
('720','麻涌镇','MaYongZhen','0','79','1'),
('721','道滘镇','DaoZhen','0','79','1'),
('722','石碣镇','ShiZhen','0','79','1'),
('723','沙田镇','ShaTianZhen','0','79','1'),
('724','望牛墩镇','WangNiuDunZhen','0','79','1'),
('725','洪梅镇','HongMeiZhen','0','79','1'),
('726','茶山镇','ChaShanZhen','0','79','1'),
('727','寮步镇','BuZhen','0','79','1'),
('728','大岭山镇','DaLingShanZhen','0','79','1'),
('729','大朗镇','DaLangZhen','0','79','1'),
('730','黄江镇','HuangJiangZhen','0','79','1'),
('731','樟木头','ZhangMuTou','0','79','1'),
('732','凤岗镇','FengGangZhen','0','79','1'),
('733','塘厦镇','TangXiaZhen','0','79','1'),
('734','谢岗镇','XieGangZhen','0','79','1'),
('735','厚街镇','HouJieZhen','0','79','1'),
('736','清溪镇','QingXiZhen','0','79','1'),
('737','常平镇','ChangPingZhen','0','79','1'),
('738','桥头镇','QiaoTouZhen','0','79','1'),
('739','横沥镇','HengLiZhen','0','79','1'),
('740','东坑镇','DongKengZhen','0','79','1'),
('741','企石镇','QiShiZhen','0','79','1'),
('742','石排镇','ShiPaiZhen','0','79','1'),
('743','长安镇','ChangAnZhen','0','79','1'),
('744','中堂镇','ZhongTangZhen','0','79','1'),
('745','高埗镇','GaoZhen','0','79','1'),
('746','禅城区','ChengQu','0','80','1'),
('747','南海区','NanHaiQu','0','80','1'),
('748','顺德区','ShunDeQu','0','80','1'),
('749','三水区','SanShuiQu','0','80','1'),
('750','高明区','GaoMingQu','0','80','1'),
('751','东源县','DongYuanXian','0','81','1'),
('752','和平县','HePingXian','0','81','1'),
('753','源城区','YuanChengQu','0','81','1'),
('754','连平县','LianPingXian','0','81','1'),
('755','龙川县','LongChuanXian','0','81','1'),
('756','紫金县','ZiJinXian','0','81','1'),
('757','惠阳区','HuiYangQu','0','82','1'),
('758','惠城区','HuiChengQu','0','82','1'),
('759','大亚湾','DaYaWan','0','82','1'),
('760','博罗县','BoLuoXian','0','82','1'),
('761','惠东县','HuiDongXian','0','82','1'),
('762','龙门县','LongMenXian','0','82','1'),
('763','江海区','JiangHaiQu','0','83','1'),
('764','蓬江区','PengJiangQu','0','83','1'),
('765','新会区','XinHuiQu','0','83','1'),
('766','台山市','TaiShanShi','0','83','1'),
('767','开平市','KaiPingShi','0','83','1'),
('768','鹤山市','HeShanShi','0','83','1'),
('769','恩平市','EnPingShi','0','83','1'),
('770','榕城区','ChengQu','0','84','1'),
('771','普宁市','PuNingShi','0','84','1'),
('772','揭东县','JieDongXian','0','84','1'),
('773','揭西县','JieXiXian','0','84','1'),
('774','惠来县','HuiLaiXian','0','84','1'),
('775','茂南区','MaoNanQu','0','85','1'),
('776','茂港区','MaoGangQu','0','85','1'),
('777','高州市','GaoZhouShi','0','85','1'),
('778','化州市','HuaZhouShi','0','85','1'),
('779','信宜市','XinYiShi','0','85','1'),
('780','电白县','DianBaiXian','0','85','1'),
('781','梅县','MeiXian','0','86','1'),
('782','梅江区','MeiJiangQu','0','86','1'),
('783','兴宁市','XingNingShi','0','86','1'),
('784','大埔县','DaPuXian','0','86','1'),
('785','丰顺县','FengShunXian','0','86','1'),
('786','五华县','WuHuaXian','0','86','1'),
('787','平远县','PingYuanXian','0','86','1'),
('788','蕉岭县','JiaoLingXian','0','86','1'),
('789','清城区','QingChengQu','0','87','1'),
('790','英德市','YingDeShi','0','87','1'),
('791','连州市','LianZhouShi','0','87','1'),
('792','佛冈县','FoGangXian','0','87','1'),
('793','阳山县','YangShanXian','0','87','1'),
('794','清新县','QingXinXian','0','87','1'),
('795','连山','LianShan','0','87','1'),
('796','连南','LianNan','0','87','1'),
('797','南澳县','NanAoXian','0','88','1'),
('798','潮阳区','ChaoYangQu','0','88','1'),
('799','澄海区','ChengHaiQu','0','88','1'),
('800','龙湖区','LongHuQu','0','88','1'),
('801','金平区','JinPingQu','0','88','1'),
('802','濠江区','JiangQu','0','88','1'),
('803','潮南区','ChaoNanQu','0','88','1'),
('804','城区','ChengQu','0','89','1'),
('805','陆丰市','LuFengShi','0','89','1'),
('806','海丰县','HaiFengXian','0','89','1'),
('807','陆河县','LuHeXian','0','89','1'),
('808','曲江县','QuJiangXian','0','90','1'),
('809','浈江区','JiangQu','0','90','1'),
('810','武江区','WuJiangQu','0','90','1'),
('811','曲江区','QuJiangQu','0','90','1'),
('812','乐昌市','LeChangShi','0','90','1'),
('813','南雄市','NanXiongShi','0','90','1'),
('814','始兴县','ShiXingXian','0','90','1'),
('815','仁化县','RenHuaXian','0','90','1'),
('816','翁源县','WengYuanXian','0','90','1'),
('817','新丰县','XinFengXian','0','90','1'),
('818','乳源','RuYuan','0','90','1'),
('819','江城区','JiangChengQu','0','91','1'),
('820','阳春市','YangChunShi','0','91','1'),
('821','阳西县','YangXiXian','0','91','1'),
('822','阳东县','YangDongXian','0','91','1'),
('823','云城区','YunChengQu','0','92','1'),
('824','罗定市','LuoDingShi','0','92','1'),
('825','新兴县','XinXingXian','0','92','1'),
('826','郁南县','YuNanXian','0','92','1'),
('827','云安县','YunAnXian','0','92','1'),
('828','赤坎区','ChiKanQu','0','93','1'),
('829','霞山区','XiaShanQu','0','93','1'),
('830','坡头区','PoTouQu','0','93','1'),
('831','麻章区','MaZhangQu','0','93','1'),
('832','廉江市','LianJiangShi','0','93','1'),
('833','雷州市','LeiZhouShi','0','93','1'),
('834','吴川市','WuChuanShi','0','93','1'),
('835','遂溪县','SuiXiXian','0','93','1'),
('836','徐闻县','XuWenXian','0','93','1'),
('837','肇庆市','ZhaoQingShi','0','94','1'),
('838','高要市','GaoYaoShi','0','94','1'),
('839','四会市','SiHuiShi','0','94','1'),
('840','广宁县','GuangNingXian','0','94','1'),
('841','怀集县','HuaiJiXian','0','94','1'),
('842','封开县','FengKaiXian','0','94','1'),
('843','德庆县','DeQingXian','0','94','1'),
('844','石岐街道','ShiJieDao','0','95','1'),
('845','东区街道','DongQuJieDao','0','95','1'),
('846','西区街道','XiQuJieDao','0','95','1'),
('847','环城街道','HuanChengJieDao','0','95','1'),
('848','中山港街道','ZhongShanGangJieDao','0','95','1'),
('849','五桂山街道','WuGuiShanJieDao','0','95','1'),
('850','香洲区','XiangZhouQu','0','96','1'),
('851','斗门区','DouMenQu','0','96','1'),
('852','金湾区','JinWanQu','0','96','1'),
('853','邕宁区','NingQu','0','97','1'),
('854','青秀区','QingXiuQu','0','97','1'),
('855','兴宁区','XingNingQu','0','97','1'),
('856','良庆区','LiangQingQu','0','97','1'),
('857','西乡塘区','XiXiangTangQu','0','97','1'),
('858','江南区','JiangNanQu','0','97','1'),
('859','武鸣县','WuMingXian','0','97','1'),
('860','隆安县','LongAnXian','0','97','1'),
('861','马山县','MaShanXian','0','97','1'),
('862','上林县','ShangLinXian','0','97','1'),
('863','宾阳县','BinYangXian','0','97','1'),
('864','横县','HengXian','0','97','1'),
('865','秀峰区','XiuFengQu','0','98','1'),
('866','叠彩区','DieCaiQu','0','98','1'),
('867','象山区','XiangShanQu','0','98','1'),
('868','七星区','QiXingQu','0','98','1'),
('869','雁山区','YanShanQu','0','98','1'),
('870','阳朔县','YangShuoXian','0','98','1'),
('871','临桂县','LinGuiXian','0','98','1'),
('872','灵川县','LingChuanXian','0','98','1'),
('873','全州县','QuanZhouXian','0','98','1'),
('874','平乐县','PingLeXian','0','98','1'),
('875','兴安县','XingAnXian','0','98','1'),
('876','灌阳县','GuanYangXian','0','98','1'),
('877','荔浦县','LiPuXian','0','98','1'),
('878','资源县','ZiYuanXian','0','98','1'),
('879','永福县','YongFuXian','0','98','1'),
('880','龙胜','LongSheng','0','98','1'),
('881','恭城','GongCheng','0','98','1'),
('882','右江区','YouJiangQu','0','99','1'),
('883','凌云县','LingYunXian','0','99','1'),
('884','平果县','PingGuoXian','0','99','1'),
('885','西林县','XiLinXian','0','99','1'),
('886','乐业县','LeYeXian','0','99','1'),
('887','德保县','DeBaoXian','0','99','1'),
('888','田林县','TianLinXian','0','99','1'),
('889','田阳县','TianYangXian','0','99','1'),
('890','靖西县','JingXiXian','0','99','1'),
('891','田东县','TianDongXian','0','99','1'),
('892','那坡县','NaPoXian','0','99','1'),
('893','隆林','LongLin','0','99','1'),
('894','海城区','HaiChengQu','0','100','1'),
('895','银海区','YinHaiQu','0','100','1'),
('896','铁山港区','TieShanGangQu','0','100','1'),
('897','合浦县','HePuXian','0','100','1'),
('898','江州区','JiangZhouQu','0','101','1'),
('899','凭祥市','PingXiangShi','0','101','1'),
('900','宁明县','NingMingXian','0','101','1'),
('901','扶绥县','FuSuiXian','0','101','1'),
('902','龙州县','LongZhouXian','0','101','1'),
('903','大新县','DaXinXian','0','101','1'),
('904','天等县','TianDengXian','0','101','1'),
('905','港口区','GangKouQu','0','102','1'),
('906','防城区','FangChengQu','0','102','1'),
('907','东兴市','DongXingShi','0','102','1'),
('908','上思县','ShangSiXian','0','102','1'),
('909','港北区','GangBeiQu','0','103','1'),
('910','港南区','GangNanQu','0','103','1'),
('911','覃塘区','TangQu','0','103','1'),
('912','桂平市','GuiPingShi','0','103','1'),
('913','平南县','PingNanXian','0','103','1'),
('914','金城江区','JinChengJiangQu','0','104','1'),
('915','宜州市','YiZhouShi','0','104','1'),
('916','天峨县','TianEXian','0','104','1'),
('917','凤山县','FengShanXian','0','104','1'),
('918','南丹县','NanDanXian','0','104','1'),
('919','东兰县','DongLanXian','0','104','1'),
('920','都安','DuAn','0','104','1'),
('921','罗城','LuoCheng','0','104','1'),
('922','巴马','BaMa','0','104','1'),
('923','环江','HuanJiang','0','104','1'),
('924','大化','DaHua','0','104','1'),
('925','八步区','BaBuQu','0','105','1'),
('926','钟山县','ZhongShanXian','0','105','1'),
('927','昭平县','ZhaoPingXian','0','105','1'),
('928','富川','FuChuan','0','105','1'),
('929','兴宾区','XingBinQu','0','106','1'),
('930','合山市','HeShanShi','0','106','1'),
('931','象州县','XiangZhouXian','0','106','1'),
('932','武宣县','WuXuanXian','0','106','1'),
('933','忻城县','XinChengXian','0','106','1'),
('934','金秀','JinXiu','0','106','1'),
('935','城中区','ChengZhongQu','0','107','1'),
('936','鱼峰区','YuFengQu','0','107','1'),
('937','柳北区','LiuBeiQu','0','107','1'),
('938','柳南区','LiuNanQu','0','107','1'),
('939','柳江县','LiuJiangXian','0','107','1'),
('940','柳城县','LiuChengXian','0','107','1'),
('941','鹿寨县','LuZhaiXian','0','107','1'),
('942','融安县','RongAnXian','0','107','1'),
('943','融水','RongShui','0','107','1'),
('944','三江','SanJiang','0','107','1'),
('945','钦南区','QinNanQu','0','108','1'),
('946','钦北区','QinBeiQu','0','108','1'),
('947','灵山县','LingShanXian','0','108','1'),
('948','浦北县','PuBeiXian','0','108','1'),
('949','万秀区','WanXiuQu','0','109','1'),
('950','蝶山区','DieShanQu','0','109','1'),
('951','长洲区','ChangZhouQu','0','109','1'),
('952','岑溪市','XiShi','0','109','1'),
('953','苍梧县','CangWuXian','0','109','1'),
('954','藤县','TengXian','0','109','1'),
('955','蒙山县','MengShanXian','0','109','1'),
('956','玉州区','YuZhouQu','0','110','1'),
('957','北流市','BeiLiuShi','0','110','1'),
('958','容县','RongXian','0','110','1'),
('959','陆川县','LuChuanXian','0','110','1'),
('960','博白县','BoBaiXian','0','110','1'),
('961','兴业县','XingYeXian','0','110','1'),
('962','南明区','NanMingQu','0','111','1'),
('963','云岩区','YunYanQu','0','111','1'),
('964','花溪区','HuaXiQu','0','111','1'),
('965','乌当区','WuDangQu','0','111','1'),
('966','白云区','BaiYunQu','0','111','1'),
('967','小河区','XiaoHeQu','0','111','1'),
('968','金阳新区','JinYangXinQu','0','111','1'),
('969','新天园区','XinTianYuanQu','0','111','1'),
('970','清镇市','QingZhenShi','0','111','1'),
('971','开阳县','KaiYangXian','0','111','1'),
('972','修文县','XiuWenXian','0','111','1'),
('973','息烽县','XiFengXian','0','111','1'),
('974','西秀区','XiXiuQu','0','112','1'),
('975','关岭','GuanLing','0','112','1'),
('976','镇宁','ZhenNing','0','112','1'),
('977','紫云','ZiYun','0','112','1'),
('978','平坝县','PingBaXian','0','112','1'),
('979','普定县','PuDingXian','0','112','1'),
('980','毕节市','BiJieShi','0','113','1'),
('981','大方县','DaFangXian','0','113','1'),
('982','黔西县','QianXiXian','0','113','1'),
('983','金沙县','JinShaXian','0','113','1'),
('984','织金县','ZhiJinXian','0','113','1'),
('985','纳雍县','NaYongXian','0','113','1'),
('986','赫章县','HeZhangXian','0','113','1'),
('987','威宁','WeiNing','0','113','1'),
('988','钟山区','ZhongShanQu','0','114','1'),
('989','六枝特区','LiuZhiTeQu','0','114','1'),
('990','水城县','ShuiChengXian','0','114','1'),
('991','盘县','PanXian','0','114','1'),
('992','凯里市','KaiLiShi','0','115','1'),
('993','黄平县','HuangPingXian','0','115','1'),
('994','施秉县','ShiBingXian','0','115','1'),
('995','三穗县','SanSuiXian','0','115','1'),
('996','镇远县','ZhenYuanXian','0','115','1'),
('997','岑巩县','GongXian','0','115','1'),
('998','天柱县','TianZhuXian','0','115','1'),
('999','锦屏县','JinPingXian','0','115','1'),
('1000','剑河县','JianHeXian','0','115','1'),
('1001','台江县','TaiJiangXian','0','115','1'),
('1002','黎平县','LiPingXian','0','115','1'),
('1003','榕江县','JiangXian','0','115','1'),
('1004','从江县','CongJiangXian','0','115','1'),
('1005','雷山县','LeiShanXian','0','115','1'),
('1006','麻江县','MaJiangXian','0','115','1'),
('1007','丹寨县','DanZhaiXian','0','115','1'),
('1008','都匀市','DuYunShi','0','116','1'),
('1009','福泉市','FuQuanShi','0','116','1'),
('1010','荔波县','LiBoXian','0','116','1'),
('1011','贵定县','GuiDingXian','0','116','1'),
('1012','瓮安县','WengAnXian','0','116','1'),
('1013','独山县','DuShanXian','0','116','1'),
('1014','平塘县','PingTangXian','0','116','1'),
('1015','罗甸县','LuoDianXian','0','116','1'),
('1016','长顺县','ChangShunXian','0','116','1'),
('1017','龙里县','LongLiXian','0','116','1'),
('1018','惠水县','HuiShuiXian','0','116','1'),
('1019','三都','SanDu','0','116','1'),
('1020','兴义市','XingYiShi','0','117','1'),
('1021','兴仁县','XingRenXian','0','117','1'),
('1022','普安县','PuAnXian','0','117','1'),
('1023','晴隆县','QingLongXian','0','117','1'),
('1024','贞丰县','ZhenFengXian','0','117','1'),
('1025','望谟县','WangXian','0','117','1'),
('1026','册亨县','CeHengXian','0','117','1'),
('1027','安龙县','AnLongXian','0','117','1'),
('1028','铜仁市','TongRenShi','0','118','1'),
('1029','江口县','JiangKouXian','0','118','1'),
('1030','石阡县','ShiXian','0','118','1'),
('1031','思南县','SiNanXian','0','118','1'),
('1032','德江县','DeJiangXian','0','118','1'),
('1033','玉屏','YuPing','0','118','1'),
('1034','印江','YinJiang','0','118','1'),
('1035','沿河','YanHe','0','118','1'),
('1036','松桃','SongTao','0','118','1'),
('1037','万山特区','WanShanTeQu','0','118','1'),
('1038','红花岗区','HongHuaGangQu','0','119','1'),
('1039','务川县','WuChuanXian','0','119','1'),
('1040','道真县','DaoZhenXian','0','119','1'),
('1041','汇川区','HuiChuanQu','0','119','1'),
('1042','赤水市','ChiShuiShi','0','119','1'),
('1043','仁怀市','RenHuaiShi','0','119','1'),
('1044','遵义县','ZunYiXian','0','119','1'),
('1045','桐梓县','TongXian','0','119','1'),
('1046','绥阳县','SuiYangXian','0','119','1'),
('1047','正安县','ZhengAnXian','0','119','1'),
('1048','凤冈县','FengGangXian','0','119','1'),
('1049','湄潭县','TanXian','0','119','1'),
('1050','余庆县','YuQingXian','0','119','1'),
('1051','习水县','XiShuiXian','0','119','1'),
('1052','道真','DaoZhen','0','119','1'),
('1053','务川','WuChuan','0','119','1'),
('1054','秀英区','XiuYingQu','0','120','1'),
('1055','龙华区','LongHuaQu','0','120','1'),
('1056','琼山区','QiongShanQu','0','120','1'),
('1057','美兰区','MeiLanQu','0','120','1'),
('1058','市区','ShiQu','0','137','1'),
('1059','洋浦开发区','YangPuKaiFaQu','0','137','1'),
('1060','那大镇','NaDaZhen','0','137','1'),
('1061','王五镇','WangWuZhen','0','137','1'),
('1062','雅星镇','YaXingZhen','0','137','1'),
('1063','大成镇','DaChengZhen','0','137','1'),
('1064','中和镇','ZhongHeZhen','0','137','1'),
('1065','峨蔓镇','EManZhen','0','137','1'),
('1066','南丰镇','NanFengZhen','0','137','1'),
('1067','白马井镇','BaiMaJingZhen','0','137','1'),
('1068','兰洋镇','LanYangZhen','0','137','1'),
('1069','和庆镇','HeQingZhen','0','137','1'),
('1070','海头镇','HaiTouZhen','0','137','1'),
('1071','排浦镇','PaiPuZhen','0','137','1'),
('1072','东成镇','DongChengZhen','0','137','1'),
('1073','光村镇','GuangCunZhen','0','137','1'),
('1074','木棠镇','MuTangZhen','0','137','1'),
('1075','新州镇','XinZhouZhen','0','137','1'),
('1076','三都镇','SanDuZhen','0','137','1'),
('1077','其他','QiTa','0','137','1'),
('1078','长安区','ChangAnQu','0','138','1'),
('1079','桥东区','QiaoDongQu','0','138','1'),
('1080','桥西区','QiaoXiQu','0','138','1'),
('1081','新华区','XinHuaQu','0','138','1'),
('1082','裕华区','YuHuaQu','0','138','1'),
('1083','井陉矿区','JingKuangQu','0','138','1'),
('1084','高新区','GaoXinQu','0','138','1'),
('1085','辛集市','XinJiShi','0','138','1'),
('1086','藁城市','ChengShi','0','138','1'),
('1087','晋州市','JinZhouShi','0','138','1'),
('1088','新乐市','XinLeShi','0','138','1'),
('1089','鹿泉市','LuQuanShi','0','138','1'),
('1090','井陉县','JingXian','0','138','1'),
('1091','正定县','ZhengDingXian','0','138','1'),
('1092','栾城县','ChengXian','0','138','1'),
('1093','行唐县','XingTangXian','0','138','1'),
('1094','灵寿县','LingShouXian','0','138','1'),
('1095','高邑县','GaoYiXian','0','138','1'),
('1096','深泽县','ShenZeXian','0','138','1'),
('1097','赞皇县','ZanHuangXian','0','138','1'),
('1098','无极县','WuJiXian','0','138','1'),
('1099','平山县','PingShanXian','0','138','1'),
('1100','元氏县','YuanShiXian','0','138','1'),
('1101','赵县','ZhaoXian','0','138','1'),
('1102','新市区','XinShiQu','0','139','1'),
('1103','南市区','NanShiQu','0','139','1'),
('1104','北市区','BeiShiQu','0','139','1'),
('1105','涿州市','ZhouShi','0','139','1'),
('1106','定州市','DingZhouShi','0','139','1'),
('1107','安国市','AnGuoShi','0','139','1'),
('1108','高碑店市','GaoBeiDianShi','0','139','1'),
('1109','满城县','ManChengXian','0','139','1'),
('1110','清苑县','QingYuanXian','0','139','1'),
('1111','涞水县','ShuiXian','0','139','1'),
('1112','阜平县','FuPingXian','0','139','1'),
('1113','徐水县','XuShuiXian','0','139','1'),
('1114','定兴县','DingXingXian','0','139','1'),
('1115','唐县','TangXian','0','139','1'),
('1116','高阳县','GaoYangXian','0','139','1'),
('1117','容城县','RongChengXian','0','139','1'),
('1118','涞源县','YuanXian','0','139','1'),
('1119','望都县','WangDuXian','0','139','1'),
('1120','安新县','AnXinXian','0','139','1'),
('1121','易县','YiXian','0','139','1'),
('1122','曲阳县','QuYangXian','0','139','1'),
('1123','蠡县','Xian','0','139','1'),
('1124','顺平县','ShunPingXian','0','139','1'),
('1125','博野县','BoYeXian','0','139','1'),
('1126','雄县','XiongXian','0','139','1'),
('1127','运河区','YunHeQu','0','140','1'),
('1128','新华区','XinHuaQu','0','140','1'),
('1129','泊头市','BoTouShi','0','140','1'),
('1130','任丘市','RenQiuShi','0','140','1'),
('1131','黄骅市','HuangShi','0','140','1'),
('1132','河间市','HeJianShi','0','140','1'),
('1133','沧县','CangXian','0','140','1'),
('1134','青县','QingXian','0','140','1'),
('1135','东光县','DongGuangXian','0','140','1'),
('1136','海兴县','HaiXingXian','0','140','1'),
('1137','盐山县','YanShanXian','0','140','1'),
('1138','肃宁县','SuNingXian','0','140','1'),
('1139','南皮县','NanPiXian','0','140','1'),
('1140','吴桥县','WuQiaoXian','0','140','1'),
('1141','献县','XianXian','0','140','1'),
('1142','孟村','MengCun','0','140','1'),
('1143','双桥区','ShuangQiaoQu','0','141','1'),
('1144','双滦区','ShuangLuanQu','0','141','1'),
('1145','鹰手营子矿区','YingShouYingZiKuangQu','0','141','1'),
('1146','承德县','ChengDeXian','0','141','1'),
('1147','兴隆县','XingLongXian','0','141','1'),
('1148','平泉县','PingQuanXian','0','141','1'),
('1149','滦平县','LuanPingXian','0','141','1'),
('1150','隆化县','LongHuaXian','0','141','1'),
('1151','丰宁','FengNing','0','141','1'),
('1152','宽城','KuanCheng','0','141','1'),
('1153','围场','WeiChang','0','141','1'),
('1154','从台区','CongTaiQu','0','142','1'),
('1155','复兴区','FuXingQu','0','142','1'),
('1156','邯山区','HanShanQu','0','142','1'),
('1157','峰峰矿区','FengFengKuangQu','0','142','1'),
('1158','武安市','WuAnShi','0','142','1'),
('1159','邯郸县','HanDanXian','0','142','1'),
('1160','临漳县','LinZhangXian','0','142','1'),
('1161','成安县','ChengAnXian','0','142','1'),
('1162','大名县','DaMingXian','0','142','1'),
('1163','涉县','SheXian','0','142','1'),
('1164','磁县','CiXian','0','142','1'),
('1165','肥乡县','FeiXiangXian','0','142','1'),
('1166','永年县','YongNianXian','0','142','1'),
('1167','邱县','QiuXian','0','142','1'),
('1168','鸡泽县','JiZeXian','0','142','1'),
('1169','广平县','GuangPingXian','0','142','1'),
('1170','馆陶县','GuanTaoXian','0','142','1'),
('1171','魏县','WeiXian','0','142','1'),
('1172','曲周县','QuZhouXian','0','142','1'),
('1173','桃城区','TaoChengQu','0','143','1'),
('1174','冀州市','JiZhouShi','0','143','1'),
('1175','深州市','ShenZhouShi','0','143','1'),
('1176','枣强县','ZaoQiangXian','0','143','1'),
('1177','武邑县','WuYiXian','0','143','1'),
('1178','武强县','WuQiangXian','0','143','1'),
('1179','饶阳县','RaoYangXian','0','143','1'),
('1180','安平县','AnPingXian','0','143','1'),
('1181','故城县','GuChengXian','0','143','1'),
('1182','景县','JingXian','0','143','1'),
('1183','阜城县','FuChengXian','0','143','1'),
('1184','安次区','AnCiQu','0','144','1'),
('1185','广阳区','GuangYangQu','0','144','1'),
('1186','霸州市','BaZhouShi','0','144','1'),
('1187','三河市','SanHeShi','0','144','1'),
('1188','固安县','GuAnXian','0','144','1'),
('1189','永清县','YongQingXian','0','144','1'),
('1190','香河县','XiangHeXian','0','144','1'),
('1191','大城县','DaChengXian','0','144','1'),
('1192','文安县','WenAnXian','0','144','1'),
('1193','大厂','DaChang','0','144','1'),
('1194','海港区','HaiGangQu','0','145','1'),
('1195','山海关区','ShanHaiGuanQu','0','145','1'),
('1196','北戴河区','BeiDaiHeQu','0','145','1'),
('1197','昌黎县','ChangLiXian','0','145','1'),
('1198','抚宁县','FuNingXian','0','145','1'),
('1199','卢龙县','LuLongXian','0','145','1'),
('1200','青龙','QingLong','0','145','1'),
('1201','路北区','LuBeiQu','0','146','1'),
('1202','路南区','LuNanQu','0','146','1'),
('1203','古冶区','GuYeQu','0','146','1'),
('1204','开平区','KaiPingQu','0','146','1'),
('1205','丰南区','FengNanQu','0','146','1'),
('1206','丰润区','FengRunQu','0','146','1'),
('1207','遵化市','ZunHuaShi','0','146','1'),
('1208','迁安市','QianAnShi','0','146','1'),
('1209','滦县','LuanXian','0','146','1'),
('1210','滦南县','LuanNanXian','0','146','1'),
('1211','乐亭县','LeTingXian','0','146','1'),
('1212','迁西县','QianXiXian','0','146','1'),
('1213','玉田县','YuTianXian','0','146','1'),
('1214','唐海县','TangHaiXian','0','146','1'),
('1215','桥东区','QiaoDongQu','0','147','1'),
('1216','桥西区','QiaoXiQu','0','147','1'),
('1217','南宫市','NanGongShi','0','147','1'),
('1218','沙河市','ShaHeShi','0','147','1'),
('1219','邢台县','XingTaiXian','0','147','1'),
('1220','临城县','LinChengXian','0','147','1'),
('1221','内丘县','NeiQiuXian','0','147','1'),
('1222','柏乡县','BaiXiangXian','0','147','1'),
('1223','隆尧县','LongYaoXian','0','147','1'),
('1224','任县','RenXian','0','147','1'),
('1225','南和县','NanHeXian','0','147','1'),
('1226','宁晋县','NingJinXian','0','147','1'),
('1227','巨鹿县','JuLuXian','0','147','1'),
('1228','新河县','XinHeXian','0','147','1'),
('1229','广宗县','GuangZongXian','0','147','1'),
('1230','平乡县','PingXiangXian','0','147','1'),
('1231','威县','WeiXian','0','147','1'),
('1232','清河县','QingHeXian','0','147','1'),
('1233','临西县','LinXiXian','0','147','1'),
('1234','桥西区','QiaoXiQu','0','148','1'),
('1235','桥东区','QiaoDongQu','0','148','1'),
('1236','宣化区','XuanHuaQu','0','148','1'),
('1237','下花园区','XiaHuaYuanQu','0','148','1'),
('1238','宣化县','XuanHuaXian','0','148','1'),
('1239','张北县','ZhangBeiXian','0','148','1'),
('1240','康保县','KangBaoXian','0','148','1'),
('1241','沽源县','GuYuanXian','0','148','1'),
('1242','尚义县','ShangYiXian','0','148','1'),
('1243','蔚县','WeiXian','0','148','1'),
('1244','阳原县','YangYuanXian','0','148','1'),
('1245','怀安县','HuaiAnXian','0','148','1'),
('1246','万全县','WanQuanXian','0','148','1'),
('1247','怀来县','HuaiLaiXian','0','148','1'),
('1248','涿鹿县','LuXian','0','148','1'),
('1249','赤城县','ChiChengXian','0','148','1'),
('1250','崇礼县','ChongLiXian','0','148','1'),
('1251','金水区','JinShuiQu','0','149','1'),
('1252','邙山区','ShanQu','0','149','1'),
('1253','二七区','ErQiQu','0','149','1'),
('1254','管城区','GuanChengQu','0','149','1'),
('1255','中原区','ZhongYuanQu','0','149','1'),
('1256','上街区','ShangJieQu','0','149','1'),
('1257','惠济区','HuiJiQu','0','149','1'),
('1258','郑东新区','ZhengDongXinQu','0','149','1'),
('1259','经济技术开发区','JingJiJiShuKaiFaQu','0','149','1'),
('1260','高新开发区','GaoXinKaiFaQu','0','149','1'),
('1261','出口加工区','ChuKouJiaGongQu','0','149','1'),
('1262','巩义市','GongYiShi','0','149','1'),
('1263','荥阳市','YangShi','0','149','1'),
('1264','新密市','XinMiShi','0','149','1'),
('1265','新郑市','XinZhengShi','0','149','1'),
('1266','登封市','DengFengShi','0','149','1'),
('1267','中牟县','ZhongMouXian','0','149','1'),
('1268','西工区','XiGongQu','0','150','1'),
('1269','老城区','LaoChengQu','0','150','1'),
('1270','涧西区','JianXiQu','0','150','1'),
('1271','瀍河回族区','HeHuiZuQu','0','150','1'),
('1272','洛龙区','LuoLongQu','0','150','1'),
('1273','吉利区','JiLiQu','0','150','1'),
('1274','偃师市','ShiShi','0','150','1'),
('1275','孟津县','MengJinXian','0','150','1'),
('1276','新安县','XinAnXian','0','150','1'),
('1277','栾川县','ChuanXian','0','150','1'),
('1278','嵩县','Xian','0','150','1'),
('1279','汝阳县','RuYangXian','0','150','1'),
('1280','宜阳县','YiYangXian','0','150','1'),
('1281','洛宁县','LuoNingXian','0','150','1'),
('1282','伊川县','YiChuanXian','0','150','1'),
('1283','鼓楼区','GuLouQu','0','151','1'),
('1284','龙亭区','LongTingQu','0','151','1'),
('1285','顺河回族区','ShunHeHuiZuQu','0','151','1'),
('1286','金明区','JinMingQu','0','151','1'),
('1287','禹王台区','YuWangTaiQu','0','151','1'),
('1288','杞县','Xian','0','151','1'),
('1289','通许县','TongXuXian','0','151','1'),
('1290','尉氏县','WeiShiXian','0','151','1'),
('1291','开封县','KaiFengXian','0','151','1'),
('1292','兰考县','LanKaoXian','0','151','1'),
('1293','北关区','BeiGuanQu','0','152','1'),
('1294','文峰区','WenFengQu','0','152','1'),
('1295','殷都区','YinDuQu','0','152','1'),
('1296','龙安区','LongAnQu','0','152','1'),
('1297','林州市','LinZhouShi','0','152','1'),
('1298','安阳县','AnYangXian','0','152','1'),
('1299','汤阴县','TangYinXian','0','152','1'),
('1300','滑县','HuaXian','0','152','1'),
('1301','内黄县','NeiHuangXian','0','152','1'),
('1302','淇滨区','BinQu','0','153','1'),
('1303','山城区','ShanChengQu','0','153','1'),
('1304','鹤山区','HeShanQu','0','153','1'),
('1305','浚县','JunXian','0','153','1'),
('1306','淇县','Xian','0','153','1'),
('1307','济源市','JiYuanShi','0','154','1'),
('1308','解放区','JieFangQu','0','155','1'),
('1309','中站区','ZhongZhanQu','0','155','1'),
('1310','马村区','MaCunQu','0','155','1'),
('1311','山阳区','ShanYangQu','0','155','1'),
('1312','沁阳市','QinYangShi','0','155','1'),
('1313','孟州市','MengZhouShi','0','155','1'),
('1314','修武县','XiuWuXian','0','155','1'),
('1315','博爱县','BoAiXian','0','155','1'),
('1316','武陟县','WuXian','0','155','1'),
('1317','温县','WenXian','0','155','1'),
('1318','卧龙区','WoLongQu','0','156','1'),
('1319','宛城区','WanChengQu','0','156','1'),
('1320','邓州市','DengZhouShi','0','156','1'),
('1321','南召县','NanZhaoXian','0','156','1'),
('1322','方城县','FangChengXian','0','156','1'),
('1323','西峡县','XiXiaXian','0','156','1'),
('1324','镇平县','ZhenPingXian','0','156','1'),
('1325','内乡县','NeiXiangXian','0','156','1'),
('1326','淅川县','ChuanXian','0','156','1'),
('1327','社旗县','SheQiXian','0','156','1'),
('1328','唐河县','TangHeXian','0','156','1'),
('1329','新野县','XinYeXian','0','156','1'),
('1330','桐柏县','TongBaiXian','0','156','1'),
('1331','新华区','XinHuaQu','0','157','1'),
('1332','卫东区','WeiDongQu','0','157','1'),
('1333','湛河区','ZhanHeQu','0','157','1'),
('1334','石龙区','ShiLongQu','0','157','1'),
('1335','舞钢市','WuGangShi','0','157','1'),
('1336','汝州市','RuZhouShi','0','157','1'),
('1337','宝丰县','BaoFengXian','0','157','1'),
('1338','叶县','YeXian','0','157','1'),
('1339','鲁山县','LuShanXian','0','157','1'),
('1340','郏县','Xian','0','157','1'),
('1341','湖滨区','HuBinQu','0','158','1'),
('1342','义马市','YiMaShi','0','158','1'),
('1343','灵宝市','LingBaoShi','0','158','1'),
('1344','渑池县','ChiXian','0','158','1'),
('1345','陕县','ShanXian','0','158','1'),
('1346','卢氏县','LuShiXian','0','158','1'),
('1347','梁园区','LiangYuanQu','0','159','1'),
('1348','睢阳区','YangQu','0','159','1'),
('1349','永城市','YongChengShi','0','159','1'),
('1350','民权县','MinQuanXian','0','159','1'),
('1351','睢县','Xian','0','159','1'),
('1352','宁陵县','NingLingXian','0','159','1'),
('1353','虞城县','YuChengXian','0','159','1'),
('1354','柘城县','ChengXian','0','159','1'),
('1355','夏邑县','XiaYiXian','0','159','1'),
('1356','卫滨区','WeiBinQu','0','160','1'),
('1357','红旗区','HongQiQu','0','160','1'),
('1358','凤泉区','FengQuanQu','0','160','1'),
('1359','牧野区','MuYeQu','0','160','1'),
('1360','卫辉市','WeiHuiShi','0','160','1'),
('1361','辉县市','HuiXianShi','0','160','1'),
('1362','新乡县','XinXiangXian','0','160','1'),
('1363','获嘉县','HuoJiaXian','0','160','1'),
('1364','原阳县','YuanYangXian','0','160','1'),
('1365','延津县','YanJinXian','0','160','1'),
('1366','封丘县','FengQiuXian','0','160','1'),
('1367','长垣县','ChangYuanXian','0','160','1'),
('1368','浉河区','HeQu','0','161','1'),
('1369','平桥区','PingQiaoQu','0','161','1'),
('1370','罗山县','LuoShanXian','0','161','1'),
('1371','光山县','GuangShanXian','0','161','1'),
('1372','新县','XinXian','0','161','1'),
('1373','商城县','ShangChengXian','0','161','1'),
('1374','固始县','GuShiXian','0','161','1'),
('1375','潢川县','ChuanXian','0','161','1'),
('1376','淮滨县','HuaiBinXian','0','161','1'),
('1377','息县','XiXian','0','161','1'),
('1378','魏都区','WeiDuQu','0','162','1'),
('1379','禹州市','YuZhouShi','0','162','1'),
('1380','长葛市','ChangGeShi','0','162','1'),
('1381','许昌县','XuChangXian','0','162','1'),
('1382','鄢陵县','LingXian','0','162','1'),
('1383','襄城县','XiangChengXian','0','162','1'),
('1384','川汇区','ChuanHuiQu','0','163','1'),
('1385','项城市','XiangChengShi','0','163','1'),
('1386','扶沟县','FuGouXian','0','163','1'),
('1387','西华县','XiHuaXian','0','163','1'),
('1388','商水县','ShangShuiXian','0','163','1'),
('1389','沈丘县','ShenQiuXian','0','163','1'),
('1390','郸城县','DanChengXian','0','163','1'),
('1391','淮阳县','HuaiYangXian','0','163','1'),
('1392','太康县','TaiKangXian','0','163','1'),
('1393','鹿邑县','LuYiXian','0','163','1'),
('1394','驿城区','ChengQu','0','164','1'),
('1395','西平县','XiPingXian','0','164','1'),
('1396','上蔡县','ShangCaiXian','0','164','1'),
('1397','平舆县','PingYuXian','0','164','1'),
('1398','正阳县','ZhengYangXian','0','164','1'),
('1399','确山县','QueShanXian','0','164','1'),
('1400','泌阳县','MiYangXian','0','164','1'),
('1401','汝南县','RuNanXian','0','164','1'),
('1402','遂平县','SuiPingXian','0','164','1'),
('1403','新蔡县','XinCaiXian','0','164','1'),
('1404','郾城区','ChengQu','0','165','1'),
('1405','源汇区','YuanHuiQu','0','165','1'),
('1406','召陵区','ZhaoLingQu','0','165','1'),
('1407','舞阳县','WuYangXian','0','165','1'),
('1408','临颍县','LinXian','0','165','1'),
('1409','华龙区','HuaLongQu','0','166','1'),
('1410','清丰县','QingFengXian','0','166','1'),
('1411','南乐县','NanLeXian','0','166','1'),
('1412','范县','FanXian','0','166','1'),
('1413','台前县','TaiQianXian','0','166','1'),
('1414','濮阳县','YangXian','0','166','1'),
('1415','道里区','DaoLiQu','0','167','1'),
('1416','南岗区','NanGangQu','0','167','1'),
('1417','动力区','DongLiQu','0','167','1'),
('1418','平房区','PingFangQu','0','167','1'),
('1419','香坊区','XiangFangQu','0','167','1'),
('1420','太平区','TaiPingQu','0','167','1'),
('1421','道外区','DaoWaiQu','0','167','1'),
('1422','阿城区','AChengQu','0','167','1'),
('1423','呼兰区','HuLanQu','0','167','1'),
('1424','松北区','SongBeiQu','0','167','1'),
('1425','尚志市','ShangZhiShi','0','167','1'),
('1426','双城市','ShuangChengShi','0','167','1'),
('1427','五常市','WuChangShi','0','167','1'),
('1428','方正县','FangZhengXian','0','167','1'),
('1429','宾县','BinXian','0','167','1'),
('1430','依兰县','YiLanXian','0','167','1'),
('1431','巴彦县','BaYanXian','0','167','1'),
('1432','通河县','TongHeXian','0','167','1'),
('1433','木兰县','MuLanXian','0','167','1'),
('1434','延寿县','YanShouXian','0','167','1'),
('1435','萨尔图区','SaErTuQu','0','168','1'),
('1436','红岗区','HongGangQu','0','168','1'),
('1437','龙凤区','LongFengQu','0','168','1'),
('1438','让胡路区','RangHuLuQu','0','168','1'),
('1439','大同区','DaTongQu','0','168','1'),
('1440','肇州县','ZhaoZhouXian','0','168','1'),
('1441','肇源县','ZhaoYuanXian','0','168','1'),
('1442','林甸县','LinDianXian','0','168','1'),
('1443','杜尔伯特','DuErBoTe','0','168','1'),
('1444','呼玛县','HuMaXian','0','169','1'),
('1445','漠河县','MoHeXian','0','169','1'),
('1446','塔河县','TaHeXian','0','169','1'),
('1447','兴山区','XingShanQu','0','170','1'),
('1448','工农区','GongNongQu','0','170','1'),
('1449','南山区','NanShanQu','0','170','1'),
('1450','兴安区','XingAnQu','0','170','1'),
('1451','向阳区','XiangYangQu','0','170','1'),
('1452','东山区','DongShanQu','0','170','1'),
('1453','萝北县','LuoBeiXian','0','170','1'),
('1454','绥滨县','SuiBinXian','0','170','1'),
('1455','爱辉区','AiHuiQu','0','171','1'),
('1456','五大连池市','WuDaLianChiShi','0','171','1'),
('1457','北安市','BeiAnShi','0','171','1'),
('1458','嫩江县','NenJiangXian','0','171','1'),
('1459','逊克县','XunKeXian','0','171','1'),
('1460','孙吴县','SunWuXian','0','171','1'),
('1461','鸡冠区','JiGuanQu','0','172','1'),
('1462','恒山区','HengShanQu','0','172','1'),
('1463','城子河区','ChengZiHeQu','0','172','1'),
('1464','滴道区','DiDaoQu','0','172','1'),
('1465','梨树区','LiShuQu','0','172','1'),
('1466','虎林市','HuLinShi','0','172','1'),
('1467','密山市','MiShanShi','0','172','1'),
('1468','鸡东县','JiDongXian','0','172','1'),
('1469','前进区','QianJinQu','0','173','1'),
('1470','郊区','JiaoQu','0','173','1'),
('1471','向阳区','XiangYangQu','0','173','1'),
('1472','东风区','DongFengQu','0','173','1'),
('1473','同江市','TongJiangShi','0','173','1'),
('1474','富锦市','FuJinShi','0','173','1'),
('1475','桦南县','NanXian','0','173','1'),
('1476','桦川县','ChuanXian','0','173','1'),
('1477','汤原县','TangYuanXian','0','173','1'),
('1478','抚远县','FuYuanXian','0','173','1'),
('1479','爱民区','AiMinQu','0','174','1'),
('1480','东安区','DongAnQu','0','174','1'),
('1481','阳明区','YangMingQu','0','174','1'),
('1482','西安区','XiAnQu','0','174','1'),
('1483','绥芬河市','SuiFenHeShi','0','174','1'),
('1484','海林市','HaiLinShi','0','174','1'),
('1485','宁安市','NingAnShi','0','174','1'),
('1486','穆棱市','MuLengShi','0','174','1'),
('1487','东宁县','DongNingXian','0','174','1'),
('1488','林口县','LinKouXian','0','174','1'),
('1489','桃山区','TaoShanQu','0','175','1'),
('1490','新兴区','XinXingQu','0','175','1'),
('1491','茄子河区','QieZiHeQu','0','175','1'),
('1492','勃利县','BoLiXian','0','175','1'),
('1493','龙沙区','LongShaQu','0','176','1'),
('1494','昂昂溪区','AngAngXiQu','0','176','1'),
('1495','铁峰区','TieFengQu','0','176','1'),
('1496','建华区','JianHuaQu','0','176','1'),
('1497','富拉尔基区','FuLaErJiQu','0','176','1'),
('1498','碾子山区','NianZiShanQu','0','176','1'),
('1499','梅里斯达斡尔区','MeiLiSiDaWoErQu','0','176','1'),
('1500','讷河市','HeShi','0','176','1'),
('1501','龙江县','LongJiangXian','0','176','1'),
('1502','依安县','YiAnXian','0','176','1'),
('1503','泰来县','TaiLaiXian','0','176','1'),
('1504','甘南县','GanNanXian','0','176','1'),
('1505','富裕县','FuYuXian','0','176','1'),
('1506','克山县','KeShanXian','0','176','1'),
('1507','克东县','KeDongXian','0','176','1'),
('1508','拜泉县','BaiQuanXian','0','176','1'),
('1509','尖山区','JianShanQu','0','177','1'),
('1510','岭东区','LingDongQu','0','177','1'),
('1511','四方台区','SiFangTaiQu','0','177','1'),
('1512','宝山区','BaoShanQu','0','177','1'),
('1513','集贤县','JiXianXian','0','177','1'),
('1514','友谊县','YouYiXian','0','177','1'),
('1515','宝清县','BaoQingXian','0','177','1'),
('1516','饶河县','RaoHeXian','0','177','1'),
('1517','北林区','BeiLinQu','0','178','1'),
('1518','安达市','AnDaShi','0','178','1'),
('1519','肇东市','ZhaoDongShi','0','178','1'),
('1520','海伦市','HaiLunShi','0','178','1'),
('1521','望奎县','WangKuiXian','0','178','1'),
('1522','兰西县','LanXiXian','0','178','1'),
('1523','青冈县','QingGangXian','0','178','1'),
('1524','庆安县','QingAnXian','0','178','1'),
('1525','明水县','MingShuiXian','0','178','1'),
('1526','绥棱县','SuiLengXian','0','178','1'),
('1527','伊春区','YiChunQu','0','179','1'),
('1528','带岭区','DaiLingQu','0','179','1'),
('1529','南岔区','NanChaQu','0','179','1'),
('1530','金山屯区','JinShanTunQu','0','179','1'),
('1531','西林区','XiLinQu','0','179','1'),
('1532','美溪区','MeiXiQu','0','179','1'),
('1533','乌马河区','WuMaHeQu','0','179','1'),
('1534','翠峦区','CuiLuanQu','0','179','1'),
('1535','友好区','YouHaoQu','0','179','1'),
('1536','上甘岭区','ShangGanLingQu','0','179','1'),
('1537','五营区','WuYingQu','0','179','1'),
('1538','红星区','HongXingQu','0','179','1'),
('1539','新青区','XinQingQu','0','179','1'),
('1540','汤旺河区','TangWangHeQu','0','179','1'),
('1541','乌伊岭区','WuYiLingQu','0','179','1'),
('1542','铁力市','TieLiShi','0','179','1'),
('1543','嘉荫县','JiaYinXian','0','179','1'),
('1544','江岸区','JiangAnQu','0','180','1'),
('1545','武昌区','WuChangQu','0','180','1'),
('1546','江汉区','JiangHanQu','0','180','1'),
('1547','硚口区','KouQu','0','180','1'),
('1548','汉阳区','HanYangQu','0','180','1'),
('1549','青山区','QingShanQu','0','180','1'),
('1550','洪山区','HongShanQu','0','180','1'),
('1551','东西湖区','DongXiHuQu','0','180','1'),
('1552','汉南区','HanNanQu','0','180','1'),
('1553','蔡甸区','CaiDianQu','0','180','1'),
('1554','江夏区','JiangXiaQu','0','180','1'),
('1555','黄陂区','HuangQu','0','180','1'),
('1556','新洲区','XinZhouQu','0','180','1'),
('1557','经济开发区','JingJiKaiFaQu','0','180','1'),
('1558','仙桃市','XianTaoShi','0','181','1'),
('1559','鄂城区','EChengQu','0','182','1'),
('1560','华容区','HuaRongQu','0','182','1'),
('1561','梁子湖区','LiangZiHuQu','0','182','1'),
('1562','黄州区','HuangZhouQu','0','183','1'),
('1563','麻城市','MaChengShi','0','183','1'),
('1564','武穴市','WuXueShi','0','183','1'),
('1565','团风县','TuanFengXian','0','183','1'),
('1566','红安县','HongAnXian','0','183','1'),
('1567','罗田县','LuoTianXian','0','183','1'),
('1568','英山县','YingShanXian','0','183','1'),
('1569','浠水县','ShuiXian','0','183','1'),
('1570','蕲春县','ChunXian','0','183','1'),
('1571','黄梅县','HuangMeiXian','0','183','1'),
('1572','黄石港区','HuangShiGangQu','0','184','1'),
('1573','西塞山区','XiSaiShanQu','0','184','1'),
('1574','下陆区','XiaLuQu','0','184','1'),
('1575','铁山区','TieShanQu','0','184','1'),
('1576','大冶市','DaYeShi','0','184','1'),
('1577','阳新县','YangXinXian','0','184','1'),
('1578','东宝区','DongBaoQu','0','185','1'),
('1579','掇刀区','DuoDaoQu','0','185','1'),
('1580','钟祥市','ZhongXiangShi','0','185','1'),
('1581','京山县','JingShanXian','0','185','1'),
('1582','沙洋县','ShaYangXian','0','185','1'),
('1583','沙市区','ShaShiQu','0','186','1'),
('1584','荆州区','JingZhouQu','0','186','1'),
('1585','石首市','ShiShouShi','0','186','1'),
('1586','洪湖市','HongHuShi','0','186','1'),
('1587','松滋市','SongZiShi','0','186','1'),
('1588','公安县','GongAnXian','0','186','1'),
('1589','监利县','JianLiXian','0','186','1'),
('1590','江陵县','JiangLingXian','0','186','1'),
('1591','潜江市','QianJiangShi','0','187','1'),
('1592','神农架林区','ShenNongJiaLinQu','0','188','1'),
('1593','张湾区','ZhangWanQu','0','189','1'),
('1594','茅箭区','MaoJianQu','0','189','1'),
('1595','丹江口市','DanJiangKouShi','0','189','1'),
('1596','郧县','YunXian','0','189','1'),
('1597','郧西县','YunXiXian','0','189','1'),
('1598','竹山县','ZhuShanXian','0','189','1'),
('1599','竹溪县','ZhuXiXian','0','189','1'),
('1600','房县','FangXian','0','189','1'),
('1601','曾都区','ZengDuQu','0','190','1'),
('1602','广水市','GuangShuiShi','0','190','1'),
('1603','天门市','TianMenShi','0','191','1'),
('1604','咸安区','XianAnQu','0','192','1'),
('1605','赤壁市','ChiBiShi','0','192','1'),
('1606','嘉鱼县','JiaYuXian','0','192','1'),
('1607','通城县','TongChengXian','0','192','1'),
('1608','崇阳县','ChongYangXian','0','192','1'),
('1609','通山县','TongShanXian','0','192','1'),
('1610','襄城区','XiangChengQu','0','193','1'),
('1611','樊城区','FanChengQu','0','193','1'),
('1612','襄阳区','XiangYangQu','0','193','1'),
('1613','老河口市','LaoHeKouShi','0','193','1'),
('1614','枣阳市','ZaoYangShi','0','193','1'),
('1615','宜城市','YiChengShi','0','193','1'),
('1616','南漳县','NanZhangXian','0','193','1'),
('1617','谷城县','GuChengXian','0','193','1'),
('1618','保康县','BaoKangXian','0','193','1'),
('1619','孝南区','XiaoNanQu','0','194','1'),
('1620','应城市','YingChengShi','0','194','1'),
('1621','安陆市','AnLuShi','0','194','1'),
('1622','汉川市','HanChuanShi','0','194','1'),
('1623','孝昌县','XiaoChangXian','0','194','1'),
('1624','大悟县','DaWuXian','0','194','1'),
('1625','云梦县','YunMengXian','0','194','1'),
('1626','长阳','ChangYang','0','195','1'),
('1627','五峰','WuFeng','0','195','1'),
('1628','西陵区','XiLingQu','0','195','1'),
('1629','伍家岗区','WuJiaGangQu','0','195','1'),
('1630','点军区','DianJunQu','0','195','1'),
('1631','猇亭区','TingQu','0','195','1'),
('1632','夷陵区','YiLingQu','0','195','1'),
('1633','宜都市','YiDuShi','0','195','1'),
('1634','当阳市','DangYangShi','0','195','1'),
('1635','枝江市','ZhiJiangShi','0','195','1'),
('1636','远安县','YuanAnXian','0','195','1'),
('1637','兴山县','XingShanXian','0','195','1'),
('1638','秭归县','GuiXian','0','195','1'),
('1639','恩施市','EnShiShi','0','196','1'),
('1640','利川市','LiChuanShi','0','196','1'),
('1641','建始县','JianShiXian','0','196','1'),
('1642','巴东县','BaDongXian','0','196','1'),
('1643','宣恩县','XuanEnXian','0','196','1'),
('1644','咸丰县','XianFengXian','0','196','1'),
('1645','来凤县','LaiFengXian','0','196','1'),
('1646','鹤峰县','HeFengXian','0','196','1'),
('1647','岳麓区','YueLuQu','0','197','1'),
('1648','芙蓉区','RongQu','0','197','1'),
('1649','天心区','TianXinQu','0','197','1'),
('1650','开福区','KaiFuQu','0','197','1'),
('1651','雨花区','YuHuaQu','0','197','1'),
('1652','开发区','KaiFaQu','0','197','1'),
('1653','浏阳市','YangShi','0','197','1'),
('1654','长沙县','ChangShaXian','0','197','1'),
('1655','望城县','WangChengXian','0','197','1'),
('1656','宁乡县','NingXiangXian','0','197','1'),
('1657','永定区','YongDingQu','0','198','1'),
('1658','武陵源区','WuLingYuanQu','0','198','1'),
('1659','慈利县','CiLiXian','0','198','1'),
('1660','桑植县','SangZhiXian','0','198','1'),
('1661','武陵区','WuLingQu','0','199','1'),
('1662','鼎城区','DingChengQu','0','199','1'),
('1663','津市市','JinShiShi','0','199','1'),
('1664','安乡县','AnXiangXian','0','199','1'),
('1665','汉寿县','HanShouXian','0','199','1'),
('1666','澧县','Xian','0','199','1'),
('1667','临澧县','LinXian','0','199','1'),
('1668','桃源县','TaoYuanXian','0','199','1'),
('1669','石门县','ShiMenXian','0','199','1'),
('1670','北湖区','BeiHuQu','0','200','1'),
('1671','苏仙区','SuXianQu','0','200','1'),
('1672','资兴市','ZiXingShi','0','200','1'),
('1673','桂阳县','GuiYangXian','0','200','1'),
('1674','宜章县','YiZhangXian','0','200','1'),
('1675','永兴县','YongXingXian','0','200','1'),
('1676','嘉禾县','JiaHeXian','0','200','1'),
('1677','临武县','LinWuXian','0','200','1'),
('1678','汝城县','RuChengXian','0','200','1'),
('1679','桂东县','GuiDongXian','0','200','1'),
('1680','安仁县','AnRenXian','0','200','1'),
('1681','雁峰区','YanFengQu','0','201','1'),
('1682','珠晖区','ZhuQu','0','201','1'),
('1683','石鼓区','ShiGuQu','0','201','1'),
('1684','蒸湘区','ZhengXiangQu','0','201','1'),
('1685','南岳区','NanYueQu','0','201','1'),
('1686','耒阳市','YangShi','0','201','1'),
('1687','常宁市','ChangNingShi','0','201','1'),
('1688','衡阳县','HengYangXian','0','201','1'),
('1689','衡南县','HengNanXian','0','201','1'),
('1690','衡山县','HengShanXian','0','201','1'),
('1691','衡东县','HengDongXian','0','201','1'),
('1692','祁东县','QiDongXian','0','201','1'),
('1693','鹤城区','HeChengQu','0','202','1'),
('1694','靖州','JingZhou','0','202','1'),
('1695','麻阳','MaYang','0','202','1'),
('1696','通道','TongDao','0','202','1'),
('1697','新晃','XinHuang','0','202','1'),
('1698','芷江','Jiang','0','202','1'),
('1699','沅陵县','LingXian','0','202','1'),
('1700','辰溪县','ChenXiXian','0','202','1'),
('1701','溆浦县','PuXian','0','202','1'),
('1702','中方县','ZhongFangXian','0','202','1'),
('1703','会同县','HuiTongXian','0','202','1'),
('1704','洪江市','HongJiangShi','0','202','1'),
('1705','娄星区','LouXingQu','0','203','1'),
('1706','冷水江市','LengShuiJiangShi','0','203','1'),
('1707','涟源市','LianYuanShi','0','203','1'),
('1708','双峰县','ShuangFengXian','0','203','1'),
('1709','新化县','XinHuaXian','0','203','1'),
('1710','城步','ChengBu','0','204','1'),
('1711','双清区','ShuangQingQu','0','204','1'),
('1712','大祥区','DaXiangQu','0','204','1'),
('1713','北塔区','BeiTaQu','0','204','1'),
('1714','武冈市','WuGangShi','0','204','1'),
('1715','邵东县','ShaoDongXian','0','204','1'),
('1716','新邵县','XinShaoXian','0','204','1'),
('1717','邵阳县','ShaoYangXian','0','204','1'),
('1718','隆回县','LongHuiXian','0','204','1'),
('1719','洞口县','DongKouXian','0','204','1'),
('1720','绥宁县','SuiNingXian','0','204','1'),
('1721','新宁县','XinNingXian','0','204','1'),
('1722','岳塘区','YueTangQu','0','205','1'),
('1723','雨湖区','YuHuQu','0','205','1'),
('1724','湘乡市','XiangXiangShi','0','205','1'),
('1725','韶山市','ShaoShanShi','0','205','1'),
('1726','湘潭县','XiangTanXian','0','205','1'),
('1727','吉首市','JiShouShi','0','206','1'),
('1728','泸溪县','XiXian','0','206','1'),
('1729','凤凰县','FengHuangXian','0','206','1'),
('1730','花垣县','HuaYuanXian','0','206','1'),
('1731','保靖县','BaoJingXian','0','206','1'),
('1732','古丈县','GuZhangXian','0','206','1'),
('1733','永顺县','YongShunXian','0','206','1'),
('1734','龙山县','LongShanXian','0','206','1'),
('1735','赫山区','HeShanQu','0','207','1'),
('1736','资阳区','ZiYangQu','0','207','1'),
('1737','沅江市','JiangShi','0','207','1'),
('1738','南县','NanXian','0','207','1'),
('1739','桃江县','TaoJiangXian','0','207','1'),
('1740','安化县','AnHuaXian','0','207','1'),
('1741','江华','JiangHua','0','208','1'),
('1742','冷水滩区','LengShuiTanQu','0','208','1'),
('1743','零陵区','LingLingQu','0','208','1'),
('1744','祁阳县','QiYangXian','0','208','1'),
('1745','东安县','DongAnXian','0','208','1'),
('1746','双牌县','ShuangPaiXian','0','208','1'),
('1747','道县','DaoXian','0','208','1'),
('1748','江永县','JiangYongXian','0','208','1'),
('1749','宁远县','NingYuanXian','0','208','1'),
('1750','蓝山县','LanShanXian','0','208','1'),
('1751','新田县','XinTianXian','0','208','1'),
('1752','岳阳楼区','YueYangLouQu','0','209','1'),
('1753','君山区','JunShanQu','0','209','1'),
('1754','云溪区','YunXiQu','0','209','1'),
('1755','汨罗市','LuoShi','0','209','1'),
('1756','临湘市','LinXiangShi','0','209','1'),
('1757','岳阳县','YueYangXian','0','209','1'),
('1758','华容县','HuaRongXian','0','209','1'),
('1759','湘阴县','XiangYinXian','0','209','1'),
('1760','平江县','PingJiangXian','0','209','1'),
('1761','天元区','TianYuanQu','0','210','1'),
('1762','荷塘区','HeTangQu','0','210','1'),
('1763','芦淞区','LuQu','0','210','1'),
('1764','石峰区','ShiFengQu','0','210','1'),
('1765','醴陵市','LingShi','0','210','1'),
('1766','株洲县','ZhuZhouXian','0','210','1'),
('1767','攸县','Xian','0','210','1'),
('1768','茶陵县','ChaLingXian','0','210','1'),
('1769','炎陵县','YanLingXian','0','210','1'),
('1770','朝阳区','ChaoYangQu','0','211','1'),
('1771','宽城区','KuanChengQu','0','211','1'),
('1772','二道区','ErDaoQu','0','211','1'),
('1773','南关区','NanGuanQu','0','211','1'),
('1774','绿园区','LvYuanQu','0','211','1'),
('1775','双阳区','ShuangYangQu','0','211','1'),
('1776','净月潭开发区','JingYueTanKaiFaQu','0','211','1'),
('1777','高新技术开发区','GaoXinJiShuKaiFaQu','0','211','1'),
('1778','经济技术开发区','JingJiJiShuKaiFaQu','0','211','1'),
('1779','汽车产业开发区','QiCheChanYeKaiFaQu','0','211','1'),
('1780','德惠市','DeHuiShi','0','211','1'),
('1781','九台市','JiuTaiShi','0','211','1'),
('1782','榆树市','YuShuShi','0','211','1'),
('1783','农安县','NongAnXian','0','211','1'),
('1784','船营区','ChuanYingQu','0','212','1'),
('1785','昌邑区','ChangYiQu','0','212','1'),
('1786','龙潭区','LongTanQu','0','212','1'),
('1787','丰满区','FengManQu','0','212','1'),
('1788','蛟河市','HeShi','0','212','1'),
('1789','桦甸市','DianShi','0','212','1'),
('1790','舒兰市','ShuLanShi','0','212','1'),
('1791','磐石市','PanShiShi','0','212','1'),
('1792','永吉县','YongJiXian','0','212','1'),
('1793','洮北区','BeiQu','0','213','1'),
('1794','洮南市','NanShi','0','213','1'),
('1795','大安市','DaAnShi','0','213','1'),
('1796','镇赉县','ZhenXian','0','213','1'),
('1797','通榆县','TongYuXian','0','213','1'),
('1798','江源区','JiangYuanQu','0','214','1'),
('1799','八道江区','BaDaoJiangQu','0','214','1'),
('1800','长白','ChangBai','0','214','1'),
('1801','临江市','LinJiangShi','0','214','1'),
('1802','抚松县','FuSongXian','0','214','1'),
('1803','靖宇县','JingYuXian','0','214','1'),
('1804','龙山区','LongShanQu','0','215','1'),
('1805','西安区','XiAnQu','0','215','1'),
('1806','东丰县','DongFengXian','0','215','1'),
('1807','东辽县','DongLiaoXian','0','215','1'),
('1808','铁西区','TieXiQu','0','216','1'),
('1809','铁东区','TieDongQu','0','216','1'),
('1810','伊通','YiTong','0','216','1'),
('1811','公主岭市','GongZhuLingShi','0','216','1'),
('1812','双辽市','ShuangLiaoShi','0','216','1'),
('1813','梨树县','LiShuXian','0','216','1'),
('1814','前郭尔罗斯','QianGuoErLuoSi','0','217','1'),
('1815','宁江区','NingJiangQu','0','217','1'),
('1816','长岭县','ChangLingXian','0','217','1'),
('1817','乾安县','QianAnXian','0','217','1'),
('1818','扶余县','FuYuXian','0','217','1'),
('1819','东昌区','DongChangQu','0','218','1'),
('1820','二道江区','ErDaoJiangQu','0','218','1'),
('1821','梅河口市','MeiHeKouShi','0','218','1'),
('1822','集安市','JiAnShi','0','218','1'),
('1823','通化县','TongHuaXian','0','218','1'),
('1824','辉南县','HuiNanXian','0','218','1'),
('1825','柳河县','LiuHeXian','0','218','1'),
('1826','延吉市','YanJiShi','0','219','1'),
('1827','图们市','TuMenShi','0','219','1'),
('1828','敦化市','DunHuaShi','0','219','1'),
('1829','珲春市','ChunShi','0','219','1'),
('1830','龙井市','LongJingShi','0','219','1'),
('1831','和龙市','HeLongShi','0','219','1'),
('1832','安图县','AnTuXian','0','219','1'),
('1833','汪清县','WangQingXian','0','219','1'),
('1834','玄武区','XuanWuQu','0','220','1'),
('1835','鼓楼区','GuLouQu','0','220','1'),
('1836','白下区','BaiXiaQu','0','220','1'),
('1837','建邺区','JianQu','0','220','1'),
('1838','秦淮区','QinHuaiQu','0','220','1'),
('1839','雨花台区','YuHuaTaiQu','0','220','1'),
('1840','下关区','XiaGuanQu','0','220','1'),
('1841','栖霞区','QiXiaQu','0','220','1'),
('1842','浦口区','PuKouQu','0','220','1'),
('1843','江宁区','JiangNingQu','0','220','1'),
('1844','六合区','LiuHeQu','0','220','1'),
('1845','溧水县','ShuiXian','0','220','1'),
('1846','高淳县','GaoChunXian','0','220','1'),
('1847','沧浪区','CangLangQu','0','221','1'),
('1848','金阊区','JinQu','0','221','1'),
('1849','平江区','PingJiangQu','0','221','1'),
('1850','虎丘区','HuQiuQu','0','221','1'),
('1851','吴中区','WuZhongQu','0','221','1'),
('1852','相城区','XiangChengQu','0','221','1'),
('1853','园区','YuanQu','0','221','1'),
('1854','新区','XinQu','0','221','1'),
('1855','常熟市','ChangShuShi','0','221','1'),
('1856','张家港市','ZhangJiaGangShi','0','221','1'),
('1857','玉山镇','YuShanZhen','0','221','1'),
('1858','巴城镇','BaChengZhen','0','221','1'),
('1859','周市镇','ZhouShiZhen','0','221','1'),
('1860','陆家镇','LuJiaZhen','0','221','1'),
('1861','花桥镇','HuaQiaoZhen','0','221','1'),
('1862','淀山湖镇','DianShanHuZhen','0','221','1'),
('1863','张浦镇','ZhangPuZhen','0','221','1'),
('1864','周庄镇','ZhouZhuangZhen','0','221','1'),
('1865','千灯镇','QianDengZhen','0','221','1'),
('1866','锦溪镇','JinXiZhen','0','221','1'),
('1867','开发区','KaiFaQu','0','221','1'),
('1868','吴江市','WuJiangShi','0','221','1'),
('1869','太仓市','TaiCangShi','0','221','1'),
('1870','崇安区','ChongAnQu','0','222','1'),
('1871','北塘区','BeiTangQu','0','222','1'),
('1872','南长区','NanChangQu','0','222','1'),
('1873','锡山区','XiShanQu','0','222','1'),
('1874','惠山区','HuiShanQu','0','222','1'),
('1875','滨湖区','BinHuQu','0','222','1'),
('1876','新区','XinQu','0','222','1'),
('1877','江阴市','JiangYinShi','0','222','1'),
('1878','宜兴市','YiXingShi','0','222','1'),
('1879','天宁区','TianNingQu','0','223','1'),
('1880','钟楼区','ZhongLouQu','0','223','1'),
('1881','戚墅堰区','QiShuYanQu','0','223','1'),
('1882','郊区','JiaoQu','0','223','1'),
('1883','新北区','XinBeiQu','0','223','1'),
('1884','武进区','WuJinQu','0','223','1'),
('1885','溧阳市','YangShi','0','223','1'),
('1886','金坛市','JinTanShi','0','223','1'),
('1887','清河区','QingHeQu','0','224','1'),
('1888','清浦区','QingPuQu','0','224','1'),
('1889','楚州区','ChuZhouQu','0','224','1'),
('1890','淮阴区','HuaiYinQu','0','224','1'),
('1891','涟水县','LianShuiXian','0','224','1'),
('1892','洪泽县','HongZeXian','0','224','1'),
('1893','盱眙县','Xian','0','224','1'),
('1894','金湖县','JinHuXian','0','224','1'),
('1895','新浦区','XinPuQu','0','225','1'),
('1896','连云区','LianYunQu','0','225','1'),
('1897','海州区','HaiZhouQu','0','225','1'),
('1898','赣榆县','GanYuXian','0','225','1'),
('1899','东海县','DongHaiXian','0','225','1'),
('1900','灌云县','GuanYunXian','0','225','1'),
('1901','灌南县','GuanNanXian','0','225','1'),
('1902','崇川区','ChongChuanQu','0','226','1'),
('1903','港闸区','GangZhaQu','0','226','1'),
('1904','经济开发区','JingJiKaiFaQu','0','226','1'),
('1905','启东市','QiDongShi','0','226','1'),
('1906','如皋市','RuGaoShi','0','226','1'),
('1907','通州市','TongZhouShi','0','226','1'),
('1908','海门市','HaiMenShi','0','226','1'),
('1909','海安县','HaiAnXian','0','226','1'),
('1910','如东县','RuDongXian','0','226','1'),
('1911','宿城区','SuChengQu','0','227','1'),
('1912','宿豫区','SuYuQu','0','227','1'),
('1913','宿豫县','SuYuXian','0','227','1'),
('1914','沭阳县','YangXian','0','227','1'),
('1915','泗阳县','YangXian','0','227','1'),
('1916','泗洪县','HongXian','0','227','1'),
('1917','海陵区','HaiLingQu','0','228','1'),
('1918','高港区','GaoGangQu','0','228','1'),
('1919','兴化市','XingHuaShi','0','228','1'),
('1920','靖江市','JingJiangShi','0','228','1'),
('1921','泰兴市','TaiXingShi','0','228','1'),
('1922','姜堰市','JiangYanShi','0','228','1'),
('1923','云龙区','YunLongQu','0','229','1'),
('1924','鼓楼区','GuLouQu','0','229','1'),
('1925','九里区','JiuLiQu','0','229','1'),
('1926','贾汪区','JiaWangQu','0','229','1'),
('1927','泉山区','QuanShanQu','0','229','1'),
('1928','新沂市','XinYiShi','0','229','1'),
('1929','邳州市','ZhouShi','0','229','1'),
('1930','丰县','FengXian','0','229','1'),
('1931','沛县','PeiXian','0','229','1'),
('1932','铜山县','TongShanXian','0','229','1'),
('1933','睢宁县','NingXian','0','229','1'),
('1934','城区','ChengQu','0','230','1'),
('1935','亭湖区','TingHuQu','0','230','1'),
('1936','盐都区','YanDuQu','0','230','1'),
('1937','盐都县','YanDuXian','0','230','1'),
('1938','东台市','DongTaiShi','0','230','1'),
('1939','大丰市','DaFengShi','0','230','1'),
('1940','响水县','XiangShuiXian','0','230','1'),
('1941','滨海县','BinHaiXian','0','230','1'),
('1942','阜宁县','FuNingXian','0','230','1'),
('1943','射阳县','SheYangXian','0','230','1'),
('1944','建湖县','JianHuXian','0','230','1'),
('1945','广陵区','GuangLingQu','0','231','1'),
('1946','维扬区','WeiYangQu','0','231','1'),
('1947','邗江区','JiangQu','0','231','1'),
('1948','仪征市','YiZhengShi','0','231','1'),
('1949','高邮市','GaoYouShi','0','231','1'),
('1950','江都市','JiangDuShi','0','231','1'),
('1951','宝应县','BaoYingXian','0','231','1'),
('1952','京口区','JingKouQu','0','232','1'),
('1953','润州区','RunZhouQu','0','232','1'),
('1954','丹徒区','DanTuQu','0','232','1'),
('1955','丹阳市','DanYangShi','0','232','1'),
('1956','扬中市','YangZhongShi','0','232','1'),
('1957','句容市','JuRongShi','0','232','1'),
('1958','东湖区','DongHuQu','0','233','1'),
('1959','西湖区','XiHuQu','0','233','1'),
('1960','青云谱区','QingYunPuQu','0','233','1'),
('1961','湾里区','WanLiQu','0','233','1'),
('1962','青山湖区','QingShanHuQu','0','233','1'),
('1963','红谷滩新区','HongGuTanXinQu','0','233','1'),
('1964','昌北区','ChangBeiQu','0','233','1'),
('1965','高新区','GaoXinQu','0','233','1'),
('1966','南昌县','NanChangXian','0','233','1'),
('1967','新建县','XinJianXian','0','233','1'),
('1968','安义县','AnYiXian','0','233','1'),
('1969','进贤县','JinXianXian','0','233','1'),
('1970','临川区','LinChuanQu','0','234','1'),
('1971','南城县','NanChengXian','0','234','1'),
('1972','黎川县','LiChuanXian','0','234','1'),
('1973','南丰县','NanFengXian','0','234','1'),
('1974','崇仁县','ChongRenXian','0','234','1'),
('1975','乐安县','LeAnXian','0','234','1'),
('1976','宜黄县','YiHuangXian','0','234','1'),
('1977','金溪县','JinXiXian','0','234','1'),
('1978','资溪县','ZiXiXian','0','234','1'),
('1979','东乡县','DongXiangXian','0','234','1'),
('1980','广昌县','GuangChangXian','0','234','1'),
('1981','章贡区','ZhangGongQu','0','235','1'),
('1982','于都县','YuDuXian','0','235','1'),
('1983','瑞金市','RuiJinShi','0','235','1'),
('1984','南康市','NanKangShi','0','235','1'),
('1985','赣县','GanXian','0','235','1'),
('1986','信丰县','XinFengXian','0','235','1'),
('1987','大余县','DaYuXian','0','235','1'),
('1988','上犹县','ShangYouXian','0','235','1'),
('1989','崇义县','ChongYiXian','0','235','1'),
('1990','安远县','AnYuanXian','0','235','1'),
('1991','龙南县','LongNanXian','0','235','1'),
('1992','定南县','DingNanXian','0','235','1'),
('1993','全南县','QuanNanXian','0','235','1'),
('1994','宁都县','NingDuXian','0','235','1'),
('1995','兴国县','XingGuoXian','0','235','1'),
('1996','会昌县','HuiChangXian','0','235','1'),
('1997','寻乌县','XunWuXian','0','235','1'),
('1998','石城县','ShiChengXian','0','235','1'),
('1999','安福县','AnFuXian','0','236','1'),
('2000','吉州区','JiZhouQu','0','236','1'),
('2001','青原区','QingYuanQu','0','236','1'),
('2002','井冈山市','JingGangShanShi','0','236','1'),
('2003','吉安县','JiAnXian','0','236','1'),
('2004','吉水县','JiShuiXian','0','236','1'),
('2005','峡江县','XiaJiangXian','0','236','1'),
('2006','新干县','XinGanXian','0','236','1'),
('2007','永丰县','YongFengXian','0','236','1'),
('2008','泰和县','TaiHeXian','0','236','1'),
('2009','遂川县','SuiChuanXian','0','236','1'),
('2010','万安县','WanAnXian','0','236','1'),
('2011','永新县','YongXinXian','0','236','1'),
('2012','珠山区','ZhuShanQu','0','237','1'),
('2013','昌江区','ChangJiangQu','0','237','1'),
('2014','乐平市','LePingShi','0','237','1'),
('2015','浮梁县','FuLiangXian','0','237','1'),
('2016','浔阳区','YangQu','0','238','1'),
('2017','庐山区','LuShanQu','0','238','1'),
('2018','瑞昌市','RuiChangShi','0','238','1'),
('2019','九江县','JiuJiangXian','0','238','1'),
('2020','武宁县','WuNingXian','0','238','1'),
('2021','修水县','XiuShuiXian','0','238','1'),
('2022','永修县','YongXiuXian','0','238','1'),
('2023','德安县','DeAnXian','0','238','1'),
('2024','星子县','XingZiXian','0','238','1'),
('2025','都昌县','DuChangXian','0','238','1'),
('2026','湖口县','HuKouXian','0','238','1'),
('2027','彭泽县','PengZeXian','0','238','1'),
('2028','安源区','AnYuanQu','0','239','1'),
('2029','湘东区','XiangDongQu','0','239','1'),
('2030','莲花县','LianHuaXian','0','239','1'),
('2031','芦溪县','LuXiXian','0','239','1'),
('2032','上栗县','ShangLiXian','0','239','1'),
('2033','信州区','XinZhouQu','0','240','1'),
('2034','德兴市','DeXingShi','0','240','1'),
('2035','上饶县','ShangRaoXian','0','240','1'),
('2036','广丰县','GuangFengXian','0','240','1'),
('2037','玉山县','YuShanXian','0','240','1'),
('2038','铅山县','QianShanXian','0','240','1'),
('2039','横峰县','HengFengXian','0','240','1'),
('2040','弋阳县','YangXian','0','240','1'),
('2041','余干县','YuGanXian','0','240','1'),
('2042','波阳县','BoYangXian','0','240','1'),
('2043','万年县','WanNianXian','0','240','1'),
('2044','婺源县','YuanXian','0','240','1'),
('2045','渝水区','YuShuiQu','0','241','1'),
('2046','分宜县','FenYiXian','0','241','1'),
('2047','袁州区','YuanZhouQu','0','242','1'),
('2048','丰城市','FengChengShi','0','242','1'),
('2049','樟树市','ZhangShuShi','0','242','1'),
('2050','高安市','GaoAnShi','0','242','1'),
('2051','奉新县','FengXinXian','0','242','1'),
('2052','万载县','WanZaiXian','0','242','1'),
('2053','上高县','ShangGaoXian','0','242','1'),
('2054','宜丰县','YiFengXian','0','242','1'),
('2055','靖安县','JingAnXian','0','242','1'),
('2056','铜鼓县','TongGuXian','0','242','1'),
('2057','月湖区','YueHuQu','0','243','1'),
('2058','贵溪市','GuiXiShi','0','243','1'),
('2059','余江县','YuJiangXian','0','243','1'),
('2060','沈河区','ShenHeQu','0','244','1'),
('2061','皇姑区','HuangGuQu','0','244','1'),
('2062','和平区','HePingQu','0','244','1'),
('2063','大东区','DaDongQu','0','244','1'),
('2064','铁西区','TieXiQu','0','244','1'),
('2065','苏家屯区','SuJiaTunQu','0','244','1'),
('2066','东陵区','DongLingQu','0','244','1'),
('2067','沈北新区','ShenBeiXinQu','0','244','1'),
('2068','于洪区','YuHongQu','0','244','1'),
('2069','浑南新区','HunNanXinQu','0','244','1'),
('2070','新民市','XinMinShi','0','244','1'),
('2071','辽中县','LiaoZhongXian','0','244','1'),
('2072','康平县','KangPingXian','0','244','1'),
('2073','法库县','FaKuXian','0','244','1'),
('2074','西岗区','XiGangQu','0','245','1'),
('2075','中山区','ZhongShanQu','0','245','1'),
('2076','沙河口区','ShaHeKouQu','0','245','1'),
('2077','甘井子区','GanJingZiQu','0','245','1'),
('2078','旅顺口区','LvShunKouQu','0','245','1'),
('2079','金州区','JinZhouQu','0','245','1'),
('2080','开发区','KaiFaQu','0','245','1'),
('2081','瓦房店市','WaFangDianShi','0','245','1'),
('2082','普兰店市','PuLanDianShi','0','245','1'),
('2083','庄河市','ZhuangHeShi','0','245','1'),
('2084','长海县','ChangHaiXian','0','245','1'),
('2085','铁东区','TieDongQu','0','246','1'),
('2086','铁西区','TieXiQu','0','246','1'),
('2087','立山区','LiShanQu','0','246','1'),
('2088','千山区','QianShanQu','0','246','1'),
('2089','岫岩','Yan','0','246','1'),
('2090','海城市','HaiChengShi','0','246','1'),
('2091','台安县','TaiAnXian','0','246','1'),
('2092','本溪','BenXi','0','247','1'),
('2093','平山区','PingShanQu','0','247','1'),
('2094','明山区','MingShanQu','0','247','1'),
('2095','溪湖区','XiHuQu','0','247','1'),
('2096','南芬区','NanFenQu','0','247','1'),
('2097','桓仁','HuanRen','0','247','1'),
('2098','双塔区','ShuangTaQu','0','248','1'),
('2099','龙城区','LongChengQu','0','248','1'),
('2100','喀喇沁左翼蒙古族自治县','KaLaQinZuoYiMengGuZuZiZhiXian','0','248','1'),
('2101','北票市','BeiPiaoShi','0','248','1'),
('2102','凌源市','LingYuanShi','0','248','1'),
('2103','朝阳县','ChaoYangXian','0','248','1'),
('2104','建平县','JianPingXian','0','248','1'),
('2105','振兴区','ZhenXingQu','0','249','1'),
('2106','元宝区','YuanBaoQu','0','249','1'),
('2107','振安区','ZhenAnQu','0','249','1'),
('2108','宽甸','KuanDian','0','249','1'),
('2109','东港市','DongGangShi','0','249','1'),
('2110','凤城市','FengChengShi','0','249','1'),
('2111','顺城区','ShunChengQu','0','250','1'),
('2112','新抚区','XinFuQu','0','250','1'),
('2113','东洲区','DongZhouQu','0','250','1'),
('2114','望花区','WangHuaQu','0','250','1'),
('2115','清原','QingYuan','0','250','1'),
('2116','新宾','XinBin','0','250','1'),
('2117','抚顺县','FuShunXian','0','250','1'),
('2118','阜新','FuXin','0','251','1'),
('2119','海州区','HaiZhouQu','0','251','1'),
('2120','新邱区','XinQiuQu','0','251','1'),
('2121','太平区','TaiPingQu','0','251','1'),
('2122','清河门区','QingHeMenQu','0','251','1'),
('2123','细河区','XiHeQu','0','251','1'),
('2124','彰武县','ZhangWuXian','0','251','1'),
('2125','龙港区','LongGangQu','0','252','1'),
('2126','南票区','NanPiaoQu','0','252','1'),
('2127','连山区','LianShanQu','0','252','1'),
('2128','兴城市','XingChengShi','0','252','1'),
('2129','绥中县','SuiZhongXian','0','252','1'),
('2130','建昌县','JianChangXian','0','252','1'),
('2131','太和区','TaiHeQu','0','253','1'),
('2132','古塔区','GuTaQu','0','253','1'),
('2133','凌河区','LingHeQu','0','253','1'),
('2134','凌海市','LingHaiShi','0','253','1'),
('2135','北镇市','BeiZhenShi','0','253','1'),
('2136','黑山县','HeiShanXian','0','253','1'),
('2137','义县','YiXian','0','253','1'),
('2138','白塔区','BaiTaQu','0','254','1'),
('2139','文圣区','WenShengQu','0','254','1'),
('2140','宏伟区','HongWeiQu','0','254','1'),
('2141','太子河区','TaiZiHeQu','0','254','1'),
('2142','弓长岭区','GongChangLingQu','0','254','1'),
('2143','灯塔市','DengTaShi','0','254','1'),
('2144','辽阳县','LiaoYangXian','0','254','1'),
('2145','双台子区','ShuangTaiZiQu','0','255','1'),
('2146','兴隆台区','XingLongTaiQu','0','255','1'),
('2147','大洼县','DaWaXian','0','255','1'),
('2148','盘山县','PanShanXian','0','255','1'),
('2149','银州区','YinZhouQu','0','256','1'),
('2150','清河区','QingHeQu','0','256','1'),
('2151','调兵山市','DiaoBingShanShi','0','256','1'),
('2152','开原市','KaiYuanShi','0','256','1'),
('2153','铁岭县','TieLingXian','0','256','1'),
('2154','西丰县','XiFengXian','0','256','1'),
('2155','昌图县','ChangTuXian','0','256','1'),
('2156','站前区','ZhanQianQu','0','257','1'),
('2157','西市区','XiShiQu','0','257','1'),
('2158','鲅鱼圈区','YuQuanQu','0','257','1'),
('2159','老边区','LaoBianQu','0','257','1'),
('2160','盖州市','GaiZhouShi','0','257','1'),
('2161','大石桥市','DaShiQiaoShi','0','257','1'),
('2162','回民区','HuiMinQu','0','258','1'),
('2163','玉泉区','YuQuanQu','0','258','1'),
('2164','新城区','XinChengQu','0','258','1'),
('2165','赛罕区','SaiHanQu','0','258','1'),
('2166','清水河县','QingShuiHeXian','0','258','1'),
('2167','土默特左旗','TuMoTeZuoQi','0','258','1'),
('2168','托克托县','TuoKeTuoXian','0','258','1'),
('2169','和林格尔县','HeLinGeErXian','0','258','1'),
('2170','武川县','WuChuanXian','0','258','1'),
('2171','阿拉善左旗','ALaShanZuoQi','0','259','1'),
('2172','阿拉善右旗','ALaShanYouQi','0','259','1'),
('2173','额济纳旗','EJiNaQi','0','259','1'),
('2174','临河区','LinHeQu','0','260','1'),
('2175','五原县','WuYuanXian','0','260','1'),
('2176','磴口县','KouXian','0','260','1'),
('2177','乌拉特前旗','WuLaTeQianQi','0','260','1'),
('2178','乌拉特中旗','WuLaTeZhongQi','0','260','1'),
('2179','乌拉特后旗','WuLaTeHouQi','0','260','1'),
('2180','杭锦后旗','HangJinHouQi','0','260','1'),
('2181','昆都仑区','KunDuLunQu','0','261','1'),
('2182','青山区','QingShanQu','0','261','1'),
('2183','东河区','DongHeQu','0','261','1'),
('2184','九原区','JiuYuanQu','0','261','1'),
('2185','石拐区','ShiGuaiQu','0','261','1'),
('2186','白云矿区','BaiYunKuangQu','0','261','1'),
('2187','土默特右旗','TuMoTeYouQi','0','261','1'),
('2188','固阳县','GuYangXian','0','261','1'),
('2189','达尔罕茂明安联合旗','DaErHanMaoMingAnLianHeQi','0','261','1'),
('2190','红山区','HongShanQu','0','262','1'),
('2191','元宝山区','YuanBaoShanQu','0','262','1'),
('2192','松山区','SongShanQu','0','262','1'),
('2193','阿鲁科尔沁旗','ALuKeErQinQi','0','262','1'),
('2194','巴林左旗','BaLinZuoQi','0','262','1'),
('2195','巴林右旗','BaLinYouQi','0','262','1'),
('2196','林西县','LinXiXian','0','262','1'),
('2197','克什克腾旗','KeShiKeTengQi','0','262','1'),
('2198','翁牛特旗','WengNiuTeQi','0','262','1'),
('2199','喀喇沁旗','KaLaQinQi','0','262','1'),
('2200','宁城县','NingChengXian','0','262','1'),
('2201','敖汉旗','AoHanQi','0','262','1'),
('2202','东胜区','DongShengQu','0','263','1'),
('2203','达拉特旗','DaLaTeQi','0','263','1'),
('2204','准格尔旗','ZhunGeErQi','0','263','1'),
('2205','鄂托克前旗','ETuoKeQianQi','0','263','1'),
('2206','鄂托克旗','ETuoKeQi','0','263','1'),
('2207','杭锦旗','HangJinQi','0','263','1'),
('2208','乌审旗','WuShenQi','0','263','1'),
('2209','伊金霍洛旗','YiJinHuoLuoQi','0','263','1'),
('2210','海拉尔区','HaiLaErQu','0','264','1'),
('2211','莫力达瓦','MoLiDaWa','0','264','1'),
('2212','满洲里市','ManZhouLiShi','0','264','1'),
('2213','牙克石市','YaKeShiShi','0','264','1'),
('2214','扎兰屯市','ZhaLanTunShi','0','264','1'),
('2215','额尔古纳市','EErGuNaShi','0','264','1'),
('2216','根河市','GenHeShi','0','264','1'),
('2217','阿荣旗','ARongQi','0','264','1'),
('2218','鄂伦春自治旗','ELunChunZiZhiQi','0','264','1'),
('2219','鄂温克族自治旗','EWenKeZuZiZhiQi','0','264','1'),
('2220','陈巴尔虎旗','ChenBaErHuQi','0','264','1'),
('2221','新巴尔虎左旗','XinBaErHuZuoQi','0','264','1'),
('2222','新巴尔虎右旗','XinBaErHuYouQi','0','264','1'),
('2223','科尔沁区','KeErQinQu','0','265','1'),
('2224','霍林郭勒市','HuoLinGuoLeShi','0','265','1'),
('2225','科尔沁左翼中旗','KeErQinZuoYiZhongQi','0','265','1'),
('2226','科尔沁左翼后旗','KeErQinZuoYiHouQi','0','265','1'),
('2227','开鲁县','KaiLuXian','0','265','1'),
('2228','库伦旗','KuLunQi','0','265','1'),
('2229','奈曼旗','NaiManQi','0','265','1'),
('2230','扎鲁特旗','ZhaLuTeQi','0','265','1'),
('2231','海勃湾区','HaiBoWanQu','0','266','1'),
('2232','乌达区','WuDaQu','0','266','1'),
('2233','海南区','HaiNanQu','0','266','1'),
('2234','化德县','HuaDeXian','0','267','1'),
('2235','集宁区','JiNingQu','0','267','1'),
('2236','丰镇市','FengZhenShi','0','267','1'),
('2237','卓资县','ZhuoZiXian','0','267','1'),
('2238','商都县','ShangDuXian','0','267','1'),
('2239','兴和县','XingHeXian','0','267','1'),
('2240','凉城县','LiangChengXian','0','267','1'),
('2241','察哈尔右翼前旗','ChaHaErYouYiQianQi','0','267','1'),
('2242','察哈尔右翼中旗','ChaHaErYouYiZhongQi','0','267','1'),
('2243','察哈尔右翼后旗','ChaHaErYouYiHouQi','0','267','1'),
('2244','四子王旗','SiZiWangQi','0','267','1'),
('2245','二连浩特市','ErLianHaoTeShi','0','268','1'),
('2246','锡林浩特市','XiLinHaoTeShi','0','268','1'),
('2247','阿巴嘎旗','ABaGaQi','0','268','1'),
('2248','苏尼特左旗','SuNiTeZuoQi','0','268','1'),
('2249','苏尼特右旗','SuNiTeYouQi','0','268','1'),
('2250','东乌珠穆沁旗','DongWuZhuMuQinQi','0','268','1'),
('2251','西乌珠穆沁旗','XiWuZhuMuQinQi','0','268','1'),
('2252','太仆寺旗','TaiPuSiQi','0','268','1'),
('2253','镶黄旗','XiangHuangQi','0','268','1'),
('2254','正镶白旗','ZhengXiangBaiQi','0','268','1'),
('2255','正蓝旗','ZhengLanQi','0','268','1'),
('2256','多伦县','DuoLunXian','0','268','1'),
('2257','乌兰浩特市','WuLanHaoTeShi','0','269','1'),
('2258','阿尔山市','AErShanShi','0','269','1'),
('2259','科尔沁右翼前旗','KeErQinYouYiQianQi','0','269','1'),
('2260','科尔沁右翼中旗','KeErQinYouYiZhongQi','0','269','1'),
('2261','扎赉特旗','ZhaTeQi','0','269','1'),
('2262','突泉县','TuQuanXian','0','269','1'),
('2263','西夏区','XiXiaQu','0','270','1'),
('2264','金凤区','JinFengQu','0','270','1'),
('2265','兴庆区','XingQingQu','0','270','1'),
('2266','灵武市','LingWuShi','0','270','1'),
('2267','永宁县','YongNingXian','0','270','1'),
('2268','贺兰县','HeLanXian','0','270','1'),
('2269','原州区','YuanZhouQu','0','271','1'),
('2270','海原县','HaiYuanXian','0','271','1'),
('2271','西吉县','XiJiXian','0','271','1'),
('2272','隆德县','LongDeXian','0','271','1'),
('2273','泾源县','YuanXian','0','271','1'),
('2274','彭阳县','PengYangXian','0','271','1'),
('2275','惠农县','HuiNongXian','0','272','1'),
('2276','大武口区','DaWuKouQu','0','272','1'),
('2277','惠农区','HuiNongQu','0','272','1'),
('2278','陶乐县','TaoLeXian','0','272','1'),
('2279','平罗县','PingLuoXian','0','272','1'),
('2280','利通区','LiTongQu','0','273','1'),
('2281','中卫县','ZhongWeiXian','0','273','1'),
('2282','青铜峡市','QingTongXiaShi','0','273','1'),
('2283','中宁县','ZhongNingXian','0','273','1'),
('2284','盐池县','YanChiXian','0','273','1'),
('2285','同心县','TongXinXian','0','273','1'),
('2286','沙坡头区','ShaPoTouQu','0','274','1'),
('2287','海原县','HaiYuanXian','0','274','1'),
('2288','中宁县','ZhongNingXian','0','274','1'),
('2289','城中区','ChengZhongQu','0','275','1'),
('2290','城东区','ChengDongQu','0','275','1'),
('2291','城西区','ChengXiQu','0','275','1'),
('2292','城北区','ChengBeiQu','0','275','1'),
('2293','湟中县','ZhongXian','0','275','1'),
('2294','湟源县','YuanXian','0','275','1'),
('2295','大通','DaTong','0','275','1'),
('2296','玛沁县','MaQinXian','0','276','1'),
('2297','班玛县','BanMaXian','0','276','1'),
('2298','甘德县','GanDeXian','0','276','1'),
('2299','达日县','DaRiXian','0','276','1'),
('2300','久治县','JiuZhiXian','0','276','1'),
('2301','玛多县','MaDuoXian','0','276','1'),
('2302','海晏县','HaiXian','0','277','1'),
('2303','祁连县','QiLianXian','0','277','1'),
('2304','刚察县','GangChaXian','0','277','1'),
('2305','门源','MenYuan','0','277','1'),
('2306','平安县','PingAnXian','0','278','1'),
('2307','乐都县','LeDuXian','0','278','1'),
('2308','民和','MinHe','0','278','1'),
('2309','互助','HuZhu','0','278','1'),
('2310','化隆','HuaLong','0','278','1'),
('2311','循化','XunHua','0','278','1'),
('2312','共和县','GongHeXian','0','279','1'),
('2313','同德县','TongDeXian','0','279','1'),
('2314','贵德县','GuiDeXian','0','279','1'),
('2315','兴海县','XingHaiXian','0','279','1'),
('2316','贵南县','GuiNanXian','0','279','1'),
('2317','德令哈市','DeLingHaShi','0','280','1'),
('2318','格尔木市','GeErMuShi','0','280','1'),
('2319','乌兰县','WuLanXian','0','280','1'),
('2320','都兰县','DuLanXian','0','280','1'),
('2321','天峻县','TianJunXian','0','280','1'),
('2322','同仁县','TongRenXian','0','281','1'),
('2323','尖扎县','JianZhaXian','0','281','1'),
('2324','泽库县','ZeKuXian','0','281','1'),
('2325','河南蒙古族自治县','HeNanMengGuZuZiZhiXian','0','281','1'),
('2326','玉树县','YuShuXian','0','282','1'),
('2327','杂多县','ZaDuoXian','0','282','1'),
('2328','称多县','ChengDuoXian','0','282','1'),
('2329','治多县','ZhiDuoXian','0','282','1'),
('2330','囊谦县','NangQianXian','0','282','1'),
('2331','曲麻莱县','QuMaLaiXian','0','282','1'),
('2332','市中区','ShiZhongQu','0','283','1'),
('2333','历下区','LiXiaQu','0','283','1'),
('2334','天桥区','TianQiaoQu','0','283','1'),
('2335','槐荫区','HuaiYinQu','0','283','1'),
('2336','历城区','LiChengQu','0','283','1'),
('2337','长清区','ChangQingQu','0','283','1'),
('2338','章丘市','ZhangQiuShi','0','283','1'),
('2339','平阴县','PingYinXian','0','283','1'),
('2340','济阳县','JiYangXian','0','283','1'),
('2341','商河县','ShangHeXian','0','283','1'),
('2342','市南区','ShiNanQu','0','284','1'),
('2343','市北区','ShiBeiQu','0','284','1'),
('2344','城阳区','ChengYangQu','0','284','1'),
('2345','四方区','SiFangQu','0','284','1'),
('2346','李沧区','LiCangQu','0','284','1'),
('2347','黄岛区','HuangDaoQu','0','284','1'),
('2348','崂山区','ShanQu','0','284','1'),
('2349','胶州市','JiaoZhouShi','0','284','1'),
('2350','即墨市','JiMoShi','0','284','1'),
('2351','平度市','PingDuShi','0','284','1'),
('2352','胶南市','JiaoNanShi','0','284','1'),
('2353','莱西市','LaiXiShi','0','284','1'),
('2354','滨城区','BinChengQu','0','285','1'),
('2355','惠民县','HuiMinXian','0','285','1'),
('2356','阳信县','YangXinXian','0','285','1'),
('2357','无棣县','WuXian','0','285','1'),
('2358','沾化县','ZhanHuaXian','0','285','1'),
('2359','博兴县','BoXingXian','0','285','1'),
('2360','邹平县','ZouPingXian','0','285','1'),
('2361','德城区','DeChengQu','0','286','1'),
('2362','陵县','LingXian','0','286','1'),
('2363','乐陵市','LeLingShi','0','286','1'),
('2364','禹城市','YuChengShi','0','286','1'),
('2365','宁津县','NingJinXian','0','286','1'),
('2366','庆云县','QingYunXian','0','286','1'),
('2367','临邑县','LinYiXian','0','286','1'),
('2368','齐河县','QiHeXian','0','286','1'),
('2369','平原县','PingYuanXian','0','286','1'),
('2370','夏津县','XiaJinXian','0','286','1'),
('2371','武城县','WuChengXian','0','286','1'),
('2372','东营区','DongYingQu','0','287','1'),
('2373','河口区','HeKouQu','0','287','1'),
('2374','垦利县','KenLiXian','0','287','1'),
('2375','利津县','LiJinXian','0','287','1'),
('2376','广饶县','GuangRaoXian','0','287','1'),
('2377','牡丹区','MuDanQu','0','288','1'),
('2378','曹县','CaoXian','0','288','1'),
('2379','单县','DanXian','0','288','1'),
('2380','成武县','ChengWuXian','0','288','1'),
('2381','巨野县','JuYeXian','0','288','1'),
('2382','郓城县','ChengXian','0','288','1'),
('2383','鄄城县','ChengXian','0','288','1'),
('2384','定陶县','DingTaoXian','0','288','1'),
('2385','东明县','DongMingXian','0','288','1'),
('2386','市中区','ShiZhongQu','0','289','1'),
('2387','任城区','RenChengQu','0','289','1'),
('2388','曲阜市','QuFuShi','0','289','1'),
('2389','兖州市','ZhouShi','0','289','1'),
('2390','邹城市','ZouChengShi','0','289','1'),
('2391','微山县','WeiShanXian','0','289','1'),
('2392','鱼台县','YuTaiXian','0','289','1'),
('2393','金乡县','JinXiangXian','0','289','1'),
('2394','嘉祥县','JiaXiangXian','0','289','1'),
('2395','汶上县','ShangXian','0','289','1'),
('2396','泗水县','ShuiXian','0','289','1'),
('2397','梁山县','LiangShanXian','0','289','1'),
('2398','莱城区','LaiChengQu','0','290','1'),
('2399','钢城区','GangChengQu','0','290','1'),
('2400','东昌府区','DongChangFuQu','0','291','1'),
('2401','临清市','LinQingShi','0','291','1'),
('2402','阳谷县','YangGuXian','0','291','1'),
('2403','莘县','Xian','0','291','1'),
('2404','茌平县','PingXian','0','291','1'),
('2405','东阿县','DongAXian','0','291','1'),
('2406','冠县','GuanXian','0','291','1'),
('2407','高唐县','GaoTangXian','0','291','1'),
('2408','兰山区','LanShanQu','0','292','1'),
('2409','罗庄区','LuoZhuangQu','0','292','1'),
('2410','河东区','HeDongQu','0','292','1'),
('2411','沂南县','YiNanXian','0','292','1'),
('2412','郯城县','ChengXian','0','292','1'),
('2413','沂水县','YiShuiXian','0','292','1'),
('2414','苍山县','CangShanXian','0','292','1'),
('2415','费县','FeiXian','0','292','1'),
('2416','平邑县','PingYiXian','0','292','1'),
('2417','莒南县','NanXian','0','292','1'),
('2418','蒙阴县','MengYinXian','0','292','1'),
('2419','临沭县','LinXian','0','292','1'),
('2420','东港区','DongGangQu','0','293','1'),
('2421','岚山区','ShanQu','0','293','1'),
('2422','五莲县','WuLianXian','0','293','1'),
('2423','莒县','Xian','0','293','1'),
('2424','泰山区','TaiShanQu','0','294','1'),
('2425','岱岳区','YueQu','0','294','1'),
('2426','新泰市','XinTaiShi','0','294','1'),
('2427','肥城市','FeiChengShi','0','294','1'),
('2428','宁阳县','NingYangXian','0','294','1'),
('2429','东平县','DongPingXian','0','294','1'),
('2430','荣成市','RongChengShi','0','295','1'),
('2431','乳山市','RuShanShi','0','295','1'),
('2432','环翠区','HuanCuiQu','0','295','1'),
('2433','文登市','WenDengShi','0','295','1'),
('2434','潍城区','WeiChengQu','0','296','1'),
('2435','寒亭区','HanTingQu','0','296','1'),
('2436','坊子区','FangZiQu','0','296','1'),
('2437','奎文区','KuiWenQu','0','296','1'),
('2438','青州市','QingZhouShi','0','296','1'),
('2439','诸城市','ZhuChengShi','0','296','1'),
('2440','寿光市','ShouGuangShi','0','296','1'),
('2441','安丘市','AnQiuShi','0','296','1'),
('2442','高密市','GaoMiShi','0','296','1'),
('2443','昌邑市','ChangYiShi','0','296','1'),
('2444','临朐县','LinXian','0','296','1'),
('2445','昌乐县','ChangLeXian','0','296','1'),
('2446','芝罘区','ZhiQu','0','297','1'),
('2447','福山区','FuShanQu','0','297','1'),
('2448','牟平区','MouPingQu','0','297','1'),
('2449','莱山区','LaiShanQu','0','297','1'),
('2450','开发区','KaiFaQu','0','297','1'),
('2451','龙口市','LongKouShi','0','297','1'),
('2452','莱阳市','LaiYangShi','0','297','1'),
('2453','莱州市','LaiZhouShi','0','297','1'),
('2454','蓬莱市','PengLaiShi','0','297','1'),
('2455','招远市','ZhaoYuanShi','0','297','1'),
('2456','栖霞市','QiXiaShi','0','297','1'),
('2457','海阳市','HaiYangShi','0','297','1'),
('2458','长岛县','ChangDaoXian','0','297','1'),
('2459','市中区','ShiZhongQu','0','298','1'),
('2460','山亭区','ShanTingQu','0','298','1'),
('2461','峄城区','ChengQu','0','298','1'),
('2462','台儿庄区','TaiErZhuangQu','0','298','1'),
('2463','薛城区','XueChengQu','0','298','1'),
('2464','滕州市','ZhouShi','0','298','1'),
('2465','张店区','ZhangDianQu','0','299','1'),
('2466','临淄区','LinZiQu','0','299','1'),
('2467','淄川区','ZiChuanQu','0','299','1'),
('2468','博山区','BoShanQu','0','299','1'),
('2469','周村区','ZhouCunQu','0','299','1'),
('2470','桓台县','HuanTaiXian','0','299','1'),
('2471','高青县','GaoQingXian','0','299','1'),
('2472','沂源县','YiYuanXian','0','299','1'),
('2473','杏花岭区','XingHuaLingQu','0','300','1'),
('2474','小店区','XiaoDianQu','0','300','1'),
('2475','迎泽区','YingZeQu','0','300','1'),
('2476','尖草坪区','JianCaoPingQu','0','300','1'),
('2477','万柏林区','WanBaiLinQu','0','300','1'),
('2478','晋源区','JinYuanQu','0','300','1'),
('2479','高新开发区','GaoXinKaiFaQu','0','300','1'),
('2480','民营经济开发区','MinYingJingJiKaiFaQu','0','300','1'),
('2481','经济技术开发区','JingJiJiShuKaiFaQu','0','300','1'),
('2482','清徐县','QingXuXian','0','300','1'),
('2483','阳曲县','YangQuXian','0','300','1'),
('2484','娄烦县','LouFanXian','0','300','1'),
('2485','古交市','GuJiaoShi','0','300','1'),
('2486','城区','ChengQu','0','301','1'),
('2487','郊区','JiaoQu','0','301','1'),
('2488','沁县','QinXian','0','301','1'),
('2489','潞城市','LuChengShi','0','301','1'),
('2490','长治县','ChangZhiXian','0','301','1'),
('2491','襄垣县','XiangYuanXian','0','301','1'),
('2492','屯留县','TunLiuXian','0','301','1'),
('2493','平顺县','PingShunXian','0','301','1'),
('2494','黎城县','LiChengXian','0','301','1'),
('2495','壶关县','HuGuanXian','0','301','1'),
('2496','长子县','ChangZiXian','0','301','1'),
('2497','武乡县','WuXiangXian','0','301','1'),
('2498','沁源县','QinYuanXian','0','301','1'),
('2499','城区','ChengQu','0','302','1'),
('2500','矿区','KuangQu','0','302','1'),
('2501','南郊区','NanJiaoQu','0','302','1'),
('2502','新荣区','XinRongQu','0','302','1'),
('2503','阳高县','YangGaoXian','0','302','1'),
('2504','天镇县','TianZhenXian','0','302','1'),
('2505','广灵县','GuangLingXian','0','302','1'),
('2506','灵丘县','LingQiuXian','0','302','1'),
('2507','浑源县','HunYuanXian','0','302','1'),
('2509','大同县','DaTongXian','0','302','1'),
('2510','城区','ChengQu','0','303','1'),
('2511','高平市','GaoPingShi','0','303','1'),
('2512','沁水县','QinShuiXian','0','303','1'),
('2513','阳城县','YangChengXian','0','303','1'),
('2514','陵川县','LingChuanXian','0','303','1'),
('2515','泽州县','ZeZhouXian','0','303','1'),
('2516','榆次区','YuCiQu','0','304','1'),
('2517','介休市','JieXiuShi','0','304','1'),
('2518','榆社县','YuSheXian','0','304','1'),
('2519','左权县','ZuoQuanXian','0','304','1'),
('2520','和顺县','HeShunXian','0','304','1'),
('2521','昔阳县','XiYangXian','0','304','1'),
('2522','寿阳县','ShouYangXian','0','304','1'),
('2523','太谷县','TaiGuXian','0','304','1'),
('2524','祁县','QiXian','0','304','1'),
('2525','平遥县','PingYaoXian','0','304','1'),
('2526','灵石县','LingShiXian','0','304','1'),
('2527','尧都区','YaoDuQu','0','305','1'),
('2528','侯马市','HouMaShi','0','305','1'),
('2529','霍州市','HuoZhouShi','0','305','1'),
('2530','曲沃县','QuWoXian','0','305','1'),
('2531','翼城县','YiChengXian','0','305','1'),
('2532','襄汾县','XiangFenXian','0','305','1'),
('2533','洪洞县','HongDongXian','0','305','1'),
('2534','吉县','JiXian','0','305','1'),
('2535','安泽县','AnZeXian','0','305','1'),
('2536','浮山县','FuShanXian','0','305','1'),
('2537','古县','GuXian','0','305','1'),
('2538','乡宁县','XiangNingXian','0','305','1'),
('2539','大宁县','DaNingXian','0','305','1'),
('2540','隰县','Xian','0','305','1'),
('2541','永和县','YongHeXian','0','305','1'),
('2542','蒲县','PuXian','0','305','1'),
('2543','汾西县','FenXiXian','0','305','1'),
('2544','离石市','LiShiShi','0','306','1'),
('2545','离石区','LiShiQu','0','306','1'),
('2546','孝义市','XiaoYiShi','0','306','1'),
('2547','汾阳市','FenYangShi','0','306','1'),
('2548','文水县','WenShuiXian','0','306','1'),
('2549','交城县','JiaoChengXian','0','306','1'),
('2550','兴县','XingXian','0','306','1'),
('2551','临县','LinXian','0','306','1'),
('2552','柳林县','LiuLinXian','0','306','1'),
('2553','石楼县','ShiLouXian','0','306','1'),
('2554','岚县','Xian','0','306','1'),
('2555','方山县','FangShanXian','0','306','1'),
('2556','中阳县','ZhongYangXian','0','306','1'),
('2557','交口县','JiaoKouXian','0','306','1'),
('2558','朔城区','ShuoChengQu','0','307','1'),
('2559','平鲁区','PingLuQu','0','307','1'),
('2560','山阴县','ShanYinXian','0','307','1'),
('2561','应县','YingXian','0','307','1'),
('2562','右玉县','YouYuXian','0','307','1'),
('2563','怀仁县','HuaiRenXian','0','307','1'),
('2564','忻府区','XinFuQu','0','308','1'),
('2565','原平市','YuanPingShi','0','308','1'),
('2566','定襄县','DingXiangXian','0','308','1'),
('2567','五台县','WuTaiXian','0','308','1'),
('2568','代县','DaiXian','0','308','1'),
('2569','繁峙县','FanZhiXian','0','308','1'),
('2570','宁武县','NingWuXian','0','308','1'),
('2571','静乐县','JingLeXian','0','308','1'),
('2572','神池县','ShenChiXian','0','308','1'),
('2573','五寨县','WuZhaiXian','0','308','1'),
('2574','岢岚县','Xian','0','308','1'),
('2575','河曲县','HeQuXian','0','308','1'),
('2576','保德县','BaoDeXian','0','308','1'),
('2577','偏关县','PianGuanXian','0','308','1'),
('2578','城区','ChengQu','0','309','1'),
('2579','矿区','KuangQu','0','309','1'),
('2580','郊区','JiaoQu','0','309','1'),
('2581','平定县','PingDingXian','0','309','1'),
('2582','盂县','YuXian','0','309','1'),
('2583','盐湖区','YanHuQu','0','310','1'),
('2584','永济市','YongJiShi','0','310','1'),
('2585','河津市','HeJinShi','0','310','1'),
('2586','临猗县','LinXian','0','310','1'),
('2587','万荣县','WanRongXian','0','310','1'),
('2588','闻喜县','WenXiXian','0','310','1'),
('2589','稷山县','ShanXian','0','310','1'),
('2590','新绛县','XinXian','0','310','1'),
('2591','绛县','Xian','0','310','1'),
('2592','垣曲县','YuanQuXian','0','310','1'),
('2593','夏县','XiaXian','0','310','1'),
('2594','平陆县','PingLuXian','0','310','1'),
('2595','芮城县','ChengXian','0','310','1'),
('2596','莲湖区','LianHuQu','0','311','1'),
('2597','新城区','XinChengQu','0','311','1'),
('2598','碑林区','BeiLinQu','0','311','1'),
('2599','雁塔区','YanTaQu','0','311','1'),
('2600','灞桥区','QiaoQu','0','311','1'),
('2601','未央区','WeiYangQu','0','311','1'),
('2602','阎良区','YanLiangQu','0','311','1'),
('2603','临潼区','LinQu','0','311','1'),
('2604','长安区','ChangAnQu','0','311','1'),
('2605','蓝田县','LanTianXian','0','311','1'),
('2606','周至县','ZhouZhiXian','0','311','1'),
('2607','户县','HuXian','0','311','1'),
('2608','高陵县','GaoLingXian','0','311','1'),
('2609','汉滨区','HanBinQu','0','312','1'),
('2610','汉阴县','HanYinXian','0','312','1'),
('2611','石泉县','ShiQuanXian','0','312','1'),
('2612','宁陕县','NingShanXian','0','312','1'),
('2613','紫阳县','ZiYangXian','0','312','1'),
('2614','岚皋县','GaoXian','0','312','1'),
('2615','平利县','PingLiXian','0','312','1'),
('2616','镇坪县','ZhenPingXian','0','312','1'),
('2617','旬阳县','XunYangXian','0','312','1'),
('2618','白河县','BaiHeXian','0','312','1'),
('2619','陈仓区','ChenCangQu','0','313','1'),
('2620','渭滨区','WeiBinQu','0','313','1'),
('2621','金台区','JinTaiQu','0','313','1'),
('2622','凤翔县','FengXiangXian','0','313','1'),
('2623','岐山县','ShanXian','0','313','1'),
('2624','扶风县','FuFengXian','0','313','1'),
('2625','眉县','MeiXian','0','313','1'),
('2626','陇县','LongXian','0','313','1'),
('2627','千阳县','QianYangXian','0','313','1'),
('2628','麟游县','YouXian','0','313','1'),
('2629','凤县','FengXian','0','313','1'),
('2630','太白县','TaiBaiXian','0','313','1'),
('2631','汉台区','HanTaiQu','0','314','1'),
('2632','南郑县','NanZhengXian','0','314','1'),
('2633','城固县','ChengGuXian','0','314','1'),
('2634','洋县','YangXian','0','314','1'),
('2635','西乡县','XiXiangXian','0','314','1'),
('2636','勉县','MianXian','0','314','1'),
('2637','宁强县','NingQiangXian','0','314','1'),
('2638','略阳县','LueYangXian','0','314','1'),
('2639','镇巴县','ZhenBaXian','0','314','1'),
('2640','留坝县','LiuBaXian','0','314','1'),
('2641','佛坪县','FoPingXian','0','314','1'),
('2642','商州区','ShangZhouQu','0','315','1'),
('2643','洛南县','LuoNanXian','0','315','1'),
('2644','丹凤县','DanFengXian','0','315','1'),
('2645','商南县','ShangNanXian','0','315','1'),
('2646','山阳县','ShanYangXian','0','315','1'),
('2647','镇安县','ZhenAnXian','0','315','1'),
('2648','柞水县','ZuoShuiXian','0','315','1'),
('2649','耀州区','YaoZhouQu','0','316','1'),
('2650','王益区','WangYiQu','0','316','1'),
('2651','印台区','YinTaiQu','0','316','1'),
('2652','宜君县','YiJunXian','0','316','1'),
('2653','临渭区','LinWeiQu','0','317','1'),
('2654','韩城市','HanChengShi','0','317','1'),
('2655','华阴市','HuaYinShi','0','317','1'),
('2656','华县','HuaXian','0','317','1'),
('2657','潼关县','GuanXian','0','317','1'),
('2658','大荔县','DaLiXian','0','317','1'),
('2659','合阳县','HeYangXian','0','317','1'),
('2660','澄城县','ChengChengXian','0','317','1'),
('2661','蒲城县','PuChengXian','0','317','1'),
('2662','白水县','BaiShuiXian','0','317','1'),
('2663','富平县','FuPingXian','0','317','1'),
('2664','秦都区','QinDuQu','0','318','1'),
('2665','渭城区','WeiChengQu','0','318','1'),
('2666','杨陵区','YangLingQu','0','318','1'),
('2667','兴平市','XingPingShi','0','318','1'),
('2668','三原县','SanYuanXian','0','318','1'),
('2669','泾阳县','YangXian','0','318','1'),
('2670','乾县','QianXian','0','318','1'),
('2671','礼泉县','LiQuanXian','0','318','1'),
('2672','永寿县','YongShouXian','0','318','1'),
('2673','彬县','BinXian','0','318','1'),
('2674','长武县','ChangWuXian','0','318','1'),
('2675','旬邑县','XunYiXian','0','318','1'),
('2676','淳化县','ChunHuaXian','0','318','1'),
('2677','武功县','WuGongXian','0','318','1'),
('2678','吴起县','WuQiXian','0','319','1'),
('2679','宝塔区','BaoTaQu','0','319','1'),
('2680','延长县','YanChangXian','0','319','1'),
('2681','延川县','YanChuanXian','0','319','1'),
('2682','子长县','ZiChangXian','0','319','1'),
('2683','安塞县','AnSaiXian','0','319','1'),
('2684','志丹县','ZhiDanXian','0','319','1'),
('2685','甘泉县','GanQuanXian','0','319','1'),
('2686','富县','FuXian','0','319','1'),
('2687','洛川县','LuoChuanXian','0','319','1'),
('2688','宜川县','YiChuanXian','0','319','1'),
('2689','黄龙县','HuangLongXian','0','319','1'),
('2690','黄陵县','HuangLingXian','0','319','1'),
('2691','榆阳区','YuYangQu','0','320','1'),
('2692','神木县','ShenMuXian','0','320','1'),
('2693','府谷县','FuGuXian','0','320','1'),
('2694','横山县','HengShanXian','0','320','1'),
('2695','靖边县','JingBianXian','0','320','1'),
('2696','定边县','DingBianXian','0','320','1'),
('2697','绥德县','SuiDeXian','0','320','1'),
('2698','米脂县','MiZhiXian','0','320','1'),
('2699','佳县','JiaXian','0','320','1'),
('2700','吴堡县','WuBaoXian','0','320','1'),
('2701','清涧县','QingJianXian','0','320','1'),
('2702','子洲县','ZiZhouXian','0','320','1'),
('2703','长宁区','ChangNingQu','0','321','1'),
('2704','闸北区','ZhaBeiQu','0','321','1'),
('2705','闵行区','XingQu','0','321','1'),
('2706','徐汇区','XuHuiQu','0','321','1'),
('2707','浦东新区','PuDongXinQu','0','321','1'),
('2708','杨浦区','YangPuQu','0','321','1'),
('2709','普陀区','PuTuoQu','0','321','1'),
('2710','静安区','JingAnQu','0','321','1'),
('2711','卢湾区','LuWanQu','0','321','1'),
('2712','虹口区','HongKouQu','0','321','1'),
('2713','黄浦区','HuangPuQu','0','321','1'),
('2714','南汇区','NanHuiQu','0','321','1'),
('2715','松江区','SongJiangQu','0','321','1'),
('2716','嘉定区','JiaDingQu','0','321','1'),
('2717','宝山区','BaoShanQu','0','321','1'),
('2718','青浦区','QingPuQu','0','321','1'),
('2719','金山区','JinShanQu','0','321','1'),
('2720','奉贤区','FengXianQu','0','321','1'),
('2721','崇明县','ChongMingXian','0','321','1'),
('2722','青羊区','QingYangQu','0','322','1'),
('2723','锦江区','JinJiangQu','0','322','1'),
('2724','金牛区','JinNiuQu','0','322','1'),
('2725','武侯区','WuHouQu','0','322','1'),
('2726','成华区','ChengHuaQu','0','322','1'),
('2727','龙泉驿区','LongQuanQu','0','322','1'),
('2728','青白江区','QingBaiJiangQu','0','322','1'),
('2729','新都区','XinDuQu','0','322','1'),
('2730','温江区','WenJiangQu','0','322','1'),
('2731','高新区','GaoXinQu','0','322','1'),
('2732','高新西区','GaoXinXiQu','0','322','1'),
('2733','都江堰市','DuJiangYanShi','0','322','1'),
('2734','彭州市','PengZhouShi','0','322','1'),
('2735','邛崃市','Shi','0','322','1'),
('2736','崇州市','ChongZhouShi','0','322','1'),
('2737','金堂县','JinTangXian','0','322','1'),
('2738','双流县','ShuangLiuXian','0','322','1'),
('2739','郫县','Xian','0','322','1'),
('2740','大邑县','DaYiXian','0','322','1'),
('2741','蒲江县','PuJiangXian','0','322','1'),
('2742','新津县','XinJinXian','0','322','1'),
('2743','都江堰市','DuJiangYanShi','0','322','1'),
('2744','彭州市','PengZhouShi','0','322','1'),
('2745','邛崃市','Shi','0','322','1'),
('2746','崇州市','ChongZhouShi','0','322','1'),
('2747','金堂县','JinTangXian','0','322','1'),
('2748','双流县','ShuangLiuXian','0','322','1'),
('2749','郫县','Xian','0','322','1'),
('2750','大邑县','DaYiXian','0','322','1'),
('2751','蒲江县','PuJiangXian','0','322','1'),
('2752','新津县','XinJinXian','0','322','1'),
('2753','涪城区','FuChengQu','0','323','1'),
('2754','游仙区','YouXianQu','0','323','1'),
('2755','江油市','JiangYouShi','0','323','1'),
('2756','盐亭县','YanTingXian','0','323','1'),
('2757','三台县','SanTaiXian','0','323','1'),
('2758','平武县','PingWuXian','0','323','1'),
('2759','安县','AnXian','0','323','1'),
('2760','梓潼县','Xian','0','323','1'),
('2761','北川县','BeiChuanXian','0','323','1'),
('2762','马尔康县','MaErKangXian','0','324','1'),
('2763','汶川县','ChuanXian','0','324','1'),
('2764','理县','LiXian','0','324','1'),
('2765','茂县','MaoXian','0','324','1'),
('2766','松潘县','SongPanXian','0','324','1'),
('2767','九寨沟县','JiuZhaiGouXian','0','324','1'),
('2768','金川县','JinChuanXian','0','324','1'),
('2769','小金县','XiaoJinXian','0','324','1'),
('2770','黑水县','HeiShuiXian','0','324','1'),
('2771','壤塘县','RangTangXian','0','324','1'),
('2772','阿坝县','ABaXian','0','324','1'),
('2773','若尔盖县','RuoErGaiXian','0','324','1'),
('2774','红原县','HongYuanXian','0','324','1'),
('2775','巴州区','BaZhouQu','0','325','1'),
('2776','通江县','TongJiangXian','0','325','1'),
('2777','南江县','NanJiangXian','0','325','1'),
('2778','平昌县','PingChangXian','0','325','1'),
('2779','通川区','TongChuanQu','0','326','1'),
('2780','万源市','WanYuanShi','0','326','1'),
('2781','达县','DaXian','0','326','1'),
('2782','宣汉县','XuanHanXian','0','326','1'),
('2783','开江县','KaiJiangXian','0','326','1'),
('2784','大竹县','DaZhuXian','0','326','1'),
('2785','渠县','QuXian','0','326','1'),
('2786','旌阳区','YangQu','0','327','1'),
('2787','广汉市','GuangHanShi','0','327','1'),
('2788','什邡市','ShiShi','0','327','1'),
('2789','绵竹市','MianZhuShi','0','327','1'),
('2790','罗江县','LuoJiangXian','0','327','1'),
('2791','中江县','ZhongJiangXian','0','327','1'),
('2792','康定县','KangDingXian','0','328','1'),
('2793','丹巴县','DanBaXian','0','328','1'),
('2794','泸定县','DingXian','0','328','1'),
('2795','炉霍县','LuHuoXian','0','328','1'),
('2796','九龙县','JiuLongXian','0','328','1'),
('2797','甘孜县','GanZiXian','0','328','1'),
('2798','雅江县','YaJiangXian','0','328','1'),
('2799','新龙县','XinLongXian','0','328','1'),
('2800','道孚县','DaoXian','0','328','1'),
('2801','白玉县','BaiYuXian','0','328','1'),
('2802','理塘县','LiTangXian','0','328','1'),
('2803','德格县','DeGeXian','0','328','1'),
('2804','乡城县','XiangChengXian','0','328','1'),
('2805','石渠县','ShiQuXian','0','328','1'),
('2806','稻城县','DaoChengXian','0','328','1'),
('2807','色达县','SeDaXian','0','328','1'),
('2808','巴塘县','BaTangXian','0','328','1'),
('2809','得荣县','DeRongXian','0','328','1'),
('2810','广安区','GuangAnQu','0','329','1'),
('2811','华蓥市','HuaShi','0','329','1'),
('2812','岳池县','YueChiXian','0','329','1'),
('2813','武胜县','WuShengXian','0','329','1'),
('2814','邻水县','LinShuiXian','0','329','1'),
('2815','利州区','LiZhouQu','0','330','1'),
('2816','元坝区','YuanBaQu','0','330','1'),
('2817','朝天区','ChaoTianQu','0','330','1'),
('2818','旺苍县','WangCangXian','0','330','1'),
('2819','青川县','QingChuanXian','0','330','1'),
('2820','剑阁县','JianGeXian','0','330','1'),
('2821','苍溪县','CangXiXian','0','330','1'),
('2822','峨眉山市','EMeiShanShi','0','331','1'),
('2823','乐山市','LeShanShi','0','331','1'),
('2824','犍为县','WeiXian','0','331','1'),
('2825','井研县','JingYanXian','0','331','1'),
('2826','夹江县','JiaJiangXian','0','331','1'),
('2827','沐川县','ChuanXian','0','331','1'),
('2828','峨边','EBian','0','331','1'),
('2829','马边','MaBian','0','331','1'),
('2830','西昌市','XiChangShi','0','332','1'),
('2831','盐源县','YanYuanXian','0','332','1'),
('2832','德昌县','DeChangXian','0','332','1'),
('2833','会理县','HuiLiXian','0','332','1'),
('2834','会东县','HuiDongXian','0','332','1'),
('2835','宁南县','NingNanXian','0','332','1'),
('2836','普格县','PuGeXian','0','332','1'),
('2837','布拖县','BuTuoXian','0','332','1'),
('2838','金阳县','JinYangXian','0','332','1'),
('2839','昭觉县','ZhaoJueXian','0','332','1'),
('2840','喜德县','XiDeXian','0','332','1'),
('2841','冕宁县','MianNingXian','0','332','1'),
('2842','越西县','YueXiXian','0','332','1'),
('2843','甘洛县','GanLuoXian','0','332','1'),
('2844','美姑县','MeiGuXian','0','332','1'),
('2845','雷波县','LeiBoXian','0','332','1'),
('2846','木里','MuLi','0','332','1'),
('2847','东坡区','DongPoQu','0','333','1'),
('2848','仁寿县','RenShouXian','0','333','1'),
('2849','彭山县','PengShanXian','0','333','1'),
('2850','洪雅县','HongYaXian','0','333','1'),
('2851','丹棱县','DanLengXian','0','333','1'),
('2852','青神县','QingShenXian','0','333','1'),
('2853','阆中市','ZhongShi','0','334','1'),
('2854','南部县','NanBuXian','0','334','1'),
('2855','营山县','YingShanXian','0','334','1'),
('2856','蓬安县','PengAnXian','0','334','1'),
('2857','仪陇县','YiLongXian','0','334','1'),
('2858','顺庆区','ShunQingQu','0','334','1'),
('2859','高坪区','GaoPingQu','0','334','1'),
('2860','嘉陵区','JiaLingQu','0','334','1'),
('2861','西充县','XiChongXian','0','334','1'),
('2862','市中区','ShiZhongQu','0','335','1'),
('2863','东兴区','DongXingQu','0','335','1'),
('2864','威远县','WeiYuanXian','0','335','1'),
('2865','资中县','ZiZhongXian','0','335','1'),
('2866','隆昌县','LongChangXian','0','335','1'),
('2867','东  区','DongQu','0','336','1'),
('2868','西  区','XiQu','0','336','1'),
('2869','仁和区','RenHeQu','0','336','1'),
('2870','米易县','MiYiXian','0','336','1'),
('2871','盐边县','YanBianXian','0','336','1'),
('2872','船山区','ChuanShanQu','0','337','1'),
('2873','安居区','AnJuQu','0','337','1'),
('2874','蓬溪县','PengXiXian','0','337','1'),
('2875','射洪县','SheHongXian','0','337','1'),
('2876','大英县','DaYingXian','0','337','1'),
('2877','雨城区','YuChengQu','0','338','1'),
('2878','名山县','MingShanXian','0','338','1'),
('2879','荥经县','JingXian','0','338','1'),
('2880','汉源县','HanYuanXian','0','338','1'),
('2881','石棉县','ShiMianXian','0','338','1'),
('2882','天全县','TianQuanXian','0','338','1'),
('2883','芦山县','LuShanXian','0','338','1'),
('2884','宝兴县','BaoXingXian','0','338','1'),
('2885','翠屏区','CuiPingQu','0','339','1'),
('2886','宜宾县','YiBinXian','0','339','1'),
('2887','南溪县','NanXiXian','0','339','1'),
('2888','江安县','JiangAnXian','0','339','1'),
('2889','长宁县','ChangNingXian','0','339','1'),
('2890','高县','GaoXian','0','339','1'),
('2891','珙县','Xian','0','339','1'),
('2892','筠连县','LianXian','0','339','1'),
('2893','兴文县','XingWenXian','0','339','1'),
('2894','屏山县','PingShanXian','0','339','1'),
('2895','雁江区','YanJiangQu','0','340','1'),
('2896','简阳市','JianYangShi','0','340','1'),
('2897','安岳县','AnYueXian','0','340','1'),
('2898','乐至县','LeZhiXian','0','340','1'),
('2899','大安区','DaAnQu','0','341','1'),
('2900','自流井区','ZiLiuJingQu','0','341','1'),
('2901','贡井区','GongJingQu','0','341','1'),
('2902','沿滩区','YanTanQu','0','341','1'),
('2903','荣县','RongXian','0','341','1'),
('2904','富顺县','FuShunXian','0','341','1'),
('2905','江阳区','JiangYangQu','0','342','1'),
('2906','纳溪区','NaXiQu','0','342','1'),
('2907','龙马潭区','LongMaTanQu','0','342','1'),
('2908','泸县','Xian','0','342','1'),
('2909','合江县','HeJiangXian','0','342','1'),
('2910','叙永县','XuYongXian','0','342','1'),
('2911','古蔺县','GuXian','0','342','1'),
('2912','和平区','HePingQu','0','343','1'),
('2913','河西区','HeXiQu','0','343','1'),
('2914','南开区','NanKaiQu','0','343','1'),
('2915','河北区','HeBeiQu','0','343','1'),
('2916','河东区','HeDongQu','0','343','1'),
('2917','红桥区','HongQiaoQu','0','343','1'),
('2918','东丽区','DongLiQu','0','343','1'),
('2919','津南区','JinNanQu','0','343','1'),
('2920','西青区','XiQingQu','0','343','1'),
('2921','北辰区','BeiChenQu','0','343','1'),
('2922','塘沽区','TangGuQu','0','343','1'),
('2923','汉沽区','HanGuQu','0','343','1'),
('2924','大港区','DaGangQu','0','343','1'),
('2925','武清区','WuQingQu','0','343','1'),
('2926','宝坻区','BaoQu','0','343','1'),
('2927','经济开发区','JingJiKaiFaQu','0','343','1'),
('2928','宁河县','NingHeXian','0','343','1'),
('2929','静海县','JingHaiXian','0','343','1'),
('2930','蓟县','JiXian','0','343','1'),
('2931','城关区','ChengGuanQu','0','344','1'),
('2932','林周县','LinZhouXian','0','344','1'),
('2933','当雄县','DangXiongXian','0','344','1'),
('2934','尼木县','NiMuXian','0','344','1'),
('2935','曲水县','QuShuiXian','0','344','1'),
('2936','堆龙德庆县','DuiLongDeQingXian','0','344','1'),
('2937','达孜县','DaZiXian','0','344','1'),
('2938','墨竹工卡县','MoZhuGongKaXian','0','344','1'),
('2939','噶尔县','GaErXian','0','345','1'),
('2940','普兰县','PuLanXian','0','345','1'),
('2941','札达县','ZhaDaXian','0','345','1'),
('2942','日土县','RiTuXian','0','345','1'),
('2943','革吉县','GeJiXian','0','345','1'),
('2944','改则县','GaiZeXian','0','345','1'),
('2945','措勤县','CuoQinXian','0','345','1'),
('2946','昌都县','ChangDuXian','0','346','1'),
('2947','江达县','JiangDaXian','0','346','1'),
('2948','贡觉县','GongJueXian','0','346','1'),
('2949','类乌齐县','LeiWuQiXian','0','346','1'),
('2950','丁青县','DingQingXian','0','346','1'),
('2951','察雅县','ChaYaXian','0','346','1'),
('2952','八宿县','BaSuXian','0','346','1'),
('2953','左贡县','ZuoGongXian','0','346','1'),
('2954','芒康县','MangKangXian','0','346','1'),
('2955','洛隆县','LuoLongXian','0','346','1'),
('2956','边坝县','BianBaXian','0','346','1'),
('2957','林芝县','LinZhiXian','0','347','1'),
('2958','工布江达县','GongBuJiangDaXian','0','347','1'),
('2959','米林县','MiLinXian','0','347','1'),
('2960','墨脱县','MoTuoXian','0','347','1'),
('2961','波密县','BoMiXian','0','347','1'),
('2962','察隅县','ChaYuXian','0','347','1'),
('2963','朗县','LangXian','0','347','1'),
('2964','那曲县','NaQuXian','0','348','1'),
('2965','嘉黎县','JiaLiXian','0','348','1'),
('2966','比如县','BiRuXian','0','348','1'),
('2967','聂荣县','NieRongXian','0','348','1'),
('2968','安多县','AnDuoXian','0','348','1'),
('2969','申扎县','ShenZhaXian','0','348','1'),
('2970','索县','SuoXian','0','348','1'),
('2971','班戈县','BanGeXian','0','348','1'),
('2972','巴青县','BaQingXian','0','348','1'),
('2973','尼玛县','NiMaXian','0','348','1'),
('2974','日喀则市','RiKaZeShi','0','349','1'),
('2975','南木林县','NanMuLinXian','0','349','1'),
('2976','江孜县','JiangZiXian','0','349','1'),
('2977','定日县','DingRiXian','0','349','1'),
('2978','萨迦县','SaXian','0','349','1'),
('2979','拉孜县','LaZiXian','0','349','1'),
('2980','昂仁县','AngRenXian','0','349','1'),
('2981','谢通门县','XieTongMenXian','0','349','1'),
('2982','白朗县','BaiLangXian','0','349','1'),
('2983','仁布县','RenBuXian','0','349','1'),
('2984','康马县','KangMaXian','0','349','1'),
('2985','定结县','DingJieXian','0','349','1'),
('2986','仲巴县','ZhongBaXian','0','349','1'),
('2987','亚东县','YaDongXian','0','349','1'),
('2988','吉隆县','JiLongXian','0','349','1'),
('2989','聂拉木县','NieLaMuXian','0','349','1'),
('2990','萨嘎县','SaGaXian','0','349','1'),
('2991','岗巴县','GangBaXian','0','349','1'),
('2992','乃东县','NaiDongXian','0','350','1'),
('2993','扎囊县','ZhaNangXian','0','350','1'),
('2994','贡嘎县','GongGaXian','0','350','1'),
('2995','桑日县','SangRiXian','0','350','1'),
('2996','琼结县','QiongJieXian','0','350','1'),
('2997','曲松县','QuSongXian','0','350','1'),
('2998','措美县','CuoMeiXian','0','350','1'),
('2999','洛扎县','LuoZhaXian','0','350','1'),
('3000','加查县','JiaChaXian','0','350','1'),
('3001','隆子县','LongZiXian','0','350','1'),
('3002','错那县','CuoNaXian','0','350','1'),
('3003','浪卡子县','LangKaZiXian','0','350','1'),
('3004','天山区','TianShanQu','0','351','1'),
('3005','沙依巴克区','ShaYiBaKeQu','0','351','1'),
('3006','新市区','XinShiQu','0','351','1'),
('3007','水磨沟区','ShuiMoGouQu','0','351','1'),
('3008','头屯河区','TouTunHeQu','0','351','1'),
('3009','达坂城区','DaChengQu','0','351','1'),
('3010','米东区','MiDongQu','0','351','1'),
('3011','乌鲁木齐县','WuLuMuQiXian','0','351','1'),
('3012','阿克苏市','AKeSuShi','0','352','1'),
('3013','温宿县','WenSuXian','0','352','1'),
('3014','库车县','KuCheXian','0','352','1'),
('3015','沙雅县','ShaYaXian','0','352','1'),
('3016','新和县','XinHeXian','0','352','1'),
('3017','拜城县','BaiChengXian','0','352','1'),
('3018','乌什县','WuShiXian','0','352','1'),
('3019','阿瓦提县','AWaTiXian','0','352','1'),
('3020','柯坪县','KePingXian','0','352','1'),
('3021','阿拉尔市','ALaErShi','0','353','1'),
('3022','库尔勒市','KuErLeShi','0','354','1'),
('3023','轮台县','LunTaiXian','0','354','1'),
('3024','尉犁县','WeiLiXian','0','354','1'),
('3025','若羌县','RuoQiangXian','0','354','1'),
('3026','且末县','QieMoXian','0','354','1'),
('3027','焉耆','Yan','0','354','1'),
('3028','和静县','HeJingXian','0','354','1'),
('3029','和硕县','HeShuoXian','0','354','1'),
('3030','博湖县','BoHuXian','0','354','1'),
('3031','博乐市','BoLeShi','0','355','1'),
('3032','精河县','JingHeXian','0','355','1'),
('3033','温泉县','WenQuanXian','0','355','1'),
('3034','呼图壁县','HuTuBiXian','0','356','1'),
('3035','米泉市','MiQuanShi','0','356','1'),
('3036','昌吉市','ChangJiShi','0','356','1'),
('3037','阜康市','FuKangShi','0','356','1'),
('3038','玛纳斯县','MaNaSiXian','0','356','1'),
('3039','奇台县','QiTaiXian','0','356','1'),
('3040','吉木萨尔县','JiMuSaErXian','0','356','1'),
('3041','木垒','MuLei','0','356','1'),
('3042','哈密市','HaMiShi','0','357','1'),
('3043','伊吾县','YiWuXian','0','357','1'),
('3044','巴里坤','BaLiKun','0','357','1'),
('3045','和田市','HeTianShi','0','358','1'),
('3046','和田县','HeTianXian','0','358','1'),
('3047','墨玉县','MoYuXian','0','358','1'),
('3048','皮山县','PiShanXian','0','358','1'),
('3049','洛浦县','LuoPuXian','0','358','1'),
('3050','策勒县','CeLeXian','0','358','1'),
('3051','于田县','YuTianXian','0','358','1'),
('3052','民丰县','MinFengXian','0','358','1'),
('3053','喀什市','KaShiShi','0','359','1'),
('3054','疏附县','ShuFuXian','0','359','1'),
('3055','疏勒县','ShuLeXian','0','359','1'),
('3056','英吉沙县','YingJiShaXian','0','359','1'),
('3057','泽普县','ZePuXian','0','359','1'),
('3058','莎车县','ShaCheXian','0','359','1'),
('3059','叶城县','YeChengXian','0','359','1'),
('3060','麦盖提县','MaiGaiTiXian','0','359','1'),
('3061','岳普湖县','YuePuHuXian','0','359','1'),
('3062','伽师县','ShiXian','0','359','1'),
('3063','巴楚县','BaChuXian','0','359','1'),
('3064','塔什库尔干','TaShiKuErGan','0','359','1'),
('3065','克拉玛依市','KeLaMaYiShi','0','360','1'),
('3066','阿图什市','ATuShiShi','0','361','1'),
('3067','阿克陶县','AKeTaoXian','0','361','1'),
('3068','阿合奇县','AHeQiXian','0','361','1'),
('3069','乌恰县','WuQiaXian','0','361','1'),
('3070','石河子市','ShiHeZiShi','0','362','1'),
('3071','图木舒克市','TuMuShuKeShi','0','363','1'),
('3072','吐鲁番市','TuLuFanShi','0','364','1'),
('3073','鄯善县','ShanXian','0','364','1'),
('3074','托克逊县','TuoKeXunXian','0','364','1'),
('3075','五家渠市','WuJiaQuShi','0','365','1'),
('3076','阿勒泰市','ALeTaiShi','0','366','1'),
('3077','布克赛尔','BuKeSaiEr','0','366','1'),
('3078','伊宁市','YiNingShi','0','366','1'),
('3079','布尔津县','BuErJinXian','0','366','1'),
('3080','奎屯市','KuiTunShi','0','366','1'),
('3081','乌苏市','WuSuShi','0','366','1'),
('3082','额敏县','EMinXian','0','366','1'),
('3083','富蕴县','FuYunXian','0','366','1'),
('3084','伊宁县','YiNingXian','0','366','1'),
('3085','福海县','FuHaiXian','0','366','1'),
('3086','霍城县','HuoChengXian','0','366','1'),
('3087','沙湾县','ShaWanXian','0','366','1'),
('3088','巩留县','GongLiuXian','0','366','1'),
('3089','哈巴河县','HaBaHeXian','0','366','1'),
('3090','托里县','TuoLiXian','0','366','1'),
('3091','青河县','QingHeXian','0','366','1'),
('3092','新源县','XinYuanXian','0','366','1'),
('3093','裕民县','YuMinXian','0','366','1'),
('3094','和布克赛尔','HeBuKeSaiEr','0','366','1'),
('3095','吉木乃县','JiMuNaiXian','0','366','1'),
('3096','昭苏县','ZhaoSuXian','0','366','1'),
('3097','特克斯县','TeKeSiXian','0','366','1'),
('3098','尼勒克县','NiLeKeXian','0','366','1'),
('3099','察布查尔','ChaBuChaEr','0','366','1'),
('3100','盘龙区','PanLongQu','0','367','1'),
('3101','五华区','WuHuaQu','0','367','1'),
('3102','官渡区','GuanDuQu','0','367','1'),
('3103','西山区','XiShanQu','0','367','1'),
('3104','东川区','DongChuanQu','0','367','1'),
('3105','安宁市','AnNingShi','0','367','1'),
('3106','呈贡县','ChengGongXian','0','367','1'),
('3107','晋宁县','JinNingXian','0','367','1'),
('3108','富民县','FuMinXian','0','367','1'),
('3109','宜良县','YiLiangXian','0','367','1'),
('3110','嵩明县','MingXian','0','367','1'),
('3111','石林县','ShiLinXian','0','367','1'),
('3112','禄劝','LuQuan','0','367','1'),
('3113','寻甸','XunDian','0','367','1'),
('3114','兰坪','LanPing','0','368','1'),
('3115','泸水县','ShuiXian','0','368','1'),
('3116','福贡县','FuGongXian','0','368','1'),
('3117','贡山','GongShan','0','368','1'),
('3118','宁洱','NingEr','0','369','1'),
('3119','思茅区','SiMaoQu','0','369','1'),
('3120','墨江','MoJiang','0','369','1'),
('3121','景东','JingDong','0','369','1'),
('3122','景谷','JingGu','0','369','1'),
('3123','镇沅','Zhen','0','369','1'),
('3124','江城','JiangCheng','0','369','1'),
('3125','孟连','MengLian','0','369','1'),
('3126','澜沧','LanCang','0','369','1'),
('3127','西盟','XiMeng','0','369','1'),
('3128','古城区','GuChengQu','0','370','1'),
('3129','宁蒗','Ning','0','370','1'),
('3130','玉龙','YuLong','0','370','1'),
('3131','永胜县','YongShengXian','0','370','1'),
('3132','华坪县','HuaPingXian','0','370','1'),
('3133','隆阳区','LongYangQu','0','371','1'),
('3134','施甸县','ShiDianXian','0','371','1'),
('3135','腾冲县','TengChongXian','0','371','1'),
('3136','龙陵县','LongLingXian','0','371','1'),
('3137','昌宁县','ChangNingXian','0','371','1'),
('3138','楚雄市','ChuXiongShi','0','372','1'),
('3139','双柏县','ShuangBaiXian','0','372','1'),
('3140','牟定县','MouDingXian','0','372','1'),
('3141','南华县','NanHuaXian','0','372','1'),
('3142','姚安县','YaoAnXian','0','372','1'),
('3143','大姚县','DaYaoXian','0','372','1'),
('3144','永仁县','YongRenXian','0','372','1'),
('3145','元谋县','YuanMouXian','0','372','1'),
('3146','武定县','WuDingXian','0','372','1'),
('3147','禄丰县','LuFengXian','0','372','1'),
('3148','大理市','DaLiShi','0','373','1'),
('3149','祥云县','XiangYunXian','0','373','1'),
('3150','宾川县','BinChuanXian','0','373','1'),
('3151','弥渡县','MiDuXian','0','373','1'),
('3152','永平县','YongPingXian','0','373','1'),
('3153','云龙县','YunLongXian','0','373','1'),
('3154','洱源县','ErYuanXian','0','373','1'),
('3155','剑川县','JianChuanXian','0','373','1'),
('3156','鹤庆县','HeQingXian','0','373','1'),
('3157','漾濞','Yang','0','373','1'),
('3158','南涧','NanJian','0','373','1'),
('3159','巍山','WeiShan','0','373','1'),
('3160','潞西市','LuXiShi','0','374','1'),
('3161','瑞丽市','RuiLiShi','0','374','1'),
('3162','梁河县','LiangHeXian','0','374','1'),
('3163','盈江县','YingJiangXian','0','374','1'),
('3164','陇川县','LongChuanXian','0','374','1'),
('3165','香格里拉县','XiangGeLiLaXian','0','375','1'),
('3166','德钦县','DeQinXian','0','375','1'),
('3167','维西','WeiXi','0','375','1'),
('3168','泸西县','XiXian','0','376','1'),
('3169','蒙自县','MengZiXian','0','376','1'),
('3170','个旧市','GeJiuShi','0','376','1'),
('3171','开远市','KaiYuanShi','0','376','1'),
('3172','绿春县','LvChunXian','0','376','1'),
('3173','建水县','JianShuiXian','0','376','1'),
('3174','石屏县','ShiPingXian','0','376','1'),
('3175','弥勒县','MiLeXian','0','376','1'),
('3176','元阳县','YuanYangXian','0','376','1'),
('3177','红河县','HongHeXian','0','376','1'),
('3178','金平','JinPing','0','376','1'),
('3179','河口','HeKou','0','376','1'),
('3180','屏边','PingBian','0','376','1'),
('3181','临翔区','LinXiangQu','0','377','1'),
('3182','凤庆县','FengQingXian','0','377','1'),
('3183','云县','YunXian','0','377','1'),
('3184','永德县','YongDeXian','0','377','1'),
('3185','镇康县','ZhenKangXian','0','377','1'),
('3186','双江','ShuangJiang','0','377','1'),
('3187','耿马','GengMa','0','377','1'),
('3188','沧源','CangYuan','0','377','1'),
('3189','麒麟区','Qu','0','378','1'),
('3190','宣威市','XuanWeiShi','0','378','1'),
('3191','马龙县','MaLongXian','0','378','1'),
('3192','陆良县','LuLiangXian','0','378','1'),
('3193','师宗县','ShiZongXian','0','378','1'),
('3194','罗平县','LuoPingXian','0','378','1'),
('3195','富源县','FuYuanXian','0','378','1'),
('3196','会泽县','HuiZeXian','0','378','1'),
('3197','沾益县','ZhanYiXian','0','378','1'),
('3198','文山县','WenShanXian','0','379','1'),
('3199','砚山县','YanShanXian','0','379','1'),
('3200','西畴县','XiChouXian','0','379','1'),
('3201','麻栗坡县','MaLiPoXian','0','379','1'),
('3202','马关县','MaGuanXian','0','379','1'),
('3203','丘北县','QiuBeiXian','0','379','1'),
('3204','广南县','GuangNanXian','0','379','1'),
('3205','富宁县','FuNingXian','0','379','1'),
('3206','景洪市','JingHongShi','0','380','1'),
('3207','勐海县','HaiXian','0','380','1'),
('3208','勐腊县','LaXian','0','380','1'),
('3209','红塔区','HongTaQu','0','381','1'),
('3210','江川县','JiangChuanXian','0','381','1'),
('3211','澄江县','ChengJiangXian','0','381','1'),
('3212','通海县','TongHaiXian','0','381','1'),
('3213','华宁县','HuaNingXian','0','381','1'),
('3214','易门县','YiMenXian','0','381','1'),
('3215','峨山','EShan','0','381','1'),
('3216','新平','XinPing','0','381','1'),
('3217','元江','YuanJiang','0','381','1'),
('3218','昭阳区','ZhaoYangQu','0','382','1'),
('3219','鲁甸县','LuDianXian','0','382','1'),
('3220','巧家县','QiaoJiaXian','0','382','1'),
('3221','盐津县','YanJinXian','0','382','1'),
('3222','大关县','DaGuanXian','0','382','1'),
('3223','永善县','YongShanXian','0','382','1'),
('3224','绥江县','SuiJiangXian','0','382','1'),
('3225','镇雄县','ZhenXiongXian','0','382','1'),
('3226','彝良县','YiLiangXian','0','382','1'),
('3227','威信县','WeiXinXian','0','382','1'),
('3228','水富县','ShuiFuXian','0','382','1'),
('3229','西湖区','XiHuQu','0','383','1'),
('3230','上城区','ShangChengQu','0','383','1'),
('3231','下城区','XiaChengQu','0','383','1'),
('3232','拱墅区','GongShuQu','0','383','1'),
('3233','滨江区','BinJiangQu','0','383','1'),
('3234','江干区','JiangGanQu','0','383','1'),
('3235','萧山区','XiaoShanQu','0','383','1'),
('3236','余杭区','YuHangQu','0','383','1'),
('3237','市郊','ShiJiao','0','383','1'),
('3238','建德市','JianDeShi','0','383','1'),
('3239','富阳市','FuYangShi','0','383','1'),
('3240','临安市','LinAnShi','0','383','1'),
('3241','桐庐县','TongLuXian','0','383','1'),
('3242','淳安县','ChunAnXian','0','383','1'),
('3243','吴兴区','WuXingQu','0','384','1'),
('3244','南浔区','NanQu','0','384','1'),
('3245','德清县','DeQingXian','0','384','1'),
('3246','长兴县','ChangXingXian','0','384','1'),
('3247','安吉县','AnJiXian','0','384','1'),
('3248','南湖区','NanHuQu','0','385','1'),
('3249','秀洲区','XiuZhouQu','0','385','1'),
('3250','海宁市','HaiNingShi','0','385','1'),
('3251','嘉善县','JiaShanXian','0','385','1'),
('3252','平湖市','PingHuShi','0','385','1'),
('3253','桐乡市','TongXiangShi','0','385','1'),
('3254','海盐县','HaiYanXian','0','385','1'),
('3255','婺城区','ChengQu','0','386','1'),
('3256','金东区','JinDongQu','0','386','1'),
('3257','兰溪市','LanXiShi','0','386','1'),
('3258','市区','ShiQu','0','386','1'),
('3259','佛堂镇','FoTangZhen','0','386','1'),
('3260','上溪镇','ShangXiZhen','0','386','1'),
('3261','义亭镇','YiTingZhen','0','386','1'),
('3262','大陈镇','DaChenZhen','0','386','1'),
('3263','苏溪镇','SuXiZhen','0','386','1'),
('3264','赤岸镇','ChiAnZhen','0','386','1'),
('3265','东阳市','DongYangShi','0','386','1'),
('3266','永康市','YongKangShi','0','386','1'),
('3267','武义县','WuYiXian','0','386','1'),
('3268','浦江县','PuJiangXian','0','386','1'),
('3269','磐安县','PanAnXian','0','386','1'),
('3270','莲都区','LianDuQu','0','387','1'),
('3271','龙泉市','LongQuanShi','0','387','1'),
('3272','青田县','QingTianXian','0','387','1'),
('3273','缙云县','YunXian','0','387','1'),
('3274','遂昌县','SuiChangXian','0','387','1'),
('3275','松阳县','SongYangXian','0','387','1'),
('3276','云和县','YunHeXian','0','387','1'),
('3277','庆元县','QingYuanXian','0','387','1'),
('3278','景宁','JingNing','0','387','1'),
('3279','海曙区','HaiShuQu','0','388','1'),
('3280','江东区','JiangDongQu','0','388','1'),
('3281','江北区','JiangBeiQu','0','388','1'),
('3282','镇海区','ZhenHaiQu','0','388','1'),
('3283','北仑区','BeiLunQu','0','388','1'),
('3284','鄞州区','ZhouQu','0','388','1'),
('3285','余姚市','YuYaoShi','0','388','1'),
('3286','慈溪市','CiXiShi','0','388','1'),
('3287','奉化市','FengHuaShi','0','388','1'),
('3288','象山县','XiangShanXian','0','388','1'),
('3289','宁海县','NingHaiXian','0','388','1'),
('3290','越城区','YueChengQu','0','389','1'),
('3291','上虞市','ShangYuShi','0','389','1'),
('3292','嵊州市','ZhouShi','0','389','1'),
('3293','绍兴县','ShaoXingXian','0','389','1'),
('3294','新昌县','XinChangXian','0','389','1'),
('3295','诸暨市','ZhuShi','0','389','1'),
('3296','椒江区','JiaoJiangQu','0','390','1'),
('3297','黄岩区','HuangYanQu','0','390','1'),
('3298','路桥区','LuQiaoQu','0','390','1'),
('3299','温岭市','WenLingShi','0','390','1'),
('3300','临海市','LinHaiShi','0','390','1'),
('3301','玉环县','YuHuanXian','0','390','1'),
('3302','三门县','SanMenXian','0','390','1'),
('3303','天台县','TianTaiXian','0','390','1'),
('3304','仙居县','XianJuXian','0','390','1'),
('3305','鹿城区','LuChengQu','0','391','1'),
('3306','龙湾区','LongWanQu','0','391','1'),
('3307','瓯海区','HaiQu','0','391','1'),
('3308','瑞安市','RuiAnShi','0','391','1'),
('3309','乐清市','LeQingShi','0','391','1'),
('3310','洞头县','DongTouXian','0','391','1'),
('3311','永嘉县','YongJiaXian','0','391','1'),
('3312','平阳县','PingYangXian','0','391','1'),
('3313','苍南县','CangNanXian','0','391','1'),
('3314','文成县','WenChengXian','0','391','1'),
('3315','泰顺县','TaiShunXian','0','391','1'),
('3316','定海区','DingHaiQu','0','392','1'),
('3317','普陀区','PuTuoQu','0','392','1'),
('3318','岱山县','ShanXian','0','392','1'),
('3319','嵊泗县','Xian','0','392','1'),
('3320','衢州市','ZhouShi','0','393','1'),
('3321','江山市','JiangShanShi','0','393','1'),
('3322','常山县','ChangShanXian','0','393','1'),
('3323','开化县','KaiHuaXian','0','393','1'),
('3428','康家洼村','KangJiaWaCun','0','3427','1'),
('3325','合川区','HeChuanQu','0','394','1'),
('3326','江津区','JiangJinQu','0','394','1'),
('3327','南川区','NanChuanQu','0','394','1'),
('3328','永川区','YongChuanQu','0','394','1'),
('3329','南岸区','NanAnQu','0','394','1'),
('3330','渝北区','YuBeiQu','0','394','1'),
('3331','万盛区','WanShengQu','0','394','1'),
('3332','大渡口区','DaDuKouQu','0','394','1'),
('3333','万州区','WanZhouQu','0','394','1'),
('3334','北碚区','BeiQu','0','394','1'),
('3335','沙坪坝区','ShaPingBaQu','0','394','1'),
('3336','巴南区','BaNanQu','0','394','1'),
('3337','涪陵区','FuLingQu','0','394','1'),
('3338','江北区','JiangBeiQu','0','394','1'),
('3339','九龙坡区','JiuLongPoQu','0','394','1'),
('3340','渝中区','YuZhongQu','0','394','1'),
('3341','黔江开发区','QianJiangKaiFaQu','0','394','1'),
('3342','长寿区','ChangShouQu','0','394','1'),
('3343','双桥区','ShuangQiaoQu','0','394','1'),
('3344','綦江县','JiangXian','0','394','1'),
('3345','潼南县','NanXian','0','394','1'),
('3346','铜梁县','TongLiangXian','0','394','1'),
('3347','大足县','DaZuXian','0','394','1'),
('3348','荣昌县','RongChangXian','0','394','1'),
('3349','璧山县','ShanXian','0','394','1'),
('3350','垫江县','DianJiangXian','0','394','1'),
('3351','武隆县','WuLongXian','0','394','1'),
('3352','丰都县','FengDuXian','0','394','1'),
('3353','城口县','ChengKouXian','0','394','1'),
('3354','梁平县','LiangPingXian','0','394','1'),
('3355','开县','KaiXian','0','394','1'),
('3356','巫溪县','WuXiXian','0','394','1'),
('3357','巫山县','WuShanXian','0','394','1'),
('3358','奉节县','FengJieXian','0','394','1'),
('3359','云阳县','YunYangXian','0','394','1'),
('3360','忠县','ZhongXian','0','394','1'),
('3361','石柱','ShiZhu','0','394','1'),
('3362','彭水','PengShui','0','394','1'),
('3363','酉阳','YouYang','0','394','1'),
('3364','秀山','XiuShan','0','394','1'),
('3365','沙田区','ShaTianQu','0','33','1'),
('3366','东区','DongQu','0','33','1'),
('3367','观塘区','GuanTangQu','0','33','1'),
('3368','黄大仙区','HuangDaXianQu','0','33','1'),
('3369','九龙城区','JiuLongChengQu','0','33','1'),
('3370','屯门区','TunMenQu','0','33','1'),
('3371','葵青区','KuiQingQu','0','33','1'),
('3372','元朗区','YuanLangQu','0','33','1'),
('3373','深水埗区','ShenShuiQu','0','33','1'),
('3374','西贡区','XiGongQu','0','33','1'),
('3375','大埔区','DaPuQu','0','33','1'),
('3376','湾仔区','WanZiQu','0','33','1'),
('3377','油尖旺区','YouJianWangQu','0','33','1'),
('3378','北区','BeiQu','0','33','1'),
('3379','南区','NanQu','0','33','1'),
('3380','荃湾区','WanQu','0','33','1'),
('3381','中西区','ZhongXiQu','0','33','1'),
('3382','离岛区','LiDaoQu','0','33','1'),
('3384','台北','TaiBei','0','35','1'),
('3385','高雄','GaoXiong','0','35','1'),
('3386','基隆','JiLong','0','35','1'),
('3387','台中','TaiZhong','0','35','1'),
('3388','台南','TaiNan','0','35','1'),
('3389','新竹','XinZhu','0','35','1'),
('3390','嘉义','JiaYi','0','35','1'),
('3391','宜兰县','YiLanXian','0','35','1'),
('3392','桃园县','TaoYuanXian','0','35','1'),
('3393','苗栗县','MiaoLiXian','0','35','1'),
('3394','彰化县','ZhangHuaXian','0','35','1'),
('3395','南投县','NanTouXian','0','35','1'),
('3396','云林县','YunLinXian','0','35','1'),
('3397','屏东县','PingDongXian','0','35','1'),
('3398','台东县','TaiDongXian','0','35','1'),
('3399','花莲县','HuaLianXian','0','35','1'),
('3400','澎湖县','PengHuXian','0','35','1'),
('3401','合肥','HeFei','0','3','1'),
('3402','庐阳区','LuYangQu','0','3401','1'),
('3403','瑶海区','YaoHaiQu','0','3401','1'),
('3404','蜀山区','ShuShanQu','0','3401','1'),
('3405','包河区','BaoHeQu','0','3401','1'),
('3406','长丰县','ChangFengXian','0','3401','1'),
('3407','肥东县','FeiDongXian','0','3401','1'),
('3408','肥西县','FeiXiXian','0','3401','1'),
('3431','圣佛堂村','ShengFoTangCun','0','3427','1'),
('3430','东盖村','DongGaiCun','0','3427','1'),
('3427','第什营乡','DiShiYingXiang','0','1231','1');

INSERT INTO `youdian_attribute` VALUES
('2','1','Parent','int','所属频道','channelselect','0','',NULL,NULL,'',NULL,NULL,NULL,'22','0','1','1'),
('3','1','Child','varchar','子类频道','select','50','270px',NULL,NULL,'',NULL,NULL,NULL,'22','0','0','0'),
('4','1','ChannelName','varchar','频道名称','text','1','270px',NULL,'textinput',NULL,'',NULL,NULL,'22','1','1','0'),
('5','1','ChannelSName','varchar','简短名称','text','8','270px','','textinput','','如：新闻、图片、文章等','0','','22','0','1','0'),
('6','1','ChannelContent','text','详细内容','editor','5','100%','300px',NULL,NULL,NULL,NULL,NULL,'24','0','1','0'),
('7','1','ChannelSContent','text','简短内容','textarea','4','100%','65px',NULL,NULL,NULL,NULL,NULL,'24','0','1','0'),
('8','1','ChannelModelID','int','频道模型','modelselect','3','','',NULL,NULL,NULL,NULL,NULL,'22','0','1','0'),
('9','1','ChannelTarget','varchar','链接目标','select','7',NULL,NULL,NULL,'_self|当前窗口_self\r\n_blank|新窗口_blank','',NULL,NULL,'22','0','1','0'),
('10','1','HasPicture','int','是否启用代表图片','radio','2',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'24','0','0','0'),
('11','1','ChannelPicture','varchar','频道代表图片','image','2','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'24','0','1','0'),
('12','1','Keywords','varchar','页面关键词Keywords','text','12','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'23','0','1','1'),
('13','1','Description','varchar(512)','页面描述Description','textarea','13','100%',NULL,NULL,NULL,'设置页面描述，留空表示继承上级频道设置！建议不要超过200个字符！',NULL,NULL,'23','0','1','1'),
('14','1','PageSize','int','分页条数','text','10','270px',NULL,'textinput','20',NULL,NULL,NULL,'22','0','1','0'),
('15','1','ChannelOrder','int','频道排序','text','9','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'22','0','1','0'),
('16','1','IndexTemplate','varchar','频道首页模板','text','5','270px',NULL,'textinput','article.html','请输入模板文件名称，以html为扩展名！如：article.html',NULL,NULL,'22','0','1','0'),
('17','1','ReadTemplate','varchar','频道阅读模板','text','6','270px',NULL,'textinput','showarticle.html','请输入模板文件名称，以html为扩展名！如：showarticle.html',NULL,NULL,'22','0','1','0'),
('18','1','IsEnable','int','是否启用频道','radio','18',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'22','0','1','0'),
('19','1','IsLock','int','频道是否锁定','radio','17',NULL,NULL,NULL,'1|锁定\r\n0|不锁定|1',NULL,NULL,NULL,'22','0','1','0'),
('20','1','IsShow','int','频道是否显示','radio','16',NULL,NULL,NULL,'1|显示|1\r\n0|隐藏',NULL,NULL,NULL,'22','0','1','0'),
('21','1','IsSystem','int','是否是系统频道','radio','21',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'22','0','0','0'),
('22','1',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('23','1',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('24','1',NULL,NULL,'频道内容',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('25','2','SpecialID','int','专题编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'30','0','2','0'),
('26','2','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,'所有频道',NULL,NULL,NULL,'30','0','1','0'),
('27','2','SpecialName','varchar','专题名称','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'30','1','1','0'),
('28','2','SpecialDescription','varchar','专题描述','textarea','5','100%','100px',NULL,NULL,NULL,NULL,NULL,'30','0','1','0'),
('29','2','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'30','0','1','0'),
('30','2',NULL,NULL,'专题信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('31','2','SpecialOrder','int','专题排序','text','4',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'30','0','1','0'),
('32','30','InfoID','int','信息ID','text','1','','','textinput','','','0','','54','0','0','1'),
('33','30','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'54','0','1','1'),
('34','30','SpecialID','varchar','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'54','0','1','1'),
('35','30','InfoTitle','varchar','文章标题','text','4','50%','','textinput','','','0','','54','1','1','1'),
('36','30','InfoSContent','varchar','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'54','0','1','0'),
('37','30','InfoContent','varchar','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'54','0','1','0'),
('38','30','HasPicture','int','是否启用代表图片','radio','5','','','','1|启用\n0|禁用|1','','0','','54','0','0','0'),
('39','30','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'54','0','1','0'),
('40','30','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','20','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','55','0','1','1'),
('41','30','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'',NULL,NULL,'55','0','1','0'),
('42','30','HasAttachment','int','是否启用附件','radio','10','','','','1|启用\n0|禁用|1','','0','','55','0','0','0'),
('43','30','IsLinkUrl','int','是否是转向链接','radio','12','','','','1|是\n0|否|1','','0','','55','0','0','1'),
('44','30','LinkUrl','varchar(255)','转向链接','text','13','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.cn','0','','55','0','1','0'),
('45','30','Keywords','varchar','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'56','0','1','1'),
('46','30','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'56','0','1','1'),
('47','30','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'55','0','1','1'),
('48','30','InfoTime','datetime','发表时间','datetime','19','',NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('49','30','InfoAuthor','varchar','作者','text','11','270px','','textinput','','','0','','55','0','0','0'),
('51','30','InfoHit','int','点击次数','text','19','',NULL,'textinput','0',NULL,NULL,NULL,'55','0','1','1'),
('52','30','InfoFrom','varchar','来源','text','18',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('53','30','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'55','0','1','1'),
('54','30',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('55','30',NULL,NULL,'其它信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('56','30',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('57','32',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('58','32',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('59','32','ChannelContent','varchar','详细内容','editor','3','100%','300px',NULL,NULL,NULL,NULL,NULL,'57','0','1','0'),
('60','32','Keywords','varchar','页面关键字Keywords','text','2','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'58','0','1','1'),
('61','32','Description','varchar(512)','页面描述Description','textarea','3','100%',NULL,'textinput',NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'58','0','1','1'),
('62','32','HasPicture','int','是否启用代表图片','radio','2','',NULL,'','1|启用\r\n0|禁用|1',NULL,NULL,NULL,'57','0','0','0'),
('63','32','ChannelPicture','varchar','代表图片','image','1','100%',NULL,'textinput','',NULL,NULL,NULL,'57','0','1','0'),
('64','31',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('65','31',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('66','31',NULL,NULL,'其它信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('67','31','InfoID','int','信息ID','text','1','','','textinput','','',NULL,'','64','0','0','1'),
('68','31','ChannelID','int','所属频道','channelselect','2','','','','','',NULL,'','64','0','1','1'),
('69','31','SpecialID','varchar','所属专题','specialselect','3','','','','','',NULL,'','64','0','1','1'),
('70','31','InfoTitle','varchar','图片标题','text','4','50%','','textinput','','','0','','64','1','1','1'),
('71','31','InfoSContent','varchar','简短内容','textarea','7','100%','70px','','','','0','','64','0','1','0'),
('72','31','InfoContent','varchar','详细内容','editor','8','100%','400px','','','',NULL,'','64','0','1','0'),
('73','31','HasPicture','int','是否启用代表图片','radio','5','','','','1|启用\r\n0|禁用|1',NULL,NULL,NULL,'64','0','0','0'),
('74','31','InfoPicture','varchar(255)','缩略图','image','6','100%','','textinput','','',NULL,'','64','0','1','0'),
('75','31','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','7','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','66','0','1','1'),
('76','31','InfoAttachment','varchar(255)','附件','attachment','1','50%','','textinput','','',NULL,'','66','0','1','0'),
('77','31','HasAttachment','int','是否启用附件','radio','1','','','','1|启用|1\n0|禁用','','0','','66','0','0','0'),
('78','31','InfoAuthor','varchar','作者','text','4','270px','','textinput','','',NULL,'','66','0','0','0'),
('79','31','IsLinkUrl','int','是否是转向链接','radio','2','','','','1|是\n0|否|1','','0','','66','0','0','1'),
('80','31','InfoHit','int','点击次数','text','5','','','textinput','0','',NULL,'','66','0','1','1'),
('81','31','LinkUrl','varchar(255)','转向链接','text','2','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','66','0','1','0'),
('82','31','Keywords','varchar','页面关键词 Keywords','text','1','100%','','textinput','','设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,'','65','0','1','1'),
('83','31','Description','varchar(512)','页面描述 Description','textarea','2','100%','','','','设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,'','65','0','1','1'),
('85','31','InfoTime','datetime','发表时间','datetime','6','','','textinput','','',NULL,'','66','0','1','0'),
('86','31','IsEnable','int','是否启用','radio','29','','','','1|启用|1\r\n0|禁用',NULL,NULL,NULL,'66','0','1','1'),
('87','31','InfoOrder','int','排序','text','3','','','textinput','0','请输入数字，值越小排名越靠前！',NULL,'','66','0','1','1'),
('88','30','LabelID','varchar','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'55','0','1','1'),
('89','31','LabelID','varchar','属性','labelcheckbox','8','','','','','',NULL,'','66','0','1','1'),
('90','1','LinkUrl','varchar(255)','转向链接','text','14','270px',NULL,'textinput',NULL,'如：http://www.baidu.com。频道模型为\"链接模型\"时有效！',NULL,NULL,'22','0','1','0'),
('91','33','ChannelTarget','varchar','链接目标','select','2','','','','_self|当前窗口_self\r\n_blank|新窗口_blank',NULL,NULL,NULL,'93','0','1','0'),
('92','33','LinkUrl','varchar(255)','转向链接','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'93','0','1','0'),
('93','33',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('94','33','ChannelName','varchar','频道名称','text','1','270px','','textinput','','',NULL,'','93','1','1','0'),
('95','3','BannerID','int','幻灯片编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','0','0'),
('96','3','BannerName','varchar','幻灯片名称','text','2','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('97','3','BannerImage','varchar','幻灯图片','image','4','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('98','3','BannerUrl','varchar','链接地址','text','5','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('99','3','BannerOrder','int','幻灯片排序','text','6','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'101','0','1','0'),
('100','3','IsEnable','int','是否启用','radio','7',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'101','0','1','0'),
('101','3',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('102','4',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('103','4','SupportID','int','客服编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','0','0','0'),
('104','4','SupportName','varchar','客服名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','1','1','0'),
('105','4','SupportTypeID','int','客服类型','supporttypeselect','3',NULL,NULL,'',NULL,'选择自定义类型，填写自定义客服HTML代码，可实现一键加QQ群、自定义QQ图标、发邮件等高级功能',NULL,NULL,'102','0','1','0'),
('106','4','SupportNumber','varchar','客服号码','textarea','4','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','0','1','0'),
('107','4','SupportOrder','int','客服排序','text','5','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'102','0','1','0'),
('108','4','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'102','0','1','0'),
('109','5','','','基本信息','text',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('110','5','Support3ID','text','第三方客服编号','text','1',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'109','0','0','0'),
('111','5','Support3Js','int','第三方客服Js脚本','textarea','2','100%','300px','textinput',NULL,NULL,NULL,NULL,'109','0','1','0'),
('112','5','IsEnable','int','是否启用','radio','3',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'109','0','1','0'),
('113','9','LinkClassID','int','友情链接分类编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'117','0','0','0'),
('114','9','LinkClassName','varchar','友情链接分类名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'117','1','1','0'),
('115','9','LinkClassOrder','int','友情链接分类排序','text','3','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'117','0','1','0'),
('117','9',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('118','10',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('119','10','LinkID','int','友情链接编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','0','0','0'),
('120','10','LinkClassID','int','链接分类','linkclassselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'118','0','1','0'),
('121','10','LinkType','int','链接类型','radio','1',NULL,NULL,NULL,'1|文字|1\r\n2|图片',NULL,NULL,NULL,'118','0','1','0'),
('122','10','LinkUrl','varchar(255)','链接地址','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','0','1','0'),
('123','10','LinkOrder','int','链接排序','text','7','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'118','0','1','0'),
('124','10','IsEnable','int','是否启用','radio','9',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'118','0','1','0'),
('125','10','LinkName','varchar','链接名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','1','1','0'),
('126','10','LinkLogo','varchar','链接Logo','image','4','420px',NULL,'textinput',NULL,'鼠标移动到文本框可以预览Logo',NULL,NULL,'118','0','1','0'),
('127','10','LinkDescription','varchar','链接描述','textarea','8','100%','100px','textinput',NULL,NULL,NULL,NULL,'118','0','1','0'),
('128','7',NULL,NULL,'招聘信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('129','7','JobID','int','招聘编号','text','1','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','0','0'),
('130','7','JobName','varchar','职位名称','text','2','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','1','1','0'),
('131','7','Education','varchar','学位要求','text','3','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('132','7','Gender','varchar','性别要求','text','4','192px',NULL,'textinput','',NULL,NULL,NULL,'128','0','1','0'),
('133','7','Age','varchar','年龄要求','text','5','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('134','7','Salary','varchar','薪水','text','6','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('135','7','Language','varchar','语言要求','text','7','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('136','7','Number','varchar','招聘人数','text','8','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('137','7','Workplace','varchar','工作地点','text','9','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('138','7','Expiration','varchar','截至日期','text','10','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('139','7','Requirement','varchar','详细要求','editormini','11','100%','250px','textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('140','7','JobOrder','int','职位排序','text','12','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'128','0','1','0'),
('141','7','IsEnable','int','是否启用','radio','14',NULL,NULL,'','1|启用|1\r\n0|禁用',NULL,NULL,NULL,'128','0','1','0'),
('142','7','Time','datetime','发布时间','datetime','13','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('143','8','CommentID','int','评论编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('144','8','InfoID','int','信息ID','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','0','1'),
('145','8','GuestID','int','评论人ID','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('146','8','GuestName','varchar','评论人','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('147','8','GuestIP','varchar','评论人IP','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('148','8','CommentContent','varchar','评论内容','textarea','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('149','8','CommentTime','datetime','评论时间','datetime','7','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('150','8','IsCheck','int','是否审核','radio','8',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'151','0','1','0'),
('151','8','',NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('152','11',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('153','11','AdID','int','广告编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','0','0'),
('154','11','AdTypeID','int','广告类型','adtyperadio','2','',NULL,NULL,NULL,NULL,NULL,NULL,'152','0','1','0'),
('155','11','AdName','varchar','广告名称','text','3','550px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('156','11','AdContent','varchar','广告内容','image','4','100%','100px','textinput',NULL,'',NULL,NULL,'152','0','1','0'),
('157','11','AdUrl','varchar','广告地址','text','5','550px',NULL,'textinput',NULL,'广告地址以http://开头，如：http://www.xx.com',NULL,NULL,'152','0','1','0'),
('158','11','AdDescription','varchar','广告描述','textarea','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('159','11','AdTime','datetime','发布时间','datetime','7','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('160','11','IsEnable','int','是否启用','radio','8',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'152','0','1','0'),
('161','12',NULL,NULL,'添加会员分组',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('162','12','MemberGroupID','int','会员分组ID','text','1','200px',NULL,'',NULL,NULL,NULL,NULL,'161','0','0','0'),
('163','12','MemberGroupName','varchar','会员分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'161','1','1','0'),
('164','12','MemberGroupRemark','varchar','会员分组备注','text','3','200px','','textinput',NULL,NULL,NULL,NULL,'161','0','1','0'),
('165','12','IsSystem','int','是否是系统分组','radio','4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'161','0','0','0'),
('166','13',NULL,NULL,'会员信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('167','13','MemberID','int','会员编号','text','1','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','0','1'),
('168','13','MemberGroupID','int','会员分组','membergroupselect','2','',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('169','13','MemberName','varchar','会员名称','text','3','120px','','textinput','','','0','','166','1','1','1'),
('170','13','MemberGender','int','性别','radio','4',NULL,NULL,NULL,'1|女\r\n0|男|1',NULL,NULL,NULL,'166','0','1','1'),
('171','13','MemberRealName','varchar','真实姓名','text','5','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('172','13','MemberPassword','varchar','密码','text','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','0','1'),
('173','13','MemberBirthday','date','生日','date','7','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('174','13','MemberAddress','varchar','联系地址','text','15','280px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('175','13','MemberPostCode','varchar','邮政编码','text','9','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('176','13','MemberEmail','varchar','电子邮件','text','14','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('177','13','MemberTelephone','varchar','电话','text','11','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('178','13','MemberMobile','varchar','移动电话','text','12','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('179','13','MemberQQ','varchar','QQ','text','14','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('180','13','MemberQuestion','varchar','密保问题','text','17','280px',NULL,'textinput',NULL,'如：我初中地理老师是谁？我爸爸叫什么名字？',NULL,NULL,'166','0','1','1'),
('181','13','MemberAnswer','varchar','密保答案','text','18','280px',NULL,'textinput',NULL,'找回密码的重要依据，认真填写并记牢！',NULL,NULL,'166','0','1','1'),
('182','13','IsCheck','int','是否审核','radio','41',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'166','0','1','1'),
('183','13','LastLoginTime','datetime','最后登录时间','label','21','150px',NULL,'',NULL,NULL,NULL,NULL,'166','0','1','1'),
('184','13','LastLoginIP','varchar','最后登录IP','label','20','150px',NULL,'',NULL,NULL,NULL,NULL,'166','0','1','1'),
('185','13','RegisterTime','datetime','注册时间','label','22','150px',NULL,'',NULL,NULL,NULL,NULL,'166','0','1','1'),
('186','13','IsLock','int','是否锁定','radio','40',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'166','0','1','1'),
('187','13','IsSystem','int','是否系统','radio','42',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'166','0','0','1'),
('188','15','AdminGroupID','int','管理组ID','text','1','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','0','0'),
('189','15','AdminGroupName','varchar','管理组名称','text','2','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','1','1','0'),
('190','15','AdminGroupRemark','varchar','管理组备注','text','3','170px','','textinput',NULL,NULL,NULL,NULL,'193','0','1','0'),
('191','15','MenuPurview','varchar','管理组权限','text','4','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','0','0'),
('192','15','IsSystem','int','是否是系统','radio','5',NULL,NULL,'','1|是\r\n0|否|1',NULL,NULL,NULL,'193','0','0','0'),
('193','15',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('194','14',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('195','14','AdminID','int',NULL,'text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','0','0'),
('196','14','AdminName','varchar','管理员名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'194','1','1','0'),
('197','14','MemberID','int',NULL,'text','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','0','0'),
('198','14','AdminGroupID','int','管理组','admingroupselect','4','',NULL,NULL,NULL,NULL,NULL,NULL,'194','0','1','0'),
('199','14','AdminPassword','varchar','密码','text','5',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'194','0','0','0'),
('200','14','LastLoginTime','varchar','最后登录时间','label','6','200px',NULL,'',NULL,NULL,NULL,NULL,'194','0','1','0'),
('201','14','LastLoginIP','varchar','最后登录IP','label','7','200px',NULL,'',NULL,NULL,NULL,NULL,'194','0','1','0'),
('202','14','IsLock','int','是否锁定','radio','8',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'194','0','1','0'),
('203','14','IsSystem','int','是否是系统','radio','9',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'194','0','0','0'),
('204','16','',NULL,'模板文件',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('205','16','FileName','varchar','文件名称','label','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'204','0','1','0'),
('206','16','FileContent','varchar','文件内容','editor','2','100%','500px',NULL,NULL,NULL,NULL,NULL,'204','0','1','0'),
('207','1','Title','varchar','页面标题Title','text','11','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'23','0','1','1'),
('208','30','Title','varchar','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','56','0','1','1'),
('209','31','Title','varchar','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'65','0','1','1'),
('210','32','Title','varchar','页面标题Title','text','1','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'58','0','1','1'),
('211','17','TagID','int','自定义标签ID','text','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'215','0','0','0'),
('212','17','TagName','varchar','自定义标签名称','text','1','250px',NULL,'textinput',NULL,'名称只能使用英文字母、数字，并且必须以英文字母开头，不能与系统标签同名，否则会覆盖系统标签。在前台通过{$标签名称}调用！',NULL,NULL,'215','1','1','0'),
('213','17','TagDescription','varchar','自定义标签描述','text','2','100%','','textinput',NULL,'',NULL,NULL,'215','0','1','0'),
('214','17','TagContent','varchar','自定义标签内容','editormini','3','100%','315px','textinput',NULL,'',NULL,NULL,'215','0','1','0'),
('215','17',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('216','17','IsEnable','int','是否启用自定义标签','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'215','0','1','0'),
('217','18','LabelID','int','属性标记编号','text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','0','0'),
('218','18','LabelName','varchar','属性标记名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'223','1','1','0'),
('219','18','ChannelModelID','int','所属频道模型','modelselect','3','',NULL,'',NULL,NULL,NULL,NULL,'223','0','1','0'),
('220','18','LabelOrder','int','属性标记排序','text','4','200px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'223','0','1','0'),
('221','18','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','0','0'),
('222','18','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'223','0','1','0'),
('223','18',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('224','32','ChannelSContent','varchar','简短内容','textarea','2','100%','70px','textinput',NULL,NULL,NULL,NULL,'57','0','1','0'),
('225','1','Html','varchar','静态页面名称','text','1','150px',NULL,'textinput',NULL,'设置频道在前台页面显示的静态文件名称，无需添加扩展名，常常以频道名称拼音命名，<b>留空则取频道名称拼音首字母作为页面名称！</b>如：wangzhanjianshe',NULL,NULL,'23','0','1','0'),
('226','19','ChannelModelID','int','频道模型编号','text','0','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','0','0','0'),
('227','19','ChannelModelName','varchar','频道模型名称','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','1','1','0'),
('228','19','ChannelModelOrder','int','频道模型排序','text','2','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'233','0','1','0'),
('229','19','ChannelModelTable','varchar','表名','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','0','0','0'),
('230','19','ChannelModelDescription','varchar','频道模型描述','textarea','4','100%','80px','textinput',NULL,NULL,NULL,NULL,'233','0','1','0'),
('231','19','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'233','0','0','0'),
('232','19','IsEnable','int','是否是启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'233','0','1','0'),
('233','19',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('234','20',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('235','20','AttributeID','int','属性编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','0','0'),
('236','20','ChannelModelID','int','所属频道模型','label','2','',NULL,'',NULL,NULL,NULL,NULL,'234','0','1','0'),
('237','20','FieldName','varchar','字段名称','label','4','',NULL,'',NULL,NULL,NULL,NULL,'234','0','1','0'),
('238','20','FieldType','varchar','字段类型','label','5','200px',NULL,'',NULL,NULL,NULL,NULL,'234','0','1','0'),
('239','20','DisplayName','varchar','显示名称','text','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('240','20','DisplayType','varchar','显示类型','displaytypeselect','7','',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('241','20','DisplayOrder','int','排序','text','8','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'234','0','1','0'),
('242','20','DisplayWidth','varchar','宽度','text','9','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('243','20','DisplayHeight','varchar','高度','text','10','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('244','20','DisplayClass','varchar','样式表类','text','11','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('245','20','DisplayValue','varchar','默认值','textarea','12','280px','85px','textinput',NULL,'格式：值|文本|是否选中(1:表示选中，不填表示未选中)，每项回车分开！例如：1|启用|1',NULL,NULL,'234','0','1','0'),
('246','20','DisplayHelpText','varchar','帮助文字','text','13','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('247','20','IsValidate','int','是否验证','radio','14',NULL,NULL,NULL,'1|启用验证\r\n0|禁用验证|1',NULL,NULL,NULL,'234','0','1','0'),
('248','20','ValidateRule','varchar','验证正则表达式','text','15','300px',NULL,'textinput','',NULL,NULL,NULL,'234','0','1','0'),
('249','20','GroupID','int','所属分组','attributegroupselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'234','0','1','0'),
('250','20','IsEnable','int','是否启用','radio','17',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'234','0','1','0'),
('251','20','IsSystem','int','是否是系统','radio','18',NULL,NULL,NULL,'1|系统|1\r\n0|自定义',NULL,NULL,NULL,'234','0','0','0'),
('252','21',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('253','21','AttributeID','int','字段分组编号','text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'252','0','0','0'),
('254','21','DisplayName','varchar','字段分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'252','1','1','0'),
('255','21','IsEnable','int','是否启用','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'252','0','1','0'),
('256','21','DisplayOrder','int','排序','text','3','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'252','0','1','0'),
('257','30','f1','varchar','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('258','30','f2','varchar','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('259','30','f3','varchar','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('260','30','f4','varchar','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('261','30','f5','varchar','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('262','30',NULL,NULL,'扩展分组1',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('263','30',NULL,NULL,'扩展分组2',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('264','31','f1','varchar','扩展字段1','text','1','200px','','textinput','','','0','','269','0','0','0'),
('265','31','f2','varchar','扩展字段2','text','2','200px','','textinput','','','0','','269','0','0','0'),
('266','31','f3','varchar','扩展字段3','text','3','200px','','textinput','','','0','','269','0','0','0'),
('267','31','f4','varchar','扩展字段4','text','4','200px','','textinput','','','0','','269','0','0','0'),
('268','31','f5','varchar','扩展字段5','text','5','200px','','textinput','','','0','','269','0','0','0'),
('269','31',NULL,NULL,'扩展分组1',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('270','31',NULL,NULL,'扩展分组2',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('271','34',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('272','34',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('273','34',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('274','34',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('275','34',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('276','34','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'271','0','1','1'),
('277','34','SpecialID','varchar(512)','所属专题','specialselect','2','','','','','','0','','271','0','1','1'),
('278','34','InfoTitle','varchar','视频标题','text','3','50%','','textinput','','','0','','271','1','1','1'),
('279','34','InfoSContent','text','简短内容','textarea','7','100%','70px','','','','0','','271','0','1','0'),
('280','34','InfoContent','text','详细内容','editor','8','100%','400px','','','','0','','271','0','1','0'),
('281','34','HasPicture','int','是否启用代表图片','radio','50','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'272','0','0','0'),
('282','34','InfoPicture','varchar(255)','缩略图','image','6','100%','','textinput','','','0','','271','0','1','0'),
('283','34','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','8',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'272','0','1','1'),
('284','34','InfoAttachment','varchar(255)','视频文件','attachment','4','100%','','textinput','','超过5M的视频文件请使用FTP上传！推荐使用<span style=\'color:blue\'>H.264编码的mp4格式</span>，它能在电脑、平板、手机上播放！<a href=\'http://jingyan.baidu.com/article/c1465413b5ebc40bfdfc4c7a.html\' target=\'_blank\'>点击查看：如何转化为H.264编码的mp4格式？</a><br/>推荐将视频上传到第三方视频平台（如：优酷、土豆、搜狐视频等），然后再填写通用代码中的地址','0','','271','0','1','0'),
('285','34','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'272','0','0','0'),
('286','34','IsLinkUrl','int','是否是转向链接','radio','50',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'272','0','0','1'),
('287','34','LinkUrl','varchar(255)','转向链接','text','2','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','272','0','1','0'),
('288','34','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','273','0','1','1'),
('289','34','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'273','0','1','1'),
('290','34','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'273','0','1','1'),
('291','34','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'272','0','1','1'),
('292','34','InfoTime','datetime','时间','datetime','7','',NULL,'textinput',NULL,NULL,NULL,NULL,'272','0','1','1'),
('293','34','InfoAuthor','varchar(50)','作者','text','6','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'272','0','0','0'),
('294','34','InfoHit','int','点击次数','text','5','',NULL,'textinput','0',NULL,NULL,NULL,'272','0','1','1'),
('295','34','InfoFrom','varchar(50)','来源','text','4','','','textinput','','','0','','272','0','1','0'),
('296','34','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'272','0','1','1'),
('297','34','LabelID','varchar(512)','属性','labelcheckbox','9','','','','','','0','','272','0','1','1'),
('298','34','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('299','34','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('300','34','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('301','34','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','0','0'),
('302','34','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','0','0'),
('303','35',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('304','35',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('305','35',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('306','35',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('307','35',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('308','35','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'303','0','1','1'),
('309','35','SpecialID','varchar(512)','所属专题','specialselect','1','','','','','','0','','303','0','1','1'),
('310','35','InfoTitle','varchar','下载标题','text','2','50%','','textinput','','','0','','303','1','1','1'),
('311','35','InfoSContent','text','简短内容','textarea','7','100%','70px','','','','0','','303','0','0','0'),
('312','35','InfoContent','text','详细内容','editor','8','100%','400px','','','','0','','303','0','1','0'),
('313','35','HasPicture','int','是否启用代表图片','radio','50','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'304','0','0','0'),
('314','35','InfoPicture','varchar(255)','缩略图','image','4','100%','','textinput','','','0','','303','0','1','0'),
('315','35','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','6','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','304','0','1','1'),
('316','35','InfoAttachment','varchar(255)','附件','attachment','3','50%','','textinput','','','0','','303','0','1','0'),
('317','35','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'304','0','0','0'),
('318','35','IsLinkUrl','int','是否是转向链接','radio','12','','','','1|是\n0|否|1','','0','','303','0','0','1'),
('319','35','LinkUrl','varchar(255)','转向链接','text','1','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','304','0','1','0'),
('320','35','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','305','0','1','1'),
('321','35','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'305','0','1','1'),
('322','35','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'305','0','1','1'),
('323','35','InfoOrder','int','排序','text','2','','','textinput','0','请输入数字，值越小排名越靠前！','0','','304','0','1','1'),
('324','35','InfoTime','datetime','时间','datetime','5','','','textinput','','','0','','304','0','1','1'),
('325','35','InfoAuthor','varchar(50)','作者','text','3','270px','','textinput','','','0','','304','0','1','0'),
('326','35','InfoHit','int','点击次数','text','4','','','textinput','0','','0','','304','0','1','1'),
('327','35','InfoFrom','varchar(50)','来源','text','3','','','textinput','','','0','','304','0','1','0'),
('328','35','IsEnable','int','是否启用','radio','23','','','','1|启用|1\r\n0|禁用','','0','','304','0','1','1'),
('329','35','LabelID','varchar(512)','属性','labelcheckbox','7','','','','','','0','','304','0','1','1'),
('330','35','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('331','35','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('332','35','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('333','35','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','0','0'),
('334','35','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','0','0'),
('335','36',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('336','36',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('337','36',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('338','36',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('339','36',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('340','36','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'335','0','1','1'),
('341','36','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'336','0','0','1'),
('342','36','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'335','1','1','1'),
('343','36','InfoSContent','text','简短内容','textarea','7','100%','70px','','','','0','','336','0','0','0'),
('344','36','InfoContent','text','产品详情','editor','8','100%','400px','','','','0','','335','0','1','0'),
('345','36','HasPicture','int','是否启用代表图片','radio','50','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'336','0','0','0'),
('346','36','InfoPicture','varchar(255)','缩略图','image','6','100%','','textinput','','','0','','335','0','1','0'),
('347','36','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','7','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','336','0','1','1'),
('348','36','InfoAttachment','varchar(255)','附件','attachment','1','50%','','textinput','','启用附件后有效！','0','','336','0','1','0'),
('349','36','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'336','0','0','0'),
('350','36','IsLinkUrl','int','是否是转向链接','radio','50',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'336','0','0','1'),
('351','36','LinkUrl','varchar(255)','转向链接','text','2','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','336','0','1','0'),
('352','36','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','337','0','1','1'),
('353','36','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'337','0','1','1'),
('354','36','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'337','0','1','1'),
('355','36','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'336','0','1','1'),
('356','36','InfoTime','datetime','时间','datetime','6','',NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','1','1'),
('357','36','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','0','0'),
('358','36','InfoHit','int','点击次数','text','5','270px',NULL,'textinput','0',NULL,NULL,NULL,'336','0','1','1'),
('359','36','InfoFrom','varchar(50)','来源','text','4',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','0','0'),
('360','36','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'336','0','1','1'),
('361','36','LabelID','varchar(512)','属性','labelcheckbox','8','','','','','','0','','336','0','1','1'),
('362','36','f1','varchar(255)','扩展字段1','text','2','200px','','textinput','','','0','','338','0','0','0'),
('363','36','f2','varchar(255)','编号','text','2','200px','','textinput','','','0','','335','0','1','0'),
('364','36','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'338','0','0','0'),
('365','36','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','0','0'),
('366','36','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','0','0'),
('367','37',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('368','37',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('369','37',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','1'),
('370','37',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('371','37',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('372','37','ChannelID','int','所属频道','channelselect','0','','','','','','0','','368','0','1','1'),
('373','37','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'368','0','0','1'),
('374','37','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'367','1','1','1'),
('375','37','InfoSContent','text','内容','textarea','7','100%','70px','','','','0','','367','0','1','0'),
('376','37','InfoContent','text','详细内容','editor','8','100%','400px','','','','0','','368','0','0','0'),
('377','37','HasPicture','int','是否启用代表图片','radio','5','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'368','0','0','0'),
('378','37','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('379','37','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'368','0','1','1'),
('380','37','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'368','0','0','0'),
('381','37','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'368','0','0','0'),
('382','37','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'368','0','0','1'),
('383','37','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'368','0','0','0'),
('384','37','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','369','0','1','1'),
('385','37','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'369','0','1','1'),
('386','37','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'369','0','1','1'),
('387','37','InfoOrder','int','排序','text','16','','','textinput','0','请输入数字，值越小排名越靠前！','0','','368','0','1','1'),
('388','37','InfoTime','datetime','时间','datetime','17','','','textinput','','','0','','368','0','1','1'),
('389','37','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('390','37','InfoHit','int','点击次数','text','19','270px','','textinput','0','','0','','368','0','1','1'),
('391','37','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('392','37','IsEnable','int','是否启用','radio','21','','','','1|启用|1\r\n0|禁用','','0','','368','0','1','1'),
('393','37','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'368','0','0','1'),
('394','37','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('395','37','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('396','37','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('397','37','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','0','0'),
('398','37','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','0','0'),
('399','38',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('400','38',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('401','38',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('402','38',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('403','38',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('404','38','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'399','0','1','1'),
('405','38','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'400','0','0','1'),
('406','38','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'399','1','1','1'),
('407','38','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'400','0','0','0'),
('408','38','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'400','0','0','0'),
('409','38','HasPicture','int','是否启用代表图片','radio','5','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'400','0','0','0'),
('410','38','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('411','38','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'400','0','1','1'),
('412','38','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'400','0','0','0'),
('413','38','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'400','0','0','0'),
('414','38','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'400','0','0','1'),
('415','38','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'400','0','0','0'),
('416','38','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','401','0','1','1'),
('417','38','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'401','0','1','1'),
('418','38','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'401','0','1','1'),
('419','38','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'399','0','1','1'),
('420','38','InfoTime','datetime','时间','datetime','17','',NULL,'textinput',NULL,NULL,NULL,NULL,'399','0','1','1'),
('421','38','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('422','38','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,NULL,NULL,'399','0','1','1'),
('423','38','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('424','38','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'399','0','1','1'),
('425','38','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'400','0','0','1'),
('426','38','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('427','38','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('428','38','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('429','38','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','0','0'),
('430','38','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','0','0'),
('431','39',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('432','39',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('433','39',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('434','39',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('435','39',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('436','39','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'431','0','1','1'),
('437','39','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'432','0','0','1'),
('438','39','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'431','1','1','1'),
('439','39','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'432','0','0','0'),
('440','39','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'432','0','0','0'),
('441','39','HasPicture','int','是否启用代表图片','radio','5','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'432','0','0','0'),
('442','39','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('443','39','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'432','0','1','1'),
('444','39','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'432','0','0','0'),
('445','39','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'432','0','0','0'),
('446','39','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'432','0','0','1'),
('447','39','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'432','0','0','0'),
('448','39','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','433','0','1','1'),
('449','39','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'433','0','1','1'),
('450','39','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'433','0','1','1'),
('451','39','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'431','0','1','1'),
('452','39','InfoTime','datetime','时间','datetime','17','',NULL,'textinput',NULL,NULL,NULL,NULL,'431','0','1','1'),
('453','39','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('454','39','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,NULL,NULL,'431','0','1','1'),
('455','39','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('456','39','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'431','0','1','1'),
('457','39','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'432','0','0','1'),
('458','39','f1','text','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('459','39','f2','text','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('460','39','f3','text','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('461','39','f4','text','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','0','0'),
('462','39','f5','text','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','0','0'),
('463','30','IsCheck','int','是否审核','radio','22',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'55','0','1','1'),
('464','31','IsCheck','int','是否审核','radio','28',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'66','0','1','1'),
('465','38','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'399','0','1','1'),
('466','39','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'431','0','1','1'),
('467','34','IsCheck','int','是否审核','radio','22','','','','1|已审核|1\r\n0|未审核','','0','','272','0','1','1'),
('468','35','IsCheck','int','是否审核','radio','22','','','','1|已审核|1\r\n0|未审核','','0','','304','0','1','1'),
('469','36','IsCheck','int','是否审核','radio','20','','','','1|已审核|1\r\n0|未审核','','0','','336','0','1','1'),
('470','37','IsCheck','int','是否审核','radio','20','','','','1|已审核|1\r\n0|未审核','','0','','368','0','1','1'),
('471','22','BannerGroupID','int','幻灯分组编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'474','0','0','0'),
('472','22','BannerGroupName','varchar(50)','幻灯分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'474','1','1','0'),
('473','22','IsSystem','int','是否是系统','radio','4',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'474','0','0','0'),
('474','22','BannerGroupID','int','基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('475','3','BannerGroupID','int','所属幻灯分组','bannergroupselect','3',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('476','22','BannerGroupOrder','int','幻灯分组排序','text','3','200px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'474','0','1','0'),
('477','1','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','15','','','textinput','','不勾选则继承父级频道的阅读权限！若父级频道未设置，则游客也可以访问！启用Html静态缓存后无效','0','','22','0','1','1'),
('478','13','f1','text','扩展字段1','text','25','200px','','textinput','','','0','','483','0','0','0'),
('479','13','f2','text','扩展字段2','text','26','200px','','textinput','','','0','','483','0','0','0'),
('480','13','f3','text','扩展字段3','text','27','200px','','textinput','','','0','','483','0','0','0'),
('481','13','f4','text','扩展字段4','text','28','200px','','textinput','','','0','','483','0','0','0'),
('482','13','f5','text','扩展字段5','text','29','200px','','textinput','','','0','','483','0','0','0'),
('483','13',NULL,NULL,'其它信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('484','32','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承父级频道的阅读权限！若父级频道未设置，则游客也可以访问！启用Html静态缓存后无效',NULL,NULL,'57','0','1','1'),
('485','20','IsRequire','int','是否是必填字段','radio','16',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'234','0','1','0'),
('486','1','IsHtml','int','是否启用Html静态缓存','radio','19',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成频道Html静态缓存',NULL,NULL,'22','0','1','0'),
('487','30','IsHtml','int','是否启用Html静态缓存','radio','24',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'55','0','1','0'),
('488','31','IsHtml','int','是否启用Html静态缓存','radio','30','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','66','0','1','0'),
('489','34','IsHtml','int','是否启用Html静态缓存','radio','24','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','272','0','1','0'),
('490','35','IsHtml','int','是否启用Html静态缓存','radio','24','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','304','0','1','0'),
('491','36','IsHtml','int','是否启用Html静态缓存','radio','22','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','336','0','1','0'),
('492','37','IsHtml','int','是否启用Html静态缓存','radio','22','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','368','0','1','0'),
('493','38','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'399','0','1','0'),
('494','39','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'431','0','1','0'),
('495','30','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'56','0','1','0'),
('496','31','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'65','0','1','0'),
('497','34','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'273','0','1','0'),
('498','35','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'305','0','1','0'),
('499','36','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'337','0','1','0'),
('500','37','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'369','0','1','0'),
('501','38','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'401','0','1','0'),
('502','39','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'433','0','1','0'),
('503','32','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置频道在前台页面显示的静态文件名称，无需添加扩展名，常常以频道名称拼音命名，<b>留空则取频道名称拼音首字母作为页面名称！</b>如：wangzhanjianshe',NULL,NULL,'58','0','1','0'),
('504','1',NULL,NULL,'其它信息',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('505','1','f1','text','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('506','1','f2','text','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('507','1','f3','text','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('508','23','MailClassName','varchar','邮件订阅分类名称','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'512','0','1','0'),
('509','23','MailClassOrder','int','邮件订阅分类排序','text','2','270px','','textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'512','0','1','0'),
('510','23','MailClassDescription','varchar','邮件订阅分类描述','textarea','3','100%','80px','textinput',NULL,NULL,NULL,NULL,'512','0','1','0'),
('511','23','IsEnable','int','是否启用','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'512','0','1','0'),
('512','23',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('513','24','MailClassID','int','所属订阅分类','mailclassselect','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'521','0','1','0'),
('514','24','MailAccount','varchar','邮箱帐号','text','2','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','1','1','0'),
('515','24','Name','varchar','姓名','text','3','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('516','24','Telephone','varchar','电话','text','4','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('517','24','Address','varchar','地址','text','5','370px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('518','24','AddTime','datetime','添加时间','datetime','6','',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('519','24','Remark','varchar','备注','textarea','7','100%','80px','textinput','',NULL,NULL,NULL,'521','0','1','0'),
('520','24','IsEnable','int','是否启用','radio','8',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'521','0','1','0'),
('521','24',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('522','25',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('523','25','MailTitle','varchar','邮件主题','text','1','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'522','1','1','0'),
('524','25','MailContent','varchar','邮件内容','editormini','2','100%','300px','textinput',NULL,NULL,NULL,NULL,'522','0','1','0'),
('525','25','AddTime','datetime','添加时间','datetime','3',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'522','0','1','0'),
('526','1','ChannelIcon','varchar','频道图标','imageex','4','500px',NULL,'textinput',NULL,'设置手机/微信网站频道图标，建议图片尺寸不大于64x64',NULL,NULL,'504','0','1','0'),
('527','1','ChannelStyle','varchar','频道首页模板排版样式','radio','5',NULL,NULL,'','0|默认|1\r\n1|图文\r\n2|文字\r\n3|橱窗\r\n4|相册','设置手机/微信网站频道首页模板样式，是否有效取决于模板是否实现当前功能',NULL,NULL,'504','0','1','0'),
('528','6','','','基本信息','','0','',NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('529','6','GuestName','varchar','姓名,name','text','14','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('530','6','Contact','varchar','电话,telephone','text','15','100%','','','','','1','^(0|86|17951)?(13[0-9]|15[012356789]|17[678]|18[0-9]|14[57])[0-9]{8}$','528','0','1','0'),
('531','6','MessageTitle','varchar','标题,Title','text','5','100%','','','','','0','','528','1','1','0'),
('532','6','MessageContent','text','内容,content','textarea','10','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('533','6','f1','text','字段1','textarea','30','100%','','','','','0','','528','0','0','0'),
('534','6','f2','text','字段2','textarea','30','100%','','','','','0','','528','0','0','0'),
('535','6','f3','text','字段3','textarea','30','100%','','','','','0','','528','0','0','0'),
('536','6','f4','text','字段4','textarea','30','100%','','','','','0','','528','0','0','0'),
('537','6','f5','text','字段5','text','30','100%','','','','','0','','528','1','0','0'),
('540','6','Email','text','Email','text','29','100%','','','','','0','','528','0','0','0'),
('541','6','Address','text','地址,address','text','29','100%','','','','','0','','528','0','0','0'),
('542','6','Gender','text','性别,gender','radio','29','100%','','','女|女|1\r\n男|男','','1','','528','0','0','0'),
('543','6','QQ','text','QQ','text','20','100%','','','','','0','','528','0','0','0'),
('544','26',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('545','26','GuestName','text','姓名,name','text','1','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('546','26','Quantity','text','订购数量,number','text','2','100%','','','','','0','','544','0','1','0'),
('547','26','Telephone','text','电话,telephone','text','3','100%','','','','','0','','544','0','1','0'),
('548','26','QQ','text','QQ','text','4','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('549','26','Email','text','Email','text','5','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('550','26','Address','text','地址,address','text','6','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('551','26','Remark','text','备注,remark','textarea','7','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('552','26','f1','text','字段1','textarea','8','100%','','','','','0','','544','0','0','0'),
('553','26','f2','text','字段2','textarea','9','100%','','','','','0','','544','0','0','0'),
('554','26','f3','text','字段3','textarea','10','100%','','','','','0','','544','0','0','0'),
('555','26','f4','text','字段4','textarea','11','100%','','','','','0','','544','0','0','0'),
('556','26','f5','text','字段5','textarea','12','100%','','','','','0','','544','0','0','0'),
('557','26','ProductName','text','订购产品,Product','text','0','100%','','','','','0','','544','0','1','0'),
('558','3','BannerThumbnail','varchar','缩略图','imageex','4','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('559','3','BannerDescription','text','幻灯片说明','textarea','6','100%','80px','textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('560','19','IndexTemplate','varchar','默认首页模板','text','3','200px',NULL,'textinput',NULL,'设置当前模型默认的模板文件名，建议使用小写字母，如：article.html',NULL,NULL,'233','0','1','0'),
('561','19','ReadTemplate','varchar','默认阅读模板','text','4','200px',NULL,'textinput',NULL,'设置当前模型默认的模板文件名，建议使用小写字母，如：showarticle.html',NULL,NULL,'233','0','1','0'),
('562','11','AdGroupID','int','所属广告位','adgroupselect','4',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('563','11','AdOrder','int','广告排序','text','5','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'152','0','1','0'),
('564','30',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('565','31',NULL,NULL,'相册/相关信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('566','34',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('567','35',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('568','36',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('569','37',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('570','38',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('571','39',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('572','30','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'564','0','1','0'),
('573','30','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'564','0','1','0'),
('574','31','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'565','0','1','0'),
('575','31','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'565','0','1','0'),
('576','34','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'566','0','1','0'),
('577','34','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'566','0','1','0'),
('578','35','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'567','0','1','0'),
('579','35','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'567','0','1','0'),
('580','36','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'568','0','1','0'),
('581','36','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'568','0','1','0'),
('582','37','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'569','0','1','0'),
('583','37','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'569','0','1','0'),
('584','38','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'570','0','1','0'),
('585','38','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'570','0','1','0'),
('586','39','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'571','0','1','0'),
('587','39','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'571','0','1','0'),
('588','39','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'433','0','1','1'),
('589','38','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'401','0','1','1'),
('590','37','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'369','0','1','1'),
('591','36','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'337','0','1','1'),
('592','35','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'305','0','1','1'),
('593','34','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'273','0','1','1'),
('594','31','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'65','0','1','1'),
('595','30','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'56','0','1','1'),
('596','39','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'432','0','0','0'),
('597','38','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'400','0','0','0'),
('598','37','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'368','0','0','0'),
('599','36','InfoPrice','double','本店售价','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'335','0','1','0'),
('600','35','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'304','0','0','0'),
('601','34','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'272','0','0','0'),
('602','31','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'66','0','0','0'),
('603','30','InfoPrice','double','本店售价','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'55','0','0','0'),
('604','1',NULL,NULL,'相册/相关信息',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('605','1','ChannelAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'604','0','1','0'),
('606','1','ChannelRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'604','0','1','0'),
('607','39','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1','',NULL,'','0',NULL,NULL,NULL,'431','0','1','0'),
('608','38','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1','',NULL,'','0',NULL,NULL,NULL,'399','0','1','0'),
('609','37','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1','',NULL,'','0',NULL,NULL,NULL,'368','0','1','0'),
('610','36','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1','',NULL,'','0',NULL,NULL,NULL,'335','0','1','0'),
('611','35','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1','',NULL,'','0',NULL,NULL,NULL,'303','0','1','0'),
('612','34','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1','',NULL,'','0',NULL,NULL,NULL,'271','0','1','0'),
('613','31','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','3','',NULL,'','0',NULL,NULL,NULL,'64','0','1','0'),
('614','30','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','3','',NULL,'','0',NULL,NULL,NULL,'54','0','1','0'),
('615','13','MemberAvatar','varchar','头像','image','4','400px',NULL,'textinput',NULL,'头像尺寸建议为80 x 80',NULL,NULL,'166','0','1','0'),
('616','30',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('617','31',NULL,NULL,'属性规格',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('618','34',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('619','35',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('620','36',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('621','37',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('622','38',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('623','39',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('624','39','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'623','0','1','1'),
('625','38','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'622','0','1','1'),
('626','37','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'621','0','1','1'),
('627','36','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'620','0','1','1'),
('628','35','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'619','0','1','1'),
('629','34','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'618','0','1','1'),
('630','31','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'617','0','1','1'),
('631','30','TypeID','int','信息类型','typeselect','1','',NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'616','0','1','1'),
('632','39','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'435','0','1','0'),
('633','38','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'403','0','1','0'),
('634','37','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'371','0','1','0'),
('635','36','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'339','0','1','0'),
('636','35','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'307','0','1','0'),
('637','34','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'275','0','1','0'),
('638','31','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'270','0','1','0'),
('639','30','ProvinceID','int','地区','areaselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'263','0','1','0'),
('640','39','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'431','0','0','0'),
('641','38','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'399','0','0','0'),
('642','37','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'368','0','0','0'),
('643','36','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'335','0','1','0'),
('644','35','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'303','0','0','0'),
('645','34','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'271','0','0','0'),
('646','31','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'64','0','0','0'),
('647','30','StockCount','int','库存数量','text','10','80px',NULL,'textinput','9999',NULL,NULL,NULL,'54','0','0','0'),
('648','39','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'431','0','0','0'),
('649','38','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'399','0','0','0'),
('650','37','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'368','0','0','0'),
('651','36','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0','购买此商品并付款后，将获得的积分',NULL,NULL,'335','0','1','0'),
('652','35','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'303','0','0','0'),
('653','34','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'271','0','0','0'),
('654','31','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'64','0','0','0'),
('655','30','GivePoint','int','赠送积分','text','13','80px',NULL,'textinput','0',NULL,NULL,NULL,'54','0','0','0'),
('656','39','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'431','0','0','0'),
('657','38','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'399','0','0','0'),
('658','37','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'368','0','0','0'),
('659','36','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0','积分兑换此商品时，可以使用的最多积分',NULL,NULL,'335','0','1','0'),
('660','35','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'303','0','0','0'),
('661','34','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'271','0','0','0'),
('662','31','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'64','0','0','0'),
('663','30','ExchangePoint','int','兑换积分','text','16','80px',NULL,'textinput','0',NULL,NULL,NULL,'54','0','0','0'),
('664','39','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'431','0','0','0'),
('665','38','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'399','0','0','0'),
('666','37','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'368','0','0','0'),
('667','36','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'335','0','1','0'),
('668','35','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'303','0','0','0'),
('669','34','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'271','0','0','0'),
('670','31','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'64','0','0','0'),
('671','30','MarketPrice','double','市场价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'54','0','0','0'),
('672','39','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','1','0'),
('673','38','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','1','0'),
('674','37','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','1','0'),
('675','36','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','1','0'),
('676','35','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','1','0'),
('677','34','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','1','0'),
('678','31','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'270','0','1','0'),
('679','30','Longitude','double','地理坐标','coordinate','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'263','0','1','0'),
('680','39','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'431','0','0','0'),
('681','38','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'399','0','0','0'),
('682','37','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'368','0','0','0'),
('683','36','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'335','0','1','0'),
('684','35','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'303','0','0','0'),
('685','34','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'271','0','0','0'),
('686','31','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'64','0','0','0'),
('687','30','Commission','double','佣金','text','10','80px',NULL,'textinput','0','用于分销的分成金额',NULL,NULL,'54','0','0','0');

INSERT INTO `youdian_banner` VALUES
('3','','1','/Upload/banner/2.jpg','','https://www.baidu.com/','1','#fff','1','1'),
('4','','1','/Upload/banner/1.jpg','','https://www.baidu.com/','0','#fff','1','1'),
('5','','2','/Upload/banner/2en.jpg','','','0','#2169b1','1','2'),
('6','','2','/Upload/banner/1en.jpg','','','0','#2B8A0E','1','2'),
('7','','3','/Upload/banner/10.jpg','','','0','','1','1'),
('8','','3','/Upload/banner/11.jpg','','','0','','1','1'),
('9','','4','/Upload/banner/10en.jpg','','','0','','1','2'),
('10','','4','/Upload/banner/11en.jpg','','','0','','1','2');

INSERT INTO `youdian_banner_group` VALUES
('1','首页幻灯分组','4','1','1'),
('2','banner group of home','0','1','2'),
('3','手机幻灯片分组','0','0','1'),
('4','banner grounp of mobile','0','0','2');

INSERT INTO `youdian_cart` VALUES
('1','59','1','2','1',''),
('2','54','1','2','1',''),
('3','55','1','2','1',''),
('4','50','1','2','1',''),
('5','59','1','9','1','7,14'),
('6','59','1','9','1','8,14');

INSERT INTO `youdian_channel` VALUES
('1','0','0','网站首页','','','','33','_self','','1','','','','','index','','20','0','index.html','','1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/public/logo.png','0',NULL,NULL),
('2','0','0','Home','','','','33','_self','','0','','','','','index','','20','0','index.html','read.html','1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/public/logo.png','0',NULL,NULL),
('4','0','0','Job','','','','33','_self','','0','','','','','job','','20','70','job.html','','1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/icon/4.jpg','0',NULL,NULL),
('5','0','0','Guestbook','','','','33','_self','','0','','','','','guestbook','','20','71','guestbook.html','','1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/icon/5.jpg','0',NULL,NULL),
('6','0','0','在线订购','','','','33','_self','','0','','','','','order',NULL,'20','7','order.html','','1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/6.jpg','0',NULL,NULL),
('7','0','0','Order','','','','33','_self','','1','','','','','order',NULL,'20','6','order.html','read.html','1','1','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/7.jpg','0',NULL,NULL),
('8','0','0','人才招聘','招聘','','','33','_self','','1','','','','','job','','20','70','job.html','','1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/icon/8.jpg','0',NULL,NULL),
('9','0','0','在线留言','','','','33','_self','','1','','','','','guestbook',NULL,'20','75','guestbook.html','','1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/icon/9.jpg','0',NULL,NULL),
('10','0','0','投递简历','',NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'resume',NULL,'20','20','resume.html','','1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/10.jpg','0',NULL,NULL),
('11','0','0','Resume','','','','33','_self','','0','','','','','resume',NULL,'20','20','resume.html','','1','1','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/11.jpg','0',NULL,NULL),
('15','0','1','关于我们','','<p><img alt=\"\" class=\"left\" src=\"/Upload/public/aboutus1.jpg\" style=\"width: 500px; height: 333px; float: left; margin-right: 20px;\" /><span style=\"line-height:1.8em;\">某某电子有限公司成立于2000年，注册资金1000万，员工40余人，是一家专业做电子电气的公司。优秀的员工，先进的技术，精良的设备，严格的管理是公司得以不断发展养大、产品能够赢得用户依靠的根本所在。&ldquo;可靠、专业&rdquo;是我们生产精神和服务信念。</span><br />\r\n<br />\r\n<span style=\"line-height:1.8em;\">公​司在坚持技术创新的基础上，狠抓质量管理，不断提高服务水平，实现了公司业务的良性发展民主评议党员总结，我们用心参与推广以及行业交流活动，公司在长期的发展过程中以过硬的产品质量、良好的产品性能、领先的技术优势和国内许多大型的厂都建立了长期良好的合作伙伴关联，我们也热诚欢迎国内外客户来我司考察，参观及技术交流！</span></p>\r\n\r\n<p align=\"justify\"><br />\r\n<span style=\"line-height:2em;\"><span style=\"font-size:18px;\"><span style=\"color:#000000;\"><strong>我们的服务宗旨是：</strong></span></span></span></p>\r\n\r\n<p align=\"justify\"><span style=\"line-height:1.8em;\">诚实、公正、守信、价格合理、平等互利。</span></p>\r\n\r\n<p align=\"justify\"><span style=\"line-height:1.8em;\">公司凭借雄厚经济实力，恪守诚信为本的原则，得了众多客户的信赖，并在业界获得好的口碑。建立了稳固的合作关系，随着业务的不断发展和壮大，合作伙伴的范围也在不断扩大。我们热情盼望与您的合作，为社会的可持续发展献上一份努力。&nbsp;</span><br />\r\n<br />\r\n<span style=\"line-height:2em;\"><span style=\"font-size:18px;\"><span style=\"color:#000000;\"><span align=\"justify\"><strong>我们的使命：</strong></span></span></span></span><br />\r\n<span style=\"line-height:1.8em;\">公司在运营过程中秉承&ldquo;产品适用、价格适中、服务优质&rdquo;的营销理念，专注于仪器仪表、进出口贸易、计算机软件的开发、生产、销售和服务。公司自成 立以来坚持以市场变化为导向，发展不同类别、不同领域的各类计量检测、测试仪器，计算机软件。目前已经形成了上百类仪器仪表类产品，开发了三大类，几十种 计量测试软件。是同行中发展较快，产品较全的，服务销售网络较广的一家新兴高科技企业公司。公司的集团化发展，使得公司拥有了完善的售前、售中、售后服务 团队，同时也具备了产品系列化、高科技化的发展潜力。 形成了北京、上海、重庆、武汉、大连五大销售技术服务中心，全国范围销售的联合企业公司</span><br data-filtered=\"filtered\" />\r\n<br />\r\n<span style=\"line-height:2em;\"><span style=\"font-size:18px;\"><span style=\"color:#000000;\"><span align=\"justify\"><strong>合作项目</strong></span><strong>：</strong></span></span></span><br data-filtered=\"filtered\" />\r\n<span style=\"line-height:1.8em;\">如厂矿企业、机关、学校、医院、宾馆、写 字楼、酒店、商务楼、学校小区废旧物资，我们将有专人负责为您打扫、看管、货运一切废 旧物资，根据需要可签各种合同，现金交易，并提供拥金。</span></p>\r\n','不止于质量 我们更追求完美','32','_self','','0','/Upload/public/aboutus.jpg','','','','aboutus','','20','10','page.html','','1','1','1','0','1','1','','','','/Upload/icon/15.jpg','3','###/Upload/public/1.jpg###@@@###/Upload/public/2.jpg###@@@###/Upload/public/3.jpg###@@@###/Upload/public/2.jpg###',NULL),
('17','15','0','企业文化','','<img src=\"/Upload/public/wenhua.png\" style=\"width: 404px; height: 312px;float:left;\" /> 一、我们的核心价值观是：忠诚、感恩、学习、创新、艰苦奋斗! &nbsp;<br />\r\n二、我们的工作作风是：主动出击、快速反应、马上行动 &nbsp;<br />\r\n三、我们的创新文化是：要么死亡、要么创新、除了老婆和孩子不变，一切都要变! &nbsp;<br />\r\n&mdash;&mdash;创新是企业的灵魂!经验是负债，创新是资产 &nbsp;<br />\r\n四、我们的战略文化是：发展中不忘稳健，稳健中求发展! &nbsp;<br />\r\n&mdash;&mdash;拓展全国、走向世界j &nbsp;<br />\r\n五、我们的危机文化是：居危思进，差一分钟都有可能导致失败，一天不进步企业都有可能要出局， &nbsp;<br />\r\n&mdash;&mdash;没有危机意识的企业只有死亡。 &nbsp;<br />\r\n六、我们的努力文化是：努力就像怀孕，时间久了会让自己和别人都看出来! &nbsp;<br />\r\n一一八小时内求生存，八小时外求发展！ &nbsp;<br />\r\n&mdash;&mdash;每一份私下的努力都会有培增的回报，并且在公众场合上被表现出来！ &nbsp;<br />\r\n七、我们的用人文化是：德在前才在后。相马又赛马!能者上、庸者下、平着让！ &nbsp;<br />\r\n一一有德有才破格使用，有德无才培养使用! &nbsp;<br />\r\n无德有才限制使用，无德无才坚决不用! &nbsp;<br />\r\n&mdash;&mdash;用人要疑，制度第一；用人不疑，必死无疑；疑人不用，无人可用。 &nbsp;<br />\r\n八、我们的执行文化是：伟大的公司来自于伟大的原则，伟大的原则来自伟大的执行力。理解也执行，不理解也执行。 &nbsp;接受命令，坚决执行，有疑必问，有问必复! &nbsp;<br />\r\n&mdash;&mdash;执行力是企业的核心竞争力之一。 &nbsp;<br />\r\n&mdash;&mdash;结果提前，自我退后：锁定目标，专注重复 &nbsp;<br />\r\n&mdash;&mdash;讲管理不讲人情，管理就是责任， &nbsp;','','32','_self','','0','/Upload/public/wenhua.jpg','','','','culture','','20','0','page.html','','1','0','1','0','1','1','','','','/Upload/icon/wenhua.png','0','',NULL),
('18','15','0','资质荣誉','','1、国家&ldquo;十一五&rdquo;&ldquo;863计划&rdquo;信息技术领域重大专项&mdash;&mdash;&ldquo;高端容错计算系统研制与应用推广&rdquo;项目承担单位<br />\r\n2、国家&ldquo;十二五&rdquo;&ldquo;863计划&rdquo;先进制造领域重大项目&mdash;&mdash;&ldquo;面向离散型集团企业集约化经营管理平台研发与应用&rdquo;项目承担单位<br />\r\n3、国家&ldquo;十一五&rdquo;&ldquo;863计划&rdquo;先进制造领域重点项目&mdash;&mdash;&ldquo;制造业商务智能技术与产品研发&rdquo;项目承担单位<br />\r\n4、国家首批创新型企业<br />\r\n5、国家520家重点企业之一<br />\r\n6、国家重点高新技术企业<br />\r\n7、首批&ldquo;中国软件创新力20强&rdquo;<br />\r\n8、首批认定的国家级企业技术中心<br />\r\n9、高效能服务器和存储技术国家重点实验室<br />\r\n10、国家信息存储工程技术研究中心<br />\r\n11、国家&ldquo;863&rdquo;服务器成果产业化基地<br />\r\n12、首批认定的一级计算机信息系统集成资质<br />\r\n13、通过ISO9001、ISO14001、18000 三项认证的企业<br />\r\n14、国家涉密信息系统集成甲级资质、涉密软件开发资质<br />\r\n15、国家密码管理局认定的商用密码产品生产定点单位和商用密码产品销售许可单位','','32','_self','','0','/Upload/public/rongyu.jpg','','','','honor','','20','0','page.html','','1','0','1','0','1','1','','','','/Upload/icon/rongyu.png','0','###/Upload/public/rongyu1.jpg###@@@###/Upload/public/rongyu2.jpg###@@@###/Upload/public/rongyu3.jpg###@@@###/Upload/public/rongyu4.jpg###',NULL),
('19','15','0','组织机构','','<div style=\"text-align: center\">\r\n<p><img alt=\"\" src=\"/Upload/public/zzjj1.png\" /></p>\r\n</div>\r\n','','32','_self','','0','/Upload/public/jg.png','','','','organization','','20','0','page.html','','1','0','1','0','1','1','','','','/Upload/icon/zzjj1.png','0','',NULL),
('20','0','1','新闻资讯','新闻','','企业发展携手你我共前进','30','_self','','0','','','','','news','','20','20','article.html','showarticle.html','1','0','1','0','1','1','','','','/Upload/icon/20.jpg','1','',NULL),
('21','20','0','公司新闻','新闻','','','30','_self','','0','/Upload/public/gsxw.jpg','','','','companynews','','20','0','article.html','showarticle.html','1','0','1','0','1','1','','','','/Upload/icon/gsxw.png','1','',NULL),
('22','20','0','行业动态','新闻','','','30','_self','','0','/Upload/public/hyxw.jpg','','','','industrytrends','','20','0','article.html','showarticle.html','1','0','1','0','1','1','','','','/Upload/icon/hyxw.png','1','',NULL),
('23','0','1','产品中心','产品','','创新产品不止于质量 更追求完美','36','_self','','0','','','','','product','','20','30','product.html','showproduct.html','1','0','1','0','1','1','','','','/Upload/icon/23.jpg','3','',NULL),
('24','23','0','智能仪器','产品','','','36','_self','','0','','','','','class1','','20','0','product.html','showproduct.html','1','0','1','0','1','1','','','','/Upload/icon/23.jpg','0','',NULL),
('25','23','1','智能设备','产品','','','36','_self','','0','','','','','class2','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('26','23','0','汽车仪表','产品','','','36','_self','','0','','','','','class3','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('27','23','1','数显仪表','产品','','','36','_self','','0','','','','','class4','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','3',NULL,NULL),
('28','27','0','压力表','产品','','','36','_self','','0','','','','','class41','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('29','27','0','直流数显','产品','','','36','_self','','0','','','','','class42','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('30','0','0','下载中心','下载','','','35','_self','','0','','','','','download','','20','50','download.html','showdownload.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/30.jpg','0',NULL,NULL),
('31','0','0','联系我们','','','','32','_self','','0','','','','','contactus','','20','80','page.html','','1','0','1','0','1','1','','','','/Upload/icon/31.jpg','0','',NULL),
('57','25','0','无人机','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class21','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,NULL,'0',NULL,NULL),
('58','25','0','摄像头','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class22','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,NULL,'0',NULL,NULL),
('59','0','0','我们的优势','','','国内最专业的电子仪器设计服务商之一。多年在电子专业领域积累丰富的设计开发经验','32','_self','','0','/Upload/public/youshi.png','','','','wmdys','','20','31','page.html','','1','0','0','0','1','1','','','','','0','高素质的研发生产团队######公司下属有员工100余名。其中高级技术人员30多名；核心生产团队行业经验平均有10年以上；生产员工行业经验平均3年以上@@@强大的仪器加工能力######秉持安全设计的理念，采取人工力学工程的方法。选择适合人体要求，不劳烦腰部，还能使得健身达到最大的效果@@@严格的产品质检工序######一直致力于通过专业、细致和全面的服务为客户提供全球一流品质的实验室仪器、设备，并度身定制',NULL),
('60','0','0','我们的客户','','','我们很荣幸地与各单位合作并提供产品和服务','32','_self','','0','','','','','wmdkh','','20','32','page.html','','1','0','0','0','1','1','','','','','0','中国航天科工集团###/Upload/customer/cm01.jpg###@@@Panasonic###/Upload/customer/cm02.jpg###@@@中国华能集团###/Upload/customer/cm03.jpg###@@@中国科学院###/Upload/customer/cm04.jpg###@@@中广核CGN###/Upload/customer/cm05.jpg###@@@明阳风电###/Upload/customer/cm06.jpg###@@@Newamstar新美星###/Upload/customer/cm07.jpg###@@@深圳宝安国际机场###/Upload/customer/cm08.jpg###@@@中国电子科技集团###/Upload/customer/cm09.jpg###@@@中船重工###/Upload/customer/cm10.jpg###',NULL),
('32','0','0','客户案例','案例','','完善客户的需求 是我们永不止步的追求','31','_self','','0','','','','','case','','20','40','picture.html','showpicture.html','1','0','1','0','1','1','','','','/Upload/icon/32.jpg','0','',NULL),
('35','0','1','About Us','','<p><img alt=\"\" class=\"left\" src=\"/Upload/public/aboutus1.jpg\" style=\"width: 500px; height: 333px; float: left; margin-right: 20px;\" />XX Electronics Co., Ltd. was founded in 2000, with a registered capital of 10 million and over 40 employees. It is a professional electronic and electrical company. Excellent staff, advanced technology, excellent equipment and strict management are the basic of the continuous development of the company, the product can win the dependence of the user. &quot;Reliable and professional&quot; is our belief in the spirit of production and service.<br />\r\nOn the basis of insisting on technological innovation, the company pays great attention to quality management, constantly improves the service level, realizes the good development of the democratic appraisal party members&#39; summary of the company&#39;s business. We attentively participate in the promotion and the industry exchange activities. The company has excellent quality, good product performance and lead in the long-term development process. The technical advantages and many large factories in China have established long-term good partners. We also sincerely welcome customers from home and abroad to our company, visit and technical exchange!<br />\r\nThe purpose of our service is to:<br />\r\nHonest, fair, trustworthy, reasonable price, equality and mutual benefit.<br />\r\nRelying on its strong economic strength and scrupulously abide by the principle of honesty, the company has won many customers&#39; trust and gained good reputation in the industry. The establishment of a solid cooperative relationship, with the continuous development and growth of business, the scope of partners is also expanding. We warmly look forward to working with you and contributing to the sustainable development of our society. It<br />\r\nOur mission:<br />\r\nIn the course of operation, the company adheres to the marketing concept of &quot;suitable products, moderate price, high quality service&quot;, and focuses on the development, production, sales and service of the instrument, import and export trade and computer software. Since its inception, the company has adhered to market change oriented development of all kinds of metrological testing, testing instruments and computer software in different categories and fields. At present, hundreds of instruments and meters have been formed, and three categories and dozens of measuring and testing software have been developed. It is a new hi-tech enterprise with relatively fast development, relatively complete product and extensive service sales network. The company&#39;s group development makes the company have a perfect service team of pre-sale, sale and after sale. At the same time, it also has the development potential of product series and high-tech. Beijing, Shanghai, Chongqing, Wuhan and Dalian have formed the five largest sales and technical service centers.<br />\r\nCooperative projects:<br />\r\nSuch as factory, mining, school, school, hospital, hotel, office building, hotel, business building, and the waste materials in the school district, we will have a special person responsible for cleaning, managing and transporting all the waste materials for you. According to the needs, we can sign various contracts, cash transactions, and provide gold.</p>\r\n','Not only quality, we are more perfect','32','_self','','0','/Upload/public/aboutus.jpg','','','','aboutus','','20','10','page.html','','1','0','1','0','1','2','','','','/Upload/icon/35.jpg','3','###/Upload/public/1.jpg###@@@###/Upload/public/2.jpg###@@@###/Upload/public/3.jpg###@@@###/Upload/public/2.jpg###',NULL),
('37','35','0','Culture','','<img src=\"/Upload/public/wenhua.png\" style=\"width: 404px; height: 312px;float:left;\" /> First, our core values are loyalty, gratitude, learning, innovation and hard struggle.<br />\r\nTwo, our work style is: active attack, quick response, immediate action.<br />\r\nThree, our innovation culture is: either death or innovation, everything will change except wife and children.<br />\r\nInnovation is the soul of an enterprise. Experience is debt and innovation is asset.<br />\r\nFour, our strategic culture is: in development, we should not forget steady, steady and seek development.<br />\r\nExpanding the whole country and going to the world J<br />\r\nFive, our crisis culture is: when we are in danger, we may fail in less than a minute.<br />\r\nThe only business without crisis is death. It<br />\r\nSix, our efforts culture is: efforts are like pregnancy, and for a long time they will see themselves and others.<br />\r\nSurvive within 118 hours and develop outside eight hours! It<br />\r\nEvery private effort will increase returns and be shown on public occasions. It<br />\r\nSeven, our employment culture is that virtue is before us. Horse racing and horse racing! It<br />\r\nThere are virtues, talents and talents.<br />\r\nNo virtue, no talent, no use, no morality, no determination.<br />\r\nIt is doubtful that the system should be the first to employ people. It<br />\r\nEight, our execution culture is that great companies come from great principles, and great principles come from great execution. Understanding is also carried out, not understanding and execution. If you accept orders, execute resolutely, there will be doubts and questions.<br />\r\nExecutive power is one of the core competitiveness of enterprises. It<br />\r\nThe result is early, self Retreat: lock the target, focus on repetition.<br />\r\nManagement is not human, management is responsibility.','','32','_self','','0','/Upload/public/wenhua.jpg','','','','culture','','20','0','page.html','','1','0','1','0','1','2','','','','/Upload/icon/wenhua.png','0','',NULL),
('63','45','0','UAV','','','','36','_self','','0','','','','','class21','','20','0','product.html','showproduct.html','1','0','1','0','1','2','','','','','0','',NULL),
('64','45','0','Camera','','','','36','_self','','0','','','','','class22','','20','0','product.html','showproduct.html','1','0','1','0','1','2','','','','','0','',NULL),
('38','35','0','Honor','','<p>1, the national &quot;11th Five-Year&quot; &quot;863 Plan&quot; information technology major project - &quot;high-end fault-tolerant computing system development and application promotion&quot; project commitment unit<br />\r\n2, the national &quot;12th Five-Year&quot; &quot;863 Plan&quot; advanced manufacturing field major projects - &quot;the research and development and application of the intensive business management platform for the discrete group enterprise&quot;<br />\r\n3, the national &quot;11th Five-Year&quot; &quot;863 Plan&quot; advanced manufacturing field key project - &quot;manufacturing business intelligence technology and product development&quot; project commitment unit<br />\r\n4, the first batch of innovative enterprises of the state<br />\r\n5, one of the 520 key enterprises in the state<br />\r\n6. State key high-tech enterprises<br />\r\n7, the first &quot;Chinese software innovation power 20&quot;<br />\r\n8, the first batch of national enterprise technology center<br />\r\n9. State Key Laboratory of high efficiency servers and storage technology<br />\r\n10. National information storage engineering technology research center<br />\r\n11. The national &quot;863&quot; server industrialization base<br />\r\n12. The first level of computer information system integration qualification.<br />\r\n13. Enterprises certified by ISO9001, ISO14001 and 18000 three.<br />\r\n14. The national secret information system integrates the qualification of Grade A and the development of classified software.<br />\r\n15, the State Password Administration identified commercial password products production designated units and commercial password products sales licensing units.</p>\r\n','','32','_self','','0','/Upload/public/rongyu.jpg','','','','honor','','20','0','page.html','','1','0','1','0','1','2','','','','/Upload/icon/rongyu.png','0','###/Upload/public/rongyu1.jpg###@@@###/Upload/public/rongyu2.jpg###@@@###/Upload/public/rongyu3.jpg###@@@###/Upload/public/rongyu4.jpg###',NULL),
('39','35','0','Organization','','<div style=\"text-align: center\">\r\n<p><img alt=\"\" src=\"/Upload/public/zzjj1en.png\"  /></p>\r\n</div>\r\n','','32','_self','','0','/Upload/public/jg.png','','','','organization','','20','0','page.html','','1','0','1','0','1','2','','','','/Upload/icon/zzjj1en.png','0','',NULL),
('40','0','1','News','','','Business development hand in hand with you and I go forward','30','_self','','0','','','','','news','','20','20','article.html','showarticle.html','1','0','1','0','1','2','','','','/Upload/icon/40.jpg','1','',NULL),
('41','40','0','Company News','','','','30','_self','','0','/Upload/public/gsxw.jpg','','','','companynews','','20','0','article.html','showarticle.html','1','0','1','0','1','2','','','','/Upload/icon/gsxw.png','1','',NULL),
('42','40','0','Industry Trends','','','','30','_self','','0','/Upload/public/hyxw.jpg','','','','industrytrends','','20','0','article.html','showarticle.html','1','0','1','0','1','2','','','','/Upload/icon/hyxw.png','1','',NULL),
('43','0','1','Product','','','Innovative products are more than quality in pursuit of perfection','36','_self','','0','','','','','product','','20','30','product.html','showproduct.html','1','0','1','0','1','2','','','','/Upload/icon/43.jpg','3','',NULL),
('44','43','0','Smart Instrument','','','','36','_self','','0','','','','','class1','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('45','43','1','Smart Device','','','','36','_self','','0','','','','','class2','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('46','43','0','Car Meter','','','','36','_self','','0','','','','','class3','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('47','43','1','Digital Gauge','','','','36','_self','','0','','','','','class4','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','3',NULL,NULL),
('48','47','0','Pressure Gauge','','','','36','_self','','0','','','','','class41','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('49','47','0','DC Gauge','','','','36','_self','','0','','','','','class42','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('50','0','0','Case','','','Improving customer needs is our never ending pursuit','31','_self','','0','','','','','case','','20','50','picture.html','showpicture.html','1','0','1','0','1','2','','','','/Upload/icon/50.jpg','0','',NULL),
('51','0','0','Download','','','','35','_self','','0','','','','','download','','20','50','download.html','showdownload.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/51.jpg','0',NULL,NULL),
('52','0','0','Contact Us','','','','32','_self','','0','','','','','contactus','','20','80','page.html','','1','0','1','0','1','2','','','','/Upload/icon/52.jpg','0','',NULL),
('61','0','0','Our Advantages','','','Years of accumulated experience in design and development in the field of electronics.','32','_self','','0','/Upload/public/youshi.png','','','','ouradvantages','','20','31','page.html','','1','0','0','0','1','2','','','','','0','High quality R & D production team######The company has more than 100 employees. Among them, there are more than 30 senior technical personnel, and the core production team has an average of more than 10 years of experience in the industry, with an average of 3 years of experience in the production industry.@@@Powerful instrument processing capability######Adhere to the concept of safety design and adopt artificial mechanics engineering method. Choose suitable body requirements, do not bother the waist, but also make fitness to achieve the greatest effect.@@@Strict product quality inspection processes######We have been committed to providing customers with world-class quality laboratory instruments and equipment through professional, meticulous and comprehensive services.',NULL),
('62','0','0','Out Customers','','','We are honored to cooperate with all units and provide products and services.','32','_self','','0','','','','','outcustomers','','20','32','page.html','','1','0','0','0','1','2','','','','','0','HangTian Group###/Upload/customer/cm01.jpg###@@@Panasonic###/Upload/customer/cm02.jpg###@@@Huaneng Group###/Upload/customer/cm03.jpg###@@@KeXueYuan###/Upload/customer/cm04.jpg###@@@CGN###/Upload/customer/cm05.jpg###@@@YangGuan FengDian###/Upload/customer/cm06.jpg###@@@Newamstar###/Upload/customer/cm07.jpg###@@@BaoAn###/Upload/customer/cm08.jpg###@@@DianZi###/Upload/customer/cm09.jpg###@@@CSIC###/Upload/customer/cm10.jpg###',NULL),
('55','15','0','宣传视频','视频','','','34','_self','','0','/Upload/public/sp.jpg','','','','video','','20','0','video.html','showvideo.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/sp.png','0',NULL,NULL),
('56','35','0','Video','video','','','34','_self','','0','/Upload/public/sp.jpg','','','','video','','20','0','video.html','showvideo.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/sp.png','0',NULL,NULL);

INSERT INTO `youdian_channel_model` VALUES
('1','频道信息','1','youdian_channel','','0','1',NULL,NULL),
('2','专题信息','2','youdian_special',NULL,'1','1',NULL,NULL),
('3','幻 灯 片','3','youdian_banner',NULL,'1','1',NULL,NULL),
('4','在线客服','4','youdian_support',NULL,'1','1',NULL,NULL),
('5','第三方在线客服','5','youdian_support3',NULL,'1','1',NULL,NULL),
('6','在线留言','6','youdian_guestbook',NULL,'1','1',NULL,NULL),
('7','人才招聘','7','youdian_recruit',NULL,'1','1',NULL,NULL),
('8','信息评论','8','youdian_comment',NULL,'1','1',NULL,NULL),
('9','友情链接分类','5','youdian_link_class',NULL,'1','1',NULL,NULL),
('10','友情链接','9','youdian_link',NULL,'1','1',NULL,NULL),
('11','广告信息','10','youdian_ad',NULL,'1','1',NULL,NULL),
('12','会员分组','11','youdian_member_group',NULL,'1','1',NULL,NULL),
('13','会员信息','13','youdian_member',NULL,'0','1',NULL,NULL),
('14','管理员信息','14','youdian_admin',NULL,'1','1',NULL,NULL),
('15','管理员组','15','youdian_admin_group',NULL,'1','1',NULL,NULL),
('16','修改模板','16',NULL,NULL,'1','1',NULL,NULL),
('17','自定义标签','17','youdian_tag',NULL,'1','1',NULL,NULL),
('18','属性标记','18','youdian_label',NULL,'1','1',NULL,NULL),
('19','模型管理','19','youdian_channel_model',NULL,'1','1',NULL,NULL),
('20','字段管理','20','youdian_attribute',NULL,'1','1',NULL,NULL),
('21','字段分组管理','21','youdian_attribute',NULL,'1','1',NULL,NULL),
('22','幻灯分组管理','22','youdian_banner_group',NULL,'1','1',NULL,NULL),
('23','邮件订阅分类','23','youdian_mail_class',NULL,'1','1',NULL,NULL),
('24','邮件管理','24','youdian_mail',NULL,'1','1',NULL,NULL),
('25','邮件群发管理','25','youdian_mail_send',NULL,'1','1',NULL,NULL),
('26','订单模型','26','youdian_order',NULL,'1','1',NULL,NULL),
('30','文章模型','30','youdian_info','','0','1','article.html','showarticle.html'),
('31','图片模型','31','youdian_info',NULL,'0','1','picture.html','showpicture.html'),
('32','单页模型','32','youdian_channel',NULL,'0','1','page.html',''),
('33','链接模型','33','youdian_info',NULL,'0','1','',''),
('34','视频模型','34','youdian_info','','0','1','video.html','showvideo.html'),
('35','下载模型','35','youdian_info','','0','1','download.html','showdownload.html'),
('36','产品模型','36','youdian_info','','0','1','product.html','showproduct.html'),
('37','反馈模型','37',NULL,'','0','1','feedback.html','showfeedback.html'),
('38','保留模型3','38',NULL,'系统保留使用，建议不要自定义','0','0',NULL,NULL),
('39','保留模型4','39',NULL,'系统保留使用，建议不要自定义','0','0',NULL,NULL);

INSERT INTO `youdian_config` VALUES
('1','WEB_NAME','某某科技有限公司',NULL,'basic','1','1'),
('2','WEB_URL','http://www.xx.com',NULL,'basic','1','0'),
('3','WEB_ICP','ICP备888888888号',NULL,'basic','1','1'),
('4','WEB_STATUS','1',NULL,'basic','1','0'),
('5','WEB_CLOSE_REASON','抱歉，网站正在维护中，给您带来不便深表歉意！',NULL,'basic','1','1'),
('6','WEB_BAD_WORDS','他妈的=***',NULL,'basic','1','0'),
('7','TITLE','website|cms|wap website|finished website',NULL,'seo','1','2'),
('8','CONTACT','Miss Cheng',NULL,'contact','1','2'),
('9','COMPANY','某某科技有限公司',NULL,'contact','1','1'),
('10','CONTACT','陈小姐',NULL,'contact','1','1'),
('11','ADDRESS','湖南省长沙市星沙经济开发区板仓路明城公寓E栋901',NULL,'contact','1','1'),
('12','TELEPHONE','010-83486998',NULL,'contact','1','1'),
('13','MOBILE','13588881398',NULL,'contact','1','1'),
('14','FAX','010-83486998',NULL,'contact','1','1'),
('15','EMAIL','12345@qq.com',NULL,'contact','1','1'),
('16','POSTCODE','400000',NULL,'contact','1','1'),
('17','ONLINE_ENABLE','1',NULL,'online','1','0'),
('18','ONLINE_STYLE','blue',NULL,'online','1','1'),
('19','ONLINE_POSITION','0',NULL,'online','1','0'),
('20','UPLOAD','./Upload/',NULL,'upload','1','0'),
('21','UPLOAD_FILE_TYPE','rar|zip|doc|docx|ppt|pptx|pdf|jpg|xls|png|gif|mp3|jpeg|bmp|swf|flv|ico|mp4',NULL,'upload','1','0'),
('22','MAX_UPLOAD_SIZE','5242880',NULL,'upload','1','0'),
('23','GUEST_BOOK_ALLOW','1',NULL,'guestbook','1','0'),
('24','GUEST_BOOK_CHECK','1',NULL,'guestbook','1','0'),
('25','GUEST_BOOK_VERIFYCODE','1',NULL,'guestbook','1','0'),
('26','GUEST_BOOK_PAGESIZE','10',NULL,'guestbook','1','0'),
('27','COMMENT_ENABLE','1',NULL,'comment','1','0'),
('28','COMMENT_CHECK','1',NULL,'comment','1','0'),
('29','COMMENT_VERIFYCODE','1',NULL,'comment','1','0'),
('30','MEMBER_REG_ENABLE','1',NULL,'reg','1','0'),
('31','MEMBER_REG_CHECK','3',NULL,'reg','1','0'),
('32','MEMBER_REG_VERIFYCODE','1',NULL,'reg','1','0'),
('40','QQ','',NULL,'contact','1','1'),
('41','APP_GROUP_LIST','Home,Admin,Install',NULL,'config','1','0'),
('42','DEFAULT_GROUP','Home',NULL,'config','1','0'),
('43','DEFAULT_MODULE','Index',NULL,'config','1','0'),
('44','DEFAULT_ACTION','Index',NULL,'config','1','0'),
('45','URL_MODEL','1',NULL,'config','1','0'),
('46','DEFAULT_THEME','Default',NULL,'config','1','0'),
('47','URL_CASE_INSENSITIVE','true',NULL,'config','1','0'),
('48','TMPL_ACTION_ERROR','APP_PATH.\'tpl/admin/default/public/error.html\'',NULL,'config','0','0'),
('49','TMPL_ACTION_SUCCESS','APP_PATH.\'tpl/admin/default/public/success.html\' ',NULL,'config','0','0'),
('50','TAGLIB_PRE_LOAD','YouDian',NULL,'config','1','0'),
('51','DEFAULT_THEME','Default',NULL,'home/config','1','0'),
('52','WATER_PIC','',NULL,'water','1','0'),
('53','WATER_OFFSET_X','0',NULL,'water','1','0'),
('54','WATER_OFFSET_Y','0',NULL,'water','1','0'),
('55','WATER_TRANS','60',NULL,'water','1','0'),
('56','TITLE','企业网站管理系统|微网站建设|手机网站建设|中英文网站建设',NULL,'seo','1','1'),
('57','KEYWORDS','企业网站管理系统,微网站建设,手机网站建设,中英文网站建设',NULL,'seo','1','1'),
('58','DESCRIPTION','本系统集手机站、微信站、电脑站三站合一，各站数据同步、只需一个空间,维护更方便！订购热线：010-88888888',NULL,'seo','1','1'),
('59','ONLINE_TOP','180',NULL,'online','1','0'),
('60','ONLINE_EFFECT','1',NULL,'online','1','0'),
('61','ONLINE_WIDTH','160',NULL,'online','1','0'),
('62','ONLINE_OPEN','1',NULL,'online','1','0'),
('63','ONLINE_TELEPHONE','',NULL,'online','1','0'),
('64','ONLINE_FOOTER_TEXT','<img alt=\"微信扫一扫 关注我们\" src=\"/Upload/public/qrcode.jpg\" style=\"width: 130px; height: 130px;margin-top:8px;\" title=\"微信扫一扫 关注微信公众号\" /><br />\r\n<b style=\"color: rgb(255, 0, 0);\">wangzhan</b><br />\r\n<strong>扫一扫，关注微信公众号</strong>',NULL,'online','1','1'),
('65','ONLINE_TITLE','在线客服',NULL,'online','1','1'),
('66','URL_MODEL','1',NULL,'core','1','0'),
('67','URL_HTML_SUFFIX','html',NULL,'core','1','0'),
('68','WEB_NAME','Tech Company',NULL,'basic','1','2'),
('69','WEB_ICP','ICP 123456789',NULL,'basic','1','2'),
('70','WEB_CLOSE_REASON','Sorry, the website is maintenance!',NULL,'basic','1','2'),
('71','COMPANY','Your Company Name',NULL,'contact','1','2'),
('72','DESCRIPTION','this product include pc site、mobile site、weixin site，Data synchronization, one virtual host, more convenient maintenance. Order hotline: +86-010-88888888',NULL,'seo','1','2'),
('73','KEYWORDS','website,cms,wap website',NULL,'seo','1','2'),
('74','ADDRESS','Room 6, 8th Building, XueYuan Road HaiDian District Beijing China',NULL,'contact','1','2'),
('76','ONLINE_TITLE','online services',NULL,'online','1','2'),
('77','ONLINE_FOOTER_TEXT','<img alt=\"\" src=\"/Upload/public/qrcode.jpg\" style=\"width: 130px; height: 130px;margin-top:8px;\" title=\"号\" /><br />\r\n<b style=\"color: rgb(255, 0, 0);\">wangzhan</b><br />\r\n<strong>wechat</strong>',NULL,'online','1','2'),
('78','ORDER_ALLOW','1','订单权限','order','1','0'),
('79','ORDER_PAGESIZE','10','每页显示订单数','order','1','0'),
('80','STAT_USERNAME','','统计帐号','stat','1','0'),
('81','STAT_USERPWD','','登录密码','stat','1','0'),
('82','STAT_CODE','','统计代码','stat','1','0'),
('83','STAT_ENABLE','1','是否启用统计','stat','1','0'),
('84','SHARE_STYLE','0',NULL,'baidushare','1','0'),
('85','SHARE_TOP','333',NULL,'baidushare','1','0'),
('86','SHARE_POS','right',NULL,'baidushare','1','0'),
('87','SHARE_SIZE','0',NULL,'baidushare','1','0'),
('88','SHARE_ENABLE','0',NULL,'baidushare','1','0'),
('89','MOBILE','+8613588889999',NULL,'contact','1','2'),
('90','TELEPHONE','86-010-12345678',NULL,'contact','1','2'),
('91','FAX','86-010-12345678',NULL,'contact','1','2'),
('92','EMAIL','12345@qq.com',NULL,'contact','1','2'),
('93','QQ','',NULL,'contact','1','2'),
('94','POSTCODE','400000',NULL,'contact','1','2'),
('95','LINK_ENABLE','0','是否启用生成关键词内链','link','1','0'),
('96','LINK_KEYWORD','','关键词对应链接设置','link','1','0'),
('97','WEB_BAD_IP','',NULL,'basic','1','0'),
('98','WAP_URL','','手机网站域名','domain','1','0'),
('99','WEB_LOGO','/Upload/public/logo.png',NULL,'basic','1','1'),
('100','WEB_LOGO','/Upload/public/logoen.png',NULL,'basic','1','2'),
('101','MEMBER_ADD_CHECK','1',NULL,'reg','1','0'),
('102','DEFAULT_THEME','flat',NULL,'wap/config','1','0'),
('103','ONLINE_STYLE','blue_en',NULL,'online','1','2'),
('104','HTML_ENABLE','0',NULL,'html','1','0'),
('105','INDEX_CACHE_TIME','604800',NULL,'html','1','0'),
('106','CHANNEL_CACHE_TIME','1296000',NULL,'html','1','0'),
('107','INFO_CACHE_TIME','0',NULL,'html','1','0'),
('108','AUTO_DEL_ENABLE','0',NULL,'other','1','0'),
('109','AUTO_UPLOAD_ENABLE','1',NULL,'other','1','0'),
('110','DEL_LINK_ENABLE','0',NULL,'other','1','0'),
('111','ALLOW_LINK','',NULL,'other','1','0'),
('112','WATER_ENABLE','0',NULL,'water','1','0'),
('113','MEMBER_LOGIN_VERIFYCODE','1',NULL,'reg','1','0'),
('114','ORDER_VERIFYCODE','1',NULL,'order','1','0'),
('115','THUMB_ENABLE','0',NULL,'thumb','1','0'),
('116','THUMB_WATER_ENABLE','0',NULL,'thumb','1','0'),
('117','THUMB_TYPE','2',NULL,'thumb','1','0'),
('118','THUMB_WIDTH','160',NULL,'thumb','1','0'),
('119','THUMB_HEIGHT','160',NULL,'thumb','1','0'),
('120','WATER_TYPE','2',NULL,'water','1','0'),
('121','WATER_TEXT','',NULL,'water','1','0'),
('122','WATER_FONT','simkai.ttf',NULL,'water','1','0'),
('123','WATER_TEXT_SIZE','12',NULL,'water','1','0'),
('124','WATER_TEXT_COLOR','#FF0000',NULL,'water','1','0'),
('125','WATER_TEXT_ANGLE','0',NULL,'water','1','0'),
('126','WATER_POSITION','9',NULL,'water','1','0'),
('127','THUMB_FIRST','1',NULL,'thumb','1','0'),
('128','WAP_AUTO_REDIRECT','0',NULL,'wap','1','0'),
('129','WAP_PC_ACCESS','0',NULL,'wap','1','0'),
('130','WAP_LOGO','/Upload/public/logowap.png',NULL,'wap','1','1'),
('131','LANG_AUTO_DETECT','1',NULL,'core','1','0'),
('132','DEFAULT_LANG','cn',NULL,'core','1','0'),
('133','EMAIL_SENDER','',NULL,'basic','1','1'),
('134','EMAIL_ACCOUNT','',NULL,'basic','1','1'),
('135','EMAIL_SMTP','',NULL,'basic','1','1'),
('136','EMAIL_PASSWORD','',NULL,'basic','1','1'),
('137','EMAIL_BODY','您好，{$MemberName}!感谢您注册成为{$WebName}会员。\r\n请点击以下链接激活会员帐号:\r\n{$Activate}',NULL,'reg','1','1'),
('138','EMAIL_BODY','Hello，{$MemberName}!Welcome to register the member of {$WebName}.\r\nplease click the following url to activate:{$Activate}',NULL,'reg','1','2'),
('139','EMAIL_SENDER','',NULL,'basic','1','2'),
('140','EMAIL_ACCOUNT','',NULL,'basic','1','2'),
('141','EMAIL_SMTP','',NULL,'basic','1','2'),
('142','EMAIL_PASSWORD','',NULL,'basic','1','2'),
('143','ORDER_EMAIL','0',NULL,'order','1','0'),
('144','ORDER_EMAIL_BODY','',NULL,'order','1','0'),
('146','MEMBER_ENABLE','1',NULL,'reg','1','0'),
('147','GUEST_BOOK_SENDEMAIL','1',NULL,'guestbook','1','0'),
('148','WX_TOKEN','',NULL,'wx','1','0'),
('149','WX_APP_ID','',NULL,'wx','1','0'),
('150','WX_APP_SECRET','',NULL,'wx','1','0'),
('151','COMMENT_PAGE_SIZE','10',NULL,'comment','1','0'),
('152','WX_LOGO','',NULL,'wx','1','0'),
('153','WX_NAME','',NULL,'wx','1','0'),
('154','WX_ORIGINAL_ID','',NULL,'wx','1','0'),
('155','WX_ID','',NULL,'wx','1','0'),
('156','WX_DESCRIPTION','',NULL,'wx','1','0'),
('157','WX_QRCODE','/Upload/qr_cn.png',NULL,'wx','1','0'),
('158','WAP_STATUS','1',NULL,'wap','1','0'),
('159','WX_SAVE_MSG','0',NULL,'wx','1','0'),
('160','GUEST_BOOK_EMAIL','2575150524@qq.com',NULL,'guestbook','1','0'),
('161','GUEST_BOOK_EMAIL_TITLE','网站留言提醒',NULL,'guestbook','1','0'),
('162','GUEST_BOOK_EMAIL_BODY','',NULL,'guestbook','1','0'),
('163','ORDER_EMAIL_TITLE','订购通知',NULL,'order','1','0'),
('164','FEEDBACK_VERIFYCODE','1',NULL,'guestbook','1','0'),
('165','FEEDBACK_SENDEMAIL','0',NULL,'guestbook','1','0'),
('166','FEEDBACK_EMAIL','',NULL,'guestbook','1','0'),
('167','FEEDBACK_EMAIL_TITLE','网站反馈通知邮件',NULL,'guestbook','1','0'),
('168','FEEDBACK_CHECK','0',NULL,'guestbook','1','0'),
('169','WEB_ICON','',NULL,'basic','1','0'),
('170','BAIDU_TRANSLATE_APIKEY','',NULL,'other','1','0'),
('171','EMAIL_PORT','465',NULL,'basic','1','1'),
('172','EMAIL_PORT','25',NULL,'basic','1','2'),
('173','EMAIL_WAY','ssl',NULL,'basic','1','1'),
('174','EMAIL_WAY','tls',NULL,'basic','1','2'),
('175','LOG_STATUS','0',NULL,'basic','1','0'),
('176','LOGTYPE_ALLOW','2,3,4,5,6,7,8,1',NULL,'basic','1','0'),
('177','ORDER_EMAIL_TO','',NULL,'order','1','0'),
('178','ADMIN_PAGE_SIZE','20',NULL,'other','1','0'),
('179','ADMIN_ROLL_PAGE','30',NULL,'other','1','0'),
('180','SITEMAP_ENABLE','0',NULL,'other','1','0'),
('181','SITEMAP_TIME','86400',NULL,'other','1','0'),
('182','ASYNC_STAT_CODE',NULL,'','stat','1','0'),
('183','BAIDU_TRANSLATE_APPID','','','other','1','0'),
('184','ORDER_PREFIX','SN',NULL,'order','1','0'),
('185','SMS_TYPE','Huyi',NULL,'other','1','0'),
('186','SMS_ACCOUNT','',NULL,'other','1','0'),
('187','SMS_PASSWORD','',NULL,'other','1','0'),
('188','MOBILE_REG_TEMPLATE','您的验证码是：【{$Code}】。请不要把验证码泄露给其他人。',NULL,'reg','1','1'),
('190','ORDER_SMS','0',NULL,'order','1','0'),
('191','ORDER_SMS_TO','',NULL,'order','1','0'),
('192','ORDER_SMS_TEMPLATE','您有新的订单：订单编号【{$OrderNumber}】，订单金额【{$TotalOrderPrice}】，下单时间【{$OrderTime}】，请及时处理！',NULL,'order','1','0'),
('193','GUEST_BOOK_SMS','0',NULL,'guestbook','1','0'),
('194','GUEST_BOOK_SMS_TO','',NULL,'guestbook','1','0'),
('195','GUEST_BOOK_SMS_TEMPLATE','',NULL,'guestbook','1','0'),
('196','FEEDBACK_SMS','0',NULL,'guestbook','1','0'),
('197','FEEDBACK_SMS_TO','',NULL,'guestbook','1','0'),
('198','FEEDBACK_SMS_TEMPLATE','',NULL,'guestbook','1','0'),
('199','SMS_IP_MAX','20',NULL,'other','1','0'),
('200','SMS_NUM_MAX','60',NULL,'other','1','0'),
('201','WX_CUSTOMER_SERVICE','0',NULL,'wx','1','0'),
('202','COMMENT_BUY','1',NULL,'comment','1','0'),
('203','COMMENT_TIP','评论事项：有什么问题, 满意, 或者不不满, 都可以在这里评论出来, 这里评论全部源于真实的评论',NULL,'comment','1','1'),
('204','COMMENT_TIP','',NULL,'comment','1','2'),
('205','APP_LOGO','',NULL,'other','1','1'),
('206','APP_LOGO','',NULL,'other','1','2'),
('207','APP_THEME_COLOR','#FF3300',NULL,'other','1','0'),
('208','APP_VERSION','1.0.0',NULL,'other','1','0'),
('209','APP_APK_URL','',NULL,'other','1','0'),
('210','APP_APK_QRCODE','',NULL,'other','1','0'),
('211','APP_IPA_URL','',NULL,'other','1','0'),
('212','APP_IPA_QRCODE','',NULL,'other','1','0'),
('213','APP_TAB2_CHANNELID','21',NULL,'other','1','1'),
('214','APP_TAB2_CHANNELID','40',NULL,'other','1','2'),
('215','APP_TAB2_ICON','ion-ios-book',NULL,'other','1','0'),
('216','APP_TAB3_CHANNELID','55',NULL,'other','1','1'),
('217','APP_TAB3_CHANNELID','43',NULL,'other','1','2'),
('218','APP_TAB3_ICON','ion-ios-videocam',NULL,'other','1','0'),
('219','APP_ABOUT','',NULL,'other','1','1'),
('220','APP_ABOUT','',NULL,'other','1','2'),
('221','APP_TAB2_TITLE','新闻',NULL,'other','1','1'),
('222','APP_TAB2_TITLE','News',NULL,'other','1','2'),
('223','APP_TAB3_TITLE','视频',NULL,'other','1','1'),
('224','APP_TAB3_TITLE','Product',NULL,'other','1','2'),
('225','APP_TAB2_ICON_ACTIVE','ion-ios-book-outline',NULL,'other','1','0'),
('226','APP_TAB3_ICON_ACTIVE','ion-ios-videocam-outline',NULL,'other','1','0'),
('227','APP_VERSION_DESCRIPTION','',NULL,'other','1','1'),
('228','APP_VERSION_DESCRIPTION','',NULL,'other','1','2'),
('229','APP_APK_SIZE','2.8M',NULL,'other','1','0'),
('230','APP_KEY_JIGUANG','',NULL,'other','1','0'),
('231','APP_MASTER_SECRET_JIGUANG','',NULL,'other','1','0'),
('232','WAP_QRCODE','',NULL,'wap','1','0'),
('233','APP_SHARE_TITLE','某某系统App下载',NULL,'other','1','1'),
('234','APP_SHARE_TITLE','App',NULL,'other','1','2'),
('235','APP_SHARE_DESCRIPTION','',NULL,'other','1','1'),
('236','APP_SHARE_DESCRIPTION','',NULL,'other','1','2'),
('237','APP_APK_SHARE_URL','',NULL,'other','1','1'),
('238','APP_APK_SHARE_URL','',NULL,'other','1','2'),
('239','CURRENCY_SYMBOL','￥',NULL,'order','1','1'),
('240','CURRENCY_SYMBOL','$',NULL,'order','1','2'),
('241','XCX_NAME','1',NULL,'wx','1','1'),
('242','XCX_NAME','abc',NULL,'wx','1','2'),
('243','XCX_THEME_COLOR','#FF0000',NULL,'wx','1','0'),
('244','XCX_TAB_COLOR','#006600',NULL,'wx','1','0'),
('245','XCX_TAB_SELECTED_COLOR','#0000FF',NULL,'wx','1','0'),
('246','XCX_TAB_BACKGROUND_COLOR','#FFFF00',NULL,'wx','1','0'),
('247','XCX_TAB_BORDER_STYLE','white',NULL,'wx','1','0'),
('248','XCX_TAB1_CHANNELID','0',NULL,'wx','1','1'),
('249','XCX_TAB1_CHANNELID','0',NULL,'wx','1','2'),
('250','XCX_TAB1_TITLE','首页',NULL,'wx','1','1'),
('251','XCX_TAB1_TITLE','',NULL,'wx','1','2'),
('252','XCX_TAB1_ICON','',NULL,'wx','1','0'),
('253','XCX_TAB1_ICON_ACTIVE','',NULL,'wx','1','0'),
('254','XCX_TAB2_CHANNELID','',NULL,'wx','1','1'),
('255','XCX_TAB2_CHANNELID','',NULL,'wx','1','2'),
('256','XCX_TAB2_TITLE','',NULL,'wx','1','1'),
('257','XCX_TAB2_TITLE','',NULL,'wx','1','2'),
('258','XCX_TAB2_ICON','',NULL,'wx','1','0'),
('259','XCX_TAB2_ICON_ACTIVE','',NULL,'wx','1','0'),
('260','XCX_TAB3_CHANNELID','',NULL,'wx','1','1'),
('261','XCX_TAB3_CHANNELID','',NULL,'wx','1','2'),
('262','XCX_TAB3_TITLE','',NULL,'wx','1','1'),
('263','XCX_TAB3_TITLE','',NULL,'wx','1','2'),
('264','XCX_TAB3_ICON','',NULL,'wx','1','0'),
('265','XCX_TAB3_ICON_ACTIVE','',NULL,'wx','1','0'),
('266','XCX_TAB4_CHANNELID','',NULL,'wx','1','1'),
('267','XCX_TAB4_CHANNELID','',NULL,'wx','1','2'),
('268','XCX_TAB4_TITLE','',NULL,'wx','1','1'),
('269','XCX_TAB4_TITLE','',NULL,'wx','1','2'),
('270','XCX_TAB4_ICON','',NULL,'wx','1','0'),
('271','XCX_TAB4_ICON_ACTIVE','',NULL,'wx','1','0'),
('272','FREE_SHIPPING_THRESHOLD','200',NULL,'order','1','1'),
('273','FREE_SHIPPING_THRESHOLD','200',NULL,'order','1','2'),
('274','POINT_EXCHANGE_RATE','1',NULL,'order','1','1'),
('275','POINT_EXCHANGE_RATE','1',NULL,'order','1','2'),
('276','AUTO_RECEIVE_DAYS','0',NULL,'order','1','1'),
('277','AUTO_RECEIVE_DAYS','0',NULL,'order','1','2'),
('278','WAP_LOGO','/Upload/public/logowapen.png',NULL,'wap','1','2'),
('279','WX_TYPE','3',NULL,'wx','1','0'),
('280','XCX_APP_ID','',NULL,'wx','1','0'),
('281','XCX_APP_SECRET','',NULL,'wx','1','0'),
('282','XCX_PAY_RATE','0',NULL,'wx','1','0'),
('283','XCX_ACCOUNT_NAME','',NULL,'wx','1','0'),
('284','XCX_ACCOUNT_KEY','',NULL,'wx','1','0'),
('285','Longitude','113.083961',NULL,'contact','1','1'),
('286','Longitude','116.414717',NULL,'contact','1','2'),
('287','Latitude','28.232137',NULL,'contact','1','1'),
('288','Latitude','39.908184',NULL,'contact','1','2'),
('289','XCX_QRCODE','',NULL,'wx','1','1'),
('290','XCX_QRCODE','',NULL,'wx','1','2'),
('291','SearchPageSize','20',NULL,'other','1','0'),
('292','HomeRollPage','10',NULL,'other','1','0'),
('293','DistributeEnable','0',NULL,'other','1','0'),
('294','DistributeRequirement','1',NULL,'other','1','1'),
('295','DistributeRequirement','2',NULL,'other','1','2'),
('296','MinMoney','105',NULL,'other','1','1'),
('297','MinMoney','100',NULL,'other','1','2'),
('298','DistributeMode','1',NULL,'other','1','1'),
('299','DistributeMode','2',NULL,'other','1','2'),
('300','OrderRate','20',NULL,'other','1','1'),
('301','OrderRate','50',NULL,'other','1','2'),
('302','BuyerRate','0',NULL,'other','1','1'),
('303','BuyerRate','20',NULL,'other','1','2'),
('304','ReturnGrade','2',NULL,'other','1','1'),
('305','ReturnGrade','3',NULL,'other','1','2'),
('306','WithdrawThreshold','500',NULL,'other','1','1'),
('307','WithdrawThreshold','5001',NULL,'other','1','2'),
('308','MinWithdraw','200',NULL,'other','1','1'),
('309','MinWithdraw','101',NULL,'other','1','2'),
('310','QiniuEnable','0',NULL,'other','1','0'),
('311','QiniuAccessKey','',NULL,'other','1','0'),
('312','QiniuSecretKey','',NULL,'other','1','0'),
('313','QiniuBucketName','',NULL,'other','1','0'),
('314','QiniuUrl','',NULL,'other','1','0'),
('315','QiniuMirrorUrl','',NULL,'other','1','0'),
('316','QiniuInterlaceEnable','1',NULL,'other','1','0'),
('317','QiniuFileType','png|jpg|jpeg|ico|bmp|gif',NULL,'other','1','0'),
('318','BaiduPushEnable','0',NULL,'other','1','1'),
('319','BaiduPushEnable','0',NULL,'other','1','2'),
('320','BaiduPushToken','9n8v2Tyw3cP6U1vm',NULL,'other','1','1'),
('321','BaiduPushToken','',NULL,'other','1','2'),
('322','DistributeEmail','1',NULL,'other','1','0'),
('323','DistributeEmailTitle','会员返佣通知',NULL,'other','1','0'),
('324','DistributeEmailBody','您好！{$Name}\n订单{$OrderNumber}已确认收货，您本次获得佣金{$Money}！\n{$Time}',NULL,'other','1','0'),
('326','DistributeSmsBody','您好，【{$Name}】，订单【{$OrderNumber}】已确认收货，您本次获得佣金{$Money}，【{$Time}】',NULL,'other','1','0'),
('325','DistributeSms','1',NULL,'other','1','0'),
('327','ImageProcess',NULL,NULL,'other','1','0'),
('328','AdminThemeColor','#2589ff',NULL,'basic','1','0'),
('329','CheckUpdate','1',NULL,'basic','1','0');

INSERT INTO `youdian_delivery_time` VALUES
('1','工作日、双休日与假日均可送货 ','1','1','1'),
('2','只双休日、假日送货(工作日不用送) ','2','1','1'),
('3','只工作日送货(双休日、假日不用送)','3','1','1'),
('4','尽量安排其他时间送货,请备注说明','4','1','1'),
('5','Working day, weekend and holiday delivery available','1','1','2'),
('6','Only weekends, holidays and delivery (working days do not send)','2','1','2'),
('7','Only working days delivery (weekends, holidays do not send)','3','1','2'),
('8','Try to arrange delivery time, please Remarks','4','1','2');

INSERT INTO `youdian_distributor_level` VALUES
('1','铜牌分销商','20','15','5','0',''),
('2','银牌分销商','25','20','10','2000',''),
('3','金牌分销商','30','25','15','5000','');

INSERT INTO `youdian_guestbook` VALUES
('1','0','aaa','192.168.1.105','15211270936','aaaaa','aaaa','2016-10-18 14:05:51',NULL,NULL,'0','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('2','0','','192.168.1.199','13548984883','1','','2017-05-09 10:17:07',NULL,NULL,'0','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('3','0','','192.168.1.199','13588888888','1','','2017-05-09 10:18:12',NULL,NULL,'0','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
('4','0','','192.168.1.199','13588889999','1','','2017-05-09 10:43:08',NULL,NULL,'0','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

INSERT INTO `youdian_info` VALUES
('201','22','','1','国产首款5G芯片今年下半年将推出','','<p>近期，&ldquo;中国芯&rdquo;全民热议仍在持续。对此，紫光集团全球执行副总裁兼紫光展锐CEO曾学忠表示，未来10年是人工智能时代， 5G和AI将会迎来爆发，技术变革的驱动力也来自芯片。</p>\r\n\r\n<p>他强调，未来10年不管经济如何发展，都离不开芯片。&ldquo;如果说钢铁是工业时代的基础，芯片就是数字时代的基础，整个半导体行业决定了未来世界的发展走向。&rdquo;</p>\r\n\r\n<p>艾媒咨询发布的《2018Q1中国芯片产业市场专题报告》显示，2017年中国集成电路产量已达1564.6亿块，较2016年增长18.7%，随着国家对芯片行业重视加强，以及企业、院所等机构未来研发资源投入加大，中国集成电路产量未来仍将呈现较快增长状态。</p>\r\n\r\n<p>中国是目前全球最大、增长最快的市场，而且在2017年全球十大芯片设计排名榜上，中国企业已占两席&mdash;紫光展锐和华为海思。</p>\r\n\r\n<p>据了解，从2G、3G到4G再到当前5G，紫光展锐始终坚持自主创新。2018年展锐推出了SC9850KH芯片平台，这是中国首款真正实现商用的自主国产CPU芯片，也是中国首款拥有自主知识产权的嵌入CPU关键技术的4G芯片平台。同时展锐也推出了首款8核人工智能芯片平台SC9863，降低了为大众消费者进入5G、AI的门槛。</p>\r\n\r\n<p>曾学忠称，芯片设计是整个芯片行业的顶端，它对行业、对产业的贡献是1比10比100的关系，1元的芯片可以撬动行业100元的价值，这就是为什么芯片设计作为集成电路产业龙头的重要性。世界是平的，也是平行的。未来全球半导体市场应是平行发展的，你中有我、我中有你，全球互为一体。</p>\r\n\r\n<p>据悉，今年展锐在5G的研发上开启了&ldquo;5G芯片全球领先战略&rdquo;，先后与中国移动、英特尔、华为、是德科技、罗德与施瓦茨达成战略合作，并计划于2018年内推出首款5G芯片，2019年下半年商用首款5G手机平台，实现与5G移动网络的部署同步推向市场。</p>\r\n','0','/Upload/news/15.jpg','','','0','0','','','','','0','2018-06-05 18:13:08',NULL,'16','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('200','22','','1','小黄车到底会不会黄？','','<p>在一次次传言和辟谣中，小黄车昭示着共享单车行业的风雨飘摇。</p>\r\n\r\n<p>　　关于小黄车资金链紧张的消息并非第一次传出，在一次次传言和辟谣中，小黄车昭示着共享单车行业的风雨飘摇。</p>\r\n\r\n<p>　　6月4日有媒体报道称，ofo小黄车面临资金链紧张、大规模裁员等困境。称此次裁员人数将是ofo有史以来规模最大的一次，总部整体裁员比例达到50%，且存在继续扩大范围的可能性。裁员涉及ofo的全部业务条线，包括业务团队与职能部门。其中供应链团队80人，裁员比例为60%，即供应链最终只保留32人。</p>\r\n\r\n<p>　　与此同时，管理层也将发生剧变。海外市场主管张严琪离职，整个海外部门解散。同时离职的高管还包括负责市场公关业务的高级副总裁南楠与公关内容总监杨汛。</p>\r\n\r\n<p>　　海外业务不会裁撤</p>\r\n\r\n<p>　　针对此事，ofo一位内部员工告诉第一财经，南楠的确已经离职，但主要是出于个人原因。张严琪并未离职，近期公司内部进行了一次大的组织架构调整，张严琪将可能负责区块链业务。</p>\r\n\r\n<p>　　&ldquo;公司大范围裁员一事并未听说，从目前公司大的微信群来看，过年至今人员从3000人左右到目前2800人左右，并未出现报道中所提及的裁员比例。&rdquo;上述员工告诉第一财经。</p>\r\n\r\n<p>　　事件发生后的第一时间，ofo联合创始人于信在朋友圈进行了回应，称COO离职消息不符，海外业务解散不实。而关于报道中提到的裁员问题，于信表示，此事不好澄清，只能交给时间去证明，此事背后是有人在推动。谣言当事人之一杨汛也在朋友圈进行了回应，称自己并没有离职。</p>\r\n\r\n<p>　　虽然ofo方面否认了管理层地震和大规模裁员，但从ofo与滴滴不和，三位派驻高管离职到ofo绕过滴滴抵押单车向阿里借款17.7亿补血，以及拒绝滴滴收购要约被曝降薪裁员，一定程度上反映出ofo的资金和运营压力。</p>\r\n\r\n<p>　　无论是小蓝、小鸣单车的破产宿命，还是摩拜最终的&ldquo;胳膊拧不过大腿&rdquo;，没有清晰的盈利模式和正向现金流，使得共享单车企业难以走向独立运营。</p>\r\n\r\n<p>　　在共享单车创办早期，创始团队甚至投资人一度认为依靠租金可以收回成本，实现盈利。ofo创始人戴威曾算过一笔账：目前每辆车大概能带来5~10元的收入，ofo自行车的成本不到300元，若按照12个月报废来算折旧的话，每天的折旧不到1元，每个运维人员大概负责300辆车，一天薪水100元，平摊到每辆车上，一天的成本也不到1元，总体算下来，毛利在70%~80%左右。</p>\r\n\r\n<p>　　但在资本助推之下，现实竞争场上的变化参数远比这笔账要复杂。</p>\r\n\r\n<p>　　数家单车公司大量铺车，推出&ldquo;免押金&rdquo;、&ldquo;免费&rdquo;等模式之后，仅靠租金盈利已不太现实。&ldquo;共享单车商业模式是成立的，但估值太高，在缺乏管理的情况下，免租金模式很难在一二线城市继续，押金的挤兑也很严重。&rdquo;小鸣单车前CEO陈宇莹曾向第一财经表示。</p>\r\n\r\n<p>　　资本的收紧，高额的管理、运维成本，仅仅依靠单一的租金收入很难带来可观的利润。新年过后，摩拜和ofo小黄车不约而同地停止了价格战。ofo甚至推出了车身商业化广告，在APP上也上线了开屏广告。</p>\r\n\r\n<p>　　刊例显示，ofo给出的资源数据为&ldquo;1500万辆单车、覆盖2.5亿用户&rdquo;，而品牌定制车身的广告价格为每辆2000元/月，开屏广告价格为100~120元，1000CPM起售。在第三方职场社交软件脉脉上，记者也发现有多名ofo B2B事业部员工在推广广告业务。</p>\r\n\r\n<p>　　但在实际推广中，品牌主对于车身广告效果仍存在担忧。&ldquo;一方面广告位比较狭窄，不少停放在路边的共享单车被贴满牛皮癣广告，效果会打折扣，同时流动广告还要考虑到品牌呈现环境安全问题。&rdquo;一位资深广告界人士告诉记者。</p>\r\n\r\n<p>　　更直接的风险来自于政策，包括北京、上海在内的城市，已经开始明令禁止在车辆上设置商业广告，广告所能带来的营收增长并不乐观。</p>\r\n\r\n<p>　　左右手互搏</p>\r\n\r\n<p>　　共享单车市场也在酝酿新的变化，巨头是其中最大的变量。</p>\r\n\r\n<p>　　同被阿里系投资的哈罗单车再次获得蚂蚁金服领投20亿元投资。根据永安行公告来看，参股公司低碳科技获得20.60亿元增资，其中蚂蚁金服全资子公司上海云鑫增资18.93亿元，上海云鑫对低碳科技的持股比例将从27.6%升至36.7%；永安行的持股比例将从10.2%降至8.9%，为第二大股东，低碳科技的整体估值不低于14.68亿美元。</p>\r\n\r\n<p>　　低碳科技是哈罗单车与永安行低碳合并后的运营主体，过去的半年多时间里，哈罗单车先后完成了4轮融资，总融资金额超过15亿美元，融资规模和速度与整个行业形成鲜明反差。蚂蚁金服领投了其中的三轮融资，成为哈罗单车的第一大股东。</p>\r\n\r\n<p>　　错过了打车大战带来的流量入口之后，阿里不会再错过单车这个巨大的线下场景，3月份以来哈罗单车所采取的全国芝麻信用免押金策略效果明显，成为阿里推广支付工具的重要抓手。在业界看来，作为阿里系布局共享单车两枚重要棋子，蚂蚁金服对哈罗单车的频频加持，使得哈罗单车的战略地位在提升。</p>\r\n\r\n<p>　　另一面，一直寻求独立发展的ofo则在尝试建立自己的信用体系。此前，ofo与芝麻信用合作在全国25座城市推出信用免押金的政策，现在能使用信用免押金的仅剩上海、杭州、广州、深圳和厦门5座城市。在其他城市，用户需要购买95元&ldquo;福利包&rdquo;后才可继续享受免押金服务，95元&ldquo;福利包&rdquo;被直接充入账户余额，消费完后，用户需重新购买。</p>\r\n','0','/Upload/news/14.jpg','','','0','0','','','','','0','2018-06-05 18:13:08',NULL,'12','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('204','55','','1','善待老人就会善待自己','','','0','/Upload/video/shandai.jpg','','https://res.youdiancms.com/shandai.mp4','0','0','','','','','0','2018-06-07 16:16:36',NULL,'16','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('197','22','','1','比尔·盖茨说，今年暑假要读这些书——盖茨的夏日书单','','<p>坐拥亿万身家的慈善家比尔&middot;盖茨为了疫苗和援助项目不惜花重金，但他也知道，金钱买不到更丰富的知识。</p>\r\n\r\n<p>　　所以，每年夏天（以及每逢节假日期间），盖茨都会分享一份阅读清单，打着沙滩读物的旗号介绍令人大开眼界的概念。这算不上什么秘密，但盖茨每年都会佯装出惊喜的样子。他在个人博客盖茨笔记（Gates Notes）上写道，&ldquo;当我整理好今年夏天的推荐书单时，我发现其中几本书探讨的都是一些重大的问题。&rdquo;</p>\r\n\r\n<p>　　事实上，今年他还列出了几个核心问题，读者们可以在这些大部头里找到答案。&ldquo;天才的诀窍是什么？好人为什么没有好报？人类从哪里来，又往哪里去？&rdquo;</p>\r\n\r\n<p>　　以下书目似乎按先后顺序解答了这几个问题。从列奥纳多&middot;达&middot;芬奇（Leonardo da Vinci）的传记，一位女性抗击癌症的回忆录，到借鬼魂之口虚构叙述亚伯拉罕&middot;林肯（Abraham Lincoln）人生的其中一夜，甚至还有一本解释生命起源与发展的书。以上只涵盖了4个主题，那么不妨把第5本书视为呼吁采取行动的号角。此书作者是去年去世的全球健康专家汉斯&middot;罗斯林（Hans Rosling）。它回过头来探讨了一些经验教训，更为直接地阐述了每个人都有能力为世界多行善举。</p>\r\n\r\n<p>　　《列奥纳多&middot;达&middot;芬奇》（Leonardo da Vinci）</p>\r\n\r\n<p>　　作者：沃特&middot;艾萨克森（Walter Isaacson）</p>\r\n\r\n<p>　　[封面图：西蒙与舒斯特出版公司（Simon &amp; Schuster）]</p>\r\n\r\n<p>　　作为全球最受敬仰的画家兼思想家，达&middot;芬奇基本上靠自学成才，500多年前的技术局限性并未限制他对世界运转原理的猜想。正如盖茨所写，&ldquo;当他渴望了解一件事情时，无论是通过心脏的血流亦或是啄木鸟舌头的形状，他都会密切观察，记下自己的想法，试着寻找答案。&rdquo;好奇心比以往任何时候都更可贵，尤其是在互联网时代。</p>\r\n\r\n<p>　　《万事皆有因，以及其他我爱听的谎言》（Everything Happens for a Reason and Other Lies I&rsquo;ve Loved）</p>\r\n\r\n<p>　　作者：凯特&middot;鲍勒（Kate Bowler）</p>\r\n\r\n<p>　　[封面图：企鹅兰登书屋（Penguin Random House）]</p>\r\n\r\n<p>　　当一位杜克大学神学院（Duke Divinity School）的教授被诊断出结肠癌第四期时，她努力去接受这种偶然事件的随机性，也试图摸索最终如何控制这种随机性。盖茨认为，&ldquo;有些&lsquo;为什么&rsquo;是无法用事实给出满意答复的。&rdquo;在他看来，这本书阐明了过分注重因果思维的风险。鲍勒在一个门诺派教徒家庭中长大，家人认为坚定的信仰往往能够得到切实回报。这样的成长环境赋予她幽默、无奈而又极为可贵的思考视角。</p>\r\n\r\n<p>　　《林肯在中阴界》（Lincoln in the Bardo）</p>\r\n\r\n<p>　　作者：乔治&middot;桑德斯（George Saunders）</p>\r\n\r\n<p>　　[封面图：企鹅兰登书屋]</p>\r\n\r\n<p>　　这本奇幻小说的前提设定和文风一样不落俗套。故事发生在一夜之间，美国内战刚刚开始，亚伯拉罕&middot;林肯总统来到了最近离世的11岁儿子下葬的墓地。随后，鬼魂出现了，故事主要以类似剧本的对话方式展开。如盖茨所写，&ldquo;总统重新认识到，他把别人的儿子送上战场为国捐躯，给其他家庭制造了悲剧。他必须做出选择。战争应该继续吗？如果应该，我们如何保证最终的结果值得我们付出如此沉痛的代价？&rdquo;</p>\r\n\r\n<p>　　《起源故事：万物之大历史》（Origin Story: A Big History of Everything）</p>\r\n\r\n<p>　　作者：大卫&middot;克里斯蒂安（David Christian）</p>\r\n\r\n<p>　　[封面图：利特尔与布朗出版公司（Little, Brown and Company）]</p>\r\n\r\n<p>　　历史学家大卫&middot;克里斯蒂安擅长把复杂的世界历史讲得深入浅出，通俗易懂，所以他2011年的历史学TED演讲已被浏览超过800万次。这本书是这种能力的进一步延展。正如盖茨在书评中所写，克里斯蒂安更注重改变的起始瞬间，比如他解释了大爆炸的物理学和化学原理，以及人类从单细胞生物进化成辨识度更高的灵长类动物背后的生物学和人类学道理。对于受到启发的教师、父母或终生学习者，盖茨还推荐了克里斯蒂安所开设的免费在线课程。</p>\r\n\r\n<p>　　《事实真相》（Factfulness）</p>\r\n\r\n<p>　　作者：汉斯&middot;罗斯林、欧拉&middot;罗斯林（Ola Rosling）和安娜&middot;罗斯林&middot;洛恩朗德（Anna Rosling Ronnlund）</p>\r\n\r\n<p>　　早在4月份，盖茨就推荐过这本书，还专门单独撰写了一篇评论，强调它对未来改革家而言有着极大的鼓舞力量。盖茨当时写道，&ldquo;这本书大部分篇幅都在阐述阻止人类以事实眼光看待世界的10种本能，从恐惧本能（我们更关注可怕的事物）到规模本能（独立的数据看上去往往比实际更可观）再到间隔本能（大多数人处在两种极端之间）。针对每一种本能，他都提供了实用的建议，引导我们如何克服与生俱来的偏见。&rdquo;</p>\r\n\r\n<p>　　最后，当然少不了盖茨式的经典总结：对全球许多人而言，生活真的在改善。但要继续前行，我们还需要大量的想象力、灵感与投入。</p>\r\n','0','/Upload/news/11.jpg','','','0','0','','','','','0','2018-06-05 18:03:03',NULL,'5','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('196','21','','1','可穿戴设备不好卖了， Apple Watch 依旧一枝独秀','','<p>今年的苹果的 WWDC 大会彻底「软」了，唯一发布的硬件是新的 Apple Watch 彩虹表带，不过由 Apple Watch 领衔的苹果可穿戴设备业务，已经逐渐成为了行业老大了。</p>\r\n\r\n<p>　　今天市场研究公司 IDC 发布了一份 2018 Q1 全球可穿戴设备的市场报告，数据显示第一季度全球可穿戴设备出货量为 2510 万台，同比增长 1.2 ％，相比去年同期 18 ％ 的增幅可以说是暴跌了。</p>\r\n\r\n<p>　　可穿戴设备与智能手机一样陷入低迷，这主要是由于基础类的可穿戴设备的出货量下跌 9.2 ％造成的，与此同时智能设备更受消费者青睐，苹果和 Fitbit 等相对高端的智能可穿戴设备增长了 28.4 ％。</p>\r\n\r\n<p>　　请输入描述</p>\r\n\r\n<p>　　跟据 IDC 的统计，手表和手环占了第一季度全球可穿戴设备出货量的 95 ％，而 苹果无疑是其中最大的赢家。</p>\r\n\r\n<p>　　随着支持蜂窝网络的 Apple Watch Series 3 上市，Apple Watch 出货量同比增长 13.5 ％，苹果可穿戴设备的市场份额从 14.3 ％增长到 16.1 ％，稳坐榜首，在市场整体低迷的大背景下一枝独秀。</p>\r\n\r\n<p>　　请输入描述</p>\r\n\r\n<p>　　根据苹果今年第一季度财报，Apple Watch 营收和出货量涨幅更是双双超过50%。而 Apple Watch Series 3 的销量较 Series 2 一年前的销量多出一倍多。</p>\r\n\r\n<p>　　根据市场研究机构 GBH Insights 的调查，在购买 Apple Watch Series 3 的用户中，70% 都是新用户。</p>\r\n\r\n<p>　　在苹果第二季度的财报电话会议里， 库克表示包括 AirPods、Beats 耳机和 Apple Watch在内可穿戴设备业务营收增长近 50%，撑起了苹果「其他产品」超 90 ％的增长，库克对这一业务的评价是：</p>\r\n\r\n<p>　　我们的可穿戴设备业务现在可以跻身「财富 300 强」行列。</p>\r\n\r\n<p>　　其中在智能手表市场占据半壁江山的 Apple Watch 功不可没，虽然本次 WWDC 大会没推出新款 Apple Watch，但也更新了 watchOS 5 ，更好地支持运动功能。</p>\r\n','0','/Upload/news/10.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'18','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('191','21','','1','微软正式宣布75亿美元收购GitHub，开发者们会买账吗？','','<p>微软终于敲定了收购 GitHub 的消息。</p>\r\n\r\n<p>　　6 月 4 日晚间，微软方面发出通告，正式宣布计划以 75 亿美元的股票收购软件代码托管网站 GitHub，该桩交易预计在今年年底完成。</p>\r\n\r\n<p>　　GitHub 成立于 2008 年 4 月，至今刚好十年。2015 年时，GitHub 估值 20 亿美元，而在短短三年时间里，GitHub 市值涨了近 4 倍，成为当下最受欢迎的社交编程及代码托管平台。</p>\r\n\r\n<p style=\"text-align: center;\"><img src=\"/Upload/news/a3.jpg\" style=\"width: 1080px; height: 720px;\" /></p>\r\n\r\n<p style=\"text-align: center;\">　　据统计，截至今年 3 月份，GitHub 高频用户数量达 2800 万，并为 Java、Python 和 C++ 等编程语言软件托管了 8000 万个源代码存储库 。NASA 等公共机构和 Google、苹果、亚马逊等大型科技公司也均在 GitHub 上有业务。</p>\r\n\r\n<p>　　由于 GitHub 社区用户以白人男性居多（据说比例高达 97%），因而被中国程序员们戏称为「全球最大同性交友网站」。</p>\r\n\r\n<p>　　GitHub CEO Chris Wanstrath 表示，社区平台早在 2011 年就实现了盈利。目前，GitHub 的盈利模式主要有三种：代码托管服务、数据沉淀和云存储，以及企业猎头招聘社区。</p>\r\n\r\n<p>　　而据 CNBC 去年报道，GitHub 预计年收入超过 2 亿美元，其中超过 1.1 亿美元来自 B 端企业服务营收。</p>\r\n\r\n<p>　　知情人士透露，这样一家具备盈利能力的公司，没有选择上市而是向微软臣服，一部分原因是对微软重视开发者业务的能力与决心十分信任。</p>\r\n\r\n<p>　　有趣的是，微软曾是开源软件的坚决反对者，但在 Nadella 担任微软 CEO 后，微软逐渐成为开源社区最积极的推动者之一。从 2014 年微软开源编程基础工具 .NET 至今，微软已经陆续推出上百个开源项目；在 2016 年，微软还超越了 Facebook 和 Google，登顶 GitHub 的贡献榜。</p>\r\n\r\n<p>　　至于微软收购 GitHub 的意义，Nadella 在推特上评论说「微软 + GitHub = 赋能开发者」。据业内人士推测，从微软把 GitHub 部分收入并进智能云业务板块来看，是为了推行「AI + 云」战略，以促使开发者为微软包括云平台 Azure Cloud 在内的多平台开发应用。</p>\r\n\r\n<p>　　^ 从左至右依次是 GitHub 联合创始人Chris Wanstrath、微软 CEO Satya Nadella、GitHub 新任 CEO Nat Friedman</p>\r\n\r\n<p>　　微软方面表示 ，GitHub 今后的运营会保持原有风格，以开发者至上，保持独立运作。</p>\r\n\r\n<p>　　收购完成后，微软公司副总裁 Nat Friedman 将担任 GitHub 首席执行官 ，GitHub 联合创始人兼前 CEO Chris Wanstrath 将成为微软技术研究员，向执行副总裁 Scott Guthrie 汇报工作，开展战略性软件开发计划。</p>\r\n\r\n<p>　　一直以来，源于诺基亚、Hotmail、Skype 等前车之鉴，人们对微软的那些大手笔收购都抱着嘲讽质疑的态度 。那么 GitHub 未来的命运会是怎样呢？或许只有时间才能给出答案。</p>\r\n','0','/Upload/news/5.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'4','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('198','22','','1','面对人工智能，一万句我爱你，不如一句我懂你','','<p>小时候，我听爸爸妈妈说最多的一句话就是：&ldquo;你不懂！长大之后你就明白了。&rdquo;</p>\r\n\r\n<p>　　以我五岁的智商，我把这句话翻译为：滚蛋。</p>\r\n\r\n<p>　　我内心是不服的，大人判断一件事情的逻辑，难道就真的没办法给小孩子解释明白？一种被当成智障的屈辱感油然而生。。。</p>\r\n\r\n<p>　　这种事情在人生中反复发生，例如多年后，一个妹子泪眼婆娑地望着我说：你不懂！然后转身消失在夕阳的余晖下，那辆玛莎拉蒂里。留下我默默地推着自行车百思不得姐。</p>\r\n\r\n<p>　　多年后我才发现这个事实：你的朋友、亲人、爱人、你所珍惜和依赖的人，当他说出&ldquo;为你好！&rdquo;&ldquo;你不懂！&rdquo;&ldquo;听我的！&rdquo;的时候，多半是因为没办法给出让你理解和信服的解释。</p>\r\n\r\n<p>　　你看过《ET》吗？两个人之间的交流，并不比人和一个外星人交流更简单。你可以细品品。。。</p>\r\n\r\n<p><img src=\"/Upload/news/a4.jpg\" style=\"width: 1080px; height: 567px;\" /></p>\r\n\r\n<p>　　然而我终究想说：</p>\r\n\r\n<p>　　一万句&ldquo;我爱你&rdquo;，不如一句&ldquo;我懂你&rdquo;。</p>\r\n\r\n<p>　　试图理解，是我们的本能。事实上，理解一个人很难；理解一个人工智能也很难。</p>\r\n\r\n<p>　　接下来的五分钟，我们就来讨论两个科幻问题：</p>\r\n\r\n<p>　　1、我们有没有可能理解人工智能的每一个决定？</p>\r\n\r\n<p>　　2、如果有，我们用什么方法来理解人工智能？</p>\r\n\r\n<p>　　邢新宇</p>\r\n\r\n<p>　　邢新宇，就是今天的主咖了。这位宾州州立大学的教授，在和京东安全合作，试着用算法来解释人工智能的每一个决策。（至于为什么是和京东安全合作，看到后面你就明白了。）</p>\r\n\r\n<p>　　Let&#39;s ROCK</p>\r\n\r\n<p>　　1、我们真的可以&ldquo;懂&rdquo;人工智能吗？</p>\r\n\r\n<p>　　先纠正一下绝大部分人的误区：</p>\r\n\r\n<p>　　如果你觉得，人们可以像理解&ldquo;1+1=2&rdquo;那样理解人工智能所做的每一个决策。那么恭喜你，请关注浅黑科技，明天继续来打卡学习。</p>\r\n\r\n<p>　　事实上，人工智能的绝大部分决策，人是不能理解的。哪怕是制造他们的科学家&mdash;&mdash;这些人工智能的&ldquo;爸爸妈妈&rdquo;也不能理解。</p>\r\n\r\n<p>　　你可能会说，纳尼？人造出来的东西，自己怎么会不理解？</p>\r\n\r\n<p>　　举个例子，当年我们的祖先发明钻木取火的时候，他们其实并不懂燃烧的原理。先使用，后理解，这本就是我们认识世界的规律。</p>\r\n\r\n<p>　　举一个大多数人都知道的例子：</p>\r\n\r\n<p>　　阿法狗，这个最著名的人工智能围棋大师。</p>\r\n\r\n<p>　　在具体的对弈中，科学家爸爸只为它设定了目标&mdash;&mdash;赢得比赛，却根本没有规定阿法狗必须按照人类的套路来落子。当然也正是因为如此，它才有可能&ldquo;青出于蓝胜于蓝&rdquo;，完虐柯洁大棋渣。</p>\r\n\r\n<p>　　人工智能的决策过程，就像这个汉子画画一样，全程旁观者都会感到&ldquo;莫名其妙&rdquo;，直到最后一秒绝杀，你才会恍然大悟。</p>\r\n\r\n<p>　　OK，误区纠正完毕，结论是：</p>\r\n\r\n<p>　　从某个角度看，人工智能的水平已经超过人脑太多，如何理解人工智能（AI），其实是个国际难题。</p>\r\n\r\n<p>　　如果只是用 AI 下个棋，不理解也就不理解了。但是，AI 可是越来越普及，这个我们无法理解的东西开始围绕在生活中，就像一个朋友，他永远戴着面具和你说话，想想就让人头皮发麻。</p>\r\n','0','/Upload/news/12.jpg','','','0','0','','','','','0','2018-06-05 18:09:21',NULL,'1','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('192','21','','1','快手确认收购Acfun A站将保持独立品牌','','<p>6月5日早间，短视频网站快手针对收购视频弹幕网站Acfun（下文简称A站）一事向《一线》发来回应：</p>\r\n\r\n<p>快手方面确认已完成对Acfun的整体收购，未来，A站将保持独立品牌、维持独立运营、保持原有团队、独立发展。而快手也会在资金、资源、技术等给予A站大力支持。</p>\r\n\r\n<p>此外，A站CEO刘炎焱也对腾讯科技表示，消息属实，今天终于可以对外说了。</p>\r\n\r\n<p>今年年初，A站曾经历关站、无法访问等风波。有消息称其得到了阿里系的支持后才恢复正常运作，不过后来又有消息称阿里巴巴放弃了对A站的控股计划，转而由今日头条接盘。</p>\r\n\r\n<p>但事实上，据《一线》了解，快手一直是A站的潜在融资方之一。</p>\r\n','0','/Upload/news/6.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'5','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('193','21','','1','摩拜早期投资人刘二海：当你足够强大，自不必与巨头为伍','','<p>猎云注：这是摩拜早期投资人、愉悦资本创始及执行合伙人刘二海题为《穿越魔鬼通道》的演讲。在演讲中刘二海表示，中国的创业发展到今天，已经到了全新的阶段，已升级为产品、团队的全方位竞争。企业飞速成长，巨头强势入场，这一切，都要求创业者要研判并创造自己企业的独特价值。文章来源：英诺天使（ID：innoangel99）作者：卞小草</p>\r\n\r\n<p>　　什么是&ldquo;魔鬼通道&rdquo;？</p>\r\n\r\n<p>　　我今天分享的主题是《穿越魔鬼通道》，细看现在很多企业，包括刚才提到的共享单车，曾经有一段时间大家说共享单车太多了，颜色都不够用了，但几乎在一年之内，现在生存下来的颜色只有三家左右。</p>\r\n\r\n<p>　　从之前的团购、专车、餐饮O2O、视频门户到后来的共享单车、视频直播、二手车市场，我们发现一个共性，几乎每一个大的行业都要经过一次洗礼。</p>\r\n\r\n<p>　　这个共性在形成过程中有3个现象：1、竞争迅速升级；2、企业极速成长；3、巨头入场博弈。</p>\r\n\r\n<p>　　一、竞争迅速升级。有一次我碰上一个在三里屯的投资人，他说你们投资的的共享单车挡住了我们的路，你们作为投资人就没有一点罪恶感吗？我说真抱歉，但竞争就是这么迅速而激烈。</p>\r\n\r\n<p>　　二、企业极速成长。摩拜从没有车到有800、900万辆车，只有一年的时间包括现在抖音在短时间内的爆发也影响到了腾讯的朋友圈。</p>\r\n\r\n<p>　　为什么企业能够这么快速的成长？一个重要原因是当下在网上找到用户变得非常容易，所以这些企业可以迅速成功。此外投资人的资金加持，也加速了企业的成长速度。</p>\r\n\r\n<p>　　国外一位投资人曾经问我：&ldquo;你们怎么拼命给企业钱？&rdquo;看起来很疯狂的投资，其实我们很清楚自己在做什么，这就是当下战场的规则，我们也没有办法，大量资本的涌入也推动了企业的发展，你作为一个player必须遵守。</p>\r\n\r\n<p>　　三、巨头入场博弈。几乎在所有行业都可以看到巨头的身影，这也给在座的朋友们带来了不一样的挑战：要不要站队？不站队巨头投了别人怎么办？初创企业处在惶恐和焦虑中。</p>\r\n\r\n<p>　　从我们看到的情况来说，企业如果想获得的成功，必须得穿越魔鬼通道，必须经历竞争迅速升级、企业极速成长以及巨头入场博弈的过程，才能成长起来。</p>\r\n\r\n<p>　　&ldquo;别人&rdquo;是如何穿越魔鬼通道的？</p>\r\n\r\n<p>　　如何穿越魔鬼通道？我们还是要回到商业本质和商业模式说起。举两个例子，我们可以看出，这些企业是如何真正穿越或正在穿越魔鬼通道的。</p>\r\n\r\n<p>　　第一个例子：蔚来汽车。蔚来汽车主要是在技术工程能力上超越竞争对手，最重要的还是他们的工程能力。</p>\r\n\r\n<p>　　2016年10月12日，在德国纽博格林北环赛道中，蔚来汽车EP9以7分05秒创造了最快电动汽车圈速记录；2017年2月23日，在美国得克萨斯美洲赛道的无人驾驶测试中，EP9创造了每小时257公里的速度纪录，成为全球最快的无人驾驶汽车；同年5月12日，EP9以6分45秒900的成绩再次刷新纪录；12月16日，蔚来汽车正式发布首款量产车ES8。</p>\r\n\r\n<p>　　第二个例子：京东。京东并没有太多技术，在座各位的技术可能做的比他好。在当年，相对于更早成立的当当、卓越、亚马逊，京东是靠什么超越竞争对手的呢？</p>\r\n\r\n<p>　　其实关键在于京东做了大件物品的物流，这其中没有太多的技术，但是补齐了价值链中尚不成熟的部分。基础设施的完善也可以创造价值，也可以帮助企业穿越魔鬼通道。</p>\r\n\r\n<p>　　蔚来汽车和京东穿越魔鬼通道的秘诀，一个是工程技术，一个是基础架构完善。</p>\r\n\r\n<p>　　愉悦资本做了不少的投资，我们有一个&ldquo;面向根据地的投资&rdquo;投资策略。所谓根据地就是说地域比较广阔，在这个领域可以进行多个投资，我们在这个领域已经投出了数一数二的项目；最后，我们在这个领域有深厚的人脉积累和深刻的理解力。</p>\r\n','0','/Upload/news/7.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'2','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('194','21','','1','一线B站与动画制作公司绘梦动画成立合资公司','','6月5日消息，近日&ldquo;上海信息科技有限公司&rdquo;与动画制作公司&ldquo;上海文化传播有限公司&rdquo;成立合资公司&ldquo;（上海）文化传播有限公司&rdquo;。<br />\r\n<br />\r\n据悉，新公司B站占股60%，绘梦动画占股40%，由董事长陈担任董事长，有气前联合创始人兼担任总经理。<br />\r\n<br />\r\n此次B站与动画成立合资公司，或意在增强其动画制作能力。对此，腾讯《一线》向B站求证，暂无回应。<br />\r\n<br />\r\n公开资料显示，动画成立于2013年，公司品牌为&ldquo;HAOLINERS&rdquo;，其制作动画包括《我叫白小飞》《狐妖小红娘》《灵域》《端脑》《雏蜂》《那年那兔那些事》《从前有座灵剑山》等，是国内最主要的动画公司之一。<br />\r\n<br />\r\n据悉，目前绘梦动画在东京、首尔成立了分公司，与富士电视台、GENOSTUDIO有合作关系，且与东京MX电视合作推出了&ldquo;绘梦时间&rdquo;节目','0','/Upload/news/8.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'2','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('195','21','','1','为何又是京东？搜狗王小川道出其中秘密！','','<p>碎片化的移动互联网时代，使用户变得分散，伴随着PC市场风云变换，人们对台式机产品的需求逐渐缩减，京东作为优质电商平台，坚持通过京东赋能为品牌制定新潮产品，让品牌对齐市场需求，从而提升消费者满意度。近期京东618全球年中购物节拉开帷幕，联想、惠普、华硕、戴尔、希捷、爱奇艺智能、英特尔、金士顿、AOC、搜狗、英伟达、希捷、Gopro、哈曼等众品牌为京东618打call，就能看出京东服务商的身份非同一般，那么京东是如何获得品牌厂商们的信赖的？</p>\r\n\r\n<p>　　笔者认为，品牌厂商之所以信赖京东，与京东优质的用户群资源关系紧密，作为消费者认可及品牌厂商信赖的优质购物平台，京东目前拥有超过2亿高品质用户群，通过京东大数据挖掘分析，能够精准人群画像分析用户对产品的核心诉求，从而帮扶品牌对齐市场。而京东大数据还能够将线上积累的数据应用到线下的京东之家，达到线上线下一体化模式，为消费者带去&ldquo;沉浸式的体验感&rdquo;，这也是众多品牌厂商看重的原因之一。</p>\r\n\r\n<p>　　另一方面，京东也以开放的态度，为品牌厂商提供&ldquo;反向定制&rdquo;赋能能力，如在今年京东618开门红京东推出百亿赋能计划，联想及惠普纷纷与京东进行战略合作，其最新款游戏本&ldquo;联想拯救者Y7000&rdquo;及&ldquo;暗影精灵4代&rdquo;，在京东同台进行首发。其实，这已经不是京东与品牌厂商的第一次合作了，早在2015年，京东便开始推动品牌厂家进行产品反向定制，在京东的帮扶下，品牌厂商取得了惊人的销售量，验证了京东反向定制模式、赋能品牌产品的效果。</p>\r\n','0','/Upload/news/9.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'1','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('190','21','','1','一文读懂快手收购A站：各自的算盘是什么？','','<p>6月5日上午，国内短视频、直播平台快手收购Acfun（A站）的消息在全网传开。</p>\r\n\r\n<p>消息称，此次快手收购A站的交易对价大概率会低于7.5亿人民币，更多细节并未透露。不过在上一轮融资中，A站投前估值为7.5亿人民币。</p>\r\n\r\n<p><strong>快手收购A站</strong></p>\r\n\r\n<p><strong>A站回应</strong></p>\r\n\r\n<p>随后，A站CEO刘炎焱对腾讯科技表示，消息属实，自己也将继续留在A站，公司保持独立运营。</p>\r\n\r\n<p><strong>快手回应</strong></p>\r\n\r\n<p>快手方面也向腾讯《一线》发来回应，称快手方面确认已完成对Acfun的整体收购。</p>\r\n\r\n<p>未来，A站将保持独立品牌、维持独立运营、保持原有团队、独立发展。而快手也会在资金、资源、技术等给予A站大力支持。</p>\r\n\r\n<p><strong>A站股东回应</strong></p>\r\n\r\n<p>6月5日午间，Acfun股东中文在线发布公告，称与快手签订转让协议，拟以人民币1.4亿元价格将其持有的全部A站权益出售给快手。</p>\r\n\r\n<p>消息显示，中文在线于2016年11月21日召开董事会签署协议，拟以现金出资2.5亿元认购A站13.51%的股权。</p>\r\n\r\n<p>不过，因为A站并未满足相关增资协议中的先决条件，后续中文在线仅向A站支付投资预付款1.385亿元，亦未进行工商变更。</p>\r\n\r\n<p><strong>快手为何收购A站？</strong></p>\r\n\r\n<p>关于此次快手收购A站的原因，36氪从用户画像、市场整体环境以及商业化三个维度做了简单的分析：</p>\r\n\r\n<p><strong>1、A站能够补全快手在用户圈层上的不足</strong></p>\r\n\r\n<p>用户画像上，快手的用户足够下沉且平均，而A站则以年轻人为主，社区文化重，收购A站能够很好地补全快手在用户圈层上的不足，逻辑跟陌陌收购探探类似。</p>\r\n\r\n<p>极光大数据的数据显示，从用户性别分布结果上看，A站和快手均是男性高于女性，男女比例相仿。</p>\r\n\r\n<p>从用户城市等级分布结果看，A站有更大比例的用户分布在一线城市，占比达到20.04%，新一线和二线城市在A站用户中也有着较高的占比。</p>\r\n\r\n<p>而快手的用户相对要更加下沉，分布在三线及以下城市的用户占比超过60%。</p>\r\n\r\n<p><strong>2、快手需要走一条投资并购的路子</strong></p>\r\n\r\n<p>从市场整体环境去分析，作为快手的直接竞争对手，1.5亿日活的抖音已超越1亿日活的快手。</p>\r\n\r\n<p>加上今日头条依靠整个短视频矩阵所展现出的强产品研发与运营能力，快手走一条投资并购的路子未尝不是一个与头条抗庭的捷径。</p>\r\n\r\n<p><strong>3、商业化永远是快手最关注的指标之一</strong></p>\r\n\r\n<p>作为一直谋求海外上市的短视频公司，商业化永远是快手最关注的指标之一。</p>\r\n\r\n<p>通过B站上市，整个市场都看到了其游戏收入的高占比以及其多元化的商业价值。</p>\r\n\r\n<p><strong>A站为何接受收购？</strong></p>\r\n\r\n<p>A站虽然起点很高，是最老牌的弹幕视频网站，但由于高管变动频繁、管理不善等原因，发展上一直冷冷清清。</p>\r\n\r\n<p>今年年初，A站更是经历了关站、无法访问等风波，命运几度飘摇。有消息称其得到了阿里系的支持后才恢复正常运作，不过后来又有消息称阿里巴巴放弃了对A站的控股计划。</p>\r\n\r\n<p>也有消息称，快手和A站合作的最初传闻，正是来自于今年年初A站重新上线时获得的一笔资金，有消息显示，该笔资金的来源就是快手。</p>\r\n\r\n<p>事实上，据《一线》了解，快手一直是A站的潜在融资方之一。</p>\r\n\r\n<p>此外，公开信息显示，A站去年11月实际DAU降至160万，其中PC端90万、移动端45万&mdash;&mdash;这个数字在去年1月份的峰值是1200万，当时月平均DAU也有800万。</p>\r\n\r\n<p>发展不良的时候，快手伸来援手，且团队还能独立运营。你情我愿，一拍即合。</p>\r\n','0','/Upload/news/4.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'1','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('189','21','','1','人民日报评美拍：让我们的网络空间清朗起来','','<p>近期，某网络直播短视频平台因传播涉未成年人低俗不良信息，严重影响青少年身心健康。国家网信办会同各部门依法依规联合约谈该平台负责人，提出严肃批评，责令全面整改。</p>\r\n\r\n<p>这条新闻一出来，和很多网友一样，笔者也是拍手称快。笔者的儿子正上小学，时不时央求我给他买一部手机。一直没答应，倒不是为了省钱，而是怕网络上乱七八糟的东西，坏了孩子视听。</p>\r\n\r\n<p>有观点说，现在的孩子都是网络原住民，注定要比上一代人更早接触网络，更需要网络，倒不如让他们在游泳中学习游泳。这种说法要想成立，需要一个前提，就是对那些乌烟瘴气、不健康的信息能够及时屏蔽，对散播不利于未成年人身心健康内容的平台能够严加打击。这是从监管角度来说的，那么从供给方的角度来说，需要做些什么呢？</p>\r\n\r\n<p>这次整改中，该平台的表态中有一句话值得注意&mdash;&mdash;用正确的价值观指导算法。换句话说，之前很多直播短视频平台用来指导算法的不是正确的价值观，而是根据社会的需求&mdash;&mdash;而且还不是高尚的需求&mdash;&mdash;来推送内容。如今网民消费多元化，当注意力成为一种资源后，任何一种偏门的爱好，都能催生出相应的供给。</p>\r\n\r\n<p>我们看林林总总的直播平台，上面点击率高的网红，往往具有如下特点。第一，有极端特质，光怪陆离。镜头前的他们，要么特别漂亮，要么非常丑陋，要么语不惊人死不休，要么离经叛道玩颠覆。</p>\r\n\r\n<p>第二，有极强的表现欲。没听说哪个网络红人晕镜头。浮夸虚无比比皆是，谦虚谨慎不在此列。美其名曰率性，其实缺乏底蕴。</p>\r\n\r\n<p>第三，保鲜期短，替代性高。一批批网络红人出来得快，消失也快，&ldquo;乱哄哄你方唱罢我登场&rdquo;，说明靠表面的东西只能抓一时眼球。</p>\r\n\r\n<p>让我们的网络空间清朗起来，这项工作不容易，但再难也要做。一方面，需要对内容供给方划定红线，改变一味迎合需求的做法。另一方面，用《说苑》里的话就是：&ldquo;与善人居，如入兰芷之室，久而不闻其香，则与之化矣。与恶人居，如入鲍鱼之肆，久而不闻其臭，亦与之化矣。&rdquo;愿您常入兰芷之室，少进或不进鲍鱼之肆。</p>\r\n','0','/Upload/news/3.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'1','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('16','30','','1','NET Framework 2.0简体中文版','','<p>Microsoft .NET Framework 2.0 版可再发行组件包将安装运行针对 .NET Framework 2.0 版开发的应用程序时所需的 .NET Framework 运行库及相关文件。</p>\r\n\r\n<p>　　.NET Framework 2.0 版改进了缓存，从而提高了应用程序的可扩展性和性能；使用 ClickOnce 改进了应用程序部署和更新；通过 ASP.NET 2.0 控件和服务对各种浏览器和设备提供更强大的支持。有关 .NET Framework 2.0 的详细信息，请单击此处。重要事项：不能在同一台计算机上安装两种不同语言版本的 .NET Framework。试图安装第二种语言版本的 .NET Framework 时，将会导致出现以下错误：&ldquo;安装程序无法安装 Microsoft .NET Framework，因为已经安装了该产品的其他版本。&rdquo;如果您要使用非英语的平台或要以另一种语言查看 .NET Framework 资源，则必须下载相应语言版本的 .NET Framework 语言包。发布日期： 2008/3/24，语言： 简体中文</p>\r\n','0','','','/Upload/download/netframework2.rar','0','0','','','','','0','2013-03-26 16:14:31','','25','','','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('183','58','','1','摄像头6',NULL,'','0','/Upload/product/2_2_6.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('184','26','','1','汽车仪表6',NULL,'','0','/Upload/product/3_1_6.jpg','','','0','0','','','','','0','2018-06-05 11:56:52',NULL,'2',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('31','32','','1','对地方环境空气质量监测数据','','<p>随着系列国家重点工程项目的实施，仪器仪表行业日益得到政府的重视和扶持。这将使仪器仪表行业的市场投资价值日渐突出。但对于过去的一年在仪器仪表界里也发生了不少大事儿，央视主持人自费研究PM2.5，数据却遭到质疑了;&ldquo;水十条&rdquo;千呼万唤始出来;国内仪器公司海外收购;我国科学家研制的暗物质探测卫星发射升空;实验室安全很重要，火灾监测仪必不可少;仪器仪表相关会议频繁召开等等，下面我就带大家一起总结一下。<br />\r\n央视主持人柴静发布《穹顶之下》数据被质疑，相关检测设备及数据可靠性迫在眉睫<br />\r\n今年3月，从央视离职的主持人柴静发布了深度公益调查《柴静雾霾调查：穹顶之下》。这段宣传片，柴静用了大量的数据和资料来支撑她的结论，知乎上一网友的博士论文刚好与emission有点关系，他看着觉得有点不对，查了查资料，发觉几乎每个数据都有问题。首先是有意混淆雾霾和PM2。5，其次是缺少采样仪的测试范围和灵敏度数据、空气湿度和风向条件、采样仪的流量数据，以及改变数据口径形成误导印象和篡改资料的背景和时间等。这一报道出来，让网友疾呼：专业的事情还是交给专业的人去做吧！<br />\r\n接下来就是小米公司开发的空气净化器数据造假，各种环境检测仪器仪表不够精密，监测数据造假等系列问题。2015年下半年，各级环保部门共查实8起典型违法案例，已全部移交公安机关处理，并对10名责任人处以刑事或行政拘留。从2016年1月1日开始，环境保护部实施《环境监测数据弄虚作假行为判定及处理办法》。根据《办法》规定，环境保护部今后用两年时间展开专项检查，对地方环境监测数据，特别是空气质量检测数据造假行为进行严查。更严厉的大棒，挥向造假企业、地方环保部门和地方政府，值得点赞。</p>\r\n','0','/Upload/case/case1.jpg','','','0','0','','','','','0','2013-03-26 18:22:43',NULL,'1',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('32','26',NULL,'1','汽车仪表5','','<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_5.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'0',NULL,'','518','C013',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('33','26',NULL,'1','汽车仪表4','','<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_4.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'1',NULL,'','188','C014',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('34','26',NULL,'1','汽车仪表3','','<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_3.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'10',NULL,'','268','C015',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('35','26',NULL,'1','汽车仪表2','','<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_2.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'5',NULL,'15','288','C016',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('185','28','','1','压力表1',NULL,'','0','/Upload/product/3_1_1.jpg','','','0','0','','yalibiao1_20190710','','','0','2018-06-05 11:57:56',NULL,'4',NULL,'','','','','','','1','1','1','1','yalibiao1','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('186','28','','1','压力表2',NULL,'','0','/Upload/product/3_1_2.jpg','','','0','0','','','','','0','2018-06-05 11:57:56',NULL,'1',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('40','28',NULL,'1','压力表3',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'458','C021',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('41','28',NULL,'1','压力表4',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'788','C022',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('42','28',NULL,'1','压力表5',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_5.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,'15','88','C023',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('43','28',NULL,'1','压力表6',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_1_6.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'3',NULL,NULL,'589','C024',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('44','29','','1','直流数显1',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/3_2_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'5',NULL,'','','C025','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('45','29',NULL,'1','直流数显2',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_2_2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'1',NULL,'15','130','C026',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('46','29',NULL,'1','直流数显3',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/3_2_3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'1',NULL,'13','113','C027',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('47','29','','1','直流数显4',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/3_2_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'5',NULL,'','','C028','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('48','24','','1','显微镜1',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/1_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'14',NULL,'','','C029','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('49','24','','1','显微镜2',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/1_2.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'13',NULL,'15','','C030','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('50','24','','1','显微镜3',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/1_3.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'6',NULL,'','','C031','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('51','24','','1','显微镜4',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/1_4.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'18',NULL,'','','C032','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('52','24','','1','显微镜5',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/1_5.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'13',NULL,'','','C033','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('53','24','','1','显微镜6',NULL,'<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n\r\n<p>产品描述信息</p>\r\n','0','/Upload/product/1_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'13',NULL,'','','C034','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('178','58','','1','摄像头1',NULL,'','0','/Upload/product/2_2_1.jpg','','','0','0','','','','','-1','2018-06-05 11:52:06',NULL,'7',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('179','58','','1','摄像头2',NULL,'','0','/Upload/product/2_2_2.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'1',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('180','58','','1','摄像头3',NULL,'','0','/Upload/product/2_2_3.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('181','58','','1','摄像头4',NULL,'','0','/Upload/product/2_2_4.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('182','58','','1','摄像头5',NULL,'','0','/Upload/product/2_2_5.jpg','','','0','0','','','','','-1','2018-06-05 11:52:06',NULL,'10',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('172','57','','1','无人机1',NULL,'','0','/Upload/product/2_1_1.jpg','','','0','0','','','','','0','2018-06-05 11:50:17',NULL,'0',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('173','57','','1','无人机2',NULL,'','0','/Upload/product/2_1_2.jpg','','','0','0','','','','','-1','2018-06-05 11:51:02',NULL,'1',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('174','57','','1','无人机3',NULL,'','0','/Upload/product/2_1_3.jpg','','','0','0','','','','','0','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('175','57','','1','无人机4',NULL,'','0','/Upload/product/2_1_4.jpg','','','0','0','','','','','-1','2018-06-05 11:51:02',NULL,'2',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('176','57','','1','无人机5',NULL,'','0','/Upload/product/2_1_5.jpg','','','0','0','','','','','0','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('177','57','','1','无人机6',NULL,'','0','/Upload/product/2_1_6.jpg','','','0','0','','','','','0','2018-06-05 11:51:02',NULL,'1',NULL,'','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('60','32','','1','精密量产设备在某企业启用','','<p>传统的机械加工方法(普通加工)与精密和超精密加工方法一样。随着新技术、新工艺、新设备以及新的测试技术和仪器的采用，其加工精度都在不断地提高。<br />\r\n加工精度的不断提高，反映了加工工件时材料的分割水平不断由宏观进入微观世界的发展趋势。随着时间的进展，原来认为是难以达到的加工精度会变得相对容易。因此，普通加工、精密加工和超精密加工只是一个相对概念?其间的界限随着时间的推移不断变化。精密切削与超精密加工的典型代表是金刚石切削。<br />\r\n以金刚石切削为例。其刀刃口圆弧半径一直在向更小的方向发展。因为它的大小直接影响到被加工表面的粗糙度，与光学镜面的反射率直接有关，对仪器设备的反射率要求越来越高。如激光陀螺反射镜的反射率已提出要达到99.99%，这就必然要求金刚石刀具更加锋利。为了进行切极薄试验，目标是达到切屑厚度nm，其刀具刃口圆弧半径应趋近2.4nm。为了达到这个高度，促使金刚石研磨机改变了传统的结构。其中主轴轴承采用了空气轴承作为支承，研磨盘的端面跳动可在机床上自行修正，使其端面跳动控制在0.5&mu;m以下。<br />\r\n刀具方面，采用金刚石砂轮，控制背吃刀量和进给量，在超精密磨床上，可以进行延性方式磨削，即纳米磨削。即使是玻璃的表面也可以获得光学镜面。2精密加工和超精密加工的发展趋势从长远发展的观点来看，制造技术是当前世界各国发展国民经济的主攻方向和战略决策，是一个国家经济发展的重要手段之一，同时又是一个国家独立自主、繁荣昌盛、经济上持续稳定发展、科技上保持领先的长远大计。科技的发展对精密加工和超精密加工技术也提出了更高的要求。从大到天体望远镜的透镜，小到大规模集成电路线宽&mu;m要求的微细工程和微机械的微纳米尺寸零件，不论体积大小，其最高尺寸精度都趋近于纳米;零件形状也日益复杂化，各种非球面已是当前非常典型的几何形状。微机械技术为超精密制造技术引来一种崭新的态势?它的微细程度使传统的制造技术面临一种新的挑战，促进了各种产品技术性能的提高，发展过程呈现出螺旋式循环发展，直接对科学技术的进步和人类文明作出贡献。对产品高质量、小型化、高可靠性和高性能的追求，使超精密加工技术得以迅速发展，现已成为现代制造工业的重要组成部分</p>\r\n','0','/Upload/case/case2.jpg','','','0','0','','','','','0','2013-03-26 20:45:30',NULL,'3',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('61','32','','1','高端办公写字楼提供高低温试验箱','','<p>高低温试验箱一般放置在实验室用于鉴定产品的耐高低温性能。随着各个行业的发展，对于产品的性能也日趋严格。从而带动了高低温试验箱的应用范围，从最初的各个机械行业、科研院校已渐渐延伸到更多的领域。现今，已有许多用户将高低温试验箱放置到了写字楼，那么，就存在一个问题。写字楼的电梯、办公室的门设备能进去吗?<br />\r\n<br />\r\n一般标准的是难以进入写字楼办公室的。为了适应客户的要求。高低温试验箱厂家可做成分体式的。1.将试验箱控制器放到顶部，左右的宽度则可减少20厘米左右。2.将试验箱工作室与制冷系统拆开，高度则可减少设备总高度的二分之一。<br />\r\n<br />\r\n因此，用户在选择高低温试验箱时除了考虑试验外，也需考虑试验箱的放置场地。若门尺寸、电梯尺寸不够，是否可拆门窗、是否可采用吊装。若不能，则应根据试验、门尺寸选择适合容积的试验箱将其做成左右或上下的拆体式高低温试验箱。这些都需要用户与厂家详细沟通确定。</p>\r\n','0','/Upload/case/case3.jpg','','','0','0','','','','','0','2013-03-26 20:45:52',NULL,'3',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('62','32','','1','某品牌汽车仪表，采用我们的智能仪表','','<p>汽车仪表的功能就是获取需要的数据并采用合适的方式显示出来。以前的仪表一般限制在3~4个量的显示和4~5个警告功能，现在新式仪表则达到有约光电子学显示仪表光电子学显示仪表15个量显示和约40个警告监测功能。</p>\r\n','0','/Upload/case/case4.jpg','','','0','0','','','','','0','2013-03-26 20:46:09',NULL,'5',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('63','32','','1','挥向造假企业、地方环保部门和地方政府','','企业造假行为的背后，都存在地方环保部门&ldquo;睁一只眼闭一只眼&rdquo;的不作为，甚至主动造假以显示治污政绩。所毁掉的不仅仅是这几个监测技术人员、几个环境监测站长，而在于动摇了全国环境监测数据的根本，破坏了环保部门的公信力。<br />\r\n　　环境监测数据是环境治理的决策依据，如果源头注水造假，决策势必出现偏差，贻误环境治理时机，损害公众利益。<br />\r\n　　从2016年1月1日开始，环境保护部实施《环境监测数据弄虚作假行为判定及处理办法》。根据《办法》规定，环境保护部今后用两年时间展开专项检查，对地方环境监测数据，特别是空气质量检测数据造假行为进行严查。更严厉的大棒，挥向造假企业、地方环保部门和地方政府，值得点赞。<br />\r\n　　从大局看，中央和地方在环境监测领域投资巨大，在线监测网络使用资金早已超过一百个亿，理论上有能力监控上万个污染源。其中，仅大气监测体系一项就投资4.36亿元，2014年建成了发展中国家最大的空气质量监测网。正是在这样的背景下，有些地方政府为了减轻考核压力，编造篡改监测数据情况时有发生。中央领导多次批示要求，严厉打击环保数据造假行为，对虚假数字要严厉问责。<br />\r\n　　环境监测数据已经上升到法律层面，具有了更高的约束力。新环保法明确规定，监测机构应当使用符合国家标准的监测设备，遵守监测规范，对监测数据的真实性和准确性负责，对篡改、伪造或者指使篡改、伪造监测数据的要予以惩处，追究法律责任。2015年下半年，各级环保部门共查实8起典型违法案例，已全部移交公安机关处理，并对10名责任人处以刑事或行政拘留。<br />\r\n　　企业之所以能弄虚作假，表明现在运行的环保在线自动监测网络存在漏洞。我了解到，有一些企业购置了造假设备，给数据伪造和篡改留下空间，试图蒙混过关。有些地方政府发布的环境监测数据与市民直观感受不符，有时甚至出现很大反差，也与这个漏洞有关。<br />\r\n　　多年来，一些地方环境检测数据造假已经是公开的秘密。就如同近年来发生的一些往沙漠里排污，或是往河流里排污一样，都是明知违法而为之。在我看来，这些企业造假行为的背后，都存在地方环保部门&ldquo;睁一只眼闭一只眼&rdquo;的不作为，甚至不排除主动配合造假以显示治污政绩。这种做法所毁掉的不仅仅是这几个监测技术人员、几个环境监测站长，而在于动摇了全国环境监测数据的根本，破坏了环保部门的公信力。','0','/Upload/case/case5.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'16',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('64','32','','1','某无人生产车间，仪表自动报警检测','','<p>在油田或气田的钻井作业中，由于地理位置偏僻，气候环境恶劣，施工条件较差，而且频繁地搬井，所以，在钻井上铺设电缆非常不容易，成本也高。因此，代替电缆传输信号的无线通讯应运而生。德康最新开发的无线通讯正是在这样的环境下产生的，立特电子作为美国德康中国唯一总代理专业提供德康最新高科技气体探测无线通讯系统。这套专为油田油井开发的产品模块化结构，可配用低功耗的气体探测器，太阳能电源，高能蓄电池，各种通道的控制器，还有声光报警器，这些产品均间均使用无线来通讯，且均为防爆产品，最适用于钻井、油田上的应用。</p>\r\n','0','/Upload/case/case6.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'11',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('65','32','','1','为某人工智能企业制造仪器','','<p>人工智能是计算机科学的一个分支，它企图了解智能的实质，并生产出一种新的能以人类智能相似的方式做出反应的智能机器，该领域的研究包括机器人、语言识别、图像识别、自然语言处理和专家系统等。人工智能从诞生以来，理论和技术日益成熟，应用领域也不断扩大，可以设想，未来人工智能带来的科技产品，将会是人类智慧的&ldquo;容器&rdquo;。人工智能可以对人的意识、思维的信息过程的模拟。人工智能不是人的智能，但能像人那样思考、也可能超过人的智能。<br />\r\n人工智能是一门极富挑战性的科学，从事这项工作的人必须懂得计算机知识，心理学和哲学。人工智能是包括十分广泛的科学，它由不同的领域组成，如机器学习，计算机视觉等等，总的说来，人工智能研究的一个主要目标是使机器能够胜任一些通常需要人类智能才能完成的复杂工作。但不同的时代、不同的人对这种&ldquo;复杂工作&rdquo;的理解是不同的。 [1] &nbsp;2017年12月，人工智能入选&ldquo;2017年度中国媒体十大流行语</p>\r\n','0','/Upload/case/case7.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'35',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('66','32','','1','空气湿度和风向条件、采样仪的流量数据','','<p>随着系列国家重点工程项目的实施，仪器仪表行业日益得到政府的重视和扶持。这将使仪器仪表行业的市场投资价值日渐突出。但对于过去的一年在仪器仪表界里也发生了不少大事儿，央视主持人自费研究PM2.5，数据却遭到质疑了;&ldquo;水十条&rdquo;千呼万唤始出来;国内仪器公司海外收购;我国科学家研制的暗物质探测卫星发射升空;实验室安全很重要，火灾监测仪必不可少;仪器仪表相关会议频繁召开等等，下面我就带大家一起总结一下。<br />\r\n央视主持人柴静发布《穹顶之下》数据被质疑，相关检测设备及数据可靠性迫在眉睫<br />\r\n今年3月，从央视离职的主持人柴静发布了深度公益调查《柴静雾霾调查：穹顶之下》。这段宣传片，柴静用了大量的数据和资料来支撑她的结论，知乎上一网友的博士论文刚好与emission有点关系，他看着觉得有点不对，查了查资料，发觉几乎每个数据都有问题。首先是有意混淆雾霾和PM2。5，其次是缺少采样仪的测试范围和灵敏度数据、空气湿度和风向条件、采样仪的流量数据，以及改变数据口径形成误导印象和篡改资料的背景和时间等。这一报道出来，让网友疾呼：专业的事情还是交给专业的人去做吧！<br />\r\n接下来就是小米公司开发的空气净化器数据造假，各种环境检测仪器仪表不够精密，监测数据造假等系列问题。2015年下半年，各级环保部门共查实8起典型违法案例，已全部移交公安机关处理，并对10名责任人处以刑事或行政拘留。从2016年1月1日开始，环境保护部实施《环境监测数据弄虚作假行为判定及处理办法》。根据《办法》规定，环境保护部今后用两年时间展开专项检查，对地方环境监测数据，特别是空气质量检测数据造假行为进行严查。更严厉的大棒，挥向造假企业、地方环保部门和地方政府，值得点赞。</p>\r\n','0','/Upload/case/case8.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'95',NULL,'','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('273','50','','1','Air quality monitoring','','With the implementation of a series of national key projects, the instrumentation industry has gained increasing attention and support from the government. This will make the market value of instrumentation industry increasingly prominent. But for the past year, there have been a lot of great events in the instrument and instrument circle. The CCTV hosts study PM2.5 at their own expense, but the data have been questioned; &ldquo; water ten &rdquo; the overseas acquisition of domestic instruments; the dark matter detection satellite developed by Chinese scientists; the laboratory safety is very important, fire. Disaster monitoring instrument is essential; instrument and related meetings frequently convened and so on. Next I will bring you together to summarize.<br />\r\n<br />\r\nCCTV host Jing Chai released &quot;dome below&quot; data was questioned, the reliability of relevant testing equipment and data is imminent<br />\r\n<br />\r\nIn March of this year, Jing Chai, the host from CCTV, released a deep public interest survey &quot;Jing Chai haze investigation: under the dome&quot;. This piece of publicity, Jing Chai used a lot of data and data to support her conclusion, knowing that a friend&#39;s doctoral thesis was just a little related to emission. He looked at it a little wrong, looked up the data, and found that almost every data had problems. The first is to intentionally confuse fog and haze and PM2. 5, the next is the lack of testing range and sensitivity data, air humidity and wind direction conditions, the flow data of the sampling instrument, and the background and time of changing data to form misleading impressions and tamper information. This report comes out, let netizens cry: professional matters or professional people to do it!<br />\r\n<br />\r\nNext is the series of problems such as the data counterfeiting of air purifier developed by Xiaomi, the inaccuracy of various environmental testing instruments, and the fraud of monitoring data. In the second half of 2015, the environmental protection departments at all levels found 8 typical illegal cases, all of which had been transferred to public security organs, and 10 responsible persons were detained in criminal or administrative detention. Since January 1, 2016, the Ministry of environmental protection has implemented the methods of judging and handling environmental monitoring data falsification. According to the provisions of the &quot;measures&quot;, the Ministry of environmental protection will use a special inspection for two years in the future to strictly check the local environmental monitoring data, especially the false behavior of air quality testing data. It is worthwhile to praise the more rigid clubs, the counterfeiting enterprises, the local environmental protection departments and the local governments.','0','/Upload/case/case1.jpg','','','0','0','','','','','0','2013-03-26 18:22:43',NULL,'1',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('276','51','','1','NET Framework 2 simplified Chinese version','','The reissue package package of the Microsoft.NET Framework 2 version will install the.NET Framework runtime and related files needed to run applications developed for the.NET Framework 2 version.<br/>.NET Framework 2 improves the scalability and performance of the application; improves application deployment and updates using ClickOnce; provides more powerful support for various browsers and devices through ASP.NET 2 controls and services. For more information about.NET Framework 2, click here. Important: you cannot install two different language versions of.NET Framework on the same computer. When trying to install the.NET Framework version of the second language, it will cause the following error: &ldquo; the installer cannot install Microsoft.NET Framework because the other versions of the product have been installed. &rdquo; if you want to use a non English platform or you want to view.NET Framework resources in another language, you have to download the.NET Framework package for the corresponding language version. Release date: 2008/3/24, language: Simplified Chinese','0','','','/Upload/download/netframework2.rar','0','0','','','','','0','2013-03-26 16:14:31','','24','','','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('275','51','','1','MySql 5.0',NULL,'MySQL is a relational database management system developed by MySQL AB, Sweden, and currently belongs to Oracle&#39;s products. MySQL is one of the most popular relational database management systems. In WEB applications, MySQL is the best RDBMS (Relational Database Management System, relational database management system) application software.<br />\r\n<br />\r\nMySQL is a relational database management system, the relational database stores data in different tables, rather than putting all the data in a large warehouse, which increases speed and improves flexibility.<br />\r\n<br />\r\nThe SQL language used by MySQL is the most commonly used standardized language for accessing databases. MySQL software adopts a dual authority policy, which is divided into community and business editions. Because of its small size, fast speed, low overall cost, especially open source, the development of medium and small web sites will choose MySQL as a website database. Due to the excellent performance of its community edition, PHP and Apache can form a good development environment.','0','','','/Upload/download/mysql.rar','0','0','','','','','0','2016-04-13 17:24:22','','1','','','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('274','51','','1','MyEclipse5.8',NULL,'MyEclipse is a very excellent set of Eclipse plug-ins which is mainly used to develop Java and J2EE. The full name MyEclipseEnterprise Workbench is an extension to EclipseIDE. With MyEclipse, we can greatly improve the efficiency of database and JavaEE development, publishing and application server integration. MyEclipse is almost the inclusion of all the exclusive eclipse development tools of all mainstream open source products. And it also fully supports HTML, Struts, JSP, CSS, Javascript, Spring, SQL, Hibernate, EJB3, JDBC database linking tools, such as a number of functions, worthy of use!','0','','','/Upload/download/myeclipse.rar','0','0','','','','','0','2016-04-13 17:29:02','','5','','','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('272','50','','1','Precision production equipment used','','Traditional machining methods (general machining) are the same as precision and ultra precision machining methods. With the adoption of new technology, new technology, new equipment and new testing technology and instruments, the machining accuracy is constantly improving.<br />\r\n<br />\r\nThe continuous improvement of machining accuracy reflects the development trend of the level of material segmentation from the macro into the micro world. As time goes on, the machining accuracy which is considered difficult to achieve will become relatively easy. Therefore, ordinary processing, precision machining and ultra precision machining are only a relative concept, and the boundaries between them vary with time. The typical example of precision cutting and ultra precision machining is diamond cutting.<br />\r\n<br />\r\nDiamond cutting is taken as an example. The radius of the knife edge has been developing in a smaller direction. Because its size directly affects the roughness of the machined surface, it is directly related to the reflectivity of the optical mirror, and the requirement for the reflectivity of the equipment is getting higher and higher. If the reflectivity of the laser gyroscope reflector has been raised to 99.99%, this will inevitably require diamond tools to be sharper. In order to carry out the thinning test, the target is to achieve chip thickness of nm, and the radius of the tool edge should approach 2.4nm. In order to achieve this height, the diamond grinder has changed the traditional structure. The spindle bearing adopts the air bearing as the support, the end face of the grinding disc can be corrected by the machine itself, so that the end face of the grinding disc is controlled by 0.5&mu; m below.<br />\r\n<br />\r\nIn terms of cutting tools, diamond grinding wheel is used to control the amount of feed and feed on the back. In ultra precision grinding machine, ductile grinding can be carried out, namely nano grinding. Optical surfaces can be obtained even on the surface of glass. 2 the development trend of precision processing and ultra precision processing is from the viewpoint of long-term development. Manufacturing technology is the main direction and strategic decision of developing national economy in all countries. It is one of the important means of national economic development. At the same time, it is a country&#39;s independent, prosperous and sustained economic development. A long - term plan to keep the lead in technology. The development of science and technology has also put forward higher requirements for precision machining and ultra precision machining technology. From large to celestial telescope lens, small to large scale integrated circuit line width &mu; m requirements for micro and micromechanical micro and nano size parts, regardless of size, the maximum size accuracy is close to nanometer; the shape of parts is increasingly complex, various aspheric is the current very typical geometric shape. Micromechanical technology brings a new trend for ultra precision manufacturing technology. Its micro degree makes the traditional manufacturing technology face a new challenge, promotes the improvement of the technical performance of various products. The development process presents a spiral circular development, and contributes directly to the progress of science and technology and human civilization. With the pursuit of high quality, miniaturization, high reliability and high performance, the ultra precision machining technology has been developed rapidly, and it has become an important part of modern manufacturing industry.','0','/Upload/case/case2.jpg','','','0','0','','','','','0','2013-03-26 20:45:30',NULL,'2',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('271','50','','1','High temperature test box','','The high and low temperature test chamber is usually placed in the laboratory to identify the high and low temperature performance of the product. With the development of various industries, the performance of products has become increasingly stringent. Thus driving the application scope of high and low temperature test box, from the initial machinery industry, scientific research institutions have gradually extended to more areas. Nowadays, many users put the high and low temperature test box in the office building, so there is a problem. Can the office elevator and office door equipment go in?<br />\r\n<br />\r\n<br />\r\n<br />\r\nThe general standard is that it is difficult to enter office buildings. In order to meet the requirements of the customer. The manufacturers of high and low temperature test boxes can be made of composition and body type. 1. put the controller of the test box on the top, and the width of the left and right can be reduced by about 20 centimeters. 2. dismantle the test chamber and the refrigeration system, and the height can reduce the total height of the equipment by 1/2.<br />\r\n<br />\r\n<br />\r\n<br />\r\nTherefore, when choosing high and low temperature test box, the user should consider the test site placing in addition to the test. If door size, elevator size is not enough, whether it can be dismantled doors and windows, whether hoisting can be used. If it can not, it should be based on the size of the test and door size to choose a suitable volume test box to make the left and right up or down detachable high and low temperature test chamber. All these require detailed communication between users and manufacturers.','0','/Upload/case/case3.jpg','','','0','0','','','','','0','2013-03-26 20:45:52',NULL,'2',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('270','50','','1','Car meter adopts intelligent instrument.','','The function of the automobile meter is to get the data needed and display it in a suitable way. The previous instruments were generally limited to the 3~4 volume display and 4~5 warning functions, and the new instrument now reached about 15 volume displays and about 40 warning monitoring functions of the optoelectronics display instrument.','0','/Upload/case/case4.jpg','','','0','0','','','','','0','2013-03-26 20:46:09',NULL,'5',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('208','56','','1','Energy saving and environmental protection','','','0','/Upload/video/jieneng.jpg','','https://res.youdiancms.com/jieneng.mp4','0','0','','','','','0','2018-06-07 16:19:08',NULL,'33','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('209','56','','1','Tax','','','0','/Upload/video/shuiwu.jpg','','https://res.youdiancms.com/shuiwu.mp4','0','0','','','','','0','2018-06-07 16:18:41',NULL,'10','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('210','56','','1','Forest protection','','','0','/Upload/video/baohu.jpg','','https://res.youdiancms.com/baohu.mp4','0','0','','','','','0','2018-06-07 16:17:56',NULL,'9','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('211','56','','1','To be good to the old will be good to himself','','','0','/Upload/video/shandai.jpg','','https://res.youdiancms.com/shandai.mp4','0','0','','','','','0','2018-06-07 16:16:36',NULL,'11','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('212','56','','1','The nation remains mobilized for brand new endeavors.','','','0','/Upload/video/jiayougan.jpg','','https://res.youdiancms.com/jiayougan.mp4','0','0','','','','','0','2018-06-07 16:13:05',NULL,'3','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('213','56','','1','How wonderful the Chinese dream is','','','0','/Upload/video/zhongguo.jpg','','https://res.youdiancms.com/zhongguo.mp4','0','0','','','','','0','2013-04-27 18:06:04',NULL,'101','','9','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('214','56','','1','It\'s safe to go out of the team','','','0','/Upload/video/haishi.jpg','','https://res.youdiancms.com/haishi.mp4','0','0','','','','','2','2015-06-17 10:10:17',NULL,'36','','','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('215','56','','1','Jumei.com creative advertising','','You only smell my perfume, but do not see my sweat, you have your rules, I have my choice, I have my choice, you deny my present, I decide my future, you laugh at me without all, unworthy of love, I pity you always wait, you can despise our youth, we will prove this is whose age, dream is doomed On the road of loneliness, there is no doubt and ridicule on the road, but then again, even if it is black and blue, it has to live beautifully.','0','/Upload/video/jumei.jpg','','https://res.youdiancms.com/jumei.mp4','0','0','','','','','4','2013-04-27 20:05:14',NULL,'69','','7','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('216','41','','1','Wearable devices are not ready to sell, and Apple Watch is still thriving','','Apple&#39;s WWDC conference this year is completely &quot;soft&quot;, the only release of the hardware is the new Apple Watch rainbow strap, but the apple wearable device business led by Apple Watch has gradually become the industry&#39;s oldest.<br />\r\nToday, market research company IDC released a 2018 Q1 global wearable device market report, which showed that the first quarter global wearable equipment shipments were 25 million 100 thousand, up 1.2% from a year earlier. The growth rate of 18% in the same period last year could be said to be a slump.<br />\r\nWearable devices are in the same downturn as smartphones, mainly due to a 9.2% drop in the shipments of basic wearable devices, while smart devices are more popular with consumers, and the relatively high-end smart wearable devices such as apple and Fitbit have grown by 28.4%.<br />\r\nPlease enter the description<br />\r\nAccording to IDC&#39;s statistics, watches and bracelets account for 95% of the global wearable device shipments in the first quarter, and apple is undoubtedly the biggest winner.<br />\r\nWith the Apple Watch Series 3 in support of the cellular network, the Apple Watch shipment increased by 13.5%, and the market share of the apple wearable equipment increased from 14.3% to 16.1%.<br />\r\nPlease enter the description<br />\r\nAccording to Apple&#39;s first quarter earnings this year, Apple Watch revenue and shipments increased by more than 50%. Sales of Apple Watch Series 3 were more than double the sales of Series 2 a year ago.<br />\r\nAccording to GBH Insights, a market research firm, 70% of users who purchase Apple Watch Series 3 are new users.<br />\r\n&nbsp;<br />\r\nIn the second quarter Apple conference phone conference, Cook said the sales of wearable devices, including AirPods, Beats headphones and Apple Watch, grew by nearly 50%, supporting the growth of apple &quot;other products&quot; over 90%, and Cook&#39;s evaluation of the business was:<br />\r\nOur wearable device business can now rank among the fortune 300 companies.<br />\r\nAmong them, the smart watch market occupies half of the Apple Watch work can not be, although the WWDC conference did not launch the new Apple Watch, but also updated watchOS 5, better support the sports function.','0','/Upload/news/10.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'8','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('217','41','','1','Microsoft officially announced $7 billion 500 million to acquire GitHub','','Microsoft has finally finalized the news of the acquisition of GitHub.<br />\r\nIn the evening of June 4th, Microsoft issued a notice, officially announcing the plan to buy software code hosting site GitHub for $7 billion 500 million, which is expected to be completed by the end of this year.<br />\r\nGitHub was founded in April 2008 and has just been ten years. In 2015, GitHub was valued at $2 billion, and in just three years, the market value of GitHub rose nearly 4 times, becoming the most popular social programming and code hosting platform.<br />\r\n<img src=\"/Upload/news/a3.jpg\" style=\"width: 1080px; height: 720px;\" /><br />\r\nAccording to statistics, as of March this year, the number of high frequency users of GitHub reached 28 million, and 80 million source repositories were managed for programming language software such as Java, Python and C++. NASA and other public institutions and Google, apple, Amazon and other large technology companies also have business on GitHub.<br />\r\nBecause GitHub community users are mostly white men (the proportion is said to be up to 97%), Chinese programmers have been dubbed the &quot;world&#39;s largest homosexual dating website&quot; by Chinese programmers.<br />\r\nGitHub CEO Chris Wanstrath said community platforms had made profits in the early 2011. At present, there are three main profit models of GitHub: Code hosting service, data settling and cloud storage, and enterprise headhunting recruitment community.<br />\r\nAccording to CNBC&#39;s report last year, GitHub expects annual revenue to exceed $200 million, of which more than $110 million comes from B end enterprise services revenue.<br />\r\nSuch a profitable company, which has not chosen to go public, is subject to Microsoft, partly because of its confidence in the ability and determination of Microsoft to attach importance to the developer&#39;s business.<br />\r\nInterestingly, Microsoft was a strong opponent of open source software, but after Nadella&#39;s Microsoft CEO, Microsoft gradually became one of the most active promoters of the open source community. From the 2014 Microsoft open source programming basic tool.NET, Microsoft has launched hundreds of open source projects in succession; in 2016, Microsoft has also surpassed the Facebook and Google and topped the list of GitHub&#39;s contributions.<br />\r\nAs for the significance of Microsoft&#39;s acquisition of GitHub, Nadella commented on twitter that &quot;Microsoft + GitHub = energy developers&quot;. According to industry speculates, from Microsoft&#39;s GitHub part of revenue and into the smart cloud business sector, it is to implement the &quot;AI + cloud&quot; strategy to promote the developers to develop and apply the multi platform for Microsoft, including the cloud platform Azure Cloud.<br />\r\nFrom left to right is GitHub co founder Chris Wanstrath, Microsoft CEO Satya Nadella, GitHub new CEO Nat Friedman.<br />\r\nMicrosoft said that the future operation of GitHub will remain the original style, with the highest level of development and independent operation.<br />\r\nAfter the completion of the acquisition, Microsoft Corp vice president Nat Friedman will be the chief executive officer of GitHub, GitHub co founder and former CEO Chris Wanstrath will become a Microsoft technology researcher, reporting to the executive vice president Scott Guthrie, and developing a strategic software development plan.<br />\r\nAll along, from NOKIA, Hotmail, Skype and other lessons, people are mockery of Microsoft&#39;s big acquisitions. So what is the fate of GitHub in the future? It may only be time to give the answer.','0','/Upload/news/5.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('218','41','','1','Quick hand confirmation will maintain an independent brand','','In the early morning of June 5th, a short video website was sent to respond to the first line of the video calling barrage website Acfun (hereinafter referred to as A station):<br />\r\nAs soon as possible, we confirm that we have completed the overall acquisition of Acfun. In the future, A station will maintain its independent brand, maintain its independent operation, maintain its original team and develop independently. And the fast will also give A station strong support in capital, resources, technology and so on.<br />\r\nIn addition, A station CEO Liu Yanyan also told Tencent science and technology that the news is true and can be said today.<br />\r\nAt the beginning of this year, A station had experienced such problems as closing stations and being unable to visit. It was said that it had been supported by the Ali department to resume its normal operation, but later there was news that the Alibaba gave up the holding plan for the A station and turned it from the headline today.<br />\r\nBut in fact, according to the first line, fast hand has always been one of the potential financing side of A station.','0','/Upload/news/6.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('219','41','','1','Liu Erhai, an early investor in Mobai: when you are strong enough','','Hunting cloud note: This is a speech delivered by Liu Erhai, the founder and executive partner of the early days of the early days of the early days of the early days of the capital. In his speech, Liu Erhai said that the development of entrepreneurship in China has reached a new stage, and has been upgraded to all aspects of product and team competition. With the rapid growth of enterprises and the strong admission of giants, all these require entrepreneurs to judge and create the unique value of their own businesses. Article source: ID:innoangel99, author: Bian Xiao Cao<br />\r\nWhat is &ldquo; the devil channel &rdquo;?<br />\r\nThe theme I share today is &quot;crossing the devil passage&quot;, looking at many companies now, including the shared bike that has just been mentioned. There was a time when people said that there was too much to share a single car and the color was not used enough, but in almost a year, there were only about three colors.<br />\r\nFrom the previous group shopping, special car, catering O2O, video portal to the later shared bike, video live, used car market, we found a common, almost every big industry has to go through a baptism.<br />\r\nThere are 3 phenomena in the formation of this commonality: 1, the rapid escalation of competition; 2, the rapid growth of enterprises; 3, the entry of giants.<br />\r\nFirst, the competition is rapidly upgrading. Once I met one of the investors in Sanlitun, who said that the shared bike you invested in it blocked our way. Do you have no sense of guilt as an investor? I say I&#39;m sorry, but competition is so fast and fierce.<br />\r\nTwo, enterprises are growing fast. From no car to 800 or 9 million cars, only a year&#39;s time, including the outbreak of jitter in short time, has also affected the circle of friends of Tencent.<br />\r\nWhy can enterprises grow so fast? An important reason is that it is very easy to find users online, so these enterprises can quickly succeed. In addition, investors&#39; capital holdings have also accelerated the growth of enterprises.<br />\r\nA foreign investor once asked me: &amp;ldquo, how do you give money to the enterprise desperately? &rdquo; an investment that looks crazy, we really know what we&#39;re doing, that&#39;s the rules of the current battlefield, and we don&#39;t have a way to get a lot of capital into the business. You have to follow it as a player.<br />\r\nThree. The game of the giants. Almost all industries can see the figure of the giant, which brings different challenges to our friends here: do we want to stand in line? What do you do without a team tycoon? Start-ups are in fear and anxiety.<br />\r\nFrom what we see, if the enterprise wants to succeed, it must go through the devil channel, and have to go through the process of rapid competition, the rapid growth of the enterprise and the game of the big entrance.<br />\r\n&ldquo; others &rdquo; how do they cross the devil&#39;s passage?<br />\r\nHow do you cross the devil passage? We still have to go back to the nature of business and the business model. Take two examples, we can see how these enterprises really cross or are crossing the devil channel.<br />\r\nThe first example: azure car. The main purpose of Wei Lai automobile is to surpass competitors in terms of technical engineering ability, and the most important is their engineering capability.<br />\r\nIn October 12, 2016, in the North Ring Road of newburgrin in Germany, azure car EP9 created the fastest electric vehicle speed record in 7 minutes and 05 seconds; in February 23, 2017, in the United States Texas American race track unmanned test, EP9 created a speed record of 257 kilometers per hour, becoming the fastest driverless car in the world. Car; in May 12th of the same year, EP9 refreshed the record with 6 minutes, 45 seconds and 900 seconds; in December 16th, Wei Lai car officially released the first production vehicle ES8.<br />\r\nSecond examples: the Jingdong. Jingdong doesn&#39;t have much technology. Everyone here&#39;s technology may do better than him. In that year, compared with the earlier Dangdang, excellence and Amazon, what did Jingdong rely on to surpass competitors?<br />\r\nIn fact, the key is that Jingdong has done the logistics of large items, and there is not much technology, but it has made up the immature part of the value chain. Infrastructure can also create value and help enterprises cross the devil&#39;s channel.<br />\r\nThe secrets of Wei Lai car and Jingdong crossing the devil&#39;s channel are engineering technology and infrastructure.<br />\r\nJoyful capital has invested a lot. We have a &ldquo; a resource oriented investment &rdquo; an investment strategy. The so-called base area is to say that the region is wide, and we can invest more in this field. In this field, we have put out a number of two projects; finally, we have deep accumulation and profound understanding in this field.','0','/Upload/news/7.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('220','41','','1','First line station and animation company animation dream animation joint venture','','June 5th news, recently &ldquo; Shanghai phantom electricity Mdt InfoTech Ltd &rdquo; (&ldquo; B station &rdquo;) and animation production company &ldquo; Shanghai painting boundary Cultural Communication Co., Ltd. &rdquo; (&ldquo; dream animation &rdquo;) joint venture company &ldquo; doraemi (Shanghai) Cultural Communication Co., Ltd. &rdquo; (hereinafter referred to &amp;ldq) Uo; Doraemon &rdquo;).<br />\r\n<br />\r\n<br />\r\n<br />\r\nIt is reported that the new company B station 60% shares, painting dream animation account for 40% of the share, the chairman of the B station chairman Chen Rui as chairman, the former co - founder of the evil spirit and COO Dong Zhiling as the general manager.<br />\r\n<br />\r\n<br />\r\n<br />\r\nThe B station and the dream animation joint venture, or to enhance its animation production capabilities. In this regard, Tencent &quot;first line&quot; to B station verification, no response.<br />\r\n<br />\r\n<br />\r\n<br />\r\nThe public information shows that the animation was founded in 2013, and the company&#39;s brand is &ldquo; HAOLINERS&rdquo; the animation includes &quot;I called Bai Xiaofei,&quot; &quot;the fox demon little red Niang&quot; &quot;the spirit domain&quot; &quot;the end brain&quot; &quot;the chick&quot; &quot;that rabbit that year&quot; and &quot;the former Ling sword mountain&quot;, which is one of the most important animation companies in China.<br />\r\n<br />\r\n<br />\r\n<br />\r\nIt is reported that the current animation in Tokyo, Seoul established a branch, with Fuji television station, GENOSTUDIO has a cooperative relationship, and with the Tokyo MX television cooperation launched a &ldquo; a dream time &rdquo;','0','/Upload/news/8.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('221','41','','1','Why is it the Jingdong? SOGO Wang Xiaochuan said the secret!','','With the fragmented mobile Internet era, users have become scattered, with the changing of the PC market, the demand for desktop products has been reduced gradually. As a high quality e-commerce platform, Jingdong insists on making brand new products for brands through Jingdong Fu, allowing brands to align market demand and thus enhance consumer satisfaction. Recent Jingdong 618 global Year Shopping Festival opened the curtain, Lenovo, HP, ASUS, DELL, Seagate, Iqiyi intelligence, Intel, Kingston, AOC, Sogou, NVIDIA, Gopro, Haman and other brands of Jingdong to call, you can see Jingdong service body is not the same, then how the Jingdong is how to get What is the trust of brand manufacturers?<br/>The author believes that brand manufacturers rely on Jingdong, closely related to the high-quality user group resources of Jingdong. As a high quality shopping platform which is recognized by consumers and trusted by brand manufacturers, Jingdong currently owns over 200 million high quality users. The core demand of the product helps the brand to align the market. And Jingdong big data can also use the data accumulated online to the offline Jingdong\'s home, to achieve the online and offline integration model, to bring &ldquo to consumers; immersive experience &rdquo; this is one of the reasons for many brand manufacturers to pay attention to.<br/>On the other hand, the Jingdong also provides &ldquo with an open attitude for brand makers; reverse customization of &rdquo; capabilities, such as the launch of a 100 billion energy program in Jingdong 618 this year, Lenovo and HP have strategic cooperation with Jingdong, its latest game, &ldquo; Lenovo Savior Y7000&rdquo; and &ldquo; shadow The spirit of the 4 generation of &rdquo; the Jingdong on the same stage to start. In fact, this is not the first cooperation between Jingdong and brand manufacturers. As early as 2015, Jingdong began to promote the reverse customization of products by brand manufacturers. Under the help of Jingdong, the brand manufacturers made amazing sales, which verified the effect of the reverse customization model and the brand products.','0','/Upload/news/9.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('222','41','','1','One article knows quickly to buy A station: what are their abacus?','','On the morning of June 5th, the news of the acquisition of Acfun (A station) by domestic short video and live platform quickly spread throughout the network.<br/>According to the news, the transaction price of the A station will be less than 750 million yuan, and more details are not disclosed. However, in the last round of financing, the A station was valued at RMB 750 million.<br/>Quick hand acquisition of A station<br/>A station response<br/>Subsequently, A station CEO Liu Yanyan told Tencent technology that the message is true and that she will remain at A station and remain independent.<br/>Quick response<br/>The fast hand also responded to Tencent\'s \"first line\", saying that the fast hand side confirmed that it had completed the overall acquisition of Acfun.<br/>In the future, A will maintain its independent brand, maintain its independent operation, maintain its original team and develop independently. And the fast will also give A station strong support in capital, resources, technology and so on.<br/>Shareholders\' response to A station<br/>In the afternoon of June 5th, Acfun shareholders issued a bulletin on Chinese online, which said that the transfer agreement was signed with the quick hand. It is intended to sell the rights and interests of all A stations held by the RMB 140 million yuan.<br/>According to the news, Chinese online convened the board of directors to sign an agreement in November 21, 2016, and it will subscribe 250 million yuan in cash to subscribe 13.51% stake in A station.<br/>However, because the A station did not meet the prerequisites of the relevant capital increase agreement, the follow-up Chinese online only paid 138 million 500 thousand yuan to the A station and did not change the business.<br/>Why did the quick hand buy the A station?<br/>With regard to the reasons for the rapid acquisition of A station, 36 krypton has made a simple analysis from three dimensions: user portrait, overall market environment and commercialization.<br/>1, A station can make up for the shortage of fast hand in user circles.<br/>On the user\'s portrait, the users of the quick hand are enough to sink and average, while the A station is dominated by the young people, and the community culture is heavy. The acquisition of the A station can well complement the shortage of the quick hand in the user circle, and the logic is similar to the stranger acquisition exploration.<br/>According to the data of Aurora data, from the results of user gender distribution, the A station and the fast hand are all higher than men, and the ratio of male to female is similar.<br/>From the result of user city grade distribution, the A station has a larger proportion of users in the first tier cities, accounting for 20.04%, and the new and second line cities also have a higher proportion in the A station users.<br/>The users of the fast track are more sinks, and the number of users in the three line and below cities is more than 60%.<br/>2, quick hands need to take a way to invest in mergers and acquisitions<br/>From the analysis of the overall market environment, as a fast competitor of direct competition, the 150 million day live trembling has surpassed the 100 million day fast runner.<br/>In addition to the strong product R & D and operation ability that the headline relies on the whole short video matrix today, it is not a shortcut to fight the court with a headline.<br/>3, commercialization is always one of the most concerned indicators.<br/>As a short video company, which has been seeking overseas listing, commercialization is always one of the most concerned indicators for fast sellers.<br/>Through the B station listing, the whole market has seen the high proportion of its gaming revenues and its diversified commercial value.<br/>Why does the A station accept the purchase?<br/>Although A station has a high starting point, it is the oldest barrage video website. However, because of the frequent changes of executives and poor management, the development has been cold and clear.<br/>At the beginning of this year, the A station went through a storm of closing stations and unable to visit. It was reported that it had been supported by Ali before resuming its normal operation. However, it was later reported that Alibaba had abandoned its holding plan for A station.<br/>It is also reported that the initial rumor of the cooperation between the quick hand and the A station was a fund that came from the re - launch of the A station early this year, and it was reported that the source of the fund was a quick hand.<br/>In fact, according to the first line, fast hand has always been one of the potential financing side of A station.<br/>In addition, public information shows that the A station dropped to 1 million 600 thousand in actual DAU last November, of which the PC terminal 900 thousand, the mobile end 450 thousand &mdash; &mdash; the number was 12 million in the peak of last year, and the average monthly DAU was 8 million.<br/>When the development is bad, quick hand helps and the team can operate independently. You love me.','0','/Upload/news/4.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('223','41','','1','People\'s Daily commentary on the United States: let\'s clear up our cyberspace.','','Recently, a webcast short video platform has seriously affected young people\'s physical and mental health due to the dissemination of vulgar and unhealthy information about minors. The national network office and the departments jointly interviewed the head of the platform in accordance with the law, and put forward serious criticism and ordered the comprehensive rectification.<br/>This news came out, like many netizens, I also applaud. My son is going to primary school, and pleads with me from time to time to buy him a cell phone. I have never promised, not to save money, but to be afraid of the mess on the Internet.<br/>There is a point of view that the children are online Aboriginal people, doomed to contact the network earlier than the previous generation, more need the network, rather than let them swim in swimming. In order to set up such a statement, it needs a prerequisite, which is the timely shielding of information from the smoky, unhealthy information and a severe blow to the platform for spreading the content of the mental and physical health of minors. This is from a regulatory point of view, so what do we need to do from the supplier side?<br/>In this rectification, there is a sentence worth noting in the statement of the platform: &mdash; &mdash; guide the algorithm with correct values. In other words, many of the previous live short video platforms used to guide the algorithms are not the correct values, but based on the social needs of &mdash; &mdash; and not a noble demand for &mdash; &mdash; to push the content. Nowadays, Internet users are spending a lot of money. When attention becomes a resource, any kind of hobby can give birth to the corresponding supply.<br/>We see a large number of live broadcast platforms with high click through rates, which often have the following characteristics. First, there are extreme qualities, and the grotesque. In front of them, they are either very beautiful or ugly, or they are not dying.<br/>Second, there is a strong desire for expression. I didn\'t hear about the Internet red man. Nothing is more modest than prudence. In its name, the name is straightforward, but in fact it lacks the background.<br/>Third, the fresh-keeping period is short and the substitute is high. A batch of Internet red men came out quickly and disappeared quickly, &ldquo; you were singing in a noisy mess and I was on the stage &rdquo.<br/>Let\'s clear up our cyberspace. This job is not easy, but it is hard to do. On the one hand, it is necessary to define the red line for content providers and change the way of catering to demand. On the other hand, the word \"&ldquo\" is used in the \"Yuan Yuan\", such as living in good people, such as entering the room of \"Lan Zhi\", but not knowing its fragrance for a long time. To live with evil people, such as entering the abalone fish, not to smell their stink for a long time. &rdquo; may you often enter the room of LAN Zhi, less or less.','0','/Upload/news/3.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('224','42','','1','The first domestic 5G chip will be launched in the second half of this year','','Recently, &ldquo; China core &rdquo; the National hot debate is still continuing. In this regard, CEO Ceng Xuezhong, the executive vice president and purple light exhibition of purple light group, said that the next 10 years are the era of artificial intelligence, 5G and AI will usher in the outbreak, and the driving force of technological change comes from the chip.<br/>He stressed that in the next 10 years, no matter how the economy develops, chips will be indispensable. &ldquo; if steel is the foundation of the industrial age, the chip is the foundation of the digital age, and the whole semiconductor industry determines the future development trend of the world. &rdquo;<br/>The 2018Q1 China chip industry market report, released by Amy consulting, shows that China\'s integrated circuit output has reached 156 billion 460 million in 2017, up 18.7% from 2016. As the country pays more attention to the chip industry, and the investment of future R & D resources in enterprises and institutions and other institutions, China\'s integrated circuit output will still be in the future. It is now growing rapidly.<br/>China is the largest and fastest growing market in the world. In 2017, China\'s ten largest chip design rankings have accounted for two &mdash, purple light and HUAWEI hit.<br/>It is understood that from 2G, 3G to 4G to the current 5G, purple exhibition has always insisted on independent innovation. The 2018 year exhibition has launched the SC9850KH chip platform, which is the first Chinese independent domestic CPU chip to realize the real business. It is also the first 4G chip platform in China to embed the key technology of embedded CPU with independent intellectual property rights. At the same time, it also launched the first 8 core AI chip platform SC9863, reducing the threshold for mass consumers to enter 5G and AI.<br/>Ceng Xuezhong said that chip design is the top of the entire chip industry, its contribution to the industry and industry is 1 to 10 to 100, 1 yuan chip can pry the value of the industry 100 yuan, which is why chip design is the importance of the integrated circuit industry. The world is flat and parallel. The future global semiconductor market should be parallel development. You have me, I have you, and the world is one.<br/>It is reported that this year has opened &ldquo in 5G research and development, 5G chip global leading strategy &rdquo, and successively with China Mobile, Intel, HUAWEI, Germany technology, Rhodes and Schwartz strategic cooperation, and planned to launch the first 5G chip in 2018, the second half of 2019 commercial first 5G mobile platform, and the 5G mobile network. The deployment of the collaterals is synchronized to the market.','0','/Upload/news/15.jpg','','','0','0','','','','','0','2018-06-05 18:13:08',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('225','42','','1','Will the yellow car be yellow in the end?','','In a series of rumours and rumours, the yellow car shows that the sharing bicycle industry is in a precarious situation.<br/>The news about the tight fund chain of the small yellow car is not the first time to pass out. In one of the rumors and refuting rumours, the small yellow car shows the wind and rain of the sharing of the bicycle industry.<br/>In June 4th, there were media reports that ofo small yellow car was facing difficulties such as tight capital chain and massive layoffs. It is said that the number of layoffs will be the largest in the history of ofo, with a total reduction of 50% in headquarters and the possibility of further expansion. The layoffs involve all business lines of ofo, including business teams and functional departments. Among them, there are 80 supply chain teams with a layoff ratio of 60%, that is, the supply chain will retain only 32 people.<br/>At the same time, management will also undergo drastic changes. Zhang Yanqi, director of overseas market, resigned and the whole overseas department was dissolved. At the same time, senior executives, including Yang Nan, and vice president of public relations, Yang Xun, are the senior executives who are responsible for marketing public relations.<br/>Overseas business will not be abolished<br/>In response to this, ofo, an internal employee, told the first finance company that Nan Nan had already left, but mainly for personal reasons. Zhang Yanqi did not quit. Recently, the company carried out a major organizational restructuring. Zhang Yanqi may be responsible for the block chain business.<br/>&ldquo, the company has not heard of the large scale downsizing. From the current WeChat group, there are about 2800 people from about 3000 people to the present year, and there is no proportion of the downsizing mentioned in the report. &rdquo; the employees told the first finance.<br/>At the very first time after the incident, ofo co-founder Yu Xin wrote a response in his circle of friends, saying that COO\'s resignation was inconsistent, and that the overseas business was disbanded. On the issue of layoffs mentioned in the report, Yu said that the matter could not be clarified and could only be given time to prove that someone behind it was pushing. One of the rumors, Yang Xun, also responded in a circle of friends, saying he had not left.<br/>Although ofo denies management earthquake and large scale layoffs, but from ofo and drop drop, three stationed executives leave to ofo to bypass the drop mortgage single car to borrow blood to Ali 1 billion 770 million, and refusing to buy the offer to be exposed to a pay reduction, to a certain extent, reflects the financial and operational pressure of the ofo.<br/>Whether it is the bankruptcy fatality of small blue and small cars, or the final &ldquo of the motorist, the arm is no more than the &rdquo of the thigh; there is no clear profit model and positive cash flow, which makes it difficult for the sharing single car business to run independently.<br/>In the early days of sharing bicycles, the founding team and even investors once thought that rent could recover costs and make profits. Ofo founder Dai Wei once counted an account: at present, each car can bring about 5~10 yuan, the cost of ofo bicycles is less than 300 yuan. If it is depreciated according to 12 months\' scrap, the depreciation is less than 1 yuan a day. Every operation and maintenance personnel is responsible for 300 cars, the salary of 100 yuan a day, the cost of each car, the cost of one day. It is less than 1 yuan, and gross profit is around 70%~80%.<br/>But under the help of capital, the parameters of the actual competition field are much more complicated than this account.<br/>A number of bike companies have launched a large number of vehicles, launched &ldquo; no deposit &rdquo; &ldquo; free &rdquo; and other modes, it is not realistic to rely solely on rental profits. &ldquo; the sharing of single car business model is established, but the valuation is too high, in the absence of management, the rent free model is difficult to continue in a second line city, the deposit is also very serious. &rdquo; Chen Yuying CEO once told the first finance company before he was a small cyclist.<br/>The tightening of capital and the high cost of management and operation depend on the single rental income. After the new year, the ofo and the small yellow cars stopped the price war. Ofo even launched commercially commercialized commercials on the body and launched an advertising campaign on APP.<br/>The publication shows that the resource data given by ofo is &ldquo; 15 million vehicles and 250 million users &rdquo; and the advertising price of the brand custom body is 2000 yuan per month, the open screen advertising price is 100~120 yuan, and the 1000CPM is sold. In the third party workplace social networking software, reporters also found that a number of ofo B2B Division staff in promoting advertising business.<br/>But in actual promotion, brand owners still worry about the effect of body advertisement. &ldquo, on the one hand, the advertising position is relatively narrow, a lot of the shared bicycle parking on the roadside is filled with psoriasis advertising, the effect will be discounted, and the mobile advertising should also take into account the environmental security problems of the brand. &rdquo, a senior advertising person, told reporters.<br/>More direct risks come from policies, including cities in Beijing and Shanghai, which have begun to ban commercial advertising on vehicles, and the revenue growth that advertising can bring is not optimistic.<br/>Left and right hand interpacing<br/>The sharing bike market is also brewing new changes, and the giant is the biggest variable.<br/>The Harold cycling, which was invested by Ali, was again invested in an investment of 2 billion yuan in ant gold clothing. According to the Yongan announcement, the share companies have gained 2 billion 60 million yuan for low carbon science and technology, of which the ant gold clothing company, Shanghai Yunxin, is 1 billion 893 million yuan, and the share ratio of Shanghai Yunxin to low carbon technology will rise from 27.6% to 36.7%; the share ratio of Yongan bank will fall from 10.2% to 8.9%, which is the second shareholders and low carbon science and technology. The value of the body is not less than 14.68 billion dollars.<br/>Low carbon science and technology is the operation main body after the combination of low carbon and Yongan. In the past half a year, the harrow single car has completed 4 rounds of financing, the total financing amount is over 1 billion 500 million US dollars, and the scale and speed of financing is in sharp contrast with the whole industry. Ant gold collar has invested three rounds of financing, becoming the largest shareholder of harrow bicycle.<br/>After missing the traffic entrance of the car war, Ali will not miss the huge line of the single car. Since March, the national sesame credit free deposit strategy adopted by the harrow\'s bicycle has become an important grab for Ali\'s promotion of payment tools. In the industry, as the Ali Department layout sharing two important pieces of the single car, the ant gold clothes on the harrow single car frequency increases, making the strategic position of the harrow\'s bicycle in the promotion.<br/>On the other hand, ofo, which has been seeking independent development, is trying to establish its own credit system. Previously, ofo and sesame credit cooperation in the 25 cities of the country launched a policy of credit free deposit, now only Shanghai, Hangzhou, Guangzhou, Shenzhen and Xiamen, which can use the credit free deposit, are the only 5 cities. In other cities, users need to buy 95 yuan &ldquo; welfare package &rdquo; then continue to enjoy the deposit free service, 95 yuan &ldquo; welfare package &rdquo; be directly charged into the account balance, after consumption, users need to buy again.','0','/Upload/news/14.jpg','','','0','0','','','','','0','2018-06-05 18:13:08',NULL,'2','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('226','42','','1','Millet industry chain concept stocks rose, blue think technology','','The annual flagship conference of millet will be held in Shenzhen in May 31st. The new products have been identified as millet 8, MIUI10 and millet Bracelet 3. The official hints that millet 8 will become the strongest millet camera phone, and MIX2s is the strongest camera phone at present, and its DxOMark score reaches 97 points. According to the revelations, millet 8 will also be the first Android to support 3D structured light, while supporting screen fingerprint recognition.<br />\r\n<br />\r\n<br />\r\n<br />\r\nThe first quarter of the domestic smart phone market shipments data is poor, the industry is in full inventory. Changjiang Securities (6.43 -3.02%) pointed out that with the release of Android flagship machine, sales of new machines in the two quarter are expected to drive the industry to be warmer, and a new round of supply chain is opened, and it is expected that consumer demand and supply chain enterprise performance will be improved. In addition, Android brand, especially OPPO/vivo, is expected to arrive at the end of this year and the first half of next year.<br />\r\n<br />\r\n<br />\r\n<br />\r\nChangjiang Securities believes that consumer electronics should be at the bottom of the cycle and should focus on the three clues of cycle, innovation and consumption to reinventing investment logic.<br />\r\n<br />\r\n<br />\r\n<br />\r\nRelevant beneficiary shares:<br />\r\n<br />\r\n<br />\r\n<br />\r\nPu Lu Tong (15.33 -4.37%, stock): millet provides supply chain management services.<br />\r\n<br />\r\n<br />\r\n<br />\r\nZhuo Yi Technology (8.82 suspension, diagnostic stocks): the Tianjin factory, which is responsible for millet mobile power supply, has been on the rise continuously.<br />\r\n<br />\r\n<br />\r\n<br />\r\nFENDA Technology (9.06 -3.82%, stock): FENDA technology is producing a new soundbar for the millet foundry, with an annual output exceeding 700 thousand units. Confirmed by FENDA technology certification, the company is working with millet to develop a new soundbar. According to a close company insider, the order of millet to FENDA is 6-7 million per month, and is expected to be used in the new generation of millet TV in May this year.<br />\r\n<br />\r\n<br />\r\n<br />\r\nKai Run shares (42.42 -0.56%, diagnosis stock): with the depth of cooperation with millet, create intelligent travel Extreme brand &ldquo; 90 &rdquo; and joint venture to set up Shanghai run rice and Shanghai Shuo rice, through millet commercial city and other e-commerce channels to carry out their own brand &ldquo; 90 &rdquo; products sales.','0','/Upload/news/16.jpg','','','0','0','','','','','0','2018-06-05 18:13:08',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('227','42','','1','In the face of AI, the ten thousand sentence I love you is better than a sentence','','When I was young, I heard my parents say the most sentence: &ldquo; you don&#39;t understand! When you grow up, you understand. &rdquo;<br />\r\nWith my five year old IQ, I translate this sentence into: go away.<br />\r\nMy heart is dissatisfied. When adults judge the logic of a thing, is there really no way to explain it to children? A sense of humiliation as a mental retardation arises spontaneously.<br />\r\nThis kind of thing happens repeatedly in life, for example, after many years, a girl&#39;s tears streaming down her eyes and looked at me and said, &quot;you don&#39;t understand!&quot; Then turned away and disappeared under the setting sun, the Mar Sarah Thierry. Leave me silently pushing my bicycle.<br />\r\nYears later, I discovered the fact that your friends, relatives, lovers, people you cherish and depend on, when he says &amp;ldquo, for you! &rdquo; &ldquo; you don&#39;t understand! &rdquo; &ldquo; listen to me! &amp;rdquo, mostly because of the inability to give you an understanding and convincing explanation.<br />\r\nHave you seen ET? Communication between two people is no easier than communication between an individual and an alien. You can make a fine product.<br />\r\n<img src=\"/Upload/news/a4.jpg\" style=\"width: 1080px; height: 567px;\" /><br />\r\nBut I&#39;d like to say, after all,<br />\r\nThe ten thousand sentence is &ldquo; I love you &rdquo; not as good as a &ldquo; I understand your &rdquo;<br />\r\nIt is our instinct to try to understand. In fact, it is difficult to understand a person; it is difficult to understand an AI.<br />\r\nIn the next five minutes, we will discuss two science fiction questions:<br />\r\n1, is it possible for us to understand every decision of artificial intelligence?<br />\r\n2, if so, what method do we use to understand AI?<br />\r\nXing Xinyu<br />\r\nXing Xinyu, it&#39;s the main curry today. The Pennsylvania State University Professor, working safely with Jingdong, tried to use algorithms to explain every decision of artificial intelligence. (why is it safe to cooperate with Jingdong?)<br />\r\nLet&#39; s ROCK<br />\r\n1, we can really &ldquo; understand &rdquo; AI?<br />\r\nFirst, correct most of the people&#39;s misunderstandings.<br />\r\nIf you think, people can understand every decision made by AI in the way of understanding &ldquo; 1+1=2&amp;rdquo. Congratulations, please pay attention to light black technology and continue to punch cards tomorrow.<br />\r\nIn fact, most decisions of artificial intelligence are incomprehensible to human beings. Even scientists who manufacture them: &mdash; &mdash; these artificial intelligence &ldquo; mom and dad &rdquo; can not understand.<br />\r\nYou might say, Nani? How can people not understand what they produce?<br />\r\nFor example, when our ancestors invented wood for fire, they did not understand the principle of combustion. First use and then understand, this is the law of our understanding of the world.<br />\r\nAn example of what most people know:<br />\r\nArafa, the most famous AI Weiqi master.<br />\r\nIn a specific game, the scientist&#39;s father set the target &amp;mdash only for it; &mdash; won the game, but did not stipulate that the Alfa dog had to fall in accordance with the human race. Of course, it is precisely because of this that it can be &ldquo; the blue is better than the blue &rdquo;<br />\r\nThe decision-making process of artificial intelligence, like this Han painting, all the visitors will feel &ldquo; inexplicable &rdquo; until the last second kill, you will suddenly realize.<br />\r\nOK, the misunderstandings have been corrected. The conclusion is:<br />\r\nFrom a certain point of view, the level of artificial intelligence has exceeded that of human brain. How to understand artificial intelligence (AI) is actually an international problem.<br />\r\nIf you only play chess with AI, you will not understand if you do not understand. But, AI is becoming more and more popular, the thing that we can&#39;t understand begins to revolve around life, like a friend who always wears a mask and talk to you, just think about the scalp.','0','/Upload/news/12.jpg','','','0','0','','','','','0','2018-06-05 18:09:21',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('228','42','','1','Those queues and waiting in the scorching sun are the first big Carnival in China.','','If you have been in a new sale of apple, or have been queued to buy Air Jordan, Yeezy limited edition shoes, you must not be unfamiliar with the hot atmosphere of a Pop-up flash store. Hundreds of thousands of users are queuing up and nervous. They can\'t wait to get the first flagship plus 6. The &ldquo of the world; refueling &rdquo; people are participating in this feast to share the atmosphere of love and gathering together.<br/>Unique &ldquo; one plus phenomenon &rdquo;<br/>Recently, a mobile phone has been held in 26 cities, including Beijing, Shanghai, Shenzhen and Chengdu, in 11 countries, including Beijing, Shanghai, Shenzhen and Chengdu. According to one plus mobile social media data, the global participation of over 15000 people has been warmly welcomed by users. In Germany, users waited for more than 17 hours, and at the earliest visitors to the scene in New York, in New York, for 11 hours, and in Bangalore, India, consumers had even forgotten the fact that it was raining in line with the enthusiasm of 6.<br/><img src=\"/Upload/news/a5.jpg\" style=\"width: 750px; height: 355px;\" /><br/>In Bangalore, India, thousands of people queued up for the purchase in the rain.<br/>It is worth mentioning that one plus Pop-up flash shop has been carried out abroad before, and the current domestic users have not yet formed a forming cognition of its &ldquo; flash store activity &rdquo. This first Canadian Pop-up was held in China for the first time, relying on its strong influence on users, attracting a large number of fans to queue up to rush to buy. This is a rare and fresh experience for domestic consumers, after all, the domestic queue to buy new mobile phones, this matter, the past will only happen on the powder, domestic mobile phone manufacturers rarely have such a phenomenon. But one plus did, and the degree of popularity sweeping the globe formed its unique &ldquo; one plus phenomenon &rdquo;<br/><img src=\"/Upload/news/a6.jpg\" style=\"width: 750px; height: 499px;\" /><br/>The first introduction of Pop-up into China has led to massive queuing up.<br/>One plus CEO Liu Zuohu also said in social media: &ldquo; this is the largest and most influential world Pop-up event in the history of a cell phone, thanks to the enthusiastic participation of global users and growing fast. &rdquo;<br/>In fact, it has been four years since the event of a Pop-up flash shop was held. As early as 2015, when one plus mobile phone launched Pop-up flash store in New York Times Square, it attracted local users. Since then, every Pop-up flash store activity on a mobile phone has attracted a large number of users from all over the world to queue up for panic buying. After four years of development, the Pop-up flash shop has become a combination of the tradition, and the global user queuing rush to buy a new machine has gradually evolved into a unique &ldquo; one addition of &ldquo;<br/>Only do the best<br/>Both at home and abroad, a plus shows its unique charm. As a matter of fact, the &ldquo displayed in the Pop-up flash shop and the &rdquo phenomenon are the inevitable result of its long adherence to the quality line.<br/>One plus is one of the few Android mobile camps that insist on launching 1~2 flagship products every year. The insistence on the boutique line reflects the ultimate pursuit of product and quality by Liu Zuohu, a mobile phone CEO.<br/>As one of the biggest product managers, Liu Zuohu said he could not tolerate &ldquo, a product with a general performance and a general performance of &rdquo. &ldquo; I am really not good at making a product with a preset product cost, which is not consistent with our product concept. Every time I plan to add products, I always think about how to bring the best technology and technology to everyone. I like and pursue high quality products. &rdquo, Liu Zuohu said at one plus 6 press conference.<br/>&nbsp;','0','/Upload/news/13.jpg','','','0','0','','','','','0','2018-06-05 18:09:21',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('229','42','','1','Bill Gate said this summer vacation to read these books - Gates\'s summer books.','','Bill, a philanthropist with hundreds of millions of wealth, &middot; Gates spent money on vaccines and aid projects, but he also knew that money could not buy more knowledge.<br/>So, every summer (and during the holidays), Gates will share a reading list with the banner of beach books to introduce the concept of an eye opening. It\'s not a secret, but Gates pretends to be surprised every year. In his personal blog Gates notes (Gates Notes), he wrote, &ldquo; when I tidy up the list of recommendations this summer, I found that some of these books discussed some of the major issues. &rdquo;<br/>In fact, this year he has listed several core issues that readers can find in these big heads. &ldquo; what\'s the knack for genius? Why did the good people fail to report them? Where do human beings come from and where do they go? &rdquo;<br/>The following bibliographies seem to answer these questions in a sequential manner. From the biography of Leonardo &middot; Da &middot; Finch (Leonardo Da Vinci), a woman\'s memoir against cancer to a fictional narration of Abraham &middot by the mouth of the ghost; one of the night of the life of Lincoln (Abraham Lincoln), and even a book explaining the origin and development of life. The above covers only 4 themes, so we might as well regard the fifth books as the clarion call for action. The author of this book is Hans Rosling Hans, a global health expert who died last year. &middot Hans. It goes back to discussing some experiences and lessons, and more directly explains that everyone has the ability to do good deeds for the world.<br/>Leonardo &middot; Da &middot; Finch (Leonardo Da Vinci)<br/>Author: Voight &middot; AI Isaacson (Walter Isaacson)<br/>[cover sheet: Simon and Schuster publishing company (Simon &amp; Schuster)]<br/>As the most admired painter and thinker in the world, &middot; Finch was basically self-taught, and the technical limitations of more than 500 years ago did not limit his conjecture about the principles of the world. As Gates wrote, &ldquo; when he longed to know something, whether through the blood flow of the heart or the shape of the woodpecker\'s tongue, he watched closely, put down his thoughts, and tried to find the answer. &rdquo; curiosity is more valuable than ever before, especially in the Internet age.<br/>Everything Happens for a Reason and Other Lies I&rsquo; ve Loved.<br/>Author: Kate &middot; Bowler (Kate Bowler)<br/>[cover map: Penguin Landon Penguin (Random House)]<br/>When a professor at the Duke Divinity School (Duke) was diagnosed with the fourth stage of colon cancer, she tried to accept the randomness of the contingency and try to find out how to eventually control the randomness. Gates thinks that &ldquo, some &lsquo and why &rsquo is unable to give a satisfactory answer with facts. &rdquo; in his view, this book illustrates the overemphasis on the risk of causal thinking. Bowler grew up in a family of a non Christian family. His family believed that a firm belief can often be rewarded in real terms. Such a growth environment gives her a humorous, helpless and valuable perspective of thinking.<br/>Lincoln in Lincoln in the Bardo<br/>Authors: George &middot; Saunders (George Saunders)<br/>[cover map: Penguin Landon Bookstore]<br/>The premise of this fantasy novel is no exception to the style of writing. The story happened overnight. The American Civil War just started. Abraham &middot; President Lincoln came to the grave where the 11 year old son died recently. Then the ghost appeared, and the story was mainly carried out in a dialogue similar to the script. As Gates wrote, &ldquo; the president rerealized that he sent others\' sons to the battlefield to sacrifice their lives for the country and create tragedies for other families. He has to make a choice. Should the war continue? If so, how can we ensure that the final result is worth such a heavy price? &rdquo;<br/>Origin Story: A Big History of Everything<br/>Author: David &middot; Christian (David Christian)<br/>[cover: Littell and Brown publishing company (Little)Brown and Company)]<br/>Historian David &middot; Christian is good at making the complex world history simple and easy to understand, so his history TED speech in 2011 has been browsed more than 8 million times. This book is a further extension of this ability. As Gates wrote in his book review, Christian pays more attention to the beginning of the change, such as explaining the physics and chemical principles of the big bang, and the biological and anthropological principles behind human primates that have evolved from single cell organisms to more recognizable ones. For inspiring teachers, parents or lifelong learners, Gates also recommended free online courses offered by Christian.<br/>\"The truth\" (Factfulness)<br/>Author: Hans &middot; Roslin, Euler &middot; Roslin (Ola Rosling) and Anna &middot; Roslin &middot; Lorne Lund (Anna Rosling Ronnlund).<br/>As early as April, Gates recommended this book and wrote a separate review that stressed that it was a great inspiration for future reformers. At that time, Gates wrote, &ldquo; most of the books are on the 10 instincts that prevent human beings from seeing the world in fact, from the fear instinct (we pay more attention to the horror) to the scale instinct (the independent data is often more impressive than the reality) and the spacer instinct (most people are in the two extremes. ). For every instinct, he has provided practical advice to guide us to overcome inherent bias. &rdquo;<br/>Last but not least, Gates\'s classic conclusion is: for many people around the world, life is really improving. But we need a lot of imagination, inspiration and input to keep moving forward.','0','/Upload/news/11.jpg','','','0','0','','','','','0','2018-06-05 18:03:03',NULL,'1','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('230','42','','1','In social media big data, there are hidden cruelty and hidden secrets of mobile phones.','','Two or three years ago, when we talked about the wave of mobile Internet, we would definitely mention the popularity of smart phones. In the process of mobile phones becoming our organs, many manufacturers are experiencing cruel stories of their internal organs being emptied.<br/>&ldquo of the year; &rdquo of China cool Union; only HUAWEI could not rain. The sights of the once - sights were deep in the debt crisis, and Kim was still struggling to save itself under a huge hole, and the Meizu was busy adjusting the internal structure of the &hellip; &hellip; the opportunities left for them may not be much.<br/>For HUAWEI, millet, OPPO, vivo, these leaders still face the negative growth of China\'s smart phone market last year. At present, the overall size of the market users is difficult to leap, so the stock users in the tide of change become the focus of competition.<br/>It is hard to say that a series of behaviors of users decide the direction of mobile phone change, or the choice of mobile phone in the right or left. This is more likely to be a two-way flow, the user is releasing the known self and uncovering the unknown, and the handset vendor needs to find a way to improve the retention of the brand in the process of interacting with the user.<br/>User behavior constitutes an industry barometer<br/>Recently, micro-blog and market research company Sano jointly released the 2017 smart phone micro report (hereinafter referred to as &ldquo; report &rdquo). Based on the quantitative analysis of micro-blog users\' active behavior in 2017, the report shows the change of China\'s smartphone market. Micro-blog has recorded the micro-blog data for major mobile phone manufacturers on the market, so it\'s like the stock index\'s meaning to the stock market. To some extent, the report from user behavior is also a barometer for the mobile industry.<br/>1, HUAWEI OV Matthew effect intensifies<br/>Xiaomi has gone through the worst times and returned to the first camp. The fact that micro-blog users\' stock, increment and replacement retention data are integrated also confirm this fact.<br/>From the new point of view, HUAWEI, millet, vivo, OPPO achieved adverse growth, but all only increased by 1%, while the total amount of other brand new shares declined by 3% over the same period.<br/>When changing planes, the retention rate of iPhone was 5% lower than that of last year, while the addition and retention of the four major domestic brands were improved, with the retention rate of HUAWEI and millet increased by 9% and 8% respectively, and also the crown runner up on this key index.<br/>With the acceleration of the market share of HUAWEI\'s four major OV brands, it is even more difficult for the following echelon manufacturers to catch up.<br/>2. Apple\'s advantage has been hit<br/>From the point of view of the replacement flow, whether Android users or iOS users, the choice of iPhone after the switch has decreased significantly. After the iPhone user switch, the proportion of Samsung\'s proportion innovation is only 3%, and the high-end flagship of Samsung has not been able to replace the iPhone. Instead, the share of the choice of OV meters is increasing.<br/>3, the thousand yuan machine began to become a non mainstream<br/>The report shows that only about 1.1% of micro-blog users are interested in buying more than 1000 yuan mobile phones, more than 57..3% users tend to buy more than 2500 yuan mobile phones. At the same time, compared with 44% of the users in 2016, the user replacement cycle will be longer than that of the 50% users in 1 years. In addition, the 26-35 year old white-collar has become the main driver of the 17 year replacement, and 58% users have used at least 5 smart phones.<br/>In fact, it also reflects that consumer upgrading needs a material basis, and on the other hand, the manufacturers need technological innovation to upgrade consumer goods, and the electronic industry needs to innovate in many dimensions of hardware performance, appearance, and user experience.<br/>Content marketing creates social currency<br/>Of course, to win in the wave of change, to improve the retention rate of the brand, in addition to the hardware and face value, more need to understand the psychological motivation of loyal users.<br/>Generally speaking, the motivation of consumers to choose social media is mainly &ldquo; function &rdquo; &ldquo; entertainment &rdquo; &ldquo; social &rdquo; and &ldquo; self &rdquo; four aspects. This requires mobile phone manufacturers to strengthen the connection between consumers and themselves, and build fans relationship with users in order to create social currencies.<br/>As soon as the purchase is gradually disappearing, the consumption of each consumer is ultimately associated with emotion, and the social currency formed by the content operation is actually representing the assets shared between the consumer and the cell phone manufacturer. Such assets satisfy consumer groups\' share and use, and bring them to buy and transform.<br/>1. User portrait<br/>In the era of Internet big data, users get the world. Based on the huge active user data of micro-blog, mobile phone manufacturers can excavate their users\' sex, age, behavior attributes, interests and even psychological characteristics to build a complete set of user portrait. After constantly stacking and updating, users can achieve information and visualization, so as to achieve the goal of precision marketing.<br/>According to this report, iPhone is still the first choice for women in a second tier city. Their age is 19-39 years old. Vivo and OPPO are the main young female users in small and medium-sized cities, but HUAWEI and millet are just the opposite. HUAWEI P10, glory 9, millet 6 and other mainstream models are male users. In addition, the location data of users\' active check-in distribution indicate that different mobile phone users have different living and working conditions.<br/>Such a user portrait also reflects the attention of the manufacturer to the marketing value of the head spokesmen, such as the more brands of millet and HUAWEI, the two male users, and began to force the women\'s market. The fans of their spokesmen are often dominated by female users, such as millet Wu Yifan, HUAWEI\'s Zhang Yixing, Hu Ge; and more female users OPPO and vivo continue to plough the female market, and tend to be more likely to flow small and red flowers in the choice of spokesmen.<br/>2. Content operation<br/>The most effective marketing is not advertising, but the content that enables the audience to take the initiative to interest, covering many dimensions, such as demand, motivation and values.<br/>Unlike the traditional media, such as TV, radio, and newspaper, it is different from other forms of brand advertising (such as outdoor and building). Social media has transformed the one-way brand instillation mechanism into a dialogue mechanism, integrating product information into interesting micro-blog topics and language forms, attracting the attention of micro-blog users. And interest, and interact with it, thus promoting the diffusion of new products.<br/>3. Transfer and transfer<br/>Borrowing the argument of Wei Wu, a real social platform is transmitted quickly by the two sides, but the short video platform is not the same. Therefore, the concept of community and social networking is different. Micro-blog has a social chain and transfers quickly.<br/>At this level, micro-blog is a &ldquo; everyone faces the multi - nonlinear structure of all people &rdquo; each node may be the highlight and selling point of the cell phone.<br/>Write in the end<br/>Mobile phone manufacturer\'s content operation covers at least five value dimensions: functional information, entertainment information, social interaction, brand interaction and self concept value, thus forming &ldquo; content marketing &mdash; customer brand participation in &mdash; brand loyalty &rdquo; chain.<br/>As an open social platform, micro-blog has the innate advantage of being deeply related to mobile phone brands. With the &ldquo, the content fan - user - &rdquo, the social ecology closed loop, micro-blog has set up a unique platform ecosystem that combines star KOL, fans, customers and platforms closely.<br/>Whether it is the celebrity effect of the spokesperson, the high quality IP flow effect, or the reputation effect of the brand, most of them still need the micro-blog and the amplifier. The application of social entry level to the mobile Internet user behavior perspective is an insight into the development trend of the mobile phone industry, and provides a reference for the marketing and product research and development of the smartphone manufacturers.','0','/Upload/news/2.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('231','42','','1','A station to enter two yuan, seven hundred million old iron can tolerate this ','','Millions of &ldquo; monkey &rdquo; finally a new destination, not Ma Yun dad, not &ldquo; not line up the little prince &rdquo; today&#39;s headline, but gathered 700 million &ldquo; old iron &rdquo; the quick hand.<br />\r\nToday&#39;s media reported that the fast team has completed the overall acquisition of &ldquo; Acfun&rdquo; (hereinafter referred to as &ldquo; A station &amp;rdquo). The quick hand has been to &ldquo; Luo super channel &rdquo; confirm this transaction, the quick hand reveals that the future A station will maintain the independent brand, maintain independent operation, maintain the original team, independent development. Quick hands will provide support in capital, resources and technology. However, the fast hand refused to publish the price of the transaction.<br />\r\n<img src=\"/Upload/news/a2.jpg\" style=\"width: 640px; height: 415px;\" /><br />\r\nI was surprised to see the news. Because, I remember, A station no longer exists.<br />\r\nQuick hand pick up cheap, A station is resurrected<br />\r\nFew mainstream Internet Co business will not be able to visit a few days, and on AcFun, it happened several times, because of the slow commercialization, the lack of video license, the copyright dispute, the overfrequency of the management changes, and the mismanagement of many reasons, which once appeared because of no money renewal. The horror of being stopped by a cloud service provider.<br />\r\nAt worst, AcFun domain names almost didn&#39;t renew &mdash; &mdash; when it renewed domain names for another year, monkeys saw a glimmer of hope.<br />\r\nAfter a break, the A station has been a major injury, and it has been reported that Alibaba will receive &mdash; &mdash; Ali&#39;s Youku potato is one of the shareholders of the A station, and since then there is news that the headlines will be connected, but they are unresolved. In short, many people think that A station has not been saved. Now the quick hand dish is settled. It is equal to resurrecting the A station.<br />\r\n<img src=\"/Upload/news/a1.jpg\" style=\"width: 630px; height: 317px;\" /><br />\r\nSince the A station has been in such a bad state, its valuation should not be high. In previous financial rumors, its valuation had been cut down and the price code was estimated to be lower than the price. According to 36kr reports, the A station is estimated to be 750 million yuan before the current round of investment, while the A station has a 1 billion 850 million valuation on the last round of financing. It&#39;s obvious that the quick hand picked up a big bargain.<br />\r\nThe B station, which was born in 2009, has been listed, and the A station online in 2007 is now forced to be sold out, and everyone is in the same vents, and the A station starts early but is not as good as the latter. It can be seen that the business team is the key to the success of the business. &amp;mdash, of course, the A station is a big shareholder and a big failure to introduce a traditional animation company. . Now entering the embrace of fast arms, the complementary space between them is greater and the synergy effect is more, which will naturally bring new possibilities to A station.<br />\r\nMarch into the two dollar and take the young man<br />\r\nThe two dollar market is very important. On the one hand, it is an important content category. On the other hand, it can catch young people.<br />\r\nData show that in 2017, China&#39;s two dimensional user scale reached 308 million, of which 97% were after 90 and 00, the market size of the two yuan industry in China accounted for 57% of the whole entertainment market. The two sub market was not only a barrage such as A station and B station, but also animation, literature, live broadcast, audio, game and so on. As for the giant, it caters to the current user development strategy of holding young people, and has a huge commercial value itself. It is precisely because of this, that BAT has buried heavy troops here.','0','/Upload/news/1.jpg','','','0','0','','','','','0','2018-06-05 17:47:52',NULL,'0','','','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('232','44','','1','Microscope 1',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/1_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'7',NULL,'','','C029','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('233','44','','1','Microscope 2',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/1_2.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'3',NULL,'15','','C030','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('234','44','','1','Microscope 3',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/1_3.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'4',NULL,'','','C031','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('235','44','','1','Microscope 4',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/1_4.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'15',NULL,'','','C032','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('236','44','','1','Microscope 5',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/1_5.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'12',NULL,'','','C033','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('237','44','','1','Microscope 6',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/1_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'11',NULL,'','','C034','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('238','63','','1','UAV 2',NULL,'','0','/Upload/product/2_1_2.jpg','','','0','0','','','','','-1','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('239','63','','1','UAV 4',NULL,'','0','/Upload/product/2_1_4.jpg','','','0','0','','','','','-1','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('240','63','','1','UAV 3',NULL,'','0','/Upload/product/2_1_3.jpg','','','0','0','','','','','0','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('241','63','','1','UAV 5',NULL,'','0','/Upload/product/2_1_5.jpg','','','0','0','','','','','0','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('242','63','','1','UAV 6',NULL,'','0','/Upload/product/2_1_6.jpg','','','0','0','','','','','0','2018-06-05 11:51:02',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('243','63','','1','UAV 1',NULL,'','0','/Upload/product/2_1_1.jpg','','','0','0','','','','','0','2018-06-05 11:50:17',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('244','64','','1','Camera 1',NULL,'','0','/Upload/product/2_2_1.jpg','','','0','0','','','','','-1','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('245','64','','1','Camera 5',NULL,'','0','/Upload/product/2_2_5.jpg','','','0','0','','','','','-1','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('246','64','','1','Camera 6',NULL,'','0','/Upload/product/2_2_6.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('247','64','','1','Camera 2',NULL,'','0','/Upload/product/2_2_2.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('248','64','','1','Camera 3',NULL,'','0','/Upload/product/2_2_3.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('249','64','','1','Camera 4',NULL,'','0','/Upload/product/2_2_4.jpg','','','0','0','','','','','0','2018-06-05 11:52:06',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('250','46','','1','Automobile instrument 6',NULL,'','0','/Upload/product/3_1_6.jpg','','','0','0','','','','','0','2018-06-05 11:56:52',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('251','46','','1','Automobile instrument 1',NULL,'Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information <br / ><br/>Product description information','0','/Upload/product/3_1_1.jpg','','','0','0','','','','','0','2016-04-13 09:33:25',NULL,'7',NULL,'','','C017','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('252','46',NULL,'1','Automobile instrument 5','','Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_5.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'0',NULL,'','518','C013',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('253','46',NULL,'1','Automobile instrument 4','','Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_4.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'1',NULL,'','188','C014',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('254','46',NULL,'1','Automobile instrument 3','','Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_3.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'10',NULL,'','268','C015',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('255','46',NULL,'1','Automobile instrument 2','','Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_2.jpg','',NULL,'0','0',NULL,'','','','0','2013-03-26 18:54:16',NULL,'5',NULL,'15','288','C016',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('256','48','','1','Pressure meter 1',NULL,'','0','/Upload/product/3_1_1.jpg','','','0','0','','','','','0','2018-06-05 11:57:56',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('257','48','','1','Pressure meter 2',NULL,'','0','/Upload/product/3_1_2.jpg','','','0','0','','','','','0','2018-06-05 11:57:56',NULL,'0',NULL,'','','','','','','1','1','2','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('258','48',NULL,'1','Pressure meter 3',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'458','C021',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('259','48',NULL,'1','Pressure meter 4',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'788','C022',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('260','48',NULL,'1','Pressure meter 5',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_5.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,'15','88','C023',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('261','48',NULL,'1','Pressure meter 6',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_1_6.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'3',NULL,NULL,'589','C024',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('262','49','','1','DC digital display 1',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_2_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'5',NULL,'','','C025','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('263','49',NULL,'1','DC digital display 2',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_2_2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'1',NULL,'15','130','C026',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('264','49',NULL,'1','DC digital display 3',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_2_3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'1',NULL,'13','113','C027',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('265','49','','1','DC digital display 4',NULL,'Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information<br/>Product description information','0','/Upload/product/3_2_1.jpg','','','0','0','','','','','0','2013-03-26 18:54:16',NULL,'5',NULL,'','','C028','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('266','50','','1','Counterfeit Enterprises and Governments','','Behind the counterfeiting of enterprises, there are local environmental protection departments &ldquo; open one eye closed one eye &rdquo; inaction or even active fraud to show pollution control achievements. What has been destroyed is not only a few monitoring technicians, several environmental monitoring stations, but also the foundation of the national environmental monitoring data, which has destroyed the credibility of the environmental protection department.<br />\r\n<br />\r\nEnvironmental monitoring data is the decision basis of environmental governance. If the source flooding is false, the decision is bound to be deviant, and it is harmful to the environmental governance opportunity to damage the public interest.<br />\r\n<br />\r\nSince January 1, 2016, the Ministry of environmental protection has implemented the methods of judging and handling environmental monitoring data falsification. According to the provisions of the &quot;measures&quot;, the Ministry of environmental protection will use a special inspection for two years in the future to strictly check the local environmental monitoring data, especially the false behavior of air quality testing data. It is worthwhile to praise the more rigid clubs, the counterfeiting enterprises, the local environmental protection departments and the local governments.<br />\r\n<br />\r\nFrom the overall point of view, the central and local investment in the field of environmental monitoring is huge, and the online monitoring network has already used more than ten billion funds. In theory, it has the ability to monitor tens of thousands of pollution sources. Among them, only one air monitoring system invested 436 million yuan. In 2014, the largest air quality monitoring network in developing countries was built. It is against this background that some local governments have to fabricate and tamper with monitoring data in order to reduce the pressure of assessment. The central leadership has repeatedly issued instructions to crack down on environmental data fraud and strict accountability for false figures.<br />\r\n<br />\r\nEnvironmental monitoring data have risen to the legal level and have a higher binding force. The new environmental law clearly stipulates that the monitoring institutions should use the monitoring equipment that conforms to the national standards, abide by the monitoring standards, be responsible for the authenticity and accuracy of the monitoring data, and punish the tampering, forgery or forgery and forgery of the monitoring data, and investigate legal responsibilities. In the second half of 2015, the environmental protection departments at all levels found 8 typical illegal cases, all of which had been transferred to public security organs, and 10 responsible persons were detained in criminal or administrative detention.<br />\r\n<br />\r\nThe fact that enterprises are being fraudulent shows that there are loopholes in the online environmental monitoring network. I understand that some enterprises have purchased counterfeit equipment, leaving room for data forgery and tampering, trying to muddle through. Some environmental monitoring data released by some local governments do not accord with the intuitive feeling of the citizens. Sometimes there is even a big contrast, which is also related to this loophole.<br />\r\n<br />\r\nOver the years, some local environmental testing data fraud has been an open secret. Just like some of the sewage that has occurred in the desert in recent years, or the sewage discharged into the river, it is all knowingly illegal. In my opinion, there are local environmental protection departments &amp;ldquo behind these enterprises&#39; counterfeiting behavior; open one eye closed one eye &rdquo; inaction, and even do not exclude the active cooperation of counterfeiting in order to show the achievement of pollution control. This practice has destroyed not only the monitoring technicians and several environmental monitoring stations, but also the foundation of the national environmental monitoring data, which undermined the credibility of the environmental protection department.','0','/Upload/case/case5.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'7',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('267','50','','1','Automatic alarm for an workshop','','In the drilling operation of oil field or gas field, because of the remote geographical location, bad climate environment, poor construction conditions and frequent moving wells, it is very difficult to lay the cable on the drilling, and the cost is high. Therefore, wireless communication instead of cable transmission signal arises at the historic moment. The latest wireless communication developed by de Kang is produced in this environment. Lithute electronics provides the latest high-tech gas detection wireless communication system in Germany as the only general agent in the United States. The modular structure designed for oil well oil wells can be used for low power gas detector, solar power supply, high energy storage battery, controller of various channels and acoustooptic alarm. All of these products are all wireless communication, and all are explosion-proof products, which are most suitable for drilling and oil field applications.','0','/Upload/case/case6.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'10',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('268','50','','1','Making instrument for an AI enterprise','','Artificial intelligence is a branch of computer science. It attempts to understand the essence of intelligence and produces a new intelligent machine that can react in a similar way of human intelligence. The research in this field includes robots, language recognition, image recognition, Natural Language Processing and expert systems. Since the birth of artificial intelligence, the theory and technology have become more mature, and the application field is also expanding. It is possible to imagine that the scientific and technological products brought by artificial intelligence in the future will be the &amp;ldquo of human intelligence; the container &rdquo; Artificial intelligence can simulate the information process of people&#39;s consciousness and thinking. AI is not human intelligence, but it can think like human beings, and may also exceed human intelligence.<br />\r\n<br />\r\nArtificial intelligence is a challenging science. People who engage in this work must know computer knowledge, psychology and philosophy. Artificial intelligence includes a wide range of science, which consists of different fields, such as machine learning, computer vision and so on. In general, one of the main objectives of the research of artificial intelligence is to make the machine competent for some complex work that usually requires human intelligence to complete. But different times and different people have different understanding of this &amp;ldquo and complex work &amp;rdquo. [1] &nbsp; in December 2017, artificial intelligence was selected for &ldquo; the ten popular language of Chinese media in 2017.','0','/Upload/case/case7.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'32',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('269','50','','1','Air humidity and wind direction','','With the implementation of a series of national key projects, the instrumentation industry has gained increasing attention and support from the government. This will make the market value of instrumentation industry increasingly prominent. But for the past year, there have been a lot of great events in the instrument and instrument circle. The CCTV hosts study PM2.5 at their own expense, but the data have been questioned; &ldquo; water ten &rdquo; the overseas acquisition of domestic instruments; the dark matter detection satellite developed by Chinese scientists; the laboratory safety is very important, fire. Disaster monitoring instrument is essential; instrument and related meetings frequently convened and so on. Next I will bring you together to summarize.<br />\r\n<br />\r\nCCTV host Jing Chai released &quot;dome below&quot; data was questioned, the reliability of relevant testing equipment and data is imminent<br />\r\n<br />\r\nIn March of this year, Jing Chai, the host from CCTV, released a deep public interest survey &quot;Jing Chai haze investigation: under the dome&quot;. This piece of publicity, Jing Chai used a lot of data and data to support her conclusion, knowing that a friend&#39;s doctoral thesis was just a little related to emission. He looked at it a little wrong, looked up the data, and found that almost every data had problems. The first is to intentionally confuse fog and haze and PM2. 5, the next is the lack of testing range and sensitivity data, air humidity and wind direction conditions, the flow data of the sampling instrument, and the background and time of changing data to form misleading impressions and tamper information. This report comes out, let netizens cry: professional matters or professional people to do it!<br />\r\n<br />\r\nNext is the series of problems such as the data counterfeiting of air purifier developed by Xiaomi, the inaccuracy of various environmental testing instruments, and the fraud of monitoring data. In the second half of 2015, the environmental protection departments at all levels found 8 typical illegal cases, all of which had been transferred to public security organs, and 10 responsible persons were detained in criminal or administrative detention. Since January 1, 2016, the Ministry of environmental protection has implemented the methods of judging and handling environmental monitoring data falsification. According to the provisions of the &quot;measures&quot;, the Ministry of environmental protection will use a special inspection for two years in the future to strictly check the local environmental monitoring data, especially the false behavior of air quality testing data. It is worthwhile to praise the more rigid clubs, the counterfeiting enterprises, the local environmental protection departments and the local governments.','0','/Upload/case/case8.jpg','','','0','0','','','','','0','2013-03-26 20:46:31',NULL,'95',NULL,'','','','','','','1','1','2','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('147','55','','1','中国梦多美妙篇','','','0','/Upload/video/zhongguo.jpg','','https://res.youdiancms.com/zhongguo.mp4','0','0','','','','','0','2013-04-27 18:06:04',NULL,'104','','9','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('150','55','','1','聚美优品创意广告','','<p>你只闻到我的香水，却没看的我的汗水，你有你的规则，我有我的选择，你否定我的现在，我决定我的未来，你嘲笑我一无所有，不配去爱，我可怜你总是等待，你可以轻视我们的年轻，我们会证明这是谁的时代，梦想是注定孤独的旅行，路上少不了质疑和嘲笑，但那又怎样，哪怕遍体鳞伤也要活的漂亮！</p>\r\n','0','/Upload/video/jumei.jpg','','https://res.youdiancms.com/jumei.mp4','0','0','','','','','4','2013-04-27 20:05:14',NULL,'70','','7','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('203','55','','1','撸起袖子加油干','','','0','/Upload/video/jiayougan.jpg','','https://res.youdiancms.com/jiayougan.mp4','0','0','','','','','0','2018-06-07 16:13:05',NULL,'6','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('153','55','','1','还是组队出门比较安全','','','0','/Upload/video/haishi.jpg','','https://res.youdiancms.com/haishi.mp4','0','0','','','','','2','2015-06-17 10:10:17',NULL,'41','','','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('162','26','','1','汽车仪表1',NULL,'<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span><br />\r\n<span style=\"color: rgb(98, 98, 98); font-family: 宋体; line-height: 21.6px;\">产品描述信息</span>','0','/Upload/product/3_1_1.jpg','','','0','0','','','','','0','2016-04-13 09:33:25',NULL,'9',NULL,'','','C017','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('199','22','','1','那些烈日下的排队、等待，是一加在国内的第一次大狂欢','','<p>如果你参加过苹果新品发售的抢购，或是排队买过 Air Jordan、Yeezy 限量版球鞋，那你一定不会对一加 Pop-up 闪店活动的火热气氛感到陌生。成百上千的用户排成长龙，满怀紧张的心情，迫不及待地想第一时间上手最新的一加旗舰一加 6。全球的&ldquo;加油&rdquo;们纷纷参与到这场盛宴中来，共同感受因热爱而汇聚在一起的氛围。</p>\r\n\r\n<p>　　独特的&ldquo;一加现象&rdquo;</p>\r\n\r\n<p>　　近日，一加手机在全球 11 个国家，包括中国北京、上海、深圳和成都在内的 26 个城市举行了一加 6 线下 Pop-up 闪店活动。根据一加手机社交媒体数据显示，此次活动全球参与人数超过 15000 人，受到了用户们的热烈欢迎。在德国，有用户等了足足 17 个小时，在纽约 Pop-up 活动最早来到现场的用户等了 11 个小时，而在印度的班加罗尔，消费者们对于一加 6 的热情甚至让他们忘记了正在下雨排队的事实。</p>\r\n\r\n<p><img src=\"/Upload/news/a5.jpg\" style=\"width: 750px; height: 355px;\" /></p>\r\n\r\n<p>　　在印度班加罗尔，出现千人冒雨排队购机的情景</p>\r\n\r\n<p>　　值得一提的是，一加的 Pop-up 闪店活动此前一直在国外开展，当下国内用户其实还未形成对其&ldquo;闪店活动&rdquo;的成型认知。此次一加在国内首度举行 Pop-up，依靠自身对用户强大的影响力，吸引了大量的粉丝前来排队抢购。这对于国内的消费者来说，是一次难得的新鲜体验，毕竟国内排队买手机新品这件事，从前只会发生在果粉身上，国产手机厂商鲜有这样的现象。但一加却做到了，席卷全球的火爆程度形成了其独特的&ldquo;一加现象&rdquo;。</p>\r\n\r\n<p><img src=\"/Upload/news/a6.jpg\" style=\"width: 750px; height: 499px;\" /></p>\r\n\r\n<p>　　一加 Pop-up 首次引入国内，便引发大规模排队热潮</p>\r\n\r\n<p>　　一加 CEO 刘作虎也在社交媒体上表示：&ldquo;这是一加手机有史以来举行的最大规模、影响范围最广的一次世界性 Pop-up 活动, 感谢全球用户的热情参与，一加正在快速成长。&rdquo;</p>\r\n\r\n<p>　　其实，一加 Pop-up 闪店活动举办至今已有四年历史。早于 2015 年，一加手机首次在纽约时代广场开展 Pop-up 闪店活动时，便吸引了当地用户大排长龙。自此以后，一加手机的每场 Pop-up 闪店活动，都会吸引全球范围的大批用户排队抢购。经过四年的发展，如今 Pop-up 闪店活动已成为一加的一种传统，而全球用户排队抢购一加新机的热潮也逐渐演变成独特的&ldquo;一加现象&ldquo;。</p>\r\n\r\n<p>　　只做精品</p>\r\n\r\n<p>　　无论国内还是国外，一加均显示了它独特的魅力。事实上一加 Pop-up 闪店活动所展现的&ldquo;一加现象&rdquo;是其长期以来坚持精品化路线的必然结果。</p>\r\n\r\n<p>　　一加是 Android 手机阵营中为数不多坚持每年只推出 1~2 款旗舰产品的企业。对精品化路线的坚持，体现着一加手机 CEO 刘作虎对于产品和品质的极致追求。</p>\r\n\r\n<p>　　作为一加最大的产品经理，刘作虎表示自己忍受不了&ldquo;长得一般、性能一般&rdquo;的产品。&ldquo;我个人真的不擅长卡位做一款预设产品成本的产品，这也跟我们的产品理念不相符合，每次在规划一加产品的时候我总是想，怎么样把最好的技术和工艺带给大家，我喜欢和追求的始终是高品质的精品。&rdquo;刘作虎在一加 6 发布会上说到。</p>\r\n\r\n<p>&nbsp;</p>\r\n','0','/Upload/news/13.jpg','','','0','0','','','','','0','2018-06-05 18:09:21',NULL,'3','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('187','22','','1','快手收购A站进军二次元，七亿老铁能容得下这只百万猴子吗？','','<p>百万&ldquo;猴子&rdquo;终于有了新归宿，不是马云爸爸，不是&ldquo;不站队小王子&rdquo;今日头条，而是聚集了7亿&ldquo;老铁&rdquo;的快手。</p>\r\n\r\n<p>　　今天媒体报道，快手已完成对&ldquo;Acfun&rdquo;（下文简称&ldquo;A站&rdquo;）的整体收购。快手已向&ldquo;罗超频道&rdquo;确认本次交易，快手透露未来A站将保持独立品牌、维持独立运营、保持原有团队、独立发展。快手会在资金、资源、技术等方面给予支持。不过，快手拒绝公布此次交易的价格。</p>\r\n\r\n<p style=\"text-align: center;\"><img src=\"/Upload/news/a2.jpg\" style=\"width: 640px; height: 415px;\" /></p>\r\n\r\n<p style=\"text-align: center;\">　　看到这个消息，我还是蛮诧异的。因为，我印象中，A站已经不复存在了。</p>\r\n\r\n<p>　　快手捡便宜，A站被复活</p>\r\n\r\n<p>　　很少有主流互联网公司的业务会几天时间都访问不了，而在AcFun身上，就发生了好几次这样的事儿，因为商业化缓慢，缺乏视频牌照，版权纠纷缠身，管理层变动过于频繁，诸多原因导致经营不善，一度出现了因为没钱续费被云服务商停服的惨状。</p>\r\n\r\n<p>　　最惨的时候，AcFun域名都差点没有续费&mdash;&mdash;当它续费域名又一年后，猴子们才看到一丝希望。</p>\r\n\r\n<p>　　经过一番折腾后，A站已是大伤元气，此前据传阿里巴巴将会接盘&mdash;&mdash;阿里旗下优酷土豆是A站股东之一，此后又有消息传今日头条会接盘，但都悬而未决。总之，很多人都以为A站没救了，现在快手接盘尘埃落定，等于是复活A站。</p>\r\n\r\n<p style=\"text-align: center;\"><img src=\"/Upload/news/a1.jpg\" style=\"width: 630px; height: 317px;\" /></p>\r\n\r\n<p style=\"text-align: center;\">　　既然A站此前状态如此糟糕，那么它的估值应该不会高，此前的融资传言中，其估值就已被腰斩，估计快手给的价码，比腰斩更低。根据36kr报道，A站本轮投前估值为 7.5 亿人民币，A站上一轮融资时估值达到了18.5亿。显而易见，快手捡了个大便宜。</p>\r\n\r\n<p>　　2009年诞生的B站已经上市，2007年上线的A站如今却被迫卖身，大家处于同样的风口，A站起步早却发展不如后者，可见经营团队才是创业能否成功的关键&mdash;&mdash;当然， A站引入某个传统动漫公司作为大股东，也是一大败笔。如今进入快手怀抱，两者互补空间更大，协作效应更多，自然会给A站带来新的可能。</p>\r\n\r\n<p>　　进军二次元，拿下年轻人</p>\r\n\r\n<p>　　二次元市场十分重要。一方面它是一个重要的内容品类，另一方面可以抓住年轻人。</p>\r\n\r\n<p>　　有数据显示，2017年中国二次元用户规模达到3.08亿，其中97%都是90后、00后，中国二次元产业的市场规模占整个泛娱乐市场规模的57%，二次元市场不只是有A站、B站这样的弹幕网站，还有动漫、文学、直播、音频、游戏等等形态，对于巨头而言，它即迎合了当前各家抓住年轻人的用户发展战略，本身也有巨大的商业价值，正是因为此，BAT都在此埋下重兵。</p>\r\n','0','/Upload/news/1.jpg','','','0','0','','','','','0','2018-06-05 17:47:52',NULL,'0','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('188','22','','1','社交媒体大数据里，藏着手机江湖的残酷物语和崛起秘辛','','<p>两三年前，当我们谈到移动互联网浪潮时，一定会提及智能手机的普及。而在手机逐渐成为我们器官的过程中，诸多厂商却经历着自身内脏被掏空的残酷物语。</p>\r\n\r\n<p>　　当年的&ldquo;中华酷联&rdquo;，只剩下华为风雨不倒。曾风光一时的乐视手机深陷债务危机，金立还在巨大的资金窟窿下努力自救，魅族忙着内部架构大调整&hellip;&hellip;留给他们的机会可能都不多了。</p>\r\n\r\n<p>　　对于华为、小米、OPPO、vivo这些领跑者来说，也仍然面临中国智能手机市场去年负增长的现实。目前来看，市场用户总体规模难以有大的跃升，于是乎换机潮中的存量用户成为争夺焦点。</p>\r\n\r\n<p>　　很难说，是用户的一系列行为决定了手机变革的走向，还是手机本身在左右用户的选择变迁。这更应该是一个双向的流动，用户在释放已知的自己，同时发掘未知的自己，而手机厂商则需要在与用户互动过程中，找到提升品牌留存率的法门。</p>\r\n\r\n<p>　　用户行为构成行业晴雨表</p>\r\n\r\n<p>　　最近，微博与市场调研公司赛诺联合发布了《2017年智能手机微报告》（以下简称&ldquo;报告&rdquo;）。报告基于对2017年微博用户活跃行为数据的定量分析，呈现出中国智能手机市场格局的变化。微博记录了市场上主流手机厂商主要机型的微博使用数据，所以就像股指之于股市的意义，一定程度上，这份从用户行为出发的报告也是手机行业的晴雨表。</p>\r\n\r\n<p>　　1、华为OV马太效应加剧</p>\r\n\r\n<p>　　小米已经走过最坏的时代，重回第一阵营。综合微博用户存量、增量及换机留存率数据表现，也印证了这一事实。</p>\r\n\r\n<p>　　从新增来看，华为、小米、vivo、OPPO实现逆势增长，但都仅仅提升1%，而其它品牌新增份额总量则同比出现了3%的下滑。</p>\r\n\r\n<p>　　换机时的留存方面，iPhone的留存率比去年降低了5%，而四大国产品牌的新增和留存皆有所提升，其中华为和小米的留存率分别提高了9%和8%，也成为了这一关键性指标上的冠亚军。</p>\r\n\r\n<p>　　随着华为OV四大国产品牌的市场份额加速集中化，后续梯队的厂商要再追上难上加难。</p>\r\n\r\n<p>　　2、苹果优势遭受冲击</p>\r\n\r\n<p>　　从换机流向上来看，无论安卓用户还是iOS用户，换机后选择iPhone都有明显下降。iPhone用户换机后选择三星的比例创新低只有3%，三星的高端旗舰也没有能够为iPhone的替代，反而是选择华OV米的份额在增加。</p>\r\n\r\n<p>　　3、千元机开始成为非主流</p>\r\n\r\n<p>　　报告显示，目前仅有1.1%左右的微博用户有意向购买1000元以下的手机，超过57.3%的用户更倾向于购买2500元以上的手机。同时，与2016年44%的用户会在1年内更换手机相比，用户换机周期变长，接近50%用户两年换机。此外，26-35岁白领阶层成为17年的换机主力，58%用户至少使用过5个智能手机。</p>\r\n\r\n<p>　　这其实也反映出，用户实现消费升级需要物质基础，另一面，厂商则需要科技创新来提升消费品档次，电子产业需要在硬件性能、外观、用户体验的多个维度革新。</p>\r\n\r\n<p>　　内容营销创造社交货币</p>\r\n\r\n<p>　　当然，要在换机浪潮中获胜，提升品牌留存率，除了在硬件和颜值上下功夫以外，更需要了解忠实用户的心理动因。</p>\r\n\r\n<p>　　一般来说，消费者选择社交媒体的动机主要有&ldquo;功能&rdquo;、&ldquo;娱乐&rdquo;、&ldquo;社交&rdquo;和&ldquo;自我&rdquo;四个方面。这就要求手机厂商需加强消费者与自身的连接，构建与用户的粉丝关系，才能创造出社交货币。</p>\r\n\r\n<p>　　刚需购买逐渐消失的时代，每一个消费者的消费最终都与情感相联系，而由内容运营出发所形成的社交货币，其实就代表了消费者与手机厂商之间共享的资产。这类资产使消费群体获得分享和使用满足，给厂商则带来购买转化。</p>\r\n\r\n<p>　　1、用户画像</p>\r\n\r\n<p>　　在互联网大数据时代，得用户者得天下。以微博庞大的活跃用户数据为依托，手机厂商能够挖掘其用户的性别、年龄、行为属性、兴趣爱好甚至心理特征等数据构建出一整套完善的用户画像。经过不断叠加、更新，实现用户的信息化乃至可视化，从而达到精准营销强的目的。</p>\r\n\r\n<p>　　从这份报告来看，iPhone仍然是一二线城市女性首选，她们的年龄集中在19-39岁。vivo和OPPO以中小城市的年轻女性用户为主，华为和小米却刚好相反，华为 P10、荣耀 9、小米 6 等主流机型都是男性用户为主。此外，用户主动签到分布的地点数据也在大概率上表明，不同手机用户不一样的生活和工作状况。</p>\r\n\r\n<p>　　这样的用户画像也反映出厂商对头部代言人营销价值的重视，比如小米、华为这两大男性使用者更多的品牌，开始向女性市场发力。其代言人的粉丝往往以女性用户为主，例如小米的吴亦凡，华为的张艺兴、胡歌；而女性用户更多的OPPO和vivo则继续深耕女性市场，在代言人选择上更倾向于流量小生和当红小花。</p>\r\n\r\n<p>　　2、内容运营</p>\r\n\r\n<p>　　最有效的营销不是广告，而是让受众能够主动感兴趣的内容，涵盖需求、动机、价值观等众多维度。</p>\r\n\r\n<p>　　与传统的电视、广播、报纸等媒体不同，与其他形式品牌广告投放（比如户外、楼宇等）也不同，社交媒体将单向品牌灌输机制转变成为对话机制，把产品信息融入到有趣的微博话题和语言形式之中，吸引微博用户的关注和兴趣，并与之展开交流互动，进而促进新产品的扩散。</p>\r\n\r\n<p>　　3、传受转换</p>\r\n\r\n<p>　　借用魏武挥的说法，一个真正的社会化平台，传受双方的切换非常快，但短视频平台不是，传受泾渭分明。故而社区和社交的概念是不一样的，微博拥有社交链条，传受转换非常迅速。</p>\r\n\r\n<p>　　从这个层面上来看，微博是&ldquo;所有人面向所有人&rdquo;的多元非线性结构，每一个节点都可能成为手机的亮点和卖点。</p>\r\n\r\n<p>　　写在最后</p>\r\n\r\n<p>　　手机厂商的内容运营涵盖至少五个价值维度:功能性信息、娱乐性信息、社交互动、品牌互动以及自我概念价值，从而形成&ldquo;内容营销&mdash;顾客-品牌参与&mdash;品牌忠诚&rdquo;的链条。</p>\r\n\r\n<p>　　微博作为开放的社交平台，与手机品牌具备深度关联的先天优势。随着&ldquo;内容-粉丝-用户-变现&rdquo;的社交生态闭环逐渐完善，微博建立起一套独有的平台生态系统，将明星KOL、粉丝、客户与平台紧密相结合。</p>\r\n\r\n<p>　　无论是代言人的明星效应，优质IP的流量效应、还是品牌的口碑效应，大多数都还是需要微博这个粘合器和放大器。社交入口级应用以移动互联网用户行为视角洞察手机行业发展态势，为智能手机厂商的市场营销、产品研发提供参考。</p>\r\n','0','/Upload/news/2.jpg','','','0','0','','','','','0','2018-06-05 17:52:13',NULL,'0','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('169','30','','1','MySql 5.0',NULL,'MySQL是一个关系型数据库管理系统，由瑞典MySQL AB 公司开发，目前属于 Oracle 旗下产品。MySQL 是最流行的关系型数据库管理系统之一，在 WEB 应用方面，MySQL是最好的 RDBMS (Relational Database Management System，关系数据库管理系统) 应用软件。<br />\r\nMySQL是一种关系数据库管理系统，关系数据库将数据保存在不同的表中，而不是将所有数据放在一个大仓库内，这样就增加了速度并提高了灵活性。<br />\r\nMySQL所使用的 SQL 语言是用于访问数据库的最常用标准化语言。MySQL 软件采用了双授权政策，分为社区版和商业版，由于其体积小、速度快、总体拥有成本低，尤其是开放源码这一特点，一般中小型网站的开发都选择 MySQL 作为网站数据库。由于其社区版的性能卓越，搭配 PHP 和 Apache 可组成良好的开发环境。','0','','','/Upload/download/mysql.rar','0','0','','','','','0','2016-04-13 17:24:22','','1','','','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('170','30','','1','MyEclipse5.8英文版',NULL,'MyEclipse 是一个十分优秀主要用于开发Java, J2EE的 Eclipse 插件集合。全称MyEclipseEnterprise Workbench，是对EclipseIDE的扩展。使用MyEclipse，让我们可以在数据库和JavaEE的开发、发布以及应用程序服务器的整合方面极大的提高工作效率。MyEclipse是差不多把目前所有主流开源产品的专属eclipse开发工具，都包含进去了。而且它还完整地支持HTML，Struts，JSP，CSS，Javascript，Spring，SQL，Hibernate，EJB3,JDBC数据库链接工具等多项功能，值得推荐使用！','0','','','/Upload/download/myeclipse.rar','0','0','','','','','0','2016-04-13 17:29:02','','7','','','','','','','','1','1','1','1','','',NULL,'','128','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('202','22','','1','小米产业链概念股涨幅居前，蓝思科技等多股跟涨','','小米年度旗舰发布会将于5月31日在深圳召开，已确定的新品有小米8、MIUI10、小米手环3。官方暗示，小米8将成为最强的小米拍照手机，目前MIX2s是最强的拍照手机，其DxOMark评分达到了97分。另据爆料，小米8还将成为安卓阵营中首款支持3D结构光的机型，同时支持屏幕指纹识别。<br />\r\n<br />\r\n　　一季度国内智能手机市场出货数据较差，行业处于全面去库存。长江证券(6.43 -3.02%,诊股)指出，随着安卓旗舰机的发布，二季度新机销量有望带动行业回暖，供应链新一轮备货开启，预计消费者需求与供应链企业业绩将出现环比改善。此外，安卓品牌特别是OPPO/vivo的换机时点也有望在今年末至明年上半年到来。<br />\r\n<br />\r\n　　长江证券认为，消费电子处于周期底部向上，应当围绕周期、创新与消费升级三条线索重塑投资逻辑。<br />\r\n<br />\r\n　　相关受益股：<br />\r\n<br />\r\n　　普路通(15.33 -4.37%,诊股)：小米提供供应链管理服务。<br />\r\n<br />\r\n　　卓翼科技(8.82 停牌,诊股)：负责小米移动电源的天津工厂，其供货量一直处于持续上升的状态。<br />\r\n<br />\r\n　　奋达科技(9.06 -3.82%,诊股)：奋达科技正在为小米代工生产一款新品soundbar，预计年产量超70万台。经奋达科技证代确认，公司正在与小米合作研发一款新品soundbar。另据一位接近公司的业内知情人士透露，目前小米给奋达下的订单为6-7万台每月，预计将用于今年5月新一代小米电视中搭售。<br />\r\n<br />\r\n　　开润股份(42.42 -0.56%,诊股)：与小米深度合作，打造智能出行极致品牌&ldquo;90分&rdquo;，并合资设立上海润米与上海硕米，通过小米商城等电商渠道进行自有品牌&ldquo;90分&rdquo;产品的销售。','0','/Upload/news/16.jpg','','','0','0','','','','','0','2018-06-05 18:13:08',NULL,'0','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('205','55','','1','保护森林','','','0','/Upload/video/baohu.jpg','','https://res.youdiancms.com/baohu.mp4','0','0','','','','','0','2018-06-07 16:17:56',NULL,'20','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('206','55','','1','税务','','','0','/Upload/video/shuiwu.jpg','','https://res.youdiancms.com/shuiwu.mp4','0','0','','','','','0','2018-06-07 16:18:41',NULL,'19','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0',''),
('207','55','','1','节能环保','','','0','/Upload/video/jieneng.jpg','','https://res.youdiancms.com/jieneng.mp4','0','0','','','','','0','2018-06-07 16:19:08',NULL,'46','','','','','','','','1','1','1','1','','',NULL,'','0','','0','0','0','0','0','0','0','9999','0','0','0','0','0','');

INSERT INTO `youdian_job` VALUES
('1','销售经理','大专以上','男女不限','20-25岁','面议','不限','10','北京','长期有效','<div class=\"cc_l\">1、普通话标准，性格开朗，善于与人沟通，具有一定的亲和力；<br />\r\n2、有一定的客户资源优先；<br />\r\n3、具有一定的市场开拓能力，挖掘客户潜在需求能力；<br />\r\n4、具有良好的客户服务意识，高度的责任感。</div>\r\n','1','2012-08-23 17:18:10','1','1'),
('2','平面设计师','大专以上','女','20-30','3000-5000/月','不限','5','北京','长期有效','<div class=\"cc_l\">1、美术、平面设计相关专业，大专以上学历；<br />\r\n2、有扎实的美术功底、良好的创意思维和理解能力，能及时把握客户需求；<br />\r\n3、熟练使用设计相关工具，如Photoshop、Illustrator、Dreamweaver、Flash等；<br />\r\n4、了解div+css+js网页布局设计；<br />\r\n5、善于与人沟通，良好的团队合作精神和高度的责任感，能够承受压力，有创新精神，保证工作质量；</div>\r\n','0','2012-11-14 14:24:54','1','1'),
('3','前台接待','大专','女','20-25','面议','不限','2','北京','长期有效','<div class=\"cc_l\">1、性格开朗，待人热情，身高1.60米以上，形象好，气质佳；<br />\r\n2、普通话流利，具有良好的语言表达能力和沟通应变能力；<br />\r\n3、熟练使用电脑、传真机及各种办公软件word，excel；<br />\r\n4、工作积极主动，认真严谨，具备良好的团队合作精神；<br />\r\n5、具有良好的思想道德素质，责任心强，较强的服务意识。</div>\r\n','0','2012-11-15 15:11:32','1','1'),
('4','Sales Manager','University Degree','Unlimited','20-25','Negotiable','Unlimited','10','Beijing','Unlimited','<p>1, good putonghua, cheerful, affinity, good at communicating;<br />\r\n2, having a customer resources is preferred;<br />\r\n3, having a ability of market development and mining customer potential demand;<br />\r\n4, good customer service consciousness, high sense of responsibility.</p>\r\n','0','2012-11-15 15:11:54','1','2'),
('5','Receptionist','University Degree','Female','20-25','Negotiable','Unlimited','2','Beijing','Unlimited','<p>1, cheerful, warm, height 1.60 meters of above, good face, good temperament;<br />\r\n2, good putonghua, good language expression ability and communication ability;<br />\r\n3, skilled use of computer, fax and all kinds of office software,eg. word, excel;<br />\r\n4, work actively, serious, and good team cooperation spirit;<br />\r\n5, good ideological and moral quality, strong sense of responsibility, strong sense of service.</p>\r\n','0','2013-03-27 16:26:42','1','2'),
('6','Graphic Designers','University Degree','Female','20-30','3000-5000','Unlimited','5','Beijing','Unlimited','<p>1, related to arts, graphic design specialty, college degree or above;<br />\r\n2, good art foundation, good understanding of the creative thinking and ability, understanding customer requirement;<br />\r\n3, skilled use of design tools, such as Photoshop, Illustrator, Dreamweaver, Flash etc.;<br />\r\n4, understanding of div+css+js webpage layout design;<br />\r\n5, good communication skills, team cooperation spirit and high sense of responsibility, bearing pressure,innovation spirit, guarantee the quality of work;</p>\r\n','0','2013-03-27 16:26:42','1','2');

INSERT INTO `youdian_label` VALUES
('1','热门','30','0','1','1'),
('2','头条','30','0','1','1'),
('3','推荐','30','0','1','1'),
('4','热门','31','0','1','1'),
('5','头条','31','0','1','1'),
('6','推荐','31','0','1','1'),
('7','热门','34','0','1','1'),
('8','头条','34','0','1','1'),
('9','推荐','34','0','1','1'),
('10','热门','35','0','1','1'),
('11','头条','35','0','1','1'),
('12','推荐','35','0','1','1'),
('13','热门','36','0','1','1'),
('14','头条','36','0','1','1'),
('15','推荐','36','0','1','1'),
('16','保留使用','37','0','1','1'),
('17','保留使用','37','0','1','1'),
('18','保留使用','37','0','1','1'),
('19','保留使用','38','0','1','1'),
('20','保留使用','38','0','1','1'),
('21','保留使用','38','0','1','1'),
('22','保留使用','39','0','1','1'),
('23','保留使用','39','0','1','1'),
('24','保留使用','39','0','1','1');

INSERT INTO `youdian_language` VALUES
('1','中文','cn',NULL,'0','1'),
('2','英语','en',NULL,'1','1');

INSERT INTO `youdian_link` VALUES
('1','1','好搜','1','http://www.haosou.com','','2','','1','1'),
('4','1','搜狗搜索','2','http://www.sogou.com','/Upload/link/sogou.png','11','','1','1'),
('9','1','搜狐','1','http://www.sohu.com','','20','','1','1'),
('10','1','百度','1','http://www.baidu.com','','2','','1','1'),
('11','1','百度搜索','2','http://www.baidu.com','/Upload/link/baidu.gif','10','','1','1'),
('12','2','baidu','1','http://www.baidu.com','','0','','1','2'),
('13','2','google','1','http://www.google.com','','0','','1','2'),
('14','2','yahoo','1','http://www.yahoo.com','','0','','1','2'),
('15','2','sohu','1','http://www.sohu.com','','0','','1','2'),
('16','2','sina','1','http://www.sina.com.cn','','0','','1','2'),
('17','2','sogou','1','http://www.sogou.com','','0','','1','2'),
('18','2','CMS','1','http://www.youdiancms.com','','0','','1','2'),
('19','1','新浪','1','http://www.sina.com.cn','','0','','1','1'),
('20','1','搜狗','1','http://www.sogou.com/','','0','','1','1'),
('21','1','中国新闻网','1','http://www.chinanews.com/','','0','','1','1'),
('22','1','腾讯新闻','1','http://news.qq.com/','','0','','1','1'),
('24','1','中国日报','1','http://cn.chinadaily.com.cn/','','0','','1','1'),
('26','1','新浪网','2','http://www.sina.com.cn','/Upload/link/sina.png','12','','1','1'),
('27','1','雅虎','2','https://www.yahoo.com/','/Upload/link/yahoo.png','14','','1','1'),
('28','1','CMS','2','http://www.youdiancms.com','/Upload/link/qq.png','13','','1','1'),
('29','1','CMS','2','http://www.youdiancms.com/','/Upload/link/tom.png','15','','1','1'),
('30','1','网易','2','http://www.netease.com','/Upload/link/163.png','16','','1','1'),
('41','1','CMS系统','1','http://www.youdiancms.com','','1','','1','1'),
('32','2','baidu.com','2','http://www.baidu.com','/Upload/link/baidu.gif','0','','1','2'),
('33','2','sina.com.cn','2','http://www.sina.com.cn','/Upload/link/sina.png','0','','1','2'),
('34','2','sogou.com','2','http://www.sogou.com','/Upload/link/sogou.png','0','','1','2'),
('35','2','CMS WebSite','2','http://www.youdiancms.com/','/Upload/link/qq.png','0','','1','2'),
('36','2','163.com','2','http://www.163.com','/Upload/link/tom.png','0','','1','2'),
('37','2','netease.com','2','http://www.netease.com','/Upload/link/163.png','0','','1','2'),
('38','2','yahoo.com','2','http://www.yahoo.com','/Upload/link/yahoo.png','0','','1','2'),
('39','2','sohu.com','2','http://www.sohu.com','/Upload/link/sohu.png','0','','1','2'),
('40','2','china news','1','http://www.china.com.cn/','','0','','1','2');

INSERT INTO `youdian_link_class` VALUES
('1','默认分类','0','1'),
('2','default','0','2');

INSERT INTO `youdian_mail_class` VALUES
('1','默认分类','0','','1','1'),
('2','Default','0','','1','2');

INSERT INTO `youdian_member` VALUES
('1','1','admin','0','','1b6639881b53f660f5a9b6ba80fd7883','1989-09-22','','410000','xx@qq.com','400-699-1720','','','网站在哪个公司做的','','2015-06-10 09:57:11','192.168.1.40','2012-08-23 20:41:34','1','0','1','','','','','',NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,'0','0','','0','0',NULL,'','');

INSERT INTO `youdian_member_group` VALUES
('1','注册会员','1','9,10,11','15,16,17','63,65,67,145,79,89,130,132,143,142','15,17,18,19,55,20,21,22',NULL,'1','1'),
('2','微信游客','1','9,10,12,11','15,16,17','63,65,67,79,89','33,15,17,18,19,55,20,21,22,23,24,25,26,27,28,29',NULL,'1','1');

INSERT INTO `youdian_menu` VALUES
('5','1','数据库设置','Config/db','0','30',NULL,'0'),
('7','5','添加频道','Channel/add','0','1',NULL,'0'),
('8','5','频道管理','Channel/index','0','2',NULL,'1'),
('9','1','基本设置','Config/basic','0','1',NULL,'1'),
('10','9','留言设置','Config/guestbook','0','2',NULL,'0'),
('14','9','评论设置','Config/comment','0','6',NULL,'0'),
('16','7','在线客服设置','Config/online','0','3',NULL,'0'),
('17','19','搜索引擎优化设置','Config/seo','0','3',NULL,'1'),
('18','1','联系方式','Config/contact','0','2',NULL,'1'),
('19','1','文件上传设置','Config/upload','0','7',NULL,'1'),
('20','12','会员功能设置','Config/reg','0','5',NULL,'1'),
('24','2','邮件订阅分类管理','Mail/classindex','0','6',NULL,'1'),
('25','2','邮件群发管理','Mail/sendindex','0','0',NULL,'1'),
('26','2','订阅邮箱管理','Mail/index','0','5',NULL,'1'),
('27','2','网站安全提示','Public/welcome#c2','0','2',NULL,'0'),
('28','2','组件支持情况','Public/welcome#c4','0','4',NULL,'0'),
('32','4','添加专题','Special/add','0','1',NULL,'0'),
('33','5','专题管理','Special/index','0','2',NULL,'1'),
('34','7','添加在线客服','Support/add','0','1',NULL,'0'),
('35','7','在线客服管理','Support/index','0','2',NULL,'1'),
('37','6','添加幻灯片','Banner/add','0','1',NULL,'0'),
('38','11','幻灯片管理','Banner/index','0','2',NULL,'1'),
('39','7','第三方在线客服','Support/third','0','4',NULL,'1'),
('40','8','添加友情链接','Link/add','0','1',NULL,'0'),
('41','8','友情链接管理','Link/index','0','2',NULL,'1'),
('42','8','添加友情链接分类','Link/addclass','0','3',NULL,'0'),
('43','8','友情链接分类管理','Link/classindex','0','4',NULL,'1'),
('44','9','留言管理','Guestbook/index','0','1',NULL,'1'),
('45','9','人才招聘','Job/index','0','2',NULL,'1'),
('46','9','评论管理','Comment/index','0','6',NULL,'1'),
('47','9','发布招聘信息','Job/add','0','0',NULL,'0'),
('48','11','添加广告','Ad/add','0','1',NULL,'0'),
('49','11','广告内容管理','Ad/index','0','10',NULL,'1'),
('50','12','添加会员分组','MemberGroup/add','0','3',NULL,'0'),
('51','12','会员分组管理','MemberGroup/index','0','4',NULL,'1'),
('52','12','会员管理','Member/index','0','1',NULL,'1'),
('53','12','添加会员','Member/add','0','0',NULL,'0'),
('55','13','管理员管理','Admin/index','0','2',NULL,'1'),
('56','13','添加管理员分组','AdminGroup/add','0','3',NULL,'0'),
('57','13','管理员分组管理','AdminGroup/index','0','4',NULL,'1'),
('58','14','模板选择','Template/pick','0','1',NULL,'1'),
('59','14','模板管理','Template/index','0','2',NULL,'1'),
('60','14','样式管理','Template/style','0','3',NULL,'1'),
('61','1','水印设置','Config/water','0','6',NULL,'1'),
('62','3','内容频道',NULL,'3','0',NULL,'1'),
('63','15','我的个人资料','Member/modify','0','1',NULL,'1'),
('65','15','修改我的密码','Public/pwd','0','3',NULL,'1'),
('66','15','用户后台首页','Public/welcome','0','0',NULL,'0'),
('67','16','我的留言','Guestbook/index','0','1',NULL,'1'),
('68','16','我的评论','Comment/index','0','2',NULL,'1'),
('69','17','我发布的文章','Info/index','3','0',NULL,'1'),
('71','18','添加自定义标签','Tag/add','0','1',NULL,'0'),
('72','18','自定义标签管理','Tag/index','0','2',NULL,'1'),
('73','5','添加属性标记','Label/add','0','3',NULL,'0'),
('74','5','属性标记管理','Label/index','0','4',NULL,'0'),
('75','19','搜索引擎登录入口','SEO/searchenginelogin','0','10',NULL,'1'),
('76','19','伪静态设置','Config/core','0','0',NULL,'1'),
('77','9','订单设置','Config/order','0','4',NULL,'0'),
('78','26','订单管理','Order/index','0','3',NULL,'1'),
('79','16','我的订单','Order/index','0','3',NULL,'1'),
('80','18','数据库管理','Db/index','0','3',NULL,'1'),
('81','18','数据库还原','Db/restore','0','4',NULL,'1'),
('82','18','添加频道模型','ChannelModel/add','0','5',NULL,'0'),
('83','18','频道模型管理','ChannelModel/index','0','6',NULL,'1'),
('84','1','站长统计设置','Config/stat','0','15',NULL,'1'),
('85','1','百度分享设置','Config/baidushare','0','16',NULL,'1'),
('86','19','生成网站地图','SEO/sitemap','0','11',NULL,'1'),
('87','19','生成关键词内链','Config/autolink','0','12',NULL,'1'),
('88','10','应聘简历管理','Job/resume','0','3',NULL,'1'),
('89','16','我的应聘','Resume/index','0','3',NULL,'1'),
('90','6','添加幻灯分组','BannerGroup/add','0','3',NULL,'0'),
('91','11','幻灯分组管理','BannerGroup/index','0','4',NULL,'1'),
('92','12','会员模型管理','MemberModel/index','0','2',NULL,'0'),
('93','21','模板选择','WapTemplate/pick','0','1',NULL,'1'),
('94','21','模板管理','WapTemplate/index','0','2',NULL,'1'),
('95','21','样式管理','WapTemplate/style','0','3',NULL,'1'),
('96','18','一键备份全站','Db/backupall','0','7',NULL,'1'),
('97','1','其它设置','Config/other','0','50',NULL,'1'),
('98','1','缩略图设置','Config/thumb','0','17',NULL,'1'),
('99','1','手机网站设置','Config/wap','0','45',NULL,'1'),
('100','1','邮箱设置','Config/email','0','40',NULL,'1'),
('101','1','语言设置','Config/language','0','41',NULL,'1'),
('102','22','微信绑定设置','Wx/messageapi','0','1',NULL,'1'),
('103','22','自定义菜单设置','Wx/menu','0','5',NULL,'1'),
('104','23','关注自动回复','Wx/subscribereply','0','0',NULL,'1'),
('105','23','关键词自动回复','Wx/keywordreply','0','0',NULL,'1'),
('106','23','默认自动回复','Wx/defaultreply','0','10',NULL,'1'),
('107','22','凭证接口设置','Wx/credentialapi','0','3',NULL,'0'),
('108','22','微信公众平台登录','Wx/index','0','0',NULL,'0'),
('109','25','微消息','Wx/message','0','0',NULL,'1'),
('110','22','第三方接口','Wx/api','0','2',NULL,'0'),
('111','25','微活动','Wx/lottery','0','2',NULL,'1'),
('112','22','基本信息设置','Wx/basic','0','2',NULL,'1'),
('113','23','地理位置自动回复','Wx/lbsreply','0','8',NULL,'1'),
('114','25','微查询','Wx/query','0','1',NULL,'1'),
('115','25','微投票','Wx/vote','0','3',NULL,'1'),
('116','25','微会员卡','wx/card','0','4',NULL,'1'),
('117','25','微调查','wx/research','0','5',NULL,'1'),
('118','22','微信功能设置','Wx/config','0','6',NULL,'0'),
('119','14','模板设置','Template/config','0','4',NULL,'1'),
('120','21','模板设置','WapTemplate/config','0','4',NULL,'1'),
('121','18','操作日志管理','Log/index','0','10',NULL,'1'),
('122','31','数据采集','Collect/index','0','15',NULL,'1'),
('123','11','广告位管理','AdGroup/index','0','15',NULL,'1'),
('124','26','配送方式管理','Shipping/Index','0','5',NULL,'1'),
('125','26','支付方式管理','Pay/Index','0','6',NULL,'1'),
('126','1','第三方登录设置','Config/oauth','0','43',NULL,'1'),
('127','5','类型管理','Type/index','0','2',NULL,'1'),
('128','26','销售统计','Order/stat','0','8',NULL,'1'),
('129','18','网站目录权限检测','Public/dirDetection','0','12',NULL,'1'),
('130','16','我的收藏','Favorite/index','0','5',NULL,'1'),
('131','26','资金管理','Cash/index','0','10',NULL,'1'),
('132','16','我的资金','Cash/index','0','8',NULL,'1'),
('133','27','基本设置','App/config','0','5',NULL,'1'),
('134','28','用户反馈','App/feedback','0','10',NULL,'1'),
('135','29','安装统计','App/stat','0','15',NULL,'1'),
('136','27','关于我们设置','App/about','0','20',NULL,'1'),
('137','28','消息推送','App/addMessage','0','7',NULL,'1'),
('138','29','活跃度分析','App/active','0','25',NULL,'1'),
('139','27','通信秘钥管理','App/secret','0','25',NULL,'1'),
('140','22','小程序设置','Wx/xcxconfig','0','8',NULL,'1'),
('141','26','优惠券管理','Coupon/index','0','14',NULL,'1'),
('142','16','我的优惠券','Coupon/index','0','10',NULL,'1'),
('143','16','我的积分','Point/index','0','9',NULL,'1'),
('144','18','菜单管理','Menu/index','0','18',NULL,'0'),
('145','16','我的收货地址','Consignee/index','0','2',NULL,'1'),
('146','18','区域管理','Area/index','0','20',NULL,'1'),
('147','30','应用商店','Plugin/index','0','1',NULL,'1'),
('148','31','三级分销','Plugin/distribution','0','20',NULL,'1'),
('149','31','七牛云存储','Plugin/qiniu','0','21',NULL,'1'),
('150','19','百度自动推送','SEO/baidupush','0','14',NULL,'1'),
('151','31','邮件群发','Plugin/email','0','23',NULL,'1'),
('152','31','图像批量处理','Plugin/imageprocess','0','25',NULL,'1'),
('153','26','积分管理','Point/index','0','12',NULL,'1'),
('160','31','APP管理','Plugin/app','0','28',NULL,'1');

INSERT INTO `youdian_menu_group` VALUES
('1','1','系统设置','2','1'),
('2','5','邮件群发','2','0'),
('3','3','信息管理','10','1'),
('4','2','专题管理','2','0'),
('5','3','频道管理','1','1'),
('6','5','幻 灯 片','0','0'),
('7','4','在线客服','1','1'),
('8','5','友情链接','2','1'),
('9','4','其它','4','1'),
('10','4','人才招聘','3','0'),
('11','5','网站广告','1','1'),
('12','6','会员信息','1','1'),
('13','6','管理员信息','1','1'),
('14','7','电脑模板管理','1','1'),
('15','9','基本信息','1','1'),
('16','9','互动管理','1','1'),
('17','10','内容管理','1','1'),
('18','2','系统管理','0','1'),
('19','14','网站优化','0','1'),
('20','5','第三方脚本','1','0'),
('21','7','手机模板管理','2','1'),
('22','15','微信设置','0','1'),
('23','15','自动回复','0','1'),
('24','15','消息管理','0','0'),
('25','15','微信应用','0','1'),
('26','4','订单管理','2','1'),
('27','16','应用设置','1','1'),
('28','16','功能模块','5','1'),
('29','16','统计分析','10','1'),
('30','17','应用中心','1','1'),
('31','17','我的应用','3','1');

INSERT INTO `youdian_menu_operation` VALUES
('1','41','添加','add','Link','Admin','0','10','1'),
('2','41','删除','del','Link','Admin','0','3','1'),
('3','41','修改','modify','Link','Admin','0','11','1'),
('4','41','排序','batchsort','Link','Admin','0','5','1'),
('5','41','查看','index','Link','Admin','0','9','1'),
('6','41','保存添加','saveadd','Link','Admin','0','2','1'),
('7','41','批量删除','batchdel','Link','Admin','0','3','1'),
('8','41','保存修改','savemodify','Link','Admin','0','4','1'),
('9','43','查看分类','classindex','Link','Admin','0','9','1'),
('10','43','添加分类','addclass','Link','Admin','0','10','1'),
('11','43','保存添加分类','saveaddclass','Link','Admin','0','2','1'),
('12','43','删除分类','delclass','Link','Admin','0','3','1'),
('13','43','批量删除分类','batchdelclass','Link','Admin','0','3','1'),
('14','43','分类排序','batchsortclass','Link','Admin','0','5','1'),
('15','43','修改分类','modifyclass','Link','Admin','0','11','1'),
('16','43','保存修改分类','savemodifyclass','Link','Admin','0','4','1'),
('17','49','查看','index','Ad','Admin','0','9','1'),
('18','49','添加','add','Ad','Admin','0','10','1'),
('19','49','保存添加','saveadd','Ad','Admin','0','2','1'),
('20','49','删除','del','Ad','Admin','0','3','1'),
('21','49','批量删除','batchdel','Ad','Admin','0','3','1'),
('22','49','修改','modify','Ad','Admin','0','11','1'),
('23','49','保存修改','savemodify','Ad','Admin','0','4','1'),
('24','55','查看','index','Admin','Admin','0','9','1'),
('25','55','添加','add','Admin','Admin','0','10','1'),
('26','55','保存添加','saveadd','Admin','Admin','0','2','1'),
('27','55','删除','del','Admin','Admin','0','3','1'),
('28','55','批量删除','batchdel','Admin','Admin','0','3','1'),
('29','55','锁定','batchlock','Admin','Admin','0','1','1'),
('30','55','修改密码','batchmodifypwd','Admin','Admin','0','1','1'),
('31','55','修改','modify','Admin','Admin','0','11','1'),
('32','55','保存修改','savemodify','Admin','Admin','0','4','1'),
('33','57','查看','index','AdminGroup','Admin','0','9','1'),
('34','57','添加','add','AdminGroup','Admin','0','10','1'),
('35','57','保存添加','saveadd','AdminGroup','Admin','0','2','1'),
('36','57','删除','del','AdminGroup','Admin','0','3','1'),
('37','57','批量删除','batchdel','AdminGroup','Admin','0','3','1'),
('38','57','修改','modify','AdminGroup','Admin','0','11','1'),
('39','57','保存修改','savemodify','AdminGroup','Admin','0','4','1'),
('40','38','查看','index','Banner','Admin','0','9','1'),
('41','38','添加','add','Banner','Admin','0','10','1'),
('42','38','保存添加','saveadd','Banner','Admin','0','2','1'),
('43','38','排序','batchsort','Banner','Admin','0','5','1'),
('44','38','删除','del','Banner','Admin','0','3','1'),
('45','38','批量删除','batchdel','Banner','Admin','0','3','1'),
('46','38','修改','modify','Banner','Admin','0','11','1'),
('47','38','保存修改','savemodify','Banner','Admin','0','4','1'),
('48','91','查看','index','BannerGroup','Admin','0','9','1'),
('49','91','添加','add','BannerGroup','Admin','0','10','1'),
('50','91','保存添加','saveadd','BannerGroup','Admin','0','2','1'),
('51','91','排序','batchsort','BannerGroup','Admin','0','5','1'),
('52','91','删除','del','BannerGroup','Admin','0','3','1'),
('53','91','批量删除','batchdel','BannerGroup','Admin','0','3','1'),
('54','91','修改','modify','BannerGroup','Admin','0','11','1'),
('55','91','保存修改','savemodify','BannerGroup','Admin','0','4','1'),
('56','8','查看','index','Channel','Admin','0','9','1'),
('57','8','链接频道查看','link','Channel','Admin','0','9','1'),
('58','8','单页频道查看','single','Channel','Admin','0','9','1'),
('59','8','添加','add','Channel','Admin','0','10','1'),
('60','8','保存添加','saveadd','Channel','Admin','0','2','1'),
('61','8','批量添加','batchadd','Channel','Admin','0','10','1'),
('62','8','保存批量添加','savebatchadd','Channel','Admin','0','2','1'),
('63','8','保存所有','saveall','Channel','Admin','0','4','1'),
('64','8','删除','del','Channel','Admin','0','3','1'),
('65','8','删除频道缓存','clearCache','Channel','Admin','0','7','1'),
('66','8','修改','modify','Channel','Admin','0','11','1'),
('67','8','保存修改','savemodify','Channel','Admin','0','4','1'),
('68','8','查看属性标记','index','Label','Admin','0','9','1'),
('69','8','添加属性标记','add','Label','Admin','0','10','1'),
('70','8','保存添加属性标记','saveadd','Label','Admin','0','2','1'),
('71','8','删除属性标记','del','Label','Admin','0','3','1'),
('72','8','批量删除属性标记','batchdel','Label','Admin','0','3','1'),
('73','8','属性标记排序','batchsort','Label','Admin','0','5','1'),
('74','8','修改属性标记','modify','Label','Admin','0','11','1'),
('75','8','保存修改属性标记','savemodify','Label','Admin','0','4','1'),
('76','83','添加','add','ChannelModel','Admin','0','10','1'),
('77','83','排序','batchsort','ChannelModel','Admin','0','5','1'),
('78','83','字段排序','batchsortfield','ChannelModel','Admin','0','5','1'),
('79','83','清除缓存','clearcache','ChannelModel','Admin','0','7','1'),
('80','83','删除','del','ChannelModel','Admin','0','3','1'),
('81','83','查看','index','ChannelModel','Admin','0','9','1'),
('82','83','修改','modify','ChannelModel','Admin','0','11','1'),
('83','83','修改字段','modifyfield','ChannelModel','Admin','0','11','1'),
('84','83','保存添加','saveadd','ChannelModel','Admin','0','2','1'),
('85','83','保存修改字段','savemodifyfield','ChannelModel','Admin','0','4','1'),
('86','83','查看字段','viewfield','ChannelModel','Admin','0','9','1'),
('87','83','保存修改','savemodify','ChannelModel','Admin','0','4','1'),
('88','122','添加','add','Collect','Admin','0','10','1'),
('89','122','采集内容','collectcontent','Collect','Admin','0','1','1'),
('90','122','采集列表地址','collectlist','Collect','Admin','0','1','1'),
('91','122','删除','del','Collect','Admin','0','3','1'),
('92','122','查看','index','Collect','Admin','0','9','1'),
('93','122','修改','modify','Collect','Admin','0','11','1'),
('94','122','保存添加','saveadd','Collect','Admin','0','2','1'),
('95','122','保存修改','savemodify','Collect','Admin','0','4','1'),
('96','122','开始采集数据','start','Collect','Admin','0','1','1'),
('97','122','测试采集字段数据','testfield','Collect','Admin','0','1','1'),
('98','46','审核','batchcheck','Comment','Admin','0','1','1'),
('99','46','批量删除','batchdel','Comment','Admin','0','3','1'),
('100','46','删除','del','Comment','Admin','0','3','1'),
('101','46','查看','index','Comment','Admin','0','9','1'),
('102','46','保存修改','savecomment','Config','Admin','0','4','1'),
('103','46','查看','comment','Config','Admin','0','9','1'),
('104','80','查看','index','Db','Admin','0','9','1'),
('105','80','备份','backup','Db','Admin','0','1','1'),
('106','80','分析','analyze','Db','Admin','0','1','1'),
('107','80','检查','check','Db','Admin','0','1','1'),
('108','80','优化','optimize','Db','Admin','0','1','1'),
('109','80','修复','repair','Db','Admin','0','1','1'),
('110','80','查看字段','columns','Db','Admin','0','9','1'),
('111','81','查看','restore','Db','Admin','0','9','1'),
('112','81','备份','backup','Db','Admin','0','1','1'),
('113','81','删除','delsqlfile','Db','Admin','0','3','1'),
('114','81','批量删除','batchdelsqlfile','Db','Admin','0','3','1'),
('115','81','还原','recover','Db','Admin','0','1','1'),
('116','81','查看SQL内容','viewsqlfile','Db','Admin','0','9','1'),
('117','96','查看','backupall','Db','Admin','0','9','1'),
('118','96','删除备份文件','delzip','Db','Admin','0','3','1'),
('119','96','一键备份全站','dobackupall','Db','Admin','0','1','1'),
('120','96','备份数据库','backupdata','Db','Admin','0','1','1'),
('121','9','查看','basic','Config','Admin','0','9','1'),
('122','9','保存修改','savebasic','Config','Admin','0','4','1'),
('123','18','查看','contact','Config','Admin','0','9','1'),
('124','18','保存修改','savecontact','Config','Admin','0','4','1'),
('125','61','查看','water','Config','Admin','0','9','1'),
('126','61','保存修改','savewater','Config','Admin','0','4','1'),
('127','19','查看','upload','Config','Admin','0','9','1'),
('128','19','保存修改','saveupload','Config','Admin','0','4','1'),
('129','84','查看','stat','Config','Admin','0','9','1'),
('130','84','保存修改','savestat','Config','Admin','0','4','1'),
('131','85','查看','baidushare','Config','Admin','0','9','1'),
('132','85','保存修改','savebaidushare','Config','Admin','0','4','1'),
('133','98','查看','thumb','Config','Admin','0','9','1'),
('134','98','保存修改','savethumb','Config','Admin','0','4','1'),
('135','5','查看','db','Config','Admin','0','9','1'),
('136','5','保存修改','savedb','Config','Admin','0','4','1'),
('137','100','查看','email','Config','Admin','0','9','1'),
('138','100','保存修改','saveemail','Config','Admin','0','4','1'),
('139','101','查看','language','Config','Admin','0','9','1'),
('140','101','保存修改','savelanguage','Config','Admin','0','4','1'),
('141','97','查看','other','Config','Admin','0','9','1'),
('142','97','保存修改','saveother','Config','Admin','0','4','1'),
('143','99','查看','wap','Config','Admin','0','9','1'),
('144','99','保存修改','savewap','Config','Admin','0','4','1'),
('145','44','回复留言','answermessage','Guestbook','Admin','0','2','1'),
('146','44','批量删除','batchdelmessage','Guestbook','Admin','0','3','1'),
('147','44','删除','delmessage','Guestbook','Admin','0','3','1'),
('148','44','审核/取消审核','batchcheckmessage','Guestbook','Admin','0','1','1'),
('149','44','查看','index','Guestbook','Admin','0','9','1'),
('150','44','导出','exportmessage','Guestbook','Admin','0','6','1'),
('151','44','设置','guestbook','Config','Admin','0','11','1'),
('152','44','保存修改','saveguestbook','Config','Admin','0','4','1'),
('153','45','发布招聘信息','add','Job','Admin','0','10','1'),
('154','45','批量删除','batchdel','Job','Admin','0','3','1'),
('155','45','批量删除简历','batchdelresume','Job','Admin','0','3','1'),
('156','45','排序','batchsort','Job','Admin','0','5','1'),
('157','45','删除','del','Job','Admin','0','3','1'),
('158','45','删除简历','delresume','Job','Admin','0','3','1'),
('159','45','查看','index','Job','Admin','0','9','1'),
('160','45','修改','modify','Job','Admin','0','11','1'),
('161','45','应聘简历','resume','Job','Admin','0','1','1'),
('162','45','应聘简历详情','viewresume','Job','Admin','0','1','1'),
('163','45','保存添加','saveadd','Job','Admin','0','2','1'),
('164','45','保存修改','savemodify','Job','Admin','0','4','1'),
('165','121','设置','config','Log','Admin','0','1','1'),
('166','121','删除','del','Log','Admin','0','3','1'),
('167','121','清除所有日志','delall','Log','Admin','0','3','1'),
('168','121','获取地理位置','getlocation','Log','Admin','0','3','1'),
('169','121','查看','index','Log','Admin','0','9','1'),
('170','121','保存设置','saveconfig','Log','Admin','0','4','1'),
('171','25','查看','sendindex','Mail','Admin','0','9','1'),
('172','25','添加','addsend','Mail','Admin','0','10','1'),
('173','25','保存添加','saveaddsend','Mail','Admin','0','2','1'),
('174','25','删除','delsend','Mail','Admin','0','3','1'),
('175','25','批量删除','batchdelsend','Mail','Admin','0','3','1'),
('176','25','修改','modifysend','Mail','Admin','0','11','1'),
('177','25','保存修改','savemodifysend','Mail','Admin','0','4','1'),
('178','26','添加','add','Mail','Admin','0','10','1'),
('179','26','批量删除','batchdel','Mail','Admin','0','3','1'),
('180','26','删除','del','Mail','Admin','0','3','1'),
('181','26','查看','index','Mail','Admin','0','9','1'),
('182','26','修改','modify','Mail','Admin','0','11','1'),
('183','26','保存添加','saveadd','Mail','Admin','0','2','1'),
('184','26','保存修改','savemodify','Mail','Admin','0','4','1'),
('185','24','添加','addclass','Mail','Admin','0','10','1'),
('186','24','批量删除','batchdelclass','Mail','Admin','0','3','1'),
('187','24','排序','batchsortclass','Mail','Admin','0','5','1'),
('188','24','删除','delclass','Mail','Admin','0','3','1'),
('189','24','查看','classindex','Mail','Admin','0','9','1'),
('190','24','修改','modifyclass','Mail','Admin','0','11','1'),
('191','24','导入查看','import','Mail','Admin','0','9','1'),
('192','24','导入','startimport','Mail','Admin','0','6','1'),
('193','24','导出','exportmail','Mail','Admin','0','6','1'),
('194','24','保存添加','saveaddclass','Mail','Admin','0','2','1'),
('195','24','保存修改','savemodifyclass','Mail','Admin','0','4','1'),
('196','52','添加','add','Member','Admin','0','10','1'),
('197','52','审核/取消审核','batchcheck','Member','Admin','0','1','1'),
('198','52','批量删除','batchdel','Member','Admin','0','3','1'),
('199','52','锁定/取消锁定','batchlock','Member','Admin','0','1','1'),
('200','52','修改密码','batchmodifypwd','Member','Admin','0','1','1'),
('201','52','删除','del','Member','Admin','0','3','1'),
('202','52','导出','export','Member','Admin','0','6','1'),
('203','52','查看','index','Member','Admin','0','9','1'),
('204','52','修改','modify','Member','Admin','0','11','1'),
('205','52','保存添加','saveadd','Member','Admin','0','2','1'),
('206','52','保存修改','savemodify','Member','Admin','0','4','1'),
('207','52','设置管理员','setadmin','Member','Admin','0','1','1'),
('208','52','代管','take','Member','Admin','0','1','1'),
('209','51','添加','add','MemberGroup','Admin','0','10','1'),
('210','51','批量删除','batchdel','MemberGroup','Admin','0','3','1'),
('211','51','删除','del','MemberGroup','Admin','0','3','1'),
('212','51','查看','index','MemberGroup','Admin','0','9','1'),
('213','51','修改','modify','MemberGroup','Admin','0','11','1'),
('214','51','保存添加','saveadd','MemberGroup','Admin','0','2','1'),
('215','51','保存修改','savemodify','MemberGroup','Admin','0','4','1'),
('216','20','添加','reg','Config','Admin','0','9','1'),
('217','20','保存修改','savereg','Config','Admin','0','4','1'),
('218','78','修改','modify','Order','Admin','0','10','1'),
('219','78','保存修改','savemodify','Order','Admin','0','4','1'),
('220','78','删除','delorder','Order','Admin','0','3','1'),
('221','78','查看','index','Order','Admin','0','9','1'),
('222','78','导出','export','Order','Admin','0','6','1'),
('223','78','设置','order','Config','Admin','0','11','1'),
('224','78','保存设置','saveorder','Config','Admin','0','4','1'),
('225','17','查看','seo','Config','Admin','0','9','1'),
('226','17','保存设置','saveseo','Config','Admin','0','4','1'),
('227','33','添加','add','Special','Admin','0','10','1'),
('228','33','删除','del','Special','Admin','0','3','1'),
('229','33','查看','index','Special','Admin','0','9','1'),
('230','33','修改','modify','Special','Admin','0','11','1'),
('231','33','保存所有','saveall','Special','Admin','0','2','1'),
('232','33','保存添加','saveadd','Special','Admin','0','2','1'),
('233','33','保存修改','savemodify','Special','Admin','0','4','1'),
('234','35','添加','add','Support','Admin','0','10','1'),
('235','35','批量删除','batchdel','Support','Admin','0','3','1'),
('236','35','排序','batchsort','Support','Admin','0','5','1'),
('237','35','删除','del','Support','Admin','0','3','1'),
('238','35','查看','index','Support','Admin','0','9','1'),
('239','35','修改','modify','Support','Admin','0','11','1'),
('240','35','保存添加','saveadd','Support','Admin','0','2','1'),
('241','35','保存修改','savemodify','Support','Admin','0','4','1'),
('242','35','设置','online','Config','Admin','0','11','1'),
('243','35','保存修改','saveonline','Config','Admin','0','4','1'),
('244','39','查看','third','Support','Admin','0','9','1'),
('245','39','保存添加','addthird','Support','Admin','0','2','1'),
('246','39','保存修改','savethird','Support','Admin','0','4','1'),
('247','72','添加','add','Tag','Admin','0','10','1'),
('248','72','批量删除','batchdel','Tag','Admin','0','3','1'),
('249','72','删除','del','Tag','Admin','0','3','1'),
('250','72','查看','index','Tag','Admin','0','9','1'),
('251','72','修改','modify','Tag','Admin','0','11','1'),
('252','72','保存添加','saveadd','Tag','Admin','0','2','1'),
('253','72','保存修改','savemodify','Tag','Admin','0','4','1'),
('268','58','查看模板切换','pick','Template','Admin','0','9','1'),
('269','58','保存模板切换','savepick','Template','Admin','0','4','1'),
('270','58','备份模板','backup','Template','Admin','0','1','1'),
('271','58','删除模板','del','Template','Admin','0','3','1'),
('272','58','语言包','lang','Template','Admin','0','1','1'),
('273','58','保存语言包','savelang','Template','Admin','0','4','1'),
('274','59','查看模板管理','index','Template','Admin','0','9','1'),
('275','59','修改模板文件','modify','Template','Admin','0','11','1'),
('276','59','保存模板文件修改','savemodify','Template','Admin','0','4','1'),
('278','59','保存样式修改','savemodifystyle','Template','Admin','0','4','1'),
('279','60','查看样式管理','style','Template','Admin','0','9','1'),
('292','60','修改样式','modifystyle','Template','Admin','0','11','1'),
('293','60','保存样式修改','savemodifystyle','Template','Admin','0','4','1'),
('294','119','模板设置','config','Template','Admin','0','9','1'),
('295','119','保存模板设置','saveconfig','Template','Admin','0','4','1'),
('296','93','查看模板切换','pick','WapTemplate','Admin','0','9','1'),
('297','93','保存模板切换','savepick','WapTemplate','Admin','0','4','1'),
('298','93','备份模板','backup','WapTemplate','Admin','0','1','1'),
('299','93','删除模板','del','WapTemplate','Admin','0','3','1'),
('300','93','语言包','lang','WapTemplate','Admin','0','1','1'),
('301','93','保存语言包','savelang','WapTemplate','Admin','0','4','1'),
('302','94','查看模板管理','index','WapTemplate','Admin','0','9','1'),
('303','94','修改模板文件','modify','WapTemplate','Admin','0','11','1'),
('304','94','保存模板文件修改','savemodify','WapTemplate','Admin','0','4','1'),
('306','94','保存样式修改','savemodifystyle','WapTemplate','Admin','0','4','1'),
('307','95','查看样式管理','style','WapTemplate','Admin','0','9','1'),
('308','95','修改样式','modifystyle','WapTemplate','Admin','0','11','1'),
('309','95','保存样式修改','savemodifystyle','WapTemplate','Admin','0','4','1'),
('310','120','模板设置','config','WapTemplate','Admin','0','9','1'),
('311','120','保存模板设置','saveconfig','WapTemplate','Admin','0','4','1'),
('312','102','微信绑定设置','messageapi','Wx','Admin','0','9','1'),
('313','102','保存微信绑定设置','savemessageapi','Wx','Admin','0','4','1'),
('314','112','基本信息设置','basic','Wx','Admin','0','9','1'),
('315','112','保存基本信息设置','savebasic','Wx','Admin','0','4','1'),
('316','103','同步菜单到微信','updatemenu','Wx','Admin','0','1','1'),
('317','103','清除微信菜单','clearmenu','Wx','Admin','0','1','1'),
('318','103','查看','menu','Wx','Admin','0','9','1'),
('319','103','添加','addmenu','Wx','Admin','0','10','1'),
('320','103','保存添加','saveaddmenu','Wx','Admin','0','2','1'),
('321','103','修改','modifymenu','Wx','Admin','0','11','1'),
('322','103','保存修改','savemodifymenu','Wx','Admin','0','4','1'),
('323','103','删除','menu','Wx','Admin','0','3','1'),
('324','103','保存所有','savemodifymenu','Wx','Admin','0','4','1'),
('325','118','排序','batchsortmenu','Wx','Admin','0','5','1'),
('326','118','查看','config','Wx','Admin','0','9','1'),
('327','118','显示/隐藏','savemodifymenu','Wx','Admin','0','1','1'),
('328','104','查看','subscribereply','Wx','Admin','0','9','1'),
('329','104','保存修改','savesubscribereply','Wx','Admin','0','4','1'),
('336','105','查看','keywordreply','Wx','Admin','0','9','1'),
('337','105','删除','delkeywordreply','Wx','Admin','0','3','1'),
('338','105','批量删除','batchdelkeywordreply','Wx','Admin','0','3','1'),
('339','105','排序','batchsortkeywordreply','Wx','Admin','0','5','1'),
('340','105','修改','modifykeywordreply','Wx','Admin','0','11','1'),
('341','105','保存修改','savemodifykeywordreply','Wx','Admin','0','4','1'),
('342','105','使用次数清零','zerokeywordcount','Wx','Admin','0','1','1'),
('343','105','添加','addkeywordreply','Wx','Admin','0','10','1'),
('344','105','保存添加','saveaddkeywordreply','Wx','Admin','0','2','1'),
('345','113','查看','lbsreply','Wx','Admin','0','9','1'),
('346','113','保存修改','savelbsreply','Wx','Admin','0','4','1'),
('347','106','查看','defaultreply','Wx','Admin','0','9','1'),
('348','106','保存修改','savedefaultreply','Wx','Admin','0','4','1'),
('349','109','查看','message','Wx','Admin','0','9','1'),
('350','109','删除','delallmessage','Wx','Admin','0','3','1'),
('351','109','批量删除','batchdelmessage','Wx','Admin','0','3','1'),
('352','109','导出','exportmessage','Wx','Admin','0','6','1'),
('353','114','查看','query','Wx','Admin','0','9','1'),
('354','111','查看','lottery','Wx','Admin','0','9','1'),
('355','111','查看中奖用户','award','Wx','Admin','0','1','1'),
('356','111','确认/取消领奖','checkaward','Wx','Admin','0','1','1'),
('357','111','删除','dellottery','Wx','Admin','0','3','1'),
('358','111','清除抽奖数据','clearlottery','Wx','Admin','0','3','1'),
('359','111','批量删除','batchdellottery','Wx','Admin','0','3','1'),
('360','111','添加','addlottery','Wx','Admin','0','10','1'),
('361','111','保存添加','saveaddlottery','Wx','Admin','0','2','1'),
('362','111','修改','modifylottery','Wx','Admin','0','11','1'),
('363','111','保存修改','savemodifylottery','Wx','Admin','0','4','1'),
('364','111','排序','batchsortlottery','Wx','Admin','0','5','1'),
('365','115','添加','addvote','Wx','Admin','0','10','1'),
('366','115','批量删除','batchdelvote','Wx','Admin','0','3','1'),
('367','115','排序','batchsortvote','Wx','Admin','0','5','1'),
('368','115','清空投票记录','clearvote','Wx','Admin','0','3','1'),
('369','115','删除','delvote','Wx','Admin','0','3','1'),
('370','115','查看','vote','Wx','Admin','0','9','1'),
('371','115','修改','modifyvote','Wx','Admin','0','11','1'),
('372','115','保存添加','saveaddvote','Wx','Admin','0','2','1'),
('373','115','保存修改','savemodifyvote','Wx','Admin','0','4','1'),
('374','117','查看','research','Wx','Admin','0','9','1'),
('375','117','添加','addresearch','Wx','Admin','0','10','1'),
('376','117','保存添加','saveresearchadd','Wx','Admin','0','2','1'),
('377','117','修改','modifyresearch','Wx','Admin','0','11','1'),
('378','117','保存修改','savemodifyresearch','Wx','Admin','0','4','1'),
('379','117','批量删除','batchdelresearch','Wx','Admin','0','3','1'),
('380','117','删除','delresearch','Wx','Admin','0','3','1'),
('381','117','清除调查数据','clearresearchdata','Wx','Admin','0','3','1'),
('382','117','无刷新清除调查数据','clearresearch','Wx','Admin','0','3','1'),
('383','117','查看设置调查问题','question','Wx','Admin','0','11','1'),
('384','117','导出调查结果','exportquestion','Wx','Admin','0','6','1'),
('385','117','添加调查问题','addquestion','Wx','Admin','0','10','1'),
('386','117','保存添加调查问题','savequestionadd','Wx','Admin','0','2','1'),
('387','117','修改调查问题','modifyquestion','Wx','Admin','0','11','1'),
('388','117','保存修改调查问题','savemodifyquestion','Wx','Admin','0','4','1'),
('389','117','批量删除调查问题','batchdelquestion','Wx','Admin','0','3','1'),
('390','117','删除调查问题','delquestion','Wx','Admin','0','3','1'),
('391','117','调查问题排序','sortquestion','Wx','Admin','0','5','1'),
('392','117','查看用户建议','suggest','Wx','Admin','0','11','1'),
('393','117','导出用户建议','exportsuggest','Wx','Admin','0','6','1'),
('394','116','查看会员卡','card','Wx','Admin','0','9','1'),
('395','116','会员卡设置','cardconfig','Wx','Admin','0','11','1'),
('396','116','保存会员卡设置','updatecardconfig','Wx','Admin','0','4','1'),
('397','116','会员卡充值','pay','Wx','Admin','0','1','1'),
('398','116','赠送积分','givescore','Wx','Admin','0','1','1'),
('399','116','批量冻结','batchlock','Wx','Admin','0','1','1'),
('400','116','导出所有会员','export','Wx','Admin','0','6','1'),
('401','116','查看消费记录','consume','Wx','Admin','0','11','1'),
('402','116','消费金额','expense','Wx','Admin','0','1','1'),
('403','116','查看积分记录','score','Wx','Admin','0','11','1'),
('404','116','查看礼品券','gift','Wx','Admin','0','11','1'),
('405','116','兑换礼品券会员','giftmember','Wx','Admin','0','11','1'),
('406','116','添加礼品券','addgift','Wx','Admin','0','10','1'),
('407','116','保存添加礼品券','savegiftadd','Wx','Admin','0','2','1'),
('408','116','修改礼品券','modifygift','Wx','Admin','0','11','1'),
('409','116','保存修改礼品券','savemodifygift','Wx','Admin','0','4','1'),
('410','116','删除礼品券','delgift','Wx','Admin','0','3','1'),
('411','116','礼品券排序','batchsortgift','Wx','Admin','0','5','1'),
('412','116','查看会员通知','notify','Wx','Admin','0','11','1'),
('413','116','发布会员通知','addnotify','Wx','Admin','0','10','1'),
('414','116','保存发布会员通知','savenotifyadd','Wx','Admin','0','2','1'),
('415','116','修改会员通知','modifynotify','Wx','Admin','0','11','1'),
('416','116','保存修改会员通知','savemodifynotify','Wx','Admin','0','4','1'),
('417','116','删除会员通知','delnotify','Wx','Admin','0','3','1'),
('418','116','查看优惠卷','coupon','Wx','Admin','0','11','1'),
('419','116','兑换优惠卷会员','couponmember','Wx','Admin','0','11','1'),
('420','116','添加优惠卷','addcoupon','Wx','Admin','0','10','1'),
('421','116','保存添加优惠卷','savecouponadd','Wx','Admin','0','2','1'),
('422','116','修改优惠卷','modifycoupon','Wx','Admin','0','11','1'),
('423','116','保存修改优惠卷','savemodifycoupon','Wx','Admin','0','4','1'),
('424','116','删除优惠卷','delcoupon','Wx','Admin','0','3','1'),
('425','116','优惠卷排序','batchsortcoupon','Wx','Admin','0','5','1'),
('426','63','查看','modify','Member','Member','0','9','1'),
('427','63','保存修改','savemodify','Member','Member','0','4','1'),
('428','67','批量删除','batchdelmessage','Guestbook','Member','0','3','1'),
('429','67','删除','delmessage','Guestbook','Member','0','3','1'),
('430','67','查看','index','Guestbook','Member','0','9','1'),
('431','79','批量删除','batchdelorder','Order','Member','0','3','1'),
('432','79','详情','view','Order','Member','0','9','1'),
('433','79','查看','index','Order','Member','0','9','1'),
('434','89','修改','modify','Resume','Member','0','11','1'),
('435','89','保存修改','savemodify','Resume','Member','0','4','1'),
('436','89','批量删除','batchdelresume','Resume','Member','0','3','1'),
('437','89','删除','delresume','Resume','Member','0','3','1'),
('438','89','查看','index','Resume','Member','0','9','1'),
('439','68','批量删除','batchdel','Comment','Member','0','3','1'),
('440','68','删除','del','Comment','Member','0','3','1'),
('441','68','查看','index','Comment','Member','0','9','1'),
('442','76','查看','core','Config','Admin','0','9','1'),
('443','76','保存修改','savecore','Config','Admin','0','4','1'),
('444','75','查看','searchenginelogin','Seo','Admin','0','9','1'),
('445','86','查看','sitemap','Seo','Admin','0','9','1'),
('446','86','生成网站地图','makesitemap','Seo','Admin','0','1','1'),
('447','86','删除网站地图','delsitemap','Seo','Admin','0','3','1'),
('448','87','查看','autolink','Config','Admin','0','9','1'),
('449','87','保存修改','saveautolink','Config','Admin','0','4','1'),
('451','123','添加','add','AdGroup','Admin','0','10','1'),
('452','123','删除','del','AdGroup','Admin','0','3','1'),
('453','123','查看','index','AdGroup','Admin','0','9','1'),
('454','123','修改','modify','AdGroup','Admin','0','11','1'),
('455','123','保存添加','saveadd','AdGroup','Admin','0','2','1'),
('456','123','保存修改','savemodify','AdGroup','Admin','0','4','1'),
('457','49','排序','sort','Ad','Admin','0','5','1'),
('458','25','群发当前邮件','send','Mail','Admin','0','1','1'),
('459','25','开始邮件群发','startsend','Mail','Admin','0','1','1'),
('460','25','查看邮件群发日志','viewlog','Mail','Admin','0','1','1'),
('461','86','保存网站地图设置','savesitemap','Seo','Admin','0','4','1'),
('462','78','查看日志','orderlog','Order','Admin','0','9','1'),
('463','78','修改日志','modifyorderlog','Order','Admin','0','11','1'),
('464','78','保存修改日志','savemodifyorderlog','Order','Admin','0','4','1'),
('465','78','删除日志','delorderlog','Order','Admin','0','3','1'),
('466','78','设置状态','setstatus','Order','Admin','0','1','1'),
('467','124','查看','index','Shipping','Admin','0','9','1'),
('468','124','添加','add','Shipping','Admin','0','10','1'),
('469','124','修改','modify','Shipping','Admin','0','11','1'),
('470','124','保存修改','savemodify','Shipping','Admin','0','4','1'),
('471','124','保存添加','saveadd','Shipping','Admin','0','2','1'),
('472','124','删除','del','Shipping','Admin','0','3','1'),
('473','124','排序','sort','Shipping','Admin','0','5','1'),
('474','125','查看','index','Pay','Admin','0','9','1'),
('475','125','添加','add','Pay','Admin','0','10','1'),
('476','125','修改','modify','Pay','Admin','0','11','1'),
('477','125','保存修改','savemodify','Pay','Admin','0','4','1'),
('478','125','保存添加','saveadd','Pay','Admin','0','2','1'),
('479','125','删除','del','Pay','Admin','0','3','1'),
('480','125','排序','sort','Pay','Admin','0','5','1'),
('481','126','查看','oauth','Config','Admin','0','9','1'),
('482','126','保存修改','saveoauth','Config','Admin','0','4','1'),
('483','80','批量执行SQL语句','sql','Db','Admin','0','11','1'),
('484','80','批量执行SQL语句','executesql','Db','Admin','0','1','1'),
('485','127','查看','index','Type','Admin','0','9','1'),
('486','127','添加','add','Type','Admin','0','10','1'),
('487','127','修改','modify','Type','Admin','0','11','1'),
('488','127','保存修改','savemodify','Type','Admin','0','4','1'),
('489','127','保存添加','saveadd','Type','Admin','0','2','1'),
('490','127','排序','sort','Type','Admin','0','5','1'),
('491','127','删除','del','Type','Admin','0','3','1'),
('492','127','属性分组管理','group','Type','Admin','0','1','1'),
('493','127','添加属性分组','addgroup','Type','Admin','0','10','1'),
('494','127','修改属性分组','modifygroup','Type','Admin','0','11','1'),
('495','127','保存属性分组修改','savemodifygroup','Type','Admin','0','4','1'),
('496','127','保存属性分组添加','saveaddgroup','Type','Admin','0','2','1'),
('497','127','属性分组排序','sortgroup','Type','Admin','0','5','1'),
('498','127','删除属性分组','delgroup','Type','Admin','0','3','1'),
('499','127','属性列表管理','attribute','Type','Admin','0','1','1'),
('500','127','添加属性','addattribute','Type','Admin','0','10','1'),
('501','127','修改属性','modifyattribute','Type','Admin','0','11','1'),
('502','127','保存属性修改','savemodifyattribute','Type','Admin','0','4','1'),
('503','127','保存属性添加','saveaddattribute','Type','Admin','0','2','1'),
('504','127','属性排序','sortattribute','Type','Admin','0','5','1'),
('505','127','删除属性','delattribute','Type','Admin','0','3','1'),
('506','128','销售统计','stat','Order','Admin','0','9','1'),
('507','129','网站目录权限检测','dirDetection','Public','Admin','0','9','1'),
('508','46','评论回复','reply','Comment','Admin','0','2','1'),
('509','131','资金管理','index','Cash','Admin','0','9','1'),
('510','131','修改','modify','Cash','Admin','0','11','1'),
('511','131','保存修改','savemodify','Cash','Admin','0','4','1'),
('512','131','删除','del','Cash','Admin','0','3','1'),
('513','131','给会员转电子币','transfer','Cash','Admin','0','2','1'),
('514','133','查看','config','App','Admin','0','9','1'),
('515','133','保存App基本设置','saveConfig','App','Admin','0','4','1'),
('516','136','查看','about','App','Admin','0','9','1'),
('517','136','保存修改','saveAbout','App','Admin','0','4','1'),
('518','139','查看','secret','App','Admin','0','9','1'),
('519','139','创建','addSecret','App','Admin','0','10','1'),
('520','139','修改','modifySecret','App','Admin','0','11','1'),
('521','139','保存修改','saveModifySecret','App','Admin','0','4','1'),
('522','139','保存创建','saveAddSecret','App','Admin','0','2','1'),
('523','139','删除','delSecret','App','Admin','0','3','1'),
('524','137','推送消息历史','message','App','Admin','0','1','1'),
('525','137','我要推送消息','addMessage','App','Admin','0','10','1'),
('526','137','推送消息','pushMessage','App','Admin','0','2','1'),
('527','137','删除','delMessage','App','Admin','0','3','1'),
('528','134','查看','feedback','App','Admin','0','9','1'),
('529','134','删除','delFeedback','App','Admin','0','3','1'),
('530','135','查看','stat','App','Admin','0','9','1'),
('531','138','查看','active','App','Admin','0','9','1'),
('532','140','小程序设置','xcxConfig','Wx','Admin','0','1','1'),
('533','140','保存小程序设置','saveXcxConfig','Wx','Admin','0','4','1'),
('534','144','菜单管理','index','Menu','Admin','0','9','1'),
('535','144','保存所有','saveAll','Menu','Admin','0','4','1'),
('536','26','查看','index','Coupon','Admin','0','9','1'),
('537','26','添加','add','Coupon','Admin','0','10','1'),
('538','26','修改','modify','Coupon','Admin','0','11','1'),
('539','26','保存修改','savemodify','Coupon','Admin','0','4','1'),
('540','26','保存添加','saveadd','Coupon','Admin','0','2','1'),
('541','26','删除','del','Coupon','Admin','0','3','1'),
('542','26','删除发放的优惠券','delCouponSend','Coupon','Admin','0','3','1'),
('543','146','查看','index','Area','Admin','0','9','1'),
('544','131','设置','config','Cash','Admin','0','1','1'),
('545','147','插件应用商店','index','Plugin','Admin','0','9','1'),
('546','150','查看','baiduPush','Seo','Admin','0','9','1'),
('547','147','保存百度自动推送','saveBaiduPush','Seo','Admin','0','4','1'),
('548','153','查看','index','Point','Admin','0','9','1');

INSERT INTO `youdian_menu_top` VALUES
('1','设置','Public/AdminLeft','menu','99','1','1','1'),
('2','系统','Public/AdminLeft','menu','3','1','0','1'),
('3','内容','Public/AdminLeft','menu','1','1','0','1'),
('4','互动','Public/AdminLeft','menu','5','1','0','1'),
('5','广告','Public/AdminLeft','menu','7','1','0','1'),
('6','会员','Public/AdminLeft','menu','14','1','0','1'),
('7','模板','Public/AdminLeft','menu','94','1','0','1'),
('14','SEO','Public/AdminLeft','menu','10','1','0','1'),
('15','微信','Public/AdminLeft','menu','12','1','0','1'),
('17','应用','Public/AdminLeft','menu','96','1','0','1'),
('9','基本信息','Public/MemberLeft','menu','1','0','0','1'),
('10','内容管理','Public/MemberLeft','menu','2','0','0','1'),
('11','安全退出','Public/Logout','_top','4','0','0','1'),
('12','修改密码','Public/Pwd','main','3','0','0','0');

INSERT INTO `youdian_oauth` VALUES
('1','QQ号码登录','1','123','213','http://connect.qq.com/','qq','','1');

INSERT INTO `youdian_pay` VALUES
('1','6','货到付款','0','',NULL,'','','0',NULL,NULL,NULL,'1','开通城市：北京、上海、深圳、广州','1','1','1');

INSERT INTO `youdian_pay_type` VALUES
('1','支付宝','1','1','1'),
('2','财付通即时到账','2','1','0'),
('3','财付通担保支付','3','1','0'),
('4','paypal支付','4','1','1'),
('5','银行汇款/转账、邮局汇款','5','0','1'),
('6','货到付款','6','0','1'),
('7','余额支付','7','0','1'),
('8','银联支付','8','1','1'),
('9','网银在线','9','1','0'),
('10','微信支付','2','1','1');

INSERT INTO `youdian_resume` VALUES
('1','3','0','肖芳','女','1990-05-16','汉族','2000-3000','群众','大专','13587898345','xiaofang@qq.com','北京市海淀区三一路','2013-05-16 11:13:27','北京','文秘','北京大学','','1','');

INSERT INTO `youdian_shipping` VALUES
('1','上门取货','0','买家自己到商家指定地点取货','0','0','0','1','1'),
('2','圆通快递','0','上海圆通物流有限公司经过多年的网络快速发展，在中国速递行业中一直处于领先地位。为了能更好的发展国际快件市场，加快与国际市场的接轨，强化圆通的整体实力，圆通已在东南亚、欧美、中东、北美洲、非洲等许多城市运作国际快件业务','5','0','0','1','1'),
('3','中通速递','0','保价费按照申报价值的2％交纳，但是，保价费不低于100元，保价金额不得高于10000元，保价金额超过10000元的，超过的部分无效','10','0','0','1','1');

INSERT INTO `youdian_support` VALUES
('1','业务咨询','1','123123','1','1','1'),
('6','consult','1','888888','1','1','2');

INSERT INTO `youdian_support3` VALUES
('1','','1','1'),
('2','','1','2');

INSERT INTO `youdian_support_type` VALUES
('1','腾讯QQ','1'),
('2','淘宝旺旺','2'),
('3','阿里旺旺','3'),
('4','微软MSN','4'),
('5','Skype','5'),
('6','阿里旺旺国际版','3'),
('7','自定义类型','20');

INSERT INTO `youdian_wx_app` VALUES
('1','迎中秋庆国庆刮刮卡大抽奖','1','刮刮卡','99','1@@@迎中秋庆国庆刮刮卡大抽奖，好运多多，机会多多，小伙伴们，赶快参与吧！@@@@@@2014-10-30 16:51:41@@@2018-10-31 16:51:41@@@你已经玩过了，下次再来！@@@/Public/tpl/wx/images/scratch.jpg@@@@@@活动已经结束@@@亲，活动已经结束，所有奖品已经发放完毕。下次早点哦！请继续关注我们的后续活动，谢谢！@@@联想x60笔记本@@@1@@@1@@@小米3S手机@@@2@@@5@@@64G U盘@@@5@@@10@@@3@@@123@@@1@@@','','1'),
('2','10周年店庆幸运大转抽奖活动','1','大转盘','99','0@@@10周年店庆大抽奖活动，好运多多，奖品多多，小伙伴们，赶快来参与吧！@@@@@@2014-10-30 16:52:46@@@2018-10-31 16:52:46@@@你已经玩过了，下次再来！@@@/Public/tpl/wx/images/wheel.jpg@@@@@@活动已经结束@@@亲，活动已经结束，所有奖品已经发放完毕。下次早点哦！请继续关注我们的后续活动，谢谢！@@@ipad平板电脑@@@1@@@1@@@iphone5手机@@@2@@@5@@@手机充电宝@@@5@@@10@@@3@@@123@@@1@@@','','1'),
('3','你是通过什么途径知道我们的','2','投票','99','0@@@2014-10-30 16:55:00@@@2019-10-30 16:55:00@@@1###搜索引擎$$$2###网络广告$$$3###朋友介绍$$$4###电视报纸$$$5###其它@@@/Upload/1414659467.png@@@1','','1'),
('4','高级会员卡','6','会员卡','99','高级会员卡@@@/Upload/1414659502.png@@@/Public/Images/card/bg17.png@@@/Public/Images/card/cover.jpg@@@微时代会员卡，方便携带收藏，永不挂失@@@#FFFF00@@@#FFFF00@@@@@@@@@1@@@1@@@某某商家@@@长沙友点软件科技有限公司（http://www.youdiansoft.cn）位于长沙市星沙经济开发区，是国内首家研发中英文网站、手机网站、微信网站三站合一的高科技软件企业，拥有独立自主研发的三站合一企业级产品《友点企业网站管理系统》。以公司核心技术为依托，形成了针对不同行业、不同规模、不同应用的系列产品和解决方案。@@@0731-84037726@@@长沙市星沙经济开发区板仓路尚都花园城6栋1单元904@@@@@@@@@123@@@@@@',NULL,'1'),
('5','你最想去哪里旅游?','5','调查','99','/Public/tpl/wx/images/research.png@@@感谢您参与此次调查，本调查目的在于了解产品对消费者购物选择的影响。您对本问卷的所有回答都是以匿名形式进行并且答案得到严格保密，研究结果将是结论性质的报告，不会泄漏您的任何相关信息。每位参与调研的朋友都将获得我们送出的尊贵礼品，同时你还有机会获得大奖。\r\n                                @@@尊敬的客户：\r\n感谢您的耐心参与，您的选择，将对我们起到重要的指导作用，我们在此向您表示诚挚的谢意。\r\n同时，为了回馈您的贡献，我们将从所有参与调研的客户中，随机抽取几位幸运奖得主。您将有机会获得我们为您精心准备的礼品一份，中奖名单将在近期公布，敬请关注。\r\n祝您生活愉快。\r\n                                @@@2014-10-30 17:00:30@@@2018-01-28 17:00:30@@@@@@赶快来参与吧，还有机会中大奖！@@@0',NULL,'1');

INSERT INTO `youdian_wx_apptype` VALUES
('1','微活动','1','1'),
('2','微投票','2','1'),
('3','微工具','3','1'),
('4','地理位置服务','4','1'),
('5','微调查','5','1'),
('6','微会员卡','6','1');

INSERT INTO `youdian_wx_menu` VALUES
('1','0','一级菜单1','1','0','',NULL,NULL,NULL,'1'),
('2','0','一级菜单2','1','2','',NULL,NULL,NULL,'1'),
('3','0','一级菜单3','1','3','',NULL,NULL,NULL,'1'),
('4','2','二级菜单25','1','4','这里填写二级菜单25返回消息！','3',NULL,NULL,'1'),
('5','2','二级菜单23','1','3','这里填写二级菜单23返回消息！','22','',NULL,'1'),
('6','1','二级菜单15','1','2','这里填写二级菜单15返回消息！','2','',NULL,'1'),
('10','2','二级菜单22','1','2','这里填写二级菜单22返回消息！',NULL,NULL,NULL,'1'),
('11','1','二级菜单14','1','1','这里填写二级菜单14返回消息！','','',NULL,'1'),
('15','2','二级菜单21','1','1','这里填写二级菜单21返回消息！',NULL,NULL,NULL,'1'),
('16','3','二级菜单31','1','1','这里填写二级菜单31返回消息！',NULL,NULL,NULL,'1'),
('17','2','二级菜单24','1','3','这里填写二级菜单24返回消息！',NULL,NULL,NULL,'1'),
('21','1','二级菜单11','1','0','这里填写二级菜单11返回消息！',NULL,NULL,NULL,'1'),
('22','1','二级菜单12','1','0','这里填写二级菜单12返回消息！','3',NULL,NULL,'1'),
('23','3','二级菜单32','1','2','这里填写二级菜单32返回消息！','3',NULL,NULL,'1'),
('24','1','二级菜单13','1','0','这里填写二级菜单13返回消息！','','',NULL,'1');

INSERT INTO `youdian_wx_question` VALUES
('1','5','99','你最想去的地方？','1###丽江@@@2###西藏@@@3###海南@@@4###香港@@@5###其他旅游景点','0','1'),
('2','5','99','你的业余爱好？','1###唱歌@@@2###旅游@@@3###逛街@@@4###看书@@@5###其他','0','1');

INSERT INTO `youdian_wx_reply` VALUES
('1','1','subscribe','0','2','0','1','1','',NULL,'1'),
('2','2','default','2','1','0','您好！客服美眉不在，请直接联系我们！\r\nQQ：1234567\r\n电话：010-88888888\r\n手机：13588888888','','',NULL,'1'),
('3','4','lbs','4','5','0','/^附近(d*)([wW]+)$/','/^附近(d*)([wW]+)$/','','附近1000KTV','1'),
('4','3','1,首页','0','2','0','1','1',NULL,NULL,'1');

INSERT INTO `youdian_wx_type` VALUES
('1','微信文本消息','1','1','1'),
('2','微信图文消息','1','2','1'),
('3','微信音乐消息','1','3','1'),
('4','打开频道主页','0','4','1'),
('5','微应用','1','5','1'),
('6','外部链接','0','6','1'),
('7','直接返回素材','1','10','1'),
('8','打开小程序','0','20','1');

