<?php namespace Phpcmf\Controllers\Admin;

class Mform extends \Phpcmf\App
{
    public function __construct(...$params) {
        parent::__construct(...$params);

        $dir = dr_safe_replace(\Phpcmf\Service::L('input')->get('dir'));

        $menu = [
            '模块表单' => [APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-cogs'],
            '评论配置' => ['hide:'.APP_DIR.'/'.\Phpcmf\Service::L('Router')->class.'/edit{dir='.$dir.'}', 'fa fa-comments'],
            'help' => [1059]
        ];

        \Phpcmf\Service::V()->assign('menu', \Phpcmf\Service::M('auth')->_admin_menu($menu));
    }

    public function index() {

        $modules = \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-content');
        if (!$modules) {
            $this->_admin_msg(0, dr_lang('未安装任何内容模块'));
        }

        $config = \Phpcmf\Service::M('comment', 'comment')->get_setting('mform');

        $module = [];
        foreach ($modules as $t) {
            $module[$t['dirname']] = [
                'name' => $t['name'],
                'icon' => $t['icon'],
                'dirname' => '',
            ];
            $form = \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-'.$t['dirname'], 'form');
            if ($form) {
                foreach ($form as $f) {
                    $dir = $t['dirname'].'-'.$f['table'];
                    $is_install = 0;
                    // 是否评论表
                    $table = \Phpcmf\Service::M()->dbprefix(SITE_ID.'_'.$t['dirname'].'_form_'.$f['table']);
                    if (\Phpcmf\Service::M()->is_table_exists($table) && \Phpcmf\Service::M()->is_table_exists($table.'_comment') && \Phpcmf\Service::M()->is_field_exists($table, 'comments')) {
                        $is_install = 1;
                    }
                    $module[$dir] = [
                        'mid' => $t['dirname'],
                        'name' => $f['name'],
                        'icon' => $f['setting']['icon'],
                        'used' => $config[$dir]['use'] ? 1 : 0,
                        'dirname' => $f['table'],
                        'is_install' => $is_install,
                    ];
                }
            }
        }
        if (!$module) {
            $this->_admin_msg(0, dr_lang('未安装任何内容模块'));
        }

        \Phpcmf\Service::V()->assign([
            'module' => $module,
        ]);
        \Phpcmf\Service::V()->display('mform.html');
    }


    // 调用代码
    public function show_index() {

        $dir = dr_safe_replace(\Phpcmf\Service::L('input')->get('dir'));
        list($mid, $fid) = explode('-', $dir);

        $code = '// 评论ajax框代码 id表示当前模块表单的内容id号';
        $code.= PHP_EOL.'{dr_mform_comment(\''.$mid.'\',\''.$fid.'\', $id)}';

        $msg = '<br>全局的模板页面：mform_comment_ajax.html';
        $msg.= '<br>单独的模板页面：'.$mid.'/'.$fid.'_comment_ajax.html';

        \Phpcmf\Service::V()->assign('msg', $msg);
        \Phpcmf\Service::V()->assign('code', $code);
        \Phpcmf\Service::V()->display('code.html');
        exit;
    }

    // 评论配置
    public function edit() {

        $dir = dr_safe_replace(\Phpcmf\Service::L('input')->get('dir'));
        list($mid, $fid) = explode('-', $dir);
        $module = \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-content', $mid);
        if (!$module) {
            $this->_admin_msg(0, dr_lang('当前站点没有安装此模块[%s]', $mid));
        }

        $table = \Phpcmf\Service::M()->dbprefix(SITE_ID.'_'.$mid.'_form_'.$fid.'_comment');
        if (!\Phpcmf\Service::M()->is_table_exists($table)) {
            $this->_admin_msg(0, dr_lang('当前站点没有安装此模块[%s]的表单中', $mid));
        }

        $config = \Phpcmf\Service::M('comment', 'comment')->get_setting('mform');
        $data = $config[$dir] ? $config[$dir] : [];

        if (IS_AJAX_POST) {
            $config[$dir] = \Phpcmf\Service::L('input')->post('data');
            if ($config[$dir]['comment_list_field']) {
                foreach ($config[$dir]['comment_list_field'] as $t) {
                    if ($t['func']
                        && !method_exists(\Phpcmf\Service::L('Function_list'), $t['func']) && !function_exists($t['func'])) {
                        $this->_json(0, dr_lang('列表回调函数[%s]未定义', $t['func']));
                    }
                }
            }
            \Phpcmf\Service::M('comment', 'comment')->save_setting('mform', $config);
            \Phpcmf\Service::M('cache')->sync_cache(''); // 自动更新缓存
            $this->_json(1, dr_lang('操作成功'));
        }

        // 评论字段
        $comment_field = \Phpcmf\Service::M()->db->table('field')
            ->where('disabled', 0)
            ->where('ismain', 1)
            ->where('relatedname', 'comment-mform-'.$dir)
            ->orderBy('displayorder ASC,id ASC')
            ->get()->getResultArray();
        $sys_field = \Phpcmf\Service::L('Field')->sys_field(['content', 'author', 'inputtime']);
        $comment_field = dr_list_field_value($data['comment_list_field'], $sys_field, $comment_field);

        $page = intval(\Phpcmf\Service::L('input')->get('page'));

        if (!isset($data['review'])) {
            // 默认点评
            $data['review']['use'] = 0;
            $data['review']['score'] = 10;
            $data['review']['option'] = [];
            // 点评选项
            for ($i = 1; $i <= 9; $i++) {
                $data['review']['option'][$i] = [
                    'use' => 0,
                    'name' => '选项'.$i,
                ];
            }
            // 点评值
            for ($i = 1; $i <= 5; $i++) {
                $data['review']['value'][$i] = [
                    'use' => 0,
                    'name' => $i.'星评价',
                ];
            }
        }

        \Phpcmf\Service::V()->assign([
            'page' => $page,
            'data' => $data,
            'form' => dr_form_hidden(['page' => $page]),
            'module' => $module,
            'comment_field' => $comment_field,
        ]);
        \Phpcmf\Service::V()->display('module_comment.html');
    }

    // 创建评论
    public function add() {

        $dir = dr_safe_filename($_GET['dir']);
        list($mid, $fid) = explode('-', $dir);
        $row = \Phpcmf\Service::M('module')->table('module')->where('dirname', $mid)->getRow();
        if (!$row) {
            $this->_json(0, dr_lang('此模块[%s]未安装', $mid));
        }

        $rt = \Phpcmf\Service::M('comment', 'comment')->install_mform($mid, $fid, SITE_ID);
        if (!$rt['code']) {
            $this->_json(0, $rt['msg']);
        }

        \Phpcmf\Service::M('cache')->sync_cache('');
        $this->_json(1, '安装成功');
    }

    // 删除评论
    public function del() {

        $dir = dr_safe_filename($_GET['dir']);
        list($mid, $fid) = explode('-', $dir);
        $row = \Phpcmf\Service::M('Module')->table('module')->where('dirname', $mid)->getRow();
        if (!$row) {
            $this->_json(0, dr_lang('此模块[%s]未安装', $mid));
        }

        $rt = \Phpcmf\Service::M('comment', 'comment')->uninstall_mform($mid, $fid, SITE_ID);
        if (!$rt['code']) {
            $this->_json(0, $rt['msg']);
        }

        \Phpcmf\Service::M('cache')->sync_cache('');
        $this->_json(1, '卸载成功');
    }

}
