<?php
// +----------------------------------------------------------------------
// | HulaCWMS 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use app\common\model\AdminAction as AdminActionModel;
use app\common\validate\AdminAction as ActionValidate;


class AdminAction extends Base
{
    /**
     * 用户行为
     */
    public function action(){
        $param=[
            'title'=>''
        ];
        $param=$this->initParam($param);
        $map[] = ['status','>',-1];
        if($param['title']!=''){
            $map[]=['name|title','like','%'.$param['title'].'%'];
        }

        $model=new AdminActionModel();
        $lists=$model->where($map)->order('id desc')
            ->paginate($this->config['LIST_ROWS'],false,['query' => $this->getRouteQuery()]);
        $this -> assign('lists', $lists);
        $this->assign('param',$param);

        $this->meta_title = '用户行为';
        return $this->fetch();
    }

    /**
     * 新增
     */
    public function add(){
        if($this->request->isGet()){
            return $this -> fetch();
        }
        $thisModel=new AdminActionModel();
        $postData=$this->request->param();

        //验证
        $actionValidate=new ActionValidate();
        if (!$actionValidate->check($postData)) {
            $this->error($actionValidate->getError());
        }
        //判断行为标识是否重复
        $checkName=$thisModel
            ->where('name',$postData['name'])
            ->where('status','>',-1)->find();
        if($checkName){
            $this->error('行为标识重复！');
        }
        //判断行为名称是否重复
        $checkTitle=$thisModel
            ->where('title',$postData['title'])
            ->where('status','>',-1)->find();
        if($checkTitle){
            $this->error('行为名称重复！');
        }
        $postData['status']=1;
        $re=$thisModel->add($postData);
        if($re){
            //添加行为记录
            action_log("adminaction_add","admin_action",$re,session('UID'));
            $this->success('新增成功！','action');
        }
        else{
            $this->error($thisModel->getError());
        }
    }


    /**
     * 编辑
     */
    public function edit(){
        $thisModel=new AdminActionModel();
        if($this->request->isGet()){
            $id=input('id');
            $info=$thisModel->get($id);
            $this->assign('info',$info);
            return $this -> fetch();
        }
        $paramData=$this->request->param();

        //验证
        $actionValidate=new ActionValidate();
        if (!$actionValidate->check($paramData)) {
            $this->error($actionValidate->getError());
        }
        //判断行为标识是否重复
        $checkName=$thisModel
            ->where('name',$paramData['name'])
            ->where('status','>',-1)->find();
        if($checkName){
            $this->error('行为标识重复！');
        }
        //判断行为名称是否重复
        $checkTitle=$thisModel
            ->where('title',$paramData['title'])
            ->where('status','>',-1)->find();
        if($checkTitle){
            $this->error('行为名称重复！');
        }

        $re=$thisModel->edit($paramData);
        if($re){
            //添加行为记录
            action_log("adminaction_edit","admin_action",$paramData['id'],session('UID'));
            $this->success('编辑成功！','');
        }
        else{
            $this->error($thisModel->getError());
        }
    }


    /**
     * 启用禁用用户行为
     */
    public function enable(){
        if ($this->request->isPost()){
            $data['id']=input('id/d');
            $data['status']=input('val/d');
            $model=new AdminActionModel();
            $res=$model->edit($data);
            if($res){
                //                添加行为记录
                if($data['status']==1){
                    $adminAction_status="adminaction_status_qi";
                }
                if($data['status']==0){
                    $adminAction_status="adminaction_status_jin";
                }
                action_log($adminAction_status,"admin_action",$data['id'],session('UID'));
                $this->success('操作成功！');
            }else{
                $this->error($model->getError());
            }
        }
    }

    /**
     * 删除
     */
    public function del(){
        $id=$this->request->param('ids/a');
        $thisModel=new AdminActionModel();
        $where[] =['id','in',$id];
        //伪删除
        $re=$thisModel->save([
            'status'  => -1
        ],$where);
        if($re){
            //添加行为记录
            action_log("adminaction_del","admin_action",$id,session('UID'));
            $this->success('删除成功！');
        }
        else{
            $this->error($thisModel->getError());
        }
    }

}
