<?php
// +----------------------------------------------------------------------
// | HulaCWMS 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use app\common\model\AdminActionLog as AdminActionLogModel;

class AdminActionLog extends Base
{
    /**
     * 用户行为日志actionlog
     */
    public function actionlog(){
        $param=[
            'title'=>''
        ];
        $param=$this->initParam($param);
        $map=[];
        if($param['title']!=''){
            $map[]=['adminAction.title','like','%'.$param['title'].'%'];
        }
        $model=new AdminActionLogModel();
        $lists = $model->withJoin(['admin_action','admin_member'])
            -> where($map)
            -> order('admin_action_log.id asc')
            ->paginate($this->config['LIST_ROWS'],false,['query' => $this->getRouteQuery()]);
        $this -> assign('lists', $lists);
        $this->assign('param',$param);
        return $this->fetch();
    }
    /**
     *用户行为记录详细
     */
    public function detail(){
        $model=new AdminActionLogModel();
        $id=input('id');
        $info=$model
            ->withJoin(['admin_action','admin_member'])
            ->where('admin_action_log.id',$id)
            ->find();
        $this->assign('info',$info);
        return $this -> fetch();
    }

    /**
     * 删除用户行为记录
     */
    public function del(){
        $id=$this->request->param('ids/a');
        $thisModel=new AdminActionLogModel();
        $re=$thisModel->del($id);
        if($re){
            //添加行为记录
            action_log("adminactionlog_del","admin_action_log",$id,session('UID'));
            $this->success('删除成功！');
        }
        else{
            $this->error($thisModel->getError());
        }
    }

    /**
     * 清空日志
     */
    public function clear(){
        $model=new AdminActionLogModel();
        $res = $model->where('1=1')->delete();
        if($res !== false){
            $this->success('日志清空成功！','actionlog');
        }else {
            $this->error('日志清空失败！');
        }
    }

}
