<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;

use app\common\model\AdminAuthGroup as AdminAuthGroupModel;
use app\common\model\AdminMember as AdminMemberModel;
use app\common\validate\AdminMember as AdminMemberValidate;
use app\common\validate\AdminMemberEdit as AdminMemberEditValidate;

/**
 *
 */
class AdminMember extends Auth
{
    /**
     * 列表
     */
    public function index()
    {
        $param = [
            'nickname' => ''
        ];
        $param = $this->initParam($param);
        $map[] = ['status', '>', -1];
        if ($param['nickname'] != '') {
            $map[] = ['username|nickname', 'like', '%' . $param['nickname'] . '%'];
        }
        $model = new AdminMemberModel();
        $lists = $model->where($map)->paginate($this->config['LIST_ROWS'], false, ['query' => $this->getRouteQuery()]);
        $this->assign('lists', $lists);
        $this->assign('param', $param);
        return $this->fetch();
    }

    /**
     * 新增
     */
    public function add()
    {
        $model = new AdminMemberModel();
        if ($this->request->isGet()) {
            return $this->fetch();
        }
        $postData = $this->request->param();
        //            验证
        $adminMemberValidate = new AdminMemberValidate();
        if (!$adminMemberValidate->check($postData)) {
            $this->error($adminMemberValidate->getError());
        }
        //用户名查重
        if ($model->isHas($postData['username'])) {
            $this->error("用户名已存在！");
        }
        //验证  确认密码是否与密码相同
        if ($postData['repassword'] !== $postData['password']) {
            $this->error('两次输入密码不一致！请重新输入！');
        }
        $postData['password'] = zz_ucenter_md5($postData['password'], config('UC_AUTH_KEY'));
        $postData['reg_time'] = time();
        $postData['status'] = 1;
        $re = $model->add($postData);
        if ($re) {
            //添加行为记录
            action_log("adminmember_add", "admin_member", $re, session('UID'));
            $this->success('新增成功！', '');
        } else {
            $this->error($model->getError());
        }
    }

    /**
     * 编辑
     */
    public function edit()
    {
        $model = new AdminMemberModel();
        if ($this->request->isGet()) {
            $id = input('id');
            $info = $model->get($id);
            $this->assign('info', $info);
            return $this->fetch();
        }
        $paramData = $this->request->param();
        //验证
        $adminMemberValidate = new AdminMemberEditValidate();
        if (!$adminMemberValidate->check($paramData)) {
            $this->error($adminMemberValidate->getError());
        }
        //用户名查重
        $member = $model->isHas($paramData['username']);
        if ($member && $member['id'] != $paramData['id']) {
            $this->error("用户名已存在！");
        }
        if ($paramData['password'] != '') {
            $paramData['password'] = zz_ucenter_md5($paramData['password'], config('UC_AUTH_KEY'));
        } else {
            unset($paramData['password']);
        }

        $re = $model->edit($paramData);
        if ($re) {
            //                添加行为记录
            action_log("adminmember_edit", "admin_member", $paramData['id'], session('UID'));
            $this->success('编辑成功！', '');
        } else {
            $this->error($model->getError());
        }
    }

    /**
     * 编辑管理员
     */
    public function resetpwd()
    {
        if (request()->isPost()) {
            $data = $_POST;
            //验证  确认密码是否与密码相同
            if ($data['repassword'] !== $data['password']) {
                $this->error('两次输入密码不一致！请重新输入！');
            }

            if(!$data['password']){
                $this->error('请输入要修改的密码！');
            }
            if(strlen($data['password'])<4){
                $this->error('密码不少于4位数！');
            }
            if($this->member->password!=zz_ucenter_md5($data['oldpassword'], config('UC_AUTH_KEY'))){
                $this->error('原密码输入错误！');
            }
            $this->member->update_time= time();
            $this->member->password = zz_ucenter_md5($data['password'], config('UC_AUTH_KEY'));
            $re = $this->member->save();
            if ($re) {
                action_log("adminmember_resetpwd", "admin_member", $this->member->id, $this->member->id);
                $this->logout();
                $this->success('密码重置成功，请重新登录！', 'admin/login','top');
            } else {
                $this->error('操作失败');
            }
        } else {
            return $this->fetch();
        }
    }

    /**
     * 删除
     */
    public function del()
    {
        $id = $this->request->param('ids/a');
        //超级管理员，不能被删除。
        if (in_array(1, $id)) {
            $this->error('超级管理员无法被删除！');
        }
        $model = new AdminMemberModel();
        //伪删除
        $where[] = ['id', 'in', $id];
        $re = $model->save([
            'status' => -1
        ], $where);
        if ($re) {
            //                添加行为记录
            action_log("adminmember_del", "admin_member", $id, session('UID'));
            $this->success('删除成功！');
        } else {
            $this->error($model->getError());
        }
    }

    /**
     * 禁用启用
     */
    public function enable()
    {
        if ($this->request->isPost()) {
            $data['id'] = input('id/d');
            $data['status'] = input('val/d');
            if ($data['id'] == 1) {
                $this->error('该管理员为超级管理员，无法改变其状态！');
            }
            $model = new AdminMemberModel();
            $res = $model->edit($data);
            if ($res) {
                if ($data['status'] == 1) {
                    //启用
                    $adminmember_status = "adminmember_status_qi";
                }
                if ($data['status'] == 0) {
                    //禁用
                    $adminmember_status = "adminmember_status_jin";
                }
                //添加行为记录
                action_log($adminmember_status, "admin_member", $data['id'], session('UID'));

                $this->success('操作成功！');
            } else {
                $this->error($model->getError());
            }
        }
    }

    /**
     * 对管理员进行授权，分配权限组
     */
    public function auth()
    {
        $model = new AdminMemberModel();
        $modelAuthModel = new AdminAuthGroupModel();
        if ($this->request->isGet()) {
            $id = input('id');
            $map[] = ['status', '>', -1];
            $lists = $modelAuthModel->where($map)->select();
            $member = $model->find($id);
            $this->assign('member', $member);
            $this->assign('lists', $lists);
            $this->assign('id', $id);
            return $this->fetch();
        }
        $paramData = $this->request->param();
        if ($paramData['id'] == 1) {
            $this->error('该管理员为超级管理员，无法授权！');
        }
        $re = $model->edit($paramData);
        if ($re) {
            session('ADMIN_MEMBER_RULES', null);
            //添加行为记录
            action_log("adminmember_auth", "admin_member", $paramData['id'], session('UID'));
            $this->success('授权成功！', 'index');
        } else {
            $this->error($model->getError());
        }
    }


}