<?php
// +----------------------------------------------------------------------
// | hulacwms 3.0 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\admin\controller;
use app\common\model\AdminAuthGroup;
use app\common\model\AdminMember;
use think\Controller;
use app\common\model\Config as ConfigModel;
use app\common\model\AdminMenu as AdminMenuModel;

class Auth extends Base
{
    /**
     * @var 当前登录管理员
     */
    protected $member;

    /**
     * 模块初始化
     */
    protected function initialize(){

        parent::initialize();
        //是否已登录
        $uid=$this->isLogin();
        //获取登录管理员信息
        $adminMemberModel=new AdminMember();
        $member=$adminMemberModel->get($uid);
        //数据库中不存在管理员记录
        if(!$member){
            $this->logout();
            $this->error('错误：请重新登录！','Admin/login');
        }

        //非超级管理员，验证登录用户
        if($member->id!=1){
            if ((int)$member->getData('status') !=1) {
                $this->logout();
                $this->error('错误：当前登录用户已被禁用，请联系系统管理员！', 'Admin/login');
            }
            if ((int)$member->group_id == 0) {
                $this->logout();
                $this->error('错误：当前登录用户未被分配到任何权限组！', 'Admin/login');
            }
            //验证权限
            $adminAuth = new AdminAuthGroup();
            $currentPath = $this->request->controller() . '/' . $this->request->action();
            $reAuth = $adminAuth->checkAuth($member, $currentPath);
            //验证未通过
            if (!$reAuth) {
                $this->error($adminAuth->getError());
            }
        }

        $this->member=$member;
    }
}
