<?php

namespace app\common\model;


/**
 * 后台权限
 * Class AdminAuth
 * @package app\common\model
 */
class AdminAuthGroup extends Base
{
    protected $autoWriteTimestamp = true;

    /**
     * 判断用户权限
     * @param $member 用户信息
     * @param $path 当前pathinfo
     * @return AdminAuthGroup|bool
     */
    public function checkAuth($member, $path)
    {
        if (!$member->group_id) {
            $this->error = '错误：未分配权限！';
            return false;
        }
        $detail = $this->get($member->group_id);
        if (!$detail) {
            $this->error = '错误：无法获取用户组权限！';
            return false;
        }
        if ($detail->getData('status') < 1) {
            $this->error = '错误：用户权限组已被禁用，请联系管理员！';
            return false;
        }
        if (empty($detail->rules)) {
            $this->error = '错误：用户权限组没有分配权限！';
            return false;
        }
        //首页\附件上传\编辑器上传不在权限控制内
        if ($path == 'Index/index'||$path == 'Files'||$path == 'Ueditor') {
            return $detail;
        }

        //使用当前访问的url地址去数据库中检索
        $adminMenuModel = new AdminMenu();
        $adminMenu = $adminMenuModel->where('url', 'like', "$path%")->field('id')->select();

        //如果后台菜单中无记录，无权限访问。
        if (!$adminMenu) {
            $this->error = '错误：无权限！';
            return false;
        }

        $ruleArr = explode(',', $detail->rules);
        foreach ($adminMenu as $item) {
            if (in_array($item['id'], $ruleArr)) {
                return $detail;
            }
        }
        $this->error = '错误：无权限！';
        return false;
    }

    /**
     * 判断用户组名称是否重复
     * @param $title
     * @return AdminAuth
     */
    public function isRepeatTitle($title, $id = false)
    {
        if ($id) {
            return $this->where('title', $title)->where('id', '<>', $id)->find();
        } else {
            return $this->where('title', $title)->find();
        }
    }
}