<?php
namespace app\common\model;
use think\Model;

/**
 * 模型基类
 * Class BaseModel
 * @package app\common\model
 */
class Base extends Model{

    /**
     * @var 验证器
     */
    public $validater;

    /**
     * 新增
     */
    public function add($data){
        //验证
        if($this->validater&&!$this->validater->check($data)){
            $this->error=$this->validater->getError();
            return false;
        }
        $re=$this->save($data);
        if(!$re){
            $this->error='新增失败!';
            return false;
        }
        return $this->id;
    }
    /**
     * 编辑
     */
    public function edit($data){
        //验证
        if($this->validater&&!$this->validater->check($data)){
            $this->error=$this->validater->getError();
            return false;
        }
        $re=$this->isUpdate(true)->save($data);
        if(!$re){
            $this->error='编辑失败!';
            return false;
        }
        return true;
    }
    /**
     * 删除
     */
    public function del($id){
        return $this->destroy($id);
    }
}