<?php
namespace app\common\model;
use app\common\model\Document as DocumentModel;
use think\Db;

/**
 * {$TABLE.Comment}
 * Class {$TABLE.Name}
 * @package app\common\model
 */
class DocumentArticle extends Base {
    /**
     * 添加文章
     * @param $data
     */
    public function add_data($data)
    {
        if(!$data){
            return false;
        }
        $documentModel=new DocumentModel();
        $re=true;
        // 启动事务
        Db::startTrans();
        try {
            $data['status']=1;
            $documentResult=$documentModel->add($data);
            if(!$documentResult){
                throw new \Exception('新增文章失败！');
            }
            $content = isset($data['content'])?$data['content']:'';
            //副表
            $contentResult= $this->save([
                'id'      =>  $documentResult,
                'content' =>  $content
            ]);
            if(!$contentResult){
                throw new \Exception('新增失败！');
            }
            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            $re=false;
        }
        if(!$re){
            return $re;
        }
        return $documentResult;
    }

    /**
     * 编辑文章
     * @param $data
     */
    public function edit_data($data)
    {
        if(!$data){
            return false;
        }
        $documentModel=new DocumentModel();
        $re=true;
        // 启动事务
        Db::startTrans();
        try {
            $documentResult=$documentModel->edit($data);
            if(!$documentResult){
                throw new \Exception('编辑文章失败！');
            }
            $content = isset($data['content'])?$data['content']:'';
            //副表
            $contentResult=$this->save([
                'content' => $content
            ],['id' =>  $data['id']]);
            if(!$contentResult){
                throw new \Exception('编辑文章失败！');
            }
            // 提交事务
            Db::commit();
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            $re=false;
        }
        return $re;
    }

}