<?php
namespace app\common\model;

use think\Db;
/**
 * {$TABLE.Comment}
 * Class {$TABLE.Name}
 * @package app\common\model
 */
class DocumentCategory extends Base {

    //自动时间戳
    protected $autoWriteTimestamp = true;
    /**
     * @var array   是否显示
     */
    public $is_showList=[
        
        0=>'隐藏',
        
        1=>'显示',
        
    ];

    public function getIsShowAttr($value)
    {
        return $this->is_showList[$value];
    }

    public function parent(){
        return $this->belongsTo('DocumentCategory','pid');
    }

    /**
     * 更新上级child_id
     * $oldpid=原上级分类id
     * $newpid=现上级分类id
     * $category=栏目分类对象
     */
    public function edit_category_child_item($oldpid,$newpid,$category){

        $prefix=config('database.prefix');
        //原上级分类，需要删除当前分类及当前分类下的子孙分类id
        //找到所有上级分类->删除当前分类id->获取当前分类子孙id->删除分类子孙分类id
        $oldpid=(int)$oldpid;
        if($oldpid){
            //找到所有上级分类
            $lists = db('document_category')
                -> where("CONCAT(',',child,',') like '%,$oldpid,%'")
                ->whereOr('id',$oldpid)
                -> field('id,child')
                ->order('pid asc')
                -> select();
            foreach ($lists as $item){
                $childArr=explode(',',$item['child']);
                if(!$childArr){
                    continue;
                }
                //删除当前分类id
                $childArr=array_diff($childArr,[$category['id']]);
                //获取当前分类子孙id
                if($category['child']){
                    $currCategoryChildArr=explode(',',$category['child']);
                    $childArr=array_diff($childArr,$currCategoryChildArr);
                }
                $newchild=implode(',',$childArr);
                $sql="update ".$prefix."document_category set child='$newchild' where id=".$item['id'].";";
                Db::execute($sql);
            }
        }

        //现上级分类，需要添加当前分类及当前分类下的子孙分类id
        //找到所有上级分类->添加当前分类->获取当前分类子孙id->添加分类子孙分类id
        $newpid=(int)$newpid;
        if($newpid){
            //找到所有上级分类
            $lists = db('document_category')
                -> where("CONCAT(',',child,',') like '%,$newpid,%'")
                ->whereOr('id',$newpid)
                -> field('id,child')
                ->order('pid asc') -> select();
            foreach ($lists as $item){
                $newchild=$item['child'];
                $newchild=$newchild?$newchild.',':'';
                //添加当前分类
                $newchild=$newchild.$category['id'];
                //获取当前分类子孙id
                if(isset($category['child'])&&$category['child']!=''){
                    //添加分类子孙分类id
                    $newchild=$newchild.','.$category['child'];
                }
                $sql="update ".$prefix."document_category set child='$newchild' where id=".$item['id'].";";
                Db::execute($sql);
            }
        }
    }
    /**
     * 设置栏目分类中parent_id
     * $id=分类id
     * $child_id=当前分类的所有子孙分类id
     */
    public function set_category_parent_id($id,$child_id){
        $id=(int)$id;
        if(!$id){
            $this -> error('参数错误，非法请求！');
        }
        //$id和$child_id放到一个数组中，循环改变其parent_id;
        $idArr=explode(',',$child_id);
        array_push($idArr,$id);

        foreach ($idArr as $item){
            //获取分类的所有父id
            $lists = db('document_category') -> where("CONCAT(',',child,',') like '%,$item,%'") -> field('id')->order('pid asc') -> select();
            $parentArr=array();
            foreach ($lists as $category){
                array_push($parentArr,$category['id']);
            }
            db('document_category')->where('id',$item)->update(['parent_id'=>implode(',',$parentArr)]);
        }
    }

    /**
     * 更新上级child_id
     */
    public function del_category_child_item($cid){
        $cid=(int)$cid;
        if(!$cid){
            return;
        }
        //获取所有上级
        $lists = db('document_category')
            -> where("CONCAT(',',child,',') like '%,$cid,%'")
            -> field('id,child') -> select();

        $prefix=config('database.prefix');
        foreach($lists as $item){
            $child=explode(',',$item['child']);
            $child=array_diff($child,[$cid]);
            $child=implode(',',$child);
            $id=$item['id'];
            $sql="update ".$prefix."document_category set child='$child' where id=$id;";
            Db::execute($sql);
        }
    }

}