<?php
namespace app\common\model;
use think\model\concern\SoftDelete;

/**
 * 图片视频上传
 * Class Upload
 * @package app\common\model
 */
class Picture extends Base {
    //软删除功能，当数据表中出现delete_time字段时，启用。
    protected $autoWriteTimestamp = true;
    /**
     * @var 文件信息
     */
    public $info;
    /**
     * 文件上传方法
     */
    public function upload($config,$formFile='file'){

        $rootPath=$config['rootPath'];

        // 获取表单上传文件 例如上传了001.jpg
        $file = request()->file($formFile);

        if(empty($file)){
            $this->error="请选择要上传的文件！";
            return FALSE;
        }

        // 验证文件大小和文件类型
        $info = $file->validate(['size'=>$config['maxSize'],'ext'=>$config['exts']]);
        if(!$info){
            $this->error="上传失败：".$file->getError();
            return false;
        }

        //获取文件md5用以验证是否曾上传过。
        $fileMd5=$info->md5();
        $fileSha1=$info->sha1();
        $pic=$this->where('md5',$fileMd5)->find();

        //如果上传过，直接从数据库中拉取图片地址。
        if($pic){
            $this->info=['path'=>$pic->path,'url'=>$pic->url];
            return true;
        }

        //保存到站点目录下
        $info = $info->move($rootPath);
        if(!$info){
            $this->error="上传失败：".$file->getError();
            return false;
        }

        $saveFileName=$info->getSaveName();
        $savePath=$rootPath.'/'.str_replace('\\','/',$saveFileName);


        //将文件信息保存到数据库中
        $insertData['path']='/'.$savePath;
        $insertData['url']='';
        $insertData['md5']=$fileMd5;
        $insertData['sha1']=$fileSha1;
        $this->save($insertData);
        $this->info=['path'=>$insertData['path'],'url'=>$insertData['url']];
        return true;
    }
}