<?php
// +----------------------------------------------------------------------
// | HulaCWMS 呼啦企业网站管理系统
// +----------------------------------------------------------------------
// | Copyright (c) 2021 https://www.kaifashu.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 开发树
// +----------------------------------------------------------------------

namespace app\index\controller;
use app\common\model\Config as ConfigModel;
use app\common\model\PvLog as PvLogModel;
use app\common\model\UrlLog as UrlLogModel;
use think\Console;
use think\Controller;

/**
 * 前台父类
 * Class Index
 */
class Base extends Controller
{
    protected function initialize()
    {
        /* 读取数据库中的配置 */
        $configModel=new ConfigModel();
        $config=$configModel->load($this->request->module());
        config($config,'app'); //添加配置
        //系统模板目录，兼容模板标签 include
        define('TPL', __ROOT__.'template/'.$config['WEB_TEMPLATE_PATH'].'/');
        //判断是否关闭站点。
        if (!$config['WEB_SITE_CLOSE']) {
            $this->error('网站暂时关闭！','','stop');
        }
        //判断后台统计配置是否开启  1 开启
        if ($config["WEB_TONGJI"] == 1) {
            //pv表   zz_pv_log  栏目存在 点击进入页面后
            $pvLogModel=new PvLogModel();
            $pvLogModel->set_view();
        }

        //判断是否开启了伪静态
        if (config('WEB_REWRITE')=='0') {
            $this->request->setRoot('/?s=');
        } elseif(config('WEB_REWRITE')=='1') {
            $this->request->setRoot('/');
        }
        else{
            $this->request->setRoot('index.php');
        }
    }

    //统计url
    protected function urlrecord($title)
    {
        $urlLogModel=new UrlLogModel();
        //获取url
        $urlInfo = $this->request->url(true);
        $urlLogModel->set_url($title,$urlInfo);
    }
}