layui.$(function () {
    //表单对象
    var form = layui.form;

    //监听表单事件
    form.on('submit(zz-btn-submit)', function(fromData){
        zzpost(fromData.form.action,fromData.field);
        return false;
    });

    //监听表格内复选框事件
    form.on('checkbox(zz-checkbox-table)', function(data){
        var itemStatus = data.elem.checked;
        if (itemStatus == true) {
            layui.$(".zz-table-chk-item").prop("checked", true);
            form.render('checkbox');
        } else {
            layui.$(".zz-table-chk-item").prop("checked", false);
            form.render('checkbox');
        }
    });

    //搜索按钮点击事件
    layui.$(".zz-form-search").submit(function() {
        var url = layui.$(this).attr('action');
        if(url==''){
            zzError('错误：搜索没有设置目标链接地址！');
            return false;
        }
        var query = layui.$(this).serialize();
        query = query.replace(/(&|^)(\w*?\d*?\-*?_*?)*?=?((?=&)|(?=layui.$))/g,'');
        query = query.replace(/^&/g, '');
        console.log(url);
        if (url.indexOf('?') > -1) {
            url += '&' + query;
        } else {
            url += '?' + query;
        }
        window.location.href = url;
        return false;
    });


    //弹出操作窗口
    layui.$('.open-win').click(function () {
        var that=layui.$(this);
        var url=layui.$.trim(that.attr('href'));

        if(url==''){
            zzError('错误：没有设置目标链接！');
            return ;
        }
        var title=layui.$.trim(that.attr('title'));

        title=title==''?'信息':title;

        var winWidth=layui.$.trim(that.attr('win-width'));
        winWidth=winWidth==''?'700px':winWidth+'px';

        var winHeight=layui.$.trim(that.attr('win-height'));
        winHeight=winHeight==''?'auto':winHeight+'px';

        top.layer.open({
            type:2,
            title:title,
            area: [winWidth,winHeight], //宽高
            content:url,
            success:function(e,index){
                if(winHeight=='auto')
                    parent.layer.iframeAuto(index);
            }
        });
        return false;
    });

    //添加，编辑页面取消按钮
    layui.$('.zz-btn-cancel').click(function () {
        var windowName=window.name;
        //判断是否弹出的窗口
        if(windowName){
            //在iframe中
            var index = top.layer.getFrameIndex(window.name); //先得到当前iframe层的索引
            top.layer.close(index); //再执行关闭
        }
        else {
            //不在iframe中
            history.go(-1);
        }
    });


    //ajax-post操作，一般用于单个删除
    layui.$('.ajax-post').click(function(){
        var that = this;
        var url=layui.$.trim(layui.$(that).attr('href'));
        if(url==''){
            zzError('错误：没有设置目标链接！');
            return;
        }
        if (layui.$(this).hasClass('confirm') ) {
            var confirmLayer=top.layer.confirm('您确认要执行该操作吗？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                top.layer.close(confirmLayer);
                var target=layui.$(that).attr('href');
                zzpost(target);
            });
        }
        else{
            var target=layui.$(that).attr('href');
            zzpost(target);
        }
        return false;
    });

    //数据表中，启用禁用，显示隐藏开关
    form.on('switch(zz-switch)', function(data){
        var itemDom=data.elem;

        var url=layui.$.trim(layui.$(itemDom).attr('data-href'));
        if(url==''){
            zzError('错误：没有设置目标链接！');
        }

        zzpost(url,{val:data.value},function(){
            // location.reload();
            return true;
        },function(){
            itemDom.checked=itemDom.checked?false:true;
            form.render('checkbox');
        });
    });

    //批量操作，多应用批量删除
    layui.$('.zz-btn-select-all').click(function () {
        var that = this;
        parent.layer.confirm('您确认要执行该操作吗？', {
            btn: ['确定','取消'] //按钮
        }, function(){

            var target=layui.$.trim(layui.$(that).attr('href'));
            //判断是否选中要删除的对象
            var delDom=layui.$(".layui-table .zz-table-chk-item:checked");

            if(delDom.length==0){
                zzError('请选择要操作的数据');
                return false;
            }
            var delItem=new Array();
            delDom.each(function (e) {
                delItem.push(this.value);
            });
            zzpost(target,{ids:delItem});
        });
        return false;
    });

    //数据表中表单元素ajax修改
    layui.$('.zz-form-datalist>input').blur(function () {
        var zzForm=layui.$(this).parents('.zz-form-datalist');
        var url=layui.$.trim(zzForm.attr('action'));

        //判断是否值已改变
        if(layui.$(this).attr('data-source')==layui.$(this).val()){
            return false;
        }

        if(url==''){
            zzError('错误：没有设置目标链接地址');
            return false;
        }
        var formFeild = form.val(zzForm.attr('lay-filter'));

        zzpost(url,formFeild);
    });


})