/*
//上传组件封装
//元素按钮可以通过设置属性url=上传服务器地址，multiple=是否批量上传。来指定
//本文件只需要引入一次
*/
function zzUpload(obj, config,fun1) {
    //获取属性参数
    var root = layui.$(obj);
    var $accept=layui.$.trim(root.attr('accept'));
    $accept=$accept==''?'images':$accept;
    var $multiple = layui.$.trim(root.attr('multiple'));
    $multiple = $multiple == 'multiple' ? true : false;

    //根据类型获取上传信息
    var uploadInfo=zzGetUploadInfo($accept);

    //新建上传元素
    var $name = layui.$.trim(root.attr('name'));
    var btnUpload=layui.$('<button class="layui-btn zz-upload-btn" type="button">'+uploadInfo.btn+'</button>');
    root.append(btnUpload);
    var uploadText=layui.$('<input class="zz-upload-value layui-input" name="'+$name+'" type="text" placeholder="在这里可输入文件地址">');
    root.append(uploadText);

    //如果有上传初始化回调
    if(uploadInfo.init){
        uploadInfo.init(root);
    }

    //如果有默认值
    var $value = layui.$.trim(root.attr('value'));
    uploadText.val($value);
    if($value!=''&&uploadInfo.uploaded){
        var uploadValArr = $value.split(',');
        for(var x in uploadValArr){
            uploadInfo.uploaded(root,uploadValArr[x]);
        }
    }

    //上传配置中没有上传url，使用上传信息中上传地址
    var $url=layui.$.trim(root.attr('url'));
    $url=$url==''?uploadInfo.url:$url;


    var $config={
        elem: btnUpload,
        url:$url,
        accept:$accept,
        multiple:$multiple,
        done: function (res, index, upload) {
            btnUpload.removeAttr('disabled');
            btnUpload.html(uploadInfo.btn);
            if (res.code == 1) {
                var path = res.data.url==''?res.data.path:res.data.url;
                var parent=btnUpload.parent();
                //显示地址
                var uploadValEle=parent.children('.zz-upload-value');
                if(this.multiple){
                    var uploadVal=layui.$.trim(uploadValEle.val());
                    uploadValEle.val(uploadVal==''?path:uploadVal+','+path);
                }
                else{
                    uploadValEle.val(path);
                }

                if(uploadInfo.uploaded){
                    uploadInfo.uploaded(parent,path,this.multiple);
                }
                if(fun1){
                    fun1(res);
                }
            } else {
                zzError(res.msg, res.wait);
            }
        }
        , choose: function (obj) {
            btnUpload.attr('disabled', 'disabled');
            btnUpload.html('<i class="layui-icon layui-icon-loading layui-anim layui-anim-rotate layui-anim-loop"></i>上传中...');
        }
        , error: function () {
            btnUpload.removeAttr('disabled');
            btnUpload.html('<i class="layui-icon">&#xe67c;</i>上传图片');
            zzError("上传失败");
        }
    };
    //合并配置
    for(var x in config){
        $config[x]=config[x];
    }

    layui.upload.render($config);
};
//根据上传类型，获取上传信息
function zzGetUploadInfo(accept){
    //创建上传按钮
    //创建上传地址输入框
    accept=accept==''?'images':accept;
    var info={};
    if(accept=='video'){
        info={
            url:'?s=/Files/video',
            btn:'<i class="layui-icon">&#xe67c;</i>上传视频'
        }
    }
    else if(accept=='audio'){
        info={
            url:'?s=/Files/video',
            btn:'<i class="layui-icon">&#xe67c;</i>上传音频'
        }
    }
    else if(accept=='file'){
        info={
            url:'?s=/Files/file',
            btn:'<i class="layui-icon">&#xe67c;</i>上传文件'
        }
    }
    else{
        //默认是上传图片
        info={
            url:'?s=/Files/picture',
            btn:'<i class="layui-icon">&#xe67c;</i>上传图片',
            init:function (ele) {
                var show='<div class="zz-upload-pic-show layui-row"></div>';
                ele.append(show);
            },
            uploaded:function (ele,path,multiple) {
                var item=layui.$('<div class="zz-upload-pic-show-item"><img alt="" src="'+path+'"></div>');
                var btn=layui.$('<a class="layui-icon layui-icon-close" title="删除"></a>');
                var show=ele.children('.zz-upload-pic-show');
                item.append(btn);
                //多文件上传
                if(!multiple){
                    show.html('');
                }
                show.append(item);

                btn.click(function () {
                    var domParent = layui.$(this).parent();
                    var uploadVal = domParent.parent().prev();
                    var uploadValArr = uploadVal.val().split(',');
                    uploadValArr.splice(domParent.index(), 1);
                    uploadVal.val(uploadValArr.join(','));
                    domParent.remove();
                })
            }
        }
    }
    return info;
}
layui.$(function () {

    //初始化上传
    layui.$('.zz-upload').each(function () {
        zzUpload(this);
    });
});
