-- -----------------------------------------------------------------
-- 以下为升级至1.5版本
-- -----------------------------------------------------------------

ALTER TABLE `dou_admin_log` CHANGE `user_id` `user_id` MEDIUMINT( 8 ) UNSIGNED NOT NULL DEFAULT  '0';
ALTER TABLE `dou_file` CHANGE `item_id` `item_id` varchar(20) NOT NULL DEFAULT '';
ALTER TABLE `dou_show` CHANGE `type` `type` VARCHAR(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL;
ALTER TABLE `dou_show` ADD `show_text` TEXT NOT NULL DEFAULT '' AFTER `show_img`;

-- 文件系统
CREATE TABLE IF NOT EXISTS `dou_file` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `number` varchar(30) NOT NULL default '',
  `file` varchar(255) NOT NULL default '',
  `module` varchar(20) NOT NULL default '',
  `item_id` mediumint(8) unsigned NOT NULL default '0',
  `type` varchar(20) NOT NULL default '',
  `size` int(10) unsigned NOT NULL default '0',
  `thumb_size` int(10) unsigned NOT NULL default '0',
  `action_time` int(10) unsigned NOT NULL default '0',
  `add_time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 参数设置
DROP TABLE IF EXISTS `dou_parameter`;
CREATE TABLE `dou_parameter` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `lang` varchar(150) NOT NULL DEFAULT '',
  `value` varchar(150) NOT NULL DEFAULT '',
  `cue` varchar(255) NOT NULL DEFAULT '',
  `group` varchar(30) NOT NULL DEFAULT 'system',
  `lock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '50',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 系统设置
DROP TABLE IF EXISTS `dou_config`;
CREATE TABLE `dou_config` (
  `name` varchar(80) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(10) NOT NULL default '',
  `box` varchar(255) NOT NULL default '',
  `tab` varchar(10) NOT NULL default 'main',
  `sort` tinyint(3) unsigned NOT NULL default '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO dou_config VALUES('site_name','DouPHP轻量级企业网站管理系统','text','','main','1');
INSERT INTO dou_config VALUES('site_title','DouPHP轻量级企业网站管理系统','text','','main','2');
INSERT INTO dou_config VALUES('site_keywords','DouPHP,轻量级企业网站管理系统','text','','main','3');
INSERT INTO dou_config VALUES('site_description','DouPHP,轻量级企业网站管理系统','text','','main','4');
INSERT INTO dou_config VALUES('site_logo','logo.png','file','','main','5');
INSERT INTO dou_config VALUES('site_address','福建省漳州市芗城区','text','','main','6');
INSERT INTO dou_config VALUES('site_closed','0','radio','','main','7');
INSERT INTO dou_config VALUES('icp','','text','','main','8');
INSERT INTO dou_config VALUES('net_safe_record','','text','','main','9');
INSERT INTO dou_config VALUES('tel','0596-8888888','text','','main','10');
INSERT INTO dou_config VALUES('fax','0596-6666666','text','','main','11');
INSERT INTO dou_config VALUES('qq','','text','','main','12');
INSERT INTO dou_config VALUES('email','your@domain.com','text','','main','13');
INSERT INTO dou_config VALUES('language','zh_cn','select','','main','14');
INSERT INTO dou_config VALUES('rewrite','1','radio','','main','15');
INSERT INTO dou_config VALUES('sitemap','1','radio','','main','16');
INSERT INTO dou_config VALUES('captcha','1','radio','','main','17');
INSERT INTO dou_config VALUES('stock','0','radio','','main','18');
INSERT INTO dou_config VALUES('input_must_include_chinese','1','radio','','main','19');
INSERT INTO dou_config VALUES('site_favicon','favicon.ico','file','','main','20');
INSERT INTO dou_config VALUES('code','','textarea','','main','21');
INSERT INTO dou_config VALUES('thumb_width','135','text','','display','1');
INSERT INTO dou_config VALUES('thumb_height','135','text','','display','2');
INSERT INTO dou_config VALUES('img_width','','text','','display','3');
INSERT INTO dou_config VALUES('watermark','','text','','display','4');
INSERT INTO dou_config VALUES('price_decimal','2','text','','display','5');
INSERT INTO dou_config VALUES('display','a:4:{s:7:\"article\";s:2:\"10\";s:12:\"home_article\";s:1:\"5\";s:7:\"product\";s:2:\"10\";s:12:\"home_product\";s:1:\"4\";}','array','','display','6');
INSERT INTO dou_config VALUES('defined','a:2:{s:7:\"article\";s:0:\"\";s:7:\"product\";s:0:\"\";}','array','','defined','1');
INSERT INTO dou_config VALUES('mail_service','0','radio','','mail','1');
INSERT INTO dou_config VALUES('mail_host','smtp.domain.com','text','','mail','2');
INSERT INTO dou_config VALUES('mail_port','25','text','','mail','3');
INSERT INTO dou_config VALUES('mail_ssl','0','radio','','mail','4');
INSERT INTO dou_config VALUES('mail_username','','text','','mail','5');
INSERT INTO dou_config VALUES('mail_password','','text','','mail','6');
INSERT INTO dou_config VALUES('mobile_name','DouPHP','text','','mobile','1');
INSERT INTO dou_config VALUES('mobile_title','DouPHP触屏版','text','','mobile','2');
INSERT INTO dou_config VALUES('mobile_keywords','DouPHP,DouPHP触屏版','text','','mobile','3');
INSERT INTO dou_config VALUES('mobile_description','DouPHP,DouPHP触屏版','text','','mobile','4');
INSERT INTO dou_config VALUES('mobile_logo','','file','','mobile','5');
INSERT INTO dou_config VALUES('mobile_subdir_binding','0','radio','','mobile','6');
INSERT INTO dou_config VALUES('mobile_display','a:4:{s:7:\"article\";i:10;s:12:\"home_article\";i:5;s:7:\"product\";i:10;s:12:\"home_product\";i:4;}','array','','mobile','7');
INSERT INTO dou_config VALUES('close_update','0','radio','','developer','1');
INSERT INTO dou_config VALUES('close_douphp_plus','0','radio','','developer','2');
INSERT INTO dou_config VALUES('close_miniprogram','0','radio','','developer','3');
INSERT INTO dou_config VALUES('close_mobile','0','radio','','developer','4');
INSERT INTO dou_config VALUES('update_overwritten_theme','1','radio','','developer','5');
INSERT INTO dou_config VALUES('developer','1','hidden','','','1');
INSERT INTO dou_config VALUES('pure_mode','0','hidden','','','2');
INSERT INTO dou_config VALUES('site_theme','default','hidden','','','3');
INSERT INTO dou_config VALUES('mobile_theme','default','hidden','','','4');
INSERT INTO dou_config VALUES('build_date','1377768032','hidden','','','5');
INSERT INTO dou_config VALUES('update_number','a:6:{s:6:\"update\";s:1:\"0\";s:5:\"patch\";s:1:\"0\";s:6:\"module\";s:1:\"0\";s:6:\"plugin\";s:1:\"0\";s:5:\"theme\";s:1:\"0\";s:6:\"mobile\";N;}','hidden','','','6');
INSERT INTO dou_config VALUES('update_date','a:3:{s:6:\"system\";a:2:{s:6:\"update\";i:20200405;s:5:\"patch\";i:20200405;}s:6:\"module\";a:4:{s:7:\"article\";i:20200405;s:7:\"product\";s:8:\"20200405\";s:3:\"box\";s:8:\"20200405\";s:8:\"fragment\";s:8:\"20200405\";}s:5:\"theme\";a:0:{}}','hidden','','','7');
INSERT INTO dou_config VALUES('cloud_account','','hidden','','','8');
INSERT INTO dou_config VALUES('system_type','company','hidden','','','9');
INSERT INTO dou_config VALUES('hash_code','166d0de32dafdef9ab26e10130dd115b','hidden','','','10');
INSERT INTO dou_config VALUES('douphp_version','v1.5 Release 20200405','hidden','','','11');

